/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpConfigManager;
import com.sonicsw.net.http.HttpRemoteBrokerFactory;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.HTTPDirectOutboundEntry;
import progress.message.broker.HTTPDirectOutboundHolder;
import progress.message.broker.HTTPDirectOutboundProtocolHolder;
import progress.message.gr.RouterManager;
import progress.message.gr.RoutingTargetFactory;
import progress.message.gr.prAccessor;
import progress.message.resources.prMessageFormat;
import progress.message.zclient.DebugObject;

public class HttpOutboundHelper {
    private static final String DEBUG_NAME = "HttpOutboundHelper";
    private static volatile AgentRegistrar s_reg = null;
    private static volatile RouterManager s_rm = null;
    private static final String[] s_HttpProtocol = new String[]{null, "DIRECT", "JMS", "SOAP", "WS"};
    private static final String[] s_HttpFactory = new String[]{null, "com.sonicsw.net.http.direct.DirectHttpRemoteBrokerFactory", "com.sonicsw.net.http.jms.JmsHttpRemoteBrokerFactory", "com.sonicsw.net.http.soap.SoapHttpRemoteBrokerFactory", "com.sonicsw.net.http.ws.WSHttpRemoteBrokerFactory"};
    private static final ThreadLocal<SimpleDateFormat> DATE_PARSER_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy/MM/dd kk:mm:ss");
        }
    };
    private RoutingTargetFactory m_targetFactory = null;

    HttpOutboundHelper(AgentRegistrar reg, RouterManager rm) {
        s_reg = reg;
        s_rm = rm;
    }

    public HttpRemoteBrokerFactory loadHttpRemoteBrokerFactory(String factoryClassName, Properties props, RoutingTargetFactory next) {
        DebugObject.class_debug(DEBUG_NAME, "loadHttpRemoteBrokerFactory for : " + factoryClassName);
        HttpRemoteBrokerFactory httpFactory = null;
        try {
            Class<?> factory = Class.forName(factoryClassName);
            Constructor<?> constructor = factory.getConstructors()[0];
            Object[] args = new Object[]{s_rm, s_reg, props, next};
            httpFactory = (HttpRemoteBrokerFactory)constructor.newInstance(args);
            if (httpFactory == null) {
                return null;
            }
            this.registerConfigManager(httpFactory);
            return httpFactory;
        }
        catch (ClassNotFoundException cnfe) {
            Object[] obj = new Object[]{factoryClassName, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
            String msg = prAccessor.getString("RTFACT_CLASS_NOT_FOUND");
            BrokerComponent.getComponentContext().logMessage(prMessageFormat.format(msg, obj), 2);
            return null;
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            return null;
        }
    }

    public RoutingTargetFactory loadHttpRemoteBrokerFactoryFromDS(RoutingTargetFactory initialFactory) {
        Properties props = new Properties();
        RoutingTargetFactory next = initialFactory;
        HTTPDirectOutboundHolder oh = Broker.getBroker().getHTTPDirectOutboundHolder();
        if (oh != null) {
            props.put("HTTP_OUTBOUND_HOLDER", oh);
            Enumeration enumeration = oh.getHTTPDirectOutboundProtocolHolders();
            while (enumeration.hasMoreElements()) {
                String factoryClassName;
                HttpRemoteBrokerFactory newFac;
                HTTPDirectOutboundProtocolHolder nh = (HTTPDirectOutboundProtocolHolder)enumeration.nextElement();
                if (nh == null || nh.getOutboundFactory() == null || (newFac = this.loadHttpRemoteBrokerFactory(factoryClassName = nh.getOutboundFactory(), props, next)) == null) continue;
                next = newFac;
                DebugObject.class_debug(DEBUG_NAME, "set next Http factory to: " + factoryClassName);
            }
            oh.clear();
        }
        this.setTargetFactory(next);
        return next;
    }

    private void registerConfigManager(HttpRemoteBrokerFactory httpFactory) {
        DebugObject.class_debug(DEBUG_NAME, "registerHttpConfigManager for protocol " + httpFactory.getRouteType());
        Integer routeTypeObject = httpFactory.getRouteType();
        if (!HTTPConfigManagersLazyHolder.HTTP_CONFIG_MANAGERS.containsKey(routeTypeObject)) {
            HTTPConfigManagersLazyHolder.HTTP_CONFIG_MANAGERS.put(routeTypeObject, httpFactory.getConfigManager());
        }
    }

    public RoutingTargetFactory loadHttpRemoteBrokerFactory(int routeType) {
        HTTPDirectOutboundHolder oh = new HTTPDirectOutboundHolder();
        HTTPDirectOutboundProtocolHolder ph = new HTTPDirectOutboundProtocolHolder();
        String directType = s_HttpProtocol[routeType];
        String factoryName = s_HttpFactory[routeType];
        ph.setOutboundProps(directType, factoryName);
        oh.addHTTPDirectOutboundProtocolHolder(ph);
        Properties props = new Properties();
        props.put("HTTP_OUTBOUND_HOLDER", oh);
        DebugObject.class_debug(DEBUG_NAME, "dynamic load factory for protocol: " + directType);
        return this.loadHttpRemoteBrokerFactory(factoryName, props, this.m_targetFactory);
    }

    public HttpConfigManager getHttpConfigManager(int routeType) {
        Integer routeTypeObject = routeType;
        if (!HTTPConfigManagersLazyHolder.HTTP_CONFIG_MANAGERS.containsKey(routeTypeObject)) {
            return null;
        }
        return (HttpConfigManager)HTTPConfigManagersLazyHolder.HTTP_CONFIG_MANAGERS.get(routeTypeObject);
    }

    public void dynamicAddHttpOutboundEntry(HTTPDirectOutboundEntry httpEntry, int routeType) {
        String protocolType = httpEntry.getProtocol();
        DebugObject.class_debug(DEBUG_NAME, "dynamicAddHttpOutboundEntry for protocolType ==> " + protocolType);
        HttpConfigManager httpManager = null;
        if (!HTTPConfigManagersLazyHolder.HTTP_CONFIG_MANAGERS.containsKey(routeType)) {
            DebugObject.class_debug(DEBUG_NAME, "Need to add ConfigManager, contents in the HttpConfigManger table: ");
            Enumeration keys = HTTPConfigManagersLazyHolder.HTTP_CONFIG_MANAGERS.keys();
            while (keys.hasMoreElements()) {
                Integer protocol = (Integer)keys.nextElement();
                DebugObject.class_debug(DEBUG_NAME, "\tprotocol = " + protocol);
            }
            RoutingTargetFactory newFac = this.loadHttpRemoteBrokerFactory(routeType);
            if (newFac != null) {
                this.setTargetFactory(newFac);
            }
        }
        if ((httpManager = this.getHttpConfigManager(routeType)) != null) {
            httpManager.addOutboundEntry(httpEntry);
        }
    }

    public void deleteHttpOutboundEntry(String nodeName, int routeType) {
        HttpConfigManager httpManager = this.getHttpConfigManager(routeType);
        if (httpManager != null) {
            httpManager.removeOutboundEntry(nodeName);
        }
    }

    private void setTargetFactory(RoutingTargetFactory fac) {
        this.m_targetFactory = fac;
        DebugObject.class_debug(DEBUG_NAME, "setTargetFactory to ==> " + fac);
    }

    public RoutingTargetFactory getTargetFactory() {
        return this.m_targetFactory;
    }

    private static class HTTPConfigManagersLazyHolder {
        private static final Hashtable HTTP_CONFIG_MANAGERS = new Hashtable();

        private HTTPConfigManagersLazyHolder() {
        }
    }
}

