/*
 * Decompiled with CFR 0.152.
 */
package progress.message.msg.v24;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import progress.message.msg.IAckHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramDeliveryContext;
import progress.message.msg.v24.AckPayload;
import progress.message.msg.v24.DefaultDynamicHeader;
import progress.message.msg.v24.DefaultPayload;
import progress.message.msg.v24.ErrorPayload;
import progress.message.msg.v24.FlowControlPayload;
import progress.message.msg.v24.Mgram;
import progress.message.msg.v24.NackPayload;
import progress.message.msg.v24.Payload;
import progress.message.msg.v24.QueueFlowControlPayload;
import progress.message.msg.v24.StaticHeader;
import progress.message.util.ArrayUtil;
import progress.message.util.EAssertFailure;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.prAccessor;

public class MgramCreator
implements IMgramConverter {
    private static Mgram m_ackMgram = null;
    private static Mgram m_guarAckMgram = null;
    private static Mgram m_pingRequest = null;
    private static Mgram m_pingReply = null;
    private static Mgram m_flowControl = null;
    private static int TXN_REQUEST_BODY_LENGTH = 18;
    private byte[] m_buffer = null;
    private ISecureInputStream m_sis = null;
    private ClientSecurityContext m_csc = null;
    private IMessageProtection m_mp = null;
    private IMgramStatusListener m_listener = null;
    private boolean m_isTTEttlConvert = false;

    @Override
    public void initializeConverter(Hashtable properties) {
        this.m_csc = (ClientSecurityContext)properties.get(MgramConstants.CLIENT_SECURITY_CONTEXT);
        this.m_sis = (ISecureInputStream)properties.get(MgramConstants.SECURE_INPUT_STREAM);
        this.m_mp = (IMessageProtection)properties.get(MgramConstants.MESSAGE_PROTECTION);
        this.m_listener = (IMgramStatusListener)properties.get(MgramConstants.MGRAM_STATUS_LISTENER);
        Boolean tteTTL = (Boolean)properties.get(MgramConstants.TTE_TTL_CONVERT);
        if (tteTTL != null) {
            this.m_isTTEttlConvert = tteTTL;
        }
    }

    @Override
    public IMgram createMgram(InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return Mgram.createMgram(is, this.m_buffer, this.m_sis, this.m_mp, this.m_csc, this.m_isTTEttlConvert);
    }

    @Override
    public IMgram createMgram(byte version, InputStream is) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return null;
    }

    @Override
    public void secureDeliver(IMgram m, int channel, ClientSecurityContext csc, OutputStream os, MgramDeliveryContext ctx) throws IOException {
    }

    @Override
    public void deliver(IMgram m, int channel, OutputStream os, MgramDeliveryContext ctx) throws IOException {
    }

    @Override
    public void deliver(IMgram m, OutputStream os) throws IOException {
    }

    public IMgram unserialize(InputStream di) {
        return null;
    }

    @Override
    public IMgram unserialize(InputStream di, boolean tteTTLConvert) {
        return null;
    }

    public void writeMgramToStreamNonSecure(OutputStream os, IMgram m, boolean tteTTLConvert) throws IOException {
    }

    @Override
    public void serialize(OutputStream os, IMgram m, boolean tteTTLConvert) throws IOException {
    }

    public IMgram createMgram(byte[] data) throws IOException, EMgramVersionMismatch, EMgramFormatError {
        return new Mgram(data);
    }

    public IMgram createMgram(boolean initialize) {
        return new Mgram(initialize);
    }

    public static IMgram buildAck(long tracking, long clientID, short err, int channel) {
        return MgramCreator.buildAck(tracking, clientID, err, false, 0L, false, 0, channel);
    }

    public static IMgram buildAck(long msgTracking, long clientID, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        IMgram ack = MgramCreator.buildGuarenteedAck(guaranteed);
        ack.setChannel(channel);
        if (guaranteed) {
            ack.setGuarenteed(ackTracking);
        }
        if (txn) {
            ack.setTxn(tid);
        }
        IAckHandle handle = ack.getAckHandle();
        handle.setTrackingNumber(msgTracking);
        handle.setErr(err);
        handle.setClientID(clientID);
        ack.sync();
        return ack;
    }

    public IMgram buildQAck(long msgTracking, long clientID, short err, boolean guaranteed, long ackTracking, boolean txn, int tid, int channel) {
        IMgram ack = MgramCreator.buildGuarenteedAck(guaranteed);
        ack.setType((byte)14);
        ack.setChannel(channel);
        if (guaranteed) {
            ack.setGuarenteed(ackTracking);
        }
        if (txn) {
            ack.setTxn(tid);
        }
        IAckHandle handle = ack.getAckHandle();
        handle.setTrackingNumber(msgTracking);
        handle.setErr(err);
        handle.setClientID(clientID);
        ack.sync();
        return ack;
    }

    private static IMgram buildGuarenteedAck(boolean guaranteed) {
        IMgram ack = null;
        if (guaranteed) {
            try {
                ack = (IMgram)m_guarAckMgram.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        } else {
            try {
                ack = (IMgram)m_ackMgram.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return ack;
    }

    public IMgram buildPingRequest(byte[] payload, int channel) {
        IMgram ping = null;
        try {
            ping = (IMgram)m_pingRequest.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        ping.setChannel(channel);
        ping.setBody(payload);
        ping.sync();
        return ping;
    }

    public IMgram buildPingReply(IMgram m) {
        IMgram ping = null;
        try {
            ping = (IMgram)m_pingReply.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        ping.setChannel(m.getChannel());
        ping.setBody(m.getRawBody());
        ping.sync();
        return ping;
    }

    public IMgram buildDisconnectRequest(int channel, boolean forceDisconnect) {
        Mgram disconnect = new Mgram(true);
        disconnect.setType((byte)7);
        disconnect.setPriority((byte)0);
        disconnect.setRequestReplyType(2);
        disconnect.setChannel(channel);
        disconnect.setReplyToAddressFormat(0);
        byte[] body = new byte[]{(byte)(forceDisconnect ? 1 : 0)};
        disconnect.setBody(body);
        disconnect.sync();
        return disconnect;
    }

    public IMgram buildFlowControlMgram(byte minPriority, int channel) {
        IMgram flowControl = null;
        try {
            flowControl = (IMgram)m_flowControl.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        flowControl.getFlowControlHandle().setMinPriority(minPriority);
        flowControl.setChannel(channel);
        flowControl.sync();
        return flowControl;
    }

    public IMgram buildVersionMgram(int channel, byte version) {
        Mgram versionMgram = new Mgram(true);
        versionMgram.setType((byte)4);
        versionMgram.setVersion(version);
        versionMgram.setChannel(channel);
        versionMgram.setPostV22();
        versionMgram.sync();
        return versionMgram;
    }

    public IMgram buildVersionMgram(int channel, byte version, byte sessionVer) {
        Mgram versionMgram = new Mgram(true);
        versionMgram.setType((byte)4);
        versionMgram.setVersion(version);
        versionMgram.setChannel(channel);
        versionMgram.setPostV22();
        versionMgram.setSessionVer(sessionVer);
        versionMgram.sync();
        return versionMgram;
    }

    public IMgram buildConnectMgram(byte[] payload, int channel) {
        Mgram connectMgram = new Mgram(true);
        connectMgram.setType((byte)1);
        connectMgram.setRequestReplyType(0);
        connectMgram.setChannel(channel);
        connectMgram.setBody(payload);
        connectMgram.sync();
        return connectMgram;
    }

    public IMgram buildErrorMgram(int errcode, int errinfo, IMgram m, int channel) {
        Mgram error = MgramCreator.createMgram();
        error.setPayload(new ErrorPayload(error));
        if (m != null && m.hasID()) {
            error.setID(m.getID());
        }
        error.setType((byte)-1);
        error.setChannel(channel);
        error.getErrorHandle().setErrCode(errcode);
        error.getErrorHandle().setErrInfo(errinfo);
        error.sync();
        return error;
    }

    public IMgram buildCommitTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public IMgram buildNoDupCommitTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel, String transactionId, long lifespan) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public IMgram buildNoDupChannelCommitTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel, String transactionId, long lifespan, int channelStatus, String channelID) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public IMgram buildBeginTxnRequest(boolean xo, int tracking, long clientId, int channel) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public IMgram buildAbortTxnRequest(boolean xo, boolean chained, int tid, int tracking, long clientId, int channel) {
        throw new EAssertFailure(prAccessor.getString("INVALID_OPERATION"));
    }

    public IMgram buildTxnRequest(boolean chained, int tid, int tracking, long clientId, int channel) {
        Mgram txnRequest = new Mgram(true);
        txnRequest.setType((byte)8);
        txnRequest.setRequestReplyType(0);
        txnRequest.setPriority((byte)0);
        txnRequest.setChannel(channel);
        byte[] body = new byte[TXN_REQUEST_BODY_LENGTH];
        int p = 0;
        ArrayUtil.writeShort(body, p, (short)(chained ? 1 : 0));
        ArrayUtil.writeInt(body, p += 2, tracking);
        ArrayUtil.writeInt(body, p += 4, tid);
        ArrayUtil.writeLong(body, p += 4, clientId);
        txnRequest.setBody(body);
        txnRequest.sync();
        return txnRequest;
    }

    public static Payload getPayloadObject(byte type, Mgram m) {
        Payload result;
        switch (type) {
            case 4: {
                return null;
            }
            case 18: 
            case 19: {
                result = new QueueFlowControlPayload(m);
                break;
            }
            case 6: {
                result = new FlowControlPayload(m);
                break;
            }
            case 3: 
            case 14: {
                result = new AckPayload(m);
                break;
            }
            case 20: {
                result = new NackPayload(m);
                break;
            }
            case -1: {
                result = new ErrorPayload(m);
                break;
            }
            default: {
                result = null;
            }
        }
        if (result == null) {
            result = new DefaultPayload(m);
        }
        return result;
    }

    @Override
    public byte getVersion() {
        return 24;
    }

    private static Mgram createMgram() {
        Mgram m_pingRequest = new Mgram(false);
        m_pingRequest.setStaticHeader(new StaticHeader());
        m_pingRequest.setDynamicHeader(new DefaultDynamicHeader(m_pingRequest));
        return m_pingRequest;
    }

    private static Mgram createAndPopulateMgram() {
        Mgram m_pingReply = MgramCreator.createMgram();
        DefaultPayload payload = new DefaultPayload(m_pingReply);
        payload.setReplyToAddressFormat(0);
        m_pingReply.setPayload(payload);
        m_pingReply.setType((byte)0);
        m_pingReply.setPriority((byte)12);
        return m_pingReply;
    }

    static {
        m_ackMgram = MgramCreator.createMgram();
        m_ackMgram.setPayload(new AckPayload(m_ackMgram));
        m_ackMgram.setType((byte)3);
        m_ackMgram.setPriority((byte)11);
        m_ackMgram.sync();
        m_guarAckMgram = MgramCreator.createMgram();
        m_guarAckMgram.setPayload(new AckPayload(m_guarAckMgram));
        m_guarAckMgram.setGuarenteed(0L);
        m_guarAckMgram.setType((byte)3);
        m_guarAckMgram.setPriority((byte)11);
        m_guarAckMgram.sync();
        m_pingRequest = MgramCreator.createAndPopulateMgram();
        m_pingRequest.setRequestReplyType(2);
        m_pingRequest.sync();
        m_pingReply = MgramCreator.createAndPopulateMgram();
        m_pingReply.setRequestReplyType(3);
        m_pingReply.sync();
        m_flowControl = MgramCreator.createMgram();
        m_flowControl.setPayload(new FlowControlPayload(m_flowControl));
        m_flowControl.setType((byte)6);
        m_flowControl.setPriority((byte)12);
        m_flowControl.setRequestReplyType(0);
        m_flowControl.sync();
    }
}

