/*
 * Decompiled with CFR 0.152.
 */
package progress.message.util.server;

import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.TreeMap;

public class ReOrderBuffer {
    private TreeMap m_buffer = null;
    private final long m_maxSize;
    private long m_count = 0L;
    private long m_size = 0L;
    private long m_next = 1L;
    private DiscardListener m_listener = null;
    private BufferConditionListener m_conditionListener = null;

    public ReOrderBuffer(int maxSize, long firstSeqNum, DiscardListener listener, BufferConditionListener conditionListener) {
        this.m_maxSize = maxSize;
        this.m_next = firstSeqNum;
        this.m_buffer = new TreeMap();
        this.m_listener = listener;
        this.m_conditionListener = conditionListener;
    }

    public ReOrderBuffer(int maxSize) {
        this(maxSize, 1L, null, null);
    }

    public boolean buffer(Object obj, long seqNum, int size) {
        Entry item = new Entry(seqNum, obj, size);
        if (this.m_buffer.containsKey(item)) {
            return true;
        }
        if (!this.hasRoom(size) && !this.makeRoom(seqNum, size)) {
            if (this.m_conditionListener != null) {
                this.m_conditionListener.bufferFull(obj);
            }
            return false;
        }
        this.m_size += (long)size;
        ++this.m_count;
        this.m_buffer.put(item, item);
        if (this.m_conditionListener != null) {
            this.m_conditionListener.bufferAvailable();
        }
        return true;
    }

    public void rebuffer(Object obj, long seqNum, int size) throws IllegalStateException {
        if (seqNum != this.m_next - 1L) {
            throw new IllegalStateException("Only the last removed object may be rebuffered");
        }
        --this.m_next;
        this.buffer(obj, seqNum, size);
    }

    public long getSize() {
        return this.m_size;
    }

    public long getCount() {
        return this.m_count;
    }

    public long getNextSequenceNumber() {
        return this.m_next;
    }

    public boolean available() {
        if (this.m_buffer.isEmpty()) {
            return false;
        }
        Object first = this.m_buffer.firstKey();
        return ((Entry)first).getSequenceNum() == this.m_next;
    }

    public Object remove() throws NoSuchElementException, IllegalStateException {
        Entry next = (Entry)this.m_buffer.firstKey();
        if (next.getSequenceNum() != this.m_next) {
            throw new IllegalStateException("Next object in sequence not available");
        }
        this.m_buffer.remove(next);
        this.m_size -= (long)next.getSize();
        ++this.m_next;
        --this.m_count;
        return next.getObject();
    }

    public void clearTo(long newnext) {
        try {
            Entry next = (Entry)this.m_buffer.firstKey();
            while (next.getSequenceNum() < newnext) {
                this.m_buffer.remove(next);
                this.m_size -= (long)next.getSize();
                next = (Entry)this.m_buffer.firstKey();
                --this.m_count;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.m_next = newnext;
    }

    private final boolean hasRoom(int size) {
        return this.m_size + (long)size <= this.m_maxSize;
    }

    private final boolean makeRoom(long seqNum, int neededSize) {
        int discardableSize;
        Entry last;
        if ((long)neededSize > this.m_maxSize) {
            return false;
        }
        Stack<Entry> stack = new Stack<Entry>();
        for (discardableSize = 0; discardableSize < neededSize; discardableSize += last.getSize()) {
            last = (Entry)this.m_buffer.lastKey();
            if (last.getSequenceNum() <= seqNum) {
                while (!stack.isEmpty()) {
                    Object entry = stack.pop();
                    this.m_buffer.put(entry, entry);
                }
                return false;
            }
            this.m_buffer.remove(last);
            stack.push(last);
        }
        this.m_size -= (long)stack.size();
        if (this.m_listener != null) {
            while (!stack.isEmpty()) {
                Entry entry = (Entry)stack.pop();
                this.m_listener.objectDiscarded(entry.getObject(), entry.getSequenceNum(), entry.getSize());
            }
        }
        this.m_size -= (long)discardableSize;
        return true;
    }

    public void setConditionListener(BufferConditionListener l) {
        this.m_conditionListener = l;
    }

    public BufferConditionListener getConditionListener() {
        return this.m_conditionListener;
    }

    private static final class Entry
    implements Comparable {
        private final long m_seqNum;
        private final Object m_obj;
        private final int m_size;

        Entry(long seqNum, Object obj, int size) {
            this.m_obj = obj;
            this.m_seqNum = seqNum;
            this.m_size = size;
        }

        final long getSequenceNum() {
            return this.m_seqNum;
        }

        final int getSize() {
            return this.m_size;
        }

        final Object getObject() {
            return this.m_obj;
        }

        public final int compareTo(Object obj) {
            if (this.m_seqNum < ((Entry)obj).m_seqNum) {
                return -1;
            }
            if (this.m_seqNum > ((Entry)obj).m_seqNum) {
                return 1;
            }
            return 0;
        }
    }

    public static interface BufferConditionListener {
        public void bufferFull(Object var1);

        public void bufferAvailable();
    }

    public static interface DiscardListener {
        public void objectDiscarded(Object var1, long var2, int var4);
    }
}

