/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mq.components;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mq.components.AttributesHolder;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.ConfigPropertiesPopulator;
import com.sonicsw.mq.components.ConfigurationChangeBindHelper;
import com.sonicsw.mq.components.prAccessor;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.FTPairPeerInfoHolder;
import progress.message.db.EDatabaseException;
import progress.message.interbroker.IBConfigBean;
import progress.message.interbroker.Interbroker;

public class ClusterPeerUpdateChangeHandler
implements IAttributeChangeHandler {
    private String m_clusterName;
    private ConfigurationChangeBindHelper m_bindHelper;
    private static volatile String m_brokerName;
    private HashMap m_brokerNames;
    private boolean TRACE = false;
    private static volatile IComponentContext s_context;
    private static volatile Broker s_broker;
    private static volatile AttributesHolder s_attributesHolder;
    private static final Object DOUBLE_CHECK_LOCK_OBJ;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(IComponentContext context, Broker broker, AttributesHolder attributesHolder) {
        Object object;
        if (s_context == null) {
            object = DOUBLE_CHECK_LOCK_OBJ;
            synchronized (object) {
                if (s_context == null) {
                    s_context = context;
                }
            }
        }
        if (s_broker == null) {
            object = DOUBLE_CHECK_LOCK_OBJ;
            synchronized (object) {
                if (s_broker == null) {
                    s_broker = broker;
                }
            }
        }
        if (s_attributesHolder == null) {
            object = DOUBLE_CHECK_LOCK_OBJ;
            synchronized (object) {
                if (s_attributesHolder == null) {
                    s_attributesHolder = attributesHolder;
                }
            }
        }
    }

    public ClusterPeerUpdateChangeHandler(ConfigurationChangeBindHelper bindHelper, String clusterName, HashMap brokerNameMap) {
        this.m_bindHelper = bindHelper;
        this.m_clusterName = clusterName;
        m_brokerName = BrokerComponent.getBrokerComponent().getBrokerName();
        this.m_brokerNames = brokerNameMap;
    }

    public void itemDeleted() {
    }

    public synchronized void itemModified(Object newValue) {
        if (s_broker == null || s_attributesHolder == null) {
            return;
        }
        if (newValue == null) {
            return;
        }
        IDeltaAttributeSet delta = (IDeltaAttributeSet)newValue;
        String clusterName = AgentRegistrar.getAgentRegistrar().getCollective();
        String[] removedClusterMembers = delta.getDeletedAttributesNames();
        boolean isBrokerStillInCluster = true;
        if (removedClusterMembers.length > 0) {
            boolean bl = isBrokerStillInCluster = !this.handleRemovedClusterMembers(removedClusterMembers, clusterName);
        }
        if (!isBrokerStillInCluster) {
            String msg = MessageFormat.format(prAccessor.getString("BROKER_REMOVED_FROM_CLUSTER"), m_brokerName);
            s_context.logMessage(msg, 2);
            return;
        }
        String[] newClusterMembers = delta.getNewAttributesNames();
        if (newClusterMembers.length > 0) {
            this.handleNewClusterMembers(delta, newClusterMembers, clusterName);
        }
    }

    private void handleNewClusterMembers(IDeltaAttributeSet delta, String[] newClusterMembers, String clusterName) {
        IBConfigBean configBean = Interbroker.getInterbroker().getConfigConnectionMgr().getConfigBean();
        String brokerName = null;
        for (int i = 0; i < newClusterMembers.length; ++i) {
            String attributeName = newClusterMembers[i];
            brokerName = null;
            try {
                Object obj = delta.getNewValue(attributeName);
                Reference peerRef = (Reference)obj;
                String peerCID = peerRef.getElementName();
                IElement peerConfigElem = s_context.getConfiguration(peerCID, true);
                IAttributeSet peerDefaultAS = peerConfigElem.getAttributes();
                brokerName = (String)peerDefaultAS.getAttribute("BROKER_NAME");
                this.m_brokerNames.put(attributeName, brokerName);
                IElement primarybce = peerConfigElem;
                FTPairPeerInfoHolder holder = ConfigPropertiesPopulator.getFTPairPeerInfoHolder(s_context, brokerName, primarybce);
                Hashtable<String, FTPairPeerInfoHolder> peerInfoTable = BrokerComponent.getBrokerComponent().getPeerInfoTable();
                if (peerInfoTable != null) {
                    peerInfoTable.remove(brokerName);
                }
                if (holder != null) {
                    if (peerInfoTable == null) {
                        peerInfoTable = new Hashtable<String, FTPairPeerInfoHolder>();
                        BrokerComponent.getBrokerComponent().setPeerInfoTable(peerInfoTable);
                    }
                    peerInfoTable.put(brokerName, holder);
                }
                try {
                    configBean.newBroker(brokerName, holder);
                    configBean.addBroker(clusterName, brokerName);
                }
                catch (EDatabaseException eDatabaseException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.m_bindHelper.bindBrokerAcceptorChangeDelegator(brokerName, primarybce);
                continue;
            }
            catch (NotModifiedAttException nmae) {
                if (!this.TRACE) continue;
                System.out.println("ClusterPeerUpdateChangeHandler.addNewClusterMembers: exception msg = " + nmae.getMessage() + ", broker " + brokerName + " not added to cluster " + clusterName);
            }
        }
    }

    private boolean handleRemovedClusterMembers(String[] removedClusterMembers, String clusterName) {
        boolean isThisBrokerRemovedFromCluster = false;
        for (int i = 0; i < removedClusterMembers.length; ++i) {
            String attributeName = removedClusterMembers[i];
            String brokerName = (String)this.m_brokerNames.remove(attributeName);
            if (brokerName == null) continue;
            try {
                Interbroker.getInterbroker().getConfigConnectionMgr().getConfigBean().removeBroker(clusterName, brokerName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (brokerName.equals(m_brokerName)) {
                isThisBrokerRemovedFromCluster = true;
                this.m_bindHelper.unbindNonLocalBrokerAcceptorChangeDelegators();
                continue;
            }
            this.m_bindHelper.unbindBrokerAcceptorChangeDelegator(brokerName);
        }
        return isThisBrokerRemovedFromCluster;
    }

    static {
        DOUBLE_CHECK_LOCK_OBJ = new Object();
    }
}

