/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.net.http;

public class HttpConstants {
    public static final int HTTP_OK = 200;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_FILE_NOT_FOUND = 404;
    public static final int HTTP_TIMEOUT = 408;
    public static final int HTTP_REQUEST_TOO_LARGE = 413;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_NOT_SUPPORTED = 501;
    public static final int HTTP_SERVICE_UNAVAILABLE = 503;
    public static final int HTTP_JMS_QUEUE_NOT_FOUND = 505;
    public static final int HTTP_URL_MAPPING_ERROR = 506;
    public static final int HTTP_FLOW_CONTROL = 507;
    public static final int HTTP_GENERAL_ERROR = 610;
    public static final int HTTP_HOST_UNREACHABLE = 611;
    public static final int HTTP_INVALID_REPLYTO_USER = 612;
    public static final int HTTP_INVALID_JMS_MESSAGE_TYPE = 613;
    public static final int HTTP_INVALID_URL = 614;
    public static final int HTTP_INVALID_SOAP_CONTENT = 615;
    public static final int HTTP_AXIS_ERROR = 616;
    public static final String HTTP_URL_PREFIX = "http:";
    public static final String HTTPS_URL_PREFIX = "https:";
    public static final String SONICFS_URL_PREFIX = "sonicfs:";
    public static final String SONIC_URL_PREFIX = "sonic:";
    public static final String JNDI_URL_PREFIX = "jndi:";
    public static final String AUTHORIZATION = "Authorization";
    public static final String AUTH_BASIC = "Basic";
    public static final String SONICMQ_AUTH_REALM = "SonicMQ Broker HTTP(S) Authentication Realm";
    public static final String AUTH_SONIC = "Sonic";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_ID = "Content-ID";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String DEFAULT_CHAR_ENCODING = "ISO-8859-1";
    public static final String ATT_CHAR_ENCODING = "charset";
    public static final String ATT_BOUNDARY = "boundary";
    public static final String CHUNKED = "chunked";
    public static final String CONTENT_TEXT_PLAIN = "text/plain";
    public static final String CONTENT_TEXT_XML = "text/xml";
    public static final String CONTENT_TEXT = "text/";
    public static final String CONTENT_MULTIPART = "Multipart/Related";
    public static final String CONTENT_APPLIC_OCTET = "application/octet-stream";
    public static final String CONTENT_APPLIC = "application/";
    public static final String DELIV_MODE_PERSISTENT = "PERSISTENT";
    public static final String DELIV_MODE_NON_PERSISTENT = "NON_PERSISTENT";
    public static final String DELIV_MODE_NON_PERSISTENT_REPLICATED = "NON_PERSISTENT_REPLICATED";
    public static final String DELIV_MODE_DISCARDABLE = "DISCARDABLE";
    public static final String MESSAGE_TYPE_TEXT = "TEXT";
    public static final String MESSAGE_TYPE_XML = "XML";
    public static final String MESSAGE_TYPE_BYTES = "BYTES";
    public static final String MESSAGE_TYPE_MULTIPART = "MULTIPART";
    public static final String MESSAGE_TYPE_MESSAGE = "MESSAGE";
    public static final String NOTIFY_UNDELIVERED = "JMS_SonicMQ_notifyUndelivered";
    public static final String PRESERVE_UNDELIVERED = "JMS_SonicMQ_preserveUndelivered";
    public static final String DESTINATION_UNDELIVERED = "JMS_SonicMQ_destinationUndelivered";
    public static final String GROUP_ID = "JMSXGroupID";
    public static final String GROUP_SEQ = "JMSXGroupSeq";
    public static final String USER_ID = "JMSXUserID";
    public static final String LAST_MESSAGE_IN_GROUP = "JMS_SonicMQ_lastMessageInGroup";
    public static final String DESTINATION_URL = "X-HTTP-DestinationURL";
    public static final String OUTBOUND_GROUP_ID = "X-HTTP-GroupID";
    public static final String REQUEST_TIMEOUT = "X-HTTP-RequestTimeout";
    public static final String RETRIES = "X-HTTP-Retries";
    public static final String RETRY_INTERVAL = "X-HTTP-RetryInterval";
    public static final String HTTP_AUTH_USER = "X-HTTP-AuthUser";
    public static final String HTTP_AUTH_PASSWORD = "X-HTTP-AuthPassword";
    public static final String HTTP_RESPONSE_CODE = "X-HTTP-ResponseCode";
    public static final String HTTP_RESPONSE_MESSAGE = "X-HTTP-ResponseMessage";
    public static final String HTTP_CONTENT_LENGTH = "X-HTTP-ContentLength";
    public static final String HTTP_REPLY_AS_SOAP = "X-HTTP-ReplyAsSOAP";
    public static final String RECEIVE_URL = "X-HTTP-ReceiveURL";
    public static final String REQUEST_METHOD = "X-HTTP-RequestMethod";
    public static final String HTTP_SOAP_VERSION = "X-HTTP-SOAPVersion";
    public static final String MAPPED_URL = "X-HTTP-MappedURL";
    public static final String USER_AGENT_ADDRESS = "X-HTTP-UserAgentAddrress";
    public static final String HTTPS_CERTIFICATE_DN = "X-HTTPS-CertificateDN";
    public static final String HTTPS_CERTIFICATE_CN = "X-HTTPS-CertificateCN";
    public static final String HTTPS_CA_CERTIFICATE_DN = "X-HTTPS-CACertificateDN";
    public static final String HTTPS_WS_BINDING_CIPHER_SUITE = "X-HTTPS-WS-BindingCipherSuite";
    public static final String HTTPS_PROPERTY_PREFIX = "X-HTTPS-";
    public static final String HTTPS_CIPHER_SUITES = "X-HTTPS-CipherSuites";
    public static final String HTTPS_CLIENT_AUTH_CERTIFICATE = "X-HTTPS-ClientAuthCertificate";
    public static final String HTTPS_CLIENT_AUTH_CERTIFICATE_FORM = "X-HTTPS-ClientAuthCertificateForm";
    public static final String HTTPS_PRIVATE_KEY = "X-HTTPS-PrivateKey";
    public static final String HTTPS_PRIVATE_KEY_PASSWORD = "X-HTTPS-PrivateKeyPassword";
    public static final String HTTPS_PRIVATE_KEY_FORM = "X-HTTPS-PrivateKeyForm";
    public static final String HTTPS_CA_CERTIFICATE_PATH = "X-HTTPS-CACertificatePath";
    public static final String HTTPS_CLIENT_KEY_STORE_URL = "X-HTTPS-ClientKeyStoreURL";
    public static final String HTTPS_CLIENT_KEY_STORE_TYPE = "X-HTTPS-ClientKeyStoreType";
    public static final String HTTPS_CLIENT_KEY_STORE_PASSWORD = "X-HTTPS-ClientKeyStorePassword";
    public static final String HTTPS_CLIENT_KEY_ALIAS = "X-HTTPS-ClientKeyAlias";
    public static final String HTTPS_CLIENT_KEY_PASSWORD = "X-HTTPS-ClientKeyPassword";
    public static final String HTTPS_CLIENT_TRUST_STORE_URL = "X-HTTPS-ClientTrustStoreURL";
    public static final String HTTPS_CLIENT_TRUST_STORE_TYPE = "X-HTTPS-ClientTrustStoreType";
    public static final String HTTPS_CLIENT_TRUST_STORE_PASSWORD = "X-HTTPS-ClientTrustStorePassword";
    public static final String WS_SuppressWSAHeaders = "X-WS-SuppressWSAHeaders";
    public static final String WS_ReturnGroupID = "X-WS-ReturnGroupID";
    public static final String WS_RM_Version = "X-WS-RMVersion";
    public static final String WS_MessagePolicy = "X-WS-MessagePolicy";
    public static final String WS_MessagePolicyOut = "X-WS-MessagePolicy-Out";
    public static final String WS_MessagePolicyFault = "X-WS-MessagePolicy-Fault";
    public static final String WS_TransportAcceptor = "X-WS-TransportAcceptor";
    public static final String WS_MessageExchangeCorrelator = "X-WS-MessageExchangeCorrelator";
    public static final String WS_SequenceFaultDestination = "X-WS-SequenceFaultDestination";
    public static final String WS_SECURITY_USERS = "X-WS-SECURITY-USERS";
    public static final String WS_SECURITY_SIGNERS = "X-WS-SECURITY-SIGNERS";
    public static final String WS_UT_Username = "X-WS-UT-Username";
    public static final String WS_UT_Password = "X-WS-UT-Password";
    private static final String WS_ENCRYPTION_ASSERTION_PREFIX = "X-WS-ENC";
    private static final String WS_MessagePartsDialect = "MessagePartsDialect";
    private static final String WS_MessageParts = "MessageParts";
    private static final String WS_AlgEncryption = "AlgEncryption";
    private static final String WS_KeyInfo = "KeyInfo";
    private static final String WS_X509TokenRef = "X509TokenRef";
    private static final String WS_X509TokenRefURI = "X509TokenRefURI";
    private static final String WS_X509TokenRefIssuer = "X509TokenRefIssuer";
    private static final String WS_X509TokenRefSerialNumber = "X509TokenRefSerialNumber";
    public static final String WS_SIGNATURE_ASSERTION_PREFIX = "X-WS-DSIG";
    public static final String WS_AlgCanonicalization = "AlgCanonicalization";
    public static final String WS_AlgSignature = "AlgSignature";
    public static final String WS_AlgTransform = "AlgTransform";
    public static final String WS_AlgDigest = "AlgDigest";
    public static final String WS_X509TokenAlias = "X509TokenAlias";
    public static final String WS_X509TokenPrivateKeyPassword = "X509TokenPrivateKeyPassword";
    public static final String CONFIG_DELIVERY_MODE = "DeliveryMode";
    public static final String CONFIG_TIMEOUT = "Timeout";
    public static final String CONFIG_RETRIES = "Retries";
    public static final String CONFIG_RETRY_INTERVAL = "RetryInterval";
    public static final String CONFIG_REQUEST_MODE = "RequestMode";
    public static final String CONFIG_ONEWAY_TIMEOUT = "OnewayTimeout";
    public static final String CONFIG_ONEWAY_RETRIES = "OnewayRetries";
    public static final String CONFIG_CONTENT_REPLY_TIMEOUT = "ContentReplyTimeout";
    public static final String CONFIG_CONTENT_REPLY_RETRIES = "ContentReplyRetries";
    public static final String CONFIG_REQUEST_MODE_ONEWAY = "Oneway";
    public static final String CONFIG_REQUEST_MODE_CONTENTREPLY = "ContentReply";
    public static final String CONFIG_REQUEST_MODE_RECEIVE = "Receive";
    public static final String CONFIG_CONTENT_REPLY_USER = "ContentReplyUser";
    public static final String CONFIG_CONTENT_MAP = "ContentTypeMap";
    public static final String CONFIG_CONTENT_MAP_TAG = "Map";
    public static final String CONFIG_HTTP_CONTENT_MAP_ATT = "ContentType";
    public static final String CONFIG_JMS_CONTENT_MAP_ATT = "MessageType";
    public static final String CONFIG_CONTENT_MAP_WILDCARD = "*/*";
    public static final String CONFIG_REQUEST_MODE_WS = "WS";
    public static final String DEFAULT_REQUEST_MODE = "Oneway";
    public static final int DEFAULT_OUTBOUND_ONEWAY_TIMEOUT = 30;
    public static final int MINIMUM_OUTBOUND_ONEWAY_TIMEOUT = 10;
    public static final int DEFAULT_INBOUND_CONTENT_REPLY_TIMEOUT = 60;
    public static final int MINIMUM_INBOUND_CONTENT_REPLY_TIMEOUT = 10;
    public static final int DEFAULT_INBOUND_RECEIVE_TIMEOUT = 3;
    public static final int MINIMUM_INBOUND_RECEIVE_TIMEOUT = 1;
    public static final int DEFAULT_OUTBOUND_CONTENT_REPLY_TIMEOUT = 60;
    public static final int MINIMUM_OUTBOUND_CONTENT_REPLY_TIMEOUT = 10;
    public static final int DEFAULT_OUTBOUND_RETRIES = 0;
    public static final int DEFAULT_OUTBOUND_RETRY_INTERVAL = 3;
    public static final int MINIMUM_OUTBOUND_RETRY_INTERVAL = 1;
    public static final String KEY_HTTP_INBOUND_HOLDER = "HTTP_INBOUND_HOLDER";
    public static final String KEY_HTTP_OUTBOUND_HOLDER = "HTTP_OUTBOUND_HOLDER";
    public static final String HTTP_DEFAULT_USER = "HTTP_DEFAULT_USER";
    public static final boolean DEBUG_INTERNAL = false;
    static boolean DEBUG = false;
    public static final int DEBUG_DEFAULT = 0;
    public static final int DEBUG_VERBOSE = 1;
    public static int DEBUG_LEVEL = 1;
    public static final String CONFIGURATION_KEY = "HTTP_CONFIGURATION_DECRYPT_PASSWORD";
    public static final String CONFIGURATION_URL = "HTTP_CONFIGURATION_URL";
    public static final String CONFIGURATION_READER = "HTTP_CONFIGURATION_READER";
    public static final String CONFIGURATION_USER = "HTTP_CONFIGURATION_USER";
    public static final String CONFIGURATION_PASSWORD = "HTTP_CONFIGURATION_PASSWORD";
    public static final String CONFIGURATION_DOMAIN = "HTTP_CONFIGURATION_DOMAIN";
    public static final String INBOUND = "INBOUND";
    public static final String OUTBOUND = "OUTBOUND";
    public static final char SONIC_COLON = '\u00ff';
    public static final String DESTINATION_TYPE_SONIC_PREFIX = "SONIC://";
    public static final String DESTINATION_TYPE_JNDI_PREFIX = "JNDI://";
    public static final String DESTINATION_TYPE_SONICFS_PREFIX = "SONICFS://";
    public static final String ESB_SERVICE_ENTRY = "/Entry";
    public static final String ESB_SERVICE_WSDL = "/WSDL_URL";
    public static final String SONIC_ESB_DOMAIN = "/SonicESB";
    public static final String JNDI_CONTEXT_PREFIX = "/_MFContext/";
    public static final String TEMP_TOPIC_PREFIX = "TEMPORARYTOPIC.";

    public static final String WS_ENC_MessagePartsDialect(int id) {
        return "X-WS-ENC-" + id + "-" + WS_MessagePartsDialect;
    }

    public static final String WS_ENC_MessageParts(int id) {
        return "X-WS-ENC-" + id + "-" + WS_MessageParts;
    }

    public static final String WS_ENC_AlgEncryption(int id) {
        return "X-WS-ENC-" + id + "-" + WS_AlgEncryption;
    }

    public static final String WS_ENC_KeyInfo(int id) {
        return "X-WS-ENC-" + id + "-" + WS_KeyInfo;
    }

    public static final String WS_ENC_X509TokenRef(int id) {
        return "X-WS-ENC-" + id + "-" + WS_X509TokenRef;
    }

    public static final String WS_ENC_X509TokenRefURI(int id) {
        return "X-WS-ENC-" + id + "-" + WS_X509TokenRefURI;
    }

    public static final String WS_ENC_X509TokenRefIssuer(int id) {
        return "X-WS-ENC-" + id + "-" + WS_X509TokenRefIssuer;
    }

    public static final String WSS_DSIG_X509TokenRefSerialNumber(int id) {
        return "X-WS-ENC-" + id + "-" + WS_X509TokenRefSerialNumber;
    }

    public static final String WS_DSIG_MessagePartsDialect(int id) {
        return "X-WS-DSIG-" + id + "-" + WS_MessagePartsDialect;
    }

    public static final String WS_DSIG_MessageParts(int id) {
        return "X-WS-DSIG-" + id + "-" + WS_MessageParts;
    }

    public static final String WS_DSIG_AlgCanonicalization(int id) {
        return "X-WS-DSIG-" + id + "-" + WS_AlgCanonicalization;
    }

    public static final String WS_DSIG_AlgSignature(int id) {
        return "X-WS-DSIG-" + id + "-" + WS_AlgSignature;
    }

    public static final String WS_DSIG_AlgTransform(int id) {
        return "X-WS-DSIG-" + id + "-" + WS_AlgTransform;
    }

    public static final String WS_DSIG_AlgDigest(int id) {
        return "X-WS-DSIG-" + id + "-" + WS_AlgDigest;
    }

    public static final String WS_DSIG_X509TokenRef(int id) {
        return "X-WS-DSIG-" + id + "-" + WS_X509TokenRef;
    }

    public static final String WS_DSIG_X509TokenRefURI(int id) {
        return "X-WS-DSIG-" + id + "-" + WS_X509TokenRefURI;
    }

    public static final String WS_DSIG_X509TokenRefIssuer(int id) {
        return "X-WS-DSIG-" + id + "-" + WS_X509TokenRefIssuer;
    }

    public static final String WS_DSIG_X509TokenRefSerialNumber(int id) {
        return "X-WS-DSIG-" + id + "-" + WS_X509TokenRefSerialNumber;
    }

    public static final String WS_DSIG_X509TokenAlias(int id) {
        return "X-WS-DSIG-" + id + "-" + WS_X509TokenAlias;
    }

    public static final String WS_DSIG_X509TokenPrivateKeyPassword(int id) {
        return "X-WS-DSIG-" + id + "-" + WS_X509TokenPrivateKeyPassword;
    }

    public static void enableDebug(int debugLevel) {
        DEBUG = true;
        DEBUG_LEVEL = debugLevel;
    }

    public static void DEBUG(String msg, int minDebugLevel) {
        if (!DEBUG) {
            return;
        }
        if (DEBUG_LEVEL >= minDebugLevel) {
            System.out.println("[DEBUG HTTP Direct] " + msg);
        }
    }

    public static void DEBUG(Throwable t, int minDebugLevel) {
        if (!DEBUG) {
            return;
        }
        if (DEBUG_LEVEL >= minDebugLevel) {
            t.printStackTrace();
        }
    }
}

