/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.axis.handlers;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.ws.WSHttpInRequest;
import com.sonicsw.ws.axis.DebugObjects;
import com.sonicsw.ws.axis.handlers.UniversalHandler;
import com.sonicsw.ws.rm.common.AddressBinder;
import com.sonicsw.ws.security.policy.Assertion;
import com.sonicsw.ws.security.policy.SecurityPolicyAlternative;
import com.sonicsw.ws.security.policy.WSSPUtils;
import com.sonicsw.wsp.OperationContext;
import com.sonicsw.wsp.OperationContextManager;
import com.sonicsw.wsp.PolicyException;
import com.sonicsw.wsp.SecurityPolicy2002Exception;
import com.sonicsw.wsp.WSPUtils;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.Destination;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.ws.policy.Policy;
import org.apache.xmlbeans.XmlObject;
import org.xmlsoap.schemas.ws.x2004.x09.policy.OperatorContentType;
import org.xmlsoap.schemas.ws.x2004.x09.policy.PolicyDocument;
import progress.message.jclient.Queue;

public class PolicyFromOperationContextHandler
extends UniversalHandler {
    @Override
    public void handleClientRequest(MessageContext mc) throws AxisFault {
        this.debug("PolicyFromOperationContextHandler:handleClientRequest", mc);
    }

    @Override
    public void handleClientResponse(MessageContext mc) throws AxisFault {
        try {
            this.debug("PolicyFromOperationContextHandler:handleClientResponse:", mc);
            OperationContext oc = (OperationContext)mc.getProperty("COM_SONIC_WS_OPERATION_CONTEXT");
            if (oc == null) {
                return;
            }
            if (!this.isOperationReply(mc.getResponseMessage())) {
                return;
            }
            this.policyFromString(oc.getResponsePolicy(), mc);
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Throwable t) {
            BrokerComponent.getComponentContext().logMessage("Failure in RM handler:" + t, t, BrokerComponent.getLevelWarning().intValue());
            throw new AxisFault(t.getMessage());
        }
    }

    @Override
    public void handleServerRequest(MessageContext mc) throws AxisFault {
        try {
            this.debug("PolicyFromOperationContextHandler:handleServerRequest:", mc);
            WSHttpInRequest wsreq = (WSHttpInRequest)mc.getProperty("com.sonicsw.net.http.HttpInRequest");
            String fullRequestURL = wsreq.getRequest().getRequestURI();
            Destination d = null;
            if (AddressBinder.isInternallyGeneratedWSAFrom(fullRequestURL) || AddressBinder.isInternallyGeneratedWSAReplyTo(fullRequestURL)) {
                d = AddressBinder.getWSADestination(fullRequestURL);
            }
            if (d == null) {
                return;
            }
            String key = null;
            if (d instanceof Queue) {
                key = ((Queue)d).getName();
            }
            if (key == null) {
                return;
            }
            OperationContext oc = OperationContextManager.getOperationContextManager().getOperationContext(key);
            if (oc == null) {
                return;
            }
            if (this.isOperationFault(mc.getRequestMessage())) {
                OperationContextManager.getOperationContextManager().removeOperationContext(oc, true);
                return;
            }
            if (!this.isOperationReply(mc.getRequestMessage())) {
                return;
            }
            this.policyFromString(oc.getResponsePolicy(), mc);
            mc.setProperty("COM_SONIC_WS_OPERATION_CONTEXT", (Object)oc);
        }
        catch (AxisFault af) {
            throw af;
        }
        catch (Throwable t) {
            BrokerComponent.getComponentContext().logMessage("Failure in RM handler:" + t, t, BrokerComponent.getLevelWarning().intValue());
            throw new AxisFault(t.getMessage());
        }
    }

    @Override
    public void handleServerResponse(MessageContext mc) throws AxisFault {
        this.debug("PolicyFromOperationContextHandler:handleServerResponse:", mc);
        OperationContext oc = (OperationContext)mc.getProperty("COM_SONIC_WS_OPERATION_CONTEXT");
        if (oc != null) {
            OperationContextManager.getOperationContextManager().onReply(oc.getKey());
        }
    }

    private void policyFromString(String policyProp, MessageContext mc) throws AxisFault {
        try {
            if (policyProp == null || policyProp.length() == 0) {
                SecurityPolicyAlternative[] policyAlternatives = new SecurityPolicyAlternative[]{new SecurityPolicyAlternative()};
                mc.setProperty("com.sonicsw.ws.security.policy.InboundPolicy", (Object)policyAlternatives);
                return;
            }
            Policy policy = null;
            try {
                policy = WSPUtils.getPolicy(policyProp);
                if (!DebugObjects.getPolicyDebug().getDebug()) {
                    throw new SecurityPolicy2002Exception();
                }
                DebugObjects.getPolicyDebug().debug("PolicyFromOperationContextHandler: policy doc from op ctx -" + policy);
                mc.setProperty("com.sonicsw.ws.security.policy.InboundPolicy", (Object)WSSPUtils.getPolicyAlternatives(policy));
            }
            catch (SecurityPolicy2002Exception e) {
                String soapEnvNSUri = mc.getSOAPConstants().getEnvelopeURI();
                PolicyDocument pdoc = WSPUtils.getPolicyDocument(policyProp);
                DebugObjects.getHandlerDebug().debug("PolicyFromOperationContextHandler: policy doc from op ctx -\n" + pdoc);
                mc.setProperty("com.sonicsw.ws.security.policy.InboundPolicy", (Object)PolicyFromOperationContextHandler.getSecurityPolicyAlternatives(soapEnvNSUri, pdoc));
            }
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    private static SecurityPolicyAlternative[] getSecurityPolicyAlternatives(String soapEnvNSUri, PolicyDocument effectivePolicy) throws PolicyException {
        ArrayList<SecurityPolicyAlternative> alternatives = new ArrayList<SecurityPolicyAlternative>();
        Iterator allIterator = WSPUtils.getNormalizedAllIterator(effectivePolicy);
        while (allIterator.hasNext()) {
            SecurityPolicyAlternative sp = new SecurityPolicyAlternative();
            OperatorContentType currentAll = (OperatorContentType)allIterator.next();
            XmlObject[] xmlobjs = WSSPUtils.getAllSecurityAssertions(currentAll);
            for (int i = 0; i < xmlobjs.length; ++i) {
                Assertion a = WSSPUtils.createAssertionObject(soapEnvNSUri, xmlobjs[i]);
                sp.addAction(a);
            }
            alternatives.add(sp);
        }
        SecurityPolicyAlternative[] result = new SecurityPolicyAlternative[alternatives.size()];
        alternatives.toArray(result);
        return result;
    }

    @Override
    public void onClientRequestFault(MessageContext mc) {
        this.debug("PolicyFromOperationContextHandler:onClientRequestFault:", mc);
    }

    @Override
    public void onClientResponseFault(MessageContext mc) {
        this.debug("PolicyFromOperationContextHandler:onClientResponseFault:", mc);
    }

    @Override
    public void onServerRequestFault(MessageContext mc) {
        this.debug("PolicyFromOperationContextHandler:onServetResponseFault:", mc);
    }

    @Override
    public void onServerResponseFault(MessageContext mc) {
        this.debug("PolicyFromOperationContextHandler:onServerResponseFault:", mc);
    }

    public boolean isOperationFault(Message m) throws Exception {
        try {
            SOAPBody b = m.getSOAPBody();
            return b != null && b.getChildNodes().getLength() > 0 && b.hasFault();
        }
        catch (SOAPException se) {
            return false;
        }
    }

    public boolean isOperationReply(Message m) throws Exception {
        try {
            SOAPBody b = m.getSOAPBody();
            boolean rc = b != null && b.getChildNodes().getLength() > 0 && !b.hasFault();
            return rc;
        }
        catch (SOAPException se) {
            return false;
        }
    }
}

