/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.conversation.sts;

import com.sonicsw.ws.conversation.sts.SecurityContextToken;
import com.sonicsw.ws.conversation.sts.SecurityContextTokenImpl;
import com.sonicsw.ws.conversation.sts.TokenID;
import com.sonicsw.ws.conversation.sts.UnexpiredSCTException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class SecurityContextTokenCache {
    private static SecurityContextTokenCache ourInstance;
    private TreeSet byID = new TreeSet(new SecurityContextTokenImpl.ByIDComparator());
    private TreeSet byExpiration = new TreeSet(new SecurityContextTokenImpl.ByExpirationComparator());

    public static synchronized SecurityContextTokenCache getInstance() {
        if (ourInstance == null) {
            ourInstance = new SecurityContextTokenCache();
        }
        return ourInstance;
    }

    private SecurityContextTokenCache() {
    }

    public SecurityContextToken get(TokenID tokenID) {
        SecurityContextToken result = this.getSCT(tokenID);
        if (result != null && result.isExpired()) {
            result = null;
        }
        return result;
    }

    public void put(SecurityContextToken sct) throws UnexpiredSCTException {
        if (sct != null) {
            SecurityContextToken result = this.getSCT(sct.getTokenID());
            if (result != null && !result.isExpired()) {
                throw new UnexpiredSCTException("An attempt to replace an unexpired SCT:" + result + "  with SCT:" + sct);
            }
            this.removeExpiredSCT();
            this.byID.add(sct);
            this.byExpiration.add(sct);
        }
    }

    public void remove(TokenID tokenID) {
        SecurityContextToken sct = this.getSCT(tokenID);
        if (sct != null) {
            this.byID.remove(sct);
            this.byExpiration.remove(sct);
        }
    }

    public Collection getTokens() {
        return Collections.unmodifiableSet(this.byExpiration);
    }

    public void dump() {
        System.out.println("byID");
        Iterator itr = this.byID.iterator();
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
        System.out.println("byExpiration");
        itr = this.byExpiration.iterator();
        while (itr.hasNext()) {
            System.out.println(itr.next());
        }
    }

    private SecurityContextToken getSCT(TokenID tokenID) {
        SecurityContextToken result = null;
        SortedSet<SecurityContextTokenImpl> ss = this.byID.tailSet(new SecurityContextTokenImpl(tokenID, null, 0L));
        if (!ss.isEmpty() && !(result = (SecurityContextToken)ss.first()).getTokenID().equals(tokenID)) {
            result = null;
        }
        return result;
    }

    public void removeExpiredSCT() {
        SortedSet<SecurityContextTokenImpl> expired = this.byExpiration.headSet(new SecurityContextTokenImpl(null, null, System.currentTimeMillis()));
        Iterator itr = expired.iterator();
        while (itr.hasNext()) {
            SecurityContextToken sct = (SecurityContextToken)itr.next();
            this.byID.remove(sct);
            itr.remove();
        }
    }
}

