/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.rm.api;

import com.sonicsw.ws.rm.api.ISequenceStatusReporter;
import com.sonicsw.ws.rm.api.ISequenceTerminator;
import com.sonicsw.ws.rm.api.RMSequence;
import com.sonicsw.ws.rm.api.ReliableSequenceInteractorConfiguration;
import com.sonicsw.ws.rm.api.ReliableSequenceInteractorException;
import com.sonicsw.ws.rm.api.ReliableSequenceInteractorForJMS;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.apache.axis.AxisFault;
import org.apache.axis.client.Call;
import org.apache.axis.components.jms.JMSVendorAdapter;
import org.apache.axis.components.jms.JMSVendorAdapterFactory;
import org.apache.axis.transport.jms.JMSConnector;
import org.apache.axis.transport.jms.JMSConnectorManager;
import org.apache.axis.transport.jms.JMSTransport;
import org.apache.axis.transport.jms.JMSURLHelper;

public class RMSequenceFactory {
    String m_username;
    String m_password;
    String m_jmsEndpointAddr;
    JMSVendorAdapter m_vendorAdapter = null;
    Map m_connectorProperties = null;
    Map m_connectionFactoryProperties = null;
    long m_sequenceExpires = 300000L;
    long m_returnSequenceExpires = 300000L;
    String m_ultimateEndpoint = null;
    boolean m_bidirectional = false;
    String m_mgmtUrl;
    String m_brokerName;
    String m_policy = "<wsp:Policy wsu:Id=\"MyPolicy\" xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\" xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\"><wsp:ExactlyOne><wsp:All><wsrm:RMAssertion xmlns:wsrm=\"http://schemas.xmlsoap.org/ws/2005/02/rm/policy\"><wsrm:InactivityTimeout Milliseconds=\"3000000\" /><wsrm:BaseRetransmissionInterval Milliseconds=\"3000\" /><wsrm:AcknowledgementInterval Milliseconds=\"200\" /></wsrm:RMAssertion></wsp:All></wsp:ExactlyOne></wsp:Policy>";
    QueueConnectionFactory m_connectionFactory;
    JMSConnector m_connector;
    QueueConnection m_connection;
    QueueSession m_senderSession;
    QueueSession m_receiverSession;
    QueueSender m_sender;
    QueueReceiver m_receiver;
    ReliableSequenceInteractorConfiguration m_interactorConfig;
    ReliableSequenceInteractorForJMS m_interactor;
    private static String TESTEP = "http://nbpeaston:52019/axis";
    private static String JMSEP = "jms:/WS::WS?vendor=SonicMQ&brokerURL=localhost:52010&defaultUser=Administrator&defaultPassword=Administrator&transport.jms.numRetries=0";

    public void setManageable(String mgmtUrl, String brokerName) {
        this.m_mgmtUrl = mgmtUrl;
        this.m_brokerName = brokerName;
    }

    public void setPolicy(String policy) {
        this.m_policy = policy;
    }

    public void setSequenceExpires(long expires) {
        this.m_sequenceExpires = expires;
    }

    public void setReturnSequenceExpires(long expires) {
        this.m_returnSequenceExpires = expires;
    }

    public void setBidirectional(boolean bidirectional) {
        this.m_bidirectional = bidirectional;
    }

    public RMSequenceFactory(String username, String password, String jmsEndpointAddr, String endpointAddr) throws Exception {
        Call.setTransportForProtocol((String)"jms", JMSTransport.class);
        JMSURLHelper jmsurl = null;
        this.m_username = username;
        this.m_password = password;
        this.m_jmsEndpointAddr = jmsEndpointAddr;
        this.m_ultimateEndpoint = endpointAddr;
        jmsurl = new JMSURLHelper(new URL(jmsEndpointAddr));
        String vendorId = jmsurl.getVendor();
        if (vendorId == null) {
            vendorId = "JNDI";
        }
        this.m_vendorAdapter = JMSVendorAdapterFactory.getJMSVendorAdapter((String)vendorId);
        if (this.m_vendorAdapter == null) {
            throw new AxisFault("cannotLoadAdapterClass:" + vendorId);
        }
        this.m_connectorProperties = this.m_vendorAdapter.getJMSConnectorProperties(jmsurl);
        this.m_connectionFactoryProperties = this.m_vendorAdapter.getJMSConnectionFactoryProperties(jmsurl);
        this.m_connector = JMSConnectorManager.getInstance().getConnector((HashMap)this.m_connectorProperties, (HashMap)this.m_connectionFactoryProperties, this.m_username, this.m_password, this.m_vendorAdapter);
        this.m_connectionFactory = (QueueConnectionFactory)this.m_connector.getConnectionFactory();
        this.m_connection = this.m_connectionFactory.createQueueConnection(this.m_username, this.m_password);
        boolean UNTRANSACTED = false;
        this.m_receiverSession = this.m_connection.createQueueSession(UNTRANSACTED, 1);
        this.m_senderSession = this.m_connection.createQueueSession(UNTRANSACTED, 1);
        this.m_sender = this.m_senderSession.createSender(this.m_vendorAdapter.getQueue(this.m_senderSession, jmsurl.getDestination()));
        this.m_receiver = this.m_receiverSession.createReceiver(this.m_receiverSession.createTemporaryQueue());
        this.m_connection.start();
    }

    public RMSequence create() throws Exception {
        ISequenceStatusReporter reporter;
        this.initializeInterractor();
        ISequenceTerminator terminator = new ISequenceTerminator(){

            @Override
            public void sendLast(String id, int nr) throws Exception {
                RMSequenceFactory.this.m_interactor.sendLast(id, nr);
            }

            @Override
            public void terminate(String id) throws Exception {
                RMSequenceFactory.this.m_interactor.performTerminateReliableSequenceInteraction(id);
            }
        };
        if (this.m_mgmtUrl != null) {
            Class[] pTypes = new Class[]{String.class, String.class, String.class, String.class};
            Object[] parms = new Object[]{this.m_mgmtUrl, this.m_username, this.m_password, this.m_brokerName};
            reporter = (ISequenceStatusReporter)Class.forName("com.sonicsw.ws.rm.api.SequenceStatusReporterImpl").getConstructor(pTypes).newInstance(parms);
        } else {
            reporter = new ISequenceStatusReporter(){

                @Override
                public long getOutstandingMessageCount(String id) throws Exception {
                    throw new Exception("Unsupported operation, use the RMSequenceFactory setManageable method to supply URL of the Sonic Management Domain and the broker name to manage.");
                }

                @Override
                public boolean isActive(String id) throws Exception {
                    throw new Exception("Unsupported operation, use the RMSequenceFactory setManageable method to supply URL of the Sonic Management Domain and the broker name to manage.");
                }
            };
        }
        String id = this.createSequence();
        return new RMSequence(id, this.m_policy, terminator, reporter);
    }

    public void closeResources() {
        try {
            if (this.m_connection != null) {
                this.m_connection.close();
            }
            if (this.m_connector != null) {
                this.m_connector.shutdown();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void initializeInterractor() throws Exception {
        this.m_interactorConfig = new ReliableSequenceInteractorConfiguration();
        this.m_interactorConfig.setSenderSession(this.m_senderSession);
        this.m_interactorConfig.setSender(this.m_sender);
        this.m_interactorConfig.setReceiver(this.m_receiver);
        this.m_interactorConfig.setEndpointURL(this.m_ultimateEndpoint);
        this.m_interactorConfig.getProperties().setProperty("Content-Type", "text/xml");
        if (this.m_bidirectional) {
            this.m_interactorConfig.setOfferedReturnSequenceIdentifier("REQUEST_SYSTEM_ASSIGNED");
            this.m_interactorConfig.setOfferedReturnSequenceExpires(this.m_returnSequenceExpires);
        }
        this.m_interactorConfig.setPolicy(this.m_policy);
        this.m_interactorConfig.setSequenceExpires(this.m_sequenceExpires);
        this.m_interactorConfig.setReliableMessagingVersion("WSRMVersionFEB2005");
        this.m_interactorConfig.setSOAPVersion("SOAP 1.1");
        this.m_interactorConfig.setReplyTimeout(60000L);
        this.m_interactorConfig.setUseBytesMessage(true);
        this.m_interactor = new ReliableSequenceInteractorForJMS(this.m_interactorConfig);
    }

    protected String createSequence() throws JMSException, ReliableSequenceInteractorException {
        return this.m_interactor.performCreateReliableSequenceInteraction();
    }

    public static void main(String[] args) {
        try {
            RMSequenceFactory fac = new RMSequenceFactory("Administrator", "Administrator", JMSEP, TESTEP);
            RMSequence seq = fac.create();
            seq.close();
            fac.closeResources();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

