/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.ws.security.policy.parser.processors;

import com.sonicsw.ws.security.policy.model.TransportBinding;
import com.sonicsw.ws.security.policy.parser.processors.TransportTokenProcessor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.policy.model.Binding;
import org.apache.ws.security.policy.model.SupportingToken;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;
import org.apache.ws.security.policy.parser.processors.AlgorithmSuiteProcessor;
import org.apache.ws.security.policy.parser.processors.EndorsingSupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.LayoutProcessor;
import org.apache.ws.security.policy.parser.processors.SignedEndorsingSupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.SignedSupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.SupportingTokensProcessor;
import org.apache.ws.security.policy.parser.processors.Wss10Processor;
import org.apache.ws.security.policy.parser.processors.Wss11Processor;

public class TransportBindingProcessor {
    private Log log = LogFactory.getLog(this.getClass());
    private String transportBindingID;
    private boolean initializedTransportBinding = false;

    private void initializeTransportBinding(SecurityPolicyToken spt) throws NoSuchMethodException {
        TransportTokenProcessor sept = new TransportTokenProcessor();
        SecurityPolicyToken tmpSpt = SecurityPolicy.transportToken.copy();
        tmpSpt.setProcessTokenMethod((Object)sept);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.algorithmSuite.copy();
        tmpSpt.setProcessTokenMethod((Object)new AlgorithmSuiteProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.layout.copy();
        tmpSpt.setProcessTokenMethod((Object)new LayoutProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.includeTimestamp.copy();
        tmpSpt.setProcessTokenMethod((Object)this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.supportingTokens.copy();
        tmpSpt.setProcessTokenMethod((Object)new SupportingTokensProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.signedSupportingTokens.copy();
        tmpSpt.setProcessTokenMethod((Object)this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.endorsingSupportingTokens.copy();
        tmpSpt.setProcessTokenMethod((Object)new EndorsingSupportingTokensProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.signedEndorsingSupportingTokens.copy();
        tmpSpt.setProcessTokenMethod((Object)new SignedEndorsingSupportingTokensProcessor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wss10.copy();
        tmpSpt.setProcessTokenMethod((Object)new Wss10Processor());
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.wss11.copy();
        tmpSpt.setProcessTokenMethod((Object)new Wss11Processor());
        spt.setChildToken(tmpSpt);
    }

    public Object doTransportBinding(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                if (this.initializedTransportBinding) break;
                try {
                    this.initializeTransportBinding(spt);
                    this.initializedTransportBinding = true;
                    break;
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                    return new Boolean(false);
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doIncludeTimestamp(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        if (spc.getAction() == 1) {
            ((Binding)spc.readCurrentPolicyEngineData()).setIncludeTimestamp(true);
        }
        return new Boolean(true);
    }

    public Object doSignedSupportingTokens(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        try {
            this.setWSS4JProcessTokenMethod(new SignedSupportingTokensProcessor(), "doSignedSupportingTokens", spc);
        }
        catch (NoSuchMethodException e) {
            return new Boolean(false);
        }
        catch (IllegalArgumentException e) {
            return new Boolean(false);
        }
        catch (IllegalAccessException e) {
            return new Boolean(false);
        }
        catch (InvocationTargetException e) {
            return new Boolean(false);
        }
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                SupportingToken supportingToken = (SupportingToken)spc.readCurrentPolicyEngineData();
                ((TransportBinding)spc.readPreviousPolicyEngineData()).setSupportingToken(supportingToken);
                break;
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    private boolean setWSS4JProcessTokenMethod(Object tokenProcessor, String methodname, SecurityProcessorContext spc) throws NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method processTokenMethod = null;
        Class<?> handlerCls = tokenProcessor.getClass();
        Class[] parameters = new Class[]{SecurityProcessorContext.class};
        processTokenMethod = handlerCls.getDeclaredMethod(methodname, parameters);
        Object[] parameter = new Object[]{spc};
        Object ret = processTokenMethod.invoke(tokenProcessor, parameter);
        if (ret instanceof Boolean) {
            Boolean bool = (Boolean)ret;
            return bool;
        }
        return false;
    }

    public String getId() {
        return this.transportBindingID;
    }
}

