/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import com.sonicsw.security.pass.broker.IAuthentication;
import com.sonicsw.security.pcs.PluggableSecureInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.PrintStream;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import progress.message.broker.AMPScratchPad;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentAdministrativelyCreatedQueue;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentMessageProcessor;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentSender;
import progress.message.broker.Broker;
import progress.message.broker.BrokerJob;
import progress.message.broker.BrokerLicenseMgr;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.ConnectionContext;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EConnectionNotResumable;
import progress.message.broker.EIPAddressLimitExceeded;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.PipeSocket;
import progress.message.broker.TransactionMgr;
import progress.message.broker.durable.CWADSListXferOp;
import progress.message.broker.durable.CWADSListXferReplyOp;
import progress.message.broker.durable.CWADSPingOp;
import progress.message.broker.durable.CWADSPingReplyOp;
import progress.message.broker.durable.DurableBrowseOp;
import progress.message.broker.durable.DurableBrowseReplyOp;
import progress.message.broker.durable.DurableClientContextReplyQueue;
import progress.message.broker.durable.DurableGetMgramOp;
import progress.message.broker.durable.DurableGetMgramReplyOp;
import progress.message.broker.durable.DurableRemoveOp;
import progress.message.broker.durable.DurableRemoveReplyOp;
import progress.message.broker.durable.DurableSearchOp;
import progress.message.broker.durable.DurableSearchReplyOp;
import progress.message.broker.durable.DurableTrimOp;
import progress.message.broker.durable.DurableTrimReplyOp;
import progress.message.broker.durable.IDurableOperation;
import progress.message.broker.durable.IDurableReplyOperation;
import progress.message.broker.fc.FlowControlMonitor;
import progress.message.broker.loadbalancing.ILoadBalancer;
import progress.message.broker.prAccessor;
import progress.message.client.EBrokerRedirected;
import progress.message.client.EBrokerVersionMismatch;
import progress.message.client.EChecksumValidationFailed;
import progress.message.client.EConnectFailure;
import progress.message.client.EConnectionLimitExceeded;
import progress.message.client.EInauthenticClient;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.EUnsupportedMgramException;
import progress.message.client.EUserAlreadyConnected;
import progress.message.client.EUserAlreadyConnectedPendingReconnect;
import progress.message.crypto.SecureInputStream;
import progress.message.ft.FailoverConfig;
import progress.message.ft.ReplicationChannel;
import progress.message.gr.RouterManager;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.interbroker.Neighbor;
import progress.message.msg.IConnectionSyncHandle;
import progress.message.msg.IMgram;
import progress.message.msg.IMgramConverter;
import progress.message.msg.IMgramStatusListener;
import progress.message.msg.IOperationHandle;
import progress.message.msg.IPTPFlowControlHandle;
import progress.message.msg.IWindowAckHandle;
import progress.message.msg.MgramConstants;
import progress.message.msg.MgramFactory;
import progress.message.net.ISocket;
import progress.message.net.ProgressInetAddress;
import progress.message.security.SecurityBean;
import progress.message.strm.StreamFactory;
import progress.message.util.AutoVec;
import progress.message.util.CompressionFactory;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.FilterTypeEnumeration;
import progress.message.util.ICompressionFactory;
import progress.message.util.IDumpable;
import progress.message.util.IMetricsListener;
import progress.message.util.InputStreamWrapper;
import progress.message.util.capture.CaptureBuffer;
import progress.message.util.capture.CaptureInputStream;
import progress.message.zclient.BrokerConnectHandshaker;
import progress.message.zclient.BrokerConnectParms;
import progress.message.zclient.ClientConnectParms;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.ConnectData;
import progress.message.zclient.ConnectionFailoverStatus;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.EMgramVersionMismatch;
import progress.message.zclient.EMsgTooBigException;
import progress.message.zclient.EUnexpectedMgram;
import progress.message.zclient.IErrorCodes;
import progress.message.zclient.IMessageProtection;
import progress.message.zclient.ISecureInputStream;
import progress.message.zclient.ISubject;
import progress.message.zclient.Listener;
import progress.message.zclient.NegotiatedConnectParms;
import progress.message.zclient.ProgressGroup;
import progress.message.zclient.ProgressPasswordUser;
import progress.message.zclient.Sender;
import progress.message.zclient.SessionConfig;
import progress.message.zclient.xonce.ConnectionSyncData;
import progress.message.zclient.xonce.MgramTrace;

public class AgentListener
extends Listener
implements IErrorCodes,
IMgramStatusListener {
    private static final String MISSING_EMBEDDED_MGRAM_IN_WRAPPED_GUAR_FORMAT_MGRAM = "Missing embedded mgram in WRAPPED_GUAR_FORMAT_MGRAM";
    private static final String RECEIVED_REQUEST_TO_DUMP_SENDER_MGRAM_HISTORY_FOR = "Received request to dump sender mgram history for ";
    private static final String RECEIVED_UNRECOGNIZED_DIAGNOSITC_MGRAM_OPERATION = "Received unrecognized diagnositc mgram operation: ";
    private static final String UNKNOWN_OPERATION_TYPE = "Unknown Operation Type: ";
    protected static volatile AgentRegistrar s_reg;
    private static volatile AgentMessageProcessor s_msgproc;
    private static volatile AgentQueueProcessor s_qproc;
    private static volatile TransactionMgr s_txnmgr;
    private static Object QPROC_LOCK_OBJ;
    protected static final int PRE_CONNECT = 0;
    protected static final int IN_CONNECT = 0;
    protected static final int POST_CONNECT = 2;
    private byte m_clientSessionVer = (byte)32;
    private static IMetricsRegistrar m_metricsRegistrar;
    private static boolean m_hasEnabledBytesMetrics;
    private static boolean m_hasEnabledMsgsMetrics;
    public static final IMetricIdentity BROKER_BYTES_RECEIVEDPERSECOND_METRIC;
    private static IStatistic m_bytesReceivedPerSecond;
    public static final IMetricIdentity BROKER_MSGS_RECEIVEDPERSECOND_METRIC;
    private static IStatistic m_msgsReceivedPerSecond;
    public static final IMetricIdentity BROKER_MSGS_RECEIVED_METRIC;
    private static IStatistic m_msgsReceived;
    public static final IMetricIdentity BROKER_CONNECTIONS_REJECTEDPERMINUTE_METRIC;
    private static IStatistic m_connRejectedPerMinute;
    ProgressPasswordUser m_user;
    private byte[] m_masterSecret = null;
    private byte[] m_rawMacKey = null;
    private byte[] m_rawSessionKey = null;
    protected AgentConnection m_connection;
    private final boolean m_isAdminConnection;
    private volatile long m_inactiveSince = 0L;
    protected AutoVec m_ccs = new AutoVec();
    protected ClientSecurityContext m_commonCsc = null;
    private IMessageProtection m_commonMp = null;
    private final AutoVec m_scratchPads = new AutoVec();
    private String m_uid;
    private String m_chan0_appid;
    private final Object m_synchvar = new Object();
    private final Object m_criticalConnectRegionLock = new Object();
    protected boolean m_failedConnectAttempt = false;
    private boolean m_isRouter = false;
    protected InputStream m_is = null;
    protected InputStream m_socketStream = null;
    protected InputStreamWrapper m_compressionStreamWrapper = null;
    private final boolean DIAG_MGRAM_HISTORY;
    private CaptureBuffer m_cb = null;
    private ISecureInputStream m_sis = null;
    private byte m_clientMgramVersion = (byte)26;
    protected IMgramConverter m_converter = null;
    private final Object m_mainLoopNotify = new Object();
    private boolean m_reachedMainLoop = false;
    private boolean m_exited = false;
    private ICompressionFactory m_compressionFactory = null;
    private IMetricsListener m_metricsListener = null;
    protected String m_threadNamePrefix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initClass(AgentRegistrar reg) throws IOException {
        s_reg = reg;
        s_msgproc = reg.getMsgProc();
        Object object = QPROC_LOCK_OBJ;
        synchronized (object) {
            s_qproc = reg.getQueueProc();
        }
        s_txnmgr = reg.getTransactionMgr();
    }

    public void setCommonSecurityContext(ClientSecurityContext csc) {
        this.m_commonCsc = csc;
    }

    protected Object getCriticalConnectRegionLock() {
        return this.m_criticalConnectRegionLock;
    }

    protected void setRouter(boolean router) {
        this.m_isRouter = router;
    }

    public void copyInputStreams(AgentListener listener) {
        this.m_is = listener.m_is;
        this.m_socketStream = listener.m_socketStream;
        this.m_sis = listener.m_sis;
        this.m_cb = listener.m_cb;
    }

    public AgentListener(AgentConnection connection) throws IOException {
        this("AgentListener of", connection);
    }

    public AgentListener(String threadName, AgentConnection connection) throws IOException {
        super(threadName, connection);
        this.m_connection = connection;
        this.m_isAdminConnection = this.m_connection.isAdminConnection();
        this.m_threadNamePrefix = threadName;
        this.setThreadNameHelper();
        this.getFilterData().add(FilterTypeEnumeration.ADMINCLIENT, this.m_connection.getSocket() instanceof PipeSocket);
        this.m_converter = MgramFactory.getMgramConverter(26);
        this.DIAG_MGRAM_HISTORY = SessionConfig.DIAG_MGRAM_HISTORY || this.checkDebugFlags(8192);
    }

    protected long getClientId(int channel) {
        return this.m_connection.getClientId(channel);
    }

    public long getInactive() {
        return this.m_inactiveSince;
    }

    @Override
    public void setStatus(byte status) {
        switch (status) {
            case 0: {
                this.m_inactiveSince = System.currentTimeMillis();
                break;
            }
            case 1: {
                this.m_inactiveSince = 0L;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadMain() throws Exception {
        try {
            this.listenerLoop();
        }
        finally {
            Object object = this.m_mainLoopNotify;
            synchronized (object) {
                this.m_exited = true;
                this.m_mainLoopNotify.notifyAll();
            }
        }
    }

    private void listenerLoop() throws Exception {
        if (this.DEBUG) {
            this.logDebug(128, "starting");
        }
        ISocket socket = this.m_connection.getSocket();
        AMPScratchPad sp = new AMPScratchPad();
        this.m_scratchPads.setElementAt(sp, 0);
        this.m_commonMp = sp.m_mp;
        IClientContext cc = null;
        if (!this.m_connection.isAuthenticated()) {
            BrokerConnectHandshaker handshaker = null;
            try {
                socket.setSoTimeout(Config.BROKER_CONNECT_TIMEOUT);
                if (this.DEBUG) {
                    this.logDebug(128, "Starting transport handshake");
                }
                socket.startTransportHandshake();
                if (this.DEBUG) {
                    this.logDebug(128, "Starting SonicMQ handshake");
                }
                handshaker = new BrokerConnectHandshaker(this.m_connection);
                IAuthentication spi = AgentRegistrar.getAuthenticationSPI();
                boolean flag = spi != null;
                handshaker.setAuthenticationSPI(flag, spi);
                handshaker.setCipherSuite(AgentRegistrar.getCipherSuite());
                socket.startProgressHandshake();
                try {
                    this.m_is = this.m_socketStream = StreamFactory.getListenerInputStream(socket, this.m_connection.getMaxRcvBufferSize(), this.m_connection.getMinRcvBufferSize(), this.m_connection.getInitialRcvBufferSize(), Config.ENABLE_CHECKSUM && !this.m_isAdminConnection);
                    if (this.checkDebugFlags(64)) {
                        this.logDebug(64, "Created InputStream " + this.m_is);
                    }
                    if (Config.ENABLE_COMPRESSION && !this.m_isAdminConnection) {
                        this.m_compressionStreamWrapper = new InputStreamWrapper(this.m_socketStream);
                        this.m_is = this.m_compressionStreamWrapper;
                    }
                    if (this.DIAG_MGRAM_HISTORY && !this.m_isAdminConnection) {
                        int captureSize = SessionConfig.LISTENER_CAPTURE_BUFFER_SIZE;
                        if (SessionConfig.CAPTURE_BUFFER_FILTER.length() > 0) {
                            captureSize = 4096;
                        }
                        CaptureInputStream cis = new CaptureInputStream(this.m_is, captureSize);
                        this.m_is = cis;
                        this.m_cb = cis.getCaptureBuffer();
                    }
                    this.secureInputStreamUntilHandshakeComplete();
                }
                catch (NullPointerException ex) {
                    BrokerComponent.getComponentContext().logMessage(prAccessor.getString("PREMATURELY_CLOSED_CONNECTION"), (Throwable)ex, 2);
                    this.m_connection.close(0);
                    return;
                }
                if (this.DEBUG) {
                    this.logDebug(128, "preconnectloop");
                }
                this.preconnectLoop(handshaker);
                if (this.DEBUG) {
                    this.logDebug(128, "connectloop");
                }
                this.connectLoop(handshaker);
                if (this.DEBUG) {
                    this.logDebug(128, "success");
                }
            }
            catch (EBrokerRedirected e) {
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 3);
                }
                this.m_connection.close(0);
                return;
            }
            catch (EInauthenticClient e) {
                this.logMessage(e);
                this.sendErrorMgram(-25, 0);
                this.publishRejectMessage();
                this.m_connection.close(0);
                return;
            }
            catch (EBrokerVersionMismatch e) {
                this.debugDataHandleMgramCorruption(e);
                this.sendErrorMgram(-16, 32);
                this.m_connection.close(0);
                return;
            }
            catch (EUserAlreadyConnected e) {
                if (this.DEBUG || this.DEBUG_UNEXPECTED) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                if (e instanceof EUserAlreadyConnectedPendingReconnect) {
                    this.sendErrorMgram(-40, 0);
                } else {
                    this.sendErrorMgram(-17, 0);
                }
                this.m_connection.close(0);
                return;
            }
            catch (EIPAddressLimitExceeded e) {
                this.logMessage(e);
                this.sendErrorMgram(-35, 0);
                this.m_connection.close(0);
                return;
            }
            catch (EConnectionLimitExceeded e) {
                this.logMessage(e);
                this.sendErrorMgram(-18, 0);
                this.m_connection.close(0);
                return;
            }
            catch (EConnectionNotResumable e) {
                if (this.DEBUG || this.DEBUG_UNEXPECTED) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
                this.sendErrorMgram(-39, 126);
                this.m_connection.close(0);
                return;
            }
            catch (EConnectFailure e) {
                this.logMessage(e);
                int errcode = -22;
                int errinfo = e.getErrorId();
                if (errinfo == 179) {
                    errcode = -23;
                    errinfo = 0;
                    this.publishRejectMessage();
                }
                this.sendErrorMgram(errcode, errinfo);
                this.m_connection.close(0);
                return;
            }
            catch (EMgramFormatError e) {
                this.logMessage(e);
                this.handleMgramCorruption(false);
                if (this.m_connection == null) {
                    return;
                }
                IMgram response = e instanceof EMgramVersionMismatch ? MgramFactory.getMgramFactory().buildErrorMgram(-15, ((EMgramVersionMismatch)e).getVersion(), null, 0) : MgramFactory.getMgramFactory().buildErrorMgram(-20, 0, null, 0);
                if (this.m_failedConnectAttempt) {
                    this.m_connection.getSender().send(response);
                    this.publishRejectMessage();
                    this.stopSender();
                    this.m_connection.close();
                    this.cleanup(0);
                } else {
                    this.m_connection.getSender().send(response);
                    this.publishRejectMessage();
                    this.m_connection.close(0);
                }
                return;
            }
            catch (EUnexpectedMgram e) {
                this.logMessage(e);
                if (this.m_connection == null) {
                    return;
                }
                this.handleMgramCorruption(false);
                this.sendErrorMgram(-19, e.getMgram().getType());
                this.sendRejectionNoticeToAdminSession();
                return;
            }
            catch (EIntegrityCompromised ice) {
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)ice, 2);
                }
                this.handleMgramCorruption(false);
                this.sendRejectionNoticeToAdminSession();
                return;
            }
            catch (EChecksumValidationFailed cvf) {
                this.printDebuggingInfo(cvf);
                this.handleMgramCorruption(false);
                if (this.DEBUG) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)cvf, 2);
                }
                this.sendRejectionNoticeToAdminSession();
                return;
            }
            catch (IOException e) {
                this.logMessage(e);
                if (this.m_connection == null) {
                    return;
                }
                this.sendRejectionNoticeToAdminSession();
                return;
            }
            catch (InterruptedException e) {
                this.logMessage(e);
                this.m_connection.close(0);
                return;
            }
            catch (Exception e) {
                this.logMessage(e);
                this.publishRejectMessage();
                this.m_connection.close(0);
                throw e;
            }
            catch (Error e) {
                this.logMessage(e);
                if (!(e instanceof ThreadDeath)) {
                    this.publishRejectMessage();
                    this.m_connection.close(0);
                } else {
                    this.m_connection.cleanupInstanceStats();
                }
                throw e;
            }
            this.connectSender();
        } else {
            if (this.m_is == null) {
                this.m_is = this.m_socketStream = socket.getInputStream(this.m_connection.getMaxRcvBufferSize(), this.m_connection.getMinRcvBufferSize(), this.m_connection.getInitialRcvBufferSize());
                if (this.DIAG_MGRAM_HISTORY && !this.m_isAdminConnection) {
                    boolean enableCapture = true;
                    if (SessionConfig.CAPTURE_BUFFER_FILTER.length() > 0) {
                        if (this.m_commonCsc != null) {
                            if (this.m_uid == null) {
                                this.m_uid = this.m_commonCsc.getUid();
                            }
                            if (this.m_chan0_appid == null) {
                                this.m_chan0_appid = this.m_commonCsc.getAppid();
                            }
                        }
                        if (this.m_uid != null || this.m_chan0_appid != null) {
                            enableCapture = SessionConfig.matchCaptureFilterToUidAppid(this.m_uid, this.m_chan0_appid);
                        }
                    }
                    if (enableCapture) {
                        CaptureInputStream cis = new CaptureInputStream(this.m_socketStream, SessionConfig.LISTENER_CAPTURE_BUFFER_SIZE);
                        this.m_is = cis;
                        this.m_cb = cis.getCaptureBuffer();
                    }
                }
                this.secureInputStreamUntilHandshakeComplete();
            }
            if (Config.ENABLE_QOPSECURITY) {
                byte[] sessKey = this.m_connection.getSecurityContext(0).getSessionKey();
                sp.m_mp.init(2, sessKey);
            }
        }
        try {
            cc = s_reg.getClient(this.getClientId(0));
            this.m_ccs.setElementAt(cc, 0);
            this.setThreadName();
            AgentListener.indicateMinPublishPriorityReinstate(cc);
            sp.setClientContext(cc);
        }
        catch (EClientNotRegistered e) {
            if (Broker.isInShutdown()) {
                return;
            }
            String mf352 = prAccessor.getString("STR002");
            Object[] ob352 = new Object[]{this.m_commonCsc.getUid()};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(mf352, ob352), 2);
            this.handleError(e);
            return;
        }
        int pingTimeout = 0;
        boolean logPingTimeouts = false;
        try {
            if (!this.m_isAdminConnection) {
                int appid = AddrUtil.clientIdToAppid(cc.getId());
                if (cc.getAppid().endsWith("$CONNECTION$")) {
                    pingTimeout = Config.BROKER_PING_TIMEOUT;
                } else if (appid == Config.BROKER_APPID_SCODE || appid == InterbrokerConfig.BROKER_CONNECT_APPID_SCODE) {
                    pingTimeout = Config.CLUSTER_PING_TIMEOUT;
                    logPingTimeouts = true;
                } else if (appid == FailoverConfig.RM_CONNECT_APPID_SCODE || appid == FailoverConfig.RM_PRIMARY_APPID_SCODE || appid == FailoverConfig.RM_BACKUP_APPID_SCODE) {
                    pingTimeout = Config.FT_PING_TIMEOUT;
                    logPingTimeouts = true;
                }
            }
            if (pingTimeout > 0) {
                socket.setSoTimeout(pingTimeout);
                if (this.checkDebugFlags(4)) {
                    this.logDebug(4, "setting socket timeout " + Config.BROKER_PING_TIMEOUT + " milliseconds.");
                }
            } else {
                socket.setSoTimeout(0);
            }
            this.mainLoop();
        }
        catch (IOException e) {
            if (e instanceof SocketTimeoutException && pingTimeout > 0 && logPingTimeouts) {
                Object[] objectArray = new Object[1];
                objectArray[0] = this.m_connection instanceof ReplicationChannel ? (Config.PRIMARY ? "BACKUP" : "PRIMARY") : cc.getUid();
                Object[] params = objectArray;
                String msg = MessageFormat.format(prAccessor.getString("DETECTED_PING_TIMEOUT"), params);
                BrokerComponent.getComponentContext().logMessage(msg, (Throwable)e, 2);
            }
            if (this.DEBUG) {
                this.logDebug(32, "mainLoop caught " + e);
            }
            if (this.checkDebugFlags(4)) {
                this.logDebug(4, "mainLoop caught " + e + " at " + System.currentTimeMillis());
            }
            this.fatalError(null);
        }
        catch (Exception e) {
            this.handleError(e);
            throw e;
        }
        catch (Error e) {
            if (!(e instanceof ThreadDeath)) {
                this.fatalError(null);
            } else {
                this.m_connection.cleanupInstanceStats();
                this.m_connection.cleanupAcceptorConnection();
            }
            throw e;
        }
    }

    private <T0 extends Throwable> void logMessage(T0 e) {
        if (this.DEBUG) {
            BrokerComponent.getComponentContext().logMessage(e, 2);
        }
    }

    private <T0 extends Exception> void handleError(T0 e) {
        if (this.DEBUG) {
            BrokerComponent.getComponentContext().logMessage(e, 2);
        }
        this.fatalError(null);
    }

    private void sendRejectionNoticeToAdminSession() {
        this.publishRejectMessage();
        if (this.m_failedConnectAttempt) {
            this.stopSender();
            this.m_connection.close();
            this.cleanup(0);
        } else {
            this.m_connection.close(0);
        }
    }

    private void secureInputStreamUntilHandshakeComplete() {
        if (this.m_commonMp != null) {
            this.m_sis = this.m_commonMp.isSonicCipherSuite() ? new SecureInputStream(this.m_is, this.m_commonMp, new byte[SessionConfig.IO_SECURITY_BUFFER_SIZE]) : new PluggableSecureInputStream(this.m_is, this.m_commonMp, new byte[SessionConfig.IO_SECURITY_BUFFER_SIZE]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForMainLoop() throws InterruptedException {
        if (!this.isAlive() || this.isShuttingDown()) {
            Object object = this.m_mainLoopNotify;
            synchronized (object) {
                return this.m_reachedMainLoop;
            }
        }
        Object object = this.m_mainLoopNotify;
        synchronized (object) {
            while (!this.m_reachedMainLoop && !this.m_exited) {
                this.m_mainLoopNotify.wait();
            }
            return this.m_reachedMainLoop;
        }
    }

    protected synchronized void cleanup(int channel) {
        this.m_ccs.setElementAt(null, channel);
        this.m_scratchPads.setElementAt(null, channel);
    }

    protected void setThreadName() {
        this.setThreadNameHelper();
    }

    private void setThreadNameHelper() {
        Object cc;
        StringBuilder threadNameBuf = new StringBuilder(this.m_threadNamePrefix);
        String ccClass = null;
        if (this.m_ccs.size() > 0 && (cc = this.m_ccs.elementAt(0)) != null) {
            ccClass = cc.getClass().getSimpleName();
        }
        if (ccClass == null) {
            ccClass = "ClientContext";
        }
        threadNameBuf.append(" ").append(ccClass);
        if (null != this.m_commonCsc) {
            threadNameBuf.append(" ").append(this.m_commonCsc.getClientId()).append(":").append(this.m_commonCsc.getUid()).append(":").append(this.m_commonCsc.getAppid());
        }
        this.setThreadName(threadNameBuf.toString());
    }

    protected final void setThreadName(String threadName) {
        this.setThreadNameHelper(threadName);
    }

    private void setThreadNameHelper(String threadName) {
        if (DebugState.GLOBAL_DEBUG_ON) {
            this.debugName(threadName);
        }
        try {
            this.setName(threadName);
        }
        catch (SecurityException se) {
            this.logDebug(8192, "Unexpected exception: " + se);
        }
    }

    protected synchronized void fatalError(IMgram m) {
        this.fatalError(m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void fatalError(IMgram m, boolean disableReconnects) {
        int size = this.m_ccs.size();
        if (s_qproc == null) {
            Object object = QPROC_LOCK_OBJ;
            synchronized (object) {
                if (s_qproc == null) {
                    s_qproc = s_reg.getQueueProc();
                }
            }
        }
        for (int channel = 0; channel < size; ++channel) {
            IClientContext cc = (IClientContext)this.m_ccs.elementAt(channel);
            if (cc == null) continue;
            if (disableReconnects) {
                AgentListener.sRegPrepareDisconnect(cc);
            }
            if (m != null && m.getChannel() == channel) {
                this.m_connection.getSender().send(m);
                if (this.checkDebugFlags(64)) {
                    this.logDebug(64, "*****fatalError (m); m!=null; type= " + m.getType());
                }
                s_reg.disconnect(this.getClientId(channel), false, true, this.m_connection);
            } else {
                s_reg.disconnect(this.getClientId(channel), false, true, this.m_connection);
            }
            this.cleanup(channel);
        }
        this.m_connection.close();
    }

    protected void fatalError(IMgram m, int channel) {
        if (m == null) {
            s_reg.disconnect(this.getClientId(channel), false, true, this.m_connection);
        } else {
            this.m_connection.getSender().send(m);
            if (this.checkDebugFlags(64)) {
                this.logDebug(64, "fatalError (m, channel); m!=null; type= " + m.getType());
            }
            s_reg.disconnect(this.getClientId(channel), false, true, this.m_connection);
        }
        this.cleanup(channel);
        this.m_connection.close(channel);
    }

    private void sendConnectSuccessReply(BrokerConnectHandshaker handshaker) throws IOException, InterruptedException {
        ClientSecurityContext csc = this.m_connection.getSecurityContext(0);
        if (csc == null) {
            if (Broker.isInShutdown()) {
                throw new InterruptedException();
            }
            throw new AssertionError((Object)"Internal error: csc is null in sendConnectSuccessReply");
        }
        ConnectData cd = new ConnectData(csc, Config.BROKER_NAME, s_reg.getCollective(), this.m_connection.getSocketId());
        this.m_connection.getSender().send(handshaker.buildSuccessMgram(cd));
    }

    private void sendErrorMgram(int errcode, int errinfo) {
        this.m_connection.getSender().send(MgramFactory.getMgramFactory().buildErrorMgram(errcode, errinfo, null, 0));
    }

    private void handleQueueOpenRemoteReceiver(IMgram m) {
        String queueName = m.getSubject().getJMSName();
        IAgentQueue iaq = s_reg.getQueueProc().getAgentQueue(queueName);
        try {
            String selector = m.getPayloadInputStreamHandle().readUTF();
            if (this.DEBUG) {
                this.logDebug(128, "handleQueueOpenRemoteReceiver: queueName = " + queueName + " selector = " + selector);
            }
            if (iaq != null) {
                ((AgentAdministrativelyCreatedQueue)iaq).openRemoteReceiver(this.getClientId(0), selector);
            } else if (this.DEBUG) {
                this.logDebug(128, "handleQueueOpenRemoteReceiver: queueName = " + queueName + " does not exist on this broker");
            }
        }
        catch (IOException ioe) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ioe, 2);
        }
    }

    private void handleQueueCloseRemoteReceiver(IMgram m) {
        String queueName = m.getSubject().getJMSName();
        IAgentQueue iaq = s_reg.getQueueProc().getAgentQueue(queueName);
        try {
            String selector = m.getPayloadInputStreamHandle().readUTF();
            if (this.DEBUG) {
                this.logDebug(128, "handleQueueCloseRemoteReceiver: queueName = " + queueName + " selector = " + selector);
            }
            if (iaq != null) {
                ((AgentAdministrativelyCreatedQueue)iaq).closeRemoteReceiver(this.getClientId(0), selector);
            } else if (this.DEBUG) {
                this.logDebug(128, "handleQueueCloseRemoteReceiver: queueName = " + queueName + " does not exist on this broker");
            }
        }
        catch (IOException ioe) {
            BrokerComponent.getComponentContext().logMessage((Throwable)ioe, 2);
        }
    }

    protected void handlePing(IMgram m) throws EUnexpectedMgram {
        if (m.isRequest()) {
            Sender sender;
            if (this.DEBUG) {
                this.logDebug(128, "Returning PING");
            }
            if ((sender = this.m_connection.getSender()) != null) {
                sender.send(MgramFactory.getMgramFactory().buildPingReply(m));
                if (this.DEBUG) {
                    this.logDebug(128, "PING Returned");
                }
            } else if (this.DEBUG) {
                this.logDebug(128, "Unable to return PING: Sender == null");
            }
        } else if (m.isReply()) {
            s_reg.pingReplyRcvd(this.getClientId(m.getChannel()));
        }
    }

    private void handleVersion(IMgram m) throws EMgramVersionMismatch, IOException {
        byte version = m.getVersion();
        if (version >= 24) {
            this.m_clientMgramVersion = version;
            this.m_connection.getAgentSender().setClientMgramVersion(this.m_clientMgramVersion);
            this.initializeConverter();
            if (m.isPostSV22()) {
                if (Config.ENABLE_COMPRESSION && m.isCompressionEnabled() && !this.m_isAdminConnection) {
                    this.m_compressionFactory = CompressionFactory.getInstance(Config.COMPRESSION_FACTORY);
                    if (m.getCompressionId() != this.m_compressionFactory.getCompressionID()) {
                        if (this.DEBUG) {
                            this.debug("Rejecting compression request for the connection, requested compression id = " + m.getCompressionId() + ", local compression id = " + this.m_compressionFactory.getCompressionID());
                        }
                        this.m_compressionFactory = null;
                    } else if (this.DEBUG) {
                        this.debug("Accepting compression request for the connection, compression cf = " + this.m_compressionFactory.getClass().getName() + ", compression id = " + this.m_compressionFactory.getCompressionID());
                    }
                }
                boolean needCRC = false;
                byte streamVersion = 0;
                byte streamFlags = 0;
                IMgram vm = null;
                if (m.hasStreamVersion() && Config.ENABLE_CHECKSUM && !this.m_isAdminConnection) {
                    streamVersion = m.getStreamVersion();
                    if (StreamFactory.supportsStream(streamVersion, streamFlags = m.getStreamFlags())) {
                        needCRC = true;
                        StreamFactory.setupSegmentedStream(this.m_socketStream, streamVersion, streamFlags, this.m_connection.getSocket(), this.m_connection.getMaxRcvBufferSize(), this.m_connection.getMinRcvBufferSize(), this.m_connection.getInitialRcvBufferSize());
                        if (this.checkDebugFlags(64)) {
                            this.logDebug(64, "Converted to segmented stream; streamVersion= " + streamVersion + " streamFlags= " + streamFlags);
                        }
                        vm = MgramFactory.getMgramFactory().buildVersionMgram(0, this.m_converter.getVersion(), (byte)32, streamVersion, streamFlags);
                        if (this.checkDebugFlags(64)) {
                            this.logDebug(64, "Sent version response;  streamVersion= " + streamVersion + " streamFlags= " + streamFlags);
                        }
                    } else {
                        vm = this.convertInputStreamNotToUseStreams();
                        if (this.checkDebugFlags(64)) {
                            this.logDebug(64, "Sent version response;  requested stream version and/or flags not supported; replying no streams");
                        }
                    }
                } else {
                    vm = this.convertInputStreamNotToUseStreams();
                    if (this.checkDebugFlags(64)) {
                        this.logDebug(64, "Sent version response;  no streams");
                    }
                }
                if (!needCRC) {
                    streamVersion = 0;
                    streamFlags = 0;
                }
                if (this.m_compressionFactory != null) {
                    vm.setCompressionEnabled(true);
                    vm.setCompressionId(this.m_compressionFactory.getCompressionID());
                    if (DebugState.getDiagnosticFlags("IMetricsListener") > 0) {
                        this.m_metricsListener = this.m_connection;
                    }
                    InputStream cis = this.m_compressionFactory.getInflaterInputStream(this.m_compressionStreamWrapper.getInputStream(), this.m_metricsListener);
                    this.m_compressionStreamWrapper.setInputStream(cis);
                }
                if (needCRC || this.m_compressionFactory != null) {
                    this.m_connection.getAgentSender().sendThrough(vm);
                } else {
                    this.m_connection.getAgentSender().send(vm);
                }
                this.m_connection.getAgentSender().convertStream(streamVersion, streamFlags, this.m_compressionFactory);
            } else {
                this.m_connection.getSender().send(MgramFactory.getMgramFactory().buildVersionMgram(0, this.m_converter.getVersion()));
            }
        } else {
            throw new EMgramVersionMismatch(m.getVersion());
        }
    }

    private IMgram convertInputStreamNotToUseStreams() throws IOException {
        StreamFactory.setupSegmentedStream(this.m_socketStream, (byte)0, (byte)0, this.m_connection.getSocket(), this.m_connection.getMaxRcvBufferSize(), this.m_connection.getMinRcvBufferSize(), this.m_connection.getInitialRcvBufferSize());
        return MgramFactory.getMgramFactory().buildVersionMgram(0, this.m_converter.getVersion(), (byte)32);
    }

    protected void handleNormal(IMgram m) throws EIntegrityCompromised, InterruptedException {
        this.handleNormal(m, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNormalTxn(IMgram m, AMPScratchPad scr) throws EIntegrityCompromised, InterruptedException {
        Object object = this.m_synchvar;
        synchronized (object) {
            AMPScratchPad sp = (AMPScratchPad)this.m_scratchPads.elementAt(m.getChannel());
            if (sp == null) {
                sp = scr;
                if (this.checkDebugFlags(64)) {
                    this.logDebug(64, "handleNormalTxn: ScratchPad is null; using scratchpad from tm");
                }
            } else {
                IClientContext publisher = sp.m_publisher;
                if (publisher == null && (publisher = scr.m_publisher) != null) {
                    if (publisher.needsGuarAck()) {
                        sp.m_forceDeliverOnFlush = true;
                    }
                    if (!Config.REPLICATED && m.isNonPersistentReplicated()) {
                        sp.m_forceDeliverOnFlush = false;
                    }
                }
            }
            this.handleNormal(m, sp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNormal(IMgram m, AMPScratchPad spParam) throws EIntegrityCompromised, InterruptedException {
        AMPScratchPad sp = spParam;
        Object object = this.m_synchvar;
        synchronized (object) {
            if (Config.ENABLE_QOPSECURITY && !m.isSecure()) {
                throw new EIntegrityCompromised();
            }
            m.getCorrectedRemoteNode(Config.ROUTING_NODE_NAME);
            if (Config.ENABLE_SECURITY && m.isSecure()) {
                byte oldAttr = m.getSecurity();
                byte attr = s_msgproc.handleQopSecurity(m, this.m_isRouter);
                m.setSecurityAttribute(attr);
            }
            if (sp == null) {
                sp = (AMPScratchPad)this.m_scratchPads.elementAt(m.getChannel());
            }
            s_msgproc.newMgram(m, sp);
        }
    }

    protected AMPScratchPad getScratchPad(IMgram m) {
        return (AMPScratchPad)this.m_scratchPads.elementAt(m.getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDisconnect(IMgram mgram) throws EUnexpectedMgram, IOException {
        IClientContext clientContext = (IClientContext)this.m_ccs.elementAt(mgram.getChannel());
        boolean idleTimeout = AgentListener.isIdleTimeout(clientContext);
        int reason = 1;
        if (mgram.isReply()) {
            boolean disconnectRejected;
            boolean bl = disconnectRejected = mgram.getRawBody()[0] != 0;
            if (this.checkDebugFlags(4)) {
                this.logDebug(4, "Received disconnect reply");
            }
            if (clientContext != null && disconnectRejected) {
                if (idleTimeout) {
                    if (this.checkDebugFlags(4)) {
                        this.logDebug(4, "Disconnect request has been rejected by the remote side - cancelling timeout");
                    }
                    this.m_connection.cancelTimeOut();
                }
                return;
            }
            if (idleTimeout) {
                reason = 3;
            }
        } else if (mgram.isRequest()) {
            boolean forceDisconnect;
            boolean bl = forceDisconnect = mgram.getRawBody()[0] != 0;
            if (forceDisconnect) {
                if (this.checkDebugFlags(4)) {
                    this.logDebug(4, "Received unconditional disconnect request");
                }
            } else {
                if (this.checkDebugFlags(4)) {
                    this.logDebug(4, "Received disconnect request");
                }
                AgentConnection agentConnection = this.m_connection;
                synchronized (agentConnection) {
                    if (this.sendDisconnectReply(mgram, clientContext, idleTimeout)) {
                        return;
                    }
                }
            }
            if (idleTimeout) {
                reason = 2;
            }
        } else {
            throw new EUnexpectedMgram(mgram);
        }
        this.disconnect(mgram, reason);
        this.cleanup(mgram.getChannel());
        this.sendSuccessDisconnectReply(mgram, idleTimeout);
        this.m_connection.close(mgram.getChannel());
    }

    private boolean sendDisconnectReply(IMgram mgram, IClientContext clientContext, boolean idleTimeout) throws IOException {
        if (idleTimeout && this.m_connection.hasTimedOut()) {
            if (this.checkDebugFlags(4)) {
                this.logDebug(4, "Connection has already timed out on this side - not checking the out queue");
            }
        } else if (clientContext != null && !clientContext.isMgramQueueEmpty()) {
            if (this.checkDebugFlags(4)) {
                this.logDebug(4, "Out queue not empty - rejecting disconnect request");
            }
            this.m_connection.getAgentSender().sendThrough(MgramFactory.getMgramFactory().buildDisconnectReply(mgram.getChannel(), true));
            return true;
        }
        return false;
    }

    private void disconnect(IMgram mgram, int reason) {
        try {
            s_reg.prepareDisconnect(this.getClientId(mgram.getChannel()), reason);
        }
        catch (EClientNotRegistered ex) {
            this.debug("Exception on prepareDisconnect", ex);
        }
        s_reg.disconnect(this.getClientId(mgram.getChannel()), false);
    }

    private void sendSuccessDisconnectReply(IMgram mgram, boolean idleTimeout) {
        if (mgram.isRequest()) {
            boolean alreadyTimedOut = this.isAlreadyTimedOut(idleTimeout);
            if (alreadyTimedOut) {
                if (this.checkDebugFlags(4)) {
                    this.logDebug(4, "Connection has already timed out on this side");
                }
            } else {
                if (this.checkDebugFlags(4)) {
                    this.logDebug(4, "Sending accept disconnect reply");
                }
                this.m_connection.getSender().send(MgramFactory.getMgramFactory().buildDisconnectReply(mgram.getChannel(), false));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAlreadyTimedOut(boolean idleTimeout) {
        boolean alreadyTimedOut = false;
        if (idleTimeout) {
            AgentConnection agentConnection = this.m_connection;
            synchronized (agentConnection) {
                if (this.m_connection.hasTimedOut()) {
                    alreadyTimedOut = true;
                } else {
                    if (this.checkDebugFlags(4)) {
                        this.logDebug(4, "Connection timed out on the remote side");
                    }
                    this.m_connection.setTimedOut();
                }
            }
        }
        return alreadyTimedOut;
    }

    private static boolean isIdleTimeout(IClientContext clientContext) {
        boolean idleTimeout = false;
        if (clientContext != null && clientContext.isRemoteBroker()) {
            idleTimeout = true;
        }
        return idleTimeout;
    }

    protected void handleAckList(IMgram m) throws InterruptedException {
        this.handleAckSubList(m.getAckListHandle().getPtpList(), m);
        this.handleAckSubList(m.getAckListHandle().getPubSubList(), m);
    }

    private void handleAckSubList(Collection c, IMgram m) throws InterruptedException {
        if (c != null) {
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                IMgram subAck = (IMgram)iter.next();
                long clientId = this.getClientId(subAck.getChannel());
                subAck.getBrokerHandle().setSenderID(clientId);
                if (!iter.hasNext() && m.isGuarenteed()) {
                    subAck.setGuarenteed(m.getGuarenteedTrackingNum());
                }
                this.handleAck(subAck);
            }
        }
    }

    private void handleWindowAckAck(IMgram m) {
        IWindowAckHandle ackHandle = m.getWindowAckHandle();
        long receiptTracking = ackHandle.getReceiptTrackingNumber();
        long storageTracking = ackHandle.getStorageTrackingNumber();
        int tid = ackHandle.getTxnId();
        IClientContext cc = (IClientContext)this.m_ccs.elementAt(m.getChannel());
        if (cc != null && cc.isXOnce()) {
            if (this.DEBUG) {
                this.logDebug(128, "Received window ack ack for " + cc + ", tid = " + tid + ", receipt tracking: " + receiptTracking + ", storage tracking: " + storageTracking);
            }
            cc.getWindowAckManager().receivedWindowAckAck(tid, receiptTracking, storageTracking);
        }
    }

    protected void handleAck(IMgram m) throws InterruptedException {
        IClientContext cc = (IClientContext)this.m_ccs.elementAt(m.getChannel());
        if (cc != null && this.m_clientSessionVer < 28 && m.getType() == 3) {
            try {
                cc.convertLegacySubjectAck(m);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (m.hasTxn()) {
            s_txnmgr.newMgram(m);
        } else if (cc != null) {
            cc.acknowledge(m);
        }
    }

    protected void handleOperation(IMgram opMgram) throws IOException, EUnexpectedMgram, EIntegrityCompromised, InterruptedException {
        try {
            IOperationHandle iOpHandle = opMgram.getOperationHandle();
            switch (iOpHandle.getOperationType()) {
                case 12: {
                    this.handleOperationDurableTrackingMgram(opMgram, iOpHandle);
                    break;
                }
                case 1: {
                    s_reg.getCWADSMsgHandler().handleFirstMessageNotification(opMgram);
                    break;
                }
                case 2: {
                    s_reg.getCWADSMsgHandler().handleLastMessageNotification(opMgram);
                    break;
                }
                case 21: {
                    s_reg.getCWADSMsgHandler().handleDeliveryFinishedNotification(opMgram);
                    break;
                }
                case 3: {
                    this.handleSingleTargetOp(opMgram);
                    break;
                }
                case 20: {
                    s_reg.getCWADSMsgHandler().handleRemoteRestorePhasesDoneMgram(opMgram);
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    throw new EAssertFailure(UNKNOWN_OPERATION_TYPE + opMgram.getOperationHandle().getOperationType());
                }
                case 25: {
                    this.handleOperationWrappedGuarFormat(opMgram);
                    break;
                }
                case 27: {
                    this.handleUndeliverableOp(opMgram);
                    break;
                }
                case 31: {
                    this.handleOperationDiagOp(opMgram);
                    break;
                }
                default: {
                    this.handleDefaultOperation(opMgram);
                    break;
                }
            }
        }
        catch (EClientNotRegistered e) {
            this.handleException(e);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    private void handleException(Exception exception) {
        if (this.DEBUG) {
            BrokerComponent.getComponentContext().logMessage((Throwable)exception, 2);
        }
    }

    private void handleOperationDurableTrackingMgram(IMgram opMgram, IOperationHandle iOpHandle) throws IOException, EClientNotRegistered {
        ObjectInput input = opMgram.getPayloadInputStreamHandle();
        input.readByte();
        String tracking = input.readUTF();
        IMgram durableMgram = (IMgram)iOpHandle.getMgramList().getFirst();
        durableMgram.getBrokerHandle().setSenderID(opMgram.getBrokerHandle().getSenderID());
        this.handleDurableOperation(durableMgram, tracking);
    }

    private void handleOperationWrappedGuarFormat(IMgram opMgram) throws EIntegrityCompromised, InterruptedException, EAssertFailure {
        IMgram mgram = (IMgram)opMgram.getOperationHandle().getMgramList().getFirst();
        if (mgram != null) {
            if (opMgram.isGuarenteed()) {
                mgram.setGuarenteed(opMgram.getGuarenteedTrackingNum());
            } else {
                mgram.setReliable();
            }
            if (opMgram.isSuccessor()) {
                mgram.setSuccessor(true);
            }
            if (opMgram.getBrokerHandle().isFromRemoteBroker()) {
                mgram.getBrokerHandle().setFromRemoteBroker(true);
            }
        } else {
            throw new EAssertFailure(MISSING_EMBEDDED_MGRAM_IN_WRAPPED_GUAR_FORMAT_MGRAM);
        }
        mgram.getBrokerHandle().setFromDB(false);
        mgram.getBrokerHandle().setSenderID(opMgram.getBrokerHandle().getSenderID());
        mgram.getBrokerHandle().clearTransactionPublish();
        this.handleNormal(mgram);
    }

    private void handleOperationDiagOp(IMgram opMgram) throws IOException {
        ObjectInput input = opMgram.getPayloadInputStreamHandle();
        short type = input.readShort();
        if (input.readShort() == 0) {
            SessionConfig.logMessage(RECEIVED_REQUEST_TO_DUMP_SENDER_MGRAM_HISTORY_FOR + this.getChan0Appid(), SessionConfig.WARNING);
            this.dumpSenderHistory();
        } else {
            SessionConfig.logMessage(RECEIVED_UNRECOGNIZED_DIAGNOSITC_MGRAM_OPERATION + type, SessionConfig.WARNING);
        }
    }

    private void handleDefaultOperation(IMgram opMgram) throws EAssertFailure {
        if (!this.handleUnexpectedMgramType(opMgram, 2)) {
            throw new EAssertFailure(UNKNOWN_OPERATION_TYPE + opMgram.getOperationHandle().getOperationType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDurableOperation(IMgram m, String tracking) throws EClientNotRegistered {
        IOperationHandle iOpHandle = m.getOperationHandle();
        switch (iOpHandle.getOperationType()) {
            case 4: {
                DurableSearchOp dso = new DurableSearchOp(new DurableClientContextReplyQueue(AgentRegistrar.getAgentRegistrar().getClient(m.getBrokerHandle().getSenderID()), tracking), m);
                this.handleDurableRequestOp(dso);
                break;
            }
            case 6: {
                DurableGetMgramOp op = new DurableGetMgramOp(new DurableClientContextReplyQueue(AgentRegistrar.getAgentRegistrar().getClient(m.getBrokerHandle().getSenderID()), tracking), m);
                this.handleDurableRequestOp(op);
                break;
            }
            case 8: {
                DurableBrowseOp op = new DurableBrowseOp(new DurableClientContextReplyQueue(AgentRegistrar.getAgentRegistrar().getClient(m.getBrokerHandle().getSenderID()), tracking), m);
                this.handleDurableRequestOp(op);
                break;
            }
            case 10: {
                DurableRemoveOp op = new DurableRemoveOp(new DurableClientContextReplyQueue(AgentRegistrar.getAgentRegistrar().getClient(m.getBrokerHandle().getSenderID()), tracking), m);
                this.handleDurableRequestOp(op);
                break;
            }
            case 15: {
                CWADSPingOp op = new CWADSPingOp(new DurableClientContextReplyQueue(AgentRegistrar.getAgentRegistrar().getClient(m.getBrokerHandle().getSenderID()), tracking), m);
                this.handleCWADSDurableRequestOp(op);
                break;
            }
            case 17: {
                CWADSListXferOp op = new CWADSListXferOp(new DurableClientContextReplyQueue(AgentRegistrar.getAgentRegistrar().getClient(m.getBrokerHandle().getSenderID()), tracking), m);
                this.handleCWADSDurableRequestOp(op);
                break;
            }
            case 7: {
                DurableGetMgramReplyOp op = new DurableGetMgramReplyOp(m);
                this.handleDurableReplyOp(op, tracking);
                break;
            }
            case 5: {
                DurableSearchReplyOp dso = new DurableSearchReplyOp(m);
                this.handleDurableReplyOp(dso, tracking);
                break;
            }
            case 9: {
                DurableBrowseReplyOp dbo = new DurableBrowseReplyOp(m);
                this.handleDurableReplyOp(dbo, tracking);
                break;
            }
            case 11: {
                DurableRemoveReplyOp dro = new DurableRemoveReplyOp(m);
                this.handleDurableReplyOp(dro, tracking);
                break;
            }
            case 16: {
                CWADSPingReplyOp dro = new CWADSPingReplyOp(m);
                this.handleDurableReplyOp(dro, tracking);
                break;
            }
            case 18: {
                CWADSListXferReplyOp op = new CWADSListXferReplyOp(m);
                this.handleDurableReplyOp(op, tracking);
                break;
            }
            case 28: {
                IClientContext sendercc = AgentRegistrar.getAgentRegistrar().getClient(m.getBrokerHandle().getSenderID());
                DurableTrimOp op = new DurableTrimOp(new DurableClientContextReplyQueue(sendercc, tracking), m, sendercc.getId());
                IClientContext cc = null;
                try {
                    cc = AgentRegistrar.getAgentRegistrar().getClient(op.getClientID());
                    if (cc == null || cc.getDurableCCTracker() == null) break;
                    cc.getDurableCCTracker().setSubscriptionTrimInProgress(true, op);
                    break;
                }
                catch (EClientNotRegistered eClientNotRegistered) {
                    break;
                }
                finally {
                    this.handleDurableRequestOp(op);
                    if (cc != null && cc.getDurableCCTracker() != null) {
                        cc.getDurableCCTracker().setSubscriptionTrimInProgress(false, op);
                    }
                }
            }
            case 29: {
                DurableTrimReplyOp dro = new DurableTrimReplyOp(m);
                this.handleDurableReplyOp(dro, tracking);
                break;
            }
        }
    }

    private void handleDurableReplyOp(IDurableReplyOperation op, String tracking) {
        BrokerJob job = AgentRegistrar.getAgentRegistrar().getDurableManager().getBrokerJob(tracking);
        if (job != null) {
            Neighbor neighbor = Interbroker.getInterbroker().getNeighborByID(this.getClientId(0));
            job.enqueueReply(op, neighbor);
            if (!(op instanceof DurableTrimReplyOp) && op.isComplete()) {
                job.setCompleted();
            }
        }
    }

    private void handleDurableRequestOp(IDurableOperation op) {
        AgentRegistrar.getAgentRegistrar().getMsgSaver().performDurableOperation(op);
    }

    private void handleCWADSDurableRequestOp(IDurableOperation op) {
        AgentRegistrar.getAgentRegistrar().getDurableManager().getDurableOpProcessor().performDurableOperation(op);
    }

    private void handleSingleTargetOp(IMgram m) throws EIntegrityCompromised, IOException, InterruptedException {
        AMPScratchPad sp = (AMPScratchPad)this.m_scratchPads.elementAt(m.getChannel());
        IMgram fwdMgram = (IMgram)m.getOperationHandle().getMgramList().getFirst();
        if (this.DEBUG) {
            this.logDebug(128, "Received Single Target Message: " + fwdMgram.getGuarenteedTrackingNum());
        }
        long clientID = m.getPayloadInputStreamHandle().readLong();
        fwdMgram.getBrokerHandle().setSenderID(m.getBrokerHandle().getSenderID());
        fwdMgram.getBrokerHandle().setFromRemoteBroker(true);
        IClientContext client = null;
        try {
            client = s_reg.getClient(clientID);
        }
        catch (EClientNotRegistered ecnr) {
            try {
                IClientContext sender = s_reg.getClient(m.getBrokerHandle().getSenderID());
                sender.sendAck(fwdMgram.getGuarenteedTrackingNum(), fwdMgram, clientID);
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
            return;
        }
        HashSet<Long> clientFilter = new HashSet<Long>();
        clientFilter.add(new Long(clientID));
        this.retrieveBatchSizeAndUpdateStats(fwdMgram);
        if (Config.ENABLE_QOPSECURITY && !fwdMgram.isSecure()) {
            throw new EIntegrityCompromised();
        }
        if (Config.ENABLE_SECURITY && fwdMgram.isSecure()) {
            fwdMgram.setSecurityAttribute(s_msgproc.handleQopSecurity(fwdMgram, this.m_isRouter));
        }
        fwdMgram.getBrokerHandle().clearTransactionPublish();
        client.rcvdSingleTargetMsg(fwdMgram);
        if (this.CALLBACK) {
            this.callback("AgentListener", 103, new Object[]{this.m_connection, m});
        }
        s_msgproc.newMgram(fwdMgram, sp, clientFilter);
    }

    private void handleUndeliverableOp(IMgram m) throws IOException, EUnexpectedMgram, InterruptedException {
        IMgram wrappedMg;
        ObjectInput dis = m.getPayloadInputStreamHandle();
        short reason = dis.readShort();
        if (reason != -41 && !this.handleUnexpectedMgramType(m, 2)) {
            throw new EUnexpectedMgram(m);
        }
        if (this.checkDebugFlags(64)) {
            this.logDebug(64, "handleUndeliverableOp starting");
        }
        if ((wrappedMg = (IMgram)m.getOperationHandle().getMgramList().getFirst()).getType() == 28) {
            Iterator iter;
            Collection c = wrappedMg.getAckListHandle().getPtpList();
            if (c != null && (iter = c.iterator()).hasNext()) {
                IMgram subAck = (IMgram)iter.next();
                IClientContext cc = (IClientContext)this.m_ccs.elementAt(subAck.getChannel());
                subAck.getAckHandle().setErr(reason);
                subAck.getBrokerHandle().setAckNoReply(true);
                if (this.checkDebugFlags(64)) {
                    this.logDebug(64, "handleUndeliverableOp:  about to call acknowledgeQueue; trk= " + subAck.getAckHandle().getTrackingNumber() + " cc= " + cc.toString());
                }
                cc.acknowledgeQueue(subAck.getAckHandle().getTrackingNumber(), false, subAck);
                cc.sendThrough(MgramFactory.getMgramFactory().buildAck(m.getGuarenteedTrackingNum(), (short)0, m.getChannel()));
                if (this.checkDebugFlags(64)) {
                    this.logDebug(64, "handleUndeliverableOp:  processed QueueAck trk= " + subAck.getAckHandle().getTrackingNumber());
                }
                return;
            }
            c = wrappedMg.getAckListHandle().getPubSubList();
            if (c != null) {
                throw new EAssertFailure("HandleUndeliverableOp: support for pubsub acks not implemented yet");
            }
        } else {
            throw new EAssertFailure("HandleUndeliverableOp: support for wrappedMg.getType()= " + wrappedMg.getType() + " not implemented yet");
        }
    }

    private void addUserToGroup() {
        if (!Config.ENABLE_SECURITY || this.m_user.isInternalPrincipal()) {
            return;
        }
        SecurityBean secBean = s_reg.getSecurityBean();
        if (secBean == null) {
            return;
        }
        Vector groupNames = secBean.getGroupNames();
        if (groupNames == null) {
            return;
        }
        ArrayList usersOldExternalGroups = new ArrayList();
        for (int i = 0; i < groupNames.size(); ++i) {
            ArrayList externalGroupList;
            ProgressPasswordUser user;
            ProgressGroup group = secBean.getGroup((String)groupNames.get(i));
            if (group == null || (user = secBean.getUser(this.m_user.getName())) == null || (externalGroupList = user.getExternalGroups()) == null) continue;
            for (Object externalGroupName : externalGroupList) {
                usersOldExternalGroups.add(externalGroupName);
            }
            Enumeration enumeration = group.members();
            while (enumeration.hasMoreElements()) {
                ProgressPasswordUser p;
                Object element = enumeration.nextElement();
                if (!(element instanceof ProgressPasswordUser) || (p = (ProgressPasswordUser)element).isInternalPrincipal() || !p.getName().equals(user.getName()) || !p.isCreatedDueToACLEntry()) continue;
                group.removeMember(user);
            }
        }
        AgentRegistrar.getAgentRegistrar().processExternalUsersAndGroupMap(this.m_user);
    }

    private void connectClient(BrokerConnectHandshaker handshaker) throws EUserAlreadyConnected, EConnectionLimitExceeded, EConnectFailure, InterruptedException, IOException {
        if (this.m_connection.getSecurityContext(0) != null) {
            throw new EAssertFailure("AgentListener.connectClient(): m_connection.m_csc != null");
        }
        this.m_user = handshaker.getUser();
        this.getFilterData().add(FilterTypeEnumeration.USERID, this.m_user.getName());
        ArrayList externalGroup = this.m_user.getExternalGroups();
        boolean isInternalUser = this.m_user.isInternalPrincipal();
        boolean isCreatedDueToACLEntry = this.m_user.isCreatedDueToACLEntry();
        this.m_user = new ProgressPasswordUser(this.m_user.getName(), this.m_user.getTestPattern());
        this.m_user.setExternalGroups(externalGroup);
        this.m_user.setInternalPrincipal(isInternalUser);
        this.m_user.setCreatedDueToACLEntry(isCreatedDueToACLEntry);
        this.addUserToGroup();
        String appid = handshaker.getAppid();
        this.getFilterData().add(FilterTypeEnumeration.CONNID, appid);
        this.m_masterSecret = handshaker.getMasterSecret();
        String uid = this.m_user.getName();
        long clientId = AddrUtil.stringToClientId(uid, appid);
        this.m_connection.setResumed(handshaker.isResumedConnection());
        if (Config.ENABLE_QOPSECURITY) {
            AMPScratchPad sp = (AMPScratchPad)this.m_scratchPads.elementAt(0);
            this.m_rawMacKey = sp.m_mp.generateDigestKey(this.m_masterSecret);
            this.m_rawSessionKey = sp.m_mp.generateSessionKey(this.m_masterSecret, SessionConfig.getKeyBits());
            sp.m_mp.init(2, this.m_rawSessionKey);
            this.m_connection.getAgentSender().initMessageProtection(this.m_rawSessionKey);
        }
        ClientSecurityContext csc = new ClientSecurityContext(this.m_user, uid, appid, clientId, Config.ENABLE_SECURITY, Config.ENABLE_QOPSECURITY, this.m_rawMacKey, this.m_rawSessionKey, -1L);
        AgentListener.configDirectedAddr(appid, clientId, csc, uid);
        boolean ft = this.m_connection.getFaultTolerant();
        csc.setFaultTolerant(ft);
        csc.setClientIPAddress(this.m_connection.getHostIpAddrStr());
        if (ft) {
            csc.setFaultTolerantReconnectTimeout(this.m_connection.getClientConnectParms().getFaultTolerantReconnectTimeout());
        }
        this.m_commonCsc = csc;
        if (!appid.equals("Broker connect") && !RouterManager.isRouterAppID(appid)) {
            this.m_connection.checkLimits(0, appid, csc);
        }
        this.m_connection.connectSuccess(0, csc, clientId);
        this.setThreadName();
        if (this.m_connection.getResumed()) {
            s_reg.resume(this.getClientId(0), this.m_connection, false);
        } else {
            s_reg.connect(this.getClientId(0), this.m_connection, false);
        }
        AgentConnection.releaseConnectionCounts(clientId, null);
        if (handshaker.getBrokerConnectParms() != null) {
            this.m_connection.setNegotiatedConnectParms(NegotiatedConnectParms.buildNegotiatedConnectParms(handshaker.getBrokerConnectParms()));
        }
        this.sendConnectSuccessReply(handshaker);
        this.m_connection.getAgentSender().setClientMgramVersion(this.m_clientMgramVersion);
    }

    public void initMessageProtection(byte[] rawSessionKey) {
        AMPScratchPad sp = (AMPScratchPad)this.m_scratchPads.elementAt(0);
        sp.m_mp.init(2, rawSessionKey);
    }

    protected void stopSender() {
        this.m_connection.getSender().stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preconnectLoop(BrokerConnectHandshaker handshaker) throws EBrokerVersionMismatch, EMgramFormatError, EUnexpectedMgram, IOException, InterruptedException {
        IMgram m;
        block12: while (true) {
            m = null;
            try {
                m = this.m_converter.createMgram(this.m_is);
            }
            catch (EIntegrityCompromised ice) {
                this.m_failedConnectAttempt = true;
                throw ice;
            }
            catch (IOException ioe) {
                this.m_failedConnectAttempt = true;
                throw ioe;
            }
            catch (EMgramFormatError mfe) {
                this.m_failedConnectAttempt = true;
                throw mfe;
            }
            if ((this.debugFlags & 1) > 0) {
                PrintStream log;
                PrintStream printStream = log = SessionConfig.getLog();
                synchronized (printStream) {
                    this.logDebug(1, "RECEIVED Mgram:");
                    m.dump();
                }
            }
            if (this.CALLBACK) {
                this.callback("AgentListener", 100, new Object[]{this.m_connection, m});
            }
            switch (m.getType()) {
                case 0: {
                    this.handlePing(m);
                    continue block12;
                }
                case 4: {
                    this.handleVersion(m);
                    continue block12;
                }
                case 1: {
                    boolean client = handshaker.isClientHello(m);
                    if (!client) {
                        throw new EUnexpectedMgram(m);
                    }
                    this.m_clientSessionVer = m.getRawBody()[1];
                    ConnectionFailoverStatus cfs = BrokerStateManager.getBrokerStateManager().getConnectionFailoverStatus(this.m_connection);
                    if (handshaker.isFaultToleranceRequested()) {
                        this.m_connection.setFaultTolerant(true);
                    }
                    ClientConnectParms ccp = handshaker.getClientConnectParms();
                    this.m_connection.setClientConnectParms(ccp);
                    if (ccp != null) {
                        this.m_connection.setPartnerProductVersion(ccp.getProductVersion());
                    }
                    long txBufferSize = Config.TXN_BUFFER_SIZE;
                    handshaker.setBrokerConnectParms(new BrokerConnectParms(txBufferSize, this.faultToleranceLicensed(), Config.FT_REPLICATE_NON_PERSISTENT, ccp, Config.CLIENT_DEFAULT_FC_MONITOR_INTERVAL, BrokerLicenseMgr.getLicenseMgr().isEnterpriseEdition()));
                    if (this.m_connection != s_reg.getAgentConnection() && this.m_clientSessionVer >= 27) {
                        this.m_connection.getSender().send(MgramFactory.getMgramFactory().buildFailoverStatusNotification(cfs.getState(), cfs.getLocalURLs(), cfs.getStandbyURLs()));
                    } else if (this.m_connection != s_reg.getAgentConnection() && this.m_clientSessionVer >= 25) {
                        this.m_connection.getSender().send(MgramFactory.getMgramFactory().buildFailoverStatusNotification(cfs.getState(), null, null));
                    } else if (cfs != null && this.m_clientSessionVer < 27 && !BrokerStateManager.isActive(cfs.getState())) {
                        this.m_failedConnectAttempt = true;
                        throw new IOException("Broker not is active state.");
                    }
                    if (handshaker.isLoadBalancingRequested()) {
                        ConnectionContext cctx = new ConnectionContext();
                        cctx.setAcceptorName(this.m_connection.getSocket().getAcceptorName());
                        cctx.setClientData(handshaker.getClientData());
                        if (handshaker.getExtendedClientData() != null) {
                            cctx.setJMSClientID(handshaker.getExtendedClientData().getJMSClientID());
                            cctx.setConnectID(handshaker.getExtendedClientData().getConnectID());
                            cctx.setLocalClientHost(handshaker.getExtendedClientData().getLocalClientHost());
                        }
                        cctx.setClientPort(this.m_connection.getSocket().getLocalPort());
                        if (Config.ENABLE_REVERSE_DNS_LOOKUP) {
                            cctx.setClientHost(this.m_connection.getSocket().getInetAddress().getHostName());
                        }
                        for (ILoadBalancer lb = s_reg.getLoadBalancer(); lb != null && !lb.onConnect(cctx); lb = lb.getNext()) {
                        }
                        String newBrokerURL = cctx.getNewBrokerURL();
                        this.m_connection.getSender().send(BrokerConnectHandshaker.buildBrokerRedirectedReply(newBrokerURL));
                        if (newBrokerURL != null) {
                            BrokerManagementNotificationsHelper.sendConnectionRedirectNotification(Config.BROKER_NAME, newBrokerURL, this.m_connection.getHostIpAddrStr());
                            throw new EBrokerRedirected(newBrokerURL);
                        }
                    }
                    return;
                }
            }
            if (!this.handleUnexpectedMgramType(m, 0)) break;
        }
        throw new EUnexpectedMgram(m);
    }

    private boolean faultToleranceLicensed() {
        return BrokerLicenseMgr.getLicenseMgr().isFaultToleranceAllowed();
    }

    protected void connectSender() throws Exception {
        try {
            this.m_connection.getSocket().startProgressRenegotiate();
            this.m_connection.getSender().send(MgramFactory.getMgramFactory().buildPingRequest(this.getNegotiateLayLoad(), 0));
            s_reg.postConnect(this.getClientId(0), 0);
        }
        catch (EIntegrityCompromised ec) {
            this.logWarning(ec);
            if (this.DEBUG) {
                this.logDebug(32, "Integrity Compromised on Mgram from Client:  " + this.getClientId(0));
            }
            this.fatalError(MgramFactory.getMgramFactory().buildErrorMgram(-3, 0, null, 0));
        }
        catch (IOException e) {
            if (this.DEBUG) {
                this.logDebug(32, "caught " + e);
            }
            this.fatalError(null);
        }
        catch (Exception e) {
            this.fatalError(null);
            throw e;
        }
        catch (Error e) {
            if (!(e instanceof ThreadDeath)) {
                this.fatalError(null);
            } else {
                this.m_connection.cleanupInstanceStats();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectLoop(BrokerConnectHandshaker handshaker) throws EInauthenticClient, EUserAlreadyConnected, EConnectionLimitExceeded, EConnectFailure, EUnexpectedMgram, EMgramFormatError, IOException, InterruptedException {
        handshaker.connectBroker(s_reg, false, Config.ENABLE_SECURITY);
        try {
            String appid;
            while (!handshaker.isDone()) {
                IMgram m = this.m_converter.createMgram(this.m_is);
                if (this.CALLBACK) {
                    this.callback("AgentListener", 101, new Object[]{this.m_connection, m});
                }
                if ((this.debugFlags & 1) > 0) {
                    PrintStream log;
                    PrintStream printStream = log = SessionConfig.getLog();
                    synchronized (printStream) {
                        this.logDebug(1, "RECEIVED Mgram:");
                        m.dump();
                    }
                }
                switch (m.getType()) {
                    case 1: {
                        handshaker.handleConnectMgram(m);
                        break;
                    }
                    case 0: {
                        this.handlePing(m);
                        break;
                    }
                    default: {
                        if (this.handleUnexpectedMgramType(m, 0)) break;
                        throw new EUnexpectedMgram(m);
                    }
                }
                if (!this.DEBUG) continue;
                this.logDebug(128, "got mgram type " + m.getType() + ", size " + m.getBodyLength());
            }
            if (this.m_connection.getFaultTolerant() && !this.faultToleranceLicensed()) {
                this.m_connection.setFaultTolerant(false);
                appid = handshaker.getAppid();
                String user = handshaker.getUser().getName();
                if (!this.isInternalAppid(appid)) {
                    Object[] obj = new Object[]{user, appid};
                    String desc = prAccessor.getString("FT_NOT_LICENCED_DOWNGRADE");
                    BrokerComponent.getComponentContext().logMessage(MessageFormat.format(desc, obj), 3);
                }
            }
            this.connectClient(handshaker);
            appid = handshaker.getAppid();
            if (appid != null && appid.indexOf("$CONNECTION$") >= 0) {
                AgentConnection.setMostRecentClientConnectTime();
            }
        }
        finally {
            this.m_uid = handshaker.getUid();
            this.m_chan0_appid = handshaker.getAppid();
            if (this.m_cb != null && SessionConfig.CAPTURE_BUFFER_FILTER.length() > 0) {
                if (SessionConfig.matchCaptureFilterToUidAppid(this.m_uid, this.m_chan0_appid)) {
                    this.m_cb.resize(SessionConfig.LISTENER_CAPTURE_BUFFER_SIZE);
                } else {
                    this.m_cb.resize(0);
                    this.m_cb = null;
                }
            }
        }
    }

    private boolean isInternalAppid(String appid) {
        return appid.startsWith("SonicMQ/mf/");
    }

    private void publishRejectMessage() {
        BrokerManagementNotificationsHelper.sendConnectionRejectNotification(Config.BROKER_NAME, this.m_uid, this.m_chan0_appid, this.m_connection == null ? "<unknown>" : this.m_connection.getHostIpAddrStr());
        this.updateStatistic(m_connRejectedPerMinute, 1L);
    }

    protected void initializeConverter() {
        try {
            this.m_converter = MgramFactory.getMgramConverter(this.m_clientMgramVersion);
        }
        catch (EUnsupportedMgramException e) {
            this.m_converter = MgramFactory.getMgramConverter(26);
        }
        Hashtable<String, Object> mgramProperties = new Hashtable<String, Object>();
        mgramProperties.put(MgramConstants.MGRAM_STATUS_LISTENER, this);
        if (this.m_sis != null) {
            mgramProperties.put(MgramConstants.SECURE_INPUT_STREAM, this.m_sis);
        }
        if (this.m_commonMp != null) {
            mgramProperties.put(MgramConstants.MESSAGE_PROTECTION, this.m_commonMp);
        }
        if (this.m_commonCsc != null) {
            mgramProperties.put(MgramConstants.CLIENT_SECURITY_CONTEXT, this.m_commonCsc);
        }
        mgramProperties.put(MgramConstants.TTE_TTL_CONVERT, new Boolean(true));
        this.m_converter.initializeConverter(mgramProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() throws IOException, InterruptedException {
        boolean stay_in_loop = true;
        IMgram m = null;
        Object object = this.m_mainLoopNotify;
        synchronized (object) {
            this.m_reachedMainLoop = true;
            this.m_mainLoopNotify.notifyAll();
        }
        this.initializeConverter();
        while (stay_in_loop) {
            try {
                m = null;
                m = this.m_converter.createMgram(this.m_is);
                if (this.m_cb != null && m != null) {
                    this.m_cb.annotate(MgramTrace.diagnosticString("", this.m_connection, m));
                }
                if (this.CALLBACK) {
                    this.callback("AgentListener", 102, new Object[]{this.m_connection, m});
                }
                if ((this.debugFlags & 1) > 0) {
                    PrintStream log;
                    PrintStream printStream = log = SessionConfig.getLog();
                    synchronized (printStream) {
                        this.logDebug(1, "RECEIVED Mgram:");
                        m.dump();
                    }
                } else if ((this.debugFlags & 4) > 0 && m.getType() == 0) {
                    this.logDebug(4, "received ping " + (m.isReply() ? " reply" : " request") + " at " + System.currentTimeMillis());
                }
                try {
                    long clientId = this.getClientId(m.getChannel());
                    if (clientId == -1L && Broker.isInShutdown()) continue;
                    m.getBrokerHandle().setSenderID(clientId);
                }
                catch (NullPointerException e) {
                    continue;
                }
                if ((m_hasEnabledBytesMetrics || this.m_connection.hasEnabledBytesRecvdMetrics()) && !this.m_isAdminConnection) {
                    long mgramLength = m.networkLength();
                    this.updateStatistic(m_bytesReceivedPerSecond, mgramLength);
                    if (this.m_metricsListener == null) {
                        this.m_connection.updateBytesRcvdStats(mgramLength);
                    }
                }
                switch (m.getType()) {
                    case 23: {
                        s_reg.getIDRMgramHandler().processIDR(m);
                        break;
                    }
                    case 32: {
                        this.processConnectionSync(m);
                        break;
                    }
                    case 2: 
                    case 12: 
                    case 27: {
                        this.retrieveBatchSizeAndUpdateStats(m);
                    }
                    case 11: 
                    case 13: {
                        m.getBrokerHandle().clearTransactionPublish();
                        this.handleNormal(m);
                        break;
                    }
                    case 25: {
                        this.handleOperation(m);
                        break;
                    }
                    case 30: {
                        this.handleQueueOpenRemoteReceiver(m);
                        break;
                    }
                    case 31: {
                        this.handleQueueCloseRemoteReceiver(m);
                        break;
                    }
                    case 8: 
                    case 26: {
                        if (m.isReply()) {
                            throw new EUnexpectedMgram(m);
                        }
                        s_reg.getTransactionMgr().processTxnOp(m);
                        break;
                    }
                    case 3: 
                    case 14: 
                    case 36: {
                        this.handleAck(m);
                        break;
                    }
                    case 33: {
                        this.handleWindowAckAck(m);
                        break;
                    }
                    case 20: {
                        IClientContext cc = (IClientContext)this.m_ccs.elementAt(m.getChannel());
                        if (cc == null) break;
                        cc.getPTPFlowControlHandler().handleNack(m);
                        break;
                    }
                    case 28: {
                        this.handleAckList(m);
                        break;
                    }
                    case 0: {
                        this.handlePing(m);
                        break;
                    }
                    case 6: {
                        this.m_connection.flowControlMgramReceived(m);
                        break;
                    }
                    case 18: {
                        IClientContext cc = (IClientContext)this.m_ccs.elementAt(m.getChannel());
                        if (cc == null) break;
                        cc.getPTPFlowControlHandler().handlePTPFlowControlMgram(m);
                        break;
                    }
                    case 19: {
                        IClientContext cc = (IClientContext)this.m_ccs.elementAt(m.getChannel());
                        if (cc == null) break;
                        if (m.isReply()) {
                            cc.getFlowController().onResumeReply(m);
                            break;
                        }
                        cc.getPTPFlowControlHandler().handlePTPFlowControlMgram(m);
                        break;
                    }
                    case 37: {
                        IClientContext cc = (IClientContext)this.m_ccs.elementAt(m.getChannel());
                        if (cc == null) break;
                        IPTPFlowControlHandle handle = m.getPTPFlowControlHandle();
                        if (handle.getSubType() == 3) {
                            cc.getFlowController().onResumeReply(m);
                            break;
                        }
                        cc.getPTPFlowControlHandler().handlePTPFlowControlMgram(m);
                        break;
                    }
                    case 5: {
                        if (InterbrokerHook.isSet()) {
                            InterbrokerHook.convertEvent(this.m_connection, m);
                            break;
                        }
                        throw new EUnexpectedMgram(m);
                    }
                    case 22: {
                        if (s_reg.getReplicationManager() == null) break;
                        s_reg.getReplicationManager().onConvert(this.m_connection, m);
                        break;
                    }
                    case 16: {
                        s_reg.getRouterManager().onConvertMgram(this.m_connection, m);
                        break;
                    }
                    case 17: {
                        s_reg.getRouterManager().onRouteInfoMgram(this.m_connection, m);
                        break;
                    }
                    case 7: {
                        this.handleDisconnect(m);
                        break;
                    }
                    case -1: {
                        int errorCode = m.getErrorHandle().getErrCode();
                        this.dumpSenderHistory();
                        if (errorCode == -3) {
                            this.fatalError(null);
                            stay_in_loop = false;
                            break;
                        }
                        throw new EUnexpectedMgram(m);
                    }
                    case 38: {
                        IClientContext cc = (IClientContext)this.m_ccs.elementAt(m.getChannel());
                        FlowControlMonitor fcm = s_reg.getFCMonitor();
                        if (fcm == null) break;
                        fcm.processFlowControlReport(cc, m);
                        break;
                    }
                    default: {
                        if (this.handleUnexpectedMgramType(m, 2)) break;
                        throw new EUnexpectedMgram(m);
                    }
                }
                if (!this.DEBUG) continue;
                this.logDebug(128, "got mgram type " + m.getType() + ", size " + m.networkLength());
            }
            catch (EMsgTooBigException e) {
                this.printDebuggingInfo(e);
                this.handleMgramCorruption(true);
                this.fatalError(null, true);
                stay_in_loop = false;
            }
            catch (EChecksumValidationFailed ck) {
                this.printDebuggingInfo(ck);
                this.handleMgramCorruption(true);
                if (this.DEBUG) {
                    this.logDebug(32, "Checksum Validation failed:  " + this.getClientId(m != null ? m.getChannel() : 0));
                }
                this.fatalError(null);
                stay_in_loop = false;
            }
            catch (EIntegrityCompromised ec) {
                this.printDebuggingInfo(ec);
                this.logWarning(ec);
                this.handleMgramCorruption(false);
                if (this.DEBUG) {
                    this.logDebug(128, "Integrity Compromised on Mgram from Client:  " + this.getClientId(m != null ? m.getChannel() : 0));
                }
                this.fatalError(MgramFactory.getMgramFactory().buildErrorMgram(-3, 0, null, 0));
                stay_in_loop = false;
            }
            catch (EUnexpectedMgram e) {
                this.printDebuggingInfo(e);
                this.handleMgramCorruption(false);
                if (this.DEBUG) {
                    SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
                }
                this.fatalError(MgramFactory.getMgramFactory().buildErrorMgram(-19, 0, null, 0));
                stay_in_loop = false;
            }
            catch (EMgramFormatError e) {
                this.printDebuggingInfo(e);
                this.debugDataHandleMgramCorruption(e);
                this.fatalError(MgramFactory.getMgramFactory().buildErrorMgram(-20, 0, null, 0));
                stay_in_loop = false;
            }
        }
        if (this.m_connection != null) {
            this.m_connection.cleanupInstanceStats();
        }
    }

    private <T0 extends Exception> void debugDataHandleMgramCorruption(T0 e) {
        this.handleMgramCorruption(false);
        if (this.DEBUG) {
            BrokerComponent.getComponentContext().logMessage(e, 2);
        }
    }

    private void logWarning(EIntegrityCompromised ec) {
    }

    private void retrieveBatchSizeAndUpdateStats(IMgram fwdMgram) {
        ISubject subject;
        if ((m_hasEnabledMsgsMetrics || this.m_connection.hasEnabledMsgsRecvdMetrics()) && !this.m_isAdminConnection && fwdMgram.hasSubject() && !SessionConfig.isSystemSubject(subject = fwdMgram.getSubject()) && !subject.isSonicMQSubject()) {
            int size = 1;
            if (fwdMgram.getType() == 27) {
                size = fwdMgram.getBatchHandle().getBatchSize();
            }
            this.updateStatisticsReceivedSize(size);
        }
    }

    private void updateStatisticsReceivedSize(int size) {
        this.updateStatistic(m_msgsReceivedPerSecond, size);
        this.updateStatistic(m_msgsReceived, size);
        this.m_connection.updateMsgsRcvdStats(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processConnectionSync(IMgram m) throws IOException, InterruptedException {
        IConnectionSyncHandle handle = m.getConnectionSyncHandle();
        AutoVec clientSyncData = handle.getConnectionSyncData();
        AutoVec brokerSyncData = new AutoVec();
        IClientContext cc = null;
        ClientSecurityContext csc = null;
        ConnectionSyncData cclient = null;
        ConnectionSyncData cbroker = null;
        cclient = (ConnectionSyncData)clientSyncData.elementAt(0);
        try {
            cc = s_reg.getClient(cclient.getClientId());
        }
        catch (EClientNotRegistered ex) {
            throw new EAssertFailure("Connection Sync Mgram received for unregistered connection client:" + cclient.getClientId(), ex);
        }
        brokerSyncData.setElementAt(clientSyncData.elementAt(0), 0);
        this.m_connection.setDeliveryStartedFromId(cclient.getClientId(), cclient.getDeliveryStarted());
        for (int i = 1; i < clientSyncData.size(); ++i) {
            AgentListener associatedListener;
            cclient = (ConnectionSyncData)clientSyncData.elementAt(i);
            if (cclient == null) {
                cc = null;
            } else {
                try {
                    cc = s_reg.getClient(cclient.getClientId());
                }
                catch (EClientNotRegistered ex) {
                    cc = null;
                }
            }
            if (cclient != null && cc != null && cclient.getState() == 4) {
                this.internallyDisconnectChannelCC(cc);
                continue;
            }
            if (cclient != null && cc != null && cclient.getState() == 0) {
                this.validateCSC(cc);
                csc = this.internallyResumeChannelCC(cc, cclient, cc.getCSC().getParentId());
                if (csc == null) continue;
                byte flags = this.retrieveFlags(cc);
                this.m_connection.setDeliveryStartedFromId(cclient.getClientId(), cclient.getDeliveryStarted());
                cbroker = new ConnectionSyncData(flags, cclient.getChannel(), cclient.getClientId(), 0, false, csc, cclient.getAckMode());
                brokerSyncData.setElementAt(cbroker, i);
                continue;
            }
            if (cclient == null || cc == null || !cc.isConnected() || cclient.getState() != 3) continue;
            this.validateCSC(cc);
            Object criticalConnectRegionLock = null;
            AgentConnection associatedConnection = cc.getConnection();
            if (associatedConnection != null && (associatedListener = associatedConnection.getAgentListener()) != null) {
                criticalConnectRegionLock = associatedListener.getCriticalConnectRegionLock();
            }
            if (criticalConnectRegionLock != null) {
                associatedListener = criticalConnectRegionLock;
                synchronized (associatedListener) {
                    csc = this.internallyResumeChannelCC(cc, cclient, cc.getCSC().getParentId());
                }
            } else {
                csc = this.internallyResumeChannelCC(cc, cclient, cc.getCSC().getParentId());
            }
            this.m_connection.setDeliveryStartedFromId(cclient.getClientId(), cclient.getDeliveryStarted());
            if (csc == null) continue;
            byte flags = this.retrieveFlags(cc);
            cbroker = new ConnectionSyncData(flags, cclient.getChannel(), cclient.getClientId(), 0, false, csc, cclient.getAckMode());
            brokerSyncData.setElementAt(cbroker, i);
        }
        IMgram returnSync = MgramFactory.getMgramFactory().buildConnectionSyncMgram(brokerSyncData);
        this.m_connection.getAgentSender().sendThrough(returnSync);
    }

    private void validateCSC(IClientContext cc) throws EAssertFailure {
        if (cc.getCSC() == null) {
            throw new EAssertFailure("Attempting to resume a cc with no prior security context: " + cc);
        }
    }

    private byte retrieveFlags(IClientContext cc) {
        byte flags = 0;
        if (this.retainsJMSNonDurableState(cc)) {
            flags = (byte)(flags | 1);
        }
        return flags;
    }

    private boolean retainsJMSNonDurableState(IClientContext cc) {
        if (cc.isDurable()) {
            return false;
        }
        BrokerSubscription bs = cc.getSubscriptions().getUserSubscription();
        return bs != null;
    }

    private ClientSecurityContext internallyResumeChannelCC(IClientContext cc, ConnectionSyncData csdClient, long parentID) throws InterruptedException {
        return this.internallyCompleteChannelCC(cc, csdClient, parentID, true);
    }

    private ClientSecurityContext internallyCompleteChannelCC(IClientContext cc, ConnectionSyncData csdClient, long parentID, boolean resume) throws InterruptedException {
        ClientSecurityContext csc = null;
        int channel = cc.getChannel() == -1 ? csdClient.getChannel() : cc.getChannel();
        try {
            csc = this.newChannelConnection(channel, cc.getUid(), cc.getAppid(), parentID, resume, csdClient.getAckMode(), -1);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (EConnectionNotResumable ecnr) {
            if (this.DEBUG || this.DEBUG_UNEXPECTED) {
                BrokerComponent.getComponentContext().logMessage((Throwable)ecnr, 2);
            }
        }
        catch (Exception e) {
            BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
        }
        return csc;
    }

    private void internallyDisconnectChannelCC(IClientContext cc) {
        AgentListener.sRegPrepareDisconnect(cc);
        s_reg.cancelDisconnectTimer(cc);
        s_reg.disconnect(cc.getId(), false);
    }

    private static void sRegPrepareDisconnect(IClientContext cc) {
        try {
            s_reg.prepareDisconnect(cc.getId());
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
    }

    public ClientSecurityContext newChannelConnection(int channel, String uid, String appid, long parentID, boolean resume, short ackMode, int dblimitExceptionHandling) throws EConnectFailure, EClientNotRegistered, InterruptedException {
        if (this.m_connection.getSecurityContext(channel) != null) {
            Object[] obj = new Object[]{uid, appid};
            throw new EUserAlreadyConnected(MessageFormat.format(prAccessor.getString("USER_ALREADY_CONNECTED"), obj));
        }
        long clientId = this.getClientId(uid, appid);
        int tmpChannel = this.m_connection.getChannel(clientId);
        if (tmpChannel >= 0 && tmpChannel != channel) {
            Object[] obj = new Object[]{uid, appid};
            throw new EUserAlreadyConnected(MessageFormat.format(prAccessor.getString("USER_ALREADY_CONNECTED"), obj));
        }
        AMPScratchPad sp = new AMPScratchPad();
        this.m_scratchPads.setElementAt(sp, channel);
        if (Config.ENABLE_QOPSECURITY) {
            sp.m_mp.init(2, this.m_rawSessionKey);
        }
        ClientSecurityContext csc = new ClientSecurityContext(this.m_user, uid, appid, clientId, Config.ENABLE_SECURITY, Config.ENABLE_QOPSECURITY, this.m_rawMacKey, this.m_rawSessionKey, parentID);
        AgentListener.configDirectedAddr(appid, clientId, csc, uid);
        csc.setFaultTolerant(this.m_connection.getFaultTolerant());
        csc.setClientIPAddress(this.m_connection.getHostIpAddrStr());
        if (csc.isFaultTolerant()) {
            csc.setFaultTolerantReconnectTimeout(this.m_connection.getClientConnectParms().getFaultTolerantReconnectTimeout());
        }
        this.m_connection.connectSuccess(channel, csc, clientId);
        this.connectAgentRegistar(channel, resume, ackMode, clientId);
        s_reg.postConnect(clientId, channel);
        IClientContext clientContext = this.getClientContext(dblimitExceptionHandling, clientId, sp);
        return this.putToClientContextByChannel(channel, appid, csc, clientContext);
    }

    private static void configDirectedAddr(String appid, long clientId, ClientSecurityContext csc, String uid) {
        csc.setDirectedAddr(AddrUtil.directedAddr(clientId, 0, null));
        csc.setDirectedAddrString(SessionConfig.getDirectedSubject(uid, appid, AgentRegistrar.getAgentRegistrar().getCollective(), Config.BROKER_UID, "reply"));
    }

    private void connectAgentRegistar(int channel, boolean resume, short ackMode, long clientId) throws EConnectFailure, InterruptedException {
        try {
            if (resume) {
                s_reg.resume(clientId, this.m_connection, false, ackMode);
            } else {
                s_reg.connect(clientId, this.m_connection, null, false, ackMode);
            }
        }
        catch (InterruptedException e) {
            this.m_connection.close(channel);
            throw e;
        }
        catch (EUserAlreadyConnected e) {
            this.m_connection.close(channel);
            throw e;
        }
        catch (EConnectFailure e) {
            this.m_connection.close(channel);
            throw e;
        }
    }

    private IClientContext getClientContext(int dblimitExceptionHandling, long clientId, AMPScratchPad scratchPad) throws EClientNotRegistered {
        IClientContext cc;
        try {
            cc = s_reg.getClient(clientId);
            if (dblimitExceptionHandling > -1) {
                cc.setDbOverflowChecks(dblimitExceptionHandling);
            }
            AgentListener.indicateMinPublishPriorityReinstate(cc);
            scratchPad.setClientContext(cc);
        }
        catch (EClientNotRegistered e) {
            String m943 = prAccessor.getString("STR007");
            Object[] ob943 = new Object[]{this.m_connection.getSecurityContext(0).getUid()};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(m943, ob943), 2);
            throw e;
        }
        return cc;
    }

    private static void indicateMinPublishPriorityReinstate(IClientContext cc) {
        if (cc.getPublishLimiter() != null && (cc.isInterbroker() || cc.isXOnce())) {
            cc.getPublishLimiter().setReinstateMinPublishPriority(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientSecurityContext putToClientContextByChannel(int channel, String appid, ClientSecurityContext csc, IClientContext cc) {
        IClientContext connectionCC = null;
        AgentListener agentListener = this;
        synchronized (agentListener) {
            connectionCC = (IClientContext)this.m_ccs.elementAt(0);
            if (connectionCC == null) {
                this.fatalError(null, channel);
                return csc;
            }
            this.m_ccs.setElementAt(cc, channel);
        }
        if (appid.indexOf("$QR$") >= 0 && connectionCC.isStarted()) {
            cc.startDelivery(null);
        }
        return csc;
    }

    private long getClientId(String uid, String appid) {
        return AddrUtil.stringToClientId(uid, appid);
    }

    public byte getClientSessionVer() {
        return this.m_clientSessionVer;
    }

    protected void setClientSessionVer(byte clientSessionVer) {
        this.m_clientSessionVer = clientSessionVer;
    }

    protected void setClientMgramVer(byte clientMgramVer) {
        this.m_clientMgramVersion = clientMgramVer;
    }

    protected boolean handleUnexpectedMgramType(IMgram m, int phase) {
        return false;
    }

    public String getChan0Appid() {
        return this.m_chan0_appid;
    }

    public static List getMetricsInfo() {
        if (Config.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("AgentListener - getMetricsInfo ", 3);
        }
        ArrayList<IMetricInfo> infos = new ArrayList<IMetricInfo>();
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_BYTES_RECEIVEDPERSECOND_METRIC, (short)8, (String)"Broker wide bytes received per second (includes internal/management messages).", null, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (String)"bytes per second"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_MSGS_RECEIVEDPERSECOND_METRIC, (short)8, (String)"Application messages received per second (excludes internal/management messages).", null, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (String)"messages per second"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_MSGS_RECEIVED_METRIC, (short)0, (String)"Application messages received since start/reset (excludes internal/management messages).", null, (boolean)false, (boolean)true, (boolean)false, (boolean)false, (String)"messages"));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_CONNECTIONS_REJECTEDPERMINUTE_METRIC, (short)10, (String)"Rejected connect attempts per minute.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (String)"attempts per minute"));
        return infos;
    }

    public static synchronized void enableMetrics(IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids) {
        if (Config.DEBUG) {
            String s;
            if (ids == null || ids.length == 0) {
                s = "NONE";
            } else {
                s = "";
                for (int i = 0; i < ids.length; ++i) {
                    s = s + "\n - " + ids[i];
                }
            }
            BrokerComponent.getComponentContext().logMessage("AgentListener - enableMetrics : " + s, 3);
        }
        m_metricsRegistrar = metricsRegistrar;
        if (ids == null) {
            throw new NullPointerException("'ids' cannot be null.");
        }
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals((Object)BROKER_BYTES_RECEIVEDPERSECOND_METRIC) && m_bytesReceivedPerSecond == null) {
                m_bytesReceivedPerSecond = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
                metricsRegistrar.registerMetric(BROKER_BYTES_RECEIVEDPERSECOND_METRIC, m_bytesReceivedPerSecond);
            }
            if (ids[i].equals((Object)BROKER_MSGS_RECEIVEDPERSECOND_METRIC) && m_msgsReceivedPerSecond == null) {
                m_msgsReceivedPerSecond = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
                metricsRegistrar.registerMetric(BROKER_MSGS_RECEIVEDPERSECOND_METRIC, m_msgsReceivedPerSecond);
            }
            if (ids[i].equals((Object)BROKER_MSGS_RECEIVED_METRIC) && m_msgsReceived == null) {
                m_msgsReceived = StatisticsFactory.createStatistic((short)2, (boolean)false, null, (short)0);
                metricsRegistrar.registerMetric(BROKER_MSGS_RECEIVED_METRIC, m_msgsReceived);
            }
            if (!ids[i].equals((Object)BROKER_CONNECTIONS_REJECTEDPERMINUTE_METRIC) || m_connRejectedPerMinute != null) continue;
            m_connRejectedPerMinute = StatisticsFactory.createStatistic((short)2, (boolean)true, null, (short)1);
            metricsRegistrar.registerMetric(BROKER_CONNECTIONS_REJECTEDPERMINUTE_METRIC, m_connRejectedPerMinute);
        }
        if (m_bytesReceivedPerSecond != null) {
            m_hasEnabledBytesMetrics = true;
        }
        if (m_msgsReceivedPerSecond != null || m_msgsReceived != null) {
            m_hasEnabledMsgsMetrics = true;
        }
    }

    public static synchronized void disableMetrics(IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids) {
        if (Config.DEBUG) {
            String s;
            if (ids == null || ids.length == 0) {
                s = "NONE";
            } else {
                s = "";
                for (int i = 0; i < ids.length; ++i) {
                    s = s + "\n - " + ids[i];
                }
            }
            BrokerComponent.getComponentContext().logMessage("AgentListener - disabling metrics = " + s, 3);
        }
        if (ids == null) {
            throw new NullPointerException("'ids' cannot be null.");
        }
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals((Object)BROKER_BYTES_RECEIVEDPERSECOND_METRIC)) {
                metricsRegistrar.unregisterMetric(ids[i]);
                m_bytesReceivedPerSecond = null;
            }
            if (ids[i].equals((Object)BROKER_MSGS_RECEIVEDPERSECOND_METRIC)) {
                metricsRegistrar.unregisterMetric(ids[i]);
                m_msgsReceivedPerSecond = null;
            }
            if (ids[i].equals((Object)BROKER_MSGS_RECEIVED_METRIC)) {
                metricsRegistrar.unregisterMetric(ids[i]);
                m_msgsReceived = null;
            }
            if (!ids[i].equals((Object)BROKER_CONNECTIONS_REJECTEDPERMINUTE_METRIC)) continue;
            metricsRegistrar.unregisterMetric(ids[i]);
            m_connRejectedPerMinute = null;
        }
        if (m_bytesReceivedPerSecond == null) {
            m_hasEnabledBytesMetrics = false;
        }
        if (m_msgsReceivedPerSecond == null && m_msgsReceived == null) {
            m_hasEnabledMsgsMetrics = false;
        }
    }

    private void updateStatistic(IStatistic statistic, long value) {
        IStatistic s = statistic;
        if (s != null) {
            s.updateValue(value);
        }
    }

    private void printDebuggingInfo(Exception e) {
        String NEWLINE = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer("Unexpected exception:");
        if (this.m_connection != null) {
            ISocket socket = this.m_connection.getSocket();
            if (socket != null) {
                sb.append(NEWLINE).append("...acceptor name: ").append(socket.getAcceptorName());
                ProgressInetAddress inetAddress = socket.getInetAddress();
                if (inetAddress != null) {
                    sb.append(NEWLINE).append("...IP causing exception: ").append(inetAddress.getHostAddress(true));
                } else {
                    sb.append(NEWLINE).append("...IP is null");
                }
            } else {
                sb.append(NEWLINE).append("...socket is null");
            }
        } else {
            sb.append(NEWLINE).append("...connection is null");
        }
        if (this.m_commonCsc != null) {
            sb.append(NEWLINE).append("...user name: ").append(this.m_commonCsc.getUid());
            sb.append(NEWLINE).append("...application ID: ").append(this.m_commonCsc.getAppid());
        } else {
            sb.append(NEWLINE).append("...client security context is null");
        }
        sb.append(NEWLINE).append("...trace follows...");
        BrokerComponent.getComponentContext().logMessage(sb.toString(), (Throwable)e, 2);
    }

    private final void handleMgramCorruption(boolean requestPeerDump) {
        if (this.DIAG_MGRAM_HISTORY) {
            this.dumpMgramHistory();
            if (requestPeerDump && this.m_connection != null && this.m_clientSessionVer >= 30) {
                try {
                    this.m_connection.getAgentSender().sendThrough(MgramFactory.getMgramFactory().buildDiagnosticOpMgram((short)0, 0));
                }
                catch (IOException e) {
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
        }
    }

    private final void dumpMgramHistory() {
        if (this.m_is instanceof IDumpable) {
            ClientSecurityContext csc;
            StringBuffer buf = new StringBuffer();
            buf.append("Listener History Dump\n");
            AgentConnection c = this.m_connection;
            if (c != null && (csc = c.getSecurityContext(0)) != null) {
                csc.dump(buf);
            }
            ((IDumpable)((Object)this.m_is)).dump(buf);
            BrokerComponent.getComponentContext().logMessage(buf.toString(), 1);
        } else if (this.m_cb != null) {
            BrokerComponent.getComponentContext().logMessage("Listener input stream not dumpable: " + this.m_is, 2);
        }
    }

    private final void dumpSenderHistory() {
        Sender sender;
        if (this.DIAG_MGRAM_HISTORY && (sender = this.m_connection.getSender()) instanceof AgentSender) {
            ((AgentSender)sender).dumpMgramHistory();
        }
    }

    public ICompressionFactory getCompressionFactory() {
        return this.m_compressionFactory;
    }

    static {
        QPROC_LOCK_OBJ = new Object();
        m_hasEnabledBytesMetrics = false;
        m_hasEnabledMsgsMetrics = false;
        BROKER_BYTES_RECEIVEDPERSECOND_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "bytes", "ReceivedPerSecond"});
        BROKER_MSGS_RECEIVEDPERSECOND_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "messages", "ReceivedPerSecond"});
        BROKER_MSGS_RECEIVED_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "messages", "Received"});
        BROKER_CONNECTIONS_REJECTEDPERMINUTE_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "connections", "RejectedPerMinute"});
    }
}

