/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import com.sonicsw.mf.common.metrics.manager.IMetricsRegistrar;
import com.sonicsw.mf.common.metrics.manager.ISampledStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatistic;
import com.sonicsw.mf.common.metrics.manager.IStatisticProvider;
import com.sonicsw.mf.common.metrics.manager.StatisticsFactory;
import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import com.sonicsw.security.pcs.CipherSuiteInfo;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import progress.message.broker.AgentGuarMsgTracker;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerLicenseMgr;
import progress.message.broker.BrokerStatus;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.Config;
import progress.message.broker.DBSubscription;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.EOperationCancelled;
import progress.message.broker.ETrackingNumNotFound;
import progress.message.broker.FlowToDiskMemoryManager;
import progress.message.broker.ICCSizeTracker;
import progress.message.broker.IClientContext;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.MsgRestorePos;
import progress.message.broker.MsgSaver;
import progress.message.broker.PublishLimiter;
import progress.message.broker.StatsManager;
import progress.message.broker.StatsMetrics;
import progress.message.broker.SyncpointLoc;
import progress.message.broker.durable.ECounterFrozenException;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.broker.prAccessor;
import progress.message.broker.stats.LTotStatsObj;
import progress.message.client.EGeneralException;
import progress.message.db.DBFactory;
import progress.message.db.Db;
import progress.message.db.EDatabaseException;
import progress.message.dbq.DBQSetup;
import progress.message.dbq.IDbBatchMessageCleaner;
import progress.message.dbq.IDbMsgDeleteListener;
import progress.message.dbq.IDbUndelMsgDeleteListener;
import progress.message.dbq.IPtpDBQ;
import progress.message.dbq.IPubSubDBQ;
import progress.message.dbq.IQueryCancelCheck;
import progress.message.dbq.IRegDBQ;
import progress.message.dbq.IRoutingDBQ;
import progress.message.dbsc.data.IDbRef;
import progress.message.dbsc.pse.pc.reg.PSEClient;
import progress.message.ft.IPubSubDbSyncSupport;
import progress.message.gr.RouteInfo;
import progress.message.msg.IMgram;
import progress.message.resources.prMessageFormat;
import progress.message.util.DebugState;
import progress.message.util.LongHashTable;
import progress.message.util.server.ByteBufferInputStream;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.FastVector;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectFilter;
import progress.message.zclient.SessionConfig;

public final class BrokerDatabase
extends DebugObject
implements Runnable,
IPubSubDbSyncSupport {
    public static final IMetricIdentity BROKER_BYTES_TOPIC_DB_SIZE_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "bytes", "TopicDBSize"});
    private static final String NUM_DELETED_MESSAGE = "expirePubSubMsgs(UndelMsgs) Deleted batch; NumDeleted= %s %s";
    private static final String NUM_DELETED_TIME = "expirePubSubMsgs(UndelMsgs): numDeleted: %s time(secs)= %s";
    private static final String INPUT_PARAMETER_MESSAGE = "expirePubSubMsgs(UndelMsgs): got list of expired MessageIds; size= %s time(secs)= %s";
    private static final String THE_BROKER_IS_SHUTTING_DOWN_MESSAGE = "The broker is shutting down and has logged information that cannot be altered.  Rolling back.";
    private static String BROKER_BYTES_TOPIC_DB_SIZE_METRIC_UNITS = "bytes";
    private static IStatistic m_totalTopicDBSizeStat;
    public static final IMetricIdentity BROKER_BYTES_FTD_MEMORY_SIZE_METRIC;
    private static String BROKER_BYTES_FTD_MEMORY_SIZE_METRIC_UNITS;
    private static IStatistic m_ftdMemorySizeStat;
    private static long m_totalTopicDBSize;
    private static long m_volatileTopicDBSize;
    private static Object m_totalTopicDBSizeSyncObj;
    private FastVector m_clientsBlockedOnDbSpace = null;
    private StatsManager m_statsMgr;
    private LTotStatsObj m_statGetUndelivMsgsTime = null;
    private LTotStatsObj m_statUpdateRedelivFlagTime = null;
    private LTotStatsObj m_statGetMgramTime = null;
    private LTotStatsObj m_statSaveMsgTime = null;
    private LTotStatsObj m_statSaveUndelivMappingTime = null;
    private LTotStatsObj m_statCommitTime = null;
    private LTotStatsObj m_statDelMsgTime = null;
    private static volatile BrokerDatabase s_self;
    private IRegDBQ m_regDBQ;
    private IPtpDBQ m_ptpDBQ;
    private IPubSubDBQ m_pubSubDBQ;
    private IRoutingDBQ m_routingDBQ;
    private Db m_Database = null;
    private int m_PeakMsgCount = 0;
    private int m_CurrentMsgCount = 0;
    private int msgs_assoc_deleted = 0;
    private int msgs_till_msg_cleanup = 0;
    private int exp_msg_added = 0;
    private int exp_till_cleanup = 0;
    private long m_sequenceNumber;
    private long m_lastUpdatedSeqNo;
    private long m_lastUpdatedMessageId;
    private long m_lastUpdatedQueueMessageId;
    private Object m_maxIdAddedSyncObj = new Object();
    private long m_StartupMaxSeqNoUsed;
    private long m_StartupMaxIdUsed;
    private long m_maxAddedMessageId;
    private long m_maxAddedQueueMessageId;
    private volatile long m_maxDeletedMessageId;
    private Hashtable m_clientIdsInDb;
    private Vector m_volatileCRegDeletes;
    private boolean debugStatsEnabled;
    private boolean DEBUG1;
    private boolean m_useDBQCleaner;
    private boolean m_okToRunCleaner = false;
    private boolean m_cancelCleaner;
    private static final Class[] s_delMsgsParams;

    BrokerDatabase() throws EGeneralException, EDatabaseException {
        this(DBFactory.createBrokerDb());
    }

    BrokerDatabase(Db db) throws EGeneralException, EDatabaseException {
        super(DebugState.GLOBAL_DEBUG_ON ? "BrokerDatabase" : null);
        boolean bl = this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        if (this.DEBUG) {
            this.debug("in BrokerDatabase ctor");
        }
        s_self = this;
        this.m_clientsBlockedOnDbSpace = new FastVector();
        this.m_clientIdsInDb = new Hashtable();
        this.m_volatileCRegDeletes = new Vector();
        this.m_Database = db;
        this.m_Database.start();
        if (!this.m_Database.seemsConfigured()) {
            throw new EDatabaseException(prAccessor.getString("DB_TABLES_NOT_FOUND"));
        }
        this.m_Database.checkDBVersion();
        this.m_regDBQ = DBQSetup.initRegDBQ(this.m_Database);
        this.m_ptpDBQ = DBQSetup.initPtpDBQ(this.m_Database);
        this.m_pubSubDBQ = DBQSetup.initPubSubDBQ(this.m_Database);
        this.m_routingDBQ = DBQSetup.initRoutingDBQ(this.m_Database);
        if (this.m_Database.isRemoteDb()) {
            this.m_Database.initPingDatabase();
        }
        this.msgs_till_msg_cleanup = Config.DB_MSG_CLEAN_THRESHOLD;
        this.exp_till_cleanup = Config.EXP_MSG_CLEAN_THRESHOLD;
        if (this.DEBUG1) {
            this.debug("Db params:");
        }
        if (this.DEBUG1) {
            this.debug("PS_DB_QUEUE_SIZE: " + Config.PS_DB_QUEUE_SIZE);
        }
        if (this.DEBUG1) {
            this.debug("DB_FORCE_SYNC: " + Config.DB_FORCE_SYNC);
        }
        if (this.DEBUG1) {
            this.debug("DB cleaner params");
        }
        if (this.DEBUG1) {
            this.debug("DB_MSG_CLEAN_THRESHOLD : " + Config.DB_MSG_CLEAN_THRESHOLD);
        }
        if (this.DEBUG1) {
            this.debug("EXP_MSG_CLEAN_THRESHOLD : " + Config.EXP_MSG_CLEAN_THRESHOLD);
        }
        if (this.DEBUG1) {
            this.debug("DB_COMMIT_BATCH_SIZE : " + Config.DB_COMMIT_BATCH_SIZE);
        }
        if (this.DEBUG1) {
            this.debug("DB_CLEANUP_BATCH_SIZE: " + Config.DB_CLEANUP_BATCH_SIZE);
        }
        if (this.DEBUG1) {
            this.debug("Restore params");
        }
        if (this.DEBUG1) {
            this.debug("THROTTLE_PUBS_DURING_RESTORE: " + Config.THROTTLE_PUBS_DURING_RESTORE);
        }
        if (this.DEBUG1) {
            this.debug("RESTORE_MSGS_COUNT: " + Config.RESTORE_MSGS_COUNT);
        }
        if (this.DEBUG1) {
            this.debug("RESTORE_MSGS_FC_COUNT: " + Config.RESTORE_MSGS_FC_COUNT);
        }
        if (this.DEBUG1) {
            this.debug("FlowToDisk params:");
        }
        if (this.DEBUG1) {
            this.debug("FLOW_TO_DISK: " + Config.FLOW_TO_DISK);
        }
        if (this.DEBUG1) {
            this.debug("MAX_TOPIC_DB_SIZE: " + Config.MAX_TOPIC_DB_SIZE);
        }
        if (this.DEBUG1) {
            this.debug("MAX_MAX_FTD_MEMORY_SIZE: " + Config.MAX_FTD_MEMORY_SIZE);
        }
        if (this.DEBUG1) {
            this.debug("TOPIC_DB_SIZE_RESTART_THRESHOLD: " + Config.TOPIC_DB_SIZE_RESTART_THRESHOLD);
        }
        if (this.m_pubSubDBQ instanceof IDbBatchMessageCleaner) {
            this.m_useDBQCleaner = true;
            this.debug("Using DBQCleaner");
        }
        if (DebugState.get("UseOldCleaner")) {
            this.m_useDBQCleaner = false;
            this.debug("Using OldCleaner");
        }
        boolean bl2 = this.debugStatsEnabled = this.m_statsMgr != null && (this.debugFlags & 2) > 0 && StatsMetrics.areStatsEnabled(3);
        if (this.debugStatsEnabled) {
            this.m_statGetUndelivMsgsTime = new LTotStatsObj(3, "GetUndeliveredMsgsTime", 1);
            this.m_statGetUndelivMsgsTime.outputStatistic("GetUndeliveredMsgsTimeAvg", 5);
            this.m_statsMgr.registerStat(this.m_statGetUndelivMsgsTime);
            this.m_statUpdateRedelivFlagTime = new LTotStatsObj(3, "UpdateRedeliveredFlagTime", 1);
            this.m_statUpdateRedelivFlagTime.outputStatistic("UpdateRedeliveredFlagTimeAvg", 5);
            this.m_statsMgr.registerStat(this.m_statUpdateRedelivFlagTime);
            this.m_statGetMgramTime = new LTotStatsObj(3, "GetMgramTime", 1);
            this.m_statGetMgramTime.outputStatistic("GetMgramTimeAvg", 5);
            this.m_statsMgr.registerStat(this.m_statGetMgramTime);
            this.m_statSaveMsgTime = new LTotStatsObj(3, "SaveMsgTime", 1);
            this.m_statSaveMsgTime.outputStatistic("SaveMsgTimeAvg", 5);
            this.m_statsMgr.registerStat(this.m_statSaveMsgTime);
            this.m_statSaveUndelivMappingTime = new LTotStatsObj(3, "SaveUndelivMappingTime", 1);
            this.m_statSaveUndelivMappingTime.outputStatistic("SaveUndelivMappingTimeAvg", 5);
            this.m_statsMgr.registerStat(this.m_statSaveUndelivMappingTime);
            this.m_statCommitTime = new LTotStatsObj(3, "CommitTime", 1);
            this.m_statCommitTime.outputStatistic("CommitTimeAvg", 5);
            this.m_statsMgr.registerStat(this.m_statCommitTime);
            this.m_statDelMsgTime = new LTotStatsObj(3, "DeleteMappingTime", 1);
            this.m_statDelMsgTime.outputStatistic("DeleteMappingTimeAvg", 5);
            this.m_statsMgr.registerStat(this.m_statDelMsgTime);
        }
        this.setInitialValues();
        if (this.DEBUG1) {
            this.debug("in ctor m_sequenceNumber is: " + this.m_sequenceNumber);
        }
        if (this.DEBUG1) {
            this.debug("in ctor m_StartupMaxIdUsed is: " + this.m_StartupMaxIdUsed);
        }
        if (this.DEBUG1) {
            this.debug("in ctor m_maxAddedMessageId is: " + this.m_maxAddedMessageId);
        }
        this.msgs_assoc_deleted = Config.DB_MSG_CLEAN_THRESHOLD;
        this.exp_msg_added = Config.EXP_MSG_CLEAN_THRESHOLD;
        if (Config.DEBUG) {
            if (m_totalTopicDBSizeStat != null) {
                BrokerComponent.getComponentContext().logMessage("BrokerDatabase: broker.bytes.TopicDBSize enabled at startup", 3);
            }
            if (m_ftdMemorySizeStat != null) {
                BrokerComponent.getComponentContext().logMessage("BrokerDatabase: broker.bytes.FlowToDiskMemorySize enabled at startup", 3);
            }
        }
        if (this.DEBUG) {
            this.debug("leaving BrokerDatabase ctor");
        }
    }

    public IRegDBQ getIRegDBQ() {
        return this.m_regDBQ;
    }

    public IPtpDBQ getIPtpDBQ() {
        return this.m_ptpDBQ;
    }

    public IPubSubDBQ getIPubSubDBQ() {
        return this.m_pubSubDBQ;
    }

    public IPubSubDbSyncSupport getIPubSubDbSyncSupport() {
        return this;
    }

    public IRoutingDBQ getIRoutingDBQ() {
        return this.m_routingDBQ;
    }

    void saveMsg(long client_id, FastVector proxyingClients, IMgram message, boolean jms_redelivery, boolean isReplicateable, LongHashTable subjectFilters) throws EDatabaseException, EOperationCancelled, IOException {
        if (this.DEBUG) {
            this.debug("call into saveMsg, client id is: " + client_id + " and message is " + message.getGuarenteedTrackingNum());
        }
        long tracking = message.getGuarenteedTrackingNum();
        this.updateMaxAddedMessageId(message.getGuarenteedTrackingNum());
        String JMSMessageId = BrokerDatabase.retrieveJMSMessageId(message);
        long start = System.currentTimeMillis();
        long sequence = this.retrieveAndDebugGetSequenceNumber(message);
        boolean fromRemoteBroker = BrokerDatabase.checkFromRemoteBroker(message);
        if (this.DEBUG) {
            this.debug("fromRemoteBroker: " + fromRemoteBroker + ", isFromDB? " + message.getBrokerHandle().isFromDB());
        }
        Date timestamp = this.getDbTimestamp(message);
        this.addMessage(message, tracking, sequence, timestamp, JMSMessageId);
        start = this.addSaveMsgTimePassedSeconds(start);
        Date exp = BrokerDatabase.retrieveExp(message);
        int size = message.getBrokerHandle().getTrackedSize();
        boolean addSuccess = this.addUndelMsgTx(message, client_id, tracking, sequence, jms_redelivery, exp, timestamp, size, fromRemoteBroker, isReplicateable, BrokerDatabase.retrieveUndelSubjectIds(client_id, message.getSubject(), subjectFilters));
        this.addCCSizeTracker(addSuccess, client_id, tracking, message.getBrokerHandle().getTrackedSize(), size, message.getBrokerHandle().isFromDB());
        BrokerDatabase.updateVolatileTopicDBSizeCheckingAddSuccess(addSuccess);
        if (proxyingClients != null) {
            for (int i = 0; i < proxyingClients.m_count; ++i) {
                long clientId = ((IClientContext)proxyingClients.m_data[i]).getId();
                addSuccess = this.addUndelMsgTx(message, clientId, tracking, sequence, jms_redelivery, exp, timestamp, size, fromRemoteBroker, isReplicateable, BrokerDatabase.retrieveUndelSubjectIds(clientId, message.getSubject(), subjectFilters));
                this.addProxyCCSizeTracker(addSuccess, clientId, tracking, size);
                BrokerDatabase.updateVolatileTopicDBSizeCheckingAddSuccess(addSuccess);
            }
        }
        this.checkPeakMsgCount(start);
    }

    void saveMsg(long client_id, UndelClientInfo[] proxyingClients, IMgram message, boolean jms_redelivery, boolean fromRemoteBroker, boolean isReplicateable, LongHashTable subjectFilters) throws EDatabaseException, EOperationCancelled, IOException {
        long tracking = message.getGuarenteedTrackingNum();
        this.updateMaxAddedMessageId(message.getGuarenteedTrackingNum());
        String JMSMessageId = BrokerDatabase.retrieveJMSMessageId(message);
        long start = System.currentTimeMillis();
        long sequence = this.retrieveAndDebugGetSequenceNumber(message);
        this.debugSequence(sequence);
        Date timestamp = this.getDbTimestamp(message);
        this.addMessage(message, tracking, sequence, timestamp, JMSMessageId);
        start = this.addSaveMsgTimePassedSeconds(start);
        Date exp = BrokerDatabase.retrieveExp(message);
        int size = message.getBrokerHandle().getTrackedSize();
        boolean addSuccess = this.addUndelMsgTx(message, client_id, tracking, sequence, jms_redelivery, exp, timestamp, size, fromRemoteBroker, isReplicateable, BrokerDatabase.retrieveUndelSubjectIds(client_id, message.getSubject(), subjectFilters));
        BrokerDatabase.updateVolatileTopicDBSizeCheckingAddSuccess(addSuccess);
        if (proxyingClients != null) {
            for (int i = 0; i < proxyingClients.length; ++i) {
                long clientId = proxyingClients[i].m_cid;
                addSuccess = this.addUndelMsgTx(message, clientId, tracking, sequence, jms_redelivery, exp, timestamp, size, fromRemoteBroker, isReplicateable, BrokerDatabase.retrieveUndelSubjectIds(clientId, message.getSubject(), subjectFilters));
                BrokerDatabase.updateVolatileTopicDBSizeCheckingAddSuccess(addSuccess);
            }
        }
        this.checkPeakMsgCount(start);
    }

    private long retrieveAndDebugGetSequenceNumber(IMgram message) throws EDatabaseException {
        long sequence = this.getNextSequenceNumber();
        message.getBrokerHandle().setSequenceNumber(sequence);
        if (this.DEBUG) {
            this.debug("message.getSequenceNumber() is: " + message.getBrokerHandle().getSequenceNumber());
        }
        return sequence;
    }

    void saveMsg(FastVector clients, FastVector proxyingClients, IMgram message, boolean jms_redelivery, boolean isReplicateable, LongHashTable subjectFilters) throws EDatabaseException, IOException {
        boolean addSuccess;
        int size;
        IClientContext cc;
        if (this.DEBUG) {
            this.debug("call into saveMsg, client ids are: " + clients.m_data + " and message is " + message.getBrokerHandle().getDbTracking());
        }
        int i = 0;
        long trackingNum = message.getBrokerHandle().getDbTracking();
        this.updateMaxAddedMessageId(trackingNum);
        String JMSMessageId = BrokerDatabase.retrieveJMSMessageId(message);
        long start = System.currentTimeMillis();
        long sequence = this.retrieveAndDebugMSquenceNumber(message);
        boolean fromRemoteBroker = BrokerDatabase.checkFromRemoteBroker(message);
        if (this.DEBUG) {
            this.debug("fromRemoteBroker: " + fromRemoteBroker);
        }
        Date timestamp = this.getDbTimestamp(message);
        this.addMessage(message, trackingNum, sequence, timestamp, JMSMessageId);
        start = this.addSaveMsgTimePassedSeconds(start);
        Date exp = BrokerDatabase.retrieveExp(message);
        if (clients != null) {
            for (i = 0; i < clients.m_count; ++i) {
                cc = (IClientContext)clients.m_data[i];
                long cid = cc.getId();
                size = message.getBrokerHandle().getTrackedSize();
                if (trackingNum > cc.maxDeletedMsgId()) {
                    addSuccess = this.addUndelMsgTx(message, cid, trackingNum, sequence, jms_redelivery, exp, timestamp, size, fromRemoteBroker, isReplicateable, BrokerDatabase.retrieveUndelSubjectIds(cid, message.getSubject(), subjectFilters));
                    this.addCCSizeTracker(addSuccess, cid, trackingNum, message.getBrokerHandle().getTrackedSize(), size, message.getBrokerHandle().isFromDB());
                    BrokerDatabase.updateVolatileTopicDBSizeCheckingAddSuccess(addSuccess);
                    continue;
                }
                this.addCCSizeTracker(false, cid, trackingNum, message.getBrokerHandle().getTrackedSize(), size, message.getBrokerHandle().isFromDB());
            }
        }
        if (proxyingClients != null) {
            for (i = 0; i < proxyingClients.m_count; ++i) {
                cc = (IClientContext)proxyingClients.m_data[i];
                long clientId = cc.getId();
                size = message.getBrokerHandle().getTrackedSize();
                if (trackingNum <= cc.maxDeletedMsgId()) continue;
                addSuccess = this.addUndelMsgTx(message, clientId, trackingNum, sequence, jms_redelivery, exp, timestamp, size, fromRemoteBroker, isReplicateable, BrokerDatabase.retrieveUndelSubjectIds(clientId, message.getSubject(), subjectFilters));
                this.addProxyCCSizeTracker(addSuccess, clientId, trackingNum, size);
                BrokerDatabase.updateVolatileTopicDBSizeCheckingAddSuccess(addSuccess);
            }
        }
        this.checkPeakMsgCount(start);
    }

    private static boolean checkFromRemoteBroker(IMgram message) {
        boolean fromRemoteBroker = false;
        if (InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(message.getBrokerHandle().getSenderID())) {
            fromRemoteBroker = true;
        }
        return fromRemoteBroker;
    }

    void saveMsg(UndelClientInfo[] clients, UndelClientInfo[] proxyingClients, IMgram message, boolean jms_redelivery, boolean fromRemoteBroker, boolean isReplicateable, LongHashTable subjectFilters) throws EDatabaseException, IOException {
        int size;
        int i = 0;
        long trackingNum = message.getGuarenteedTrackingNum();
        this.updateMaxAddedMessageId(trackingNum);
        String JMSMessageId = BrokerDatabase.retrieveJMSMessageId(message);
        long start = System.currentTimeMillis();
        long sequence = this.retrieveAndDebugMSquenceNumber(message);
        this.debugSequence(sequence);
        Date timestamp = this.getDbTimestamp(message);
        this.addMessage(message, trackingNum, sequence, timestamp, JMSMessageId);
        start = this.addSaveMsgTimePassedSeconds(start);
        Date exp = BrokerDatabase.retrieveExp(message);
        if (clients != null) {
            for (i = 0; i < clients.length; ++i) {
                long cid = clients[i].m_cid;
                size = message.getBrokerHandle().getTrackedSize();
                long maxDeletedMsgId = clients[i].m_maxDelMessageId;
                if (trackingNum <= maxDeletedMsgId) continue;
                boolean addSuccess = this.addUndelMsgTx(message, cid, trackingNum, sequence, jms_redelivery, exp, timestamp, size, fromRemoteBroker, isReplicateable, BrokerDatabase.retrieveUndelSubjectIds(cid, message.getSubject(), subjectFilters));
                BrokerDatabase.updateVolatileTopicDBSizeCheckingAddSuccess(addSuccess);
            }
        }
        if (proxyingClients != null) {
            for (i = 0; i < proxyingClients.length; ++i) {
                long clientId = proxyingClients[i].m_cid;
                size = message.getBrokerHandle().getTrackedSize();
                if (trackingNum <= proxyingClients[i].m_maxDelMessageId) continue;
                boolean addSuccess = this.addUndelMsgTx(message, clientId, trackingNum, sequence, jms_redelivery, exp, timestamp, size, fromRemoteBroker, isReplicateable, BrokerDatabase.retrieveUndelSubjectIds(clientId, message.getSubject(), subjectFilters));
                BrokerDatabase.updateVolatileTopicDBSizeCheckingAddSuccess(addSuccess);
            }
        }
        this.checkPeakMsgCount(start);
    }

    private long retrieveAndDebugMSquenceNumber(IMgram message) throws EDatabaseException {
        long sequence = this.getNextSequenceNumber();
        message.getBrokerHandle().setSequenceNumber(sequence);
        if (this.DEBUG) {
            this.debug("message.m_sequenceNumber is: " + message.getBrokerHandle().getSequenceNumber());
        }
        return sequence;
    }

    private static String retrieveJMSMessageId(IMgram message) {
        String JMSMessageId = null;
        if (message.getSubject() != null && !SessionConfig.isSystemSubject(message.getSubject())) {
            JMSMessageId = Envelope.getMessageID(message);
        }
        return JMSMessageId;
    }

    private static Date retrieveExp(IMgram message) {
        Date exp = null;
        if (message.isTTE()) {
            exp = new Date(message.getTTE());
        }
        return exp;
    }

    private long addSaveMsgTimePassedSeconds(long start) {
        this.populateElapsedTime(this.m_statSaveMsgTime, start);
        return System.currentTimeMillis();
    }

    private void checkPeakMsgCount(long start) {
        this.populateElapsedTime(this.m_statSaveUndelivMappingTime, start);
        ++this.m_CurrentMsgCount;
        if (this.m_CurrentMsgCount > this.m_PeakMsgCount) {
            this.m_PeakMsgCount = this.m_CurrentMsgCount;
        }
    }

    private void debugSequence(long sequence) {
        if (this.DEBUG) {
            this.debug("sequence is: " + sequence);
        }
    }

    static final Collection retrieveUndelSubjectIds(long cid, ISubject s, LongHashTable subjectFilters) {
        ISubjectFilter filter;
        Collection undelSubjectIds = null;
        if (subjectFilters != null && (filter = (ISubjectFilter)subjectFilters.get(cid)) != null) {
            undelSubjectIds = filter.filterTrackingNums(s);
        }
        return undelSubjectIds;
    }

    private void addCCSizeTracker(boolean addSuccess, long cid, long tracking, int oldSize, int newSize, boolean isMsgFromDB) throws EOperationCancelled {
        ICCSizeTracker tracker = null;
        try {
            tracker = AgentRegistrar.getAgentRegistrar().getClient(cid).getCCSizeTracker();
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
        if (tracker != null) {
            if (addSuccess) {
                try {
                    tracker.messageSaved(oldSize, newSize, tracking);
                }
                catch (ECounterFrozenException e) {
                    throw new EOperationCancelled();
                }
            } else if (isMsgFromDB) {
                if (this.DEBUG) {
                    this.debug("undelMsg is from DB, skip tracker.messageRemoved");
                }
            } else {
                tracker.messageRemoved(1, oldSize);
            }
        }
    }

    private void addProxyCCSizeTracker(boolean addSuccess, long cid, long tracking, int size) throws EOperationCancelled {
        ICCSizeTracker tracker = null;
        try {
            tracker = AgentRegistrar.getAgentRegistrar().getClient(cid).getCCSizeTracker();
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
        if (tracker != null && addSuccess) {
            try {
                tracker.messageProxySaved(size, tracking);
            }
            catch (ECounterFrozenException e) {
                throw new EOperationCancelled();
            }
        }
    }

    void addUndeliveredHeader(long cid, long tracking, long seqno, boolean redelivered, Date exp, Date timestamp, int size, boolean fromRemote, boolean replicateable, Collection undelSubjectIds) throws EDatabaseException {
        boolean addSuccess = this.m_pubSubDBQ.addUndelMsgTx(cid, tracking, seqno, redelivered, exp, timestamp, size, fromRemote, replicateable, undelSubjectIds);
        BrokerDatabase.updateVolatileTopicDBSizeCheckingAddSuccess(addSuccess);
    }

    private final boolean addUndelMsgTx(IMgram msg, long cid, long tracking, long seqno, boolean redelivered, Date exp, Date timestamp, int size, boolean fromRemoteBroker, boolean persistent, Collection undelSubjectIds) throws EDatabaseException {
        boolean wasHeaderSaved = msg.getBrokerHandle().isMsgHeaderSaved(cid);
        if (wasHeaderSaved) {
            return false;
        }
        return this.m_pubSubDBQ.addUndelMsgTx(cid, tracking, seqno, redelivered, exp, timestamp, size, fromRemoteBroker, persistent, undelSubjectIds);
    }

    void addMessage(IMgram message, long tracking, long sequence, Date timestamp, String JMSMessageID) throws EDatabaseException, IOException {
        boolean wasDBSaved;
        if (message.isTTE()) {
            this.expireMsgCounter();
        }
        if (!(wasDBSaved = message.getBrokerHandle().wasDBSaved()) || wasDBSaved && tracking <= this.m_maxDeletedMessageId) {
            boolean addSuccess = this.m_pubSubDBQ.addMessageTx(message, tracking, sequence, timestamp, JMSMessageID);
            message.getBrokerHandle().setDBSaved(true);
            BrokerDatabase.updateVolatileTopicDBSizeCheckingAddSuccess(addSuccess, message);
        }
    }

    public void beginRegDBTran() throws EDatabaseException {
        this.m_regDBQ.acquireLock();
    }

    public void releaseRegDBTran() {
        this.m_regDBQ.releaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitRegTran(boolean clearAllCids) throws EDatabaseException {
        this.m_regDBQ.commit();
        Hashtable hashtable = this.m_clientIdsInDb;
        synchronized (hashtable) {
            if (clearAllCids) {
                this.m_volatileCRegDeletes.clear();
                this.m_clientIdsInDb.clear();
                if (this.DEBUG1) {
                    this.debug("commitRegTran;  deleted all from m_clientIdsInDb");
                }
            } else if (!this.m_volatileCRegDeletes.isEmpty()) {
                if (this.DEBUG1) {
                    this.debug("commitRegTran;  deleted from m_clientIdsInDb; count= " + this.m_volatileCRegDeletes.size());
                }
                for (Long lid : this.m_volatileCRegDeletes) {
                    this.m_clientIdsInDb.remove(lid);
                }
                this.m_volatileCRegDeletes.clear();
            }
        }
    }

    public void commitRegTran() throws EDatabaseException {
        this.commitRegTran(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackRegTran() throws EDatabaseException {
        try {
            this.m_regDBQ.rollback();
        }
        finally {
            Hashtable hashtable = this.m_clientIdsInDb;
            synchronized (hashtable) {
                this.m_volatileCRegDeletes.clear();
            }
        }
    }

    public void beginRoutingDBTran() throws EDatabaseException {
        this.m_routingDBQ.acquireLock();
    }

    public void releaseRoutingDBTran() {
        this.m_routingDBQ.releaseLock();
    }

    public void rollbackRoutingTran() throws EDatabaseException {
        this.m_routingDBQ.rollback();
    }

    public void commitRoutingTran() throws EDatabaseException {
        this.m_routingDBQ.commit();
    }

    public void beginPubSubDBTran() throws EDatabaseException {
        this.m_pubSubDBQ.acquireLock();
    }

    public void releasePubSubDBTran() {
        this.m_pubSubDBQ.releaseLock();
    }

    public void commitPubSubTran() throws EDatabaseException {
        this.commitPubSubTran(false);
    }

    public void commitPubSubTran(boolean resetSaverDbSpace) throws EDatabaseException {
        long start = System.currentTimeMillis();
        this.updateInternalCountersTx();
        this.m_pubSubDBQ.commit();
        this.updateTopicDBSizeStat(resetSaverDbSpace);
        this.populateElapsedTime(this.m_statCommitTime, start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackPubSubTran() throws EDatabaseException {
        this.m_pubSubDBQ.rollback();
        Object object = m_totalTopicDBSizeSyncObj;
        synchronized (object) {
            m_volatileTopicDBSize = 0L;
        }
    }

    public void beginQueueDBTran() throws EDatabaseException {
        this.m_ptpDBQ.acquireLock();
    }

    public void releaseQueueDBTran() {
        this.m_ptpDBQ.releaseLock();
    }

    public void rollbackQueueTran() throws EDatabaseException {
        this.m_ptpDBQ.rollback();
    }

    public void commitQueueTran() throws EDatabaseException {
        this.updateQueueInternalCountersTx();
        this.m_ptpDBQ.commit();
    }

    boolean getJmsRedelivered(long cid, Long tracking) throws EDatabaseException {
        return this.m_pubSubDBQ.getJmsRedelivered(cid, tracking);
    }

    public void doUpdateRedelivery(long tracking, long client_id) throws EDatabaseException {
        this.doUpdateRedelivery(tracking, client_id, true);
    }

    void doUpdateRedelivery(Long tracking, long client_id) throws EDatabaseException {
        this.doUpdateRedelivery((long)tracking, client_id, true);
    }

    void doUpdateRedelivery(Long tracking, long client_id, boolean redelivered) throws EDatabaseException {
        this.doUpdateRedelivery((long)tracking, client_id, redelivered);
    }

    void doUpdateRedelivery(long message_id, long client_id, boolean redelivered) throws EDatabaseException {
        long start = System.currentTimeMillis();
        this.m_pubSubDBQ.updateRedeliveryTx(message_id, client_id, redelivered);
        if (this.debugStatsEnabled) {
            long time = System.currentTimeMillis() - start;
            this.m_statUpdateRedelivFlagTime.add(time * 1000L);
        }
    }

    void updateDeliveryInfo(Long tracking, long client_id, boolean redelivered, long seqno, Date exp, Date timestamp, int size, boolean fromRemote, boolean persistent, Collection undelSubjectIds) throws EDatabaseException {
        this.m_pubSubDBQ.updateDeliveryInfoTx(tracking, client_id, redelivered, seqno, exp, timestamp, size, fromRemote, persistent, undelSubjectIds);
    }

    LongHashTable getAllUndelMessageIDs() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("call into getAllUndelMessageIDs");
        }
        return this.m_pubSubDBQ.getAllUndelMessageIDs();
    }

    List restoreMsgs(IQueryCancelCheck qc, long client_id, MsgRestorePos pos, int count, boolean returnMsgBodies, int maxSizeOfBodies) throws EDatabaseException, EGeneralException, InterruptedIOException, InterruptedException {
        if (this.DEBUG) {
            this.debug("call into restoreMsgs, client_id is" + client_id);
        }
        long start = System.currentTimeMillis();
        List cont = this.m_pubSubDBQ.restoreMsgs(qc, client_id, pos, count, returnMsgBodies, maxSizeOfBodies);
        if (this.debugStatsEnabled) {
            long qtime = System.currentTimeMillis();
            this.m_statGetUndelivMsgsTime.add((qtime - start) * 1000L);
            start = qtime;
        }
        return cont;
    }

    List restoreMsgsForSMODurable(IQueryCancelCheck qc, long client_id, boolean doRemoteOnly, MsgRestorePos localPos, MsgRestorePos remotePos, int count, boolean returnMsgBodies, int maxSizeOfBodies) throws EDatabaseException, EGeneralException, InterruptedIOException, InterruptedException {
        if (this.DEBUG) {
            this.debug("call into restoreMsgsForSMODurable, client_id is" + client_id);
        }
        List cont = this.m_pubSubDBQ.restoreMsgsForSMODurable(qc, client_id, doRemoteOnly, localPos, remotePos, count, returnMsgBodies, maxSizeOfBodies);
        return cont;
    }

    public Collection getMgramsFromPosTx(long clientId, long tracking, long seq, int maxResults) throws InterruptedIOException, EDatabaseException {
        return this.m_pubSubDBQ.getMgramsFromPosTx(clientId, tracking, seq, maxResults);
    }

    public CountSizeUpdateInfo getCountSizeFromPosTx(long clientId, long minMessageId, long maxMessageId, int maxResults) throws InterruptedIOException, EDatabaseException {
        CountSizeUpdateInfo result = this.m_pubSubDBQ.getCountSizeFromPosTx(clientId, minMessageId, maxMessageId, maxResults);
        return result;
    }

    @Deprecated
    IMgram getMgram(Long sequence_number, Long message_id) throws EDatabaseException, InterruptedIOException {
        IMgram m = this.getMgram(message_id);
        if (m != null) {
            m.getBrokerHandle().setSequenceNumber(sequence_number);
            this.debugSequenceNumber(m);
        }
        return m;
    }

    IMgram getMgram(long message_id, long sequence_number) throws EDatabaseException, InterruptedIOException {
        IMgram m = this.getMgram(message_id);
        if (m != null) {
            m.getBrokerHandle().setSequenceNumber(sequence_number);
            this.debugSequenceNumber(m);
        }
        return m;
    }

    IMgram getMgram(Long message_id) throws EDatabaseException, InterruptedIOException {
        IMgram m = this.getMgram((long)message_id);
        return m;
    }

    public IMgram getOffloadedMgram(long tracking, long clientId) throws EDatabaseException, InterruptedIOException {
        IMgram m = null;
        long start = System.currentTimeMillis();
        m = this.m_pubSubDBQ.getOffloadedMgram(tracking, clientId);
        BrokerDatabase.configDbTrackingNumber(m, tracking);
        return this.addTimeToMgramTime(m, start);
    }

    IMgram getMgram(long message_id) throws EDatabaseException, InterruptedIOException {
        IMgram m = null;
        long start = System.currentTimeMillis();
        m = this.m_pubSubDBQ.getMgram(message_id);
        BrokerDatabase.configDbTrackingNumber(m, message_id);
        return this.addTimeToMgramTime(m, start);
    }

    private IMgram addTimeToMgramTime(IMgram m, long start) {
        if (this.debugStatsEnabled && m != null) {
            long time = System.currentTimeMillis() - start;
            this.m_statGetMgramTime.add(time * 1000L);
        }
        return m;
    }

    @Override
    public IMgram getMgramTx(long message_id) throws EDatabaseException, InterruptedIOException {
        IMgram m = null;
        m = this.m_pubSubDBQ.getMgramTx(message_id);
        BrokerDatabase.configDbTrackingNumber(m, message_id);
        return m;
    }

    private static void configDbTrackingNumber(IMgram m, long message_id) {
        if (m != null && !m.isGuarenteed()) {
            m.getBrokerHandle().setDbTracking(message_id);
        }
    }

    public IMgram getMgram(IQueryCancelCheck cancel, IDbRef ref, long seqno, long message_id, IMgram mg) throws EDatabaseException, InterruptedException, InterruptedIOException {
        IMgram m = mg;
        if (m == null) {
            m = this.m_pubSubDBQ.getMgram(cancel, ref);
        }
        if (m != null) {
            if (!m.isGuarenteed()) {
                m.getBrokerHandle().setDbTracking(message_id);
            }
            m.getBrokerHandle().setSequenceNumber(seqno);
            this.debugSequenceNumber(m);
        }
        return m;
    }

    private void debugSequenceNumber(IMgram m) {
        if (this.DEBUG) {
            this.debug("m.m_sequenceNumber is: " + m.getBrokerHandle().getSequenceNumber());
        }
    }

    public ClientDeliveryInfo getClientInfofromJMSMessageIDTx(String JMSMessageID, long clientId) throws EDatabaseException, InterruptedIOException {
        ClientDeliveryInfo result = this.m_pubSubDBQ.getClientInfofromJMSMessageIDTx(JMSMessageID, clientId);
        return result;
    }

    public MgramInfo getMgramInfoFromJMSMessageIDtx(String JMSMessageID) throws EDatabaseException, InterruptedIOException {
        return this.m_pubSubDBQ.getMgramInfoFromJMSMessageIDtx(JMSMessageID);
    }

    public SavedMsgStats getMessageCountAndSize(long client_id) throws EDatabaseException, InterruptedIOException {
        return this.m_pubSubDBQ.getMessageCountAndSize(client_id);
    }

    int getMsgCount() throws EDatabaseException {
        int count;
        if (this.DEBUG) {
            this.debug("call into getMsgCount");
        }
        if ((count = this.m_pubSubDBQ.getMessageCount()) > this.m_PeakMsgCount) {
            this.m_PeakMsgCount = count;
        }
        this.m_CurrentMsgCount = count;
        return count;
    }

    public void delSubjecTracking(long client_id, long tracking_number, short subject_tracking) throws EDatabaseException, EOperationCancelled {
        if (this.DEBUG) {
            this.debug("call into delSubjecTracking, client_id is" + client_id + " tracking_number is " + tracking_number + " subject tracking is " + subject_tracking);
        }
        if (this.m_pubSubDBQ.delUndelMsgSubjectCidTx(client_id, tracking_number, subject_tracking)) {
            this.delMsg(client_id, tracking_number, -1);
        }
    }

    public LongHashTable retrieveSubjectAckMappings(long id, long highestIndoubt) throws EDatabaseException {
        return this.m_pubSubDBQ.retrieveSubjectAckMappingsTx(id, highestIndoubt);
    }

    public int delMsg(long client_id, long tracking_number, int sizeParam) throws EDatabaseException, EOperationCancelled {
        int size = sizeParam;
        if (this.DEBUG) {
            this.debug("call into delMsg, client_id is" + client_id + " tracking_number is " + tracking_number);
        }
        long start = System.currentTimeMillis();
        int delcount = this.m_pubSubDBQ.delUndelMsgCidTrkTx(client_id, tracking_number);
        BrokerDatabase.updateVolatileTopicDBSize(-(delcount * 87));
        AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
        if (reg != null) {
            ICCSizeTracker tracker = null;
            try {
                tracker = AgentRegistrar.getAgentRegistrar().getClient(client_id).getCCSizeTracker();
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
            if (tracker != null && delcount > 0) {
                if (size == -1) {
                    size = this.m_pubSubDBQ.getMessageSizeTx(tracking_number);
                }
                try {
                    tracker.messageDeleted(size, tracking_number);
                }
                catch (ECounterFrozenException e) {
                    throw new EOperationCancelled();
                }
            }
        }
        this.populateElapsedTime(this.m_statDelMsgTime, start);
        this.updateMsgDeleteCount(delcount);
        return delcount;
    }

    private void populateElapsedTime(LTotStatsObj m_statDelMsgTime, long start) {
        if (this.debugStatsEnabled) {
            long now = System.currentTimeMillis();
            m_statDelMsgTime.add((now - start) * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMsgDeleteCount(int delcount) {
        BrokerDatabase brokerDatabase = this;
        synchronized (brokerDatabase) {
            this.msgs_assoc_deleted += delcount;
        }
        this.checkStartCleaner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long start = System.currentTimeMillis();
        if (this.DEBUG1) {
            this.debug("Cleaner thread starting ");
        }
        try {
            if (this.m_useDBQCleaner && this.m_pubSubDBQ instanceof IDbBatchMessageCleaner) {
                this.cleanPubSubMsgsUsingDBQCleaner();
            } else {
                this.cleanPubSubMsgs();
            }
        }
        catch (EDatabaseException e) {
            SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
        }
        finally {
            BrokerDatabase e = this;
            synchronized (e) {
                this.m_okToRunCleaner = true;
            }
        }
        long tm = System.currentTimeMillis() - start;
        if (this.DEBUG1) {
            this.debug("Cleaner thread terminated; duration(secs) = " + tm / 1000L);
        }
        this.checkStartCleaner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanPubSubMsgsUsingDBQCleaner() throws EDatabaseException {
        IDbBatchMessageCleaner pubSubDBQ = (IDbBatchMessageCleaner)((Object)this.m_pubSubDBQ);
        long cleanstartTime = System.currentTimeMillis();
        long lastId = -1L;
        long strtId = -1L;
        long maxDelSize = Config.PS_DB_QUEUE_SIZE / 4;
        IDbUndelMsgDeleteListener undelCB = new IDbUndelMsgDeleteListener(){

            @Override
            public void onUndelMsgDelete(long cid, long mid, int size) {
                Vector<Long> mid_vec;
                BrokerDatabase.updateVolatileTopicDBSize(-87L);
                ++DbCleanerInfo.numUndelExpiredBatch;
                ICCSizeTracker tracker = null;
                try {
                    tracker = AgentRegistrar.getAgentRegistrar().getClient(cid).getCCSizeTracker();
                }
                catch (EClientNotRegistered eClientNotRegistered) {
                    // empty catch block
                }
                if (tracker != null) {
                    try {
                        tracker.messageDeleted(size, mid);
                    }
                    catch (ECounterFrozenException e) {
                        BrokerDatabase.this.m_cancelCleaner = true;
                    }
                }
                if ((mid_vec = DbCleanerInfo.expiredMsgs.get(new Long(cid))) == null) {
                    mid_vec = new Vector();
                    DbCleanerInfo.expiredMsgs.put(new Long(cid), mid_vec);
                }
                mid_vec.addElement(new Long(mid));
            }
        };
        IDbMsgDeleteListener msgCB = new IDbMsgDeleteListener(){

            @Override
            public void onMsgDelete(long id, int size) {
                if (size > 0) {
                    BrokerDatabase.updateVolatileTopicDBSize(-(124 + size));
                    ++DbCleanerInfo.numDeletedBatch;
                }
                if (id > BrokerDatabase.this.m_maxDeletedMessageId) {
                    BrokerDatabase.this.m_maxDeletedMessageId = id;
                }
            }
        };
        long maxIdToClean = this.getMaxAddedMessageId();
        DbCleanerInfo.reset();
        if (this.DEBUG1) {
            this.debug("cleanPubSubMsgsUsingDBQCleaner() starting... maxId to clean= " + maxIdToClean + " " + new Date());
        }
        boolean continueLoop = true;
        int numBatches = 0;
        long ctProcessed = 0L;
        long exceptions = 0L;
        while (continueLoop && !Broker.exiting && !Broker.isInShutdown() && lastId < maxIdToClean) {
            this.beginPubSubDBTran();
            try {
                if (Broker.exiting || Broker.isInShutdown()) break;
                long[] res = pubSubDBQ.expireAndCleanMsgsBatchTx(strtId, maxIdToClean, Config.DB_CLEANUP_BATCH_SIZE, maxDelSize, undelCB, msgCB);
                lastId = res[1];
                ctProcessed += res[0];
                boolean forceCommit = false;
                if (res[2] > 0L) {
                    forceCommit = true;
                    ++exceptions;
                }
                if (this.m_cancelCleaner) {
                    throw new EOperationCancelled();
                }
                if (DbCleanerInfo.numUndelExpiredBatch + DbCleanerInfo.numDeletedBatch > 0L || forceCommit) {
                    this.commitPubSubTran();
                }
            }
            catch (EOperationCancelled eoc) {
                try {
                    if (this.DEBUG) {
                        this.debug("The broker is shutting down.  A durable subscription cannot be changed.  Rolling back.");
                    }
                    this.rollbackPubSubTran();
                }
                catch (EDatabaseException e) {
                    this.logException(e);
                }
                break;
            }
            catch (EDatabaseException ede) {
                try {
                    this.logAndRollback();
                    SessionConfig.logMessage(ede, SessionConfig.getLevelWarning());
                }
                catch (EDatabaseException e) {
                    this.logException(e);
                }
                break;
            }
            finally {
                this.releasePubSubDBTran();
            }
            ++numBatches;
            AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
            for (Long cidL : DbCleanerInfo.expiredMsgs.keySet()) {
                Vector<Long> vec = DbCleanerInfo.expiredMsgs.get(cidL);
                if (vec == null) continue;
                IClientContext cc = null;
                try {
                    cc = reg.getClient(cidL);
                }
                catch (EClientNotRegistered ecnr) {
                    continue;
                }
                for (Long midL : vec) {
                    cc.clearDbExpiredMsg(midL);
                }
            }
            DbCleanerInfo.endBatch();
            if (this.DEBUG1 && numBatches % 1000 == 0) {
                this.debug("cleanPubSubMsgsUsingDBQCleaner; numBatches " + numBatches + ", numProcessed= " + ctProcessed + ", deleted " + DbCleanerInfo.numDeletedTotal + ", undelexpired " + DbCleanerInfo.numUndelExpiredTotal + " " + new Date());
            }
            if (lastId == -1L) break;
            strtId = lastId + 1L;
            Thread.currentThread();
            Thread.yield();
        }
        long elapsedTime = System.currentTimeMillis() - cleanstartTime;
        long deletedCount = DbCleanerInfo.numDeletedTotal + DbCleanerInfo.numUndelExpiredTotal;
        if (deletedCount > 0L) {
            BrokerManagementNotificationsHelper.sendMessagePubSubCleanupFinishedNotification(deletedCount, elapsedTime);
        }
        if (this.DEBUG1) {
            this.debug("Completed cleanPubSubMsgsUsingDBQCleaner; numBatches " + numBatches + ", numProcessed= " + ctProcessed + ", deleted " + DbCleanerInfo.numDeletedTotal + ", undelexpired " + DbCleanerInfo.numUndelExpiredTotal + ", time(ms)= " + elapsedTime);
        }
        if (exceptions > 0L) {
            Object[] obj = new Object[]{new Long(exceptions).toString()};
            String s = prMessageFormat.format(prAccessor.getString("DbCleanerDeleteInfo"), obj);
            BrokerComponent.getComponentContext().logMessage(s, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanPubSubMsgs() throws EDatabaseException {
        long start = System.currentTimeMillis();
        long time = 0L;
        long numDeleted = 0L;
        long numProcessed = 0L;
        long numExpired = 0L;
        long lastId = -1L;
        Vector message_ids = null;
        long maxIdToClean = this.getMaxAddedMessageId();
        if (this.DEBUG1) {
            this.debug("cleanPubSubMsgs() starting... maxId to clean= " + maxIdToClean + " " + new Date());
        }
        while ((message_ids = this.m_pubSubDBQ.getAllMessageIDs(lastId, Config.DB_CLEANUP_BATCH_SIZE)) != null) {
            long endIdBatch;
            int m_length = message_ids.size();
            if (this.DEBUG) {
                time = System.currentTimeMillis() - start;
                this.debug("cleanPubSubMsgs: got list of MessageIds; startId= " + lastId + " size= " + m_length + " time(secs)= " + time / 1000L);
                if (m_length > 0) {
                    this.debug("cleanPubSubMsgs: got list of MessageIds; minId= " + message_ids.elementAt(0) + " maxId= " + message_ids.elementAt(message_ids.size() - 1));
                }
                start = System.currentTimeMillis();
            }
            if (m_length == 0 || Broker.exiting || Broker.isInShutdown()) break;
            Thread.currentThread();
            Thread.yield();
            numProcessed += (long)m_length;
            boolean continueLoop = true;
            if (m_length < Config.DB_CLEANUP_BATCH_SIZE) {
                continueLoop = false;
            }
            long startIdBatch = (Long)message_ids.elementAt(0);
            lastId = endIdBatch = ((Long)message_ids.elementAt(message_ids.size() - 1)).longValue();
            if (maxIdToClean == 0L) {
                maxIdToClean = this.getMaxAddedMessageId();
            }
            if (maxIdToClean > 0L && endIdBatch > maxIdToClean) {
                continueLoop = false;
            }
            Vector<Long> ids_to_delete = new Vector<Long>(5, 10);
            int exp = this.expirePubSubMsgs(startIdBatch, endIdBatch);
            numExpired += (long)exp;
            if (this.DEBUG) {
                time = System.currentTimeMillis() - start;
                this.debug("cleanPubSubMsgs: cleaned expired messages in UndelMsgs; time(secs)= " + time / 1000L);
                start = System.currentTimeMillis();
            }
            if (Broker.exiting || Broker.isInShutdown()) break;
            Thread.currentThread();
            Thread.yield();
            LongHashTable refs = this.m_pubSubDBQ.getMsgRefCount(startIdBatch, endIdBatch);
            if (Broker.exiting || Broker.isInShutdown()) break;
            Thread.currentThread();
            Thread.yield();
            if (this.DEBUG) {
                time = System.currentTimeMillis() - start;
                this.debug("cleanPubSubMsgs: got list of refs; size= " + refs.size() + " time(secs)= " + time / 1000L);
                start = System.currentTimeMillis();
            }
            Enumeration enu = message_ids.elements();
            while (enu.hasMoreElements()) {
                Long id = (Long)enu.nextElement();
                long lid = id;
                if (refs.get(lid) != null) continue;
                AgentGuarMsgTracker trk = null;
                try {
                    trk = AgentGuarMsgTracker.getTracker(lid);
                }
                catch (ETrackingNumNotFound eTrackingNumNotFound) {
                    // empty catch block
                }
                if (trk != null && !trk.isDelivered()) continue;
                ids_to_delete.addElement(id);
            }
            m_length = ids_to_delete.size();
            if (this.DEBUG) {
                time = System.currentTimeMillis() - start;
                this.debug("cleanPubSubMsgs: after client count check; messageids to delete count is: " + m_length + " time(secs)= " + time / 1000L);
                start = System.currentTimeMillis();
            }
            if (Broker.exiting || Broker.isInShutdown()) break;
            int numDeletedInCleanupBatch = 0;
            if (m_length != 0) {
                int numToTryDelete = m_length;
                int strtIndx = 0;
                int endIndx = 0;
                while (numToTryDelete > 0) {
                    int k;
                    int thisBatchSize;
                    block34: {
                        thisBatchSize = 0;
                        if (numToTryDelete > Config.DB_COMMIT_BATCH_SIZE) {
                            endIndx = strtIndx + Config.DB_COMMIT_BATCH_SIZE - 1;
                            thisBatchSize = Config.DB_COMMIT_BATCH_SIZE;
                        } else {
                            endIndx = strtIndx + numToTryDelete - 1;
                            thisBatchSize = numToTryDelete;
                        }
                        k = 0;
                        if (this.DEBUG) {
                            this.debug("numToTryDelete= " + numToTryDelete + " strtIndx= " + strtIndx + " endIndx= " + endIndx);
                        }
                        this.beginPubSubDBTran();
                        if (!Broker.exiting && !Broker.isInShutdown()) break block34;
                        this.releasePubSubDBTran();
                        break;
                    }
                    try {
                        for (int i = strtIndx; i <= endIndx; ++i) {
                            long tracking = (Long)ids_to_delete.elementAt(i);
                            if (this.DEBUG) {
                                this.debug("tracking to delete is: " + tracking);
                            }
                            int size = this.m_pubSubDBQ.getMessageSizeTx(tracking);
                            boolean deleted = this.m_pubSubDBQ.delMessageTx(tracking);
                            if (this.DEBUG) {
                                this.debug("able to run m_delMessage");
                            }
                            if (!deleted) continue;
                            BrokerDatabase.updateVolatileTopicDBSize(-(124 + size));
                            ++numDeletedInCleanupBatch;
                            ++k;
                            if (tracking <= this.m_maxDeletedMessageId) continue;
                            this.m_maxDeletedMessageId = tracking;
                        }
                        this.commitPubSubTran();
                        this.releasePubSubDBTran();
                    }
                    catch (EDatabaseException se) {
                        try {
                            try {
                                if (this.DEBUG) {
                                    this.debug("An sql exception occurred in cleanPubSubMsgs().  Rolling back.");
                                }
                                this.rollbackPubSubTran();
                                throw se;
                            }
                            catch (EDatabaseException e) {
                                if (this.DEBUG) {
                                    this.debug("An sql exception occurred during roll back.");
                                }
                                SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
                                this.releasePubSubDBTran();
                            }
                        }
                        catch (Throwable throwable) {
                            this.releasePubSubDBTran();
                            throw throwable;
                        }
                    }
                    numToTryDelete -= thisBatchSize;
                    strtIndx = endIndx + 1;
                    if (this.DEBUG) {
                        this.debug("cleanPubSubMsgs: deleted " + k + " messages " + new Date());
                    }
                    if (Broker.exiting || Broker.isInShutdown()) break;
                    Thread.currentThread();
                    Thread.yield();
                }
                if (this.DEBUG) {
                    time = System.currentTimeMillis() - start;
                    this.debug("CleanPubSubMsgs Deleted messages; num= " + numDeletedInCleanupBatch + " time (secs)= " + time / 1000L);
                    start = System.currentTimeMillis();
                }
            }
            if (Broker.exiting || Broker.isInShutdown()) break;
            this.m_CurrentMsgCount -= numDeletedInCleanupBatch;
            numDeleted += (long)numDeletedInCleanupBatch;
            if (this.DEBUG1 && numProcessed % 100000L == 0L) {
                this.debug("cleanPubSubMsgs; processed " + numProcessed + ", deleted " + numDeleted + ", expired " + numExpired + " " + new Date());
            }
            if (continueLoop) continue;
            break;
        }
        if (this.DEBUG1) {
            this.debug("Completed cleanPubSubMsgs; processed " + numProcessed + ", deleted " + numDeleted + ", expired " + numExpired + " " + new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int expirePubSubMsgs(long minTracking, long maxTracking) throws EDatabaseException {
        long start = System.currentTimeMillis();
        MessageIDClientDeliveryInfo midCDI = this.m_pubSubDBQ.getUndelExpCIdsBatch(minTracking, maxTracking);
        Vector expiredMessageIds = midCDI.getMsgIds();
        if (BrokerDatabase.checkBrokerStarted()) {
            return 0;
        }
        int messageCount = expiredMessageIds.size();
        start = this.logInputParameters(start, messageCount);
        int numDeleted = 0;
        if (messageCount > 0) {
            int numToDelete = messageCount;
            int strtIndx = 0;
            int processedCount = 0;
            while (numToDelete > 0) {
                int thisBatchSize;
                int endIndx;
                if (numToDelete > Config.DB_COMMIT_BATCH_SIZE) {
                    endIndx = strtIndx + Config.DB_COMMIT_BATCH_SIZE - 1;
                    thisBatchSize = Config.DB_COMMIT_BATCH_SIZE;
                } else {
                    endIndx = strtIndx + numToDelete - 1;
                    thisBatchSize = numToDelete;
                }
                this.logBatchStats(numToDelete, strtIndx, endIndx);
                this.beginPubSubDBTran();
                try {
                    for (int i = strtIndx; i <= endIndx; ++i) {
                        this.deleteMessage(midCDI, expiredMessageIds, i);
                        ++processedCount;
                    }
                    this.commitPubSubTran();
                }
                catch (EDatabaseException ede) {
                    this.rollbackEDatabaseException(ede);
                }
                catch (EOperationCancelled eoc) {
                    this.rollbackOnEOperationCancelled(eoc);
                }
                finally {
                    this.releasePubSubDBTran();
                }
                numToDelete -= thisBatchSize;
                numDeleted += thisBatchSize;
                strtIndx = endIndx + 1;
                if (this.DEBUG) {
                    this.debug(String.format(NUM_DELETED_MESSAGE, thisBatchSize, new Date()));
                }
                if (Broker.exiting || Broker.isInShutdown()) {
                    return numDeleted;
                }
                Thread.yield();
            }
            this.logTimeSpent(start, processedCount);
        }
        this.expireCcMsgs(midCDI, numDeleted);
        return numDeleted;
    }

    private void logBatchStats(int numToDelete, int strtIndx, int endIndx) {
        if (this.DEBUG) {
            this.debug(String.format("numToDelete= %s strtIndx= %s endIndx= %s", numToDelete, strtIndx, endIndx));
        }
    }

    private void logTimeSpent(long start, int numDeleted) {
        if (this.DEBUG) {
            this.debug(String.format(NUM_DELETED_TIME, numDeleted, (System.currentTimeMillis() - start) / 1000L));
        }
    }

    private long logInputParameters(long start, int messageCount) {
        if (this.DEBUG) {
            this.debug(String.format(INPUT_PARAMETER_MESSAGE, messageCount, (System.currentTimeMillis() - start) / 1000L));
            return System.currentTimeMillis();
        }
        return start;
    }

    private static boolean checkBrokerStarted() {
        Thread.yield();
        return Broker.exiting || Broker.isInShutdown();
    }

    private void deleteMessage(MessageIDClientDeliveryInfo midCDI, List<Long> expiredMessageIds, int i) throws EDatabaseException, EOperationCancelled {
        int delCount;
        long tracking = expiredMessageIds.get(i);
        if (this.DEBUG) {
            this.debug("message_id to delete is: " + tracking);
        }
        if ((delCount = this.m_pubSubDBQ.delUndelMsgTrkTx(tracking)) > 0) {
            midCDI.updateCCSizeInfo(tracking);
        }
        BrokerDatabase.updateVolatileTopicDBSize(-(delCount * 87));
        if (this.DEBUG) {
            this.debug("Deleted message associations");
        }
    }

    private void rollbackOnEOperationCancelled(EOperationCancelled eoc) {
        try {
            if (this.DEBUG) {
                this.debug(THE_BROKER_IS_SHUTTING_DOWN_MESSAGE, eoc);
            }
            this.rollbackPubSubTran();
        }
        catch (EDatabaseException e) {
            this.logException(e);
        }
    }

    private void rollbackEDatabaseException(EDatabaseException ede) {
        try {
            this.logAndRollback();
            SessionConfig.logMessage(ede, SessionConfig.getLevelWarning());
        }
        catch (EDatabaseException e) {
            this.logException(e);
        }
    }

    private void logException(EDatabaseException e) {
        if (this.DEBUG) {
            this.debug("A general exception occurred during roll back.");
        }
        SessionConfig.logMessage(e, SessionConfig.getLevelWarning());
    }

    private void logAndRollback() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("A database exception occurred in expirePubSubMsgs().  Rolling back.");
        }
        this.rollbackPubSubTran();
    }

    private void expireCcMsgs(MessageIDClientDeliveryInfo midCDI, int numDeleted) {
        if (numDeleted > 0) {
            midCDI.expireCCMsgs();
        }
        if (this.DEBUG) {
            this.debug(String.format("Completed expirePubSubMsgs(UndelMsgs); deleted %s messages; %s", numDeleted, new Date()));
        }
    }

    private int updateMessageCountsExpiration(long message_id) throws EDatabaseException, EOperationCancelled {
        LongHashTable clients = this.m_pubSubDBQ.getUndelClientsByMsgTx(message_id);
        Enumeration clientEnum = clients.elements();
        int size = -1;
        while (clientEnum.hasMoreElements()) {
            ClientDeliveryInfo info = (ClientDeliveryInfo)clientEnum.nextElement();
            long cid = info.cid;
            if (size == -1) {
                size = info.size;
            }
            ICCSizeTracker tracker = null;
            try {
                tracker = AgentRegistrar.getAgentRegistrar().getClient(cid).getCCSizeTracker();
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
            if (tracker == null) continue;
            try {
                tracker.messageDeleted(size, info.messageid);
            }
            catch (ECounterFrozenException e) {
                throw new EOperationCancelled();
            }
        }
        if (size == -1) {
            size = 0;
        }
        return size;
    }

    void delClientSubscriptions(PSEClient client) throws EDatabaseException {
        this.m_regDBQ.deleteClientSubscriptions(client);
    }

    void delClientSubscriptions(IClientContext client) throws EDatabaseException {
        this.delClientSubscriptions(client.getId());
    }

    void delClientSubscriptions(long cid) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("call into delClientSubscriptions, cid is " + cid);
        }
        this.m_regDBQ.deleteClientSubscriptions(cid);
        if (this.DEBUG) {
            this.debug("able to run m_delAllSubscriptions in delClientSubscriptions");
        }
    }

    void saveClientDBSubscriptions(long cid, Vector dbSubscriptions) throws EDatabaseException, ClassCastException, IOException {
        this.debugCallIntoSaveClientSubscriptions(cid);
        Enumeration enum_subs = dbSubscriptions.elements();
        while (enum_subs.hasMoreElements()) {
            this.debugEnumerationOfSubscriptionsInProgress();
            DBSubscription subscription = (DBSubscription)enum_subs.nextElement();
            this.saveDBSubscription(subscription);
        }
        if (this.DEBUG) {
            this.debug("able to run subscription updates in saveClientSubscriptions");
        }
    }

    void saveClientSubscriptions(IClientContext client, PSEClient pseClient) throws EDatabaseException, IOException {
        if (this.DEBUG) {
            this.debug("call into saveClientSubscriptions, client is " + client);
        }
        if (BrokerLicenseMgr.getLicenseMgr().isEnterpriseEdition()) {
            this.delClientSubscriptions(pseClient);
        } else {
            this.delClientSubscriptions(client);
        }
        if (this.DEBUG) {
            this.debug("able to run m_delAllSubscriptions in saveClient");
        }
        Enumeration enum_subs = client.getSubscriptions().elements();
        while (enum_subs.hasMoreElements()) {
            this.debugEnumerationOfSubscriptionsInProgress();
            BrokerSubscription subscription = (BrokerSubscription)enum_subs.nextElement();
            this.saveSubscription(subscription);
        }
        if (this.DEBUG) {
            this.debug("able to run subscription updates in saveClient");
        }
    }

    void saveClientSubscriptions(long cid, Collection subs) throws EDatabaseException, ClassCastException, IOException {
        this.debugCallIntoSaveClientSubscriptions(cid);
        if (subs != null) {
            Iterator iter = subs.iterator();
            while (iter.hasNext()) {
                this.debugEnumerationOfSubscriptionsInProgress();
                BrokerSubscription subscription = (BrokerSubscription)iter.next();
                this.saveSubscription(subscription);
            }
        }
        if (this.DEBUG) {
            this.debug("able to run subscription updates in saveClientSubscriptions");
        }
    }

    private void debugEnumerationOfSubscriptionsInProgress() {
        if (this.DEBUG) {
            this.debug("enumeration of subscriptions in progress in saveClientSubscriptions");
        }
    }

    private void debugCallIntoSaveClientSubscriptions(long cid) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("call into saveClientSubscriptions");
        }
        this.delClientSubscriptions(cid);
    }

    void saveDBSubscription(DBSubscription sub) throws EDatabaseException, IOException {
        this.saveSubscription(sub.getClient(), sub.getLabel().isPersistent(), sub.getSubject(), sub.getLabel().getExpiration(), sub.getTTE(), sub.getLabel().isGuaranteed(), sub.getSelectorStrs(), sub.getSelectorAtBroker(), sub.getUnfiltered(), sub.getVirtualClock(), sub.getCreationTime(), sub.getPreviousBrokerCID(), sub.getRestoreToBrokerCID(), sub.getDurableStrictMessageOrder(), sub.getInDoubtProxies());
    }

    void saveSubscription(BrokerSubscription sub) throws EDatabaseException, IOException {
        this.saveSubscription(sub.getClient().getId(), sub.getLabel().isPersistent(), sub.getSubject(), sub.getLabel().getExpiration(), sub.getTTE(), sub.getLabel().isGuaranteed(), sub.getSelectorStrings(), sub.getSelectorAtBroker(), sub.getUnfiltered(), sub.getVirtualClock(), sub.getCreationTime(), sub.getPreviousBrokerCID(), sub.getRestoreToBrokerCID(), sub.getDurableStrictMessageOrder(), sub.getInDoubtProxies());
    }

    void saveSubscription(long cid, boolean isPersistent, ISubject subject, Date expireTime, long tte, boolean isGuaranteed, String[] selectorStrs, boolean isSelectorAtBroker, boolean unfiltered, GSVirtualClock virtualClock, long creationTime, long previousBrokerCID, long restoreToBrokerCID, boolean isSMOEnabled, HashSet inDoubtProxies) throws EDatabaseException, IOException {
        if (isPersistent) {
            this.m_regDBQ.saveClientSubscription(cid, subject, expireTime, tte, isGuaranteed, selectorStrs, isSelectorAtBroker, unfiltered, virtualClock, creationTime, previousBrokerCID, restoreToBrokerCID, isSMOEnabled, inDoubtProxies);
        }
    }

    void saveClient(IClientContext client) throws EDatabaseException, IOException {
        this.saveClient(client, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveClient(IClientContext clientContext, boolean saveSubs) throws EDatabaseException, IOException {
        this.logClient(clientContext);
        try {
            PSEClient pseClient = this.m_regDBQ.saveClient(clientContext.getId(), clientContext.isInterbroker(), clientContext.getCSC(), clientContext.getLastConnectedTime());
            Long cidL = new Long(clientContext.getId());
            Hashtable hashtable = this.m_clientIdsInDb;
            synchronized (hashtable) {
                this.addCidlToClientIdsInDb(cidL);
            }
            if (saveSubs) {
                this.saveClientSubscriptions(clientContext, pseClient);
            }
        }
        catch (EDatabaseException e) {
            throw new EDatabaseException(prAccessor.getString("STR057"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveClient(IClientContext client, Collection subs) throws EDatabaseException, IOException {
        this.logClient(client);
        try {
            this.m_regDBQ.saveClient(client.getId(), client.isInterbroker(), client.getCSC(), client.getLastConnectedTime());
            Long cidL = new Long(client.getId());
            Hashtable hashtable = this.m_clientIdsInDb;
            synchronized (hashtable) {
                this.addCidlToClientIdsInDb(cidL);
            }
            this.saveClientSubscriptions(client.getId(), subs);
        }
        catch (EDatabaseException e) {
            throw new EDatabaseException(prAccessor.getString("STR057"));
        }
    }

    private void logClient(IClientContext client) {
        if (this.DEBUG) {
            this.debug("call into saveClient, client is " + client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delClient(long client_id) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("call into delClient");
        }
        this.m_regDBQ.deleteClientSubscriptions(client_id);
        this.m_regDBQ.deleteClient(client_id);
        Long cidL = new Long(client_id);
        Hashtable hashtable = this.m_clientIdsInDb;
        synchronized (hashtable) {
            this.m_volatileCRegDeletes.addElement(cidL);
        }
    }

    LongHashTable getUndelClientsByMsg(Long tracking) throws EDatabaseException {
        return this.m_pubSubDBQ.getUndelClientsByMsg(tracking);
    }

    LongHashTable getAllClientAttributes() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("call into getAllClientAttributes");
        }
        LongHashTable ht = this.m_regDBQ.getAllClients();
        Enumeration<Long> enu = ht.keys();
        while (enu.hasMoreElements()) {
            Long cidL = enu.nextElement();
            this.addCidlToClientIdsInDb(cidL);
        }
        if (this.DEBUG1) {
            this.debug("getAllClientAttributes added to m_clientIdsInDb ct= " + ht.size());
        }
        return ht;
    }

    private void addCidlToClientIdsInDb(Long cidL) {
        if (!this.m_clientIdsInDb.containsKey(cidL)) {
            this.m_clientIdsInDb.put(cidL, cidL);
        }
    }

    Vector getClientSubscriptions(long cid) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("call into getClientSubscriptions");
        }
        return this.m_regDBQ.getClientSubscriptions(cid);
    }

    Vector getSubscriptions() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("call into getSubscriptions");
        }
        return this.m_regDBQ.getAllClientSubscriptions();
    }

    SyncpointLoc getSyncPtLoc() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("call into getSyncPtLoc");
        }
        SyncpointLoc l_syncpoint = this.m_regDBQ.getSyncPtLoc();
        if (this.DEBUG) {
            this.debug("about to return l_syncpoint: " + l_syncpoint);
        }
        return l_syncpoint;
    }

    void writeSyncPtLoc(SyncpointLoc spl) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("call into writeSyncPtLoc");
        }
        this.m_regDBQ.setSyncPtLoc(spl);
    }

    byte getSecurityMode() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("call into getSecurityMode");
        }
        byte m_secattr = this.m_regDBQ.getSecurityMode();
        if (this.DEBUG) {
            this.debug("After getSecurityMode m_secattr is: " + m_secattr);
        }
        return m_secattr;
    }

    public int getBrokerLastKnownState() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("call into getBrokerLastKnownState");
        }
        int state = this.m_regDBQ.getBrokerLastKnownState();
        this.debugBrokerLastKnownState(state);
        return state;
    }

    public void setBrokerLastKnownState(int state) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("call into setBrokerLastKnownState");
        }
        this.m_regDBQ.setBrokerLastKnownState(state);
        this.debugBrokerLastKnownState(state);
    }

    private void debugBrokerLastKnownState(int state) {
        if (this.DEBUG) {
            this.debug("Broker last known state is " + BrokerStatus.State.get(state));
        }
    }

    int getPeakMsgCount() {
        if (this.DEBUG) {
            this.debug("call into getPeakMsgCount");
        }
        return this.m_PeakMsgCount;
    }

    void resetPeakMsgCount() throws EDatabaseException {
        int msgCount;
        if (this.DEBUG) {
            this.debug("call into resetPeakMsgCount");
        }
        this.m_PeakMsgCount = msgCount = this.getMsgCount();
    }

    public static Class[] getDelMsgsParams() {
        return (Class[])s_delMsgsParams.clone();
    }

    public int delMsgs(long clientID) throws EDatabaseException {
        long strt = 0L;
        if (this.DEBUG1) {
            this.debug("call into delMsgs(long clientID), client_id is " + clientID);
            strt = System.currentTimeMillis();
        }
        int del_count = this.m_pubSubDBQ.delUndelMsgsCidTx(clientID);
        if (this.DEBUG1) {
            long time = (System.currentTimeMillis() - strt + 500L) / 1000L;
            if (del_count > 0) {
                this.debug("delMsgs: deleted all msgs for client " + clientID + " ct= " + del_count + " msgs; time(secs)= " + time);
            }
        }
        BrokerDatabase.updateVolatileTopicDBSize(-(del_count * 87));
        this.updateMsgDeleteCount(del_count);
        return del_count;
    }

    int delMsgs(long clientID, long messageId, int batchsize) throws EDatabaseException {
        this.debugClientId(clientID);
        long strt = 0L;
        if (this.DEBUG1) {
            strt = System.currentTimeMillis();
        }
        int del_count = this.m_pubSubDBQ.delUndelMsgsCidTx(clientID, messageId, batchsize);
        if (this.DEBUG1) {
            long time = (System.currentTimeMillis() - strt + 500L) / 1000L;
            if (del_count > 0 && del_count != batchsize) {
                this.debug("DelMsgs: deleted msgs for client " + clientID + " maxMsgId= " + messageId + " ct= " + del_count + " msgs; time(secs)= " + time);
            }
        }
        BrokerDatabase.updateVolatileTopicDBSize(-(del_count * 87));
        if (this.DEBUG) {
            this.debug("delMsgs, deleted " + del_count + " messages for client_id " + clientID);
        }
        this.updateMsgDeleteCount(del_count);
        return del_count;
    }

    public void deleteClientRegistryDbData() throws EDatabaseException {
        this.beginRegDBTran();
        try {
            this.m_regDBQ.clearClientRegistryDbData();
            this.commitRegTran(true);
        }
        catch (EDatabaseException ex) {
            try {
                this.rollbackRegTran();
            }
            catch (EDatabaseException eDatabaseException) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            this.releaseRegDBTran();
        }
    }

    public void deleteRBRegistryDbData() throws EDatabaseException {
        Vector rbs = this.m_routingDBQ.getRemoteBrokers();
        Enumeration enu = rbs.elements();
        while (enu.hasMoreElements()) {
            Object[] rb = (Object[])enu.nextElement();
            long cid = (Long)rb[0];
            this.m_routingDBQ.deleteRemoteBroker(cid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRouteInfoDbData() throws EDatabaseException {
        Vector routes = this.m_routingDBQ.getRoutes();
        Enumeration enu = routes.elements();
        this.m_routingDBQ.acquireLock();
        try {
            while (enu.hasMoreElements()) {
                RouteInfo route = (RouteInfo)enu.nextElement();
                this.m_routingDBQ.deleteRoutesByNodeGlobalBrokerTx(route.getNodeName(), route.getGlobalName(), route.getBrokerName());
            }
            this.m_routingDBQ.commit();
        }
        finally {
            this.m_routingDBQ.releaseLock();
        }
    }

    void deleteNonDurableUndelMsgs(long maxMessageId) throws EDatabaseException {
        Vector allUndelClients = this.m_pubSubDBQ.getAllUndelClients();
        if (allUndelClients == null) {
            return;
        }
        for (int ii = 0; ii < allUndelClients.size(); ++ii) {
            long clientId = (Long)allUndelClients.elementAt(ii);
            IClientContext cc = null;
            try {
                cc = AgentRegistrar.getAgentRegistrar().getClient(clientId);
            }
            catch (EClientNotRegistered ecne) {
                cc = null;
            }
            if (cc != null && (!SessionConfig.isNonDurableSubscriber(cc.getAppid()) || !SessionConfig.isFlowToDiskSupported(cc.getAppid()) && !cc.isXOnce())) continue;
            if (this.checkDebugFlags(64)) {
                this.debug("Deleting all msgs in db for " + cc + " cid= " + clientId);
            }
            AgentRegistrar.getAgentRegistrar().getDeleteSubscriptionManager().beginDeleteSubscription(cc, clientId, maxMessageId, true, true);
        }
    }

    long getLastConnectionID() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("entering getLastConnectionIDd");
        }
        long id = this.m_regDBQ.getLastConnectionID();
        if (this.DEBUG) {
            this.debug("Last JMS connection id = " + id);
        }
        return id;
    }

    void setLastConnectionID(long id) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("Saving last JMS connection ID = " + id);
        }
        this.m_regDBQ.setLastConnectionID(id);
        if (this.DEBUG) {
            this.debug("leaving setLastConnectionID");
        }
    }

    public long getLogTime() throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("entering getLogTime");
        }
        long lt = this.m_regDBQ.getLogTime();
        if (this.DEBUG) {
            this.debug("leaving getLogTime");
        }
        return lt;
    }

    public static List getMetricsInfo() {
        if (Config.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("BrokerDatabase - getMetricsInfo ", 3);
        }
        ArrayList<IMetricInfo> infos = new ArrayList<IMetricInfo>();
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_BYTES_TOPIC_DB_SIZE_METRIC, (short)0, (String)"Total size in bytes of topic message store.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (String)BROKER_BYTES_TOPIC_DB_SIZE_METRIC_UNITS));
        infos.add(MetricsFactory.createMetricInfo((IMetricIdentity)BROKER_BYTES_FTD_MEMORY_SIZE_METRIC, (short)0, (String)"Total size in bytes of in-memory allocations associated with messages offloaded to the message store due to Flow To Disk.", null, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (String)BROKER_BYTES_FTD_MEMORY_SIZE_METRIC_UNITS));
        return infos;
    }

    public static synchronized void enableMetrics(IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals((Object)BROKER_BYTES_TOPIC_DB_SIZE_METRIC)) {
                BrokerDatabase.logMessage(BROKER_BYTES_TOPIC_DB_SIZE_METRIC);
                if (m_totalTopicDBSizeStat != null) continue;
                IStatisticProvider[] topicDBSizeProviders = new IStatisticProvider[]{new IStatisticProvider(){

                    public void updateStatistic(ISampledStatistic statistic) {
                        statistic.updateValue(m_totalTopicDBSize);
                    }

                    public void resetStatistic(ISampledStatistic statistic) {
                    }
                }};
                m_totalTopicDBSizeStat = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])topicDBSizeProviders, (short)0);
                metricsRegistrar.registerMetric(BROKER_BYTES_TOPIC_DB_SIZE_METRIC, m_totalTopicDBSizeStat);
                continue;
            }
            if (!ids[i].equals((Object)BROKER_BYTES_FTD_MEMORY_SIZE_METRIC)) continue;
            BrokerDatabase.logMessage(BROKER_BYTES_FTD_MEMORY_SIZE_METRIC);
            if (m_ftdMemorySizeStat != null) continue;
            IStatisticProvider[] ftdMemorySizeProviders = new IStatisticProvider[]{new IStatisticProvider(){

                public void updateStatistic(ISampledStatistic statistic) {
                    statistic.updateValue(FlowToDiskMemoryManager.getFlowToDiskMemoryManager().getMemorySize());
                }

                public void resetStatistic(ISampledStatistic statistic) {
                }
            }};
            m_ftdMemorySizeStat = StatisticsFactory.createStatistic((short)0, (boolean)false, (IStatisticProvider[])ftdMemorySizeProviders, (short)0);
            metricsRegistrar.registerMetric(BROKER_BYTES_FTD_MEMORY_SIZE_METRIC, m_ftdMemorySizeStat);
        }
    }

    private static void logMessage(IMetricIdentity BROKER_BYTES_FTD_MEMORY_SIZE_METRIC) {
        if (Config.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("BrokerDatabase: enabling metric " + BROKER_BYTES_FTD_MEMORY_SIZE_METRIC, 3);
        }
    }

    public static synchronized void disableMetrics(IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i].equals((Object)BROKER_BYTES_TOPIC_DB_SIZE_METRIC)) {
                m_totalTopicDBSizeStat = BrokerDatabase.logMessageUnregisterMetric(BROKER_BYTES_TOPIC_DB_SIZE_METRIC, metricsRegistrar, ids, i);
                continue;
            }
            if (!ids[i].equals((Object)BROKER_BYTES_FTD_MEMORY_SIZE_METRIC)) continue;
            m_ftdMemorySizeStat = BrokerDatabase.logMessageUnregisterMetric(BROKER_BYTES_FTD_MEMORY_SIZE_METRIC, metricsRegistrar, ids, i);
        }
    }

    private static IStatistic logMessageUnregisterMetric(IMetricIdentity BROKER_BYTES_FTD_MEMORY_SIZE_METRIC, IMetricsRegistrar metricsRegistrar, IMetricIdentity[] ids, int i) {
        if (Config.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("BrokerDatabase: Disabling metric " + BROKER_BYTES_FTD_MEMORY_SIZE_METRIC, 3);
        }
        metricsRegistrar.unregisterMetric(ids[i]);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateVolatileTopicDBSize(long value) {
        if (Config.DEBUG) {
            BrokerComponent.getComponentContext().logMessage("Updating total durable size = " + m_volatileTopicDBSize + " update = " + value, 3);
        }
        Object object = m_totalTopicDBSizeSyncObj;
        synchronized (object) {
            m_volatileTopicDBSize += value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireMsgCounter() {
        BrokerDatabase brokerDatabase = this;
        synchronized (brokerDatabase) {
            int weight = 1;
            this.exp_msg_added += weight;
        }
        this.checkStartCleaner();
    }

    private final void checkStartCleaner() {
        this.checkStartCleaner(false, false);
    }

    private final void checkStartCleaner(boolean force) {
        this.checkStartCleaner(force, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void checkStartCleaner(boolean force, boolean forceDbSize) {
        boolean startCleanerBasedOnDbSize = false;
        long dbSize = 0L;
        if (!force) {
            if (forceDbSize) {
                startCleanerBasedOnDbSize = true;
                dbSize = m_totalTopicDBSize;
            } else if (Config.MAX_TOPIC_DB_SIZE > 0) {
                long maxTopicDBSize = (long)Config.MAX_TOPIC_DB_SIZE * 1024L * 1024L;
                Object object = m_totalTopicDBSizeSyncObj;
                synchronized (object) {
                    if (m_totalTopicDBSize > maxTopicDBSize) {
                        startCleanerBasedOnDbSize = true;
                        dbSize = m_totalTopicDBSize;
                    }
                }
            }
        }
        BrokerDatabase brokerDatabase = this;
        synchronized (brokerDatabase) {
            if (!Broker.exiting && !Broker.isInShutdown() && this.m_okToRunCleaner) {
                boolean runCl = false;
                if (force) {
                    if (this.DEBUG1) {
                        this.debug("Message cleanup activated. force=true; exp_msg_added= " + this.exp_msg_added + " msgs_assoc_deleted= " + this.msgs_assoc_deleted);
                    }
                    runCl = true;
                } else if (this.exp_msg_added >= this.exp_till_cleanup || this.msgs_assoc_deleted >= this.msgs_till_msg_cleanup) {
                    if (this.DEBUG1) {
                        this.debug("Message cleanup activated. exp_msg_added= " + this.exp_msg_added + " msgs_assoc_deleted= " + this.msgs_assoc_deleted);
                    }
                    runCl = true;
                } else if (this.msgs_assoc_deleted > 0 && startCleanerBasedOnDbSize) {
                    if (this.DEBUG1) {
                        this.debug("Message cleanup activated. startCleanerBasedOnDbSize; size= " + dbSize + " exp_msg_added= " + this.exp_msg_added + " msgs_assoc_deleted= " + this.msgs_assoc_deleted);
                    }
                    runCl = true;
                }
                if (runCl) {
                    this.runCleaner();
                }
            }
        }
    }

    public synchronized void runCleaner() {
        Thread cleanupThread = new Thread((Runnable)this, "DbCleaner");
        this.m_okToRunCleaner = false;
        cleanupThread.start();
        this.msgs_assoc_deleted = 0;
        this.exp_msg_added = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCleaner() {
        BrokerDatabase brokerDatabase = this;
        synchronized (brokerDatabase) {
            this.m_okToRunCleaner = true;
        }
        this.checkStartCleaner();
    }

    private void setInitialValues() throws EDatabaseException {
        if (this.DEBUG1) {
            this.debug("setInitialValues starting");
        }
        long start = System.currentTimeMillis();
        Long ptpMax = this.m_ptpDBQ.getMaxAddedMessageId();
        if (ptpMax != null) {
            this.m_StartupMaxIdUsed = ptpMax;
        }
        long time = System.currentTimeMillis() - start;
        if (this.DEBUG1) {
            this.debug("setInitialValues: got max ptp msgId; value= " + ptpMax + ", secs= " + time / 1000L);
        }
        start = System.currentTimeMillis();
        Long pubsubMsgMax = this.m_pubSubDBQ.getMaxIDFromCounters();
        time = System.currentTimeMillis() - start;
        long lvalue = 0L;
        if (pubsubMsgMax != null) {
            lvalue = pubsubMsgMax;
            this.configStartupMaxIdUsedToLValue(lvalue);
        }
        if (this.DEBUG1) {
            this.debug("setInitialValues: got max values in Messages; value= " + lvalue + ", secs= " + time / 1000L);
        }
        start = System.currentTimeMillis();
        Long pubsubUndelMax = this.m_pubSubDBQ.getMaxValueInUndelMsgs();
        time = System.currentTimeMillis() - start;
        lvalue = 0L;
        if (pubsubUndelMax != null) {
            lvalue = pubsubUndelMax;
            this.configStartupMaxIdUsedToLValue(lvalue);
        }
        if (this.DEBUG1) {
            this.debug("setInitialValues: got max values in UndelMsgs; value= " + lvalue + ", secs= " + time / 1000L);
        }
        this.updateMaxAddedMessageId(this.m_StartupMaxIdUsed);
        if (ptpMax != null) {
            this.updateMaxAddedQueueMessageId(ptpMax);
        } else {
            this.updateMaxAddedQueueMessageId(-1L);
        }
        m_volatileTopicDBSize = this.m_pubSubDBQ.getTopicDBSize();
        if (this.DEBUG1) {
            this.debug("Initial durable size (read from db): " + m_volatileTopicDBSize);
        }
        this.updateTopicDBSizeStat(false);
        start = System.currentTimeMillis();
        if (this.m_StartupMaxIdUsed == 0L) {
            this.m_pubSubDBQ.updateCounters(0L, m_totalTopicDBSize, 0L);
            this.m_lastUpdatedSeqNo = this.m_sequenceNumber = 0L;
            this.m_StartupMaxSeqNoUsed = this.m_sequenceNumber;
        } else {
            this.m_lastUpdatedSeqNo = this.m_sequenceNumber = this.m_pubSubDBQ.getSeqnoCounter();
            this.m_StartupMaxSeqNoUsed = this.m_sequenceNumber;
        }
        this.m_maxDeletedMessageId = -1L;
        time = System.currentTimeMillis() - start;
        if (this.DEBUG1) {
            this.debug("setInitialValues: got max sequenceNumber; secs= " + time / 1000L);
        }
    }

    private void configStartupMaxIdUsedToLValue(long lvalue) {
        if (lvalue > this.m_StartupMaxIdUsed) {
            this.m_StartupMaxIdUsed = lvalue;
        }
    }

    public void setFailoverInitialValues() {
        this.m_StartupMaxSeqNoUsed = this.m_sequenceNumber;
        this.m_StartupMaxIdUsed = Math.max(this.m_maxAddedMessageId, this.m_maxAddedQueueMessageId);
    }

    private void updateInternalCountersTx() throws EDatabaseException {
        if (this.m_sequenceNumber != this.m_lastUpdatedSeqNo || this.m_maxAddedMessageId != this.m_lastUpdatedMessageId || m_volatileTopicDBSize != 0L) {
            if (this.DEBUG) {
                this.debug("Updating size: " + m_volatileTopicDBSize + " SeqNo: " + this.m_sequenceNumber);
            }
            this.m_pubSubDBQ.updateCountersTx(this.m_sequenceNumber, m_totalTopicDBSize + m_volatileTopicDBSize, this.m_maxAddedMessageId);
            this.m_lastUpdatedSeqNo = this.m_sequenceNumber;
            this.m_lastUpdatedMessageId = this.m_maxAddedMessageId;
        }
    }

    private void updateQueueInternalCountersTx() throws EDatabaseException {
        if (this.m_maxAddedQueueMessageId != this.m_lastUpdatedQueueMessageId) {
            if (this.DEBUG) {
                this.debug("Updating Queue MessageId: " + this.m_maxAddedQueueMessageId);
            }
            this.m_ptpDBQ.updateCountersTx(this.m_maxAddedQueueMessageId);
            this.m_lastUpdatedQueueMessageId = this.m_maxAddedQueueMessageId;
        }
    }

    public void updateCounters(long seqNo, long topicDBSize, long messageId) throws EDatabaseException {
        if (this.DEBUG) {
            this.debug("Updating size: " + topicDBSize + " SeqNo: " + seqNo + " MsgId: " + messageId);
        }
        this.m_pubSubDBQ.updateCounters(seqNo, topicDBSize, messageId);
        this.m_lastUpdatedSeqNo = seqNo;
        this.m_lastUpdatedMessageId = messageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTopicDBSizeStat(boolean resetSaverDbSpace) {
        Object object = m_totalTopicDBSizeSyncObj;
        synchronized (object) {
            MsgSaver saver;
            m_totalTopicDBSize += m_volatileTopicDBSize;
            m_volatileTopicDBSize = 0L;
            if (resetSaverDbSpace && (saver = AgentRegistrar.getAgentRegistrar().getMsgSaver()) != null) {
                saver.resetDbSpace();
            }
            this.releaseAllPublishersBlockedOnDbSpace();
        }
    }

    boolean hasRoomForMgramNL(IMgram msg) {
        boolean hasRoom = this.hasRoomForMgram(msg);
        if (!hasRoom) {
            this.checkStartCleaner(false, true);
        }
        return hasRoom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasRoomForMgram(IMgram msg) {
        MsgSaver saver = AgentRegistrar.getAgentRegistrar().getMsgSaver();
        long msgSaverDbSpace = 0L;
        Object object = m_totalTopicDBSizeSyncObj;
        synchronized (object) {
            if (saver != null) {
                msgSaverDbSpace = saver.getDbSpace();
            }
            long maxTopicDBSize = (long)Config.MAX_TOPIC_DB_SIZE * 1024L * 1024L;
            if (Config.MAX_TOPIC_DB_SIZE <= 0) {
                return true;
            }
            return maxTopicDBSize >= m_totalTopicDBSize + msgSaverDbSpace + (long)msg.serializedLength();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseAllPublishersBlockedOnDbSpace() {
        Object object = m_totalTopicDBSizeSyncObj;
        synchronized (object) {
            if (this.m_clientsBlockedOnDbSpace.m_count > 0) {
                boolean releaseBlockedPublishers = false;
                if (Config.MAX_TOPIC_DB_SIZE > 0) {
                    long resumeTopicDBSize = this.calcResumeTopicDbSize();
                    if (resumeTopicDBSize >= m_totalTopicDBSize) {
                        releaseBlockedPublishers = true;
                    }
                } else {
                    releaseBlockedPublishers = true;
                }
                if (releaseBlockedPublishers) {
                    for (int ii = 0; ii < this.m_clientsBlockedOnDbSpace.m_count; ++ii) {
                        IClientContext client = (IClientContext)this.m_clientsBlockedOnDbSpace.m_data[ii];
                        Object object2 = client.getSyncObj();
                        synchronized (object2) {
                            client.getOutQueue().dbSpaceReleaseBlockedPublishers();
                            continue;
                        }
                    }
                    this.m_clientsBlockedOnDbSpace.m_count = 0;
                }
            }
        }
    }

    private long calcResumeTopicDbSize() {
        long resumeTopicDBSize = 0L;
        if (Config.MAX_TOPIC_DB_SIZE > Config.TOPIC_DB_SIZE_RESTART_THRESHOLD) {
            resumeTopicDBSize = (long)(Config.MAX_TOPIC_DB_SIZE - Config.TOPIC_DB_SIZE_RESTART_THRESHOLD) * 1024L * 1024L;
        } else {
            resumeTopicDBSize = (long)(Config.MAX_TOPIC_DB_SIZE - 1) * 1024L * 1024L;
            if (resumeTopicDBSize == 0L) {
                resumeTopicDBSize = (long)(0.9 * (double)Config.MAX_TOPIC_DB_SIZE * 1024.0 * 1024.0);
            }
        }
        return resumeTopicDBSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseClientBlockedOnDbSpace(IClientContext client) {
        Object object = m_totalTopicDBSizeSyncObj;
        synchronized (object) {
            client.getOutQueue().dbSpaceReleaseBlockedPublishers();
            int clientIndex = this.m_clientsBlockedOnDbSpace.indexOf(client, 0);
            if (clientIndex > -1) {
                this.m_clientsBlockedOnDbSpace.removeElementAt(clientIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void blockPublisherOnDbSpace(FastVector clients, PublishLimiter pubLimiter) {
        MsgSaver saver = AgentRegistrar.getAgentRegistrar().getMsgSaver();
        long msgSaverDbSpace = 0L;
        Object object = m_totalTopicDBSizeSyncObj;
        synchronized (object) {
            if (saver != null) {
                msgSaverDbSpace = saver.getDbSpace();
            }
            if (Config.MAX_TOPIC_DB_SIZE <= 0) {
                return;
            }
            long maxTopicDBSize = (long)Config.MAX_TOPIC_DB_SIZE * 1024L * 1024L;
            if (maxTopicDBSize < m_totalTopicDBSize + msgSaverDbSpace) {
                for (int ii = 0; ii < clients.m_count; ++ii) {
                    IClientContext client = (IClientContext)clients.m_data[ii];
                    if (!client.dbSpaceFlowControlPublisher(pubLimiter) || this.m_clientsBlockedOnDbSpace.indexOf(client, 0) != -1) continue;
                    this.m_clientsBlockedOnDbSpace.addElement(client);
                }
            }
        }
    }

    private long getNextSequenceNumber() throws EDatabaseException {
        return ++this.m_sequenceNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxAddedMessageId() {
        long value;
        Object object = this.m_maxIdAddedSyncObj;
        synchronized (object) {
            value = this.m_maxAddedMessageId;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMaxAddedMessageId(long messageId) {
        Object object = this.m_maxIdAddedSyncObj;
        synchronized (object) {
            if (this.m_maxAddedMessageId < messageId) {
                this.m_maxAddedMessageId = messageId;
            }
        }
    }

    void updateMaxAddedQueueMessageId(long messageId) {
        if (this.m_maxAddedQueueMessageId < messageId) {
            this.m_maxAddedQueueMessageId = messageId;
        }
    }

    long getMaxAddedQueueMessageId() {
        return this.m_maxAddedQueueMessageId;
    }

    public synchronized long getStartupMaxIdUsed() {
        return this.m_StartupMaxIdUsed;
    }

    public synchronized long getStartupMaxSeqNoUsed() {
        return this.m_StartupMaxSeqNoUsed;
    }

    public Db getDatabase() {
        return this.m_Database;
    }

    final CipherSuiteInfo getCipherSuiteInfo() throws EDatabaseException {
        return this.m_regDBQ.getCipherSuiteInfo();
    }

    final void setCipherSuiteInfo(CipherSuiteInfo cipherSuiteInfo) throws EDatabaseException {
        this.m_regDBQ.setCipherSuiteInfo(cipherSuiteInfo);
    }

    @Override
    public boolean mgamExistsTx(long tracking) throws EDatabaseException, IOException {
        return this.m_pubSubDBQ.mgamExistsTx(tracking);
    }

    @Override
    public boolean saveMgramTx(IMgram message) throws EDatabaseException, IOException {
        long tracking = message.getBrokerHandle().getDbTracking();
        String JMSMessageID = null;
        if (!SessionConfig.isSystemSubject(message.getSubject())) {
            JMSMessageID = Envelope.getMessageID(message);
        }
        long sequence = this.getNextSequenceNumber();
        message.getBrokerHandle().setSequenceNumber(sequence);
        this.updateMaxAddedMessageId(tracking);
        Date timestamp = this.getDbTimestamp(message);
        boolean addSuccess = this.m_pubSubDBQ.addMessageTx(message, tracking, sequence, timestamp, JMSMessageID);
        BrokerDatabase.updateVolatileTopicDBSizeCheckingAddSuccess(addSuccess, message);
        return addSuccess;
    }

    private static void updateVolatileTopicDBSizeCheckingAddSuccess(boolean addSuccess, IMgram message) {
        if (addSuccess) {
            BrokerDatabase.updateVolatileTopicDBSize(124 + message.getBrokerHandle().getTrackedSize());
        }
    }

    @Override
    public List getSyncUndelMessagesTx(long lotracking, long hitracking, int undelBaseSize, int maxSize) throws EDatabaseException, InterruptedIOException {
        return this.m_pubSubDBQ.getSyncUndelMessagesTx(lotracking, hitracking, undelBaseSize, maxSize);
    }

    @Override
    public void saveUndelMessagesTx(List undels) throws EDatabaseException, InterruptedIOException {
        Iterator it = undels.iterator();
        long sequence = -1L;
        long lastMid = -1L;
        while (it.hasNext()) {
            ClientDeliveryInfo cdi = (ClientDeliveryInfo)it.next();
            if (lastMid != cdi.messageid) {
                sequence = this.getNextSequenceNumber();
                lastMid = cdi.messageid;
            }
            this.updateMaxAddedMessageId(cdi.messageid);
            boolean addSuccess = this.m_pubSubDBQ.addUndelMsgTx(cdi.cid, cdi.messageid, sequence, cdi.redelivered, cdi.expiration, cdi.timestamp, cdi.size, cdi.fromRemote, cdi.persistent, cdi.undelSubjectIds);
            BrokerDatabase.updateVolatileTopicDBSizeCheckingAddSuccess(addSuccess);
        }
    }

    private static void updateVolatileTopicDBSizeCheckingAddSuccess(boolean addSuccess) {
        if (addSuccess) {
            BrokerDatabase.updateVolatileTopicDBSize(87L);
        }
    }

    public void delAllUndelMsgs(int maxTxnSize) throws EDatabaseException {
        int ct = 0;
        if (this.DEBUG1) {
            this.debug("delAllUndelMsgs: starting ");
        }
        do {
            if ((ct = this.m_pubSubDBQ.delAllUndelMsgs(maxTxnSize)) <= 0) continue;
            BrokerDatabase.updateVolatileTopicDBSize(-(ct * 87));
            this.commitPubSubTran();
            if (!this.DEBUG1) continue;
            this.debug("delAllUndelMsgs: deleted " + ct);
        } while (ct > 0);
    }

    public boolean isClientInDb(long cid) {
        return this.m_clientIdsInDb.containsKey(new Long(cid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVolatileCRegDelete(long cid) {
        Hashtable hashtable = this.m_clientIdsInDb;
        synchronized (hashtable) {
            this.m_volatileCRegDeletes.addElement(new Long(cid));
        }
    }

    private Date getDbTimestamp(IMgram m) {
        return new Date(System.currentTimeMillis());
    }

    SavedMsgStats trimMessages(long clientID, long messageId, int batchsize) throws EDatabaseException {
        this.debugClientId(clientID);
        SavedMsgStats stats = this.m_pubSubDBQ.trimUndelMsgsCidTx(clientID, messageId, batchsize);
        int del_count = (int)stats.count;
        BrokerDatabase.updateVolatileTopicDBSize(-(del_count * 87));
        if (this.DEBUG) {
            this.debug("trimMessages, deleted " + del_count + " messages for client_id " + clientID);
        }
        this.updateMsgDeleteCount(del_count);
        this.checkStartCleaner(true);
        return stats;
    }

    private void debugClientId(long clientID) {
        if (this.DEBUG) {
            this.debug("call into delMsgs, client_id is " + clientID);
        }
    }

    public long determineMaxMessageIdForTrimOp(long cid, long datetime) throws EDatabaseException {
        return this.m_pubSubDBQ.determineMaxMessageIdForTrimOpTx(cid, datetime);
    }

    static {
        BROKER_BYTES_FTD_MEMORY_SIZE_METRIC = MetricsFactory.createMetricIdentity((String[])new String[]{"broker", "bytes", "FlowToDiskMemorySize"});
        BROKER_BYTES_FTD_MEMORY_SIZE_METRIC_UNITS = "bytes";
        m_totalTopicDBSize = 0L;
        m_volatileTopicDBSize = 0L;
        m_totalTopicDBSizeSyncObj = new Object();
        s_delMsgsParams = new Class[]{Long.TYPE};
    }

    public static final class UndelClientInfo {
        public long m_cid;
        public long m_maxDelMessageId;
    }

    public static final class CountSizeUpdateInfo {
        public int m_count;
        public long m_size;
        public boolean m_allMessagesRestored;
        public long m_maxMessageID;

        public CountSizeUpdateInfo(long size, int count, boolean allMessagesRestored, long maxMessageId) {
            this.m_size = size;
            this.m_count = count;
            this.m_allMessagesRestored = allMessagesRestored;
            this.m_maxMessageID = maxMessageId;
        }
    }

    public static final class ClientDeliveryInfo {
        public long cid;
        public boolean redelivered;
        public long seqno;
        public Date expiration;
        public Date timestamp;
        public long messageid;
        public int size;
        public boolean fromRemote;
        public boolean persistent;
        public Collection undelSubjectIds;

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ClientDeliveryInfo)) {
                return false;
            }
            ClientDeliveryInfo value = (ClientDeliveryInfo)obj;
            if (this.cid != value.cid || this.redelivered != value.redelivered || this.seqno != value.seqno || this.messageid != value.messageid) {
                return false;
            }
            if (this.undelSubjectIds != null ? !this.undelSubjectIds.equals(value.undelSubjectIds) : value.undelSubjectIds != null) {
                return false;
            }
            if (this.timestamp != null && value.timestamp != null) {
                if (!this.timestamp.equals(value.timestamp)) {
                    return false;
                }
            } else {
                if (this.timestamp == null && value.timestamp != null) {
                    return false;
                }
                if (this.timestamp != null && value.timestamp == null) {
                    return false;
                }
            }
            if (this.expiration == null && value.expiration == null) {
                return true;
            }
            if (this.expiration == null) {
                return false;
            }
            return this.expiration.equals(value.expiration);
        }

        public int hashCode() {
            return Objects.hash(this.cid, this.redelivered, this.seqno, this.messageid, this.undelSubjectIds, this.timestamp, this.expiration);
        }

        public String toString() {
            return "ClientDeliveryInfo[CID:" + this.cid + ", RDLV:" + this.redelivered + ", mid:" + this.messageid + ", sids:" + this.undelSubjectIds + "]";
        }
    }

    public static final class MgramInfo {
        public long m_messageId;
        public long m_sequenceNumber;
        public int m_size;
        public Date m_timestamp;

        public MgramInfo(long sequenceNumber, long messageId, int size, Date timestamp) {
            this.m_messageId = messageId;
            this.m_sequenceNumber = sequenceNumber;
            this.m_size = size;
            this.m_timestamp = timestamp;
        }
    }

    public static class SavedMsgStats {
        public long size;
        public long count;
    }

    static final class DbCleanerInfo {
        static long numUndelExpiredBatch;
        static long numUndelExpiredTotal;
        static long numDeletedBatch;
        static long numDeletedTotal;
        static long numBatch;
        static Map<Long, Vector<Long>> expiredMsgs;

        DbCleanerInfo() {
        }

        static void endBatch() {
            ++numBatch;
            numDeletedTotal += numDeletedBatch;
            numUndelExpiredTotal += numUndelExpiredBatch;
            numUndelExpiredBatch = DbCleanerInfo.resetBatchExpiredMsgsDeletedTotal();
        }

        static void reset() {
            numBatch = 0L;
            numUndelExpiredBatch = 0L;
            numUndelExpiredTotal = 0L;
            numDeletedTotal = DbCleanerInfo.resetBatchExpiredMsgsDeletedTotal();
        }

        private static long resetBatchExpiredMsgsDeletedTotal() {
            numDeletedBatch = 0L;
            long numDeletedTotal = 0L;
            expiredMsgs = Collections.synchronizedMap(new HashMap());
            return numDeletedTotal;
        }
    }

    public static final class MessageIDClientDeliveryInfo {
        HashMap m_table = new HashMap();

        public void addAssociation(Long message_id, ClientDeliveryInfo info) {
            ArrayList<ClientDeliveryInfo> cdiList = (ArrayList<ClientDeliveryInfo>)this.m_table.get(message_id);
            if (cdiList == null) {
                cdiList = new ArrayList<ClientDeliveryInfo>();
                this.m_table.put(message_id, cdiList);
            }
            cdiList.add(info);
        }

        public int updateCCSizeInfo(Long message_id) throws EOperationCancelled {
            ArrayList cdiList = (ArrayList)this.m_table.get(message_id);
            if (cdiList == null) {
                return 0;
            }
            int size = cdiList.size();
            int result = 0;
            if (size > 0) {
                for (int count = 0; count < size; ++count) {
                    ClientDeliveryInfo info = (ClientDeliveryInfo)cdiList.get(count);
                    long cid = info.cid;
                    int messageSize = info.size;
                    ICCSizeTracker tracker = null;
                    try {
                        tracker = AgentRegistrar.getAgentRegistrar().getClient(cid).getCCSizeTracker();
                    }
                    catch (EClientNotRegistered eClientNotRegistered) {
                        // empty catch block
                    }
                    if (tracker != null) {
                        try {
                            tracker.messageDeleted(messageSize, info.messageid);
                        }
                        catch (ECounterFrozenException e) {
                            throw new EOperationCancelled();
                        }
                    }
                    ++result;
                }
            }
            return result;
        }

        public void expireCCMsgs() {
            AgentRegistrar reg = AgentRegistrar.getAgentRegistrar();
            for (Long midL : this.m_table.keySet()) {
                ArrayList cdiList = (ArrayList)this.m_table.get(midL);
                if (cdiList == null) continue;
                for (ClientDeliveryInfo info : cdiList) {
                    long cid = info.cid;
                    IClientContext cc = null;
                    try {
                        cc = reg.getClient(cid);
                    }
                    catch (EClientNotRegistered ecnr) {
                        continue;
                    }
                    cc.clearDbExpiredMsg(midL);
                }
            }
        }

        public Vector getMsgIds() {
            Vector vec = new Vector();
            Iterator it = this.m_table.keySet().iterator();
            while (it.hasNext()) {
                vec.addElement(it.next());
            }
            return vec;
        }
    }

    public static class ClientAttributes {
        public String userId;
        public String appId;
        public long lastConnectedTime;
        public long cid;
        public byte[] csc;
        public boolean isInterbroker;

        ClientSecurityContext unserializeCsc() throws IOException {
            ByteBufferInputStream bis = new ByteBufferInputStream(this.csc);
            ClientSecurityContext sec_ctx = ClientSecurityContext.unserialize(bis);
            return sec_ctx;
        }

        public String toString() {
            return "ClientAttributes [cid:" + this.cid + ",uid:" + this.userId + ",aid:,IB:" + this.isInterbroker + ",LastConnectedTime:" + this.lastConnectedTime + "]";
        }
    }

    public static class QueueAttributes {
        public String name;
        public boolean exclusive;
        public boolean global;
        public int saveThreshold;
        public int retrieveThreshold;
        public int maxQSize;
        public boolean clustered;
    }
}

