/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Config;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.GroupMsgAllocationEvt;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.GroupXOnceMsgAllocationTracker;
import progress.message.broker.IActivityMonitorHandle;
import progress.message.broker.IClientContext;
import progress.message.broker.IMinEnqueuePriorityListener;
import progress.message.broker.MgramSenderQueue;
import progress.message.broker.MsgSaver;
import progress.message.broker.OffloadedPubSubQueue;
import progress.message.broker.PublishLimiter;
import progress.message.broker.PublishLimiterNotify;
import progress.message.broker.SlowSubscriberMonitor;
import progress.message.broker.SubscriberTimeOnBufferTracker;
import progress.message.broker.prAccessor;
import progress.message.msg.IBatchHandle;
import progress.message.msg.IMgram;
import progress.message.util.EDuplicateKey;
import progress.message.util.IndexedList;
import progress.message.util.ListNode;
import progress.message.util.LongHashTable;
import progress.message.util.PriorityQueue;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EMgramFormatError;
import progress.message.zclient.ExpirationPriorityQueue;
import progress.message.zclient.FastVector;
import progress.message.zclient.IExpirePrecheck;
import progress.message.zclient.IQuencher;
import progress.message.zclient.ITimeOnBufferTracker;
import progress.message.zclient.Label;
import progress.message.zclient.OutQueue;
import progress.message.zclient.PrioQueueLimiter;
import progress.message.zclient.SessionConfig;

public final class ClientContextMgramQueue
extends DebugObject {
    private Vector m_minEnqueuePrioListeners = null;
    private Object m_minEnqueuePrioListener_Lock = null;
    private static volatile MsgSaver s_msgSaver;
    private IClientContext m_cc;
    private int m_minDequeuePriority = 0;
    private OutQueue m_outpq = new OutQueue(13);
    private ExpirationPriorityQueue m_waitpq = new ExpirationPriorityQueue(13);
    private volatile IndexedList m_pendingGuars = new IndexedList();
    private volatile IndexedList m_pendingQmsgs = new IndexedList();
    private volatile OffloadedPubSubQueue m_offloadedPubSubQueue = null;
    private volatile TreeMap m_pendingReconnectGuars = new TreeMap();
    private PrioQueueLimiter m_outLimiter;
    private PrioQueueLimiter m_waitLimiter;
    private PrioQueueLimiter m_guarLimiter;
    private PrioQueueLimiter m_qmsgLimiter;
    private PrioQueueLimiter m_reconnectLimiter;
    private final SubscriberTimeOnBufferTracker m_timeOnBufferTracker;
    public MgramSenderQueue m_senderQueue;
    private int m_outMinEnqueuePriority = 0;
    private int m_waitMinEnqueuePriority = 0;
    private int m_guarMinEnqueuePriority = 0;
    private int m_qmsgMinEnqueuePriority = 0;
    private int m_minEnqueuePriority = 0;
    private boolean m_hasDiscardables = false;
    private boolean m_hasExpirables = false;
    private boolean m_hasBatched = false;
    private PublishLimiterNotify m_notifyLimiter;
    private Vector m_expiredMsgs;
    private FastVector m_publishLimiters = new FastVector();
    private FastVector m_dbSpacePublishLimiters = new FastVector();
    private FastVector m_flowToDiskPublishLimiters = new FastVector();
    private FastVector m_initRestorePublishLimiters = new FastVector();
    private boolean m_breakDequeueWait;
    private IExpirePrecheck m_precheck = null;
    private IndexedList m_unflushedXOGroupSends;
    private IndexedList m_inDoubtXOGroupSends;
    private volatile LongHashTable m_msgsFromGroupSubscription = new LongHashTable();
    private boolean DEBUG1;

    void setHasDiscardables(boolean hasDiscardables) {
        this.m_hasDiscardables = hasDiscardables;
    }

    boolean hasDiscardables() {
        return this.m_hasDiscardables;
    }

    void setHasExpirables(boolean hasExpirables) {
        this.m_hasExpirables = hasExpirables;
    }

    boolean hasExpirables() {
        return this.m_hasExpirables;
    }

    void setHasBatched(boolean hasBatched) {
        this.m_hasBatched = hasBatched;
    }

    boolean hasBatched() {
        return this.m_hasBatched;
    }

    Vector getExpiredMsgs() {
        return this.m_expiredMsgs;
    }

    static void setMsgSaver(MsgSaver saver) {
        s_msgSaver = saver;
    }

    static PrioQueueLimiter.Builder newBuilder(Config.MgramQueueConfig cfg) {
        PrioQueueLimiter.Builder builder = new PrioQueueLimiter.Builder(new BuilderCallback(cfg));
        builder.normLimit(cfg.SIZE).reserved(cfg.MIN_SIZE).highLimit(cfg.PRIORITY_SIZE).restartThreshold(cfg.RESTART_THRESHOLD);
        return builder;
    }

    ClientContextMgramQueue(IClientContext cc) {
        super("ClientContextMgramQueue");
        this.m_cc = cc;
        this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        this.debugName("ClientContextMgramQueue " + this.m_cc);
        this.m_minEnqueuePrioListeners = new Vector();
        this.m_minEnqueuePrioListener_Lock = new Object();
        this.m_timeOnBufferTracker = SlowSubscriberMonitor.isEnabled() && cc.isJMSSubscriber() ? new SubscriberTimeOnBufferTracker(this.m_cc) : null;
        PrioQueueLimiter.Builder outBuilder = ClientContextMgramQueue.newBuilder(Config.OUTPUT_QUEUE);
        this.m_outLimiter = outBuilder.build(new IQuencher(){

            @Override
            public void setMinEnqueuePriority(int prio) {
                ClientContextMgramQueue.this.setOutMinEnqueuePriority(prio);
            }
        }, this.m_timeOnBufferTracker == null ? null : this.m_timeOnBufferTracker.createListener());
        PrioQueueLimiter.Builder waitBuilder = ClientContextMgramQueue.newBuilder(Config.WAIT_QUEUE);
        waitBuilder.restartThreshold(outBuilder.getRestartThreshold());
        this.m_waitLimiter = waitBuilder.build(new IQuencher(){

            @Override
            public void setMinEnqueuePriority(int prio) {
                ClientContextMgramQueue.this.setWaitMinEnqueuePriority(prio);
            }
        });
        PrioQueueLimiter.Builder guarBuilder = ClientContextMgramQueue.newBuilder(Config.GUAR_QUEUE);
        guarBuilder.restartThreshold(outBuilder.getRestartThreshold());
        this.m_guarLimiter = guarBuilder.build(new IQuencher(){

            @Override
            public void setMinEnqueuePriority(int prio) {
                ClientContextMgramQueue.this.setGuarMinEnqueuePriority(prio);
            }
        }, this.m_timeOnBufferTracker == null ? null : this.m_timeOnBufferTracker.createListener());
        PrioQueueLimiter.Builder builder = new PrioQueueLimiter.Builder();
        builder.normLimit(guarBuilder.getNormLimit() + waitBuilder.getNormLimit()).reserved(guarBuilder.getReserved() + waitBuilder.getReserved()).highLimit(guarBuilder.getHighLimit() + waitBuilder.getHighLimit()).restartThreshold(guarBuilder.getRestartThreshold());
        this.m_reconnectLimiter = builder.build(new IQuencher(){

            @Override
            public void setMinEnqueuePriority(int prio) {
                ClientContextMgramQueue.this.setGuarMinEnqueuePriority(prio);
            }
        });
        this.m_qmsgLimiter = guarBuilder.build(new IQuencher(){

            @Override
            public void setMinEnqueuePriority(int prio) {
                ClientContextMgramQueue.this.setQmsgMinEnqueuePriority(prio);
            }
        });
        this.m_senderQueue = new MgramSenderQueue(this.m_outpq, this.m_outLimiter, this.m_pendingQmsgs, this.m_qmsgLimiter, Config.ROUTING_NODE_NAME, this.m_cc);
        this.m_expiredMsgs = new Vector();
        this.m_offloadedPubSubQueue = new OffloadedPubSubQueue(this.m_cc, s_msgSaver);
    }

    void setCC(IClientContext cc) {
        this.m_cc = cc;
        if (this.m_senderQueue != null) {
            this.m_senderQueue.setCC(this.m_cc);
        }
        if (this.m_offloadedPubSubQueue != null) {
            this.m_offloadedPubSubQueue.setCC(this.m_cc);
        }
    }

    void setExpirePrecheck(IExpirePrecheck precheck) {
        this.m_precheck = precheck;
        this.m_senderQueue.setExpirePrecheck(this.m_precheck);
        this.m_waitpq.setExpirePrecheck(this.m_precheck);
    }

    int enqueueOrOffload(IMgram mgram, PublishLimiter pubLimiter, Label opts, boolean checkRoomOnly) throws EDuplicateKey {
        return this.enqueue(this.m_outpq, this.m_outLimiter, mgram, pubLimiter, opts, true, checkRoomOnly, null);
    }

    void enqueue(IMgram m, PublishLimiter pubLimiter) throws EDuplicateKey {
        this.enqueue(m, pubLimiter, null);
    }

    void enqueue(IMgram m, PublishLimiter pubLimiter, Label opts) throws EDuplicateKey {
        try {
            this.enqueue(this.m_outpq, this.m_outLimiter, m, pubLimiter, opts, false, false, null);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR063") + m.getPriority(), (Throwable)e, 1);
        }
    }

    void enqueuePriorityPush(IMgram m, int prio, int pushPrio) {
        this.m_senderQueue.enqueuePriorityPush(m, prio, pushPrio);
    }

    void enqueueForward(IMgram msg, PublishLimiter pubLimiter) {
        try {
            this.enqueue(this.m_outpq, this.m_outLimiter, msg, pubLimiter, null, false, false, null);
        }
        catch (EDuplicateKey edk) {
            BrokerComponent.getComponentContext().logMessage((Throwable)edk, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueue(IMgram mg) {
        byte prio = mg.getPriority();
        try {
            this.m_senderQueue.enqueue(mg, prio);
            Object object = this.m_cc.getSyncObj();
            synchronized (object) {
                this.m_cc.getSyncObj().notifyAll();
            }
        }
        catch (EMgramFormatError mfe) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR063") + mg.getPriority(), (Throwable)mfe, 1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR064") + mg.getPriority(), (Throwable)e, 1);
        }
    }

    int enqueueWaitOrOffload(IMgram mgram, PublishLimiter pubLimiter, Label opts, boolean checkRoomOnly) throws EDuplicateKey {
        return this.enqueue(this.m_waitpq, this.m_waitLimiter, mgram, pubLimiter, opts, true, checkRoomOnly, null);
    }

    void enqueueWait(IMgram m, PublishLimiter pubLimiter) throws EDuplicateKey {
        this.enqueue(this.m_waitpq, this.m_waitLimiter, m, pubLimiter, null, false, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueRestored(IMgram m) throws EDuplicateKey {
        block9: {
            if (m.getType() != 27) {
                if (m.isGuarenteed()) {
                    this.setGuarMsgPending(m);
                }
            } else {
                this.setBatchGuarMsgPending(m);
            }
            try {
                this.m_senderQueue.enqueue(m, m.getPriority());
                Object object = this.m_cc.getSyncObj();
                synchronized (object) {
                    this.m_cc.getSyncObj().notifyAll();
                }
            }
            catch (EMgramFormatError mfe) {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR063") + m.getPriority(), (Throwable)mfe, 1);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR065") + m.getPriority(), (Throwable)e, 1);
                if (!m.isGuarenteed()) break block9;
                this.m_pendingGuars.remove(m.getGuarenteedTrackingNum());
                this.removeGroupSubGuarPending(m.getGuarenteedTrackingNum());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int enqueue(PriorityQueue q, PrioQueueLimiter limiter, IMgram m, PublishLimiter pubLimiter, Label opts, boolean offloadIfNoRoom, boolean checkRoomOnly, GroupMsgAllocationEvt xoGroupSend) throws EDuplicateKey {
        byte prio = m.getPriority();
        int length = m.getLimiterSize();
        if (!AgentRegistrar.getAgentRegistrar().getLogManager().isEventPostProcessorThread(Thread.currentThread())) {
            this.makeRoomForNewMessage(m, q, limiter, length);
        }
        boolean nonStopMessage = opts != null && opts.isNonStop();
        boolean offloadable = !nonStopMessage && (!m.isDiscardable() || Config.FLOW_TO_DISK_DISCARDABLE && m.isDiscardable());
        boolean subscriberUsesFlowToDisk = this.m_cc.useFlowToDisk();
        if (offloadIfNoRoom && offloadable && !this.getOffloadedPubSubQueue().isEmpty(m.getPriority(), m.getBrokerHandle().getSenderID())) {
            return 4;
        }
        if (offloadIfNoRoom && offloadable && subscriberUsesFlowToDisk || checkRoomOnly) {
            boolean noRoom = false;
            if (q == this.m_outpq) {
                if (!this.hasRoomForMgram(m, m.getLimiterSize())) {
                    noRoom = true;
                }
            } else if (!this.hasRoomInWaitQueue(m)) {
                noRoom = true;
            }
            if (noRoom) {
                if (offloadIfNoRoom && offloadable && subscriberUsesFlowToDisk) {
                    return 4;
                }
                return 5;
            }
            if (checkRoomOnly) {
                return 0;
            }
        }
        if (this.checkDiscardable(m)) {
            if (!limiter.hasRoom(length, prio)) {
                return 0;
            }
            this.setHasDiscardables(true);
        }
        if (!m.getNoOutqueueExpire()) {
            if (m.isTTE()) {
                this.setHasExpirables(true);
            } else if (this.m_precheck != null && this.m_precheck.isPrecheckCandidate(m)) {
                this.setHasExpirables(true);
            }
        }
        if (m.getType() == 27) {
            this.setHasBatched(true);
        }
        if (q == this.m_outpq) {
            if (m.getType() != 27) {
                if (m.isGuarenteed() && !m.isQueueMessage()) {
                    this.setGuarMsgPending(m);
                }
            } else {
                this.setBatchGuarMsgPending(m);
            }
        }
        try {
            if (xoGroupSend != null) {
                this.addUnflushedXOGroupSend(m, xoGroupSend);
            } else if (q == this.m_outpq) {
                this.m_senderQueue.enqueue(m, prio);
            } else {
                q.enqueue(m, prio, true);
                limiter.add(length, prio);
            }
        }
        catch (EMgramFormatError mfe) {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR063") + m.getPriority(), (Throwable)mfe, 1);
        }
        if (!(this.m_minEnqueuePriority <= 0 || this.checkDiscardable(m) || pubLimiter == null || subscriberUsesFlowToDisk && offloadIfNoRoom || this.m_cc.getState() != 8 && this.m_cc.getState() != 5 && (opts == null || m.isGuarenteed()) && q != this.m_waitpq)) {
            if (this.m_publishLimiters.indexOf(pubLimiter, 0) == -1) {
                this.publimiterAddSubscriberCheckingLimiters(pubLimiter);
            } else {
                if (this.DEBUG) {
                    this.debug("Subscriber " + this.m_cc + " re-instating min enqueue priority " + this.m_minEnqueuePriority + ", publimiter = " + pubLimiter.toString());
                }
                pubLimiter.reinstateMinPublishPriority(this.m_cc, this.m_minEnqueuePriority);
            }
        }
        Object object = this.m_cc.getSyncObj();
        synchronized (object) {
            this.m_cc.getSyncObj().notifyAll();
        }
        return 0;
    }

    private final boolean checkDiscardable(IMgram m) {
        return m.isDiscardable() && (m.isPubSub() || m.getType() == 25);
    }

    public boolean hasRoomForPendingGuar(IMgram msg) {
        return this.m_guarLimiter.hasRoom(msg.getLimiterSize(), msg.getPriority());
    }

    public boolean hasRoomForForward(IMgram msg) {
        return this.m_outLimiter.hasRoom(msg.getLimiterSize(), msg.getPriority());
    }

    private void makeRoomForNewMessage(IMgram newMgram, PriorityQueue priorityQueue, PrioQueueLimiter queueLimiter, int length) {
        byte prio = newMgram.getPriority();
        boolean outQueueIsFull = false;
        boolean waitQueueIsFull = false;
        boolean guarQueueIsFull = false;
        boolean deliverAsQueueMessage = newMgram.isQueueMessage();
        if (priorityQueue == this.m_outpq) {
            outQueueIsFull = !queueLimiter.hasRoom(length, prio);
        } else if (priorityQueue == this.m_waitpq) {
            boolean bl = waitQueueIsFull = !queueLimiter.hasRoom(length, prio);
        }
        if (priorityQueue == this.m_outpq && newMgram.isGuarenteed()) {
            if (deliverAsQueueMessage) {
                guarQueueIsFull = !this.m_qmsgLimiter.hasRoom(length, prio);
            } else {
                boolean bl = guarQueueIsFull = !this.m_guarLimiter.hasRoom(length, prio);
            }
        }
        if (this.hasExpirables() && (outQueueIsFull || waitQueueIsFull || guarQueueIsFull) && !this.m_cc.isQueueReceiver() && !this.m_cc.isQueueBrowser()) {
            Vector expMsgs = null;
            if (priorityQueue == this.m_outpq) {
                expMsgs = this.clearExpiredMsgs();
            } else if (priorityQueue == this.m_waitpq) {
                expMsgs = ((ExpirationPriorityQueue)priorityQueue).getExpiredMsgs(this.m_waitLimiter);
            }
            if (expMsgs != null) {
                this.m_cc.updateExpiredMsgsPending(expMsgs.size());
                for (int i = 0; i < expMsgs.size(); ++i) {
                    this.m_expiredMsgs.addElement(expMsgs.elementAt(i));
                }
                expMsgs.removeAllElements();
            }
        }
        if (priorityQueue == this.m_outpq) {
            boolean bl = outQueueIsFull = !queueLimiter.hasRoom(length, prio);
        }
        if (priorityQueue == this.m_outpq && newMgram.isGuarenteed()) {
            if (deliverAsQueueMessage) {
                guarQueueIsFull = !this.m_qmsgLimiter.hasRoom(length, prio);
            } else {
                boolean bl = guarQueueIsFull = !this.m_guarLimiter.hasRoom(length, prio);
            }
        }
        if (outQueueIsFull && this.hasDiscardables() && !Config.FLOW_TO_DISK_DISCARDABLE && (newMgram.isDiscardable() || !guarQueueIsFull)) {
            ExpirationPriorityQueue expQueue = (ExpirationPriorityQueue)priorityQueue;
            expQueue.deleteDiscardables(newMgram, queueLimiter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMgram removePendingGuar(long tracking) {
        ListNode n = this.m_pendingGuars.remove(tracking);
        if (n == null) {
            return null;
        }
        this.updateActivity();
        IMgram m = (IMgram)n.obj;
        this.m_guarLimiter.add(-m.getLimiterSize(), m.getPriority());
        Object object = this.m_cc.getSyncObj();
        synchronized (object) {
            this.m_cc.getSyncObj().notifyAll();
        }
        this.notifyGroupThreads();
        return m;
    }

    IMgram getPendingGuar(long tracking) {
        return (IMgram)this.m_pendingGuars.get(tracking);
    }

    IndexedList getPendingGuars() {
        return this.m_pendingGuars;
    }

    OffloadedPubSubQueue getOffloadedPubSubQueue() {
        return this.m_offloadedPubSubQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IMgram removePendingQmsg(long tracking) {
        ListNode n = this.m_pendingQmsgs.remove(tracking);
        if (n == null) {
            return null;
        }
        IMgram m = (IMgram)n.obj;
        this.m_qmsgLimiter.add(-m.getLimiterSize(), m.getPriority());
        Object object = this.m_cc.getSyncObj();
        synchronized (object) {
            this.m_cc.getSyncObj().notifyAll();
        }
        return m;
    }

    IMgram getPendingQmsg(long tracking) {
        return (IMgram)this.m_pendingQmsgs.get(tracking);
    }

    Enumeration getPendingQMsgs() {
        return this.m_pendingQmsgs.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkedList dumpWaitQueue() {
        LinkedList ret = null;
        while (this.m_waitpq.getEnqueued() > 0) {
            IMgram m = (IMgram)this.m_waitpq.dequeue();
            if (!m.isGuarenteed()) continue;
            ret = ClientContextMgramQueue.initRet(m, ret);
        }
        this.m_waitLimiter.reset();
        Object object = this.m_cc.getSyncObj();
        synchronized (object) {
            this.m_cc.getSyncObj().notifyAll();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator removeForwardedMsgs(long clientId) {
        Iterator ret = this.m_outpq.removeTargeted(clientId, this.m_outLimiter).iterator();
        Object object = this.m_cc.getSyncObj();
        synchronized (object) {
            this.m_cc.getSyncObj().notifyAll();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList saveUnsentGuarsInPending(Iterator toSave) {
        LinkedList<IMgram> ret = null;
        while (toSave != null && toSave.hasNext()) {
            IMgram m = (IMgram)toSave.next();
            if (!m.isGuarenteed()) continue;
            int length = 0;
            ListNode n = this.m_pendingGuars.remove(m.getGuarenteedTrackingNum());
            if (n == null) continue;
            length = ((IMgram)n.obj).getLimiterSize();
            this.updateActivity();
            this.m_guarLimiter.add(-length, m.getPriority());
            if (ret == null) {
                ret = new LinkedList<IMgram>();
            }
            ret.add(m);
        }
        if (ret != null) {
            this.notifyGroupThreads();
        }
        Object object = this.m_cc.getSyncObj();
        synchronized (object) {
            this.m_cc.getSyncObj().notifyAll();
        }
        if (this.DEBUG) {
            this.debug(this.m_cc + " saved " + (ret != null ? ret.size() : 0) + " messages to db");
        }
        return ret;
    }

    PriorityQueue clearWaitQueue() {
        ExpirationPriorityQueue tempq = this.m_waitpq;
        this.m_waitpq = new ExpirationPriorityQueue(13);
        this.m_waitpq.setExpirePrecheck(this.m_precheck);
        this.m_waitLimiter.reset();
        return tempq;
    }

    int countWaitQEnqueued() {
        return this.m_waitpq.getEnqueued();
    }

    public void releaseWaitQueueToPRQ() {
        IMgram m = null;
        while (this.m_waitpq.getEnqueued() > 0 && this.hasRoomForPendingReconnect(m = (IMgram)this.m_waitpq.peek())) {
            if (this.DEBUG) {
                this.debug(this + "releaseWaitQueueToPRQ moving " + m.getGuarenteedTrackingNum() + " from WQ to PRQ");
            }
            this.addPendingReconnect(m);
            this.m_waitpq.dequeue();
            this.m_waitLimiter.add(-m.getLimiterSize(), m.getPriority());
        }
    }

    void releaseWaitQueue() {
        while (this.m_waitpq.getEnqueued() > 0) {
            IMgram m = (IMgram)this.m_waitpq.dequeue();
            try {
                byte prio = m.getPriority();
                this.m_senderQueue.enqueue(m, prio);
                if (m.getType() != 27) {
                    if (!m.isGuarenteed()) continue;
                    try {
                        this.setGuarMsgPending(m);
                    }
                    catch (EDuplicateKey eDuplicateKey) {}
                    continue;
                }
                try {
                    this.setBatchGuarMsgPending(m);
                }
                catch (EDuplicateKey eDuplicateKey) {
                }
            }
            catch (EMgramFormatError mfe) {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR066") + m.getPriority(), (Throwable)mfe, 1);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR066") + m.getPriority(), 1);
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR066") + m.getPriority(), (Throwable)e, 1);
            }
        }
        this.m_waitLimiter.reset();
    }

    public void dumpOutQueue() {
        this.m_senderQueue.dumpOutQueue();
    }

    int countPending() {
        return this.m_pendingGuars.count() + this.m_pendingQmsgs.count();
    }

    int countGuarPending() {
        return this.m_pendingGuars.count();
    }

    int countQPending() {
        return this.m_pendingQmsgs.count();
    }

    void setGuarMsgPending(IMgram m) throws EDuplicateKey {
        this.m_pendingGuars.append(m.getGuarenteedTrackingNum(), m);
        this.m_guarLimiter.add(m.getLimiterSize(), m.getPriority());
        this.addGroupSubGuarPending(m, this.m_cc.getGroupSubscriptionCC());
    }

    void setBatchGuarMsgPending(IMgram m) throws EDuplicateKey {
        IBatchHandle bh = m.getBatchHandle();
        if (bh.isAtomic() && m.isGuarenteed()) {
            this.setGuarMsgPending(m);
            this.setHasBatched(true);
        } else {
            Iterator it = bh.getBatchIterator();
            if (it != null) {
                IMgram subMgram = null;
                if (it.hasNext() && (subMgram = (IMgram)it.next()).isGuarenteed()) {
                    this.setGuarMsgPending(subMgram);
                    while (it.hasNext()) {
                        subMgram = (IMgram)it.next();
                        this.setGuarMsgPending(subMgram);
                    }
                }
            }
        }
    }

    void setFwdGuarMsgPending(IMgram m, PublishLimiter pubLimiter) throws EDuplicateKey {
        this.setGuarMsgPending(m);
        if (pubLimiter != null && this.m_cc.isStarted() && this.m_publishLimiters.indexOf(pubLimiter, 0) == -1) {
            this.publimiterAddSubscriberCheckingLimiters(pubLimiter);
        }
    }

    private void publimiterAddSubscriberCheckingLimiters(PublishLimiter pubLimiter) {
        this.m_publishLimiters.addElement(pubLimiter);
        if (this.m_dbSpacePublishLimiters.indexOf(pubLimiter, 0) == -1 && this.m_flowToDiskPublishLimiters.indexOf(pubLimiter, 0) == -1) {
            pubLimiter.addSubscriber(this.m_cc, this.m_minEnqueuePriority);
        }
    }

    void setQMsgPending(IMgram m) throws EDuplicateKey {
        this.m_pendingQmsgs.append(m.getGuarenteedTrackingNum(), m);
        this.m_qmsgLimiter.add(m.getLimiterSize(), m.getPriority());
    }

    IndexedList newPendingGuarsList() {
        IndexedList pendingGuars = this.m_pendingGuars;
        this.m_pendingGuars = new IndexedList();
        this.m_guarLimiter.reset();
        return pendingGuars;
    }

    IndexedList newPendingQMsgsList() {
        IndexedList pendingQmsgs = this.m_pendingQmsgs;
        this.m_pendingQmsgs = new IndexedList();
        this.m_qmsgLimiter.reset();
        this.m_senderQueue.restorePendingQmsgs(this.m_pendingQmsgs, this.m_qmsgLimiter);
        return pendingQmsgs;
    }

    void restoreQMsgToPending(IMgram m) {
        try {
            this.m_pendingQmsgs.prepend(m.getGuarenteedTrackingNum(), m);
            this.m_qmsgLimiter.add(m.getLimiterSize(), m.getPriority());
        }
        catch (EDuplicateKey eDuplicateKey) {
            // empty catch block
        }
        this.m_senderQueue.restorePendingQmsgs(this.m_pendingQmsgs, this.m_qmsgLimiter);
    }

    void restorePendingQmsgs() {
        IndexedList pendingQmsgs = this.newPendingQMsgsList();
        AgentQueueProcessor aqp = AgentRegistrar.getAgentRegistrar().getQueueProc();
        if (!this.m_cc.isInterbroker() && !this.m_cc.isRemoteBroker()) {
            this.markAsHavingSuccessor(pendingQmsgs);
        }
        aqp.restore(this.m_cc.getId(), pendingQmsgs);
        this.m_senderQueue.restorePendingQmsgs(this.m_pendingQmsgs, this.m_qmsgLimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object dequeue() {
        try {
            Object mg = this.m_senderQueue.dequeueAtOrAbove(this.m_minDequeuePriority);
            if (mg != null) {
                Object object = this.m_cc.getSyncObj();
                synchronized (object) {
                    this.m_cc.getSyncObj().notifyAll();
                }
                object = mg;
                return object;
            }
            Object var2_3 = null;
            return var2_3;
        }
        finally {
            this.notifyGroupThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object dequeueWait() throws InterruptedException {
        try {
            Object mg;
            Object object = this.m_cc.getSyncObj();
            synchronized (object) {
                while ((mg = this.dequeue()) == null) {
                    if (this.m_breakDequeueWait && this.m_outLimiter.size() == 0) {
                        this.m_breakDequeueWait = false;
                        Object var3_3 = null;
                        return var3_3;
                    }
                    this.m_cc.getSyncObj().wait();
                }
            }
            this.updateActivity();
            object = mg;
            return object;
        }
        finally {
            this.notifyGroupThreads();
        }
    }

    void addIMinEnqueuePriorityListener(IMinEnqueuePriorityListener iMinEnqPrioListener) {
        if (!this.m_minEnqueuePrioListeners.contains(iMinEnqPrioListener)) {
            this.m_minEnqueuePrioListeners.addElement(iMinEnqPrioListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void breakDequeueWait() {
        this.m_breakDequeueWait = true;
        Object object = this.m_cc.getSyncObj();
        synchronized (object) {
            this.m_cc.getSyncObj().notifyAll();
        }
    }

    boolean isMgramAvailable() {
        return this.m_outpq.hasEnqueuedAtOrAbove(this.m_minDequeuePriority);
    }

    boolean isOutQueueEmpty() {
        return !this.m_senderQueue.checkForOutgoingMsgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMinDequeuePriority(int prio) {
        this.m_minDequeuePriority = prio;
        Object object = this.m_cc.getSyncObj();
        synchronized (object) {
            this.m_cc.getSyncObj().notifyAll();
        }
    }

    void setOutMinEnqueuePriority(int prio) {
        this.m_outMinEnqueuePriority = prio;
        this.calcMinEnqueuePriority();
    }

    void setWaitMinEnqueuePriority(int prio) {
        this.m_waitMinEnqueuePriority = prio;
        this.calcMinEnqueuePriority();
    }

    void setGuarMinEnqueuePriority(int prio) {
        this.m_guarMinEnqueuePriority = prio;
        this.calcMinEnqueuePriority();
    }

    void setQmsgMinEnqueuePriority(int prio) {
        this.m_qmsgMinEnqueuePriority = prio;
        this.calcMinEnqueuePriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcMinEnqueuePriority() {
        int oldprio = this.m_minEnqueuePriority;
        int newprio = Math.max(Math.max(this.m_outMinEnqueuePriority, this.m_qmsgMinEnqueuePriority), Math.max(this.m_waitMinEnqueuePriority, this.m_guarMinEnqueuePriority));
        if (newprio != this.m_minEnqueuePriority) {
            IMinEnqueuePriorityListener iMinEnqPrioListener = null;
            Object object = this.m_minEnqueuePrioListener_Lock;
            synchronized (object) {
                this.m_minEnqueuePriority = newprio;
                while (!this.m_minEnqueuePrioListeners.isEmpty()) {
                    iMinEnqPrioListener = (IMinEnqueuePriorityListener)this.m_minEnqueuePrioListeners.firstElement();
                    PublishLimiter.getFlowControlSender().notifyIMinEnqPrioListener(iMinEnqPrioListener);
                    this.m_minEnqueuePrioListeners.removeElementAt(0);
                }
            }
            for (int i = 0; i < this.m_publishLimiters.m_count; ++i) {
                if (this.m_dbSpacePublishLimiters.indexOf(this.m_publishLimiters.m_data[i], 0) != -1 || this.m_flowToDiskPublishLimiters.indexOf(this.m_publishLimiters.m_data[i], 0) != -1 || this.m_initRestorePublishLimiters.indexOf(this.m_publishLimiters.m_data[i], 0) != -1) continue;
                ((PublishLimiter)this.m_publishLimiters.m_data[i]).subscriberPrioChange(this.m_cc, newprio);
            }
            if (newprio == 0) {
                this.m_publishLimiters.empty();
            }
            if (this.m_notifyLimiter != null) {
                this.m_notifyLimiter.notifyPrioChange();
            }
        }
    }

    void informStoppedPublishers() {
        for (int i = 0; i < this.m_publishLimiters.m_count; ++i) {
            if (this.m_dbSpacePublishLimiters.indexOf(this.m_publishLimiters.m_data[i], 0) != -1 || this.m_flowToDiskPublishLimiters.indexOf(this.m_publishLimiters.m_data[i], 0) != -1 || this.m_initRestorePublishLimiters.indexOf(this.m_publishLimiters.m_data[i], 0) != -1) continue;
            ((PublishLimiter)this.m_publishLimiters.m_data[i]).subscriberPrioChange(this.m_cc, 0);
        }
        this.m_publishLimiters.empty();
    }

    public int getMinEnqueuePriority(PublishLimiterNotify notifyLimiter) {
        this.saveTargetForNotification(notifyLimiter);
        return this.m_minEnqueuePriority;
    }

    public int getQmsgMinEnqueuePriority(PublishLimiterNotify notifyLimiter) {
        this.saveTargetForNotification(notifyLimiter);
        return Math.max(this.m_outMinEnqueuePriority, this.m_qmsgMinEnqueuePriority);
    }

    private void saveTargetForNotification(PublishLimiterNotify notifyLimiter) {
        if (notifyLimiter != null) {
            this.m_notifyLimiter = notifyLimiter;
        }
    }

    Object getMinEnqueuePriorityListenerLock() {
        return this.m_minEnqueuePrioListener_Lock;
    }

    public Vector clearExpiredMsgs() {
        int i;
        IMgram m;
        long now = System.currentTimeMillis();
        Vector v = this.m_senderQueue.getExpiredMsgs();
        int numOutExpMsgs = 0;
        if (v != null) {
            numOutExpMsgs = v.size();
            m = null;
            for (i = 0; i < v.size(); ++i) {
                m = (IMgram)v.elementAt(i);
                this.removeMsgFromGuar(m);
            }
        }
        v = this.clearExpiredPendingMsgs(this.m_pendingGuars, now, v);
        if ((v = this.clearExpiredPendingMsgs(this.m_pendingQmsgs, now, v)) != null && v.size() > numOutExpMsgs) {
            m = null;
            for (i = numOutExpMsgs; i < v.size(); ++i) {
                m = (IMgram)v.elementAt(i);
                this.removeMsgFromGuar(m);
            }
        }
        return v;
    }

    public boolean containsOutgoingMsg(IMgram msg) {
        return this.m_outpq.contains(msg, msg.getPriority());
    }

    private Vector clearExpiredPendingMsgs(IndexedList pendingMsgs, long now, Vector expiredMsgsParam) {
        Vector<IMgram> expiredMsgs = expiredMsgsParam;
        Enumeration mgrms = pendingMsgs.elements();
        while (mgrms.hasMoreElements()) {
            IMgram msg = (IMgram)mgrms.nextElement();
            if (!this.isMsgExpired(msg, now)) continue;
            if (expiredMsgs == null) {
                expiredMsgs = new Vector<IMgram>();
            }
            expiredMsgs.add(msg);
        }
        return expiredMsgs;
    }

    private boolean isMsgExpired(IMgram msg, long now) {
        if (this.m_precheck != null && this.m_precheck.precheck(msg) != 0) {
            return true;
        }
        if (msg.isTTE()) {
            long expTm = msg.getTTE();
            return expTm < now;
        }
        return false;
    }

    void removeMsgFromGuar(IMgram mgram) {
        if (mgram.isGuarenteed()) {
            if (mgram.isQueueMessage()) {
                this.m_pendingQmsgs.remove(mgram.getGuarenteedTrackingNum());
                this.m_qmsgLimiter.add(-mgram.getLimiterSize(), mgram.getPriority());
            } else {
                ListNode n = this.m_pendingGuars.remove(mgram.getGuarenteedTrackingNum());
                if (n != null) {
                    int length = ((IMgram)n.obj).getLimiterSize();
                    this.m_guarLimiter.add(-length, mgram.getPriority());
                }
                this.updateActivity();
            }
            this.removeGroupSubGuarPending(mgram.getGuarenteedTrackingNum());
            this.notifyGroupThreads();
        }
    }

    void markAsHavingSuccessor(IndexedList list) {
        Enumeration elems = list.elements();
        while (elems.hasMoreElements()) {
            IMgram m = (IMgram)elems.nextElement();
            m.setSuccessor(true);
        }
    }

    void initRestoreFlowControlPublisher(PublishLimiter pubLimiter) {
        if (pubLimiter != null && this.m_initRestorePublishLimiters.indexOf(pubLimiter, 0) == -1) {
            this.m_initRestorePublishLimiters.addElement(pubLimiter);
            if (this.m_dbSpacePublishLimiters.indexOf(pubLimiter, 0) == -1) {
                this.pubLimiterAddSubscriberCheckingFlowToDiskIndex(pubLimiter);
            }
        }
    }

    void initRestoreReleaseBlockedPublisher(PublishLimiter pubLimiter, boolean removeFromList) {
        int pubLimiterIndex;
        if (pubLimiter != null && (pubLimiterIndex = this.m_initRestorePublishLimiters.indexOf(pubLimiter, 0)) > -1) {
            if (removeFromList) {
                this.m_initRestorePublishLimiters.removeElementAt(pubLimiterIndex);
            }
            if (this.m_dbSpacePublishLimiters.indexOf(pubLimiter, 0) == -1 && this.m_flowToDiskPublishLimiters.indexOf(pubLimiter, 0) == -1) {
                if (this.m_publishLimiters.indexOf(pubLimiter, 0) == -1) {
                    pubLimiter.subscriberPrioChange(this.m_cc, 0);
                } else {
                    pubLimiter.subscriberPrioChange(this.m_cc, this.m_minEnqueuePriority);
                }
            }
        }
    }

    void initRestoreReleaseBlockedPublishers() {
        for (int ii = 0; ii < this.m_initRestorePublishLimiters.m_count; ++ii) {
            this.initRestoreReleaseBlockedPublisher((PublishLimiter)this.m_initRestorePublishLimiters.m_data[ii], false);
        }
        this.resetData(this.m_initRestorePublishLimiters);
    }

    void dbSpaceFlowControlPublisher(PublishLimiter pubLimiter) {
        if (pubLimiter != null && this.m_dbSpacePublishLimiters.indexOf(pubLimiter, 0) == -1) {
            this.m_dbSpacePublishLimiters.addElement(pubLimiter);
            this.pubLimiterAddSubscriberCheckingFlowToDiskIndex(pubLimiter);
        }
    }

    private void pubLimiterAddSubscriberCheckingFlowToDiskIndex(PublishLimiter pubLimiter) {
        this.processAddSubscriberCheckingPriority(this.m_flowToDiskPublishLimiters, pubLimiter);
    }

    void dbSpaceReleaseBlockedPublishers() {
        for (int ii = 0; ii < this.m_dbSpacePublishLimiters.m_count; ++ii) {
            this.dbSpaceReleaseBlockedPublisher((PublishLimiter)this.m_dbSpacePublishLimiters.m_data[ii], false);
        }
        this.resetData(this.m_dbSpacePublishLimiters);
        if (this.DEBUG) {
            this.debug("dbSpaceReleaseBlockedPublishers;  m_dbSpacePublishLimiters.m_count = 0");
        }
    }

    void dbSpaceReleaseBlockedPublisher(PublishLimiter pubLimiter, boolean removeFromList) {
        int pubLimiterIndex;
        if (pubLimiter != null && (pubLimiterIndex = this.m_dbSpacePublishLimiters.indexOf(pubLimiter, 0)) > -1) {
            if (removeFromList) {
                this.m_dbSpacePublishLimiters.removeElementAt(pubLimiterIndex);
            }
            if (this.m_flowToDiskPublishLimiters.indexOf(pubLimiter, 0) == -1) {
                if (this.m_publishLimiters.indexOf(pubLimiter, 0) == -1) {
                    if (this.DEBUG) {
                        this.debug("*****dbSpaceReleaseBlockedPublisher new prio= 0");
                    }
                    pubLimiter.subscriberPrioChange(this.m_cc, 0);
                } else {
                    if (this.DEBUG) {
                        this.debug("***dbSpaceReleaseBlockedPublisher removed publisher from list; publisher in m_publishLimiters; prio= " + this.m_minEnqueuePriority);
                    }
                    pubLimiter.subscriberPrioChange(this.m_cc, this.m_minEnqueuePriority);
                }
            }
        }
    }

    void dbSpaceReleaseBlockedPublisher(long clientID, boolean removeFromList) {
        IClientContext publisher = null;
        try {
            publisher = AgentRegistrar.getAgentRegistrar().getClient(clientID);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
        if (publisher != null) {
            this.dbSpaceReleaseBlockedPublisher(publisher.getPublishLimiter(), removeFromList);
        }
    }

    void flowToDiskFlowControlPublisher(PublishLimiter pubLimiter) {
        if (pubLimiter != null && this.m_flowToDiskPublishLimiters.indexOf(pubLimiter, 0) == -1) {
            this.m_flowToDiskPublishLimiters.addElement(pubLimiter);
            this.processAddSubscriberCheckingPriority(this.m_dbSpacePublishLimiters, pubLimiter);
        }
    }

    private void processAddSubscriberCheckingPriority(FastVector m_dbSpacePublishLimiters, PublishLimiter pubLimiter) {
        if (m_dbSpacePublishLimiters.indexOf(pubLimiter, 0) == -1) {
            this.pubLimiterAddSubscriberCheckingPriority(pubLimiter);
        }
    }

    private void pubLimiterAddSubscriberCheckingPriority(PublishLimiter pubLimiter) {
        if (this.m_publishLimiters.indexOf(pubLimiter, 0) == -1) {
            pubLimiter.addSubscriber(this.m_cc, 10);
        } else if (this.m_minEnqueuePriority < 10) {
            pubLimiter.subscriberPrioChange(this.m_cc, 10);
        }
    }

    void flowToDiskReleaseBlockedPublishers() {
        for (int ii = 0; ii < this.m_flowToDiskPublishLimiters.m_count; ++ii) {
            this.flowToDiskReleaseBlockedPublisher((PublishLimiter)this.m_flowToDiskPublishLimiters.m_data[ii], false);
        }
        this.resetData(this.m_flowToDiskPublishLimiters);
    }

    private void resetData(FastVector m_dbSpacePublishLimiters) {
        for (int ii = 0; ii < m_dbSpacePublishLimiters.m_count; ++ii) {
            m_dbSpacePublishLimiters.m_data[ii] = null;
        }
        m_dbSpacePublishLimiters.m_count = 0;
    }

    void flowToDiskReleaseBlockedPublisher(PublishLimiter pubLimiter, boolean removeFromList) {
        int pubLimiterIndex;
        if (pubLimiter != null && (pubLimiterIndex = this.m_flowToDiskPublishLimiters.indexOf(pubLimiter, 0)) > -1) {
            if (removeFromList) {
                this.m_flowToDiskPublishLimiters.removeElementAt(pubLimiterIndex);
            }
            if (this.m_dbSpacePublishLimiters.indexOf(pubLimiter, 0) == -1) {
                if (this.m_publishLimiters.indexOf(pubLimiter, 0) == -1) {
                    if (this.DEBUG) {
                        this.debug("*****flowToDiskReleaseBlockedPublisher new prio= 0");
                    }
                    pubLimiter.subscriberPrioChange(this.m_cc, 0);
                } else {
                    if (this.DEBUG) {
                        this.debug("***flowToDiskReleaseBlockedPublisher removed publisher from list; publisher in m_publishLimiters; prio= " + this.m_minEnqueuePriority);
                    }
                    pubLimiter.subscriberPrioChange(this.m_cc, this.m_minEnqueuePriority);
                }
            }
        }
    }

    boolean hasRoomInWaitQueue(IMgram msg) {
        return this.m_waitLimiter.hasRoom(msg.getLimiterSize(), msg.getPriority());
    }

    boolean hasRoomForMgram(IMgram msg, int size) {
        byte prio = msg.getPriority();
        boolean result = this.m_outLimiter.hasRoom(size, prio);
        boolean guaranteed = false;
        if (msg.getType() != 27) {
            guaranteed = msg.isGuarenteed();
        } else {
            IBatchHandle bh = msg.getBatchHandle();
            if (bh.isAtomic()) {
                guaranteed = msg.isGuarenteed();
            } else {
                Iterator iter = bh.getBatchIterator();
                if (iter != null && iter.hasNext() && ((IMgram)iter.next()).isGuarenteed()) {
                    guaranteed = true;
                }
            }
        }
        if (result && guaranteed) {
            result = this.m_guarLimiter.hasRoom(size, prio);
        }
        return result;
    }

    boolean hasRoomForPendingReconnect(IMgram msg) {
        return this.m_reconnectLimiter.hasRoom(msg.getLimiterSize(), msg.getPriority());
    }

    void addPendingReconnect(IMgram msg) {
        if (this.DEBUG) {
            this.debug(this.m_cc + " adding pending reconnect guar soace: " + msg.getGuarenteedTrackingNum());
        }
        if (msg.getType() != 27) {
            if (msg.isGuarenteed()) {
                this.m_pendingReconnectGuars.put(new Long(msg.getGuarenteedTrackingNum()), msg);
                this.m_reconnectLimiter.add(msg.getLimiterSize(), msg.getPriority());
            }
        } else {
            IBatchHandle bh = msg.getBatchHandle();
            if (bh.isAtomic() && msg.isGuarenteed()) {
                this.m_pendingReconnectGuars.put(new Long(msg.getGuarenteedTrackingNum()), msg);
                this.m_reconnectLimiter.add(msg.getLimiterSize(), msg.getPriority());
            } else {
                Iterator it = bh.getBatchIterator();
                if (it != null) {
                    IMgram subMgram = null;
                    if (it.hasNext() && (subMgram = (IMgram)it.next()).isGuarenteed()) {
                        this.m_pendingReconnectGuars.put(new Long(subMgram.getGuarenteedTrackingNum()), subMgram);
                        this.m_reconnectLimiter.add(subMgram.getLimiterSize(), subMgram.getPriority());
                        while (it.hasNext()) {
                            subMgram = (IMgram)it.next();
                            this.m_pendingReconnectGuars.put(new Long(subMgram.getGuarenteedTrackingNum()), subMgram);
                            this.m_reconnectLimiter.add(subMgram.getLimiterSize(), subMgram.getPriority());
                        }
                    }
                }
            }
        }
    }

    IMgram removePendingReconnectGuar(long tracking) {
        IMgram msg = (IMgram)this.m_pendingReconnectGuars.remove(new Long(tracking));
        if (msg != null) {
            if (this.DEBUG) {
                this.debug(this.m_cc + " removed pending reconnect guar: " + tracking);
            }
            this.m_reconnectLimiter.add(-msg.getLimiterSize(), msg.getPriority());
            this.notifyGroupThreads();
        }
        return msg;
    }

    Iterator getPendingReconnectGuars() {
        if (this.DEBUG) {
            this.debug(this.m_cc + " getting pending reconnect guars");
        }
        return this.m_pendingReconnectGuars.values().iterator();
    }

    TreeMap clearPendingReconnectGuars() {
        if (this.DEBUG) {
            this.debug(this.m_cc + " clearing pending reconnect guars");
        }
        TreeMap ret = this.m_pendingReconnectGuars;
        this.m_pendingReconnectGuars = new TreeMap();
        this.m_reconnectLimiter.reset();
        return ret;
    }

    void freePendingReconnectSpace(int size, int prio) {
        if (this.DEBUG) {
            this.debug(this.m_cc + " freeing pending reconnect guar soace: " + size + "/" + prio);
        }
        this.m_reconnectLimiter.add(-size, prio);
    }

    LinkedList emptySaveablePendingReconnectGuars(boolean saveNonPersistentReplicated) {
        if (this.DEBUG) {
            this.debug(this.m_cc + " saving pending reconnect guars");
        }
        LinkedList ret = null;
        TreeMap oldPendingReconnectGuars = this.clearPendingReconnectGuars();
        for (IMgram m : oldPendingReconnectGuars.values()) {
            if (!m.isGuarenteed()) continue;
            if (m.isNonPersistentReplicated() && !saveNonPersistentReplicated) {
                this.m_cc.getDelegator().handleNormalAck(m.getGuarenteedTrackingNum(), false, null, m);
                continue;
            }
            ret = ClientContextMgramQueue.initRet(m, ret);
        }
        return ret;
    }

    private static LinkedList initRet(IMgram m, LinkedList retParam) {
        LinkedList<IMgram> ret = retParam;
        if (ret == null) {
            ret = new LinkedList<IMgram>();
        }
        ret.add(m);
        return ret;
    }

    public final int getPendingReconnectCount() {
        return this.m_pendingReconnectGuars.size();
    }

    public boolean hasFlowControlledPublishers() {
        return this.m_publishLimiters.m_count > 0;
    }

    private void updateActivity() {
        IActivityMonitorHandle mon = this.m_cc.getActivityMonitorHandle();
        if (mon != null && mon.isActivityMonitoringEnabled()) {
            mon.setActive();
        }
    }

    public void addGroupSubGuarPending(IMgram m, GroupSubscriptionClientContext groupcc) {
        if (!m.isGuarenteed()) {
            return;
        }
        this.addGroupSubGuarPending(m.getGuarenteedTrackingNum(), groupcc);
    }

    public void addGroupSubGuarPending(long tracking, GroupSubscriptionClientContext groupcc) {
        if (groupcc == null) {
            return;
        }
        if (this.m_cc.isInterbroker()) {
            return;
        }
        if (this.m_cc.isGroupSubscriptionMember()) {
            this.initGroupSubGuarPendingData(groupcc, tracking);
            groupcc.getOutQueue().addGroupSubGuarPending(tracking, groupcc);
        } else if (this.m_cc.isGroupSubscription()) {
            this.initGroupSubGuarPendingData(groupcc, tracking);
        }
    }

    private void initGroupSubGuarPendingData(GroupSubscriptionClientContext groupcc, long tracking) {
        GroupSubGuarPendingData data = new GroupSubGuarPendingData();
        data.m_groupcc = groupcc;
        data.m_tracking = tracking;
        this.m_msgsFromGroupSubscription.put(tracking, data);
    }

    public GroupSubscriptionClientContext removeGroupSubGuarPending(long tracking) {
        if (this.m_cc.isGroupSubscriptionMember()) {
            GroupSubGuarPendingData data = null;
            data = (GroupSubGuarPendingData)this.m_msgsFromGroupSubscription.remove(tracking);
            if (data != null) {
                data.m_groupcc.getOutQueue().removeGroupSubGuarPending(tracking);
                return data.m_groupcc;
            }
        } else if (this.m_cc.isGroupSubscription()) {
            this.m_msgsFromGroupSubscription.remove(tracking);
        }
        return null;
    }

    public GroupSubscriptionClientContext getGroupSubGuarPendingCC(long tracking) {
        GroupSubscriptionClientContext ret = null;
        if (this.m_cc.isGroupSubscriptionMember()) {
            GroupSubGuarPendingData data = null;
            data = (GroupSubGuarPendingData)this.m_msgsFromGroupSubscription.get(tracking);
            if (data != null) {
                ret = data.m_groupcc;
            }
        }
        return ret;
    }

    public boolean isGroupSubGuarPending(long tracking) {
        return this.m_msgsFromGroupSubscription.containsKey(tracking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGroupSubGuarPending() {
        if (!this.m_cc.isGroupSubscriptionMember()) {
            return;
        }
        LongHashTable<GroupSubscriptionClientContext> groupsUsingCC = new LongHashTable<GroupSubscriptionClientContext>();
        LongHashTable longHashTable = this.m_msgsFromGroupSubscription;
        synchronized (longHashTable) {
            Enumeration groupmsgs = this.m_msgsFromGroupSubscription.elements();
            while (groupmsgs.hasMoreElements()) {
                GroupSubGuarPendingData msgdata = (GroupSubGuarPendingData)groupmsgs.nextElement();
                if (msgdata == null || msgdata.m_groupcc == null) continue;
                msgdata.m_groupcc.getOutQueue().removeGroupSubGuarPending(msgdata.m_tracking);
                groupsUsingCC.put(msgdata.m_groupcc.getId(), msgdata.m_groupcc);
            }
        }
        Enumeration groupsToNotify = groupsUsingCC.elements();
        while (groupsToNotify.hasMoreElements()) {
            GroupSubscriptionClientContext groupcc = (GroupSubscriptionClientContext)groupsToNotify.nextElement();
            if (groupcc == null) continue;
            groupcc.notifyGroup();
        }
        this.m_msgsFromGroupSubscription.clear();
    }

    private void notifyGroupThreads() {
        if (this.m_cc.isGroupSubscriptionMember()) {
            this.m_cc.getGroupSubscriptionCC().notifyGroupRestoreThreads();
        }
    }

    public long[] getCountSizePendingGuars(boolean excludeFromDb, boolean includeBatchCountParam) {
        boolean includeBatchCount = includeBatchCountParam;
        int count = 0;
        long size = 0L;
        includeBatchCount = this.checkNoBatchedMessages(includeBatchCount);
        if (!excludeFromDb && !includeBatchCount) {
            count = this.m_pendingGuars.count();
            size = this.m_guarLimiter.size();
            if (this.checkDebugFlags(64) && count > 0) {
                this.debug("getCountSizePendingGuars (no enum): returnedCtSz " + count + "/" + size);
            }
        } else {
            Enumeration enu = this.m_pendingGuars.elements();
            while (enu.hasMoreElements()) {
                IMgram m = (IMgram)enu.nextElement();
                if (excludeFromDb && m.getBrokerHandle().isFromDB() && m.isPubSub()) continue;
                count = includeBatchCount && m.getType() == 27 ? (count += m.getBatchHandle().getBatchSize()) : ++count;
                size += (long)m.getLimiterSize();
            }
            if (this.checkDebugFlags(64) && this.m_pendingGuars.count() > 0) {
                this.debug("getCountSizePendingGuars: returnedCtSz " + count + "/" + size + " GuarCtSz " + this.m_pendingGuars.count() + "/" + this.m_guarLimiter.size() + " minSendPrio= " + this.m_minDequeuePriority);
            }
        }
        return new long[]{count, size};
    }

    public long[] getCountSizePendingQMsgs() {
        int count = 0;
        long size = 0L;
        count = this.m_pendingQmsgs.count();
        size = this.m_qmsgLimiter.size();
        if (this.checkDebugFlags(64) && count > 0) {
            this.debug("getCountSizePendingQMsgs: returnedCountSize " + count + "/" + size + " minSendPrio= " + this.m_minDequeuePriority);
        }
        return new long[]{count, size};
    }

    public long[] getCountSizeOutgoingMsgs(boolean excludeGuarParam, boolean includeBatchCountParam) {
        boolean includeBatchCount = includeBatchCountParam;
        boolean excludeGuar = excludeGuarParam;
        if (excludeGuar && this.countPending() == 0) {
            excludeGuar = false;
        }
        includeBatchCount = this.configIncludeBatchCountToFalse(includeBatchCount);
        if (!excludeGuar && !includeBatchCount) {
            int count = this.m_outpq.getEnqueued();
            long size = this.m_outLimiter.size();
            if (this.checkDebugFlags(64) && count > 0) {
                this.debug("getCountSizeOutgoingMsgs (no enum): returnedCtSz " + count + "/" + size);
            }
            return new long[]{count, size};
        }
        long[] dat = this.m_outpq.getCountSizeOutgoingMsgs(excludeGuar, includeBatchCount);
        if (this.checkDebugFlags(64) && this.m_outpq.getEnqueued() > 0) {
            this.debug("getCountSizeOutgoingMsgs: returnedCtSz " + dat[0] + "/" + dat[1] + " OutqCtSz " + this.m_outpq.getEnqueued() + "/" + this.m_outLimiter.size() + " minSendPrio= " + this.m_minDequeuePriority);
        }
        return dat;
    }

    public long[] getCountSizePendingReconnectGuars(boolean excludeFromDb, boolean includeBatchCountParam) {
        boolean includeBatchCount = includeBatchCountParam;
        int count = 0;
        long size = 0L;
        includeBatchCount = this.checkNoBatchedMessages(includeBatchCount);
        if (!excludeFromDb && !includeBatchCount) {
            count = this.m_pendingReconnectGuars.size();
            size = this.m_reconnectLimiter.size();
            if (this.checkDebugFlags(64) && count > 0) {
                this.debug("getCountSizePendingReconnectGuars (no enum): returnedCtSz " + count + "/" + size);
            }
        } else {
            for (IMgram m : this.m_pendingReconnectGuars.values()) {
                if (excludeFromDb && m.getBrokerHandle().isFromDB() && m.isPubSub()) continue;
                count = includeBatchCount && m.getType() == 27 ? (count += m.getBatchHandle().getBatchSize()) : ++count;
                size += (long)m.getLimiterSize();
            }
            if (this.checkDebugFlags(64) && !this.m_pendingReconnectGuars.isEmpty()) {
                this.debug("getCountSizePendingReconnectGuars: returnedCtSz " + count + "/" + size + " PendingReconnectCtSz " + this.m_pendingReconnectGuars.size() + "/" + this.m_reconnectLimiter.size());
            }
        }
        return new long[]{count, size};
    }

    private boolean checkNoBatchedMessages(boolean includeBatchCountParam) {
        boolean includeBatchCount = includeBatchCountParam;
        includeBatchCount = this.configIncludeBatchCountToFalse(includeBatchCount);
        return includeBatchCount;
    }

    private boolean configIncludeBatchCountToFalse(boolean includeBatchCountParam) {
        boolean includeBatchCount = includeBatchCountParam;
        if (includeBatchCount && !this.hasBatched()) {
            includeBatchCount = false;
        }
        return includeBatchCount;
    }

    public int getMinDequeuePriority() {
        return this.m_minDequeuePriority;
    }

    public Set getBlockedSenders() {
        int i;
        HashSet<IClientContext> result = new HashSet<IClientContext>();
        for (i = 0; i < this.m_publishLimiters.m_count; ++i) {
            result.add(((PublishLimiter)this.m_publishLimiters.m_data[i]).getPublisherCC());
        }
        for (i = 0; i < this.m_initRestorePublishLimiters.m_count; ++i) {
            result.add(((PublishLimiter)this.m_initRestorePublishLimiters.m_data[i]).getPublisherCC());
        }
        for (i = 0; i < this.m_dbSpacePublishLimiters.m_count; ++i) {
            result.add(((PublishLimiter)this.m_dbSpacePublishLimiters.m_data[i]).getPublisherCC());
        }
        for (i = 0; i < this.m_flowToDiskPublishLimiters.m_count; ++i) {
            result.add(((PublishLimiter)this.m_flowToDiskPublishLimiters.m_data[i]).getPublisherCC());
        }
        return result;
    }

    public int getMaxNonEmptyBlockedPriority() {
        return this.m_outpq.getMaxNonEmptyPriorityBelow(this.m_minDequeuePriority);
    }

    final int enqueueXOnceGroupMessage(IMgram m, PublishLimiter pubLimiter, Label opts, GroupMsgAllocationEvt evt) throws EDuplicateKey {
        return this.enqueue(this.m_outpq, this.m_outLimiter, m, pubLimiter, opts, false, false, evt);
    }

    final IndexedList resetUnflushedXOnceGroupSends() {
        IndexedList old = null;
        if (this.m_unflushedXOGroupSends != null) {
            old = this.m_unflushedXOGroupSends;
            Enumeration undos = old.elements();
            while (undos.hasMoreElements()) {
                GroupMsgAllocationEvt undo = (GroupMsgAllocationEvt)undos.nextElement();
                IMgram m = undo.getMessage();
                this.m_outLimiter.add(-m.getLimiterSize(), m.getPriority());
                this.removeMsgFromGuar(m);
            }
            this.m_unflushedXOGroupSends = null;
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean releaseXOnceGroupMessage(long tracking) {
        if (this.m_unflushedXOGroupSends == null) {
            return false;
        }
        ListNode n = this.m_unflushedXOGroupSends.remove(tracking);
        if (n == null) {
            return false;
        }
        GroupMsgAllocationEvt evt = (GroupMsgAllocationEvt)n.obj;
        if (evt != null) {
            IMgram m = evt.getMessage();
            try {
                this.m_senderQueue.enqueue(m, m.getPriority());
                this.addInDoubtXOGroupSend(evt.getGroupMessageAllocation(), evt.getGroupCC());
            }
            catch (EMgramFormatError mfe) {
                this.removeMsgFromGuar(m);
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR063") + m.getPriority(), (Throwable)mfe, 1);
            }
            finally {
                this.m_outLimiter.add(-m.getLimiterSize(), m.getPriority());
            }
            return true;
        }
        return false;
    }

    private void addUnflushedXOGroupSend(IMgram m, GroupMsgAllocationEvt xoGroupSend) throws EDuplicateKey {
        if (this.m_unflushedXOGroupSends == null) {
            this.m_unflushedXOGroupSends = new IndexedList();
        }
        this.m_unflushedXOGroupSends.append(xoGroupSend.getRecipientTracking(), xoGroupSend);
        this.m_outLimiter.add(m.getLimiterSize(), m.getPriority());
    }

    public void addInDoubtXOGroupSend(GroupXOnceMsgAllocationTracker.GroupMsgAllocation gma, GroupSubscriptionClientContext gscc) {
        if (this.m_inDoubtXOGroupSends == null) {
            this.m_inDoubtXOGroupSends = new IndexedList();
        }
        this.m_inDoubtXOGroupSends.appendNoDup(gma.recipientTracking, new InDoubtXOGroupSend(gma, gscc));
    }

    public InDoubtXOGroupSend removeInDoubtXOGroupSend(long recipientTracking) {
        ListNode node;
        if (this.m_inDoubtXOGroupSends != null && (node = this.m_inDoubtXOGroupSends.remove(recipientTracking)) != null) {
            return (InDoubtXOGroupSend)node.obj;
        }
        return null;
    }

    public InDoubtXOGroupSend getInDoubtXOGroupSend(long recipientTracking) {
        if (this.m_inDoubtXOGroupSends != null) {
            return (InDoubtXOGroupSend)this.m_inDoubtXOGroupSends.get(recipientTracking);
        }
        return null;
    }

    public IndexedList resetInDoubtXOGroupSends() {
        IndexedList old = null;
        if (this.m_inDoubtXOGroupSends != null) {
            old = this.m_inDoubtXOGroupSends;
            this.m_inDoubtXOGroupSends = null;
        }
        return old;
    }

    public ITimeOnBufferTracker getTimeOnBufferTracker() {
        return this.m_timeOnBufferTracker;
    }

    static class BuilderCallback
    implements PrioQueueLimiter.Builder.Callback {
        private Config.MgramQueueConfig cfg;
        private static final String WARNING_PATTERN = "Inconsistency detected in the broker tuning parameters: {0} = {1}.  Using {2}.";

        BuilderCallback(Config.MgramQueueConfig cfg) {
            this.cfg = cfg;
        }

        @Override
        public void normLimitChanged(int old, int current) {
            this.logWarning(this.cfg.SIZE_METADATA.DISPLAY_NAME, old, current);
        }

        @Override
        public void reservedChanged(int old, int current) {
            this.logWarning(this.cfg.MIN_SIZE_METADATA.DISPLAY_NAME, old, current);
        }

        @Override
        public void highLimitChanged(int old, int current) {
            this.logWarning(this.cfg.PRIORITY_SIZE_METADATA.DISPLAY_NAME, old, current);
        }

        @Override
        public void restartThresholdChanged(int old, int current) {
            this.logWarning(this.cfg.RESTART_THRESHOLD_METADATA.DISPLAY_NAME, old, current);
        }

        private void logWarning(String name, int old, int current) {
            Object[] args = new Object[]{name, new Integer(old), new Integer(current)};
            SessionConfig.logMessage(MessageFormat.format(WARNING_PATTERN, args), SessionConfig.getLevelWarning());
        }
    }

    private static class GroupSubGuarPendingData {
        long m_tracking;
        GroupSubscriptionClientContext m_groupcc;

        private GroupSubGuarPendingData() {
        }
    }

    public static class InDoubtXOGroupSend {
        public final GroupXOnceMsgAllocationTracker.GroupMsgAllocation gma;
        public final GroupSubscriptionClientContext groupcc;

        InDoubtXOGroupSend(GroupXOnceMsgAllocationTracker.GroupMsgAllocation gma, GroupSubscriptionClientContext groupcc) {
            this.gma = gma;
            this.groupcc = groupcc;
        }
    }
}

