/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.ws.rm.common.RMManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import progress.message.broker.AMPScratchPad;
import progress.message.broker.AgentMessageProcessor;
import progress.message.broker.AgentQueueMsgTracker;
import progress.message.broker.AgentQueueProcessor;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.BatchSplitEvt;
import progress.message.broker.BrokerDatabase;
import progress.message.broker.BrokerSubscription;
import progress.message.broker.ClientAckEvt;
import progress.message.broker.Config;
import progress.message.broker.DBSubscription;
import progress.message.broker.DeliveryListEvt;
import progress.message.broker.DurableCCTracker;
import progress.message.broker.DurableStatsEvent;
import progress.message.broker.EClientNotRegistered;
import progress.message.broker.ELogOutOfSequence;
import progress.message.broker.EOldVirtualClockException;
import progress.message.broker.EStartupFailure;
import progress.message.broker.EventListener;
import progress.message.broker.GlobalTxnBeginEvt;
import progress.message.broker.GlobalTxnEndEvt;
import progress.message.broker.GlobalTxnJoinEvt;
import progress.message.broker.GlobalTxnResumeEvt;
import progress.message.broker.GlobalTxnSuspendEvt;
import progress.message.broker.GroupMsgAllocationEvt;
import progress.message.broker.GroupMsgDeallocationEvt;
import progress.message.broker.GroupSubscriptionClientContext;
import progress.message.broker.GroupXOnceMsgAllocationTracker;
import progress.message.broker.GuarMsgEvt;
import progress.message.broker.IAgentQueue;
import progress.message.broker.IClientContext;
import progress.message.broker.IDBQMsgs;
import progress.message.broker.IEventProcessor;
import progress.message.broker.IProxyHandle;
import progress.message.broker.IPubSubDeleteTracker;
import progress.message.broker.InterbrokerHook;
import progress.message.broker.LBSTrackingInfo;
import progress.message.broker.LogEvent;
import progress.message.broker.LogFile;
import progress.message.broker.LogReader;
import progress.message.broker.LogRecoveryDBQMsgs;
import progress.message.broker.MsgSaver;
import progress.message.broker.NoDupCommitBegEvt;
import progress.message.broker.ProxyDoubtResolvedEvt;
import progress.message.broker.QueueMsgEvt;
import progress.message.broker.QueueMsgMoveEvt;
import progress.message.broker.QueueMsgMoveToTopicEvt;
import progress.message.broker.QueueMsgSaver;
import progress.message.broker.RecipientVector;
import progress.message.broker.RecipientWrap;
import progress.message.broker.ReplyAckEvt;
import progress.message.broker.SubjectDeleteTracker;
import progress.message.broker.SubscribeEvt;
import progress.message.broker.SubscribeEvtForSelector;
import progress.message.broker.SyncDeleteMsgEvt;
import progress.message.broker.SyncGroupMsgAllocationEvt;
import progress.message.broker.SyncQueueMsgEvt;
import progress.message.broker.SyncQueueMsgMoveEvt;
import progress.message.broker.SyncQueueMsgMoveToTopicEvt;
import progress.message.broker.SyncTempQueueEvt;
import progress.message.broker.SyncTxnEvt;
import progress.message.broker.SyncpointLoc;
import progress.message.broker.TempQueueCreationEvt;
import progress.message.broker.TempQueueData;
import progress.message.broker.TempQueueDeletionEvt;
import progress.message.broker.TrackedSubjectFilter;
import progress.message.broker.TransactionMgr;
import progress.message.broker.TxMsgPubSub;
import progress.message.broker.TxMsgQueue;
import progress.message.broker.TxnAbortBeginEvt;
import progress.message.broker.TxnAbortEvt;
import progress.message.broker.TxnBeginEvt;
import progress.message.broker.TxnCommitEvt;
import progress.message.broker.TxnPrecommitEvt;
import progress.message.broker.TxnPrepareEvt;
import progress.message.broker.UnsubscribeEvt;
import progress.message.broker.gs.GSSubscribeEvt;
import progress.message.broker.gs.GSVirtualClock;
import progress.message.broker.parser.ParseException;
import progress.message.broker.parser.TokenMgrError;
import progress.message.broker.prAccessor;
import progress.message.client.EIntegrityCompromised;
import progress.message.client.EInvalidSubjectSyntax;
import progress.message.db.EDatabaseException;
import progress.message.dbsc.data.IDbQMsgData;
import progress.message.ft.ReplicationReader;
import progress.message.msg.IBrokerHandle;
import progress.message.msg.IMgram;
import progress.message.util.ArrayUtil;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.EDuplicateKey;
import progress.message.util.IndexedList;
import progress.message.util.LongHashTable;
import progress.message.util.QueueUtil;
import progress.message.util.server.ByteBufferInputStream;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.FastVector;
import progress.message.zclient.ISubject;
import progress.message.zclient.ISubjectFilter;
import progress.message.zclient.SessionConfig;

public final class RecoveryMgr
extends DebugObject {
    private static final String COMN_MSG = prAccessor.getString("STR240");
    private static final String SECLOG_MISMATCH = prAccessor.getString("STR241") + COMN_MSG;
    private static final String SECQOPLOG_MISMATCH = prAccessor.getString("STR242") + COMN_MSG;
    private static final String SECNOQOPLOG_MISMATCH = prAccessor.getString("STR243") + COMN_MSG;
    private static final String LOG_MISMATCH = prAccessor.getString("STR244") + COMN_MSG;
    private AgentRegistrar m_reg;
    private LogFile m_log;
    private TransactionMgr m_txnmgr;
    private BrokerDatabase m_db;
    private MsgSaver m_msgSaver;
    private QueueMsgSaver m_queueMsgSaver;
    private boolean m_replicating;
    private boolean m_inSync;
    private boolean m_hasValidSync;
    private boolean DEBUG1;
    private IEventProcessor m_eventProcessor = null;
    private IDBQMsgs m_dbQMsgs;
    private IPubSubDeleteTracker m_pubSubDeleteTracker = null;
    private RecoveryMetaState m_metaState = new RecoveryMetaState();
    private RecoveryMetaState m_backupMetaState;
    private Vector m_postponedGuars;
    private RecoveredQueueSet m_recoveredQueues;
    private long m_lastConnectionId = -1L;

    RecoveredQueueSet getRecoveredQueueSet() {
        return this.m_recoveredQueues;
    }

    RecoveryMgr(AgentRegistrar reg, short processorType) {
        super(DebugState.GLOBAL_DEBUG_ON ? "RecoveryMgr" : null);
        this.DEBUG1 = (this.debugFlags & 0x40) > 0;
        this.m_reg = reg;
        this.m_log = reg.getLogManager().getLogFile();
        this.m_msgSaver = reg.getMsgSaver();
        this.m_queueMsgSaver = reg.getQueueMsgSaver();
        this.m_postponedGuars = new Vector();
        this.m_recoveredQueues = new RecoveredQueueSet();
        this.setRecoveryProcessor(processorType);
    }

    private void setRecoveryProcessor(short processorType) {
        this.m_eventProcessor = processorType == 1 ? new RecoveryReplicationProcessor() : new RecoveryLogProcessor();
    }

    public IEventProcessor getEventProcessor() {
        return this.m_eventProcessor;
    }

    void redeliverMsgs() throws InterruptedException {
        if (this.DEBUG1) {
            this.debug("resending msgs");
        }
        int inDoubt = 0;
        int ackackPending = 0;
        int transacted = 0;
        int count = 0;
        int numTrackers = 0;
        int numRedelivered = 0;
        if (this.DEBUG1) {
            this.debug("redeliverMsgs: Applying GroupXOnceMsgAllocationTrackers; count= " + this.m_metaState.m_groupAllocations.size());
        }
        Enumeration inDoubtAllocatioTrackers = this.m_metaState.m_groupAllocations.elements();
        while (inDoubtAllocatioTrackers.hasMoreElements()) {
            GroupXOnceMsgAllocationTracker tracker = (GroupXOnceMsgAllocationTracker)inDoubtAllocatioTrackers.nextElement();
            try {
                IClientContext cc = this.m_reg.getClient(tracker.getGroupId());
                if (!cc.isGroupSubscription()) continue;
                ((GroupSubscriptionClientContext)cc).setGroupAllocationTracker(tracker);
            }
            catch (EClientNotRegistered cc) {}
        }
        AgentMessageProcessor msgproc = this.m_reg.getMsgProc();
        AMPScratchPad scratch = new AMPScratchPad();
        Enumeration enu = this.m_metaState.m_guars.elements();
        while (enu.hasMoreElements()) {
            IMgram msg;
            long seqNo;
            Object proxying;
            IClientContext proxy;
            long proxyId;
            Enumeration<Long> proxies;
            LongHashTable mappings;
            ++count;
            RecoveredGuarMsg rgm = (RecoveredGuarMsg)enu.nextElement();
            GuarMsgEvt evt = rgm.getEvent();
            evt.convertProxiedCidsToCCs();
            boolean splitBatch = evt.splitBatch();
            if (splitBatch && !rgm.needGuarAck()) continue;
            if (this.DEBUG) {
                this.debug("Redelivering recovered GuarMsg: track: " + rgm.getEventSeqNo());
            }
            if (!rgm.isDeliveredToPubSub() && !splitBatch) {
                if (rgm.isTransacted()) {
                    if (this.m_txnmgr.getTransactionPersistenceType(rgm.getTransactionId()) != 1) continue;
                    ++transacted;
                    evt.createTracker();
                    TxMsgPubSub msg2 = new TxMsgPubSub(evt.getTransactionId(), evt.getTracker());
                    msg2.setOrigTracking(evt.getOrigTracking());
                    this.m_txnmgr.recoveredMsg(msg2);
                    if (!this.DEBUG) continue;
                    this.debug("RedeliverMsgs: Recovered transacted message given to TM trk= " + evt.getTracker().getTracking() + " tid= " + evt.getTransactionId());
                    continue;
                }
                if (evt.getMessage().getBrokerHandle().isBatchedPublish() && ((GuarMsgEvt)evt.getMessage().getBrokerHandle().getLogEvent()).getGuarRecipients() == null) {
                    evt.createTracker();
                    this.m_postponedGuars.addElement(evt);
                    continue;
                }
                if (this.DEBUG) {
                    this.debug("resending msg " + rgm.getEventSeqNo());
                }
                msgproc.recoveredMgram(evt.getMessage(), scratch);
                ++numRedelivered;
                continue;
            }
            boolean needTracker = false;
            if (rgm.needGuarAck()) {
                if (InterbrokerHook.isSet() && InterbrokerHook.isNeighbor(evt.getOrigSender())) {
                    rgm.getEvent().setIBGuarAck(true);
                    needTracker = true;
                    ++ackackPending;
                } else if (this.m_reg.getRouterManager().isRemoteBroker(evt.getOrigSender())) {
                    rgm.getEvent().setRBGuarAck(true);
                    needTracker = true;
                    ++ackackPending;
                } else {
                    try {
                        IClientContext publisher = this.m_reg.getClient(evt.getOrigSender());
                        if (publisher.isXOnce()) {
                            publisher.getXOnceHandle().addGuarUGA(rgm.getEvent().getOrigTracking());
                            rgm.getEvent().setGuarAck(true);
                            needTracker = true;
                            ++ackackPending;
                        }
                    }
                    catch (EClientNotRegistered ecnr) {
                        rgm.setGuarAck(false);
                    }
                }
            }
            if (rgm.getEvent().hasProxyMappings()) {
                mappings = rgm.getEvent().getProxyRecipsTable();
                proxies = ((LongHashTable)mappings.clone()).keys();
                while (proxies.hasMoreElements()) {
                    proxyId = proxies.nextElement();
                    try {
                        proxy = this.m_reg.getClient(proxyId);
                        if (proxy.getProxyHandle() != null) {
                            if (this.DEBUG) {
                                this.debug("Adding proxy mapping for " + proxy + " GUAR=" + rgm.getEventSeqNo());
                            }
                            proxying = (FastVector)mappings.get(proxyId);
                            seqNo = rgm.getEventSeqNo();
                            msg = rgm.getEvent().getMessage();
                            if (msg.getType() != 27) {
                                proxy.getProxyHandle().setProxyRecips(seqNo, (FastVector)proxying);
                            } else {
                                Iterator iter = msg.getBatchHandle().getBatchIterator();
                                while (iter.hasNext()) {
                                    proxy.getProxyHandle().setProxyRecips(++seqNo, (FastVector)proxying);
                                    iter.next();
                                }
                            }
                            if (this.DEBUG) {
                                this.debug("proxy = " + proxy + " proxy.getProxyHandle(): " + proxy.getProxyHandle() + " recovery message");
                            }
                            for (int i = 0; i < ((FastVector)proxying).m_count; ++i) {
                                IClientContext proxyingCC = (IClientContext)((FastVector)proxying).m_data[i];
                                if (proxyingCC == null) continue;
                                if (this.DEBUG) {
                                    this.debug("proxyingCC = " + proxyingCC + " proxyingCC.getProxyingHandle(): " + proxyingCC.getProxyingHandle() + " recovery message");
                                }
                                proxyingCC.getProxyingHandle().notifyProxyInDoubt(proxy);
                            }
                            needTracker = true;
                            continue;
                        }
                        rgm.getEvent().removeProxyRecips(proxyId);
                    }
                    catch (EClientNotRegistered ecnr) {
                        rgm.getEvent().removeProxyRecips(proxyId);
                    }
                }
            }
            if (rgm.getEvent().hasProxyLBSRecips()) {
                mappings = rgm.getEvent().getProxyLBSRecipsTable();
                proxies = ((LongHashTable)mappings.clone()).keys();
                while (proxies.hasMoreElements()) {
                    proxyId = proxies.nextElement();
                    try {
                        proxy = this.m_reg.getClient(proxyId);
                        proxying = (LBSTrackingInfo)mappings.get(proxyId);
                        if (InterbrokerHook.isNeighbor(evt.getOrigSender())) {
                            FastVector th = new FastVector(2);
                            th.addElement(new Long(evt.getOrigSender()));
                            th.addElement(new Long(this.m_reg.getId()));
                            ((LBSTrackingInfo)proxying).copyTransitHistory(th);
                        }
                        seqNo = rgm.getEventSeqNo();
                        msg = rgm.getEvent().getMessage();
                        if (msg.getType() != 27) {
                            proxy.addLBSWrapperInfo(seqNo, ((LBSTrackingInfo)proxying).getTargetGroups());
                        } else {
                            Iterator iter = msg.getBatchHandle().getBatchIterator();
                            while (iter.hasNext()) {
                                proxy.addLBSWrapperInfo(++seqNo, ((LBSTrackingInfo)proxying).getTargetGroups());
                                iter.next();
                            }
                        }
                        needTracker = true;
                    }
                    catch (EClientNotRegistered ecnr) {
                        rgm.getEvent().removeProxyLBSRecips(proxyId);
                    }
                }
            }
            if (!needTracker) continue;
            GuarMsgEvt gevt = rgm.getEvent();
            gevt.createTracker(true);
            if (splitBatch) {
                gevt.getTracker().endSplitting();
                gevt.getTracker().canceled();
            }
            ++numTrackers;
        }
        this.m_metaState.m_guars = null;
        if (this.DEBUG1) {
            this.debug("redeliverMsgs PubSub: Num recovered= " + count);
            this.debug("redeliverMsgs PubSub: Num transacted= " + transacted);
            this.debug("redeliverMsgs PubSub: Num ackackPending= " + ackackPending);
            this.debug("redeliverMsgs PubSub: Num redelivered = " + numRedelivered);
            this.debug("redeliverMsgs PubSub: Num trackers = " + numTrackers);
            this.debug("redeliverMsgs PubSub: Complete");
        }
        if (this.DEBUG1) {
            this.debug("Compiling 'in-doubt' and 'ackack-pending' lists of queue messages");
        }
        Iterator iter = this.m_metaState.m_recQMsgs.values().iterator();
        inDoubt = 0;
        ackackPending = 0;
        transacted = 0;
        count = 0;
        numTrackers = 0;
        while (iter.hasNext()) {
            ++count;
            RecoveredQMsg rqm = (RecoveredQMsg)iter.next();
            try {
                IClientContext cc;
                AgentQueueMsgTracker tracker = null;
                if (!rqm.isDelivered()) {
                    tracker = rqm.createTracker();
                    ++numTrackers;
                    if (rqm.isTransacted()) {
                        if (this.m_txnmgr.getTransactionPersistenceType(rqm.getTransactionId()) == 1) {
                            ++transacted;
                            TxMsgQueue tq = null;
                            try {
                                tq = new TxMsgQueue(this.m_reg.getClient(rqm.getOrigSender()), rqm.getTransactionId(), rqm.getMessage());
                            }
                            catch (EClientNotRegistered cnrE) {
                                tq = new TxMsgQueue(rqm.getOrigSender(), rqm.getTransactionId(), rqm.getMessage());
                            }
                            tq.addDeliveryInfo(tracker);
                            tq.setOrigTracking(rqm.getOrigTracking());
                            this.m_txnmgr.recoveredMsg(tq);
                            if (this.DEBUG) {
                                this.debug("RedeliverMsgs: Transacted Queue Msg " + rqm.getTracking() + " tid= " + rqm.getTracking());
                            }
                        }
                    } else if (rqm.getReceiverId() != 0L) {
                        ++inDoubt;
                        if (this.DEBUG) {
                            this.debug("InDoubt " + rqm.getTracking());
                        }
                        cc = null;
                        try {
                            cc = this.m_reg.getClient(rqm.getReceiverId());
                        }
                        catch (EClientNotRegistered cnrE) {
                            // empty catch block
                        }
                        if (cc != null && InterbrokerHook.isSet() && cc.isInterbroker()) {
                            InterbrokerHook.setMsgInDoubt(rqm.getReceiverId(), rqm.getTracking());
                            if (this.DEBUG) {
                                this.debug("Interbroker InDoubt " + rqm.getTracking() + " " + rqm.getReceiverId());
                            }
                        } else if (this.m_reg.getRouterManager().isRemoteBroker(rqm.getReceiverId())) {
                            this.m_reg.getRouterManager().setMsgInDoubt(rqm.getReceiverId(), rqm.getTracking());
                            if (this.DEBUG) {
                                this.debug("RemoteBroker InDoubt " + rqm.getTracking() + " " + rqm.getReceiverId());
                            }
                        } else if (cc != null && cc.isXOnce()) {
                            this.m_reg.getQMsgStateMgr().addInDoubtMsg(rqm.getTracking());
                            if (rqm.getMessage() != null) {
                                if (this.DEBUG) {
                                    BrokerComponent.getComponentContext().logMessage("adding in-doubt q msg " + rqm.getTracking() + " to cc " + cc, 3);
                                }
                                IMgram m = rqm.getMessage();
                                m.getBrokerHandle().setLocalQueueName(rqm.getQueueName());
                                if (this.m_reg.getQueueProc().getAgentQueue(rqm.getQueueName()) != null) {
                                    cc.getXOnceHandle().addInDoubtQMsg(m);
                                } else if (rqm.isTemporary()) {
                                    this.m_reg.getQueueProc().cancelMsg(rqm.getTracking(), rqm.getQueueName(), false);
                                }
                            } else {
                                if (this.DEBUG) {
                                    BrokerComponent.getComponentContext().logMessage("adding in-doubt q msg tracking " + rqm.getTracking() + " to cc " + cc, 3);
                                }
                                if (this.m_reg.getQueueProc().getAgentQueue(rqm.getQueueName()) != null) {
                                    cc.getXOnceHandle().addInDoubtQMsg(rqm.getTracking());
                                } else if (rqm.isTemporary()) {
                                    this.m_reg.getQueueProc().cancelMsg(rqm.getTracking(), rqm.getQueueName(), false);
                                }
                            }
                        } else {
                            rqm.setReceiverId(0L);
                            if (rqm.isTemporary()) {
                                this.reEnqueueMessage(rqm);
                            }
                        }
                    } else if (rqm.isTemporary()) {
                        this.reEnqueueMessage(rqm);
                    }
                }
                if (!rqm.needGuarAck()) continue;
                ++ackackPending;
                if (this.DEBUG) {
                    this.debug("AckAckPending " + rqm.getTracking());
                }
                cc = null;
                try {
                    cc = this.m_reg.getClient(rqm.getOrigSender());
                }
                catch (EClientNotRegistered eClientNotRegistered) {
                    // empty catch block
                }
                if (cc != null && InterbrokerHook.isSet() && cc.isInterbroker()) {
                    if (tracker == null) {
                        tracker = rqm.createTracker();
                        ++numTrackers;
                    }
                    InterbrokerHook.xOnceQMsgReceived(rqm.getOrigSender(), rqm.getOrigTracking(), tracker);
                    if (!this.DEBUG) continue;
                    this.debug("Interbroker AckAckPending " + rqm.getTracking() + " origTracking= " + rqm.getOrigTracking());
                    continue;
                }
                if (this.m_reg.getRouterManager().isRemoteBroker(rqm.getOrigSender())) {
                    if (tracker == null) {
                        tracker = rqm.createTracker();
                        ++numTrackers;
                    }
                    this.m_reg.getRouterManager().xOnceQMsgReceived(rqm.getOrigSender(), rqm.getOrigTracking(), tracker);
                    if (!this.DEBUG) continue;
                    this.debug("RemoteBroker AckAckPending " + rqm.getTracking() + " origTracking= " + rqm.getOrigTracking());
                    continue;
                }
                if (cc != null && cc.isXOnce()) {
                    if (tracker == null) {
                        tracker = rqm.createTracker();
                        tracker.endSplitting();
                        ++numTrackers;
                    }
                    cc.rcvdGuarQMsg(rqm.getOrigTracking(), tracker);
                    cc.getXOnceHandle().addQueueUGA(rqm.getOrigTracking());
                    continue;
                }
                if (tracker == null) continue;
                tracker.guarAckDone();
            }
            catch (EDuplicateKey e) {
                BrokerComponent.getComponentContext().logMessage("Duplicate tracking number for recovered queue msg: " + rqm.getTracking(), (Throwable)e, 2);
            }
        }
        this.m_metaState.m_recQMsgs = null;
        if (this.DEBUG1) {
            this.debug("redeliverMsgs PTP: Num recovered= " + count);
            this.debug("redeliverMsgs PTP: Num transacted= " + transacted);
            this.debug("redeliverMsgs PTP: Num messages requiring resolution with remote senders/receivers= " + count);
            this.debug("redeliverMsgs PTP: Num ackackPending= " + ackackPending);
            this.debug("redeliverMsgs PTP: Num inDoubt = " + inDoubt);
            this.debug("redeliverMsgs PTP: Num trackers = " + numTrackers);
            this.debug("redeliverMsgs PTP: Complete");
        }
        numTrackers = 0;
        if (this.DEBUG1) {
            this.debug("Re-tracking recovered XO Requests: Num trackers = " + numTrackers);
        }
    }

    private void reEnqueueMessage(RecoveredQMsg rqm) throws InterruptedException {
        IMgram msg = rqm.getMessage();
        if (msg != null) {
            this.m_reg.getQueueProc().recoveredTemporaryMgram(msg);
        }
    }

    void redeliverPostponedMsgs() {
        int numRedelivered = 0;
        AgentMessageProcessor msgproc = this.m_reg.getMsgProc();
        AMPScratchPad scratch = new AMPScratchPad();
        Enumeration enu = this.m_postponedGuars.elements();
        while (enu.hasMoreElements()) {
            GuarMsgEvt evt = (GuarMsgEvt)enu.nextElement();
            if (this.DEBUG) {
                this.debug("redelivering postponed msg " + evt.getSeqNo());
            }
            msgproc.recoveredPostponedMgram(evt.getMessage(), scratch);
            ++numRedelivered;
        }
        if (this.DEBUG1) {
            this.debug("redeliverPostponedMsgs PubSub: Num redelivered = " + numRedelivered);
        }
    }

    private void splitPtpBatch(IMgram batchMgram, TreeMap map, long tracking, String queueName, boolean needGuarAck, long origSender, long origTracking, boolean delivered, long receiverId, long oldTracking, int tid, boolean isTemp) {
        RecoveredQMsg rqm = null;
        batchMgram.getBatchHandle().syncBatch();
        Iterator iter = batchMgram.getBatchHandle().getBatchIterator();
        long subTracking = tracking + 1L;
        while (iter.hasNext()) {
            Long t;
            IMgram subMgram = (IMgram)iter.next();
            subMgram.getBrokerHandle().setBatchedPublish(true);
            subMgram.setGuarenteed(subTracking);
            byte priority = subMgram.getPriority();
            rqm = new RecoveredQMsg(subTracking, queueName, subMgram, false, origSender, origTracking, delivered, receiverId, oldTracking, tid, isTemp, priority);
            if (subMgram != null) {
                rqm.setEnqueuedSize(subMgram.getEnqueuedSize());
                if (subMgram.isTTE()) {
                    rqm.setExpiration(subMgram.getTTE());
                }
            }
            if (rqm.isTransacted()) {
                rqm.setNonTransacted();
            }
            this.checkDBState(rqm);
            if (this.m_replicating) {
                subMgram.saveMemory();
            }
            if (!map.containsKey(t = new Long(subTracking))) {
                map.put(t, rqm);
            }
            ++subTracking;
        }
    }

    private void splitPubSubBatch(GuarMsgEvt batchEvt, IndexedList list, boolean deliveredToPubSub, boolean syncEvent) {
        IMgram batchMgram = batchEvt.getMessage();
        long logSeqNo = batchEvt.getSeqNo();
        batchMgram.getBatchHandle().syncBatch();
        Iterator iter = batchMgram.getBatchHandle().getBatchIterator();
        GuarMsgEvt subEvt = null;
        RecoveredGuarMsg rgm = null;
        DeliveryListEvt delEvt = null;
        int subjectTrackingCount = 1;
        if (batchMgram.getSubject().isMultiSubject()) {
            subjectTrackingCount += batchMgram.getSubject().getMultiSubjectCount();
        }
        long subLogSeqNo = logSeqNo + (long)subjectTrackingCount;
        boolean foundDeliveryListForBatch = false;
        if (this.m_inSync && (delEvt = (DeliveryListEvt)this.m_metaState.m_deliveryLists.get(new Long(logSeqNo))) != null) {
            foundDeliveryListForBatch = true;
        }
        while (iter.hasNext()) {
            IMgram subMgram = (IMgram)iter.next();
            subMgram.getBrokerHandle().setBatchedPublish(true);
            subEvt = new GuarMsgEvt(subMgram);
            subEvt.setBatchedPublish(true);
            subEvt.setSeqNo(subLogSeqNo);
            subEvt.setLogged(true);
            subEvt.setLBSInfo(batchEvt.getGroupSubscriptionList(), batchEvt.getGroupSubscriptionOnly());
            subMgram.getBrokerHandle().setLogEvent(subEvt);
            rgm = new RecoveredGuarMsg(subEvt, deliveredToPubSub, false, syncEvent);
            if (this.m_inSync && !foundDeliveryListForBatch) {
                delEvt = (DeliveryListEvt)this.m_metaState.m_deliveryLists.get(new Long(subLogSeqNo));
            }
            if (delEvt != null) {
                boolean cloneProxyRecipsTable = false;
                if (foundDeliveryListForBatch) {
                    cloneProxyRecipsTable = true;
                }
                this.setDeliveryInfo(delEvt, rgm, cloneProxyRecipsTable || this.m_replicating);
            }
            if (rgm.isTransacted()) {
                rgm.setNonTransacted();
            }
            list.appendNoDup(subLogSeqNo, rgm);
            subLogSeqNo += (long)subjectTrackingCount;
        }
    }

    public void redoGuarMsg(GuarMsgEvt evt) {
        IndexedList list = this.m_inSync ? this.m_metaState.m_nonsyncGuars : this.m_metaState.m_guars;
        list.appendNoDup(evt.getSeqNo(), new RecoveredGuarMsg(evt, evt.getDeliveredToPubSub(), evt.needGuarAck(), false));
        if (this.DEBUG1 && list == this.m_metaState.m_guars && list.count() % 1000 == 0) {
            this.debug("redoGuarMsg: m_metaState.m_guars.size= " + list.count());
        }
        evt.getMessage().getBrokerHandle().setSenderID(evt.getOrigSender());
        RMManager.getRMManager().onRecoveredGuarMsg(evt.getMessage());
        RecoveryMgr.configRemoteBrokerFlag(evt);
        if (evt.splitBatch()) {
            this.splitPubSubBatch(evt, list, false, false);
        }
        this.configRecoveredTxSeqNo(evt);
    }

    public void redoSyncGuarMsg(GuarMsgEvt evt, boolean deliveredToPubSub, boolean needIBGuarAck, boolean canceled) {
        if (this.m_inSync) {
            this.appendNoDupOrReplace(new RecoveredGuarMsg(evt, deliveredToPubSub, needIBGuarAck, true), this.m_metaState.m_guars);
            evt.getMessage().getBrokerHandle().setSenderID(evt.getOrigSender());
            RecoveryMgr.configRemoteBrokerFlag(evt);
            if (evt.splitBatch() && !canceled) {
                this.splitPubSubBatch(evt, this.m_metaState.m_guars, false, true);
            }
            this.configRecoveredTxSeqNo(evt);
        }
    }

    private void configRecoveredTxSeqNo(GuarMsgEvt evt) {
        if (evt.getMessage().getBrokerHandle().isTransactionalPublish()) {
            int tid = evt.getMessage().getBrokerHandle().getTxnPublishTid();
            int tidSeq = evt.getMessage().getBrokerHandle().getTxnPublishTidSeqNo();
            this.m_txnmgr.setRecoveredTxSeqno(tid, tidSeq);
        }
    }

    private static void configRemoteBrokerFlag(GuarMsgEvt evt) {
        if (InterbrokerHook.isSet()) {
            evt.getMessage().getBrokerHandle().setFromRemoteBroker(InterbrokerHook.isNeighbor(evt.getOrigSender()));
        }
    }

    public void redoMsgDelivered(long tracking) {
        if (this.m_inSync) {
            this.m_metaState.m_deliveries.addElement(new Long(tracking));
        } else {
            RecoveredGuarMsg rgm = (RecoveredGuarMsg)this.m_metaState.m_guars.get(tracking);
            if (this.DEBUG) {
                this.debug("Redoing MsgDeliveredEvt, tracking=" + tracking);
            }
            if (rgm != null) {
                rgm.setNonTransacted();
                if (rgm.needGuarAck() || rgm.m_evt.hasProxyMappings()) {
                    rgm.setDeliveredToPubSub(true);
                } else {
                    this.m_metaState.m_guars.remove(tracking);
                }
            }
        }
    }

    public void redoGuarAckDone(long tracking) {
        if (this.m_inSync) {
            this.m_metaState.m_IBGuarAcks.addElement(new Long(tracking));
        } else {
            RecoveredGuarMsg rgm = (RecoveredGuarMsg)this.m_metaState.m_guars.get(tracking);
            if (rgm != null) {
                if (rgm.isDeliveredToPubSub() && !rgm.getEvent().hasProxyMappings()) {
                    this.m_metaState.m_guars.remove(tracking);
                } else {
                    rgm.setGuarAck(false);
                }
            }
        }
    }

    public void redoQueueMsg(QueueMsgEvt evt) {
        this.redoQueueMsg(evt, false);
    }

    private void redoQueueMsg(QueueMsgEvt evt, boolean forceSyncList) {
        RecoveredQMsg rqm;
        TreeMap map;
        if (this.DEBUG) {
            this.debug("redoQueueMsg: " + evt.getSeqNo() + " inSync=" + this.m_inSync + " forceSyncList=" + forceSyncList);
        }
        TreeMap treeMap = forceSyncList ? this.m_metaState.m_recQMsgs : (map = this.m_inSync ? this.m_metaState.m_nonsyncQMsgs : this.m_metaState.m_recQMsgs);
        if (!evt.splitBatch()) {
            rqm = new RecoveredQMsg(evt);
            this.checkDBState(rqm);
            Long tracking = new Long(rqm.getTracking());
            if (!map.containsKey(tracking)) {
                map.put(tracking, rqm);
                if (this.DEBUG1 && map == this.m_metaState.m_recQMsgs && this.m_metaState.m_recQMsgs.size() % 1000 == 0) {
                    this.debug("redoQueueMsg: m_recQMsgs.size()= " + this.m_metaState.m_recQMsgs.size());
                }
            }
            RMManager.getRMManager().onRecoveredGuarQMsg(rqm.getMessage());
        } else {
            this.splitPtpBatch(evt.getMessage(), map, evt.getSeqNo(), evt.getLocalQueueName(), evt.needGuarAck(), evt.getOrigSender(), evt.getOrigTracking(), false, 0L, 0L, evt.getTransactionId(), evt.isTempQueue());
            if (evt.needGuarAck()) {
                rqm = new RecoveredQMsg(evt);
                rqm.setDelivered(true);
                rqm.setReceiverId(0L);
                rqm.setMessage(null);
                rqm.setNonTransacted();
                RecoveryMgr.putTracking(map, rqm);
            }
        }
        if (evt.getMessage() != null && evt.getMessage().getBrokerHandle().isTransactionalPublish()) {
            int tid = evt.getMessage().getBrokerHandle().getTxnPublishTid();
            int tidSeq = evt.getMessage().getBrokerHandle().getTxnPublishTidSeqNo();
            this.m_txnmgr.setRecoveredTxSeqno(tid, tidSeq);
        }
        if (evt.getMessage() != null && this.m_replicating) {
            evt.getMessage().saveMemory();
        }
    }

    public void redoTempQueueCreationEvt(TempQueueCreationEvt evt) {
        if (this.m_inSync) {
            this.m_metaState.m_nonsyncTempQueueEvt.add(evt);
        } else {
            this.addTempQueueInternal(evt.getClientID(), evt.getQueueName(), evt.getType(), evt.isGlobal(), evt.getMaxSize());
        }
    }

    private void addTempQueueInternal(long clientId, String queueName, int type, boolean global, int size) {
        HashMap<String, TempQueueData> map = (HashMap<String, TempQueueData>)this.m_metaState.m_tempQueues.get(clientId);
        if (map == null) {
            map = new HashMap<String, TempQueueData>();
            this.m_metaState.m_tempQueues.put(clientId, map);
        }
        map.put(queueName, new TempQueueData(queueName, type, global, size));
    }

    public void redoTempQueueDeletionEvt(TempQueueDeletionEvt evt) {
        if (this.m_inSync) {
            this.m_metaState.m_nonsyncTempQueueEvt.add(evt);
        } else {
            HashMap map = (HashMap)this.m_metaState.m_tempQueues.get(evt.getClientID());
            if (map != null) {
                String name = evt.getQueueName();
                if (name != null) {
                    map.remove(evt.getQueueName());
                } else {
                    this.m_metaState.m_tempQueues.remove(evt.getClientID());
                }
            }
        }
    }

    public void redoSyncTempQueueEvt(SyncTempQueueEvt evt) {
        Enumeration cidEnum = evt.getCIDs();
        while (cidEnum.hasMoreElements()) {
            long cid = (Long)cidEnum.nextElement();
            LinkedList list = evt.getTempQueueData(cid);
            for (TempQueueData tqd : list) {
                this.addTempQueueInternal(cid, tqd.getQueueName(), tqd.getQueueType(), tqd.isGlobal(), tqd.getMaxSize());
            }
        }
    }

    public void redoSyncQueueMsg(SyncQueueMsgEvt evt) {
        if (this.m_inSync) {
            Long tracking;
            RecoveredQMsg rqm = null;
            if (evt.m_parentExists && (rqm = (RecoveredQMsg)this.m_metaState.m_recQMsgs.get(tracking = new Long(evt.m_tracking))) == null) {
                rqm = (RecoveredQMsg)this.m_metaState.m_nonsyncQMsgs.get(tracking);
            }
            if (rqm == null) {
                if (!evt.splitBatch()) {
                    rqm = new RecoveredQMsg(evt);
                    this.checkDBState(rqm);
                    tracking = new Long(evt.m_tracking);
                    this.populateQMsgs(tracking, rqm);
                } else {
                    if (!evt.m_delivered) {
                        this.splitPtpBatch(evt.m_msg, this.m_metaState.m_recQMsgs, evt.m_tracking, evt.m_queueName, evt.m_needGuarAck, evt.m_origSender, evt.m_origTracking, evt.m_delivered, evt.m_receiverId, evt.m_oldTracking, evt.m_tid, evt.m_isTemp);
                    }
                    if (evt.m_needGuarAck) {
                        RecoveredQMsg splitRqm = new RecoveredQMsg(evt);
                        splitRqm.setDelivered(true);
                        splitRqm.setReceiverId(0L);
                        splitRqm.setMessage(null);
                        splitRqm.setNonTransacted();
                        Long tracking2 = new Long(splitRqm.getTracking());
                        this.populateQMsgs(tracking2, splitRqm);
                    }
                }
            } else {
                rqm.setDeliveredUnresolved(false);
                rqm.setReceiverIDUnresolved(false);
                rqm.setDelivered(evt.m_delivered);
                rqm.setReceiverId(evt.m_receiverId);
                this.checkDBState(rqm);
            }
            if (this.DEBUG) {
                this.debug("redoSyncQueueMsg: " + rqm.getTracking() + " inSync=" + this.m_inSync);
            }
            if (evt.m_msg != null && evt.m_msg.getBrokerHandle().isTransactionalPublish()) {
                int tid = evt.m_msg.getBrokerHandle().getTxnPublishTid();
                int tidSeq = evt.m_msg.getBrokerHandle().getTxnPublishTidSeqNo();
                this.m_txnmgr.setRecoveredTxSeqno(tid, tidSeq);
            }
            if (rqm != null && rqm.getOldTracking() != 0L) {
                this.m_metaState.m_qAcks.addElement(new SyncQAck(rqm.getOldTracking(), false, false));
            }
            if (rqm != null) {
                RecoveredQMsg msg;
                if (this.m_backupMetaState != null && (msg = (RecoveredQMsg)this.m_backupMetaState.m_recQMsgs.get(new Long(evt.m_tracking))) != null && rqm.getMessage() != null) {
                    msg.setMessage(rqm.getMessage());
                }
                if (rqm.getMessage() != null && this.m_replicating) {
                    rqm.getMessage().saveMemory();
                }
            }
        }
    }

    private void populateQMsgs(Long tracking, RecoveredQMsg splitRqm) {
        if (!this.m_metaState.m_recQMsgs.containsKey(tracking)) {
            this.m_metaState.m_recQMsgs.put(tracking, splitRqm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoQueueMsgAcked(long trackingValue, boolean hasDelete, boolean forceDelete) {
        Long tracking = new Long(trackingValue);
        if (this.m_inSync) {
            if (this.DEBUG) {
                this.debug("redoQueueMsgAcked " + tracking + " inSync = true");
            }
            this.m_metaState.m_qAcks.addElement(new SyncQAck(trackingValue, hasDelete, forceDelete));
        } else {
            RecoveredQMsg rqm;
            short status;
            if (this.DEBUG) {
                this.debug("redoQueueMsgAcked " + tracking + " inSync = false");
            }
            boolean deleteHappened = false;
            IDBQMsgs iDBQMsgs = this.m_dbQMsgs;
            synchronized (iDBQMsgs) {
                status = this.m_dbQMsgs.status(trackingValue, true);
                if (status == 2 && hasDelete && (deleteHappened = this.m_dbQMsgs.deleteStatus(trackingValue))) {
                    status = 1;
                    this.m_dbQMsgs.cancelInfo(trackingValue);
                }
            }
            if (status == 0 || forceDelete) {
                if (this.DEBUG) {
                    this.debug("redoQueueMsgAcked " + tracking + " deleting from db");
                }
                this.m_dbQMsgs.remove(trackingValue);
                this.m_queueMsgSaver.deleteMsg(trackingValue, false);
            }
            if ((rqm = (RecoveredQMsg)this.m_metaState.m_recQMsgs.get(tracking)) != null) {
                rqm.setDeliveredUnresolved(false);
                rqm.setReceiverIDUnresolved(false);
                rqm.setDelivered(true);
                RecoveryMgr.resetUnusedValues(rqm);
                if (rqm.needGuarAck()) {
                    if (status == 2 && hasDelete) {
                        rqm.setDeleteHandler((short)0);
                    }
                } else if (status != 2 || !hasDelete) {
                    this.m_metaState.m_recQMsgs.remove(tracking);
                    if (status == 2) {
                        this.m_dbQMsgs.cancelInfo(trackingValue);
                    }
                } else if (hasDelete) {
                    rqm.setRemoveHandler((short)1);
                    rqm.setRemoveDeleteRQMHandler((short)0);
                }
            } else {
                this.m_dbQMsgs.cancelInfo(trackingValue);
            }
        }
    }

    public void processSubscribe(SubscribeEvt evt, boolean onStandby) {
        this.processSubscribe(evt, null, false, null, onStandby);
    }

    private void processSubscribe(SubscribeEvt evt, Boolean unfiltered, boolean fromDB, HashSet inDoubtProxies, boolean onStandby) {
        block37: {
            try {
                if (evt.getLabel().isPersistent() || onStandby && evt.isReplicateOnly()) {
                    this.m_reg.recoverSubscribe(evt, unfiltered, onStandby);
                    try {
                        IClientContext cc = null;
                        if (evt.getPreviousBrokerCID() != -1L || evt.getRestoreToBrokerCID() != -1L) {
                            cc = this.m_reg.getClient(evt.getClientId());
                        }
                        if (cc != null && cc.isDurable()) {
                            BrokerSubscription rbs = this.m_reg.getRecoveredDurableBrokerSubscription(cc.getId());
                            rbs.setDurableStrictMessageOrder(evt.getDurableStrictMessageOrder());
                            if (evt.getPreviousBrokerCID() != -1L) {
                                IClientContext previous = null;
                                try {
                                    previous = this.m_reg.getClient(evt.getPreviousBrokerCID());
                                }
                                catch (EClientNotRegistered eClientNotRegistered) {
                                    // empty catch block
                                }
                                if (this.DEBUG) {
                                    this.debug("Setting previous broker for: " + cc + " to " + previous);
                                }
                                cc.setCWADSPreviousBroker(previous);
                                if (previous != null && !fromDB && cc.getId() != previous.getId() && cc.getProxyingHandle() != null) {
                                    if (this.DEBUG) {
                                        BrokerComponent.getComponentContext().logMessage(this + " Setting previous broker in doubt for: " + cc + " -- previous: " + previous, 3);
                                    }
                                    cc.getProxyingHandle().notifyProxyInDoubt(previous);
                                }
                                if (rbs != null) {
                                    rbs.setPreviousBrokerCID(evt.getPreviousBrokerCID());
                                }
                            }
                            if (inDoubtProxies != null && cc.getProxyingHandle() != null) {
                                Iterator it = inDoubtProxies.iterator();
                                while (it.hasNext()) {
                                    long id = (Long)it.next();
                                    IClientContext proxy = null;
                                    try {
                                        proxy = this.m_reg.getClient(id);
                                        if (this.DEBUG) {
                                            BrokerComponent.getComponentContext().logMessage(this + " Adding in doubt broker for: " + cc + " -- inDoubt: " + proxy, 3);
                                        }
                                        cc.getProxyingHandle().notifyProxyInDoubt(proxy);
                                    }
                                    catch (EClientNotRegistered eClientNotRegistered) {}
                                }
                            }
                            if (evt.getRestoreToBrokerCID() != -1L) {
                                IClientContext restoring = null;
                                try {
                                    restoring = this.m_reg.getClient(evt.getRestoreToBrokerCID());
                                }
                                catch (EClientNotRegistered id) {
                                    // empty catch block
                                }
                                if (this.DEBUG) {
                                    this.debug("Setting restore broker for: " + cc + " to " + restoring);
                                }
                                cc.setCWADSRestoringBroker(restoring);
                                if (rbs != null) {
                                    if (this.DEBUG) {
                                        this.debug("redoSubscribe  bs.setDurableStrictMessageOrder(true)");
                                    }
                                    rbs.setDurableStrictMessageOrder(true);
                                    if (restoring != null) {
                                        rbs.setRestoreToBrokerCID(evt.getRestoreToBrokerCID());
                                    } else {
                                        rbs.setRestoreToBrokerCID(-1L);
                                    }
                                }
                            }
                        }
                        if (onStandby && evt.getSubject() != null) {
                            cc = this.m_reg.getClient(evt.getClientId());
                            String subject = evt.getSubject().getJMSName();
                            if (cc != null && cc.isXOnce() && QueueUtil.isQueueMessageGroupSubject(subject)) {
                                IAgentQueue iaq;
                                String queueName = QueueUtil.getQueueNameFromMessageGroupSubject(subject);
                                String groupName = QueueUtil.getGroupNameFromMessageGroupSubject(subject);
                                if (this.checkDebugFlags(16384)) {
                                    this.debug("processing message group subscription, group = " + groupName + ", queue = " + queueName);
                                }
                                if ((iaq = this.m_reg.getQueueProc().getAgentQueue(queueName)) != null && iaq.getMessageGroupHandle() != null) {
                                    iaq.getMessageGroupHandle().onQueueMessageGroupSubscription(evt.getClientId(), groupName);
                                }
                            }
                        }
                        break block37;
                    }
                    catch (EClientNotRegistered cc) {}
                    break block37;
                }
                UnsubscribeEvt uevt = new UnsubscribeEvt(null, evt.getClientId(), evt.getSubject());
                uevt.setLogged(true);
                uevt.setSuppressCWADSPropagation(true);
                try {
                    this.m_reg.recoverUnsubscribe(uevt);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            catch (EInvalidSubjectSyntax e) {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR250") + evt.getSubject() + ": " + e.getMessage(), (Throwable)e, 2);
            }
            catch (EOldVirtualClockException ovce) {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STR250") + evt.getSubject() + ": " + ovce.getMessage(), (Throwable)ovce, 2);
            }
            catch (EClientNotRegistered ovce) {
            }
            catch (ParseException e) {
                BrokerComponent.getComponentContext().logMessage("RecoveryMgr: couldn't process selector string to subject " + evt.getSubject() + ": " + e.getMessage(), (Throwable)e, 2);
            }
            catch (TokenMgrError e) {
                BrokerComponent.getComponentContext().logMessage("RecoveryMgr: couldn't process selector string to subject " + evt.getSubject() + ": " + e.getMessage(), (Throwable)e, 2);
            }
        }
    }

    public void redoSyncBegin() {
        this.m_eventProcessor.redoSyncBegin();
    }

    public void redoSyncEnd() {
        this.m_eventProcessor.redoSyncEnd();
    }

    public void redoSubscribe(SubscribeEvt evt) {
        this.m_eventProcessor.redoSubscribe(evt);
    }

    public void redoSyncDeleteMsgEvt(SyncDeleteMsgEvt evt) {
        long msgId;
        Enumeration msgIds = evt.getPubSubMsgIds();
        while (msgIds.hasMoreElements()) {
            msgId = (Long)msgIds.nextElement();
            Enumeration cIds = evt.getPubSubCIDs(msgId);
            while (cIds.hasMoreElements()) {
                long cid = (Long)cIds.nextElement();
                this.m_msgSaver.deleteMsg(cid, msgId, -1, false);
            }
        }
        msgIds = evt.getQueueMsgIds();
        while (msgIds.hasMoreElements()) {
            msgId = (Long)msgIds.nextElement();
            this.m_dbQMsgs.remove(msgId);
            this.m_queueMsgSaver.deleteMsg(msgId, false);
        }
        FastVector subjectAcks = evt.getSubjectAcks();
        if (subjectAcks != null) {
            for (int i = 0; i < subjectAcks.m_count; ++i) {
                SubjectDeleteTracker tracker = (SubjectDeleteTracker)subjectAcks.m_data[i];
                HashSet sids = tracker.getSubjectIds();
                if (sids == null) continue;
                long cid = tracker.getClientId();
                long mid = tracker.getMessageId();
                Iterator it = sids.iterator();
                while (it.hasNext()) {
                    this.m_msgSaver.deleteMsg(cid, mid, -1, false, true, (Short)it.next());
                }
            }
        }
    }

    public void redoUnsubscribe(UnsubscribeEvt evt) {
        try {
            this.m_reg.recoverUnsubscribe(evt);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (EClientNotRegistered eClientNotRegistered) {
        }
        catch (EOldVirtualClockException eOldVirtualClockException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoUnsubscribeAll(long id) {
        IClientContext cc = this.m_reg.lockContext(id);
        if (cc != null) {
            try {
                this.m_reg.recoverUnsubscribeAllInternal(cc);
            }
            finally {
                cc.unlock();
            }
        }
    }

    public void redoInDoubtQMsgReenqueue(byte[] trackingNums) {
        for (int i = 0; i < trackingNums.length; i += 8) {
            this.redoQueueMsgSend(ArrayUtil.readLong(trackingNums, i), 0L);
        }
    }

    public void redoQueueMsgSend(long trackingValue, long cid) {
        if (this.DEBUG) {
            this.debug("redoQueueMsgSend " + trackingValue + " inSync=" + this.m_inSync);
        }
        Long tracking = new Long(trackingValue);
        if (this.m_inSync) {
            this.m_metaState.m_qMsgSendIds.addElement(tracking);
            this.m_metaState.m_qMsgSends.addElement(new Long(cid));
        } else {
            RecoveredQMsg rqm = (RecoveredQMsg)this.m_metaState.m_recQMsgs.get(tracking);
            if (rqm != null) {
                rqm.setReceiverIDUnresolved(false);
                rqm.setNonTransacted();
                rqm.setReceiverId(cid);
            }
        }
    }

    public void redoSyncGroupMsgReallocationEvt(SyncGroupMsgAllocationEvt evt) {
        GroupXOnceMsgAllocationTracker tracker = new GroupXOnceMsgAllocationTracker(evt.getGroupId());
        this.m_metaState.m_groupAllocations.put(evt.getGroupId(), tracker);
        Collection allocations = evt.getAllocations();
        if (allocations != null && !allocations.isEmpty()) {
            for (GroupXOnceMsgAllocationTracker.GroupMsgAllocation gma : allocations) {
                tracker.addXOnceAllocation(gma);
            }
        }
    }

    public void redoGroupAllocation(GroupMsgAllocationEvt evt) {
        GroupXOnceMsgAllocationTracker tracker = (GroupXOnceMsgAllocationTracker)this.m_metaState.m_groupAllocations.get(evt.getGroupId());
        if (tracker == null) {
            tracker = new GroupXOnceMsgAllocationTracker(evt.getGroupId());
            this.m_metaState.m_groupAllocations.put(evt.getGroupId(), tracker);
        }
        tracker.addXOnceAllocation(evt.isReplicateOnly(), evt.getRecipientId(), evt.getMessageTracking(), evt.getRecipientTracking());
    }

    public void redoGroupDeallocation(GroupMsgDeallocationEvt evt) {
        GroupXOnceMsgAllocationTracker tracker = (GroupXOnceMsgAllocationTracker)this.m_metaState.m_groupAllocations.get(evt.getGroupId());
        if (tracker == null) {
            tracker = new GroupXOnceMsgAllocationTracker(evt.getGroupId());
            this.m_metaState.m_groupAllocations.put(evt.getGroupId(), tracker);
        }
        tracker.removeXOnceAllocation(evt.getMsgTracking());
    }

    public void redoQueueMsgMove(QueueMsgMoveEvt evt) {
        if (this.DEBUG) {
            this.debug("redoQueueMsgMove: " + evt.getSeqNo() + " inSync=" + this.m_inSync);
        }
        TreeMap map = this.m_inSync ? this.m_metaState.m_nonsyncQMsgs : this.m_metaState.m_recQMsgs;
        RecoveredQMsg rqm = new RecoveredQMsg(evt);
        this.checkDBState(rqm);
        RecoveryMgr.putTracking(map, rqm);
        if (this.m_inSync) {
            this.m_metaState.m_qAcks.addElement(new SyncQAck(rqm.getOldTracking(), false, this.m_replicating));
        } else {
            this.redoQueueMsgAcked(rqm.getOldTracking(), false, this.m_replicating);
        }
    }

    public void redoSyncQueueMsgMove(SyncQueueMsgMoveEvt evt) {
        if (this.m_inSync) {
            if (this.DEBUG) {
                this.debug("redoSyncQueueMsgMove: " + evt.getMessage().getGuarenteedTrackingNum() + " inSync=" + this.m_inSync);
            }
            TreeMap map = this.m_metaState.m_nonsyncQMsgs;
            RecoveredQMsg rqm = new RecoveredQMsg(evt);
            this.checkDBState(rqm);
            RecoveryMgr.putTracking(map, rqm);
            this.m_metaState.m_qAcks.addElement(new SyncQAck(rqm.getOldTracking(), false, this.m_replicating));
        }
    }

    private static void putTracking(TreeMap map, RecoveredQMsg rqm) {
        Long tracking = new Long(rqm.getTracking());
        if (!map.containsKey(tracking)) {
            map.put(tracking, rqm);
        }
    }

    public void redoQueueMsgMoveToTopic(QueueMsgMoveToTopicEvt evt) {
        if (this.DEBUG) {
            this.debug("redoQueueMsgMoveToTOpic: " + evt.getSeqNo() + " inSync=" + this.m_inSync);
        }
        IndexedList guars = this.m_inSync ? this.m_metaState.m_nonsyncGuars : this.m_metaState.m_guars;
        long tracking = evt.getSeqNo();
        GuarMsgEvt guarEvt = evt.getNewGuarEvt();
        this.appendNoDupTracking(guarEvt, guars, tracking);
        if (this.m_inSync) {
            this.m_metaState.m_qAcks.addElement(new SyncQAck(evt.getOldTracking(), false, this.m_replicating));
        } else {
            this.redoQueueMsgAcked(evt.getOldTracking(), false, this.m_replicating);
        }
    }

    public void redoSyncQueueMsgMoveToTopic(SyncQueueMsgMoveToTopicEvt evt) {
        if (this.m_inSync) {
            if (this.DEBUG) {
                this.debug("redoSyncQueueMsgMoveToTOpic: " + evt.getSeqNo() + " inSync=" + this.m_inSync);
            }
            IndexedList guars = this.m_metaState.m_nonsyncGuars;
            GuarMsgEvt guarEvt = evt.getNewGuarEvt();
            long tracking = guarEvt.getSeqNo();
            this.appendNoDupTracking(guarEvt, guars, tracking);
            this.m_metaState.m_qAcks.addElement(new SyncQAck(evt.getOldTracking(), false, this.m_replicating));
        }
    }

    private void appendNoDupTracking(GuarMsgEvt guarEvt, IndexedList guars, long tracking) {
        if (guars.get(tracking) == null) {
            guars.appendNoDup(tracking, new RecoveredGuarMsg(guarEvt, guarEvt.getDeliveredToPubSub(), guarEvt.needGuarAck(), this.m_inSync));
        }
    }

    public void redoGuarQAckDone(long trackingValue) {
        if (this.DEBUG) {
            this.debug("redoGuarQAckDone " + trackingValue + " inSync=" + this.m_inSync);
        }
        Long tracking = new Long(trackingValue);
        if (this.m_inSync) {
            this.m_metaState.m_GRGuarAcks.addElement(tracking);
        } else {
            RecoveredQMsg rqm = (RecoveredQMsg)this.m_metaState.m_recQMsgs.get(tracking);
            if (rqm != null) {
                rqm.setNeedGuarAck(false);
                rqm.setOrigSender(0L);
                rqm.setOrigTracking(0L);
                if (rqm.isDelivered()) {
                    this.m_dbQMsgs.cancelInfo(trackingValue);
                    this.m_metaState.m_recQMsgs.remove(tracking);
                }
            }
        }
    }

    public void beginSyncpoint() {
        this.m_inSync = true;
        this.m_backupMetaState = this.m_metaState;
        if (this.DEBUG1) {
            this.debug("beginSyncpoint: m_backupMetaState.m_guars.size= " + this.m_backupMetaState.m_guars.count() + "; m_backupMetaState.m_recQMsgs.size= " + this.m_backupMetaState.m_recQMsgs.size() + " m_inSync= " + this.m_inSync + " m_hasValidSync= " + this.m_hasValidSync);
        }
        this.m_metaState = new RecoveryMetaState();
    }

    public void endSyncpoint() {
        if (this.m_inSync) {
            this.m_inSync = false;
            this.m_hasValidSync = true;
            this.m_backupMetaState = null;
            if (this.DEBUG1) {
                this.debug("End Syncpoint: m_inSync= " + this.m_inSync + " m_hasValidSync= " + this.m_hasValidSync);
            }
            int ct = this.m_metaState.m_nonsyncGuars.count();
            this.m_metaState.restoreNonSyncGuars();
            if (this.DEBUG1) {
                this.debug("End Syncpoint: Applied m_nonsyncGuars count= " + ct + " m_metaState.m_guars.count()= " + this.m_metaState.m_guars.count());
            }
            this.m_metaState.m_nonsyncGuars = new IndexedList();
            this.m_metaState.m_deliveryLists = new HashMap();
            if (this.DEBUG1 && this.m_metaState.m_clientAcks.size() > 0) {
                this.debug("End Syncpoint: Applying m_clientAcks count= " + this.m_metaState.m_clientAcks.size());
            }
            this.m_metaState.restoreClientAcks();
            this.m_metaState.m_clientAcks = new Vector();
            this.m_metaState.restoreProxyDoubtResolved();
            this.m_metaState.m_nonsyncProxyDoubtResolvedEvts = new ArrayList();
            this.m_metaState.restoreDeliveries();
            this.m_metaState.m_deliveries = new Vector();
            if (this.DEBUG1 && this.m_metaState.m_IBGuarAcks.size() > 0) {
                this.debug("End Syncpoint: Applying m_IBGuarAcks count= " + this.m_metaState.m_IBGuarAcks.size());
            }
            this.m_metaState.restoreGuarAckDone();
            this.m_metaState.m_IBGuarAcks = new Vector();
            if (this.DEBUG) {
                this.debug("End Syncpoint: Applying queueMsgEvents;");
            }
            int count = this.m_metaState.restoreNonSyncQueueMsgs();
            this.m_metaState.m_nonsyncQMsgs = new TreeMap();
            if (this.DEBUG1) {
                this.debug("End Syncpoint: Applied NonSyncQueueMsgs count= " + count + " m_metaState.m_recQMsgs.size= " + this.m_metaState.m_recQMsgs.size());
            }
            if (this.DEBUG1) {
                this.debug("End Syncpoint: Applying queueMsgAcks; count= " + this.m_metaState.m_qAcks.size());
            }
            this.m_metaState.restoreQMsgAcked();
            this.m_metaState.m_qAcks = new Vector();
            if (this.DEBUG1) {
                this.debug("End Syncpoint: Applying GRGuarAcks; count= " + this.m_metaState.m_GRGuarAcks.size());
            }
            this.m_metaState.restoreGuarQAckDone();
            this.m_metaState.m_GRGuarAcks = new Vector();
            if (this.DEBUG1) {
                this.debug("End Syncpoint: Applying QMsgSend; count= " + this.m_metaState.m_qMsgSends.size());
            }
            this.m_metaState.restoreQMsgSends();
            this.m_metaState.m_qMsgSendIds = new Vector();
            this.m_metaState.m_qMsgSends = new Vector();
            if (this.DEBUG1) {
                this.debug("End Syncpoint: Applying temporary queue events; count= " + this.m_metaState.m_nonsyncTempQueueEvt.size());
            }
            this.m_metaState.restoreNonSyncTempQueues();
            this.m_metaState.m_nonsyncTempQueueEvt = new LinkedList();
            if (this.DEBUG1) {
                this.debug("endSyncpoint m_metaState.m_guars.size= " + this.m_metaState.m_guars.count() + "; m_metaState.m_recQMsgs.size= " + this.m_metaState.m_recQMsgs.size());
            }
        }
    }

    public void redoTxnBegin(TxnBeginEvt evt) {
        this.m_txnmgr.redoBeginTxn(evt);
    }

    public void redoTxnBegin(GlobalTxnBeginEvt evt) {
        this.m_txnmgr.redoBeginTxn(evt);
    }

    public void redoTxnCommit(TxnCommitEvt evt) {
        this.m_txnmgr.redoCommit(evt);
    }

    public void redoTxnPrecommit(TxnPrecommitEvt evt) {
        this.m_txnmgr.redoPrecommit(evt, this.m_replicating);
    }

    public void redoTxnPrepare(TxnPrepareEvt evt) {
        this.m_txnmgr.redoPrepare(evt, this.m_replicating);
    }

    public void redoTxnJoin(GlobalTxnJoinEvt evt) {
        this.m_txnmgr.redoJoin(evt);
    }

    public void redoTxnSuspend(GlobalTxnSuspendEvt evt) {
        this.m_txnmgr.redoSuspend(evt);
    }

    public void redoTxnResume(GlobalTxnResumeEvt evt) {
        this.m_txnmgr.redoResume(evt);
    }

    public void redoTxnEnd(GlobalTxnEndEvt evt) {
        this.m_txnmgr.redoEnd(evt);
    }

    public void redoSyncTxn(SyncTxnEvt evt) {
        if (this.m_inSync) {
            this.m_txnmgr.redoSync(evt, this.m_replicating);
        }
    }

    public void redoTxnAbort(TxnAbortEvt evt) {
        this.m_txnmgr.redoAbort(evt);
    }

    public void redoTxnAbortBegin(TxnAbortBeginEvt evt) {
        this.m_txnmgr.redoAbortBegin(evt);
    }

    public void redoNoDupCommitBeg(NoDupCommitBegEvt evt) {
        this.m_txnmgr.redoNoDupCommitBeg(evt);
    }

    public void redoReplyAck(ReplyAckEvt evt) {
        this.m_txnmgr.redoReplyAck(evt);
    }

    public void redoConnect(long id, ClientSecurityContext csc, boolean ib, long lastConnectedTime) {
        this.m_reg.redoConnect(id, csc, ib, lastConnectedTime);
    }

    public void redoConnect(long id, ClientSecurityContext csc, boolean ib) {
        this.m_reg.redoConnect(id, csc, ib);
    }

    public void redoDurableDisconnect(long id, long lastConnectedTime, boolean inDoubt) {
        this.m_reg.redoDurableDisconnect(id, lastConnectedTime, inDoubt);
    }

    public void redoDurableSMOUpdate(long id, long previousBrokerId, long restoringBrokerId) {
        this.m_reg.redoDurableSMOUpdate(id, previousBrokerId, restoringBrokerId);
    }

    public void redoProxyDoubtResolved(ProxyDoubtResolvedEvt evt) {
        if (this.DEBUG) {
            this.debug("RecoveryManager: redoing " + evt);
        }
        if (this.m_inSync) {
            this.m_metaState.m_nonsyncProxyDoubtResolvedEvts.add(evt);
        } else {
            try {
                long proxyId = evt.getId();
                IProxyHandle proxy = this.m_reg.getClient(proxyId).getProxyHandle();
                if (proxy != null) {
                    proxy.proxyDoubtResolved(true);
                }
                Iterator it = evt.getTrackingNums();
                while (it.hasNext()) {
                    long tracking = (Long)it.next();
                    RecoveredGuarMsg rgm = (RecoveredGuarMsg)this.m_metaState.m_guars.get(tracking);
                    if (rgm == null) continue;
                    rgm.getEvent().removeRecipient(proxyId, false);
                    rgm.getEvent().removeProxyRecips(proxyId);
                    if (!rgm.okToCleanup()) continue;
                    this.m_metaState.m_guars.remove(tracking);
                }
            }
            catch (EClientNotRegistered eClientNotRegistered) {
                // empty catch block
            }
        }
    }

    public void redoDurableStats(ArrayList stats) {
        this.m_eventProcessor.redoDurableStats(stats);
    }

    public void recoverDurableStats() {
        if (this.m_metaState.m_durableStats != null) {
            for (DurableStatsEvent.DurableStat stat : this.m_metaState.m_durableStats) {
                DurableCCTracker tracker = null;
                try {
                    tracker = AgentRegistrar.getAgentRegistrar().getClient(stat.m_clientId).getDurableCCTracker();
                }
                catch (EClientNotRegistered eClientNotRegistered) {
                    // empty catch block
                }
                if (tracker == null) continue;
                tracker.recover(stat.m_count, stat.m_size);
            }
        }
    }

    public void redoUnregister(long id) {
        this.m_reg.redoUnregister(id);
    }

    public void redoUnfiltered(long id, boolean unfiltered) {
        IClientContext cc = null;
        try {
            cc = this.m_reg.getClient(id);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
        if (cc != null) {
            this.m_reg.setUnfilteredStatus(cc, unfiltered, false);
        }
    }

    public void redoBatchSplit(BatchSplitEvt evt) {
        if (evt.isPubSub()) {
            IndexedList list = null;
            list = this.m_metaState.m_guars;
            RecoveredGuarMsg rgm = (RecoveredGuarMsg)list.get(evt.getTracking());
            if (rgm == null && this.m_inSync) {
                list = this.m_metaState.m_nonsyncGuars;
                rgm = (RecoveredGuarMsg)list.get(evt.getTracking());
            }
            if (rgm != null && !rgm.getEvent().splitBatch()) {
                rgm.getEvent().setSplitBatch(true);
                rgm.getEvent().getMessage().getBrokerHandle().setSenderID(rgm.getEvent().getOrigSender());
                this.splitPubSubBatch(rgm.getEvent(), list, false, rgm.isSyncEvent());
            }
        } else {
            TreeMap map = this.m_metaState.m_recQMsgs;
            Long tracker = new Long(evt.getTracking());
            RecoveredQMsg rqm = (RecoveredQMsg)map.get(tracker);
            if (rqm == null && this.m_inSync) {
                map = this.m_metaState.m_nonsyncQMsgs;
                rqm = (RecoveredQMsg)map.get(tracker);
            }
            if (rqm != null) {
                this.splitPtpBatch(rqm.getMessage(), map, rqm.getTracking(), rqm.getQueueName(), rqm.needGuarAck(), rqm.getOrigSender(), rqm.getOrigTracking(), rqm.isDelivered(), rqm.getReceiverId(), rqm.getOldTracking(), rqm.getTransactionId(), rqm.isTemporary());
                map.remove(tracker);
                if (map == this.m_metaState.m_recQMsgs && this.m_inSync) {
                    this.m_metaState.m_nonsyncQMsgs.remove(tracker);
                }
            }
        }
    }

    public void redoClientAck(ClientAckEvt evt) {
        if (this.m_inSync) {
            this.m_metaState.m_clientAcks.addElement(evt);
        } else {
            GroupXOnceMsgAllocationTracker tracker;
            TrackedSubjectFilter filter;
            LongHashTable sfTable;
            RecoveredGuarMsg rgm;
            long clientId = evt.getClientId();
            long tracking = evt.getTracking();
            boolean isProxyAck = evt.isProxy();
            if (this.DEBUG) {
                this.debug("Redoing ClientAckEvt: client: " + clientId + " tracking=" + tracking);
            }
            if ((rgm = (RecoveredGuarMsg)this.m_metaState.m_guars.get(tracking)) != null) {
                rgm.setNonTransacted();
            }
            if (evt.hasDelete()) {
                if (rgm != null) {
                    IMgram msg = rgm.getEvent().getMessage();
                    if (msg.getType() == 27) {
                        IMgram subMgram = null;
                        Iterator it = msg.getBatchHandle().getBatchIterator();
                        while (it.hasNext()) {
                            subMgram = (IMgram)it.next();
                            long mgramTracking = subMgram.getGuarenteedTrackingNum();
                            this.deleteMsgFromDb(clientId, evt, mgramTracking);
                        }
                    } else {
                        this.deleteMsgFromDb(clientId, evt, tracking);
                    }
                } else {
                    this.deleteMsgFromDb(clientId, evt, tracking);
                }
                if (rgm != null && rgm.getEvent().hasProxyMappings() && isProxyAck) {
                    FastVector proxying = (FastVector)rgm.getEvent().getProxyRecipsTable().get(clientId);
                    for (int i = 0; i < proxying.m_count; ++i) {
                        long proxyCid = (Long)proxying.m_data[i];
                        if (this.m_pubSubDeleteTracker == null) {
                            this.m_msgSaver.deleteMsg(proxyCid, tracking, -1, false);
                            continue;
                        }
                        this.m_pubSubDeleteTracker.msgDelete(proxyCid, tracking, evt.hasSubjectTracking(), evt.getSubjectTracking(), true);
                    }
                }
            }
            if (evt.hasSubjectTracking() && rgm != null && (sfTable = rgm.getEvent().getSubjectFilters()) != null && (filter = (TrackedSubjectFilter)sfTable.get(clientId)) != null) {
                filter.removeTrackingNum(null, evt.getSubjectTracking());
                if (filter.filterSize() > 0) {
                    return;
                }
            }
            if ((tracker = (GroupXOnceMsgAllocationTracker)this.m_metaState.m_groupAllocations.get(clientId)) != null) {
                tracker.removeXOnceAllocation(tracking);
            }
            if (rgm != null) {
                if (!rgm.isDeliveredToPubSub()) {
                    rgm.getEvent().removeRecipient(clientId, false);
                }
                if (rgm.getEvent().hasProxyMappings()) {
                    rgm.getEvent().removeProxyRecips(clientId);
                }
                rgm.getEvent().removeProxyLBSRecips(clientId);
                if (rgm.okToCleanup()) {
                    this.m_metaState.m_guars.remove(tracking);
                }
            }
        }
    }

    private void deleteMsgFromDb(long clientId, ClientAckEvt evt, long tracking) {
        if (this.m_pubSubDeleteTracker == null) {
            this.m_msgSaver.deleteMsg(clientId, tracking, -1, false, evt.hasSubjectTracking(), evt.getSubjectTracking());
        } else {
            this.m_pubSubDeleteTracker.msgDelete(clientId, tracking, evt.hasSubjectTracking(), evt.getSubjectTracking(), true);
        }
    }

    long getLastConnectionId() {
        return this.m_lastConnectionId;
    }

    public void redoConnectionId(long id) {
        if (this.DEBUG) {
            this.debug("reading last connection id from log: " + id);
        }
        if (id > this.m_lastConnectionId) {
            this.m_lastConnectionId = id;
        }
    }

    public void redoCounter(short category, long id) {
        this.m_reg.redoCounter(category, id);
    }

    private void setDeliveryInfo(DeliveryListEvt evt, RecoveredGuarMsg rgm, boolean cloneProxyRecipsTable) {
        rgm.getEvent().setDeliveryInfo((RecipientVector)evt.getGuarRecipients(), (RecipientVector)evt.getPtpRecipients(), evt.getPtpTrackingNums(), evt.getGuarRecipients() != null, evt.getProxyRecipsTable(), cloneProxyRecipsTable, evt.getSubjectFilters(), evt.getProxyLBSRecips());
        this.populateNonTransacted(rgm);
        rgm.processDeliveryInfo();
    }

    public void redoDeliveryList(DeliveryListEvt evt) {
        RecoveredGuarMsg rgm;
        if (this.DEBUG) {
            this.debug("Redoing DeliveryListEvt, tracking=" + evt.getTracking());
        }
        if ((rgm = (RecoveredGuarMsg)this.m_metaState.m_guars.get(evt.getTracking())) == null) {
            rgm = (RecoveredGuarMsg)this.m_metaState.m_nonsyncGuars.get(evt.getTracking());
        }
        if (rgm != null) {
            if (rgm.isTransacted() || rgm.getEvent().splitBatch() || rgm.getEvent().getMessage().getBrokerHandle().isBatchedPublish()) {
                int tid = -1;
                if (rgm.isTransacted()) {
                    tid = rgm.getEvent().getTransactionId();
                }
                if (rgm.getEvent().splitBatch()) {
                    IMgram batchMgram = rgm.getEvent().getMessage();
                    int batchSize = batchMgram.getBatchHandle().getBatchSize();
                    long subTracking = evt.getTracking() + 1L;
                    RecoveredGuarMsg subRgm = null;
                    for (int ii = 0; ii < batchSize; ++ii) {
                        subRgm = (RecoveredGuarMsg)this.m_metaState.m_guars.get(subTracking);
                        if (subRgm == null) {
                            subRgm = (RecoveredGuarMsg)this.m_metaState.m_nonsyncGuars.get(subTracking);
                        }
                        if (subRgm != null && subRgm.getEvent().getGuarRecipients() == null) {
                            this.setDeliveryInfo(evt, subRgm, true);
                        }
                        ++subTracking;
                    }
                } else if (!rgm.isDeliveredToPubSub()) {
                    this.setDeliveryInfo(evt, rgm, this.m_replicating);
                }
                int numGuars = 0;
                if (rgm.getEvent().getGuarRecipients() != null) {
                    numGuars = rgm.getEvent().getGuarRecipients().m_count;
                }
                if (this.DEBUG) {
                    this.debug("Redoing DeliveryListEvt, tracking=" + evt.getTracking() + " tid= " + tid + " added Delivery info to GuarMsgEvt; guarRecips= " + numGuars);
                }
            }
        } else if (this.m_inSync) {
            this.m_metaState.m_deliveryLists.put(new Long(evt.getTracking()), evt);
        }
    }

    public void redoDBQMsgUpdateEvt(Long tracking, short status) {
        RecoveredQMsg msg = (RecoveredQMsg)this.m_metaState.m_recQMsgs.get(tracking);
        if (msg != null) {
            if (this.DEBUG) {
                this.debug("Updating: " + tracking + " Status: " + status);
            }
            msg.executeHandler(status);
        }
    }

    public void redoMsgSave(long tracking, long recipientId) {
        RecoveredGuarMsg msg = this.handleDuplicateSave(tracking);
        if (msg != null) {
            IBrokerHandle bh = msg.getEvent().getMessage().getBrokerHandle();
            bh.setDBSaved(true);
            bh.addMsgHeaderSaved(recipientId);
        }
    }

    public void redoMsgSave(long tracking, long[] recipientIds) {
        RecoveredGuarMsg msg = this.handleDuplicateSave(tracking);
        if (msg != null) {
            IBrokerHandle bh = msg.getEvent().getMessage().getBrokerHandle();
            bh.setDBSaved(true);
            bh.addMsgHeadersSaved(recipientIds);
        }
    }

    private RecoveredGuarMsg handleDuplicateSave(long tracking) {
        RecoveredGuarMsg msg = (RecoveredGuarMsg)this.m_metaState.m_guars.get(tracking);
        if (msg == null && this.m_backupMetaState != null && this.m_backupMetaState != null) {
            msg = (RecoveredGuarMsg)this.m_backupMetaState.m_guars.get(tracking);
        }
        return msg;
    }

    public void redoQueueMsgGroupAssign(String queueName, String groupName, long receiverId) {
        IClientContext cc = this.retrieveClientContext(receiverId);
        if (cc != null && cc.isXOnce()) {
            IAgentQueue iaq;
            if (this.checkDebugFlags(16384)) {
                this.debug("processing queue message group assignment, queue = " + queueName + ", group = " + groupName + ", receiver = " + receiverId);
            }
            if ((iaq = this.m_reg.getQueueProc().getAgentQueue(queueName)) != null && iaq.getMessageGroupHandle() != null) {
                iaq.getMessageGroupHandle().redoQueueMessageGroupAssign(receiverId, groupName);
            }
        } else if (this.checkDebugFlags(16384)) {
            this.debug("skipping queue message group assignment, queue = " + queueName + ", group = " + groupName + ", receiver = " + receiverId + (cc == null ? ", receiver not found" : ", non-FT receiver"));
        }
    }

    public void redoQueueMsgGroupUnassign(String queueName, List<String> groupNames) {
        IAgentQueue iaq;
        if (this.checkDebugFlags(16384)) {
            this.debug("processing queue message group unassign, queue = " + queueName + ", groups = " + groupNames);
        }
        if ((iaq = this.m_reg.getQueueProc().getAgentQueue(queueName)) != null && iaq.getMessageGroupHandle() != null) {
            iaq.getMessageGroupHandle().redoQueueMessageGroupUnassign(groupNames);
        }
    }

    public void redoSyncQueueMsgGroups(String queueName, long receiverId, List<String> groupNames) {
        IClientContext cc = this.retrieveClientContext(receiverId);
        if (cc != null && cc.isXOnce()) {
            IAgentQueue iaq;
            if (this.checkDebugFlags(16384)) {
                this.debug("processing queue message group sync, queue = " + queueName + ", receiver = " + receiverId);
            }
            if ((iaq = this.m_reg.getQueueProc().getAgentQueue(queueName)) != null && iaq.getMessageGroupHandle() != null) {
                iaq.getMessageGroupHandle().redoSyncQueueMessageGroups(receiverId, groupNames);
            }
        } else if (this.checkDebugFlags(16384)) {
            this.debug("skipping queue message group assignment, queue = " + queueName + ", receiver = " + receiverId + (cc == null ? ", receiver not found" : ", non-FT receiver"));
        }
    }

    private IClientContext retrieveClientContext(long receiverId) {
        IClientContext cc = null;
        try {
            cc = this.m_reg.getClient(receiverId);
        }
        catch (EClientNotRegistered eClientNotRegistered) {
            // empty catch block
        }
        return cc;
    }

    void checkDBState(RecoveredQMsg rqm) {
        boolean dontKnow;
        short status = this.m_dbQMsgs.status(rqm.getTracking(), true);
        boolean inDb = status == 0;
        boolean bl = dontKnow = status == 2;
        if (rqm.isDelivered()) {
            rqm.setMessage(null);
            rqm.setReceiverId(0L);
            if (inDb) {
                rqm.delete();
            } else if (dontKnow) {
                rqm.setDeleteHandler((short)0);
            }
        } else if (inDb) {
            rqm.setMessage(null);
        } else if (dontKnow) {
            rqm.setNullMsgHandler((short)0);
            rqm.setDeliveredUnresolved(true);
            rqm.setMsgDeliveredIfMsgNullHandler((short)1);
        } else {
            rqm.msgDeliveredIfMsgNull();
        }
    }

    public void clearMetaState() {
        this.m_metaState = null;
        this.m_backupMetaState = null;
    }

    private void finishQMessageRecovery() throws InterruptedException, EDatabaseException {
        boolean loadFromDBRequired;
        Set tqdSet;
        HashMap tqdMap;
        Long cid;
        Enumeration<Long> enu;
        if (this.DEBUG1) {
            this.debug("finishQueueMessageRecovery: Starting");
        }
        if (this.DEBUG && this.m_metaState.m_tempQueues.size() > 0) {
            this.debug("Current Temporary Queues ");
            enu = this.m_metaState.m_tempQueues.keys();
            while (enu.hasMoreElements()) {
                cid = enu.nextElement();
                this.debug("Cid: " + cid);
                tqdMap = (HashMap)this.m_metaState.m_tempQueues.get(cid);
                tqdSet = tqdMap.keySet();
                Iterator nameIter = tqdSet.iterator();
                while (nameIter.hasNext()) {
                    this.debug("\t" + nameIter.next());
                }
            }
        }
        if (this.CALLBACK && this.m_metaState.m_tempQueues.size() > 0) {
            enu = this.m_metaState.m_tempQueues.keys();
            while (enu.hasMoreElements()) {
                cid = enu.nextElement();
                tqdMap = (HashMap)this.m_metaState.m_tempQueues.get(cid);
                tqdSet = tqdMap.keySet();
                for (String name : tqdSet) {
                    this.callback(name, 0, name);
                }
            }
        }
        AgentQueueProcessor qproc = AgentRegistrar.getAgentRegistrar().getQueueProc();
        HashMap<String, String> tempQueues = new HashMap<String, String>();
        if (Config.XONCE_RECOVERY && this.m_metaState.m_tempQueues.size() > 0) {
            Enumeration<Long> enu2 = this.m_metaState.m_tempQueues.keys();
            while (enu2.hasMoreElements()) {
                long cid2 = enu2.nextElement();
                try {
                    IClientContext cc = this.m_reg.getClient(cid2);
                    if (cc.getState() == 0) continue;
                    HashMap tqdMap2 = (HashMap)this.m_metaState.m_tempQueues.get(cid2);
                    Collection data = tqdMap2.values();
                    for (TempQueueData tqd : data) {
                        qproc.addTemporaryQueue(cid2, tqd.getQueueName(), true, tqd.isGlobal(), tqd.getMaxSize());
                        tempQueues.put(tqd.getQueueName(), tqd.getQueueName());
                    }
                }
                catch (EClientNotRegistered cc) {
                }
            }
            if (this.DEBUG1) {
                this.debug("tempQueues.size()= " + tempQueues.size());
            }
        }
        this.m_metaState.m_tempQueues = null;
        int countAdded = 0;
        long totCount = 0L;
        int countRecoveredFromDb = 0;
        int countRecoveredInfoFromDb = 0;
        int countDbMsgs = this.m_dbQMsgs.size();
        int ctRecovered = this.m_metaState.m_recQMsgs.size();
        boolean bl = loadFromDBRequired = !this.m_recoveredQueues.isLoadable();
        if (this.DEBUG1) {
            this.debug("Queues loadable from metastate = " + !loadFromDBRequired);
        }
        if (!loadFromDBRequired) {
            Iterator it = this.m_dbQMsgs.getAllIds();
            while (it.hasNext()) {
                IDbQMsgData qmsgdat;
                Long id = (Long)it.next();
                long lid = id;
                RecoveredQMsg rqm = (RecoveredQMsg)this.m_metaState.m_recQMsgs.get(id);
                if (rqm == null) {
                    qmsgdat = this.m_db.getIPtpDBQ().getQueueMsgData(lid);
                    if (qmsgdat == null) continue;
                    rqm = new RecoveredQMsg(lid, qmsgdat.getQueueName(), null, false, 0L, 0L, false, 0L, 0L, 0, false, (byte)qmsgdat.getPriority());
                    rqm.setEnqueuedSize(qmsgdat.getMessageSize());
                    rqm.setExpiration(qmsgdat.getExpiration());
                    this.m_metaState.m_recQMsgs.put(new Long(lid), rqm);
                    if (this.DEBUG) {
                        this.debug("finishQMessageRecovery; recovered from Db " + lid);
                    }
                    ++countRecoveredFromDb;
                    continue;
                }
                if (rqm.isDelivered() || rqm.getEnqueuedSize() != 0L) continue;
                qmsgdat = this.m_db.getIPtpDBQ().getQueueMsgData(lid);
                rqm.setEnqueuedSize(qmsgdat.getMessageSize());
                rqm.setExpiration(qmsgdat.getExpiration());
                rqm.setPriority((byte)qmsgdat.getPriority());
                if (this.DEBUG) {
                    this.debug("finishQMessageRecovery; recovered queue msg data from Db " + lid);
                }
                ++countRecoveredInfoFromDb;
            }
        }
        this.m_dbQMsgs.resetDbQMsgs();
        this.m_dbQMsgs = null;
        Iterator iter = this.m_metaState.m_recQMsgs.values().iterator();
        while (iter.hasNext()) {
            ++totCount;
            RecoveredQMsg rqm = (RecoveredQMsg)iter.next();
            if (rqm.isDelivered()) {
                RecoveryMgr.resetUnusedValues(rqm);
            }
            if (!rqm.isTransacted() && !rqm.needGuarAck()) {
                rqm.setOrigSender(0L);
                rqm.setOrigTracking(0L);
            }
            IMgram m = rqm.getMessage();
            if (!(rqm.isDelivered() || m == null || rqm.isTransacted() || rqm.isTemporary())) {
                this.m_queueMsgSaver.saveMsg(rqm.getQueueName(), m);
                rqm.markSaveRequested();
                if (this.DEBUG) {
                    this.debug("Saving Message for queue " + rqm.getQueueName());
                }
                ++countAdded;
            }
            if (!(rqm.isDelivered() || rqm.isTransacted() || rqm.isTemporary() || loadFromDBRequired)) {
                this.m_recoveredQueues.addQueueMsg(rqm);
                if (this.DEBUG && rqm.getEnqueuedSize() == 0L) {
                    this.debug("RecoveredQueueMessage " + rqm.getTracking() + " with enqueuedSize= 0; queue= " + rqm.getQueueName());
                }
                if (!this.DEBUG) continue;
                this.debug("Recovered " + rqm.getTracking() + " to " + rqm.getQueueName());
                continue;
            }
            if (!this.DEBUG) continue;
            this.debug("RecoveryMgr.finishRecovery: not added to RecoveredQueues " + rqm.getTracking() + " transacted= " + rqm.isTransacted() + " delivered " + rqm.isDelivered() + " isTemp= " + rqm.isTemporary());
        }
        try {
            this.m_queueMsgSaver.flush();
        }
        catch (InterruptedException e) {
            throw new EAssertFailure(e.getMessage());
        }
        if (this.DEBUG1) {
            this.debug("finishQMessageRecovery: count recovered queue messages from log: " + ctRecovered);
            this.debug("finishQMessageRecovery: messages in DB: " + countDbMsgs);
            this.debug("finishQMessageRecovery: count recovered queue messages from db: " + countRecoveredFromDb);
            this.debug("finishQMessageRecovery: count recovered queue message info from db: " + countRecoveredInfoFromDb);
            this.debug("finishQMessageRecovery: total recovered queue messages: " + totCount);
            this.debug("finishQMessageRecovery: saved " + countAdded + " additional messages into db");
        }
    }

    private static void resetUnusedValues(RecoveredQMsg rqm) {
        rqm.setMessage(null);
        rqm.setReceiverId(0L);
        rqm.setNonTransacted();
    }

    private void resolveQMessageTxState() {
        if (this.DEBUG1) {
            this.debug("resolveQMessageTxState: Starting");
        }
        Vector<Long> idsToUndo = new Vector<Long>();
        Iterator iter = ((TreeMap)this.m_metaState.m_recQMsgs.clone()).values().iterator();
        int committed = 0;
        int pending = 0;
        int undo = 0;
        int totCount = 0;
        int numTransacted = 0;
        int notFound = 0;
        while (iter.hasNext()) {
            ++totCount;
            RecoveredQMsg rqm = (RecoveredQMsg)iter.next();
            if (rqm.isDelivered() || !rqm.isTransacted()) continue;
            ++numTransacted;
            IMgram msg = rqm.getMessage();
            if (msg == null) {
                rqm.setNonTransacted();
                continue;
            }
            int txCheck = this.m_txnmgr.resolveRecoveredMsg(rqm.getTransactionId(), rqm.getMessage());
            if (txCheck == 1 || txCheck == 4) {
                if (this.DEBUG) {
                    this.debug("Committed msg; tid= " + rqm.getTransactionId() + " trk= " + rqm.getTracking());
                }
                this.commitAndSplitBatch(rqm);
                ++committed;
                continue;
            }
            if (txCheck == 5) {
                this.commitAndSplitBatch(rqm);
                ++notFound;
                continue;
            }
            if (txCheck == 3) {
                if (this.DEBUG) {
                    this.debug("To be completed; tid= " + rqm.getTransactionId() + " trk= " + rqm.getTracking());
                }
                ++pending;
                continue;
            }
            if (txCheck != 2) continue;
            if (this.DEBUG) {
                this.debug("To be undone; tid= " + rqm.getTransactionId() + " trk= " + rqm.getTracking());
            }
            idsToUndo.addElement(new Long(rqm.getTracking()));
            ++undo;
        }
        Enumeration enu = idsToUndo.elements();
        while (enu.hasMoreElements()) {
            Long tracking = (Long)enu.nextElement();
            RecoveredQMsg rqm = (RecoveredQMsg)this.m_metaState.m_recQMsgs.get(tracking);
            if (rqm == null) continue;
            rqm.setNonTransacted();
            this.redoQueueMsgAcked(tracking, true, false);
        }
        if (this.DEBUG1) {
            this.debug("resolveQMessageTxState: total recovered queue messages: " + totCount);
            this.debug("resolveQMessageTxState: numTransacted: " + numTransacted);
            this.debug("resolveQMessageTxState: pending: " + pending);
            this.debug("resolveQMessageTxState: committed: " + committed);
            this.debug("resolveQMessageTxState: undone: " + undo);
            this.debug("resolveQMessageTxState: notFound: " + notFound);
            this.debug("resolveQMessageTxState: num recQMsgs remaining: " + this.m_metaState.m_recQMsgs.size());
        }
    }

    private void commitAndSplitBatch(RecoveredQMsg rqm) {
        rqm.setNonTransacted();
        if (rqm.getMessage().getType() == 27) {
            this.splitPtpBatch(rqm.getMessage(), this.m_metaState.m_recQMsgs, rqm.getTracking(), rqm.getQueueName(), rqm.needGuarAck(), rqm.getOrigSender(), rqm.getOrigTracking(), rqm.isDelivered(), rqm.getReceiverId(), rqm.getOldTracking(), rqm.getTransactionId(), rqm.isTemporary());
            this.m_metaState.m_recQMsgs.remove(new Long(rqm.getTracking()));
        }
    }

    private void resolvePubSubTxState() {
        if (this.DEBUG1) {
            this.debug("resolvePubSubTxState: Starting");
        }
        Vector<Long> idsToDelete = new Vector<Long>();
        Enumeration<Object> enu = this.m_metaState.m_guars.elements();
        int committed = 0;
        int pending = 0;
        int undo = 0;
        int totCount = 0;
        int notFound = 0;
        int numTransacted = 0;
        while (enu.hasMoreElements()) {
            ++totCount;
            RecoveredGuarMsg rgm = (RecoveredGuarMsg)enu.nextElement();
            GuarMsgEvt evt = rgm.getEvent();
            if (evt.splitBatch() || !rgm.isTransacted()) continue;
            if (rgm.isDeliveredToPubSub()) {
                rgm.setNonTransacted();
                continue;
            }
            ++numTransacted;
            IMgram msg = evt.getMessage();
            int txCheck = this.m_txnmgr.resolveRecoveredMsg(rgm.getTransactionId(), msg);
            if (txCheck == 1) {
                BrokerComponent.getComponentContext().logMessage("Recovered pub/sub committed msg: tid= " + rgm.getTransactionId() + " trk= " + rgm.getEventSeqNo(), 3);
                if (this.DEBUG) {
                    this.debug("Committed msg; tid= " + rgm.getTransactionId() + " trk= " + rgm.getEventSeqNo());
                }
                rgm.setNonTransacted();
                ++committed;
                continue;
            }
            if (txCheck == 3 || txCheck == 4) {
                if (this.DEBUG) {
                    this.debug("To be completed; tid= " + rgm.getTransactionId() + " trk= " + rgm.getEventSeqNo());
                }
                ++pending;
                continue;
            }
            if (txCheck == 2) {
                if (this.DEBUG) {
                    this.debug("To be undone; tid= " + rgm.getTransactionId() + " trk= " + rgm.getEventSeqNo());
                }
                idsToDelete.addElement(new Long(evt.getSeqNo()));
                ++undo;
                continue;
            }
            if (txCheck != 5) continue;
            BrokerComponent.getComponentContext().logMessage("Recovered pub/sub transacted msg; txn not found; tid= " + rgm.getTransactionId() + " trk= " + rgm.getEventSeqNo(), 2);
            if (this.DEBUG) {
                this.debug("Not found; tid= " + rgm.getTransactionId() + " trk= " + rgm.getEventSeqNo());
            }
            rgm.setNonTransacted();
            ++notFound;
        }
        enu = idsToDelete.elements();
        while (enu.hasMoreElements()) {
            long tracking = (Long)enu.nextElement();
            RecoveredGuarMsg rgm = (RecoveredGuarMsg)this.m_metaState.m_guars.get(tracking);
            if (rgm == null) continue;
            rgm.setNonTransacted();
            this.redoMsgDelivered(tracking);
        }
        if (this.DEBUG1) {
            this.debug("resolvePubSubTxState: total recovered pubsub messages: " + totCount);
            this.debug("resolvePubSubTxState: numTransacted: " + numTransacted);
            this.debug("resolvePubSubTxState: pending: " + pending);
            this.debug("resolvePubSubTxState: committed: " + committed);
            this.debug("resolvePubSubTxState: undone: " + undo);
            this.debug("resolvePubSubTxState: notFound: " + notFound);
            this.debug("resolvePubSubTxState: num Guars remaining: " + this.m_metaState.m_guars.count());
        }
    }

    private void appendNoDupOrReplace(RecoveredGuarMsg newRgm, IndexedList list) {
        if (newRgm.getEvent().isBatchedPublish() && newRgm.getEvent().getGuarRecipients() != null) {
            RecoveredGuarMsg oldRgm = (RecoveredGuarMsg)list.get(newRgm.getEvent().getSeqNo());
            if (oldRgm != null) {
                if (oldRgm.getEvent().getGuarRecipients() == null) {
                    GuarMsgEvt evt = newRgm.getEvent();
                    oldRgm.getEvent().setDeliveryInfo((RecipientVector)evt.getGuarRecipients(), (RecipientVector)evt.getPtpRecipients(), evt.getPtpTrackingNums(), evt.getGuarRecipients() != null, evt.getProxyRecipsTable(), false, evt.getSubjectFilters(), evt.getProxyLBSRecipsTable());
                    this.populateNonTransacted(oldRgm);
                }
            } else {
                list.appendNoDup(newRgm.getEvent().getSeqNo(), newRgm);
            }
        } else {
            list.appendNoDup(newRgm.getEvent().getSeqNo(), newRgm);
        }
    }

    private void populateNonTransacted(RecoveredGuarMsg rgm) {
        if (rgm.isTransacted()) {
            rgm.getEvent().setNonTransacted();
        }
    }

    void deleteQMsg(long tracking) {
        this.m_queueMsgSaver.deleteMsg(tracking, false);
        this.m_dbQMsgs.remove(tracking);
    }

    private class RecoveryMetaState {
        IndexedList m_guars = new IndexedList();
        Vector m_postponedGuars;
        IndexedList m_nonsyncGuars;
        ArrayList m_nonsyncProxyDoubtResolvedEvts;
        Vector m_clientAcks;
        Vector m_deliveries;
        Vector m_IBGuarAcks;
        HashMap m_deliveryLists = new HashMap();
        TreeMap m_recQMsgs = new TreeMap();
        TreeMap m_nonsyncQMsgs;
        RecoveredQueueSet m_recoveredQueues;
        Vector m_qAcks;
        Vector m_GRGuarAcks;
        Vector m_qMsgSendIds;
        Vector m_qMsgSends;
        ArrayList m_durableStats = null;
        LongHashTable m_tempQueues = new LongHashTable();
        LinkedList m_nonsyncTempQueueEvt;
        LongHashTable m_groupAllocations;

        RecoveryMetaState() {
            this.m_nonsyncGuars = new IndexedList();
            this.m_deliveries = new Vector();
            this.m_IBGuarAcks = new Vector();
            this.m_clientAcks = new Vector();
            this.m_qAcks = new Vector();
            this.m_nonsyncQMsgs = new TreeMap();
            this.m_nonsyncProxyDoubtResolvedEvts = new ArrayList();
            this.m_GRGuarAcks = new Vector();
            this.m_qMsgSendIds = new Vector();
            this.m_qMsgSends = new Vector();
            this.m_nonsyncTempQueueEvt = new LinkedList();
            this.m_groupAllocations = new LongHashTable();
        }

        public void performPartialSyncpoint(RecoveryMetaState backupMetaState) {
            if (backupMetaState != null) {
                ((RecoveryMgr)RecoveryMgr.this).m_metaState.m_guars = backupMetaState.m_guars;
                this.restoreNonSyncGuars();
                this.restoreClientAcks();
                this.restoreProxyDoubtResolved();
                this.restoreDeliveries();
                this.restoreGuarAckDone();
                ((RecoveryMgr)RecoveryMgr.this).m_metaState.m_recQMsgs = backupMetaState.m_recQMsgs;
                ((RecoveryMgr)RecoveryMgr.this).m_metaState.m_tempQueues = backupMetaState.m_tempQueues;
                this.restoreNonSyncQueueMsgs();
                this.restoreQMsgAcked();
                this.restoreGuarQAckDone();
                this.restoreQMsgSends();
                this.restoreNonSyncTempQueues();
            }
        }

        public void restoreNonSyncGuars() {
            Enumeration enu = this.m_nonsyncGuars.elements();
            while (enu.hasMoreElements()) {
                RecoveredGuarMsg rgm = (RecoveredGuarMsg)enu.nextElement();
                if (rgm.getEvent().splitBatch()) continue;
                RecoveryMgr.this.appendNoDupOrReplace(rgm, this.m_guars);
            }
        }

        public void restoreClientAcks() {
            for (int i = this.m_clientAcks.size() - 1; i >= 0; --i) {
                RecoveryMgr.this.redoClientAck((ClientAckEvt)this.m_clientAcks.elementAt(i));
            }
        }

        public void restoreProxyDoubtResolved() {
            for (int i = 0; i < this.m_nonsyncProxyDoubtResolvedEvts.size(); ++i) {
                RecoveryMgr.this.redoProxyDoubtResolved((ProxyDoubtResolvedEvt)this.m_nonsyncProxyDoubtResolvedEvts.get(i));
            }
        }

        public void restoreDeliveries() {
            for (int i = this.m_deliveries.size() - 1; i >= 0; --i) {
                RecoveryMgr.this.redoMsgDelivered((Long)this.m_deliveries.elementAt(i));
            }
        }

        public void restoreGuarAckDone() {
            for (int i = this.m_IBGuarAcks.size() - 1; i >= 0; --i) {
                RecoveryMgr.this.redoGuarAckDone((Long)this.m_IBGuarAcks.elementAt(i));
            }
        }

        public int restoreNonSyncQueueMsgs() {
            Iterator iter = this.m_nonsyncQMsgs.values().iterator();
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                RecoveredQMsg rqm = (RecoveredQMsg)iter.next();
                Long tracking = new Long(rqm.getTracking());
                if (this.m_recQMsgs.containsKey(tracking)) continue;
                this.m_recQMsgs.put(tracking, rqm);
            }
            return count;
        }

        public void restoreQMsgAcked() {
            for (int i = this.m_qAcks.size() - 1; i >= 0; --i) {
                SyncQAck ack = (SyncQAck)this.m_qAcks.elementAt(i);
                RecoveryMgr.this.redoQueueMsgAcked(ack.m_tracking, ack.m_hasDelete, ack.m_forceDelete);
            }
        }

        public void restoreGuarQAckDone() {
            for (int i = this.m_GRGuarAcks.size() - 1; i >= 0; --i) {
                RecoveryMgr.this.redoGuarQAckDone((Long)this.m_GRGuarAcks.elementAt(i));
            }
        }

        public void restoreQMsgSends() {
            for (int i = this.m_qMsgSends.size() - 1; i >= 0; --i) {
                RecoveryMgr.this.redoQueueMsgSend((Long)this.m_qMsgSendIds.elementAt(i), (Long)this.m_qMsgSends.elementAt(i));
            }
        }

        public void restoreNonSyncTempQueues() {
            for (LogEvent evt : this.m_nonsyncTempQueueEvt) {
                evt.redo(RecoveryMgr.this);
            }
        }
    }

    class RecoveredGuarMsg {
        private GuarMsgEvt m_evt;
        private boolean m_deliveredToPubSub;
        private boolean m_needGuarAck;
        private boolean m_syncEvent;

        RecoveredGuarMsg(GuarMsgEvt evt, boolean deliveredToPubSub, boolean needGuarAck, boolean syncEvent) {
            if (RecoveryMgr.this.m_replicating && !evt.isFlushed()) {
                this.m_evt = evt.rgmClone();
                evt.getMessage().getBrokerHandle().setLogEvent(this.m_evt);
            } else {
                this.m_evt = evt;
            }
            this.m_deliveredToPubSub = deliveredToPubSub;
            this.m_needGuarAck = needGuarAck;
            this.m_syncEvent = syncEvent;
            if (evt.getMessage() != null && evt.getMessage().getType() != 27) {
                evt.getMessage().getBrokerHandle().setBatchedPublish(evt.isBatchedPublish());
            }
            if (deliveredToPubSub) {
                this.setNonTransacted();
            }
            if (!evt.isTransacted() && !evt.splitBatch()) {
                this.processDeliveryInfo();
            }
        }

        GuarMsgEvt getEvent() {
            return this.m_evt;
        }

        long getEventSeqNo() {
            return this.m_evt.getSeqNo();
        }

        boolean isSyncEvent() {
            return this.m_syncEvent;
        }

        boolean isDeliveredToPubSub() {
            return this.m_deliveredToPubSub;
        }

        boolean needGuarAck() {
            return this.m_needGuarAck;
        }

        void setDeliveredToPubSub(boolean deliveredToPubSub) {
            this.m_deliveredToPubSub = deliveredToPubSub;
        }

        private final boolean okToCleanup() {
            return this.m_deliveredToPubSub && !this.m_needGuarAck && !this.m_evt.hasProxyMappings();
        }

        void setGuarAck(boolean needGuarAck) {
            this.m_needGuarAck = needGuarAck;
            this.m_evt.setGuarAck(false);
            this.m_evt.setIBGuarAck(false);
            this.m_evt.setRBGuarAck(false);
        }

        void setTransacted(int tid) {
            this.m_evt.setTransacted(tid);
        }

        final void setNonTransacted() {
            this.m_evt.setNonTransacted();
        }

        boolean isTransacted() {
            return this.m_evt.isTransacted();
        }

        int getTransactionId() {
            return this.m_evt.getTransactionId();
        }

        final void processDeliveryInfo() {
            RecipientVector ptpRecips = (RecipientVector)this.m_evt.getPtpRecipients();
            if (ptpRecips != null) {
                String queueName = null;
                String nodeName = null;
                IMgram ptpMgram = null;
                QueueMsgEvt queueMsgEvt = null;
                this.m_evt.getMessage().getSidebandDataReadOnly();
                for (int ii = 0; ii < ptpRecips.m_data.length; ++ii) {
                    if (ptpRecips.m_data[ii] == null) continue;
                    RecipientWrap rw = (RecipientWrap)ptpRecips.m_data[ii];
                    if (rw != null && rw.hasClientContext()) {
                        nodeName = rw.getTargetedNodeName();
                        queueName = rw.getLocalQueueName();
                        try {
                            ISubjectFilter sf;
                            ptpMgram = (IMgram)this.m_evt.getMessage().protectedClone();
                            ptpMgram.getBrokerHandle().setLogEvent(null);
                            ptpMgram.setGuarenteed(this.m_evt.getPtpTrackingNums()[ii]);
                            long sfId = rw.getSubjectFilterId();
                            if (sfId == -1L) {
                                sfId = rw.getId();
                            }
                            if ((sf = ptpMgram.getBrokerHandle().getSubjectFilter(sfId)) != null) {
                                ISubject filtered = sf.filter(ptpMgram.getSubject());
                                if (filtered == null) {
                                    SessionConfig.logMessage("Unable to deliver GSA message with no matching subjects!", new EAssertFailure(ptpMgram.getSubject().getJMSName()), SessionConfig.SEVERE);
                                }
                                ptpMgram.setSubject(filtered, 5);
                                ptpMgram.setLimiterSizeIncrement(this.m_evt.getMessage().getSubject().memoryLength());
                                ptpMgram.getBrokerHandle().setSubjectFilters(null);
                            }
                            if (nodeName != null) {
                                if (!ptpMgram.getRoutingHandle().isNodeInPath(Config.ROUTING_NODE_NAME)) {
                                    ptpMgram.getRoutingHandle().addNodeToPath(Config.ROUTING_NODE_NAME);
                                }
                                if (!ptpMgram.getRoutingHandle().isNodeInPath(nodeName)) {
                                    ptpMgram.getRoutingHandle().addNodeToPath(nodeName);
                                }
                                ptpMgram.getRoutingHandle().setGSAPublication(true);
                            }
                            if (Config.ENABLE_SECURITY && ptpMgram.isSecure()) {
                                try {
                                    ptpMgram.setSecurityAttribute(RecoveryMgr.this.m_reg.getMsgProc().handleQopSecurity(ptpMgram, true, true));
                                }
                                catch (EIntegrityCompromised eIntegrityCompromised) {}
                            }
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {
                            // empty catch block
                        }
                        if (queueMsgEvt == null) {
                            queueMsgEvt = new QueueMsgEvt(queueName, null, ptpMgram, false, false);
                            queueMsgEvt.setOrigSender(0L);
                            queueMsgEvt.setOrigTracking(0L);
                        } else {
                            queueMsgEvt.setLocalQueueName(queueName);
                            queueMsgEvt.setMessage(ptpMgram);
                        }
                        queueMsgEvt.setSeqNo(this.m_evt.getPtpTrackingNums()[ii]);
                        ptpMgram.sync();
                        RecoveryMgr.this.redoQueueMsg(queueMsgEvt, this.isSyncEvent());
                    }
                    ptpRecips.m_data[ii] = null;
                }
                this.m_evt.removeAllQRecipients();
            }
        }
    }

    static class RecoveredQueueSet
    extends DebugObject {
        private TreeMap m_queues = new TreeMap();

        RecoveredQueueSet() {
            super(DebugState.GLOBAL_DEBUG_ON ? "RecoveredQueueSet" : null);
        }

        void addQueueMsg(RecoveredQMsg rqm) {
            RecoveredQueue rq;
            String qname = rqm.getQueueName();
            if (this.DEBUG) {
                this.debug("Adding " + rqm.getTracking() + " to RQ " + qname);
            }
            if ((rq = (RecoveredQueue)this.m_queues.get(qname)) == null) {
                rq = new RecoveredQueue(qname);
                this.m_queues.put(qname, rq);
            }
            rq.addQueueMsg(rqm);
        }

        boolean isLoadable() {
            return true;
        }

        Iterator getRecoveredQueues() {
            return this.m_queues.values().iterator();
        }
    }

    class RecoveryReplicationProcessor
    implements IEventProcessor {
        RecoveryReplicationProcessor() {
        }

        @Override
        public boolean recoveredFromLog() {
            return false;
        }

        @Override
        public long processEvents() throws EStartupFailure {
            RecoveryMgr.this.m_replicating = true;
            return this.readReplicationStream();
        }

        long readReplicationStream() throws EStartupFailure {
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STARTING_REPLICATION"), 3);
            RecoveryMgr.this.m_txnmgr = RecoveryMgr.this.m_reg.getTransactionMgr();
            RecoveryMgr.this.m_db = RecoveryMgr.this.m_reg.getBrokerDatabase();
            RecoveryMgr.this.m_dbQMsgs = RecoveryMgr.this.m_reg.getReplicationManager().getReplicationDemultiplexer().getStandbyDBQMsgs();
            if (RecoveryMgr.this.DEBUG1) {
                RecoveryMgr.this.debug("Read " + RecoveryMgr.this.m_dbQMsgs.size() + " QueueMessage ids from db");
            }
            RecoveryMgr.this.m_pubSubDeleteTracker = RecoveryMgr.this.m_reg.getReplicationManager().getReplicationDemultiplexer().getPubSubDeleteTracker();
            try {
                int count = RecoveryMgr.this.m_db.getIPtpDBQ().deleteNonpersistentQMsgs();
                if (RecoveryMgr.this.DEBUG1) {
                    RecoveryMgr.this.debug("Deleted " + count + " nonpersistent QueueMessages from db");
                }
            }
            catch (EDatabaseException e) {
                throw new EStartupFailure(prAccessor.getString("STR281") + e, e);
            }
            EventListenerImpl readListener = new EventListenerImpl();
            try {
                ReplicationReader replReader = new ReplicationReader(readListener);
                if (RecoveryMgr.this.DEBUG1) {
                    RecoveryMgr.this.debug("Starting to read log event stream; m_inSync= " + RecoveryMgr.this.m_inSync + " m_hasValidSync= " + RecoveryMgr.this.m_hasValidSync);
                }
                boolean completeRecovery = replReader.read();
                if (RecoveryMgr.this.DEBUG1) {
                    RecoveryMgr.this.debug("Finished reading log event steam; completeRecovery= " + completeRecovery + " m_inSync= " + RecoveryMgr.this.m_inSync + " m_hasValidSync= " + RecoveryMgr.this.m_hasValidSync);
                }
                if (completeRecovery) {
                    RecoveryMgr.this.m_reg.getLogManager().flush();
                    RecoveryMgr.this.m_db.setFailoverInitialValues();
                    if (RecoveryMgr.this.m_hasValidSync && RecoveryMgr.this.m_inSync) {
                        if (RecoveryMgr.this.DEBUG1) {
                            RecoveryMgr.this.debug("Performing partial syncpoint; setting m_inSync= false ");
                        }
                        RecoveryMgr.this.m_inSync = false;
                        RecoveryMgr.this.m_metaState.performPartialSyncpoint(RecoveryMgr.this.m_backupMetaState);
                        if (RecoveryMgr.this.DEBUG1) {
                            RecoveryMgr.this.debug("Completed partial syncpoint");
                        }
                        RecoveryMgr.this.m_backupMetaState = null;
                    }
                    if (!RecoveryMgr.this.m_hasValidSync) {
                        throw new EStartupFailure(prAccessor.getString("STR248"));
                    }
                    RecoveryMgr.this.resolveQMessageTxState();
                    RecoveryMgr.this.resolvePubSubTxState();
                    if (RecoveryMgr.this.DEBUG1) {
                        RecoveryMgr.this.debug("readReplicationStream: calling txnmgr.finishRecovery");
                    }
                    int txcount = RecoveryMgr.this.m_txnmgr.finishRecovery();
                    if (RecoveryMgr.this.DEBUG1) {
                        RecoveryMgr.this.debug("readReplicationStream: completed txnmgr.finishRecovery: numRecoveredTransactions= " + txcount);
                    }
                    RecoveryMgr.this.finishQMessageRecovery();
                    if (RecoveryMgr.this.DEBUG1) {
                        RecoveryMgr.this.debug("Calling m_reg.fixupClientsAfterRecovery()");
                    }
                } else {
                    return -1L;
                }
                RecoveryMgr.this.m_reg.fixupClientsAfterRecovery();
            }
            catch (Exception e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                throw new EStartupFailure(prAccessor.getString("STR249") + e);
            }
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("REPLICATION_COMPLETE"), 3);
            long retval = readListener.getNextSeqNum();
            long dbMaxId = RecoveryMgr.this.m_db.getStartupMaxIdUsed() + 1L;
            if (RecoveryMgr.this.DEBUG) {
                RecoveryMgr.this.debug("NextSeqNo (DB)= " + dbMaxId + " NextSeqNo (Log)= " + retval);
            }
            if (dbMaxId > retval) {
                retval = dbMaxId;
            }
            if (RecoveryMgr.this.DEBUG1) {
                RecoveryMgr.this.debug("Returning from processEvents; NextSeqNo= " + retval);
            }
            return retval;
        }

        @Override
        public void redoDurableStats(ArrayList stats) {
        }

        @Override
        public void redoSyncBegin() {
            RecoveryMgr.this.m_reg.getReplicationManager().getReplicationDemultiplexer().getStandbyDBQMsgs().syncBegin();
            RecoveryMgr.this.m_reg.getReplicationManager().getReplicationDemultiplexer().getPubSubDeleteTracker().syncBegin();
            RecoveryMgr.this.m_reg.getDeleteSubscriptionManager().syncBegin();
            RecoveryMgr.this.beginSyncpoint();
        }

        @Override
        public void redoSyncEnd() {
            RecoveryMgr.this.m_reg.getReplicationManager().getReplicationDemultiplexer().getStandbyDBQMsgs().syncEnd();
            RecoveryMgr.this.m_reg.getReplicationManager().getReplicationDemultiplexer().getPubSubDeleteTracker().syncEnd();
            RecoveryMgr.this.m_reg.getDeleteSubscriptionManager().syncEnd();
            RecoveryMgr.this.endSyncpoint();
        }

        @Override
        public void redoSubscribe(SubscribeEvt evt) {
            RecoveryMgr.this.processSubscribe(evt, true);
        }
    }

    class RecoveryLogProcessor
    implements IEventProcessor {
        RecoveryLogProcessor() {
        }

        @Override
        public boolean recoveredFromLog() {
            return true;
        }

        @Override
        public long processEvents() throws EStartupFailure {
            RecoveryMgr.this.m_replicating = false;
            return this.readLog();
        }

        long readLog() throws EStartupFailure {
            long retval;
            block38: {
                BrokerComponent.getComponentContext().logMessage(prAccessor.getString("STARTING_RECOVERY"), 3);
                RecoveryMgr.this.m_txnmgr = RecoveryMgr.this.m_reg.getTransactionMgr();
                RecoveryMgr.this.m_db = RecoveryMgr.this.m_reg.getBrokerDatabase();
                retval = 0L;
                try {
                    boolean hasQopSecurity;
                    byte mode = RecoveryMgr.this.m_db.getSecurityMode();
                    boolean hasSecurity = (mode & 1) != 0;
                    boolean bl = hasQopSecurity = (mode & 2) != 0;
                    if (Config.ENABLE_SECURITY) {
                        if (!hasSecurity) {
                            throw new EStartupFailure(LOG_MISMATCH);
                        }
                        if (!hasQopSecurity && Config.ENABLE_QOPSECURITY) {
                            throw new EStartupFailure(SECNOQOPLOG_MISMATCH);
                        }
                        if (hasQopSecurity && !Config.ENABLE_QOPSECURITY) {
                            throw new EStartupFailure(SECQOPLOG_MISMATCH);
                        }
                    } else if (hasSecurity) {
                        throw new EStartupFailure(SECLOG_MISMATCH);
                    }
                }
                catch (EDatabaseException e) {
                    throw new EStartupFailure(prAccessor.getString("STR245") + e, e);
                }
                try {
                    LongHashTable client_attrs = RecoveryMgr.this.m_db.getAllClientAttributes();
                    int client_count = 0;
                    Enumeration enu = client_attrs.elements();
                    while (enu.hasMoreElements()) {
                        long lastConnectedTime;
                        BrokerDatabase.ClientAttributes attrs = (BrokerDatabase.ClientAttributes)enu.nextElement();
                        ByteBufferInputStream bis = new ByteBufferInputStream(attrs.csc);
                        ClientSecurityContext sec_ctx = ClientSecurityContext.unserialize(bis);
                        IClientContext client = AgentRegistrar.getAgentRegistrar().createContext(attrs.cid, sec_ctx, null);
                        client.setInterbroker(attrs.isInterbroker);
                        if (RecoveryMgr.this.DEBUG) {
                            RecoveryMgr.this.debug("restoring client " + client + " from db");
                        }
                        if ((lastConnectedTime = attrs.lastConnectedTime) == -1L && !client.isXOnce()) {
                            lastConnectedTime = System.currentTimeMillis();
                        }
                        RecoveryMgr.this.redoConnect(client.getId(), client.getCSC(), client.isInterbroker(), lastConnectedTime);
                        ++client_count;
                    }
                    if (RecoveryMgr.this.DEBUG1) {
                        RecoveryMgr.this.debug("" + client_count + " clients read from db");
                    }
                    Vector subs = RecoveryMgr.this.m_db.getSubscriptions();
                    int numsubs = subs.size();
                    Boolean trueValue = new Boolean(true);
                    Boolean falseValue = new Boolean(false);
                    for (int i = 0; i < numsubs; ++i) {
                        DBSubscription sub = (DBSubscription)subs.elementAt(i);
                        String[] selectorStrs = sub.getSelectorStrs();
                        GSVirtualClock virtualClock = sub.getVirtualClock();
                        SubscribeEvt evt = null;
                        if (RecoveryMgr.this.DEBUG) {
                            BrokerComponent.getComponentContext().logMessage("Read sub. InDoubtProxies=" + sub.getInDoubtProxies(), 3);
                        }
                        if (virtualClock != null) {
                            evt = new GSSubscribeEvt(null, sub.getClient(), sub.getSubject(), sub.getLabel(), selectorStrs, sub.getSelectorAtBroker(), virtualClock);
                        } else if (selectorStrs != null) {
                            evt = new SubscribeEvtForSelector(null, sub.getClient(), sub.getSubject(), sub.getLabel(), selectorStrs, sub.getSelectorAtBroker());
                            this.configNewCWADSfieldAndCreationTime(evt, sub);
                        } else {
                            evt = new SubscribeEvt(null, sub.getClient(), sub.getSubject(), sub.getLabel());
                            this.configNewCWADSfieldAndCreationTime(evt, sub);
                        }
                        evt.setTTE(sub.getTTE());
                        evt.setDurableStrictMessageOrder(sub.getDurableStrictMessageOrder());
                        evt.setLogged(true);
                        evt.setSuppressCWADSPropagation(true);
                        if (RecoveryMgr.this.DEBUG) {
                            RecoveryMgr.this.debug("redoing from db: " + evt);
                        }
                        if (sub.getUnfiltered()) {
                            RecoveryMgr.this.processSubscribe(evt, trueValue, true, sub.getInDoubtProxies(), false);
                            continue;
                        }
                        RecoveryMgr.this.processSubscribe(evt, falseValue, true, sub.getInDoubtProxies(), false);
                    }
                    if (RecoveryMgr.this.DEBUG1) {
                        RecoveryMgr.this.debug("" + numsubs + " subscriptions read from db");
                    }
                }
                catch (IOException e) {
                    throw new EStartupFailure(prAccessor.getString("STR246") + e, e);
                }
                try {
                    int count = RecoveryMgr.this.m_db.getIPtpDBQ().deleteNonpersistentQMsgs();
                    if (RecoveryMgr.this.DEBUG1) {
                        RecoveryMgr.this.debug("Deleted " + count + " nonpersistent QueueMessages from db");
                    }
                }
                catch (EDatabaseException e) {
                    throw new EStartupFailure(prAccessor.getString("STR281") + e, e);
                }
                try {
                    RecoveryMgr.this.m_dbQMsgs = new LogRecoveryDBQMsgs(RecoveryMgr.this.m_db);
                    if (RecoveryMgr.this.DEBUG1) {
                        RecoveryMgr.this.debug("Read " + RecoveryMgr.this.m_dbQMsgs.size() + " QueueMessage ids from db");
                    }
                }
                catch (EDatabaseException e) {
                    throw new EStartupFailure(prAccessor.getString("STR280") + e, e);
                }
                try {
                    SyncpointLoc sp = RecoveryMgr.this.m_db.getSyncPtLoc();
                    if (RecoveryMgr.this.DEBUG1) {
                        if (sp != null) {
                            RecoveryMgr.this.debug("Reading log: fileno= " + sp.getFileNo() + " filepos= " + sp.getFilePos());
                        } else {
                            RecoveryMgr.this.debug("Reading log: sp=null ");
                        }
                    }
                    retval = this.redoLog(sp);
                }
                catch (EStartupFailure e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!RecoveryMgr.this.DEBUG1) break block38;
                    RecoveryMgr.this.debug("could not recover from syncpoint: " + e);
                    BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                }
            }
            long dbMaxId = RecoveryMgr.this.m_db.getStartupMaxIdUsed() + 1L;
            if (RecoveryMgr.this.DEBUG) {
                RecoveryMgr.this.debug("NextSeqNo (DB)= " + dbMaxId + " NextSeqNo (Log)= " + retval);
            }
            if (dbMaxId > retval) {
                retval = dbMaxId;
            }
            if (RecoveryMgr.this.DEBUG) {
                RecoveryMgr.this.debug("Returning from readLog; NextSeqNo= " + retval);
            }
            return retval;
        }

        private void configNewCWADSfieldAndCreationTime(SubscribeEvt evt, DBSubscription sub) {
            evt.setPreviousBrokerCID(sub.getPreviousBrokerCID());
            evt.setRestoreToBrokerCID(sub.getRestoreToBrokerCID());
            long creationTime = sub.getCreationTime();
            if (creationTime != -1L) {
                evt.setCreationTime(creationTime);
            }
        }

        private long redoLog(SyncpointLoc sp) throws EStartupFailure {
            RecoveryMgr.this.m_inSync = sp != null;
            RecoveryMgr.this.m_hasValidSync = sp == null;
            EventListenerImpl readListener = new EventListenerImpl();
            if (RecoveryMgr.this.DEBUG1) {
                RecoveryMgr.this.debug("redolog: m_inSync= " + RecoveryMgr.this.m_inSync + " m_hasValidSync= " + RecoveryMgr.this.m_hasValidSync + " " + sp);
            }
            try {
                LogReader logReader = new LogReader(RecoveryMgr.this.m_log, readListener);
                if (RecoveryMgr.this.DEBUG1) {
                    RecoveryMgr.this.debug("redoLog: Starting log read " + (sp != null ? sp.getFileNo() + " " + sp.getFilePos() : ""));
                }
                long count = logReader.read(sp);
                if (RecoveryMgr.this.DEBUG1) {
                    RecoveryMgr.this.debug("redoLog: completed reading recovery file; processed " + count + " events; m_inSync= " + RecoveryMgr.this.m_inSync + " m_hasValidSync= " + RecoveryMgr.this.m_hasValidSync);
                }
                if (!RecoveryMgr.this.m_hasValidSync) {
                    throw new EStartupFailure(prAccessor.getString("STR248"));
                }
                try {
                    logReader.getLogInputStream().seek(readListener.getLastLocation());
                }
                catch (ELogOutOfSequence eLogOutOfSequence) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                RecoveryMgr.this.resolveQMessageTxState();
                RecoveryMgr.this.resolvePubSubTxState();
                if (RecoveryMgr.this.DEBUG1) {
                    RecoveryMgr.this.debug("redoLog: calling txnmgr.finishRecovery");
                }
                int txcount = RecoveryMgr.this.m_txnmgr.finishRecovery();
                if (RecoveryMgr.this.DEBUG1) {
                    RecoveryMgr.this.debug("redoLog: completed txnmgr.finishRecovery: numRecoveredTransactions= " + txcount);
                }
                RecoveryMgr.this.finishQMessageRecovery();
                if (RecoveryMgr.this.DEBUG1) {
                    RecoveryMgr.this.debug("Calling m_reg.fixupClientsAfterRecovery()");
                }
                RecoveryMgr.this.m_reg.fixupClientsAfterRecovery();
            }
            catch (Exception e) {
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
                throw new EStartupFailure(prAccessor.getString("STR249") + e);
            }
            BrokerComponent.getComponentContext().logMessage(prAccessor.getString("RECOVERY_COMPLETE"), 3);
            RecoveryMgr.this.m_log.syncSequenceNumbers();
            return readListener.getNextSeqNum();
        }

        @Override
        public void redoDurableStats(ArrayList stats) {
            ((RecoveryMgr)RecoveryMgr.this).m_metaState.m_durableStats = stats;
        }

        @Override
        public void redoSyncEnd() {
            RecoveryMgr.this.endSyncpoint();
        }

        @Override
        public void redoSyncBegin() {
        }

        @Override
        public void redoSubscribe(SubscribeEvt evt) {
            RecoveryMgr.this.processSubscribe(evt, false);
        }
    }

    class RecoveredQMsg {
        private long m_tracking;
        private IMgram m_msg;
        private long m_origSender;
        private long m_origTracking;
        private boolean m_needGuarAck;
        private long m_receiverId;
        private boolean m_delivered;
        private String m_queueName;
        private long m_expiration;
        private byte m_priority = (byte)-1;
        private long m_enqueuedSize;
        private long m_oldTracking;
        private int m_tid;
        private boolean m_isTemp = false;
        private LinkedList m_doesNotContainHandler = null;
        private LinkedList m_containsHandler = null;
        private boolean m_deliveredUnresolved = false;
        private boolean m_receiverIDUnresolved = false;
        private boolean m_saveRequested = false;
        private boolean m_replicateOnly = false;

        RecoveredQMsg(SyncQueueMsgEvt evt) {
            this.m_tracking = evt.m_tracking;
            this.m_queueName = evt.m_queueName.intern();
            if (this.m_queueName == null) {
                throw new EAssertFailure("m_queueName is null when constructing a RQM from a syncqme evt.m_origTracking: " + evt.m_origTracking);
            }
            this.m_msg = evt.m_msg;
            this.m_needGuarAck = evt.m_needGuarAck;
            this.m_origSender = evt.m_origSender;
            this.m_origTracking = evt.m_origTracking;
            this.m_delivered = evt.m_delivered;
            this.m_receiverId = evt.m_receiverId;
            this.m_oldTracking = evt.m_oldTracking;
            this.m_tid = evt.m_tid;
            this.m_isTemp = evt.m_isTemp;
            this.m_priority = evt.m_priority;
            this.m_expiration = evt.m_expiration;
            this.m_enqueuedSize = evt.m_enqueuedSize;
            this.m_replicateOnly = evt.isReplicateOnly();
            this.debugRecoveredQMsg();
        }

        RecoveredQMsg(QueueMsgEvt evt) {
            this.m_tracking = evt.getSeqNo();
            this.m_queueName = evt.getLocalQueueName().intern();
            if (this.m_queueName == null) {
                throw new EAssertFailure("m_queueName is null when constructing a RQM from qme evt.getOrigTracking(): " + evt.getOrigTracking());
            }
            this.m_msg = evt.getMessage();
            this.m_needGuarAck = evt.needGuarAck();
            this.m_origSender = evt.getOrigSender();
            this.m_origTracking = evt.getOrigTracking();
            this.m_tid = evt.getTransactionId();
            this.m_isTemp = evt.isTempQueue();
            this.m_priority = evt.getPriority();
            this.m_expiration = evt.getExpiration();
            this.m_enqueuedSize = evt.getEnqueuedSize();
            this.m_replicateOnly = evt.isReplicateOnly();
        }

        RecoveredQMsg(QueueMsgMoveEvt evt) {
            this.m_tracking = evt.getSeqNo();
            this.m_queueName = evt.getNewQueueName().intern();
            if (this.m_queueName == null) {
                throw new EAssertFailure("m_queueName is null when constructing a RQM : ");
            }
            this.m_msg = evt.getMessage();
            this.m_oldTracking = evt.getOldTracking();
            this.m_isTemp = evt.isNewTempQueue();
            this.m_priority = this.m_msg.getPriority();
            this.m_expiration = this.m_msg.getTTE();
            this.m_enqueuedSize = this.m_msg.getEnqueuedSize();
            this.m_replicateOnly = evt.isReplicateOnly();
        }

        RecoveredQMsg(SyncQueueMsgMoveEvt evt) {
            this.m_tracking = evt.getMessage().getGuarenteedTrackingNum();
            this.m_queueName = evt.getNewQueueName().intern();
            if (this.m_queueName == null) {
                throw new EAssertFailure("m_queueName is null when constructing a RQM : ");
            }
            this.m_msg = evt.getMessage();
            this.m_oldTracking = evt.getOldTracking();
            this.m_isTemp = evt.isNewTempQueue();
            this.m_priority = this.m_msg.getPriority();
            this.m_expiration = this.m_msg.getTTE();
            this.m_enqueuedSize = this.m_msg.getEnqueuedSize();
            this.m_replicateOnly = evt.isReplicateOnly();
        }

        RecoveredQMsg(long tracking, String queueName, IMgram msg, boolean needGuarAck, long origSender, long origTracking, boolean delivered, long receiverId, long oldTracking, int tid, boolean isTemp, byte priority) {
            this.m_tracking = tracking;
            this.m_queueName = queueName.intern();
            if (this.m_queueName == null) {
                throw new EAssertFailure("m_queueName is null when constructing a RQM from values origTracking: " + origTracking);
            }
            this.m_msg = msg;
            if (this.m_msg != null) {
                this.m_replicateOnly = this.m_msg.isNonPersistentReplicated();
            }
            this.m_needGuarAck = needGuarAck;
            this.m_origSender = origSender;
            this.m_origTracking = origTracking;
            this.m_delivered = delivered;
            this.m_receiverId = receiverId;
            this.m_oldTracking = oldTracking;
            this.m_tid = tid;
            this.m_isTemp = isTemp;
            this.debugRecoveredQMsg();
            this.m_priority = priority;
        }

        private void debugRecoveredQMsg() {
            if (RecoveryMgr.this.DEBUG && this.m_tid != 0) {
                RecoveryMgr.this.debug("RecoveredQMsg tid= " + this.m_tid + " tracking= " + this.m_tracking);
            }
        }

        void markSaveRequested() {
            this.m_saveRequested = true;
        }

        boolean savedOrPendingSavedInDatabase() {
            return this.m_saveRequested || this.m_msg == null;
        }

        long getTracking() {
            return this.m_tracking;
        }

        boolean needGuarAck() {
            return this.m_needGuarAck;
        }

        String getQueueName() {
            return this.m_queueName;
        }

        boolean isDelivered() {
            return this.m_delivered;
        }

        IMgram getMessage() {
            return this.m_msg;
        }

        long getReceiverId() {
            return this.m_receiverId;
        }

        long getOrigSender() {
            return this.m_origSender;
        }

        long getOrigTracking() {
            return this.m_origTracking;
        }

        long getOldTracking() {
            return this.m_oldTracking;
        }

        void setOrigSender(long sender) {
            this.m_origSender = sender;
        }

        void setOrigTracking(long tracking) {
            this.m_origTracking = tracking;
        }

        void setDelivered(boolean delivered) {
            this.m_delivered = delivered;
        }

        void setNeedGuarAck(boolean needGuarAck) {
            this.m_needGuarAck = needGuarAck;
        }

        void setQueueName(String name) {
            this.m_queueName = name;
        }

        void setReceiverId(long id) {
            this.m_receiverId = id;
        }

        void setMessage(IMgram mgram) {
            this.m_msg = mgram;
        }

        void setOldTracking(long tracking) {
            this.m_oldTracking = tracking;
        }

        void setEnqueuedSize(long size) {
            this.m_enqueuedSize = size;
        }

        void setExpiration(long exp) {
            this.m_expiration = exp;
        }

        void setPriority(byte prio) {
            this.m_priority = prio;
        }

        void setTransacted(int tid) {
            this.m_tid = tid;
        }

        void setNonTransacted() {
            this.m_tid = 0;
        }

        boolean isTransacted() {
            return this.m_tid != 0;
        }

        boolean isTemporary() {
            return this.m_isTemp;
        }

        long getExpiration() {
            return this.m_expiration;
        }

        byte getPriority() {
            return this.m_priority;
        }

        long getEnqueuedSize() {
            return this.m_enqueuedSize;
        }

        int getTransactionId() {
            return this.m_tid;
        }

        boolean isDeliveredUnresolved() {
            return this.m_deliveredUnresolved;
        }

        void setDeliveredUnresolved(boolean deliveredUnresolved) {
            this.m_deliveredUnresolved = deliveredUnresolved;
        }

        boolean isReceiverIdUnresolved() {
            return this.m_receiverIDUnresolved;
        }

        void setReceiverIDUnresolved(boolean receiverIDUnresolved) {
            this.m_receiverIDUnresolved = receiverIDUnresolved;
        }

        boolean isReplicateOnly() {
            return this.m_replicateOnly;
        }

        void setReplicateOnly(boolean replicateOnly) {
            this.m_replicateOnly = replicateOnly;
        }

        void setNullMsgHandler(short status) {
            IStatusHandler handler = new IStatusHandler(){

                @Override
                public void doit() {
                    RecoveredQMsg.this.setMessage(null);
                }

                @Override
                public String toString() {
                    return "setNullMsgHandler";
                }
            };
            this.setHandlers(status, handler);
        }

        void setMsgDeliveredIfMsgNullHandler(short status) {
            IStatusHandler handler = new IStatusHandler(){

                @Override
                public void doit() {
                    if (RecoveredQMsg.this.isDeliveredUnresolved()) {
                        RecoveredQMsg.this.msgDeliveredIfMsgNull();
                        RecoveredQMsg.this.setDeliveredUnresolved(false);
                    }
                }

                @Override
                public String toString() {
                    return "setMsgDeliveredIfMsgNullHandler";
                }
            };
            this.setHandlers(status, handler);
        }

        void setReceivedIdHandler(short status, final long cid) {
            IStatusHandler handler = new IStatusHandler(){

                @Override
                public void doit() {
                    if (RecoveredQMsg.this.isReceiverIdUnresolved()) {
                        RecoveredQMsg.this.setReceiverId(cid);
                        RecoveredQMsg.this.setReceiverIDUnresolved(false);
                    }
                }

                @Override
                public String toString() {
                    return "setReceivedIdHandler";
                }
            };
            this.setHandlers(status, handler);
        }

        void setRemoveDeleteRQMHandler(short status) {
            IStatusHandler handler = new IStatusHandler(){

                @Override
                public void doit() {
                    RecoveredQMsg.this.removeDeleteRQM();
                }

                @Override
                public String toString() {
                    return "setRemoveDeleteRQMHandler";
                }
            };
            this.setHandlers(status, handler);
        }

        void setRemoveHandler(short status) {
            IStatusHandler handler = new IStatusHandler(){

                @Override
                public void doit() {
                    RecoveredQMsg.this.removeRQM();
                }

                @Override
                public String toString() {
                    return "setRemoveHandler";
                }
            };
            this.setHandlers(status, handler);
        }

        void setDeleteHandler(short status) {
            IStatusHandler handler = new IStatusHandler(){

                @Override
                public void doit() {
                    RecoveredQMsg.this.delete();
                }

                @Override
                public String toString() {
                    return "setDeleteHandler";
                }
            };
            this.setHandlers(status, handler);
        }

        public void msgDeliveredIfMsgNull() {
            IMgram m = this.getMessage();
            if (m == null) {
                this.setDelivered(true);
                this.setMessage(null);
                this.setReceiverId(0L);
            }
        }

        private void setHandlers(short status, IStatusHandler handler) {
            switch (status) {
                case 0: {
                    if (this.m_containsHandler == null) {
                        this.m_containsHandler = new LinkedList();
                    }
                    this.m_containsHandler.addLast(handler);
                    break;
                }
                case 1: {
                    if (this.m_doesNotContainHandler == null) {
                        this.m_doesNotContainHandler = new LinkedList();
                    }
                    this.m_doesNotContainHandler.addLast(handler);
                }
            }
        }

        void delete() {
            RecoveryMgr.this.deleteQMsg(this.m_tracking);
        }

        void removeRQM() {
            Long tracking = new Long(this.m_tracking);
            ((RecoveryMgr)RecoveryMgr.this).m_metaState.m_recQMsgs.remove(tracking);
        }

        void removeDeleteRQM() {
            Long trackingObj = new Long(this.m_tracking);
            ((RecoveryMgr)RecoveryMgr.this).m_metaState.m_recQMsgs.remove(trackingObj);
            RecoveryMgr.this.deleteQMsg(this.m_tracking);
        }

        void executeHandler(int status) {
            switch (status) {
                case 0: {
                    if (this.m_containsHandler != null) {
                        for (IStatusHandler handler : this.m_containsHandler) {
                            if (RecoveryMgr.this.DEBUG) {
                                RecoveryMgr.this.debug("Executing contains handler: " + handler.toString() + " Tracking: " + this.m_tracking);
                            }
                            handler.doit();
                        }
                    }
                    if (!RecoveryMgr.this.DEBUG || this.m_doesNotContainHandler == null) break;
                    RecoveryMgr.this.debug("Tracking: " + this.m_tracking + " has the following does not contain handlers: ");
                    for (IStatusHandler handler : this.m_doesNotContainHandler) {
                        RecoveryMgr.this.debug("does not contain handler: " + handler.toString() + " Tracking: " + this.m_tracking);
                    }
                    break;
                }
                case 1: {
                    if (this.m_doesNotContainHandler != null) {
                        for (IStatusHandler handler : this.m_doesNotContainHandler) {
                            if (RecoveryMgr.this.DEBUG) {
                                RecoveryMgr.this.debug("Executing does not contain handler: " + handler.toString() + " Tracking: " + this.m_tracking);
                            }
                            handler.doit();
                        }
                    }
                    if (!RecoveryMgr.this.DEBUG || this.m_containsHandler == null) break;
                    RecoveryMgr.this.debug("Tracking: " + this.m_tracking + " has the following contains handlers: ");
                    for (IStatusHandler handler : this.m_containsHandler) {
                        RecoveryMgr.this.debug("contains handler: " + handler.toString() + " Tracking: " + this.m_tracking);
                    }
                    break;
                }
            }
            this.m_containsHandler = null;
            this.m_doesNotContainHandler = null;
        }

        private AgentQueueMsgTracker createTracker() throws EDuplicateKey {
            AgentQueueMsgTracker tracker = null;
            tracker = new AgentQueueMsgTracker(this.getTracking(), this.getQueueName(), this.getPriority(), this.getExpiration(), this.getEnqueuedSize());
            tracker.setOrigSender(this.getOrigSender());
            tracker.setOrigTracking(this.getOrigTracking());
            tracker.setDelivered(this.isDelivered());
            tracker.setNeedGuarAck(this.needGuarAck());
            tracker.setMessage(this.getMessage());
            tracker.setReceiverId(this.getReceiverId());
            tracker.setTransacted(this.getTransactionId());
            tracker.setTemporary(this.isTemporary());
            tracker.setReplicateOnly(this.isReplicateOnly());
            if (this.getMessage() != null) {
                tracker.setReplicateOnly(this.getMessage().isNonPersistentReplicated());
            }
            if (this.savedOrPendingSavedInDatabase()) {
                tracker.setMsgSavedInDatabase(true);
            }
            return tracker;
        }
    }

    class SyncQAck {
        long m_tracking;
        boolean m_hasDelete;
        boolean m_forceDelete;

        SyncQAck(long tracking, boolean hasDelete, boolean forceDelete) {
            this.m_tracking = tracking;
            this.m_hasDelete = hasDelete;
            this.m_forceDelete = forceDelete;
        }
    }

    class EventListenerImpl
    implements EventListener {
        long m_lastloc;
        long m_nextSeqNum;

        EventListenerImpl() {
        }

        long getLastLocation() {
            return this.m_lastloc;
        }

        long getNextSeqNum() {
            return this.m_nextSeqNum;
        }

        @Override
        public void onLogEventRead(LogEvent evt, long lastloc, long nextSeqNum) {
            this.m_lastloc = lastloc;
            if (nextSeqNum > this.m_nextSeqNum) {
                this.m_nextSeqNum = nextSeqNum;
            }
            evt.redo(RecoveryMgr.this);
        }

        @Override
        public void onEndLog(long nextloc) {
            this.m_lastloc = nextloc;
        }
    }

    static interface IStatusHandler {
        public void doit();

        public String toString();
    }

    static class RecoveredQueue {
        private ArrayList m_recoveredMsgs = new ArrayList();
        private String m_name;

        RecoveredQueue(String name) {
            this.m_name = name;
        }

        String getQueueName() {
            return this.m_name;
        }

        void addQueueMsg(RecoveredQMsg rqm) {
            this.m_recoveredMsgs.add(rqm);
        }

        List getRecoveredMsgs() {
            return this.m_recoveredMsgs;
        }

        void clear() {
            this.m_recoveredMsgs.clear();
        }
    }
}

