/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import progress.message.broker.ELogEventTooLong;
import progress.message.broker.LogEvent;
import progress.message.broker.RecoveryMgr;
import progress.message.util.StreamUtil;
import progress.message.util.StringUtil;

class TxnBeginEvt
extends LogEvent {
    private int m_tid;
    private int m_previousTid;
    private String m_uid;
    private String m_appid;
    private long m_requestId;
    private short m_replyStatus = 0;
    private short m_type = (short)85;

    TxnBeginEvt(int tid, int previousTid, String uid, String appid, long requestId, short replyStatus) {
        this.m_tid = tid;
        this.m_uid = uid;
        this.m_appid = appid;
        this.m_requestId = requestId;
        this.m_replyStatus = replyStatus;
        this.m_previousTid = previousTid;
    }

    TxnBeginEvt(short type) {
        this.m_type = type;
    }

    int getTid() {
        return this.m_tid;
    }

    int getPreviousTid() {
        return this.m_previousTid;
    }

    String getUid() {
        return this.m_uid;
    }

    String getAppid() {
        return this.m_appid;
    }

    long getRequestId() {
        return this.m_requestId;
    }

    @Override
    public short type() {
        return 85;
    }

    @Override
    protected int memSizeBody() {
        return 12 + (this.m_uid.length() + this.m_appid.length() << 1) + 4 + 8 + 2;
    }

    @Override
    protected int streamSizeBody() {
        return this.serializedSizeBody();
    }

    @Override
    protected int serializedSizeBody() {
        byte[] utfappid;
        byte[] utfuid;
        block2: {
            utfuid = null;
            utfappid = null;
            try {
                utfuid = StringUtil.stringToUTF(this.m_uid);
                utfappid = StringUtil.stringToUTF(this.m_appid);
            }
            catch (UTFDataFormatException e) {
                if (!this.DEBUG) break block2;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
        return 4 + utfuid.length + utfappid.length + 4 + 8 + 2;
    }

    @Override
    protected void writeBodyToLog(OutputStream out, long maxbytes) throws IOException, ELogEventTooLong {
        if (maxbytes < (long)this.serializedSizeBody()) {
            throw new ELogEventTooLong(this);
        }
        this.writeBody(out);
    }

    private void writeBody(OutputStream os) throws IOException {
        byte[] uid = StringUtil.stringToUTF(this.m_uid);
        byte[] appid = StringUtil.stringToUTF(this.m_appid);
        StreamUtil.writeInt(this.m_tid, os);
        os.write(uid, 0, uid.length);
        os.write(appid, 0, appid.length);
        StreamUtil.writeInt(this.m_previousTid, os);
        StreamUtil.writeLong(this.m_requestId, os);
        StreamUtil.writeShort(this.m_replyStatus, os);
    }

    @Override
    protected void writeBodyToStream(OutputStream os, boolean tteTTLConvert) throws IOException {
        this.writeBody(os);
    }

    @Override
    protected void readBodyFromStream(InputStream in, boolean tteTTLConvert) throws IOException {
        this.m_tid = StreamUtil.readInt(in);
        this.m_uid = StreamUtil.readUTF(in);
        this.m_appid = StreamUtil.readUTF(in);
        if (this.m_type == 85 || this.m_type == 91) {
            this.m_previousTid = StreamUtil.readInt(in);
            this.m_requestId = StreamUtil.readLong(in);
            this.m_replyStatus = StreamUtil.readShort(in);
        } else {
            this.m_previousTid = -1;
            this.m_requestId = -1L;
            this.m_replyStatus = 0;
        }
    }

    @Override
    public void redo(RecoveryMgr rm) {
        rm.redoTxnBegin(this);
    }

    @Override
    public String toString() {
        return super.toString() + "Txn " + this.m_tid + "Prev Txn " + this.m_previousTid + " for client " + this.m_uid + ", " + this.m_appid + ", requestId " + this.m_requestId + ", m_replyStatus " + this.m_replyStatus + ": begin";
    }
}

