/*
 * Decompiled with CFR 0.152.
 */
package progress.message.broker.mqtt.codec;

import java.io.EOFException;
import progress.message.broker.mqtt.codec.MqttCodecUtils;
import progress.message.broker.mqtt.proto.MqttException;
import progress.message.broker.mqtt.proto.MqttMessage;
import progress.message.broker.mqtt.proto.MqttQoS;
import progress.message.util.server.IByteBuffer;

abstract class DemuxDecoder<T extends MqttMessage> {
    DemuxDecoder() {
    }

    abstract T decode(IByteBuffer var1) throws EOFException;

    protected boolean decodeCommonHeader(MqttMessage message, IByteBuffer in) throws EOFException {
        return this.genericDecodeCommonHeader(message, null, in);
    }

    protected boolean decodeCommonHeader(MqttMessage message, int expectedFlags, IByteBuffer in) throws EOFException {
        return this.genericDecodeCommonHeader(message, expectedFlags, in);
    }

    private boolean genericDecodeCommonHeader(MqttMessage message, Integer expectedFlagsOpt, IByteBuffer in) throws EOFException {
        int expectedFlags;
        if (in.countUnread() < 2) {
            return false;
        }
        byte h1 = in.readByte();
        byte messageType = (byte)((h1 & 0xF0) >> 4);
        if (messageType != message.getMessageType()) {
            throw new MqttException("Invalid messageType = " + messageType);
        }
        byte flags = (byte)(h1 & 0xF);
        if (expectedFlagsOpt != null && (byte)(expectedFlags = expectedFlagsOpt.intValue()) != flags) {
            String hexExpected = Integer.toHexString(expectedFlags);
            String hexReceived = Integer.toHexString(flags);
            String msg = String.format("Received a message with fixed header flags (%s) != expected (%s)", hexReceived, hexExpected);
            throw new MqttException(msg);
        }
        boolean dupFlag = (byte)((h1 & 8) >> 3) == 1;
        byte qosLevel = (byte)((h1 & 6) >> 1);
        boolean retainFlag = (byte)(h1 & 1) == 1;
        int remainingLength = MqttCodecUtils.decodeRemainingLenght(in);
        if (remainingLength < 0) {
            return false;
        }
        message.setDupFlag(dupFlag);
        message.setQos(MqttQoS.valueOf(qosLevel));
        message.setRetainFlag(retainFlag);
        message.setRemainingLength(remainingLength);
        return true;
    }
}

