/*
 * Decompiled with CFR 0.152.
 */
package progress.message.ft;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.mq.components.BrokerManagementNotificationsHelper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentConnection;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.BrokerStatus;
import progress.message.broker.Config;
import progress.message.broker.prAccessor;
import progress.message.client.EBrokerVersionMismatch;
import progress.message.client.EConnectFailure;
import progress.message.client.EGeneralException;
import progress.message.client.EInterrupted;
import progress.message.client.EUserAlreadyConnected;
import progress.message.ft.FailoverConfig;
import progress.message.ft.FailureDetectCallback;
import progress.message.ft.IRequestHandler;
import progress.message.ft.PassiveConvertHandler;
import progress.message.ft.ReplicationChannel;
import progress.message.ft.ReplicationConnect;
import progress.message.ft.ReplicationConnection;
import progress.message.ft.ReplicationManager;
import progress.message.ft.ReplicationSessionContext;
import progress.message.msg.IMgram;
import progress.message.msg.MgramFactory;
import progress.message.net.ISocket;
import progress.message.util.ArrayUtil;
import progress.message.util.DebugState;
import progress.message.util.EAssertFailure;
import progress.message.util.VersionData;
import progress.message.zclient.ClientSecurityContext;
import progress.message.zclient.DebugObject;
import progress.message.zclient.EUnexpectedMgram;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Label;
import progress.message.zclient.MessageHandler;
import progress.message.zclient.ProgressSecureRandom;
import progress.message.zclient.SessionConfig;

public final class ConnectionManager
extends DebugObject
implements Runnable,
FailureDetectCallback {
    static final int DISCONNECTED = 0;
    static final int PASSIVE_CONNECT = 1;
    static final int PASSIVE_CONVERT = 2;
    static final int CONVERT_IN_PROGRESS = 3;
    static final int ACTIVE_CONNECT = 4;
    static final int ACTIVE = 5;
    static final int SEND_WAIT_TIME = 2000;
    private static final String[] state = new String[]{"DISCONNECTED", "PASSIVE_CONNECT", "PASSIVE_CONVERT", "CONVERT_IN_PROGRESS", "ACTIVE_CONNECT", "ACTIVE"};
    static final long STANDBY_FAILURE_DETECT_RETRY_INTERVAL = 1000L;
    static final byte INIT_CONVERT = 1;
    static final byte FINAL_CONVERT = 2;
    static final byte NEW_CHANNEL = 3;
    static final byte LAST_MESSAGE = 4;
    static final byte LAST_MESSAGE_REPLY = 5;
    static final byte FIRST_MESSAGE = 6;
    static final byte FIRST_MESSAGE_REPLY = 7;
    private static final long KNUTH = 2654435761L;
    private static final Random s_random = new Random(-System.currentTimeMillis());
    private static long s_token = s_random.nextLong();
    private long m_remoteId;
    private long m_connectId;
    private Thread m_conversionThread;
    private long m_convertToken;
    private ReplicationConnection m_connection = null;
    private ReplicationSessionContext m_sessionContext = null;
    private Object m_sessionContextLock = new Object();
    private int m_conversionState;
    private long m_failureDetectTimeout = -1L;
    private AgentRegistrar m_reg = null;
    private ReplicationManager m_rm = null;
    private ReplicationChannel m_passiveConvertChannel = null;
    private boolean m_remoteAdminShutdown = false;
    Thread m_standbyPinger = null;
    private FailureDetectCallback m_failureDetectCallback = null;
    private boolean m_remoteAdminDisconnected = false;
    private boolean m_newChannelAvailable = false;
    private Object m_waitForRetry = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long generateToken() {
        Random random = s_random;
        synchronized (random) {
            while ((s_token *= 2654435761L) == 0L) {
            }
            return s_token;
        }
    }

    ConnectionManager(ReplicationManager rm) throws Exception {
        super(DebugState.GLOBAL_DEBUG_ON ? "ConnectionManager" : null);
        this.m_rm = rm;
        this.m_reg = AgentRegistrar.getAgentRegistrar();
        this.m_connectId = AddrUtil.stringToClientId(Config.BROKER_NAME, "FailoverBroker connect");
        try {
            if (Config.FT_FAILURE_DETECT_CALLBACK != null) {
                this.setFailureDetectCallback((FailureDetectCallback)Class.forName(Config.FT_FAILURE_DETECT_CALLBACK).newInstance());
                if (this.DEBUG) {
                    this.debug("successfully installed FT_FAILURE_DETECT_CALLBACK " + Config.FT_FAILURE_DETECT_CALLBACK);
                }
            }
        }
        catch (Exception ex) {
            if (this.DEBUG) {
                this.debug(ex.toString(), ex);
            }
            Object[] params = new Object[]{Config.FT_FAILURE_DETECT_CALLBACK};
            String msg = MessageFormat.format(prAccessor.getString("FAILURE_DETECT_CALLBACK_NOT_REGISTERED"), params);
            BrokerComponent.getComponentContext().logMessage(msg, 2);
        }
        this.prepareForPassiveConvert();
    }

    private void prepareForPassiveConvert() throws EGeneralException {
        MessageHandler mh = new MessageHandler();
        mh.setName("FTConnectionManager msg handler");
        mh.bind(FailoverConfig.addPrefix("CONVERT"), (IMessageHandler)new PassiveConvertHandler(this));
        this.m_reg.getAdminConnection().addMessageHandler(mh);
        Label local = new Label();
        local.setRouteLimit(1);
        this.m_reg.getAdminSession().submitSubscription(FailoverConfig.addPrefix("CONVERT"), local).start();
    }

    IMgram buildInitConvertRequest(int channel, long token) {
        byte[] data = new byte[4];
        ArrayUtil.writeInt(data, 0, FailoverConfig.RM_APPID_SCODE);
        return this.buildConvertRequest(channel, token, (byte)1, data);
    }

    IMgram buildFinalConvertRequest(int channel, long token) {
        return this.buildConvertRequest(channel, token, (byte)2, null);
    }

    IMgram buildNewChannelRequest(int channel, long token, long nounce) {
        byte[] data = new byte[8];
        ArrayUtil.writeLong(data, 0, nounce);
        return this.buildConvertRequest(channel, token, (byte)3, data);
    }

    IMgram buildFirstMessageRequest(long token, Vector pendingRequests) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bos);
        data.writeInt(pendingRequests.size());
        Iterator iter = pendingRequests.iterator();
        while (iter.hasNext()) {
            data.writeLong((Long)iter.next());
        }
        bos.close();
        return this.buildConvertRequest(0, token, (byte)6, bos.toByteArray());
    }

    IMgram buildFirstMessageReply(long token, long LMR, long[] DNR) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bos);
        data.writeLong(LMR);
        data.writeInt(DNR.length);
        for (int i = 0; i < DNR.length; ++i) {
            data.writeLong(DNR[i]);
        }
        bos.close();
        return this.buildConvertRequest(0, token, (byte)7, bos.toByteArray());
    }

    IMgram buildLastMessageRequest(long token) {
        return this.buildConvertRequest(0, token, (byte)4, null);
    }

    IMgram buildLastMessageReply(long token) {
        return this.buildConvertRequest(0, token, (byte)5, null);
    }

    private IMgram buildConvertRequest(int channel, long token, byte subType, byte[] data) {
        IMgram request = MgramFactory.getMgramFactory().createMgram(true);
        request.setType((byte)22);
        request.setRequestReplySend();
        request.setChannel(channel);
        byte[] body = new byte[9 + (data == null ? 0 : data.length)];
        ArrayUtil.writeLong(body, 0, token);
        body[8] = subType;
        if (data != null) {
            System.arraycopy(data, 0, body, 9, data.length);
        }
        request.setBody(body);
        return request;
    }

    ReplicationManager getReplicationManager() {
        return this.m_rm;
    }

    long getConnectID() {
        return this.m_connectId;
    }

    synchronized boolean isActive() {
        return this.m_conversionState == 5;
    }

    synchronized long getRemoteID() {
        return this.m_remoteId;
    }

    synchronized void setRemoteID(long id) {
        this.m_remoteId = id;
        this.m_rm.setRemoteID(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSessionContext(ReplicationConnection conn) {
        Object object = this.m_sessionContextLock;
        synchronized (object) {
            this.m_sessionContext = conn.getSessionContext();
            this.m_sessionContextLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetSessionContext() {
        Object object = this.m_sessionContextLock;
        synchronized (object) {
            this.m_connection = null;
            this.m_sessionContext = null;
            this.m_sessionContextLock.notifyAll();
        }
    }

    ReplicationSessionContext acquireSessionContext() {
        ReplicationSessionContext ctx = null;
        try {
            ctx = this.acquireSessionContext(false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplicationSessionContext acquireSessionContext(boolean wait) throws InterruptedException {
        if (!wait) {
            return this.m_sessionContext;
        }
        Object object = this.m_sessionContextLock;
        synchronized (object) {
            while (this.m_sessionContext == null) {
                try {
                    if (this.DEBUG) {
                        this.debug(Thread.currentThread() + ": session context not available, waiting...");
                    }
                    this.m_sessionContextLock.wait();
                }
                catch (InterruptedException ex) {
                    if (this.DEBUG) {
                        this.debug(Thread.currentThread() + ": interrupted, connection state = " + state[this.m_conversionState]);
                    }
                    throw ex;
                }
            }
            return this.m_sessionContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateSessionContext(ReplicationSessionContext ctx) {
        if (ctx == null) {
            return false;
        }
        if (Broker.isInShutdown()) {
            return false;
        }
        Object object = this.m_sessionContextLock;
        synchronized (object) {
            if (ctx == this.m_sessionContext) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSocket(ISocket socket, String channelName) throws IOException {
        if (this.DEBUG) {
            this.debug("handleSocket() - new socket connection accepted, channel = " + channelName);
        }
        socket.startTransportHandshake();
        ReplicationChannel channel = ReplicationChannel.getChannel(channelName);
        if (channel == null || !channel.isValid()) {
            if (this.DEBUG) {
                this.debug("handleSocket() - closing accepted socket, channel " + channelName + " invalid.");
            }
            socket.close();
            return;
        }
        if (channel.isConnected()) {
            if (this.DEBUG) {
                this.debug("handleSocket() - channel " + channelName + " is active - closing accepted socket and ping the channel.");
            }
            if (!channel.pingIfAlive(ReplicationConnection.s_heartbeat) && channel.reset() && !this.m_rm.isShuttingDown()) {
                this.m_rm.onDisconnect(channel);
                if (this.getConnection() != null) {
                    channel.startConnectThread();
                }
            }
            socket.close();
            return;
        }
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.m_conversionState == 5) {
                if (this.DEBUG) {
                    this.debug("handleSocket() - activate channel " + channelName + " with current session context.");
                }
                channel.passiveConnect(socket, ProgressSecureRandom.theSecureRandom().nextLong(), this.acquireSessionContext());
                return;
            }
            if (this.m_passiveConvertChannel == null) {
                this.callBackBeforePassiveConnect(channel, socket);
                this.m_passiveConvertChannel = channel;
                new AgentConnection(socket, ProgressSecureRandom.theSecureRandom().nextLong()).startListener();
                if (this.DEBUG) {
                    this.debug("handleSocket() - starting listener ");
                }
                return;
            }
            while (this.m_conversionState != 5 && this.m_conversionState != 0) {
                if (this.DEBUG) {
                    this.debug("handleSocket() - conversion already in progress w/ channel " + this.m_passiveConvertChannel.getName() + ", wait until the previous attempt to succeed or fail.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    socket.close();
                    return;
                }
            }
            this.callBackBeforePassiveConnect(channel, socket);
            if (this.m_conversionState == 0) {
                this.m_passiveConvertChannel = channel;
                new AgentConnection(socket, ProgressSecureRandom.theSecureRandom().nextLong()).startListener();
                return;
            }
            if (channel.isConnected()) {
                if (this.DEBUG) {
                    this.debug("handleSocket() - closing accepted socket and the newly converted channel, channel " + channelName + " still active.");
                }
                socket.close();
                channel.close();
                return;
            }
            channel.passiveConnect(socket, ProgressSecureRandom.theSecureRandom().nextLong(), this.acquireSessionContext());
            return;
        }
    }

    private void callBackBeforePassiveConnect(ReplicationChannel channel, ISocket socket) {
        if (this.CALLBACK) {
            this.callback(state[this.m_conversionState], 1, new Object[]{channel, socket, this});
        }
    }

    synchronized void passiveConnect() throws EConnectFailure {
        if (this.m_passiveConvertChannel == null || !this.m_passiveConvertChannel.isValid()) {
            this.debugRejectedPassiveConnect();
            throw new EConnectFailure(179, SessionConfig.IB_CONNECT_REFUSED);
        }
        if (this.m_conversionState != 0) {
            this.debugRejectedPassiveConnect();
            throw new EUserAlreadyConnected(this.toString());
        }
        this.m_conversionState = 1;
        if (this.DEBUG) {
            this.debug("state changed to PASSIVE_CONNECT by thread " + Thread.currentThread());
        }
    }

    private void debugRejectedPassiveConnect() {
        if (this.DEBUG) {
            this.debug("rejected passive connect, state is " + state[this.m_conversionState]);
        }
        this.m_passiveConvertChannel = null;
    }

    synchronized long passiveConvert() {
        if (!this.m_passiveConvertChannel.isValid() || this.m_conversionState != 1 && this.m_conversionState != 2) {
            if (this.DEBUG) {
                this.debug("attempted passive convert rejected, thread " + Thread.currentThread());
            }
            return 0L;
        }
        long token = 0L;
        while ((token = ConnectionManager.generateToken()) == 0L) {
        }
        this.m_convertToken = token;
        this.m_conversionState = 2;
        if (this.DEBUG) {
            this.debug("state changed to PASSIVE_CONVERT by thread " + Thread.currentThread() + ", returning token " + token);
        }
        return token;
    }

    synchronized boolean okToConvert(long token, byte op, long cid) {
        boolean ok = false;
        if (this.m_passiveConvertChannel != null && this.m_passiveConvertChannel.isValid() && token == this.m_convertToken) {
            if (op == 1 && this.m_conversionState == 2 && cid == this.m_connectId) {
                ok = true;
            } else if (op == 2 && this.m_conversionState == 3 && cid == this.m_remoteId) {
                ok = true;
            }
        }
        if (this.DEBUG && !ok) {
            this.debug("okToConvert() returned false to thread " + Thread.currentThread() + ", state = " + state[this.m_conversionState] + ", requested op = " + (op == 1 ? "INIT_CONVERT" : "FINAL_CONVERT") + ", received token = " + token + " and expected token = " + this.m_convertToken);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void convertEvent(AgentConnection conn, IMgram m) throws EUnexpectedMgram, EGeneralException, IOException {
        long token;
        byte op = -1;
        try {
            byte[] body = m.getRawBody();
            token = ArrayUtil.readLong(body, 0);
            op = body[8];
        }
        catch (IndexOutOfBoundsException e) {
            if (this.DEBUG) {
                this.debug("invalid convert request.", e);
            }
            throw new EUnexpectedMgram(m);
        }
        if (op >= 4) {
            ConnectionManager e = this;
            synchronized (e) {
                if (this.m_connection != null) {
                    this.m_connection.handleChannelSwitch(conn, op, m);
                }
            }
            return;
        }
        long cid = conn.getSecurityContext(m.getChannel()).getClientId();
        if (!this.okToConvert(token, op, cid)) {
            throw new EUnexpectedMgram(m);
        }
        if (this.DEBUG) {
            this.debug("starting " + (op == 1 ? "initial passive convert" : "final passive convert"));
        }
        if (op == 1) {
            this.initConvert(conn, m);
        } else if (op == 2) {
            this.finalConvert();
        }
    }

    String setRemoteAppID(int appid) {
        String remoteAppid = null;
        if (appid == FailoverConfig.RM_PRIMARY_APPID_SCODE) {
            remoteAppid = "PRIMARY";
        } else if (appid == FailoverConfig.RM_BACKUP_APPID_SCODE) {
            remoteAppid = "BACKUP";
        }
        if (this.DEBUG) {
            this.debug("remote appid = " + remoteAppid);
        }
        if (FailoverConfig.RM_APPID.equals(remoteAppid)) {
            throw new EAssertFailure("remote and local broker were both configured as " + remoteAppid);
        }
        this.setRemoteID(AddrUtil.stringToClientId(Config.BROKER_NAME, remoteAppid));
        return remoteAppid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicationConnection getConnection() {
        Object object = this.m_sessionContextLock;
        synchronized (object) {
            return this.m_connection;
        }
    }

    private void initConvert(AgentConnection old_con, IMgram m) {
        this.m_conversionState = 3;
        if (this.DEBUG) {
            this.debug("state changed to CONVERT_IN_PROGRESS by thread " + Thread.currentThread());
        }
        byte[] body = m.getRawBody();
        int appid = ArrayUtil.readInt(body, 9);
        String remoteAppid = this.setRemoteAppID(appid);
        long old_cid = old_con.getSecurityContext(m.getChannel()).getClientId();
        ClientSecurityContext csc = (ClientSecurityContext)old_con.getSecurityContext(m.getChannel()).clone();
        csc.setAppid(remoteAppid);
        ReplicationSessionContext sc = new ReplicationSessionContext(this.m_convertToken, old_con.getAgentListener().getClientSessionVer(), csc, old_con.getPartnerProductVersion());
        boolean ok = this.m_passiveConvertChannel.connect(old_con.getSocket(), old_con.getSocketId(), sc, true);
        if (!ok) {
            if (this.DEBUG) {
                this.debug("passive convert failed to activate the channel, channel = " + this.m_passiveConvertChannel.getName());
            }
            this.abortConvert();
            old_con.close();
            return;
        }
        this.m_passiveConvertChannel.getAgentListener().copyInputStreams(old_con.getAgentListener());
        try {
            if (this.DEBUG) {
                this.debug("passive convert returning FT_CONVERT mgram to pause the peer broker's listener, channel = " + this.m_passiveConvertChannel.getName());
            }
            this.m_reg.getClient(old_cid).sendThrough(m);
            if (this.DEBUG) {
                this.debug("passive convert returned FT_CONVERT mgram to pause the peer broker's listener, channel = " + this.m_passiveConvertChannel.getName());
            }
            this.m_reg.prepareDisconnect(old_cid, 5);
            this.m_reg.disconnect(old_cid, true);
            try {
                this.m_reg.connect(this.getRemoteID(), this.getConnection(), false);
                this.getConnection().setRemoteCC(AgentRegistrar.getAgentRegistrar().getClient(this.getRemoteID()));
            }
            catch (InterruptedException e) {
                if (!Broker.exiting) {
                    throw new EInterrupted();
                }
            }
        }
        catch (Exception e) {
            if (this.DEBUG) {
                this.debug("passive convert failed, channel = " + this.m_passiveConvertChannel.getName() + " : " + e, e);
            }
            this.abortConvert();
            old_con.close();
            ReplicationConnection connection = this.getConnection();
            if (connection != null) {
                connection.close();
            }
            throw new ThreadDeath();
        }
        if (this.DEBUG) {
            this.debug("passive convert starting new listener " + this.m_passiveConvertChannel);
        }
        this.m_passiveConvertChannel.startListener();
        if (this.DEBUG) {
            this.debug("passive convert stopping old listener " + Thread.currentThread());
        }
        throw new ThreadDeath();
    }

    private void finalConvert() {
        try {
            this.activate();
            this.postConnect();
        }
        catch (Exception e) {
            if (this.DEBUG) {
                this.debug("unable to start new sender: " + e, e);
            }
            this.abortConvert();
            throw new ThreadDeath();
        }
    }

    void logConnect(ReplicationChannel channel) {
        String versionText = "";
        VersionData remoteVersion = channel.getSessionContext().getPartnerProductVersion();
        if (!SessionConfig.getCurrentVersionData().equals(remoteVersion)) {
            versionText = " (" + VersionData.getReleaseAndBuildString(remoteVersion, "Release Unknown") + ")";
        }
        Object[] params = new Object[]{Config.PRIMARY ? "BACKUP" : "PRIMARY", versionText, channel.getName(), channel.getRemoteURL()};
        String msg = MessageFormat.format(prAccessor.getString("CONNECTED_TO_PEER"), params);
        BrokerComponent.getComponentContext().logMessage(msg, 3);
    }

    void logDisconnect(ReplicationChannel channel) {
        Object[] params = new Object[]{Config.PRIMARY ? "BACKUP" : "PRIMARY", channel.getName(), channel.getRemoteURL()};
        String msg = MessageFormat.format(prAccessor.getString("DISCONNECTED_FROM_PEER"), params);
        BrokerComponent.getComponentContext().logMessage(msg, 2);
    }

    synchronized void activate() throws EGeneralException, IOException {
        if (this.m_conversionState != 3 && this.m_conversionState != 4) {
            throw new EAssertFailure("Invalid state for activate: " + this + ", " + state[this.m_conversionState]);
        }
        this.activateInternal(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void activateInternal(boolean resume) throws EGeneralException, IOException {
        if (this.DEBUG) {
            this.debug("activate() - changing connection state to ACTIVE by " + Thread.currentThread());
        }
        this.m_conversionState = 5;
        this.m_passiveConvertChannel = null;
        this.m_remoteAdminDisconnected = false;
        this.m_remoteAdminShutdown = false;
        this.m_failureDetectTimeout = -1L;
        this.notifyAll();
        Object object = this.m_waitForRetry;
        synchronized (object) {
            this.m_waitForRetry.notifyAll();
        }
        this.m_connection.start();
        if (this.DEBUG) {
            this.debug("activate() - connecting the remaining channels w/ the newly established session context.");
        }
        this.setSessionContext(this.m_connection);
        ReplicationChannel.startChannels();
    }

    synchronized void postConnect() throws EGeneralException {
        if (this.DEBUG) {
            this.debug("inform RM to start post-connect processing including the role resolution.");
        }
        this.m_rm.postConnect(this.m_connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newChannel(ReplicationChannel channel) throws IOException, InterruptedException {
        if (this.DEBUG) {
            this.debug("channel " + channel.getName() + " connected, conversion state = " + state[this.m_conversionState]);
        }
        BrokerManagementNotificationsHelper.sendReplicateConnectionConnectNotification(channel.getName(), channel.getPrimaryAddr(), channel.getPrimaryPort(), channel.getBackupAddr(), channel.getBackupPort(), channel.getWeight());
        this.logConnect(channel);
        Object object = this.m_sessionContextLock;
        synchronized (object) {
            if (this.m_connection == null) {
                if (this.DEBUG) {
                    this.debug("creating a new connection with channel " + channel);
                }
                this.m_connection = new ReplicationConnection(channel, this);
            } else {
                boolean resumed = this.m_connection.onNewChannel(channel);
                if (resumed) {
                    this.stopStandbyConnectionPinger();
                    this.m_rm.onReplicationResume();
                }
                if (this.DEBUG) {
                    this.debug("adding new channel " + channel + (resumed ? ", replication resumed" : ""));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean disconnect(ReplicationChannel channel) {
        if (this.DEBUG) {
            this.debug("channel " + channel.getName() + " disconnecting, connect state = " + state[this.m_conversionState]);
        }
        BrokerManagementNotificationsHelper.sendReplicateConnectionDisconnectNotification(channel.getName(), channel.getPrimaryAddr(), channel.getPrimaryPort(), channel.getBackupAddr(), channel.getBackupPort(), channel.getWeight());
        this.logDisconnect(channel);
        boolean replicating = false;
        ReplicationConnection disconnectedConnection = null;
        Object object = this.m_sessionContextLock;
        synchronized (object) {
            if (this.m_connection == null) {
                return false;
            }
            if (!channel.isValid() || channel.isAdminShutdown()) {
                this.m_remoteAdminDisconnected = true;
            }
            if (this.m_connection.onDisconnect(channel)) {
                replicating = false;
                disconnectedConnection = this.m_connection;
            } else {
                replicating = this.m_connection.isActive();
                if (!(replicating || this.m_rm.getBrokerState() != 6 || this.isRemoteAdminShutdown() || this.isRemoteAdminDisconnected())) {
                    this.startStandbyConnectionPinger();
                }
            }
        }
        if (!replicating && disconnectedConnection != null) {
            disconnectedConnection.unregisterCC();
            this.disconnectInternal();
        }
        return replicating;
    }

    private void startStandbyConnectionPinger() {
        Runnable runner = new Runnable(){
            long timer = 60000L;
            long stopTime = System.currentTimeMillis() + this.timer;

            @Override
            public void run() {
                block6: {
                    try {
                        if (ConnectionManager.this.DEBUG) {
                            ConnectionManager.this.debug("replication stopped, waiting " + this.timer + " ms before transitioning from " + BrokerStatus.State.get(ConnectionManager.this.m_rm.getBrokerState()) + " to WAITING");
                        }
                        Thread.sleep(this.timer);
                        if (ReplicationChannel.getActiveChannelCount() > 0) {
                            if (ConnectionManager.this.DEBUG) {
                                ConnectionManager.this.debug("replication stopped, transitioning from " + BrokerStatus.State.get(ConnectionManager.this.m_rm.getBrokerState()) + " to WAITING, active channel count = " + ReplicationChannel.getActiveChannelCount());
                            }
                            ConnectionManager.this.m_rm.setBrokerState(4);
                        }
                    }
                    catch (InterruptedException e) {
                        if (Thread.currentThread() == ConnectionManager.this.m_standbyPinger) break block6;
                        if (ConnectionManager.this.DEBUG) {
                            ConnectionManager.this.debug("timer for transitioning broker from STANDBY to WAITING canceled, active channel count = " + ReplicationChannel.getActiveChannelCount());
                        }
                        return;
                    }
                }
            }
        };
        this.m_standbyPinger = new Thread(runner);
        this.m_standbyPinger.setDaemon(true);
        this.m_standbyPinger.start();
    }

    private void stopStandbyConnectionPinger() {
        Thread t = this.m_standbyPinger;
        this.m_standbyPinger = null;
        if (t != null) {
            t.interrupt();
        }
    }

    private synchronized void disconnectInternal() {
        if (this.DEBUG) {
            this.debug("disconnecting the replication connection...");
        }
        this.stopStandbyConnectionPinger();
        this.m_failureDetectTimeout = -1L;
        if (this.m_rm.getBrokerState() == 6 && !this.isRemoteAdminShutdown() && !this.isRemoteAdminDisconnected()) {
            this.m_failureDetectTimeout = System.currentTimeMillis() + Config.FT_FAILURE_DETECT_TIMEOUT;
        }
        this.resetData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void newChannelWeight(ReplicationChannel channel) {
        if (this.DEBUG) {
            this.debug("channel " + channel + ", new weight = " + channel.getWeight());
        }
        Object object = this.m_sessionContextLock;
        synchronized (object) {
            if (this.m_connection != null) {
                int ret = this.m_connection.onWeightChange(channel);
                if (ret < 0) {
                    if (this.DEBUG) {
                        this.debug("replication ceased due to weight change on the last active channel - " + channel.getName());
                    }
                    this.m_remoteAdminDisconnected = true;
                    this.m_rm.onReplicationStop();
                } else if (ret > 0) {
                    if (this.DEBUG) {
                        this.debug("replication resumes due to weight change on channel " + channel.getName());
                    }
                    this.stopStandbyConnectionPinger();
                    this.m_rm.onReplicationResume();
                }
            }
        }
    }

    synchronized void abortConvert() {
        if (this.DEBUG) {
            this.debug("abortConvert() - state changed to DISCONNECTED by thread " + Thread.currentThread() + " old state= " + state[this.m_conversionState]);
        }
        this.m_passiveConvertChannel = null;
        this.resetData();
    }

    synchronized void abortConnect() {
        if (this.m_conversionState == 1 || this.m_conversionState == 2) {
            this.abortConvert();
        }
    }

    void setRemoteBrokerState(boolean isPeerActive, int peerRecoveredState, boolean peerHasClientConnected, long peerConnectionCount, long peerFailoverMetricsDifference) {
        this.m_rm.setRemoteBrokerState(isPeerActive, peerRecoveredState, peerHasClientConnected, peerConnectionCount, peerFailoverMetricsDifference);
    }

    void start() {
        if (this.m_conversionThread != null) {
            return;
        }
        if (this.DEBUG) {
            this.debug("FT_FAILURE_DETECT_TIMEOUT = " + Config.FT_FAILURE_DETECT_TIMEOUT);
            this.debug("FT_PING_INTERVAL = " + Config.FT_PING_INTERVAL);
            this.debug("FT_RETRY_INTERVAL = " + Config.FT_RETRY_INTERVAL);
            this.debug("FT_FAILURE_DETECT_CALLBACK = " + Config.FT_FAILURE_DETECT_CALLBACK);
        }
        this.m_conversionThread = new Thread((Runnable)this, this.getClass().getName());
        this.m_conversionThread.setDaemon(true);
        this.m_conversionThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        this.stopConversionThread();
        Object object = this.m_sessionContextLock;
        synchronized (object) {
            if (this.m_connection != null) {
                this.m_connection.stopChannelSwitchHandler();
            }
        }
        ReplicationChannel.shutdownChannels();
    }

    void stopConversionThread() {
        if (this.m_conversionThread == null) {
            return;
        }
        if (this.DEBUG) {
            this.debug("stopConversionThread: Stopping conversion thread... " + Thread.currentThread().getName());
        }
        Thread t = this.m_conversionThread;
        this.m_conversionThread = null;
        t.interrupt();
    }

    public void setFailureDetectCallback(FailureDetectCallback d) {
        this.m_failureDetectCallback = d;
    }

    @Override
    public boolean isPeerAlive() {
        if (this.DEBUG) {
            this.debug("isPeerAlive(): last active removed = " + this.m_remoteAdminDisconnected + ", active channel count = " + ReplicationChannel.getActiveChannelCount() + ", callback = " + (this.m_failureDetectCallback == null ? "null" : this.m_failureDetectCallback.getClass().getName()));
        }
        if (this.m_failureDetectCallback == null) {
            return false;
        }
        return this.m_failureDetectCallback.isPeerAlive();
    }

    void setRemoteAdminShutdown() {
        if (this.DEBUG) {
            this.debug("peer was being shut down administratively...");
        }
        this.m_remoteAdminShutdown = true;
    }

    boolean isRemoteAdminShutdown() {
        return this.m_remoteAdminShutdown;
    }

    boolean isRemoteAdminDisconnected() {
        return this.m_remoteAdminDisconnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newChannelAvailable() {
        Object object = this.m_waitForRetry;
        synchronized (object) {
            this.m_newChannelAvailable = true;
            this.m_waitForRetry.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplicationChannel[] waitForRetry(long interval, int count) throws InterruptedException {
        Object object = this.m_waitForRetry;
        synchronized (object) {
            if (this.m_newChannelAvailable) {
                this.m_newChannelAvailable = false;
                return ReplicationChannel.getChannels();
            }
            BrokerManagementNotificationsHelper.sendReplicationConnectionRetryNotification(Config.PRIMARY ? "PRIMARY" : "BACKUP", count, (int)(interval / 1000L));
            Object[] params = new Object[]{String.valueOf(interval)};
            String msg = MessageFormat.format(prAccessor.getString("REPLICATION_CONNECT_ATTEMPT_FAILED"), params);
            BrokerComponent.getComponentContext().logMessage(msg, 2);
            this.m_waitForRetry.wait(interval);
            this.m_newChannelAvailable = false;
            return ReplicationChannel.getChannels();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReplicationChannel[] getChannels() {
        Object object = this.m_waitForRetry;
        synchronized (object) {
            this.m_newChannelAvailable = false;
            return ReplicationChannel.getChannels();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convert() throws InterruptedException {
        BrokerComponent.getComponentContext().logMessage(prAccessor.getString("REPLICATION_CONNECT_ATTEMPT_START"), 3);
        long retryInterval = Config.FT_RETRY_INTERVAL;
        if (this.m_failureDetectTimeout > System.currentTimeMillis()) {
            retryInterval = Math.min(Config.FT_RETRY_INTERVAL, 1000L);
        }
        ReplicationChannel[] channels = this.getChannels();
        int index = 0;
        if (this.DEBUG) {
            this.debug("connecting all replication channels, # of channels = " + (channels != null ? channels.length : 0) + ", retry interval = " + retryInterval + ", failure detect timeout = " + this.m_failureDetectTimeout + ", current time = " + System.currentTimeMillis());
        }
        while (Thread.currentThread() == this.m_conversionThread) {
            int delayForSameChannel;
            DebugObject channel;
            block38: {
                DebugObject ch;
                if (channels == null || index == channels.length) {
                    if (this.m_failureDetectTimeout > 0L) {
                        long timeLeft = this.m_failureDetectTimeout - System.currentTimeMillis();
                        if (timeLeft <= 0L) {
                            if (this.DEBUG) {
                                this.debug("failure detect timeout expired at " + this.m_failureDetectTimeout + ", current time = " + System.currentTimeMillis());
                            }
                            this.m_failureDetectTimeout = -1L;
                            retryInterval = Config.FT_RETRY_INTERVAL;
                            if (this.isPeerAlive()) {
                                this.m_rm.setBrokerState(4);
                            } else if (this.m_rm.getBrokerState() == 6) {
                                this.m_rm.setBrokerState(1);
                            }
                        } else {
                            retryInterval = Math.min(timeLeft, retryInterval);
                        }
                    }
                    index = 0;
                    if ((channels = this.waitForRetry(retryInterval, channels == null ? 0 : channels.length)) == null) continue;
                    if (this.DEBUG) {
                        this.debug("connecting all replication channels, # of channel = " + channels.length);
                    }
                }
                channel = null;
                while (index < channels.length) {
                    ch = channels[index];
                    if (ch != null && ((ReplicationChannel)ch).isValid() && ((ReplicationChannel)ch).getWeight() != 0) {
                        if (((ReplicationChannel)ch).isPeerAddressAvailable()) {
                            channel = ch;
                            break;
                        }
                        String msg = "Skipping channel " + ((ReplicationChannel)ch).getName() + " - peer address not available";
                        BrokerComponent.getComponentContext().logMessage(msg, 3);
                    }
                    ++index;
                }
                ch = this;
                synchronized (ch) {
                    while (this.m_conversionState != 0) {
                        if (this.DEBUG) {
                            this.debug(Thread.currentThread() + ": stop active convert, state = " + state[this.m_conversionState]);
                        }
                        if (this.m_conversionState == 5 || this.m_conversionThread != Thread.currentThread()) {
                            return;
                        }
                        this.wait();
                    }
                    if (channel == null) {
                        continue;
                    }
                    if (this.CALLBACK) {
                        this.callback(state[this.m_conversionState], 0, new Object[]{channel, this});
                    }
                    this.m_conversionState = 4;
                }
                delayForSameChannel = 0;
                try {
                    ReplicationConnect con;
                    if (this.DEBUG) {
                        this.debug(Thread.currentThread() + ": connecting using channel " + ((ReplicationChannel)channel).getName() + " state changed to ACTIVE_CONNECT.");
                    }
                    if ((con = new ReplicationConnect((ReplicationChannel)channel, this)).convert()) {
                        return;
                    }
                }
                catch (EUserAlreadyConnected e) {
                    if (this.DEBUG) {
                        this.debug("connect collision, channel = " + ((ReplicationChannel)channel).getName(), e);
                    }
                    delayForSameChannel = (int)(10000.0 * (Math.random() + (Config.PRIMARY ? 0.5 : 0.0)));
                }
                catch (EBrokerVersionMismatch ebvm) {
                    if (this.DEBUG) {
                        this.debug("failed to connect, channel = " + ((ReplicationChannel)channel).getName() + " : " + ebvm, ebvm);
                    }
                }
                catch (EGeneralException e) {
                    if (!this.DEBUG) break block38;
                    this.debug("failed to connect, channel = " + ((ReplicationChannel)channel).getName() + " : " + e, e);
                }
            }
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                if (this.checkDebugFlags(64)) {
                    this.debug(Thread.currentThread() + ": state changed back to DISCONNECT.");
                }
                this.resetData();
            }
            if (delayForSameChannel > 0) {
                if (this.DEBUG) {
                    this.debug("sleeping for " + delayForSameChannel + " ms before connecting using the same channel, channel = " + ((ReplicationChannel)channel).getName());
                }
                Thread.sleep(delayForSameChannel);
                continue;
            }
            if (this.DEBUG) {
                this.debug("connecting using the next channel");
            }
            ++index;
        }
    }

    private void resetData() {
        this.m_conversionState = 0;
        this.resetSessionContext();
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingIfAlive() throws InterruptedException {
        while (Thread.currentThread() == this.m_conversionThread) {
            Object object = this.m_sessionContextLock;
            synchronized (object) {
                if (this.m_connection == null) {
                    return;
                }
                this.m_sessionContextLock.wait(Config.FT_PING_INTERVAL);
            }
            ReplicationConnection conn = this.getConnection();
            if (conn == null) continue;
            conn.pingIfAlive();
        }
    }

    @Override
    public void run() {
        if (this.checkDebugFlags(64)) {
            this.debug("Starting connect thread");
        }
        while (Thread.currentThread() == this.m_conversionThread) {
            try {
                this.convert();
                this.pingIfAlive();
            }
            catch (InterruptedException e) {
                if (this.m_conversionThread != Thread.currentThread()) {
                    if (this.DEBUG) {
                        this.debug(Thread.currentThread() + ": stopped.");
                    }
                    return;
                }
                this.m_conversionThread = null;
                e.printStackTrace();
            }
        }
    }

    boolean sendReplicationMgram(IMgram m) {
        return this.sendReplicationMgram(m, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendReplicationMgram(IMgram m, boolean nonstop) {
        boolean sentOk = false;
        int result = 2;
        int numWaits = 0;
        while (true) {
            Object object = this.m_sessionContextLock;
            synchronized (object) {
                if (this.m_connection != null) {
                    result = this.m_connection.sendReplicationMgram(m, nonstop, false);
                }
            }
            if (result != 3) break;
            result = 2;
            try {
                if (this.checkDebugFlags(64)) {
                    this.debug("sendReplicationMgram; need retry;  sleeping 2000");
                }
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                break;
            }
            numWaits = this.debugSendRelicationMGram(numWaits);
        }
        if (result == 1) {
            sentOk = true;
        }
        return sentOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendReplicationAck(IMgram ack) {
        int numWaits = 0;
        int result = 2;
        while (true) {
            Object object = this.m_sessionContextLock;
            synchronized (object) {
                if (this.m_connection != null) {
                    result = this.m_connection.sendReplicationAck(ack, false);
                }
            }
            if (result != 3) break;
            result = 2;
            try {
                if (this.checkDebugFlags(64)) {
                    this.debug("sendReplicationAck; need retry;  sleeping 2000");
                }
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                break;
            }
            numWaits = this.debugSendRelicationMGram(numWaits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rcvdReplicationAck(IMgram ack) {
        if (ack.isReply()) {
            this.rcvdReplicationReplyAck(ack);
        } else {
            long seqNo = ack.getAckHandle().getTrackingNumber();
            long tracking = -1L;
            Object object = this.m_sessionContextLock;
            synchronized (object) {
                if (this.m_connection != null) {
                    tracking = this.m_connection.rcvdReplicationAck(seqNo);
                }
            }
            if (tracking != -1L) {
                this.m_rm.onReplicationAck(tracking);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rcvdReplicationMgram(IMgram m) {
        Object object = this.m_sessionContextLock;
        synchronized (object) {
            if (this.m_connection != null) {
                this.m_connection.rcvdReplicationMgram(m);
            }
        }
        this.m_rm.onReplicatedMgram(m);
    }

    boolean sendReplicationRequest(IMgram m) {
        if (this.DEBUG) {
            this.debug("sending replication request, request tracking # = " + m.getGuarenteedTrackingNum());
        }
        return this.sendReplicationMgram(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean rcvdReplicationRequest(IMgram m) {
        if (BrokerStateManager.getBrokerStateManager().isActive()) {
            return this.rcvdReplicationReply(m);
        }
        boolean handled = false;
        if (this.DEBUG) {
            this.debug("rcvd replication request, request subject = " + m.getSubject() + ", request tracking = " + m.getGuarenteedTrackingNum());
        }
        boolean sent = false;
        IMgram ack = MgramFactory.getMgramFactory().buildAck(m.getGuarenteedTrackingNum(), (short)0, 0);
        Object object = this.m_sessionContextLock;
        synchronized (object) {
            if (this.m_connection != null) {
                if (this.DEBUG) {
                    this.debug("sending request ack, request tracking = " + m.getGuarenteedTrackingNum());
                }
                sent = this.sendReplicationMgram(ack, true);
            }
        }
        if (!sent) {
            if (this.DEBUG) {
                this.debug("failed to send replication request ack, request tracking = " + m.getGuarenteedTrackingNum());
            }
            return handled;
        }
        IRequestHandler handler = this.m_rm.getRequestHandler(m.getSubject().getSubjectString());
        if (handler != null) {
            handler.handleRequest(m);
            handled = true;
        } else if (this.DEBUG) {
            this.debug("no registered handler for replication request " + m.getSubject());
        }
        return handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendReplicationReply(IMgram m) {
        int numWaits = 0;
        if (this.DEBUG) {
            this.debug("sending replication reply, reply tracking # = " + m.getGuarenteedTrackingNum());
        }
        int result = 2;
        while (true) {
            Object object = this.m_sessionContextLock;
            synchronized (object) {
                if (this.m_connection != null) {
                    result = this.m_connection.sendReplicationReply(m, false);
                }
            }
            if (result != 3) break;
            result = 2;
            try {
                if (this.checkDebugFlags(64)) {
                    this.debug("sendReplicationReply; need retry;  sleeping 2000");
                }
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                break;
            }
            numWaits = this.debugSendRelicationMGram(numWaits);
        }
    }

    private int debugSendRelicationMGram(int numWaitsParam) {
        int numWaits = numWaitsParam;
        if (this.checkDebugFlags(64) && ++numWaits % 10 == 0) {
            this.debug("sendReplicationMgram; numwaits= " + numWaits + " ~" + numWaits * 2000 + " sec.");
        }
        return numWaits;
    }

    boolean rcvdReplicationReply(IMgram m) {
        boolean handled;
        if (this.DEBUG) {
            this.debug("rcvd replication reply, reply tracking # = " + m.getGuarenteedTrackingNum());
        }
        if (handled = this.m_rm.onReplicationReply(m)) {
            if (this.DEBUG) {
                this.debug("sending replication reply ack, reply tracking # = " + m.getGuarenteedTrackingNum());
            }
            boolean ackOk = false;
            IMgram ack = MgramFactory.getMgramFactory().buildAck(m.getGuarenteedTrackingNum(), (short)0, 0);
            ack.setRequestReplyReply();
            boolean bl = this.sendReplicationMgram(ack);
        }
        return handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rcvdReplicationReplyAck(IMgram ack) {
        long tracking = ack.getAckHandle().getTrackingNumber();
        if (this.DEBUG) {
            this.debug("rcvd replication reply ack, reply tracking # = " + tracking);
        }
        Object object = this.m_sessionContextLock;
        synchronized (object) {
            if (this.m_connection != null) {
                this.m_connection.rcvdReplicationReplyAck(tracking);
            }
        }
    }

    void validateSessionVer(byte negotiatedSessionVer) throws EBrokerVersionMismatch {
        if (!SessionConfig.isCAASessionVersionSupported(negotiatedSessionVer)) {
            if (this.checkDebugFlags(64)) {
                this.debug("validateSessionVer (passive side):  not supported: " + negotiatedSessionVer);
            }
            String msg = MessageFormat.format(progress.message.client.prAccessor.getString("CAA_BROKER_VERSION_MISMATCH"), Integer.toString(negotiatedSessionVer), Integer.toString(32));
            throw new EBrokerVersionMismatch(msg);
        }
        if (this.checkDebugFlags(64)) {
            this.debug("validateSessionVer (passive side):  isSupported: " + negotiatedSessionVer);
        }
    }

    boolean validateDirectionOfReplication(byte remoteSessionVer, VersionData remoteProductVers) throws EBrokerVersionMismatch {
        boolean isActive = this.m_rm.getRemoteStateSolicitator().resolveBrokerRole(true);
        return this.validateDirectionOfReplication(!isActive, (byte)32, SessionConfig.getCurrentVersionData(), remoteSessionVer, remoteProductVers);
    }

    boolean validateDirectionOfReplication(boolean localIsStandby, byte localSessionVer, VersionData localProductVers, byte negotiatedSessionVer, VersionData remoteProductVers) throws EBrokerVersionMismatch {
        boolean result = true;
        if (localIsStandby) {
            if (localSessionVer == negotiatedSessionVer) {
                this.validateVers(localProductVers, remoteProductVers, localSessionVer, negotiatedSessionVer);
                if (localProductVers.isLT(remoteProductVers)) {
                    result = false;
                }
            }
        } else if (localSessionVer > negotiatedSessionVer) {
            result = false;
        } else if (localSessionVer == negotiatedSessionVer) {
            this.validateVers(localProductVers, remoteProductVers, localSessionVer, negotiatedSessionVer);
            if (localProductVers.isGT(remoteProductVers)) {
                result = false;
            }
        }
        if (this.checkDebugFlags(64)) {
            this.debug("validateDirectionOfReplication:  localSessionVer= " + localSessionVer + " localProductVers= " + localProductVers + " peerSessionVer= " + negotiatedSessionVer + " remoteProductVers= " + remoteProductVers + " localIsStandby= " + localIsStandby + " result= " + result + " " + Thread.currentThread());
        }
        if (!result) {
            String remoteV = " (" + VersionData.getReleaseAndBuildString(remoteProductVers, "Release Unknown") + ")";
            String localV = " (" + VersionData.getReleaseAndBuildString(localProductVers, "Release Unknown") + ")";
            String msg = MessageFormat.format(progress.message.client.prAccessor.getString("CAA_REPL_DIRECTION_ERROR"), remoteV, localV);
            throw new EBrokerVersionMismatch(msg);
        }
        return result;
    }

    private void validateVers(VersionData localProductVers, VersionData remoteProductVers, byte localSessionVer, byte negotiatedSessionVer) throws EAssertFailure {
        if (localProductVers == null || remoteProductVers == null) {
            throw new EAssertFailure("validateDirectionOfReplication: productVers is Null:  localSessionVer= " + localSessionVer + " localProductVers= " + localProductVers + " remoteSessionVer= " + negotiatedSessionVer + " remoteProductVers= " + remoteProductVers);
        }
    }

    public byte selectSessionVer(byte defaultSessionVer, byte serverSessionVer) {
        byte selectedVer = 0;
        selectedVer = !SessionConfig.isCAASessionVersionSupported(serverSessionVer) ? SessionConfig.getLatestSupportedCAASessionVers() : serverSessionVer;
        if (this.checkDebugFlags(64)) {
            this.debug("selectSessionVer: Selected CAA SessionVer (active side)  ServerSessionVer= " + serverSessionVer + " selectedVer= " + selectedVer);
        }
        return selectedVer;
    }

    static {
        s_token *= System.currentTimeMillis();
    }
}

