/*
 * Decompiled with CFR 0.152.
 */
package progress.message.gr;

import com.sonicsw.mq.components.BrokerComponent;
import com.sonicsw.net.http.HttpDirectDispatchThreadPool;
import com.sonicsw.net.http.HttpRemoteBroker;
import com.sonicsw.ws.rm.common.RMManager;
import com.sonicsw.ws.util.WSAClusteringHelper;
import com.sonicsw.wsp.OperationContextManager;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.AgentRoutingQueue;
import progress.message.broker.Broker;
import progress.message.broker.BrokerStateManager;
import progress.message.broker.Config;
import progress.message.broker.IRemoteBroker;
import progress.message.broker.IStateListener;
import progress.message.broker.PendingQueue;
import progress.message.broker.PublishLimiterNotify;
import progress.message.broker.RoutingConnectionInfo;
import progress.message.client.EGeneralException;
import progress.message.client.EInauthenticClient;
import progress.message.client.EInterrupted;
import progress.message.client.EUserAlreadyConnected;
import progress.message.gr.DRAConnectTask;
import progress.message.gr.DRADispatchPendingTask;
import progress.message.gr.DRARemovePendingTask;
import progress.message.gr.DRAReroutePendingTask;
import progress.message.gr.DRAThreadPool;
import progress.message.gr.EAlreadyConnecting;
import progress.message.gr.ERouterAuthenticationFailure;
import progress.message.gr.IDRATask;
import progress.message.gr.ITaskCompletionListener;
import progress.message.gr.RemoteBroker;
import progress.message.gr.RouteForwarder;
import progress.message.gr.RouterManager;
import progress.message.gr.prAccessor;
import progress.message.msg.IMgram;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.DebugThread;
import progress.message.zclient.SessionConfig;

public class RemoteBrokerHelper
extends DebugObject
implements IStateListener {
    private AgentRegistrar m_reg = null;
    private RouterManager m_rtmgr = null;
    private RouteForwarder m_rtf = null;
    private Hashtable m_connectRequests = null;
    private Hashtable m_ineligibleRetryRequests = null;
    private Hashtable m_nodeUpdates = null;
    private RemoteBrokerConnectThread m_connectThread = null;
    private ConnectThreadMonitor m_monitorThread = null;
    private PublishLimiterNotify m_notifyLimiter;
    private ArrayList m_httpRemoteBrokers = null;
    private boolean m_isActive = false;
    private RetryInfoThread m_retryInfoThread = null;
    private boolean m_stopping = false;
    private static long s_pauseInterval = Config.CONNECT_ATTEMPT_INTERVAL;
    private static final ThreadLocal<SimpleDateFormat> DATE_PARSER_THREAD_LOCAL = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yy/MM/dd kk:mm:ss");
        }
    };
    private DRAThreadPool m_DRAThreadPool;
    private AsyncTaskControl m_asyncTaskControl;
    static boolean sync = false;
    private HttpDirectDispatchThreadPool m_httpDispatchThreadPool;
    private RMManager m_rmManager;
    private OperationContextManager m_ocManager;
    private WSAClusteringHelper m_wsaClusterSupport;

    public ArrayList getHttpRemoteBrokers() {
        return this.m_httpRemoteBrokers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHttpRemoteBroker(HttpRemoteBroker hrb) {
        ArrayList arrayList = this.m_httpRemoteBrokers;
        synchronized (arrayList) {
            this.m_httpRemoteBrokers.add(hrb);
            this.m_httpDispatchThreadPool.onHttpRemoteBrokerAdd(hrb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHttpRemoteBroker(HttpRemoteBroker hrb) {
        ArrayList arrayList = this.m_httpRemoteBrokers;
        synchronized (arrayList) {
            this.m_httpRemoteBrokers.remove(hrb);
            this.m_httpDispatchThreadPool.onHttpRemoteBrokerRemove(hrb);
        }
        hrb.disconnect(-1);
    }

    ConnectThreadMonitor getConnectThreadMonitor() {
        return this.m_monitorThread;
    }

    public HttpDirectDispatchThreadPool getHttpDispatchThreadPool() {
        return this.m_httpDispatchThreadPool;
    }

    public RMManager getRMManager() {
        return this.m_rmManager;
    }

    public RemoteBrokerHelper(AgentRegistrar reg, RouterManager rm, RouteForwarder rtf) {
        super(DebugState.GLOBAL_DEBUG_ON ? "RemoteBrokerHelper" : null);
        if (this.checkDebugFlags(64)) {
            this.debug("Constructed ");
        }
        this.m_connectRequests = new Hashtable();
        this.m_ineligibleRetryRequests = new Hashtable();
        this.m_nodeUpdates = new Hashtable();
        this.m_httpRemoteBrokers = new ArrayList();
        this.m_reg = AgentRegistrar.getAgentRegistrar();
        this.m_rtmgr = rm;
        this.m_rtf = rtf;
        this.m_rtf.setRemoteBrokerHelper(this);
        this.m_DRAThreadPool = new DRAThreadPool();
        this.m_asyncTaskControl = new AsyncTaskControl();
        this.m_notifyLimiter = new PublishLimiterNotify(this.m_connectRequests, "RemoteBrokerHelper.m_connectRequests");
    }

    AgentRoutingQueue getRoutingQueue() {
        return this.m_reg.getQueueProc().getRoutingQueue();
    }

    @Override
    public void stateChanging(int newState) {
    }

    @Override
    public void stateChanged(int newState) throws Exception {
        switch (newState) {
            case 1: {
                this.RBHActive();
                break;
            }
        }
    }

    private void RBHActive() {
        if (this.m_isActive) {
            return;
        }
        try {
            BrokerStateManager.getBrokerStateManager().waitForStatusChange(this.m_reg);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (Throwable t) {
            if (!Broker.exiting) {
                BrokerComponent.getComponentContext().logMessage(t, 2);
            }
            return;
        }
        this.m_stopping = false;
        this.m_isActive = true;
        long interval = Config.REMOTE_BROKER_MONITOR_INTERVAL * 1000;
        long reportTimeout = Config.REMOTE_BROKER_MONITOR_TIMEOUT * 1000;
        long abortTimeout = Config.REMOTE_BROKER_CONNECT_TIMEOUT * 1000;
        this.m_monitorThread = new ConnectThreadMonitor(interval, reportTimeout, abortTimeout);
        if (this.m_monitorThread != null) {
            this.m_monitorThread.start();
        }
        this.m_DRAThreadPool.start();
        if (Config.ENABLE_HTTP_DIRECT) {
            this.m_httpDispatchThreadPool = new HttpDirectDispatchThreadPool(this);
            if (this.m_httpDispatchThreadPool != null) {
                this.m_httpDispatchThreadPool.start();
            }
            this.m_rmManager = this.m_reg.getReliableSequenceMgr();
            if (this.m_rmManager != null) {
                this.m_rmManager.start();
            }
            this.m_ocManager = this.m_reg.getOperationContextMgr();
            if (this.m_ocManager != null) {
                this.m_ocManager.start();
            }
            this.m_wsaClusterSupport = this.m_reg.getWSAClusteringHelper();
            if (this.m_wsaClusterSupport != null) {
                this.m_wsaClusterSupport.start();
            }
        }
        this.m_connectThread = new RemoteBrokerConnectThread();
        if (this.m_connectThread != null) {
            this.m_connectThread.start();
        }
        this.m_retryInfoThread = new RetryInfoThread();
        if (this.m_retryInfoThread != null) {
            this.m_retryInfoThread.start();
        }
    }

    public void stopThreads() {
        this.m_stopping = true;
        if (this.m_retryInfoThread != null && this.m_retryInfoThread.isAlive()) {
            this.m_retryInfoThread.shutdown();
        }
        if (this.m_monitorThread != null && this.m_monitorThread.isAlive()) {
            this.m_monitorThread.shutdown();
        }
        if (this.m_connectThread != null && this.m_connectThread.isAlive()) {
            this.m_connectThread.shutdown();
        }
        if (this.m_DRAThreadPool != null) {
            this.m_DRAThreadPool.stopThreads();
        }
        if (this.m_httpDispatchThreadPool != null) {
            this.m_httpDispatchThreadPool.stopThreads();
        }
        if (this.m_ocManager != null) {
            this.m_ocManager.stop();
        }
        if (this.m_rmManager != null) {
            this.m_rmManager.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addConnectRequest(IRemoteBroker irb, RetryElem reParam) {
        RetryElem re = reParam;
        if (this.checkDebugFlags(16)) {
            this.debug("connectRequest: RemoteBroker connected = " + irb.isConnected());
        }
        if (irb.isConnected()) {
            this.wakeUpConnectThread();
            return true;
        }
        Hashtable hashtable = this.m_connectRequests;
        synchronized (hashtable) {
            if (!this.m_connectRequests.containsKey(irb)) {
                if (re == null) {
                    re = new RetryElem(System.currentTimeMillis() / 1000L);
                }
                this.m_connectRequests.put(irb, re);
            }
            this.wakeUpConnectThread();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryElem removeConnectRequest(IRemoteBroker irb) {
        if (this.checkDebugFlags(16)) {
            this.debug("removeConnectRequest: RemoteBroker connected = " + irb.isConnected());
        }
        RetryElem re = null;
        Hashtable hashtable = this.m_connectRequests;
        synchronized (hashtable) {
            if (!this.m_connectRequests.isEmpty()) {
                re = (RetryElem)this.m_connectRequests.remove(irb);
            }
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIneligibleRequest(IRemoteBroker irb) {
        boolean added = false;
        Hashtable hashtable = this.m_ineligibleRetryRequests;
        synchronized (hashtable) {
            RetryElem ere = (RetryElem)this.m_ineligibleRetryRequests.get(irb);
            if (ere == null) {
                ere = new RetryElem(System.currentTimeMillis() / 1000L);
                this.m_ineligibleRetryRequests.put(irb, ere);
                added = true;
                this.m_ineligibleRetryRequests.notifyAll();
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RetryElem removeIneligibleRequest(IRemoteBroker irb) {
        RetryElem re = null;
        Hashtable hashtable = this.m_ineligibleRetryRequests;
        synchronized (hashtable) {
            re = (RetryElem)this.m_ineligibleRetryRequests.remove(irb);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkOkToSend(IRemoteBroker irb) {
        boolean okToSend;
        PendingQueue pq = this.getRoutingQueue().getPendingQueue(irb.getPendingQueueName(), false);
        Hashtable hashtable = this.m_connectRequests;
        synchronized (hashtable) {
            okToSend = !this.getRoutingQueue().isRoutingQueueEmpty() ? false : (pq != null ? false : irb.isOkToSend(this.m_notifyLimiter));
            if (!okToSend) {
                if (this.checkDebugFlags(64)) {
                    this.debug("checkOkToSend: Creating PQ pq name: " + irb.getPendingQueueName() + " irb: " + irb);
                }
                this.getRoutingQueue().createEmptyPendingForIRB(irb);
                if (pq == null && !irb.isConnected()) {
                    if (this.checkDebugFlags(64)) {
                        this.debug("Adding connect request for newly created PQ pq name: " + irb.getPendingQueueName() + " irb: " + irb);
                    }
                    this.addConnectRequest(irb, null);
                }
            }
        }
        return okToSend;
    }

    public synchronized void route(IMgram m) throws InterruptedException {
        this.route(m, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void route(IMgram m, RetryElem retryElement) throws InterruptedException {
        IRemoteBroker irb;
        int[] dest = this.retrieveMatchVector(m);
        String node = this.retrieveNode(m);
        if (this.checkDebugFlags(16)) {
            this.debug("send(Mgram): dispatching mgram to node: " + node + ", destination: " + m.getSubject() + " sender: " + this.m_reg.getClientFullName(m.getBrokerHandle().getSenderID()));
        }
        if ((irb = this.selectRemoteBroker(node, dest, m)) == null) {
            if (this.checkDebugFlags(16)) {
                this.debug("send(Mgram): no RemoteBroker found for route node: " + node + ", destination: " + m.getSubject());
                this.debug("send(Mgram): putting mgram " + m.getGuarenteedTrackingNum() + " on the dead message queue");
            }
            int reason = node.equals(Config.ROUTING_NODE_NAME) ? 4 : 3;
            this.m_reg.getQueueProc().processUndelivered(m, reason, true);
            return;
        }
        if (this.getRoutingQueue().checkEnqueuePending(irb, m)) {
            if (this.checkDebugFlags(16)) {
                this.debugPendingQueues();
            }
            this.wakeUpConnectThread();
            return;
        }
        if (this.checkDebugFlags(16)) {
            this.debugPendingQueues();
        }
        boolean okToSend = false;
        Hashtable hashtable = this.m_connectRequests;
        synchronized (hashtable) {
            if (irb.isOkToSend(this.m_notifyLimiter)) {
                okToSend = true;
            } else {
                if (this.checkDebugFlags(8)) {
                    Date date = new Date(System.currentTimeMillis());
                    this.debug(date.getTime() + ", send(Mgram): not ok to send, irb " + irb.hashCode() + " is connected = " + irb.isConnected());
                }
                if (!m.isDiscardable()) {
                    this.getRoutingQueue().enqueuePending(irb, m);
                }
                if (!irb.isConnected()) {
                    this.getRoutingQueue().setPendingQueueDisconnected(irb.getPendingQueueName());
                    RetryElem re = retryElement != null ? (RetryElem)retryElement.clone() : null;
                    this.addConnectRequest(irb, re);
                } else {
                    this.getRoutingQueue().setPendingQueueFlowControlled(irb.getPendingQueueName());
                }
            }
        }
        if (okToSend) {
            irb.send(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteBroker selectRemoteBroker(String node, int[] dest, IMgram message) {
        RemoteBroker rb;
        IRemoteBroker irb = this.m_rtf.getRemoteBroker(node, dest, message, false);
        if (irb == null) {
            return null;
        }
        if (irb instanceof RemoteBroker && ((rb = (RemoteBroker)irb).hasConnectionTimedOut() || rb.isRegistered() && !rb.isConnected() && !rb.isConnecting()) && (irb = this.m_rtf.getRemoteBroker(node, dest, message, true)) == null) {
            return null;
        }
        PendingQueue pq = this.getRoutingQueue().getPendingQueue(irb.getPendingQueueName(), false);
        if (!irb.isConnected()) {
            boolean relookup = false;
            if (pq == null) {
                relookup = true;
            } else {
                boolean removeFlag = false;
                PendingQueue pendingQueue = pq;
                synchronized (pendingQueue) {
                    removeFlag = pq.getRemoveFlag();
                    if (removeFlag) {
                        relookup = true;
                    }
                }
            }
            if (relookup) {
                RemoteBroker rb2;
                irb = this.m_rtf.getRemoteBroker(node, dest, message, false);
                if (irb == null) {
                    return null;
                }
                if (irb instanceof RemoteBroker && (rb2 = (RemoteBroker)irb).hasConnectionTimedOut() && (irb = this.m_rtf.getRemoteBroker(node, dest, message, true)) == null) {
                    return null;
                }
            }
        }
        return irb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dispatchPendingQueue(IRemoteBroker irb) throws InterruptedException {
        if (this.checkDebugFlags(16)) {
            this.debug("send(IRemoteBroker): sending mgrams to RemoteBroker for node: " + irb.getNodeName() + ", hashcode = " + irb.hashCode());
        }
        int ct = 0;
        while (!this.getRoutingQueue().checkDeletePendingIfEmpty(irb.getPendingQueueName(), this.m_notifyLimiter)) {
            if (!irb.isOkToSend(this.m_notifyLimiter)) {
                if (this.checkDebugFlags(8)) {
                    Date date = new Date(System.currentTimeMillis());
                    this.debug(date.getTime() + ", send(irb): not ok to send, irb " + irb.hashCode() + " is connected = " + irb.isConnected());
                }
                if (this.DEBUG && ct > 0) {
                    this.debug("dispatchPendingQueue; notOkToSend; DispatchedSome " + ct + " queue= " + irb.getPendingQueueName());
                }
                return ct;
            }
            RemoteBrokerHelper remoteBrokerHelper = this;
            synchronized (remoteBrokerHelper) {
                IMgram m = this.getRoutingQueue().dequeuePending(irb.getPendingQueueName());
                if (m != null) {
                    irb.send(m);
                    ++ct;
                }
            }
        }
        if (this.checkDebugFlags(64)) {
            this.debug("dispatchPendingQueue: Completed dispatch; numLastBatch= " + ct + " queue= " + irb.getPendingQueueName());
        }
        return ct;
    }

    void markPendingQueueForMessageRemoval(IRemoteBroker irb, int reason, boolean notifyConnectThread) {
        PendingQueue pq = this.getRoutingQueue().getPendingQueue(irb.getPendingQueueName(), false);
        if (pq != null) {
            pq.setRemoveMessages(reason);
            if (notifyConnectThread) {
                this.wakeUpConnectThread();
            }
        }
    }

    int removePendingMsgs(IRemoteBroker irb, int reason) throws InterruptedException {
        if (irb == null) {
            return 0;
        }
        int ct = 0;
        while (!this.getRoutingQueue().checkDeletePendingIfEmpty(irb.getPendingQueueName(), this.m_notifyLimiter)) {
            IMgram m = this.getRoutingQueue().dequeuePending(irb.getPendingQueueName());
            if (m == null) continue;
            this.m_reg.getQueueProc().processUndelivered(m, reason, true);
            ++ct;
        }
        if (this.checkDebugFlags(64)) {
            this.debug("removePendingMsgs: removed " + ct + " messages; pqueue= " + irb.getPendingQueueName());
        }
        return ct;
    }

    private void clearConnectRequests(IRemoteBroker irb) {
        RetryElem re = this.removeConnectRequest(irb);
        RemoteBrokerHelper.clearOutRetryElem(re);
        re = this.removeIneligibleRequest(irb);
        RemoteBrokerHelper.clearOutRetryElem(re);
        re = null;
    }

    public int reroutePendingQueues(Vector queues, String destinationNodeName, String oldNodeName) throws InterruptedException {
        int ct = 0;
        for (String pendingQueueName : queues) {
            if (destinationNodeName.equals(oldNodeName)) {
                ct += this.reroutePendingMsgs(pendingQueueName, null);
                continue;
            }
            ct += this.reroutePendingSelective(pendingQueueName, destinationNodeName);
        }
        return ct;
    }

    public Vector getPendingQueuesToReroute(String destinationNodeName, String oldNodeName) {
        Vector<String> queues = new Vector<String>();
        for (String pendingQueueName : this.getRoutingQueue().getPendingQueueNames()) {
            boolean matches = !AgentRoutingQueue.isNeighborPendingQueue(pendingQueueName) ? pendingQueueName.equals(oldNodeName) : pendingQueueName.startsWith(oldNodeName);
            if (!matches) continue;
            IRemoteBroker irb = this.getRoutingQueue().getPendingRemoteBroker(pendingQueueName);
            if (irb != null) {
                this.clearConnectRequests(irb);
            }
            queues.add(pendingQueueName);
        }
        return queues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int reroutePendingSelective(String pendingQueueName, String rerouteNode) throws InterruptedException {
        boolean reroutedSomeMsgs = false;
        int ct = 0;
        int rerouted = 0;
        RemoteBrokerHelper remoteBrokerHelper = this;
        synchronized (remoteBrokerHelper) {
            PendingQueue old = this.getRoutingQueue().swapPendingQueue(pendingQueueName);
            if (old == null) {
                return ct;
            }
            IRemoteBroker irb = this.getRoutingQueue().getPendingRemoteBroker(pendingQueueName);
            while (!old.isEmpty()) {
                IMgram m = (IMgram)old.dequeue();
                if (m == null) continue;
                String node = m.getRoutingHandle().getRouting();
                if (node.equals(rerouteNode)) {
                    this.route(m);
                    reroutedSomeMsgs = true;
                    ++rerouted;
                } else {
                    this.getRoutingQueue().enqueuePending(irb, m);
                }
                ++ct;
            }
        }
        this.getRoutingQueue().checkDeletePendingIfEmpty(pendingQueueName, this.m_notifyLimiter, reroutedSomeMsgs);
        if (this.checkDebugFlags(64)) {
            this.debug("reroutePendingSelective processed " + ct + " messages; pqueue= " + pendingQueueName + " rerouted " + rerouted + " for Node= " + rerouteNode);
        }
        return ct;
    }

    public void rerouteUnacknowledged(Enumeration mgrams) {
        this.rerouteUnacknowledged(mgrams, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rerouteUnacknowledged(Enumeration mgrams, boolean preserveRedelivered) {
        Stack stack = new Stack();
        while (mgrams.hasMoreElements()) {
            Object mgram = mgrams.nextElement();
            stack.push(mgram);
        }
        RemoteBrokerHelper remoteBrokerHelper = this;
        synchronized (remoteBrokerHelper) {
            while (!stack.isEmpty()) {
                IMgram mgram = (IMgram)stack.pop();
                this.rerouteUnacknowledgedInternal(mgram, preserveRedelivered);
            }
        }
        this.wakeUpConnectThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rerouteUnacknowledged(IMgram mgram) {
        RemoteBrokerHelper remoteBrokerHelper = this;
        synchronized (remoteBrokerHelper) {
            this.rerouteUnacknowledgedInternal(mgram, true);
        }
        this.wakeUpConnectThread();
    }

    private void rerouteUnacknowledgedInternal(IMgram mgram, boolean preserveRedelivered) {
        int[] dest = this.retrieveMatchVector(mgram);
        String node = this.retrieveNode(mgram);
        IRemoteBroker irb = this.m_rtf.getRemoteBroker(node, dest, mgram, false);
        if (irb == null) {
            int reason = node.equals(Config.ROUTING_NODE_NAME) ? 4 : 3;
            this.m_reg.getQueueProc().getCleanupThread().addMsgForCleanup(mgram, reason);
            return;
        }
        this.getRoutingQueue().reenqueuePending(irb, mgram, preserveRedelivered);
    }

    private int[] retrieveMatchVector(IMgram m) {
        int[] dest = null;
        if (!m.isPubSub()) {
            dest = m.getSubject().getMatchVector();
        }
        return dest;
    }

    private String retrieveNode(IMgram m) {
        String node = m.getRoutingHandle().getRouting();
        if (node.equals("")) {
            node = Config.ROUTING_NODE_NAME;
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int reroutePendingMsgs(String pendingQueueName, RetryElem retryElement) throws InterruptedException {
        boolean reroutedSomeMsgs = false;
        int ct = 0;
        RemoteBrokerHelper remoteBrokerHelper = this;
        synchronized (remoteBrokerHelper) {
            int cto;
            PendingQueue old = this.getRoutingQueue().swapPendingQueue(pendingQueueName);
            if (old == null) {
                return ct;
            }
            if (this.checkDebugFlags(64) && (cto = old.getCurrentEnqueuedCountUnsynchronized()) > 0) {
                this.debug("reroutePendingMsgs starting; numToReroute= " + cto + " queue= " + pendingQueueName + " " + old.getDebugInfo());
            }
            while (!old.isEmpty()) {
                IMgram m = (IMgram)old.dequeue();
                if (m == null) continue;
                this.route(m, retryElement);
                reroutedSomeMsgs = true;
                ++ct;
            }
        }
        this.getRoutingQueue().checkDeletePendingIfEmpty(pendingQueueName, this.m_notifyLimiter, reroutedSomeMsgs);
        if (this.checkDebugFlags(64)) {
            this.debug("reroutePendingMsgs rerouted " + ct + " queue= " + pendingQueueName);
        }
        return ct;
    }

    public void notifyNodeUpdate(String destinationNodeName, String oldNodeName) {
        this.m_nodeUpdates.put(destinationNodeName, oldNodeName);
        this.wakeUpConnectThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selfNotify(String nodeName) {
        Hashtable hashtable = this.m_nodeUpdates;
        synchronized (hashtable) {
            boolean update = false;
            if (!this.m_nodeUpdates.isEmpty()) {
                String node = null;
                Enumeration enu = this.m_nodeUpdates.elements();
                while (enu.hasMoreElements()) {
                    node = (String)enu.nextElement();
                    if (!nodeName.equals(node)) continue;
                    update = true;
                    break;
                }
            }
            if (!update) {
                this.m_nodeUpdates.put(nodeName, nodeName);
            }
        }
        this.wakeUpConnectThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRemoteBroker switchToUnregisteredIRB(IRemoteBroker irb, boolean removePQIfNotFound) {
        boolean found = false;
        String currentNode = irb.getNodeName();
        Hashtable hashtable = this.m_nodeUpdates;
        synchronized (hashtable) {
            if (!this.m_nodeUpdates.isEmpty()) {
                Enumeration enu = this.m_nodeUpdates.elements();
                while (enu.hasMoreElements()) {
                    if (!currentNode.equals((String)enu.nextElement())) continue;
                    found = true;
                    break;
                }
            }
        }
        if (found) {
            return null;
        }
        if (irb.isConnected()) {
            return null;
        }
        IRemoteBroker diffIRB = this.m_rtf.getRemoteBroker(irb.getNodeName(), null, true);
        if (this.checkDebugFlags(16)) {
            this.debug("prepareRetry: orig irb hash = " + irb.hashCode());
            this.debug("prepareRetry: diff irb hash = " + diffIRB.hashCode());
        }
        if (diffIRB != null && diffIRB != irb) {
            this.getRoutingQueue().setPendingRemoteBroker(irb.getPendingQueueName(), diffIRB);
            if (this.checkDebugFlags(16)) {
                this.debug("prepareRetry: modifing RemoteBroker ref for pending messages from " + irb.getBrokerName() + " to " + diffIRB.getBrokerName());
            }
        } else {
            if (this.checkDebugFlags(16)) {
                if (diffIRB != null) {
                    this.debug("prepareRetry: diffIRB = " + diffIRB.hashCode() + ", irb = " + irb.hashCode() + " - if diffIRB null or equal to irb, that's really BAD!");
                } else {
                    this.debug("diffIRB is null.");
                }
            }
            if (diffIRB == null && removePQIfNotFound) {
                this.markPendingQueueForMessageRemoval(irb, 3, false);
            }
        }
        return diffIRB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareRetry(IRemoteBroker irbParam, RetryElem re) throws InterruptedException {
        IRemoteBroker irb = irbParam;
        if (this.checkDebugFlags(16)) {
            if (irb != null) {
                this.debug("prepareRetry: set up for a reconnect attempt, RemoteBroker irb = " + irb.getBrokerName() + ", hashcode = " + irb.hashCode() + " re= " + re);
            } else {
                this.debug("prepareRetry: irb is NULL");
            }
        }
        if (irb == null) {
            return;
        }
        if (re == null) {
            Hashtable hashtable = this.m_ineligibleRetryRequests;
            synchronized (hashtable) {
                RetryElem ere = (RetryElem)this.m_ineligibleRetryRequests.get(irb);
                if (ere == null) {
                    re = new RetryElem(System.currentTimeMillis() / 1000L);
                    this.m_ineligibleRetryRequests.put(irb, re);
                    this.m_ineligibleRetryRequests.notifyAll();
                }
            }
            return;
        }
        if (re.hasRoutingTimedOut()) {
            int lastUndeliveredReason;
            IRemoteBroker diffIRB;
            RemoteBroker rb;
            String node = null;
            node = irb != null ? (irb.getNodeName() != null ? irb.getNodeName() : "<unknown node>") : "<unknown node>";
            Object[] obj = new Object[]{Config.ROUTING_NODE_NAME, Config.BROKER_NAME, node};
            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTCONN_ROUTING_TIMEOUT"), obj), 2);
            if (this.checkDebugFlags(16)) {
                this.debug("prepareRetry: routing timeout period expired...");
            }
            if (!irb.isNeighbor() && (rb = (RemoteBroker)irb).isRegistered() && (diffIRB = this.switchToUnregisteredIRB(rb, false)) != null) {
                irb = diffIRB;
            }
            if ((lastUndeliveredReason = re.getLastUndeliveredReason()) == -1) {
                this.markPendingQueueForMessageRemoval(irb, 5, false);
            } else {
                this.markPendingQueueForMessageRemoval(irb, lastUndeliveredReason, false);
            }
            return;
        }
        re.clearLastUndeliveredReason();
        if (re.hasMadeMaxRetries()) {
            PendingQueue pq;
            if (this.checkDebugFlags(16)) {
                this.debug("prepareRetry: made max num of retry attempts for RemoteBroker  irb = " + irb.getBrokerName() + ", hashcode = " + irb.hashCode());
            }
            if (((pq = this.getRoutingQueue().getPendingQueue(irb.getPendingQueueName(), false)) == null || pq.isEmpty()) && !this.m_reg.getFlowControlManager().existBlockedClients(irb.getPendingQueueName())) {
                return;
            }
            if (irb.isNeighbor()) {
                re.resetRetryInfo();
                re.pauseOn();
                RemoteBrokerHelper obj = this;
                synchronized (obj) {
                    this.m_rtf.onRoutePathFailure(irb.getNodeName(), irb.getBrokerName());
                    this.reroutePendingMsgs(irb.getPendingQueueName(), re);
                }
                return;
            }
            IRemoteBroker diffIRB = this.switchToUnregisteredIRB(irb, true);
            if (diffIRB != null && diffIRB != irb) {
                re.resetRetryInfo();
                re.pauseOn();
                Hashtable hashtable = this.m_ineligibleRetryRequests;
                synchronized (hashtable) {
                    this.m_ineligibleRetryRequests.put(diffIRB, re);
                    this.m_ineligibleRetryRequests.notifyAll();
                }
                return;
            }
        } else {
            if (this.checkDebugFlags(16)) {
                this.debug("prepareRetry: update retry elem for RemoteBroker  irb = " + irb.getBrokerName() + ", hashcode = " + irb.hashCode());
            }
            re.updateRetryInfo(irb.getBrokerName());
            Hashtable hashtable = this.m_ineligibleRetryRequests;
            synchronized (hashtable) {
                this.m_ineligibleRetryRequests.put(irb, re);
                this.m_ineligibleRetryRequests.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUpConnectThread() {
        Hashtable hashtable = this.m_connectRequests;
        synchronized (hashtable) {
            this.m_connectRequests.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUpConnectThread(IRemoteBroker irb) {
        Hashtable hashtable = this.m_connectRequests;
        synchronized (hashtable) {
            if (this.m_connectThread != null && this.m_connectThread.isOkToWakeUp(irb)) {
                this.m_connectRequests.notifyAll();
            }
        }
    }

    private int debugPendingQueues() {
        PendingQueue tpq = null;
        Iterator it = this.getRoutingQueue().getPendingQueueNames().iterator();
        int ct = 0;
        while (it.hasNext()) {
            String nodeName = (String)it.next();
            tpq = this.getRoutingQueue().getPendingQueue(nodeName, false);
            ++ct;
            if (tpq == null || tpq.isEmpty()) continue;
            SessionConfig.logln("node = " + nodeName + ", pq " + tpq.hashCode() + " has " + tpq.getCurrentEnqueuedCountUnsynchronized() + " mgrams enqueued");
        }
        return ct;
    }

    void handleNeighbor(IRemoteBroker irb, RetryElem re) throws InterruptedException {
        block3: {
            if (!irb.isConnected()) {
                this.prepareRetry(irb, re);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ie) {
                    if (!Broker.exiting) break block3;
                    throw ie;
                }
            }
        }
    }

    void handleRemoteBroker(IRemoteBroker irb, RetryElem re) throws InterruptedException {
        if (irb == null) {
            return;
        }
        RemoteBroker rb = (RemoteBroker)irb;
        if (this.checkDebugFlags(16)) {
            this.debug("handleRemoteBroker: RemoteBroker rb = " + rb);
            if (rb != null) {
                this.debug("handleRemoteBroker: rb name = " + rb.getBrokerName() + ", rb hashcode = " + rb.hashCode() + ", connected = " + rb.isConnected() + ", connecting = " + rb.isConnecting() + ", registered = " + rb.isRegistered());
            } else {
                this.debug("handleRemoteBroker: rb is NULL");
            }
        }
        if (!rb.isConnected() && !rb.isConnecting()) {
            boolean successFlag = true;
            Object[] arr = new Object[]{rb};
            successFlag = !rb.isRegistered() ? this.handleUnregisteredRB(arr, re) : this.handleRegisteredRB(arr, re);
            rb = (RemoteBroker)arr[0];
            if (!successFlag) {
                this.m_reg.getGSManager().onFailedConnectInitiation(rb);
                return;
            }
            if (rb != null && !rb.isConnected()) {
                if (this.checkDebugFlags(16)) {
                    this.debug("handleRemoteBroker: adding a reconnect request after failed connect/reconnect attempt for registered RemoteBroker rb hashcode = " + rb.hashCode());
                }
                this.prepareRetry(rb, re);
            }
        } else if (rb.isConnecting()) {
            if (this.checkDebugFlags(16)) {
                Date date = new Date(System.currentTimeMillis());
                this.debug(date.getTime() + ", threadMain: rb " + rb.hashCode() + " in connecting state - prepare retry...");
            }
            this.prepareRetry(rb, re);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleUnregisteredRB(Object[] arr, RetryElem re) throws InterruptedException {
        RemoteBroker rb = (RemoteBroker)arr[0];
        boolean successFlag = true;
        try {
            if (this.checkDebugFlags(16)) {
                if (rb != null) {
                    this.debug("handleUnregisteredRB: before connect attempt, original RemoteBroker rb hashcode = " + rb.hashCode());
                } else {
                    this.debug("handleUnregisteredRB: before connect attempt, rb is NULL");
                }
            }
            if (this.m_monitorThread != null) {
                this.m_monitorThread.setMonitor(MessageFormat.format(prAccessor.getString("RTCONN_SET_MON"), rb.getNodeName()), re == null || !re.loggedConnectFailure());
            }
            RemoteBroker returnedRB = null;
            if (this.DEBUG) {
                this.debug("handleUnregisteredRB connecting to RemoteBroker " + rb.getNodeName() + "::" + rb.getBrokerName() + " connect url = " + rb.getConnectURL() + " info =  " + rb.getConnectInfo());
            }
            returnedRB = rb.connect(this.m_reg);
            if (this.checkDebugFlags(16)) {
                this.debug("handleUnregisteredRB: after connect attempt, original RemoteBroker rb = " + rb.getBrokerName() + ", hashcode = " + rb.hashCode() + ", registered = " + rb.isRegistered());
                this.debug("handleUnregisteredRB: after connect attempt, returned registered RemoteBroker returnedRB = " + returnedRB.getBrokerName() + ", hashcode = " + returnedRB.hashCode() + ", registered = " + returnedRB.isRegistered());
                this.debug("handleUnregisteredRB: the two should not be the same at this point...");
            }
            if (returnedRB != rb) {
                this.getRoutingQueue().setPendingRemoteBroker(rb.getPendingQueueName(), returnedRB);
                arr[0] = returnedRB;
                rb = returnedRB;
                String node = null;
                String broker = null;
                if (rb != null) {
                    node = rb.getNodeName();
                    broker = rb.getBrokerName();
                    if (rb.getConnectURL() != null) {
                        broker = broker + " (" + rb.getConnectURL() + ")";
                    }
                }
                Object[] obj = new Object[]{Config.ROUTING_NODE_NAME, Config.BROKER_NAME, node == null ? "<unknown node>" : node, broker == null ? "<unknown broker>" : broker};
                BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTCONN_SUCCESS"), obj), 3);
            } else if (this.checkDebugFlags(16)) {
                this.debug("handleUnregisteredRB: returned RB ref same as orig RB ref....bad!!!");
            }
        }
        catch (EAlreadyConnecting ace) {
            if (this.checkDebugFlags(16)) {
                this.debug("connect attempt on unregistered RemoteBroker - already connecting...", ace);
            }
            this.prepareRetry(rb, re);
            successFlag = false;
        }
        catch (EUserAlreadyConnected uace) {
            this.selfNotify(rb.getNodeName());
            successFlag = false;
        }
        catch (ERouterAuthenticationFailure rafe) {
            successFlag = this.prepareRetry(re, rb, rafe);
        }
        catch (EInauthenticClient ice) {
            RoutingConnectionInfo rci;
            String user = null;
            String node = null;
            if (rb != null && (rci = rb.getConnectInfo()) != null) {
                user = rci.getUserName();
                node = rci.getRoutingNodeName();
            }
            Object[] obj = new Object[]{user == null ? "<unknown user>" : user, node == null ? "<unknown node>" : node, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
            String msg = prAccessor.getString("RTAUTH_CONNECT_FAILED");
            successFlag = this.formatPopulateIndeliveredReasonAndRetry(msg, obj, re, rb, ice);
        }
        catch (EGeneralException ge) {
            if (ge instanceof EInterrupted && this.m_stopping) {
                throw new InterruptedException();
            }
            if (this.checkDebugFlags(16)) {
                this.debug("connect attempt on unregistered RemoteBroker threw exception...", ge);
            }
            if (this.logConnectFailure(re == null || !re.loggedConnectFailure())) {
                String node = null;
                node = rb != null ? (rb.getNodeName() != null ? rb.getNodeName() : "<unknown node>") : "<unknown node>";
                Object[] obj = new Object[]{Config.ROUTING_NODE_NAME, Config.BROKER_NAME, node};
                BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTCONN_FAILURE"), obj) + " " + ge.getMessage(), 2);
                RemoteBrokerHelper.configLoggedConnectFailureTrue(re);
            }
            this.prepareRetry(rb, re);
            successFlag = false;
        }
        finally {
            this.unsetMonitorCheckingNull();
        }
        return successFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleRegisteredRB(Object[] arr, RetryElem re) throws InterruptedException {
        RemoteBroker rb = (RemoteBroker)arr[0];
        boolean successFlag = true;
        try {
            RemoteBroker returnedRB;
            if (this.checkDebugFlags(16)) {
                this.debug("handleRegisteredRB: rb = " + rb.getBrokerName() + ", invoke rb's reconnect method, hashcode = " + rb.hashCode());
            }
            if (this.m_monitorThread != null) {
                this.m_monitorThread.setMonitor(MessageFormat.format(prAccessor.getString("RTRECONN_SET_MON"), rb.getNodeName()), re == null || !re.loggedConnectFailure());
            }
            if ((returnedRB = rb.reconnect(this.m_reg)) != rb) {
                this.getRoutingQueue().setPendingRemoteBroker(rb.getPendingQueueName(), returnedRB);
                RemoteBrokerHelper.clearOutRetryElem(re);
                arr[0] = returnedRB;
                rb = returnedRB;
            }
        }
        catch (ERouterAuthenticationFailure rafe) {
            successFlag = this.prepareRetry(re, rb, rafe);
        }
        catch (EInauthenticClient ice) {
            String user = null;
            String node = null;
            if (rb != null) {
                user = rb.getUserID();
                node = rb.getNodeName();
            }
            Object[] obj = new Object[]{user == null ? "<unknown user>" : user, node == null ? "<unknown node>" : node, DATE_PARSER_THREAD_LOCAL.get().format(new Date(System.currentTimeMillis()))};
            String msg = prAccessor.getString("RTAUTH_RECONNECT_FAILED");
            successFlag = this.formatPopulateIndeliveredReasonAndRetry(msg, obj, re, rb, ice);
        }
        catch (EAlreadyConnecting ace) {
            if (this.checkDebugFlags(16)) {
                this.debug("reconnect attempt on registered RemoteBroker - already connecting...", ace);
            }
            this.prepareRetry(rb, re);
            successFlag = false;
        }
        catch (EGeneralException ge) {
            if (this.checkDebugFlags(16)) {
                this.debug("handleRegisteredRB: exception thrown on reconnect attempt on rb = " + rb.getBrokerName() + ", hashcode = " + rb.hashCode(), ge);
            }
            if (this.logConnectFailure(re == null || !re.loggedConnectFailure())) {
                String node = null;
                String broker = null;
                if (rb != null) {
                    node = rb.getNodeName();
                    broker = rb.getBrokerName();
                    if (rb.getConnectURL() != null) {
                        broker = broker + " (" + rb.getConnectURL() + ")";
                    }
                }
                Object[] obj = new Object[]{Config.ROUTING_NODE_NAME, Config.BROKER_NAME, node == null ? "<unknown node>" : node, broker == null ? "<unknown broker>" : broker, Integer.toString(Config.CONNECT_RETRY_COUNT), Long.toString(Config.CONNECT_RETRY_INTERVAL)};
                BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTCONN_FAILURE_AND_RETRY"), obj) + " " + ge.getMessage(), 2);
                RemoteBrokerHelper.configLoggedConnectFailureTrue(re);
            }
            this.prepareRetry(rb, re);
            successFlag = false;
        }
        finally {
            this.unsetMonitorCheckingNull();
        }
        return successFlag;
    }

    private boolean prepareRetry(RetryElem re, RemoteBroker rb, ERouterAuthenticationFailure rafe) throws InterruptedException {
        BrokerComponent.getComponentContext().logMessage(rafe.getMessage(), (Throwable)rafe, 2);
        if (re != null) {
            re.setLastUndeliveredReason(8);
        }
        this.prepareRetry(rb, re);
        return false;
    }

    private boolean formatPopulateIndeliveredReasonAndRetry(String msg, Object[] obj, RetryElem re, RemoteBroker rb, EInauthenticClient ice) throws InterruptedException {
        BrokerComponent.getComponentContext().logMessage(MessageFormat.format(msg, obj), (Throwable)ice, 2);
        if (re != null) {
            re.setLastUndeliveredReason(7);
        }
        this.prepareRetry(rb, re);
        return false;
    }

    private static void clearOutRetryElem(RetryElem re) {
        if (re != null) {
            re.resetRetryInfo();
        }
    }

    private static void configLoggedConnectFailureTrue(RetryElem re) {
        if (re != null) {
            re.setLoggedConnectFailure(true);
        }
    }

    private void unsetMonitorCheckingNull() {
        if (this.m_monitorThread != null) {
            this.m_monitorThread.unsetMonitor();
        }
    }

    private boolean logConnectFailure(boolean firstConnectAttempt) {
        if (firstConnectAttempt) {
            return true;
        }
        BrokerComponent brokerComponent = BrokerComponent.getBrokerComponent();
        int traceMask = brokerComponent.getTraceMask();
        return (traceMask & 0x40) != 0;
    }

    boolean submitDRATask(IDRATask task) {
        return this.m_asyncTaskControl.submitDRATask(task);
    }

    class AsyncTaskControl
    extends DebugObject
    implements ITaskCompletionListener {
        private Hashtable m_activePQs = new Hashtable();

        AsyncTaskControl() {
            RemoteBrokerHelper.this.m_DRAThreadPool.setTaskCompletionListener(this);
        }

        private boolean submitDRATask(IDRATask task) {
            RemoteBrokerHelper.this.m_DRAThreadPool.addDRATask(task);
            if (this.DEBUG) {
                this.debug("added task; numAsynTasks= " + this.m_activePQs.size() + " task= " + task.getClass().getName());
            }
            return true;
        }

        private boolean submitDRATask(String id, IDRATask task) {
            boolean added = this.addActiveTask(id, task);
            if (added) {
                RemoteBrokerHelper.this.m_DRAThreadPool.addDRATask(task);
            }
            return added;
        }

        private boolean submitDRATask(Vector ids, IDRATask task) {
            boolean added = this.addActiveTask(ids, task);
            if (added) {
                RemoteBrokerHelper.this.m_DRAThreadPool.addDRATask(task);
            }
            return added;
        }

        private boolean containsActiveTask(String id) {
            return this.m_activePQs.containsKey(id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean containsActiveTask(Vector vec) {
            Hashtable hashtable = this.m_activePQs;
            synchronized (hashtable) {
                for (String pq : vec) {
                    if (!this.containsActiveTask(pq)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean hasActiveTasks() {
            return this.m_activePQs.size() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addActiveTask(String id, IDRATask task) {
            Hashtable hashtable = this.m_activePQs;
            synchronized (hashtable) {
                if (this.containsActiveTask(id)) {
                    return false;
                }
                this.m_activePQs.put(id, task);
            }
            this.debugData(id, task);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addActiveTask(Vector vec, IDRATask task) {
            Hashtable hashtable = this.m_activePQs;
            synchronized (hashtable) {
                if (this.containsActiveTask(vec)) {
                    return false;
                }
                for (String pq : vec) {
                    this.m_activePQs.put(pq, task);
                    this.debugData(pq, task);
                }
            }
            return true;
        }

        private void debugData(String pq, IDRATask task) {
            if (this.DEBUG) {
                this.debug("added " + pq + " numAsynTasks= " + this.m_activePQs.size() + " task= " + task.getClass().getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void taskCompleted(IDRATask task) {
            Object target = task.getTargetObjectIdent();
            if (target != null) {
                if (target instanceof Vector) {
                    Hashtable hashtable = this.m_activePQs;
                    synchronized (hashtable) {
                        for (Object obj : (Vector)target) {
                            this.m_activePQs.remove(obj);
                            if (!this.DEBUG) continue;
                            this.debug("removed " + (String)obj);
                        }
                    }
                } else {
                    this.m_activePQs.remove(task.getTargetObjectIdent());
                    if (this.DEBUG) {
                        this.debug("removed " + task.getTargetObjectIdent() + " numAsyncTasks= " + this.m_activePQs.size());
                    }
                }
            } else if (this.DEBUG) {
                this.debug("removed " + task.getClass().getName() + " numAsyncTasks= " + this.m_activePQs.size());
            }
            task.setCompleted();
            if (task.notifyDispatcher()) {
                RemoteBrokerHelper.this.wakeUpConnectThread();
            }
        }
    }

    class ConnectThreadMonitor
    extends DebugThread {
        private long m_checkInterval;
        private long m_reportTimeout;
        private long m_abortTimeout;
        private boolean DEBUG1;
        Hashtable m_monitoredThreads;

        ConnectThreadMonitor(long checkInterval, long reportTimeout, long abortTimeout) {
            super("ConnectThreadMonitor");
            this.m_monitoredThreads = new Hashtable();
            this.m_checkInterval = checkInterval;
            this.m_reportTimeout = reportTimeout;
            this.m_abortTimeout = abortTimeout;
            boolean bl = this.DEBUG1 = (this.debugFlags & 0x40) > 0;
            if (this.DEBUG1) {
                this.debug("Constructed; ");
            }
        }

        synchronized void setMonitor(String action) {
            this.setMonitor(action, true);
        }

        synchronized void setMonitor(String action, boolean firstConnectAttempt) {
            MonitoredThread monitoredThread = (MonitoredThread)this.m_monitoredThreads.get(Thread.currentThread());
            if (monitoredThread == null) {
                monitoredThread = new MonitoredThread();
                this.m_monitoredThreads.put(Thread.currentThread(), monitoredThread);
            }
            monitoredThread.startMonitor(action, firstConnectAttempt);
            if (this.DEBUG) {
                this.debug("setMonitor: " + Thread.currentThread());
            }
        }

        synchronized void unsetMonitor() {
            MonitoredThread monitoredThread = (MonitoredThread)this.m_monitoredThreads.get(Thread.currentThread());
            if (monitoredThread == null) {
                return;
            }
            monitoredThread.stopMonitor();
            if (this.DEBUG) {
                this.debug("unsetMonitor: " + Thread.currentThread());
            }
        }

        synchronized Boolean setOkToInterrupt(boolean okToInterrupt) {
            MonitoredThread monitoredThread = (MonitoredThread)this.m_monitoredThreads.get(Thread.currentThread());
            if (monitoredThread == null) {
                return null;
            }
            boolean val = monitoredThread.m_okToInterrupt;
            monitoredThread.m_okToInterrupt = okToInterrupt;
            if (this.DEBUG) {
                this.debug("setOkToInterrupt: " + Thread.currentThread() + " param= " + okToInterrupt);
            }
            return new Boolean(val);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() {
            Object[] formatObjects = new Object[2];
            if (this.DEBUG1) {
                this.debug("Starting; ");
            }
            while (!Thread.interrupted()) {
                try {
                    Thread.sleep(this.m_checkInterval);
                    ConnectThreadMonitor connectThreadMonitor = this;
                    synchronized (connectThreadMonitor) {
                        Enumeration threads = this.m_monitoredThreads.keys();
                        while (threads.hasMoreElements()) {
                            Thread threadObj = (Thread)threads.nextElement();
                            MonitoredThread thread = (MonitoredThread)this.m_monitoredThreads.get(threadObj);
                            if (!thread.m_monitor) continue;
                            Long elapsed = new Long(System.currentTimeMillis() - thread.m_lastActive);
                            if (thread.m_okToInterrupt && elapsed > this.m_abortTimeout) {
                                formatObjects[0] = elapsed;
                                formatObjects[1] = thread.m_action;
                                BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTCONN_MON_ABORT"), formatObjects), 2);
                                threadObj.interrupt();
                                continue;
                            }
                            if (!RemoteBrokerHelper.this.logConnectFailure(thread.m_firstConnectAttempt) || elapsed <= this.m_reportTimeout) continue;
                            formatObjects[0] = elapsed;
                            formatObjects[1] = thread.m_action;
                            BrokerComponent.getComponentContext().logMessage(MessageFormat.format(prAccessor.getString("RTCONN_MON_TIMEOUT"), formatObjects), 2);
                        }
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        class MonitoredThread {
            private long m_lastActive;
            private String m_action;
            private boolean m_monitor;
            private boolean m_okToInterrupt;
            private boolean m_firstConnectAttempt;

            MonitoredThread() {
            }

            void startMonitor(String action, boolean firstConnectAttempt) {
                this.m_lastActive = System.currentTimeMillis();
                this.m_monitor = true;
                this.m_okToInterrupt = false;
                this.m_action = action;
                this.m_firstConnectAttempt = firstConnectAttempt;
            }

            void stopMonitor() {
                this.m_monitor = false;
                this.m_action = null;
                this.m_lastActive = -1L;
            }
        }
    }

    class RemoteBrokerConnectThread
    extends DebugThread {
        private boolean DEBUG1;

        RemoteBrokerConnectThread() {
            super("RemoteBrokerConnectThread");
            boolean bl = this.DEBUG1 = (this.debugFlags & 0x40) > 0;
            if (this.DEBUG1) {
                this.debug("Constructed; sync= " + sync);
            }
        }

        public boolean isOkToWakeUp(IRemoteBroker irb) {
            String pq = null;
            if (irb != null) {
                pq = irb.getPendingQueueName();
                if (RemoteBrokerHelper.this.m_asyncTaskControl.containsActiveTask(pq)) {
                    return false;
                }
            }
            return true;
        }

        private String debugPQS(Vector vec) {
            if (vec.isEmpty()) {
                return "<none>";
            }
            Iterator it = vec.iterator();
            StringBuffer buf = new StringBuffer();
            while (it.hasNext()) {
                String pq = (String)it.next();
                buf.append(pq);
                buf.append(";");
            }
            return buf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() {
            long numLoops = 0L;
            long numWakeUps = 0L;
            long numTasks = 0L;
            long numConnects = 0L;
            long numDispatch = 0L;
            long numReroute = 0L;
            long numDelete = 0L;
            long oldNumTasks = 0L;
            long lastDebugPQ = System.currentTimeMillis();
            if (this.DEBUG1) {
                this.debug("Starting...");
            }
            try {
                while (!Broker.exiting && !this.isInterrupted()) {
                    long time;
                    Object destinationNodeName;
                    ++numLoops;
                    boolean skippedReroute = false;
                    if (!RemoteBrokerHelper.this.m_nodeUpdates.isEmpty()) {
                        Hashtable hashtable = RemoteBrokerHelper.this.m_nodeUpdates;
                        synchronized (hashtable) {
                            Enumeration enu = RemoteBrokerHelper.this.m_nodeUpdates.keys();
                            while (enu.hasMoreElements() && !Broker.exiting) {
                                destinationNodeName = (String)enu.nextElement();
                                String oldNodeName = (String)RemoteBrokerHelper.this.m_nodeUpdates.get(destinationNodeName);
                                Vector pqs = RemoteBrokerHelper.this.getPendingQueuesToReroute((String)destinationNodeName, oldNodeName);
                                if (this.DEBUG) {
                                    this.debug("Node update; dest= " + (String)destinationNodeName + " oldNodeName " + oldNodeName + " pqs.size= " + pqs.size());
                                }
                                if (pqs.isEmpty()) {
                                    RemoteBrokerHelper.this.m_nodeUpdates.remove(destinationNodeName);
                                    if (!this.DEBUG1) continue;
                                    this.debug("Node update; dest= " + (String)destinationNodeName + " oldNodeName " + oldNodeName + " No pqs to reroute...");
                                    continue;
                                }
                                if (RemoteBrokerHelper.this.m_asyncTaskControl.containsActiveTask(pqs)) {
                                    if (this.DEBUG1) {
                                        this.debug("Reroute task postponed for: dest= " + (String)destinationNodeName + " oldNodeName " + oldNodeName + " pqs= " + this.debugPQS(pqs));
                                    }
                                    skippedReroute = true;
                                    continue;
                                }
                                DRAReroutePendingTask reroute = new DRAReroutePendingTask((String)destinationNodeName, oldNodeName, pqs);
                                if (RemoteBrokerHelper.this.m_asyncTaskControl.submitDRATask(pqs, reroute)) {
                                    RemoteBrokerHelper.this.m_nodeUpdates.remove(destinationNodeName);
                                    ++numTasks;
                                    numReroute = this.incrementAndWait(numReroute, reroute);
                                    if (!this.DEBUG1) continue;
                                    this.debug("Submitted reroute task  for -- dest= " + (String)destinationNodeName + " oldNodeName " + oldNodeName + " pqs= " + this.debugPQS(pqs));
                                    continue;
                                }
                                skippedReroute = true;
                                if (!this.DEBUG1) continue;
                                this.debug("Reroute task postponed for -- dest= " + (String)destinationNodeName + " oldNodeName " + oldNodeName + " pqs= " + this.debugPQS(pqs));
                            }
                        }
                    }
                    boolean isEmpty = true;
                    IDRATask conntask = null;
                    destinationNodeName = RemoteBrokerHelper.this.m_connectRequests;
                    synchronized (destinationNodeName) {
                        if (!RemoteBrokerHelper.this.m_connectRequests.isEmpty()) {
                            isEmpty = false;
                            if (this.DEBUG) {
                                this.debug("threadMain: re/connect requests pending; size= " + RemoteBrokerHelper.this.m_connectRequests.size());
                            }
                            boolean addedConnectTask = false;
                            while (!addedConnectTask) {
                                Enumeration enu = RemoteBrokerHelper.this.m_connectRequests.keys();
                                if (!enu.hasMoreElements()) {
                                    isEmpty = true;
                                    break;
                                }
                                IRemoteBroker irb = (IRemoteBroker)enu.nextElement();
                                RetryElem re = (RetryElem)RemoteBrokerHelper.this.m_connectRequests.remove(irb);
                                if (irb != null && !irb.isConnected()) {
                                    if (!RemoteBrokerHelper.this.m_asyncTaskControl.containsActiveTask(irb.getPendingQueueName())) {
                                        conntask = new DRAConnectTask(irb, re);
                                        addedConnectTask = RemoteBrokerHelper.this.m_asyncTaskControl.submitDRATask(irb.getPendingQueueName(), conntask);
                                        if (addedConnectTask) {
                                            ++numTasks;
                                            ++numConnects;
                                            continue;
                                        }
                                        conntask = null;
                                        if (!this.DEBUG1) continue;
                                        this.debug("DRAConnectTask not added (submitDRATask); active task exists for " + irb.getPendingQueueName() + " irb= " + irb);
                                        continue;
                                    }
                                    if (!this.DEBUG1) continue;
                                    this.debug("DRAConnectTask not added; active task exists for " + irb.getPendingQueueName() + " irb= " + irb);
                                    continue;
                                }
                                if (!this.DEBUG1) continue;
                                this.debug("DRAConnectTask not added; irb is null or connected  irb= " + irb);
                            }
                        }
                    }
                    if (conntask != null && sync) {
                        conntask.waitForCompletion();
                    }
                    if (!isEmpty) {
                        if (!this.DEBUG) continue;
                        this.debug("Continuing... 1");
                        continue;
                    }
                    for (String name : RemoteBrokerHelper.this.getRoutingQueue().getPendingQueueNames()) {
                        PendingQueue pq;
                        if (name == null) {
                            if (!this.DEBUG) continue;
                            this.debug("Pending queue is null ");
                            continue;
                        }
                        if (RemoteBrokerHelper.this.m_asyncTaskControl.containsActiveTask(name)) {
                            if (!this.DEBUG1) continue;
                            this.debug("DRADispatchTask or DRARemoveTask not added; task already in progress; pqname= " + name);
                            continue;
                        }
                        IRemoteBroker dispatchRB = RemoteBrokerHelper.this.getRoutingQueue().getPendingRemoteBroker(name);
                        if (dispatchRB == null || (pq = RemoteBrokerHelper.this.getRoutingQueue().getPendingQueue(name, false)) == null) continue;
                        if (pq.getRemoveMessagesFlag()) {
                            DRARemovePendingTask removeTask = new DRARemovePendingTask(dispatchRB, pq.getRemoveMessagesReasonCode());
                            if (!RemoteBrokerHelper.this.m_asyncTaskControl.submitDRATask(name, removeTask)) continue;
                            if (this.DEBUG1) {
                                this.debug("Added remove task for " + name + " pq= " + pq.hashCode());
                            }
                            ++numTasks;
                            numDelete = this.incrementAndWait(numDelete, removeTask);
                            continue;
                        }
                        if (!dispatchRB.isOkToSend(RemoteBrokerHelper.this.m_notifyLimiter)) {
                            boolean isCon = dispatchRB.isConnected();
                            boolean connecting = dispatchRB.isConnecting();
                            if (!this.DEBUG1) continue;
                            this.debug("Can't Add dispatch task for pq= " + name + " isOkToSend= false " + dispatchRB + " connected= " + isCon + " connecting= " + connecting);
                            continue;
                        }
                        DRADispatchPendingTask dispatchTask = new DRADispatchPendingTask(dispatchRB);
                        if (RemoteBrokerHelper.this.m_asyncTaskControl.submitDRATask(name, dispatchTask)) {
                            if (this.DEBUG) {
                                this.debug("Added dispatch task for pq= " + name);
                            }
                            ++numTasks;
                            numDispatch = this.incrementAndWait(numDispatch, dispatchTask);
                            continue;
                        }
                        if (!this.DEBUG1) continue;
                        this.debug("Cannot add dispatch task for pq= " + name + " submitDRATask returned false");
                    }
                    Hashtable name = RemoteBrokerHelper.this.m_connectRequests;
                    synchronized (name) {
                        Vector needRetry = new Vector();
                        Vector queuesToProcess = new Vector();
                        boolean canProcess = RemoteBrokerHelper.this.getRoutingQueue().canProcessAnyPendingQueue(queuesToProcess, needRetry, RemoteBrokerHelper.this.m_notifyLimiter);
                        if (canProcess) {
                            int numActive = 0;
                            Enumeration enu = queuesToProcess.elements();
                            while (enu.hasMoreElements()) {
                                String qname = (String)enu.nextElement();
                                if (!RemoteBrokerHelper.this.m_asyncTaskControl.containsActiveTask(qname)) continue;
                                ++numActive;
                            }
                            if (numActive == queuesToProcess.size()) {
                                if (this.DEBUG) {
                                    this.debug("Resetting canProcess=false; numActive= " + numActive);
                                }
                                canProcess = false;
                            }
                        }
                        Enumeration enu = needRetry.elements();
                        while (enu.hasMoreElements()) {
                            IRemoteBroker irb = (IRemoteBroker)enu.nextElement();
                            if (irb == null || RemoteBrokerHelper.this.m_connectRequests.get(irb) != null || RemoteBrokerHelper.this.m_asyncTaskControl.containsActiveTask(irb.getPendingQueueName())) continue;
                            if (this.DEBUG1) {
                                this.debug("adding ineligible request for " + irb);
                            }
                            RemoteBrokerHelper.this.addIneligibleRequest(irb);
                        }
                        if (!canProcess && RemoteBrokerHelper.this.m_connectRequests.isEmpty() && !Broker.exiting) {
                            if (skippedReroute && !RemoteBrokerHelper.this.m_asyncTaskControl.hasActiveTasks()) {
                                if (this.DEBUG1) {
                                    this.debug("Continuing... 2");
                                }
                                continue;
                            }
                            if (this.DEBUG) {
                                this.debug("threadMain: re/connect requests = " + RemoteBrokerHelper.this.m_connectRequests.size() + ", wait on m_connectRequests...");
                            }
                            RemoteBrokerHelper.this.m_connectRequests.wait();
                            ++numWakeUps;
                        } else if (this.DEBUG1) {
                            this.debug("Continuing... 3 canProcess= " + canProcess + " connectreqSize= " + RemoteBrokerHelper.this.m_connectRequests.size());
                        }
                    }
                    if (!this.DEBUG1 || (time = System.currentTimeMillis()) - lastDebugPQ <= 30000L) continue;
                    int ct = RemoteBrokerHelper.this.debugPendingQueues();
                    lastDebugPQ = System.currentTimeMillis();
                    if (!this.DEBUG1) continue;
                    this.debug("PQ debug completed; ct= " + ct);
                }
            }
            catch (InterruptedException ie) {
                return;
            }
            finally {
                if (this.DEBUG) {
                    this.debug("threadMain: exiting, broker exiting = " + Broker.exiting);
                }
            }
        }

        private long incrementAndWait(long numDeleteParam, IDRATask removeTask) throws InterruptedException {
            long numDelete = numDeleteParam;
            ++numDelete;
            if (sync) {
                removeTask.waitForCompletion();
            }
            return numDelete;
        }
    }

    class RetryInfoThread
    extends DebugThread {
        RetryInfoThread() {
            super("RetryInfoThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadMain() {
            try {
                while (!Broker.exiting && !this.isInterrupted()) {
                    Hashtable hashtable = RemoteBrokerHelper.this.m_ineligibleRetryRequests;
                    synchronized (hashtable) {
                        if (RemoteBrokerHelper.this.m_ineligibleRetryRequests.isEmpty()) {
                            RemoteBrokerHelper.this.m_ineligibleRetryRequests.wait();
                        }
                    }
                    if (this.DEBUG) {
                        this.debug("threadMain: ineligible retry requests =  " + RemoteBrokerHelper.this.m_ineligibleRetryRequests.size());
                    }
                    long sleepInterval = Config.CONNECT_RETRY_INTERVAL;
                    Enumeration<Object> enu = null;
                    IRemoteBroker irb = null;
                    RetryElem re = null;
                    long elapsedTime = 0L;
                    long remainingTime = Config.CONNECT_RETRY_INTERVAL;
                    Vector connectRequests = new Vector();
                    Object[] connectRequest = null;
                    Hashtable hashtable2 = RemoteBrokerHelper.this.m_ineligibleRetryRequests;
                    synchronized (hashtable2) {
                        enu = RemoteBrokerHelper.this.m_ineligibleRetryRequests.keys();
                        while (enu.hasMoreElements() && !Broker.exiting) {
                            irb = (IRemoteBroker)enu.nextElement();
                            re = (RetryElem)RemoteBrokerHelper.this.m_ineligibleRetryRequests.get(irb);
                            elapsedTime = System.currentTimeMillis() / 1000L - re.getLastRetryTime();
                            if (this.DEBUG) {
                                this.debug("threadMain: retry elem for RemoteBroker node: " + irb.getNodeName() + ", hashcode = " + irb.hashCode() + ", elapsed time since last retry = " + elapsedTime);
                                this.debug("threadMain: elapsedTime = " + elapsedTime);
                            }
                            if (!re.isPaused()) {
                                if (elapsedTime >= Config.CONNECT_RETRY_INTERVAL) {
                                    connectRequest = this.removeBrokerAddConnectRequest(irb, re, connectRequests);
                                    continue;
                                }
                                long interval = Config.CONNECT_RETRY_INTERVAL - elapsedTime;
                                remainingTime = interval > 0L ? interval : 0L;
                            } else {
                                if (elapsedTime >= s_pauseInterval) {
                                    connectRequest = this.removeBrokerAddConnectRequest(irb, re, connectRequests);
                                    continue;
                                }
                                remainingTime = s_pauseInterval - elapsedTime;
                            }
                            if (this.DEBUG) {
                                this.debug("threadMain: remaining time = " + remainingTime);
                                this.debug("threadMain: sleep interval = " + sleepInterval);
                            }
                            if (remainingTime > 0L && remainingTime < sleepInterval) {
                                sleepInterval = remainingTime;
                            } else if (sleepInterval <= 0L) {
                                sleepInterval = s_pauseInterval;
                            }
                            if (!this.DEBUG) continue;
                            this.debug("threadMain: sleep interval = " + sleepInterval);
                        }
                    }
                    IRemoteBroker remoteBroker = null;
                    RetryElem retryElem = null;
                    boolean paused = false;
                    enu = connectRequests.elements();
                    while (enu.hasMoreElements() && !Broker.exiting) {
                        connectRequest = (Object[])enu.nextElement();
                        remoteBroker = (IRemoteBroker)connectRequest[0];
                        retryElem = (RetryElem)connectRequest[1];
                        paused = retryElem.isPaused();
                        if (this.DEBUG) {
                            if (!paused) {
                                this.debug("threadMain, add conn request #2...");
                            } else {
                                this.debug("threadMain, add conn request #3...");
                            }
                        }
                        if (paused) {
                            retryElem.pauseOff();
                        }
                        boolean conn = RemoteBrokerHelper.this.addConnectRequest(remoteBroker, retryElem);
                        if (!this.DEBUG) continue;
                        if (!paused) {
                            this.debug("threadMain: not paused #2, irb connected = " + conn + " (interesting if this is true)...");
                            continue;
                        }
                        this.debug("threadMain: paused #3, irb connected = " + conn + " (interesting if this is true)...");
                    }
                    if (RemoteBrokerHelper.this.m_ineligibleRetryRequests.isEmpty() || Broker.exiting) continue;
                    if (this.DEBUG) {
                        this.debug("threadMain: retry info thread going to sleep at " + System.currentTimeMillis() + ", for " + sleepInterval + " seconds...");
                    }
                    Thread.sleep(sleepInterval * 1000L);
                    if (!this.DEBUG) continue;
                    this.debug("threadMain: retry info thread woke up at " + System.currentTimeMillis());
                }
            }
            catch (InterruptedException ie) {
                return;
            }
            finally {
                if (this.DEBUG) {
                    this.debug("threadMain: retry thread exiting, broker exiting = " + Broker.exiting);
                }
            }
        }

        private Object[] removeBrokerAddConnectRequest(IRemoteBroker irb, RetryElem re, Vector connectRequests) {
            RemoteBrokerHelper.this.m_ineligibleRetryRequests.remove(irb);
            Object[] connectRequest = new Object[]{irb, re};
            connectRequests.addElement(connectRequest);
            return connectRequest;
        }
    }

    class RetryElem
    implements Cloneable {
        public int m_retryAttempts = 0;
        public long m_lastRetryTime;
        public boolean m_connectAttempt;
        public long m_initialConnectTime;
        public boolean m_pause;
        public boolean m_loggedConnectFailure = false;
        public int m_lastUndeliveredReason = -1;

        RetryElem(long currTime) {
            this.m_lastRetryTime = currTime;
            this.m_connectAttempt = false;
            this.m_initialConnectTime = currTime;
            this.m_pause = false;
        }

        public Object clone() {
            RetryElem re = null;
            try {
                re = (RetryElem)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return re;
        }

        synchronized boolean isTimeToRetry() {
            return this.hasIntervalPassed();
        }

        synchronized boolean hasIntervalPassed() {
            long diff = System.currentTimeMillis() / 1000L - this.m_lastRetryTime;
            boolean flag = diff >= Config.CONNECT_RETRY_INTERVAL;
            return flag;
        }

        synchronized boolean hasMadeMaxRetries() {
            return this.m_retryAttempts >= Config.CONNECT_RETRY_COUNT;
        }

        synchronized boolean isPaused() {
            return this.m_pause;
        }

        synchronized void pauseOn() {
            this.m_pause = true;
        }

        synchronized void pauseOff() {
            this.m_pause = false;
        }

        synchronized long getLastRetryTime() {
            return this.m_lastRetryTime;
        }

        synchronized boolean hasMadeConnectAttempt() {
            return this.m_connectAttempt;
        }

        synchronized long getInitialConnectTime() {
            return this.m_initialConnectTime;
        }

        synchronized boolean hasRoutingTimedOut() {
            long diff = System.currentTimeMillis() / 1000L - this.m_initialConnectTime;
            boolean flag = diff >= Config.ROUTING_TIMEOUT;
            return flag;
        }

        synchronized void updateRetryInfo(String rbName) {
            this.m_lastRetryTime = System.currentTimeMillis() / 1000L;
            ++this.m_retryAttempts;
            this.m_connectAttempt = true;
            if (RemoteBrokerHelper.this.checkDebugFlags(16)) {
                RemoteBrokerHelper.this.debug("updateRetryInfo: RemoteBroker = " + rbName + ", retry attempts = " + this.m_retryAttempts + ", last retry time = " + this.m_lastRetryTime + ", current time = " + System.currentTimeMillis() / 1000L);
            }
        }

        synchronized void resetRetryInfo() {
            this.m_lastRetryTime = System.currentTimeMillis() / 1000L;
            this.m_retryAttempts = 0;
            this.m_connectAttempt = false;
        }

        synchronized boolean loggedConnectFailure() {
            return this.m_loggedConnectFailure;
        }

        synchronized void setLoggedConnectFailure(boolean loggedConnectFailure) {
            this.m_loggedConnectFailure = loggedConnectFailure;
        }

        synchronized void clearLastUndeliveredReason() {
            this.m_lastUndeliveredReason = -1;
        }

        synchronized void setLastUndeliveredReason(int lastUndeliveredReason) {
            this.m_lastUndeliveredReason = lastUndeliveredReason;
        }

        synchronized int getLastUndeliveredReason() {
            return this.m_lastUndeliveredReason;
        }
    }
}

