/*
 * Decompiled with CFR 0.152.
 */
package progress.message.interbroker;

import com.sonicsw.mq.components.BrokerComponent;
import java.io.IOException;
import progress.message.broker.AddrUtil;
import progress.message.broker.AgentRegistrar;
import progress.message.broker.Broker;
import progress.message.broker.IClientContext;
import progress.message.gr.RouterManager;
import progress.message.interbroker.Interbroker;
import progress.message.interbroker.InterbrokerConfig;
import progress.message.interbroker.Neighbor;
import progress.message.util.DebugState;
import progress.message.zclient.DebugObject;
import progress.message.zclient.Envelope;
import progress.message.zclient.IMessageHandler;
import progress.message.zclient.Message;
import progress.message.zclient.Session;

class Convert
extends DebugObject
implements IMessageHandler {
    private static final String ERROR_OCCURRED_IN_HANDLE_MESSAGE_GET_TOKEN = "Error occurred in Handle Message Get Token";
    private static final String COLON = ":";
    private static final String CONVERT_HANDLE_MESSAGE_GET_TOKEN = "Convert.handleMessage(GET_TOKEN): %s primaryRole= %s primaryAcceptor= %s";
    private static final String CONVERT_HANDLE_MESSAGE_GET_TOKEN_NO_MORE_DATA_AVAILABLE = "Convert.handleMessage(GET_TOKEN): no more data available; %s primaryRole= %s sessver of partner= %d";
    private static final String CONVERT_HANDLE_MESSAGE_GET_TOKEN_RETURNING_TOKEN = "Convert.handleMessage(GET_TOKEN): returning token %s primaryRole= %s primaryAcceptor= %s";
    private static final String CONVERT_HANDLE_MESSAGE_DONE = "Convert.handleMessage(DONE): %s primaryRole= %s primaryAcceptor= %s";
    private static final String CONVERT_HANDLE_MESSAGE_DONE_NO_MORE_DATA_AVAILABLE = "Convert.handleMessage(DONE): no more data available; %s primaryRole= %s sessver of partner= %d";
    private static final String CONVERT_HANDLE_MESSAGE_DONE_COMPLETED = "Convert.handleMessage(DONE): completed %s primaryRole= %s primaryAcceptor= %s";
    private static final String CONVERT_1 = "  Convert 1";
    private static final String UNABLE_TO_START_NEW_SENDER = "unable to start new sender: ";
    public static final byte RESET = 0;
    public static final byte GET_TOKEN = 1;
    public static final byte DONE = 2;
    private Interbroker m_interbroker;

    Convert(Interbroker interbroker) {
        super(DebugState.GLOBAL_DEBUG_ON ? "Convert" : null);
        this.m_interbroker = interbroker;
    }

    @Override
    public void handleMessage(Session session, Envelope envelope) {
        block7: {
            Message message = envelope.getMessage();
            try {
                byte messageValue = message.readByte();
                if (InterbrokerConfig.DEBUG && this.DEBUG) {
                    this.debug(message.getSubject() + COLON + messageValue);
                }
                switch (messageValue) {
                    case 1: {
                        this.handleMessageGetToken(session, envelope, message);
                        break;
                    }
                    case 2: {
                        this.handleMessageDone(message);
                        break;
                    }
                }
            }
            catch (IOException e) {
                if (Broker.isInShutdown()) break block7;
                BrokerComponent.getComponentContext().logMessage((Throwable)e, 2);
            }
        }
    }

    private void handleMessageDone(Message message) {
        block4: {
            try {
                AgentRegistrar registrar = this.m_interbroker.getAgentRegistrar();
                long id = message.readLong();
                Neighbor neighbor = this.m_interbroker.getNeighborByID(id);
                IClientContext clientContext = registrar.lockContext(id);
                if (clientContext != null) {
                    this.processMessageDone(message, registrar, id, neighbor, clientContext);
                    if (InterbrokerConfig.DEBUG) {
                        BrokerComponent.getComponentContext().logMessage(CONVERT_1, 3);
                    }
                }
            }
            catch (IOException | RuntimeException e) {
                if (!InterbrokerConfig.DEBUG) break block4;
                BrokerComponent.getComponentContext().logMessage(UNABLE_TO_START_NEW_SENDER + e.getMessage(), (Throwable)e, 2);
            }
        }
    }

    private void handleMessageGetToken(Session session, Envelope envelope, Message message) throws IOException {
        if (envelope.isRequest()) {
            long requestId;
            Neighbor remote;
            Message replyMessage;
            block6: {
                replyMessage = new Message();
                remote = null;
                requestId = 0L;
                try {
                    requestId = AddrUtil.getIdFromDirectedSubject(envelope.getReplySubject());
                    remote = this.m_interbroker.getNeighborByConnectID(requestId);
                }
                catch (IOException | RuntimeException e) {
                    if (!this.DEBUG) break block6;
                    this.debug(ERROR_OCCURRED_IN_HANDLE_MESSAGE_GET_TOKEN);
                }
            }
            if (remote != null) {
                boolean peerPrimaryRole = message.readBoolean();
                boolean primaryAcceptor = true;
                if (message.available() > 0) {
                    primaryAcceptor = message.readBoolean();
                    this.debugData(CONVERT_HANDLE_MESSAGE_GET_TOKEN, remote, peerPrimaryRole, primaryAcceptor);
                } else {
                    this.handleGetTokenNoData(remote, requestId, peerPrimaryRole);
                }
                this.writeReplyMessage(replyMessage, remote, peerPrimaryRole, primaryAcceptor);
            }
            session.reply(replyMessage, envelope);
        }
    }

    private void handleGetTokenNoData(Neighbor remote, long requestId, boolean peerPrimaryRole) {
        byte sessionVersion = 0;
        if (this.DEBUG) {
            block3: {
                try {
                    IClientContext clientContext = AgentRegistrar.getAgentRegistrar().getClient(requestId);
                    sessionVersion = clientContext.getClientSessionVer();
                }
                catch (IOException | RuntimeException ex) {
                    if (!this.DEBUG) break block3;
                    this.debug(ERROR_OCCURRED_IN_HANDLE_MESSAGE_GET_TOKEN);
                }
            }
            this.debug(String.format(CONVERT_HANDLE_MESSAGE_GET_TOKEN_NO_MORE_DATA_AVAILABLE, remote.getName(), peerPrimaryRole, sessionVersion));
        }
    }

    private void writeReplyMessage(Message replyMessage, Neighbor remote, boolean peerPrimaryRole, boolean primaryAcceptor) {
        long token = remote.passiveConvert();
        if (token != 0L) {
            remote.setPassiveConnectInfo(peerPrimaryRole, primaryAcceptor);
            this.debugData(CONVERT_HANDLE_MESSAGE_GET_TOKEN_RETURNING_TOKEN, remote, peerPrimaryRole, primaryAcceptor);
            replyMessage.write(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessageDone(Message message, AgentRegistrar registrar, long id, Neighbor neighbor, IClientContext clientContext) throws IOException {
        try {
            boolean peerPrimaryRole = message.readBoolean();
            boolean primaryAcceptor = true;
            if (message.available() > 0) {
                primaryAcceptor = message.readBoolean();
                this.debugData(CONVERT_HANDLE_MESSAGE_DONE, neighbor, peerPrimaryRole, primaryAcceptor);
            } else if (this.DEBUG) {
                this.debug(String.format(CONVERT_HANDLE_MESSAGE_DONE_NO_MORE_DATA_AVAILABLE, neighbor.getName(), peerPrimaryRole, clientContext.getClientSessionVer()));
            }
            neighbor.setPassiveConnectInfo(peerPrimaryRole, primaryAcceptor);
            if (neighbor.isActive()) {
                registrar.postConnect(id, clientContext.getChannel());
                RouterManager routerManager = registrar.getRouterManager();
                routerManager.getRouteForwarder().onNewConnection(neighbor, true);
                registrar.getGSManager().onNewConnection(neighbor, true);
                registrar.getClusteredQueueManager().onNewConnection(neighbor);
                clientContext.startDelivery(null);
                this.m_interbroker.connectEvent(neighbor, neighbor.getToken());
                this.debugData(CONVERT_HANDLE_MESSAGE_DONE_COMPLETED, neighbor, peerPrimaryRole, primaryAcceptor);
            }
        }
        finally {
            clientContext.unlock();
        }
    }

    private void debugData(String CONVERT_HANDLE_MESSAGE_GET_TOKEN_RETURNING_TOKEN, Neighbor remote, boolean peerPrimaryRole, boolean primaryAcceptor) {
        if (this.DEBUG) {
            this.debug(String.format(CONVERT_HANDLE_MESSAGE_GET_TOKEN_RETURNING_TOKEN, remote.getName(), peerPrimaryRole, primaryAcceptor));
        }
    }
}

