/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.jndi.mfcontext;

import com.sonicsw.jndi.mfcontext.MFConnectionManager;
import com.sonicsw.mf.comm.jms.ConnectorClient;
import com.sonicsw.mf.common.MFSecurityException;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.IIdentity;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import com.sonicsw.mf.common.dirconfig.VersionOutofSyncException;
import com.sonicsw.mf.common.view.IDeltaView;
import java.lang.reflect.Method;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;

public final class MFConnection {
    private MFConnectionManager m_manager = null;
    private ConnectorClient m_connector = null;
    private String m_dsName;
    private ObjectName m_dsObjectName;
    private long m_lastUsageTime = 0L;
    private long m_idleTimeout = 0L;
    private boolean m_exiting = false;
    private static final String READER_ROLE = "READER";
    private static final String COMMS_TYPE = "jmx";
    private static final String INVOKE_OPERATION = "invoke";
    private static final String[] INVOKE_SIGNATURE = new String[]{ObjectName.class.getName(), String.class.getName(), Object[].class.getName(), String[].class.getName()};
    private static final String[] SET_ELEMENT_SIGNATURE = new String[]{IBasicElement.class.getName(), IDeltaView.class.getName()};
    private static final String[] GET_ELEMENT_SIGNATURE1 = new String[]{String.class.getName(), Boolean.class.getName()};
    private static final String[] DELETE_ELEMENT_SIGNATURE = new String[]{String.class.getName(), IDeltaView.class.getName()};
    private static final String[] CREATE_DIRECTORY_SIGNATURE1 = new String[]{String.class.getName()};
    private static final String[] DELETE_DIRECTORY_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] LIST_DIRECTORIES_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] LIST_ELEMENTS_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] LIST_ALL_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] LOOKUP_IDENITY_SIGNATURE = new String[]{String.class.getName()};
    private static final String[] GET_ALL_ELEMENTS_SIGNATURE1 = new String[]{String.class.getName(), Boolean.class.getName()};
    private static final String[] GET_ALL_DIRECTORIES_SIGNATURE1 = new String[]{String.class.getName()};
    private static final String[] RESOLVE_URL_SIGNATURE = new String[]{String.class.getName()};

    MFConnection(MFConnectionManager manager, String domainName, long idleTimeout) {
        this.m_manager = manager;
        this.m_dsName = domainName + ".DIRECTORY SERVICE:ID=DIRECTORY SERVICE";
        try {
            this.m_dsObjectName = new ObjectName(this.m_dsName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        this.m_idleTimeout = idleTimeout;
        this.init();
    }

    synchronized void init() {
        this.m_connector = this.m_manager.getConnector();
        this.m_lastUsageTime = System.currentTimeMillis();
        IdleStateVerifier idleStateVerifier = new IdleStateVerifier();
        idleStateVerifier.setName("JNDI connection - idle state verifier " + idleStateVerifier.hashCode());
        idleStateVerifier.start();
    }

    synchronized void close() {
        this.m_exiting = true;
        this.notifyAll();
    }

    synchronized boolean isConnected() {
        return this.m_connector == null ? false : this.m_connector.isConnected();
    }

    synchronized boolean isEnterpise() {
        return this.m_connector != null && this.m_connector.isConnectionEnterpriseEnabled();
    }

    void setElement(IBasicElement element, IDeltaView view) throws DirectoryServiceException, NamingException {
        this.checkIdleTimeout();
        try {
            this.m_connector.invoke(COMMS_TYPE, this.m_dsName, this.m_dsName, INVOKE_OPERATION, new Object[]{this.m_dsObjectName, "setElement", new Object[]{element, view}, SET_ELEMENT_SIGNATURE}, INVOKE_SIGNATURE);
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    IDirElement getElement(String elementName, boolean forUpdate) throws DirectoryServiceException, NamingException {
        this.checkIdleTimeout();
        try {
            return (IDirElement)this.m_connector.invoke(COMMS_TYPE, this.m_dsName, this.m_dsName, INVOKE_OPERATION, new Object[]{this.m_dsObjectName, "getElement", new Object[]{elementName, new Boolean(forUpdate)}, GET_ELEMENT_SIGNATURE1}, INVOKE_SIGNATURE, READER_ROLE);
        }
        catch (Exception e) {
            this.throwException(e);
            return null;
        }
    }

    IElementIdentity deleteElement(String elementName, IDeltaView view) throws DirectoryServiceException, VersionOutofSyncException, NamingException {
        this.checkIdleTimeout();
        try {
            return (IElementIdentity)this.m_connector.invoke(COMMS_TYPE, this.m_dsName, this.m_dsName, INVOKE_OPERATION, new Object[]{this.m_dsObjectName, "deleteElement", new Object[]{elementName, view}, DELETE_ELEMENT_SIGNATURE}, INVOKE_SIGNATURE);
        }
        catch (Exception e) {
            this.throwException(e);
            return null;
        }
    }

    void createDirectory(String dirName) throws DirectoryServiceException, NamingException {
        this.checkIdleTimeout();
        try {
            this.m_connector.invoke(COMMS_TYPE, this.m_dsName, this.m_dsName, INVOKE_OPERATION, new Object[]{this.m_dsObjectName, "createDirectory", new Object[]{dirName}, CREATE_DIRECTORY_SIGNATURE1}, INVOKE_SIGNATURE);
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    void deleteDirectory(String dirName) throws DirectoryServiceException, NamingException {
        this.checkIdleTimeout();
        try {
            this.m_connector.invoke(COMMS_TYPE, this.m_dsName, this.m_dsName, INVOKE_OPERATION, new Object[]{this.m_dsObjectName, "deleteDirectory", new Object[]{dirName}, DELETE_DIRECTORY_SIGNATURE}, INVOKE_SIGNATURE);
        }
        catch (Exception e) {
            this.throwException(e);
        }
    }

    IDirIdentity[] listDirectories(String dirName) throws DirectoryServiceException, NamingException {
        this.checkIdleTimeout();
        try {
            return (IDirIdentity[])this.m_connector.invoke(COMMS_TYPE, this.m_dsName, this.m_dsName, INVOKE_OPERATION, new Object[]{this.m_dsObjectName, "listDirectories", new Object[]{dirName}, LIST_DIRECTORIES_SIGNATURE}, INVOKE_SIGNATURE, READER_ROLE);
        }
        catch (Exception e) {
            this.throwException(e);
            return null;
        }
    }

    IElementIdentity[] listElements(String dirName) throws DirectoryServiceException, NamingException {
        this.checkIdleTimeout();
        try {
            return (IElementIdentity[])this.m_connector.invoke(COMMS_TYPE, this.m_dsName, this.m_dsName, INVOKE_OPERATION, new Object[]{this.m_dsObjectName, "listElements", new Object[]{dirName}, LIST_ELEMENTS_SIGNATURE}, INVOKE_SIGNATURE, READER_ROLE);
        }
        catch (Exception e) {
            this.throwException(e);
            return null;
        }
    }

    IIdentity lookupIdentity(String identityName) throws DirectoryServiceException, NamingException {
        this.checkIdleTimeout();
        try {
            return (IIdentity)this.m_connector.invoke(COMMS_TYPE, this.m_dsName, this.m_dsName, INVOKE_OPERATION, new Object[]{this.m_dsObjectName, "lookupIdentity", new Object[]{identityName}, LOOKUP_IDENITY_SIGNATURE}, INVOKE_SIGNATURE, READER_ROLE);
        }
        catch (Exception e) {
            this.throwException(e);
            return null;
        }
    }

    IIdentity[] listAll(String dirName) throws DirectoryServiceException, NamingException {
        this.checkIdleTimeout();
        try {
            return (IIdentity[])this.m_connector.invoke(COMMS_TYPE, this.m_dsName, this.m_dsName, INVOKE_OPERATION, new Object[]{this.m_dsObjectName, "listAll", new Object[]{dirName}, LIST_ALL_SIGNATURE}, INVOKE_SIGNATURE, READER_ROLE);
        }
        catch (Exception e) {
            this.throwException(e);
            return null;
        }
    }

    IDirElement[] getAllElements(String dirName, boolean forUpdate) throws DirectoryServiceException, NamingException {
        this.checkIdleTimeout();
        try {
            return (IDirElement[])this.m_connector.invoke(COMMS_TYPE, this.m_dsName, this.m_dsName, INVOKE_OPERATION, new Object[]{this.m_dsObjectName, "getAllElements", new Object[]{dirName, new Boolean(forUpdate)}, GET_ALL_ELEMENTS_SIGNATURE1}, INVOKE_SIGNATURE, READER_ROLE);
        }
        catch (Exception e) {
            this.throwException(e);
            return null;
        }
    }

    IDirIdentity[] getAllDirectories(String dirName) throws DirectoryServiceException, NamingException {
        this.checkIdleTimeout();
        try {
            return (IDirIdentity[])this.m_connector.invoke(COMMS_TYPE, this.m_dsName, this.m_dsName, INVOKE_OPERATION, new Object[]{this.m_dsObjectName, "listDirectories", new Object[]{dirName}, GET_ALL_DIRECTORIES_SIGNATURE1}, INVOKE_SIGNATURE, READER_ROLE);
        }
        catch (Exception e) {
            this.throwException(e);
            return null;
        }
    }

    String resolveURL(String url) throws DirectoryServiceException, NamingException {
        this.checkIdleTimeout();
        try {
            return (String)this.m_connector.invoke(COMMS_TYPE, this.m_dsName, this.m_dsName, INVOKE_OPERATION, new Object[]{this.m_dsObjectName, "resolveURL", new Object[]{url}, RESOLVE_URL_SIGNATURE}, INVOKE_SIGNATURE, READER_ROLE);
        }
        catch (Exception e) {
            this.throwException(e);
            return null;
        }
    }

    private synchronized void checkIdleTimeout() throws NamingException {
        this.m_lastUsageTime = System.currentTimeMillis();
        if (this.m_manager.getConnector() == null) {
            this.m_manager.connect();
            this.init();
        }
    }

    private void throwException(Exception e) throws DirectoryServiceException, NamingException {
        if (e instanceof MFSecurityException) {
            throw new NoPermissionException(e.getMessage());
        }
        Exception mappedException = this.mapException(e);
        if (mappedException instanceof DirectoryServiceException) {
            throw (DirectoryServiceException)mappedException;
        }
        NamingException namingException = new NamingException();
        namingException.setRootCause(e);
        throw namingException;
    }

    private Exception mapException(Exception exception) {
        Class<?> exceptionClass = exception.getClass();
        Method getTargetExceptionMethod = null;
        try {
            getTargetExceptionMethod = exceptionClass.getMethod("getTargetException", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            return exception;
        }
        Object exceptionObject = null;
        try {
            exceptionObject = getTargetExceptionMethod.invoke((Object)exception, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error extracting target exception");
        }
        if (exceptionObject == null) {
            return exception;
        }
        return this.mapException((Exception)exceptionObject);
    }

    private class IdleStateVerifier
    extends Thread {
        private IdleStateVerifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MFConnection mFConnection = MFConnection.this;
            synchronized (mFConnection) {
                long waitTime;
                while (!MFConnection.this.m_exiting && (waitTime = MFConnection.this.m_lastUsageTime + MFConnection.this.m_idleTimeout - System.currentTimeMillis()) > 0L) {
                    try {
                        MFConnection.this.wait(waitTime);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
                MFConnection.this.m_manager.disconnect();
            }
        }
    }
}

