/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.INextVersionToken;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.config.impl.DeltaAttributeSet;
import com.sonicsw.mf.common.config.impl.DeltaElement;
import com.sonicsw.mf.common.config.impl.ElementIdentity;
import com.sonicsw.mf.common.config.impl.ElementNode;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.impl.EnvelopeElement;
import com.sonicsw.mf.common.config.impl.ICanReplaceRef;
import com.sonicsw.mf.common.config.impl.IDelta;
import com.sonicsw.mf.common.config.impl.IElementCache;
import com.sonicsw.mf.common.config.impl.IReplaceRef;
import com.sonicsw.mf.common.config.impl.InternalDSToken;
import com.sonicsw.mf.common.config.impl.NextVersionToken;
import com.sonicsw.mf.common.config.impl.Util;
import com.sonicsw.mf.common.config.impl.VersionMisMatchException;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mx.util.IEmptyArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Element
extends ElementNode
implements IDirElement,
ICanReplaceRef {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    private static final int USER_SERIALIZATION_VERSION = 100;
    private static final int EXTERNAL_USER_SERIALIZATION_VERSION = 101;
    static final String USER_NAME_ATTRIBUTE = "USER_NAME";
    static final String USER_PASSWORD_ATTRIBUTE = "PASSWORD";
    static final String ELEMENT_ATTRIBUTES = "|";
    static final String SYSTEM_ATTRIBUTES = "_MF_SYSTEM_ATTRIBUTES";
    static final String RELEASE_VERSION = "RELEASE_VERSION";
    static final String SUBCLASS_FROM_THIS_SUPER = "SUBCLASS_FROM_THIS_SUPER";
    static final String SUPER_REFERENCE = "SUPER_REFERENCE";
    static final String IS_SUPER_ELEMENT = "IS_SUPER_ELEMENT";
    static final String IS_TEMPLATE = "IS_TEMPLATE";
    static final String SUBCLASSING_DELTA = "SUBCLASSING_DELTA";
    static final String IS_SUBCLASSED_ELEMENT = "IS_SUBCLASSED_ELEMENT";
    static final String SUBCLASSED_ELEMENTS = "SUBCLASSED_ELEMENTS";
    private static final String MF_USER = "MF_AUTHENTICATION_USER";
    private static final String MF_EXTERNAL_USER = "MF_AUTHENTICATION_USER";
    private ElementIdentity m_identity;
    private AttributeSet m_attributes;
    private boolean m_deleted;
    private transient IElementCache m_cache;
    private transient boolean doneUpdateCalled;
    private transient boolean m_dontWriteAttributes;
    private transient IDeltaElement m_subclassingDelta;
    private static HashMap m_directories = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDirectoryName(String dirName) {
        HashMap hashMap = m_directories;
        synchronized (hashMap) {
            String retDir = (String)m_directories.get(dirName);
            if (retDir == null) {
                retDir = dirName;
                m_directories.put(dirName, dirName);
            }
            return retDir;
        }
    }

    public void dontWriteAttributes(boolean dont) {
        this.m_dontWriteAttributes = dont;
    }

    public void setDeleted() {
        this.m_deleted = true;
        this.m_readOnly = true;
    }

    public void setNewIdentity(ElementIdentity id) {
        this.m_identity = id;
    }

    @Override
    public IDirElement getNextVersion(INextVersionToken token) {
        boolean internalDSToken = token instanceof InternalDSToken;
        if (this.m_deleted) {
            throw new IllegalStateException("getNextVersion cannot be called on deleted elements.");
        }
        if (token == null) {
            throw new IllegalStateException("A null token was passed to getNextVersion().");
        }
        ElementIdentity tokenID = null;
        if (!internalDSToken) {
            tokenID = ((NextVersionToken)token).getID(this.m_identity.getName());
        }
        if (!internalDSToken && tokenID == null) {
            throw new IllegalStateException("No next version token for " + this.m_identity);
        }
        if (internalDSToken) {
            if (this.m_identity.getCreationTimestamp() == 0L) {
                throw new IllegalStateException("The InternalDSToken cannot be used on new elements.");
            }
            long version = this.m_identity.getVersion();
            Element newElement = (Element)this.createWritableClone();
            ((ElementIdentity)newElement.getIdentity()).setVersion(version + 1L);
            return newElement;
        }
        if (tokenID == null) {
            throw new IllegalStateException("Invalid token used by getNextVersion on " + this.m_identity + " token id: null");
        }
        if (this.m_identity.getCreationTimestamp() != 0L) {
            if (this.m_identity.getVersion() < tokenID.getVersion()) {
                throw new IllegalStateException("Invalid token used by getNextVersion on " + this.m_identity + " token id: " + tokenID);
            }
            if (!this.m_identity.equalVersion(tokenID)) {
                return this;
            }
        } else if (tokenID.getVersion() != 1L) {
            throw new IllegalStateException("Invalid token used by getNextVersion on " + this.m_identity + " token id: " + tokenID);
        }
        if (!this.m_readOnly) {
            throw new IllegalStateException("getNextVersion should be called on read-only elements.");
        }
        Element newElement = (Element)this.createWritableClone();
        ElementIdentity newID = tokenID.createClone();
        newID.setVersion(this.m_identity.getVersion() + 1L);
        newElement.setNewIdentity(newID);
        return newElement;
    }

    public Element(String name, String elementTypeName, String releaseVersion, boolean createTemplate) {
        this(name, elementTypeName, releaseVersion);
        if (createTemplate) {
            this.setTemplate();
        }
    }

    public Element(String name, String elementTypeName, String releaseVersion, String tamplateName) {
        this(name, elementTypeName, releaseVersion);
        if (tamplateName != null) {
            this.addSuperToSubclassFrom(tamplateName);
        }
    }

    public Element(String name, String elementTypeName, String releaseVersion) {
        super("", null);
        this.m_identity = new ElementIdentity(name, elementTypeName, releaseVersion);
        this.m_attributes = new AttributeSet(ELEMENT_ATTRIBUTES, (ElementNode)this, null);
        this.m_deleted = false;
        this.doneUpdateCalled = false;
        this.m_dontWriteAttributes = false;
        this.m_cache = null;
    }

    private Element(ElementIdentity id, boolean deleted) {
        super("", null);
        this.m_identity = id;
        this.m_deleted = deleted;
        this.m_attributes = null;
        this.m_readOnly = true;
    }

    @Override
    public void setName(String newName) throws ReadOnlyException {
        if (this.m_readOnly) {
            throw new ReadOnlyException();
        }
        if (!this.m_isNew) {
            throw new IllegalStateException("Only new elements can be renamed.");
        }
        this.m_identity.setName(newName);
    }

    public DeltaElement createDelta(Element element) {
        if (this.isDeleted() || element.isDeleted()) {
            throw new Error();
        }
        Object deltaAttributeSet = Util.createDelta(this.getAttributes(), null, element.getAttributes(), null);
        if (deltaAttributeSet == null) {
            deltaAttributeSet = new DeltaAttributeSet(null, new HashMap(), new HashMap());
        }
        return new DeltaElement(this.m_identity, deltaAttributeSet);
    }

    public Element(IElementIdentity id) {
        this(id, true);
    }

    public Element(IElementIdentity id, boolean isNew) {
        super("", null);
        this.m_identity = ((ElementIdentity)id).createClone();
        this.m_attributes = new AttributeSet(ELEMENT_ATTRIBUTES, (ElementNode)this, null);
        this.m_deleted = false;
        this.doneUpdateCalled = false;
        this.m_dontWriteAttributes = false;
        this.m_cache = null;
        this.m_isNew = isNew;
    }

    public int estimateSize() {
        AttributeSet attributes = (AttributeSet)this.getAttributes();
        if (attributes != null) {
            return attributes.estimateSize() + this.m_identity.estimateSize();
        }
        return this.m_identity.estimateSize();
    }

    public static IDirElement createDeletedElement(IElementIdentity id) {
        Element element = new Element(id);
        element.m_deleted = true;
        element.m_readOnly = true;
        element.doneUpdateCalled = false;
        return element;
    }

    public void setCache(IElementCache cache) {
        if (!this.m_readOnly) {
            throw new Error("Only read-only elements can be cached.");
        }
        this.m_cache = cache;
    }

    public void cacheMe(IElementCache cache) {
        if (!this.m_readOnly) {
            throw new Error("Only read-only elements can be cached.");
        }
        this.m_cache = cache;
        this.cacheAttributes();
    }

    private void cacheAttributes() {
        if (this.m_cache == null || this.m_attributes == null) {
            return;
        }
        this.m_cache.storeAttributes(this);
        this.m_attributes = null;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        String type = this.m_identity.getType();
        if (type != null) {
            boolean userType = type.equals("MF_AUTHENTICATION_USER");
            boolean externalUserType = type.equals("MF_AUTHENTICATION_USER");
            boolean isEnvelope = this instanceof EnvelopeElement;
            if (!isEnvelope && (userType || externalUserType)) {
                this.writeUserObject(userType ? 100 : 101, s);
                return;
            }
        }
        s.writeInt(3);
        s.writeObject(this.m_identity);
        if (this.m_dontWriteAttributes) {
            s.writeObject(null);
        } else {
            s.writeObject(this.getAttributes());
        }
        s.writeBoolean(this.m_deleted);
    }

    private void writeUserObject(int type, ObjectOutputStream s) throws IOException {
        s.writeInt(type);
        EntityName fullName = Element.getEntity(this.m_identity.getName());
        s.writeObject(Element.getDirectoryName(fullName.getParent()));
        s.writeObject(fullName.getBaseName());
        s.writeLong(this.m_identity.getVersion());
        s.writeLong(this.m_identity.getCreationTimestamp());
        s.writeObject(this.m_identity.getReleaseVersion());
        s.writeBoolean(this.m_readOnly);
        s.writeBoolean(this.m_deleted);
        if (!this.m_deleted) {
            if (this.m_dontWriteAttributes) {
                s.writeBoolean(true);
                return;
            }
            s.writeBoolean(false);
            IAttributeSet attributes = this.getAttributes();
            s.writeObject(attributes.getAttribute(USER_NAME_ATTRIBUTE));
            s.writeObject(attributes.getAttribute(USER_PASSWORD_ATTRIBUTE));
        }
    }

    private void readUserObject(int type, ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.doneUpdateCalled = false;
        String dirName = (String)s.readObject();
        String baseName = (String)s.readObject();
        String name = dirName + '/' + baseName;
        long version = s.readLong();
        long creationTimestamp = s.readLong();
        String elementType = type == 101 ? "MF_AUTHENTICATION_USER" : "MF_AUTHENTICATION_USER";
        String releaseVersion = (String)s.readObject();
        this.m_identity = new ElementIdentity(name, elementType, releaseVersion);
        this.m_identity.setVersion(version);
        this.m_identity.setCreationTimestamp(creationTimestamp);
        this.m_name = "";
        this.m_readOnly = s.readBoolean();
        this.m_deleted = s.readBoolean();
        if (this.m_deleted) {
            this.m_attributes = new AttributeSet(ELEMENT_ATTRIBUTES, (ElementNode)this, null);
            this.m_attributes.setReadOnly(this.m_readOnly);
            return;
        }
        boolean didntWriteAttributes = s.readBoolean();
        if (didntWriteAttributes) {
            this.m_attributes = null;
        } else {
            String user = (String)s.readObject();
            byte[] password = (byte[])s.readObject();
            this.m_attributes = new AttributeSet(ELEMENT_ATTRIBUTES, this, user, password);
            this.m_attributes.setReadOnly(this.m_readOnly);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3 && version != 101 && version != 100) {
            Util.throwSerialVersionMismatch(version, 3);
        }
        if (version == 101 || version == 100) {
            this.readUserObject(version, s);
            return;
        }
        this.m_identity = (ElementIdentity)s.readObject();
        this.m_attributes = (AttributeSet)s.readObject();
        this.m_deleted = s.readBoolean();
        this.doneUpdateCalled = false;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public boolean isDeleted() {
        return this.m_deleted;
    }

    @Override
    public boolean isDirty() {
        return (this.m_isModified || this.m_isNew) && !this.doneUpdateCalled;
    }

    @Override
    public IBasicElement doneUpdate() throws ReadOnlyException {
        return this.doneUpdate(false);
    }

    @Override
    public IBasicElement doneUpdateForSubclassing() throws ReadOnlyException {
        String superRef = this.getSuperElementName();
        if (superRef != null) {
            throw new Error(this.m_identity.getName() + " is already subclassed from " + superRef + ".");
        }
        this.addSuperAttribute(this.m_identity.getName(), false);
        return this.doneUpdate(true);
    }

    public void removeSystemAttributes() throws ReadOnlyException, ConfigException {
        this.getAttributes().deleteAttribute(SYSTEM_ATTRIBUTES);
    }

    @Override
    public String getArchiveName() {
        String archiveName = null;
        IAttributeSet topSet = this.getAttributes();
        IAttributeSet systemAttrs = (IAttributeSet)topSet.getAttribute(SYSTEM_ATTRIBUTES);
        if (systemAttrs != null) {
            archiveName = (String)systemAttrs.getAttribute("ARCHIVE_NAME");
        }
        return archiveName;
    }

    @Override
    public String getSuperElementName() {
        IAttributeSet systemAttributes = (IAttributeSet)this.getAttributes().getAttribute(SYSTEM_ATTRIBUTES);
        if (systemAttributes != null) {
            return (String)systemAttributes.getAttribute(SUPER_REFERENCE);
        }
        return null;
    }

    public void removeSuperElementName() {
        IAttributeSet systemAttributes = (IAttributeSet)this.m_attributes.getAttribute(SYSTEM_ATTRIBUTES);
        if (systemAttributes == null) {
            return;
        }
        try {
            systemAttributes.deleteAttribute(SUPER_REFERENCE);
        }
        catch (Exception e) {
            throw new Error();
        }
    }

    public boolean isSuperElement() {
        IAttributeSet systemAttributes = (IAttributeSet)this.getAttributes().getAttribute(SYSTEM_ATTRIBUTES);
        if (systemAttributes != null) {
            Boolean isSuper = (Boolean)systemAttributes.getAttribute(IS_SUPER_ELEMENT);
            if (isSuper == null) {
                return false;
            }
            return isSuper;
        }
        return false;
    }

    @Override
    public boolean isSubclassedElement() {
        IAttributeSet systemAttributes = (IAttributeSet)this.getAttributes().getAttribute(SYSTEM_ATTRIBUTES);
        if (systemAttributes != null) {
            Boolean isSub = (Boolean)systemAttributes.getAttribute(IS_SUBCLASSED_ELEMENT);
            if (isSub == null) {
                return false;
            }
            return isSub;
        }
        return false;
    }

    public byte[] getSubclassedDelta(String subClassedName) {
        IAttributeSet systemAttributes = (IAttributeSet)this.getAttributes().getAttribute(SYSTEM_ATTRIBUTES);
        if (systemAttributes == null) {
            return null;
        }
        IAttributeSet subclassedItems = (IAttributeSet)systemAttributes.getAttribute(SUBCLASSED_ELEMENTS);
        if (subclassedItems == null) {
            return null;
        }
        return (byte[])subclassedItems.getAttribute(subClassedName);
    }

    public void removeSubclassedDelta(String subClassedName) {
        try {
            IAttributeSet systemAttributes = (IAttributeSet)this.m_attributes.getAttribute(SYSTEM_ATTRIBUTES);
            if (systemAttributes == null) {
                return;
            }
            IAttributeSet subclassedItems = (IAttributeSet)systemAttributes.getAttribute(SUBCLASSED_ELEMENTS);
            if (subclassedItems == null) {
                return;
            }
            subclassedItems.deleteAttribute(subClassedName);
            HashMap allAttributes = subclassedItems.getAttributes();
            if (allAttributes.isEmpty()) {
                systemAttributes.deleteAttribute(SUBCLASSED_ELEMENTS);
                systemAttributes.deleteAttribute(IS_SUPER_ELEMENT);
            }
        }
        catch (Exception e) {
            throw new Error();
        }
    }

    @Override
    public String[] getSubclassedList() {
        IAttributeSet systemAttributes = (IAttributeSet)this.getAttributes().getAttribute(SYSTEM_ATTRIBUTES);
        if (systemAttributes == null) {
            return IEmptyArray.EMPTY_STRING_ARRAY;
        }
        IAttributeSet subclassedItems = (IAttributeSet)systemAttributes.getAttribute(SUBCLASSED_ELEMENTS);
        if (subclassedItems == null) {
            return IEmptyArray.EMPTY_STRING_ARRAY;
        }
        HashMap allItems = subclassedItems.getAttributes();
        String[] result = new String[allItems.size()];
        Iterator iterator = allItems.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            result[i++] = (String)iterator.next();
        }
        return result;
    }

    public static DeltaElement addSubToSuperDelta(String subName, Element original) {
        try {
            IAttributeSet subList;
            IAttributeSet origAttributes = original.getAttributes();
            IAttributeSet origSystemAttributes = (IAttributeSet)origAttributes.getAttribute(SYSTEM_ATTRIBUTES);
            IAttributeSet origSubclassed = null;
            if (origSystemAttributes != null) {
                origSubclassed = (IAttributeSet)origSystemAttributes.getAttribute(SUBCLASSED_ELEMENTS);
            }
            Element base = new Element(original.getIdentity());
            IAttributeSet attributes = base.getAttributes();
            IAttributeSet systemAttributes = null;
            if (origSystemAttributes != null) {
                systemAttributes = attributes.createAttributeSet(SYSTEM_ATTRIBUTES);
            }
            if (origSubclassed != null) {
                systemAttributes.createAttributeSet(SUBCLASSED_ELEMENTS);
            }
            base.doneUpdate();
            Element modifiedBase = (Element)base.createWritableClone();
            attributes = modifiedBase.getAttributes();
            systemAttributes = (IAttributeSet)attributes.getAttribute(SYSTEM_ATTRIBUTES);
            if (systemAttributes == null) {
                systemAttributes = attributes.createAttributeSet(SYSTEM_ATTRIBUTES);
            }
            if ((subList = (IAttributeSet)systemAttributes.getAttribute(SUBCLASSED_ELEMENTS)) == null) {
                subList = systemAttributes.createAttributeSet(SUBCLASSED_ELEMENTS);
            }
            subList.setBytesAttribute(subName, new byte[0]);
            return (DeltaElement)modifiedBase.doneUpdate();
        }
        catch (Exception e) {
            throw new Error();
        }
    }

    public static DeltaElement removeSubToSuperDelta(String[] list, String itemToRemove, IElementIdentity id) {
        try {
            Element base = new Element(id);
            IAttributeSet attributes = base.getAttributes();
            IAttributeSet systemAttributes = attributes.createAttributeSet(SYSTEM_ATTRIBUTES);
            IAttributeSet subList = systemAttributes.createAttributeSet(SUBCLASSED_ELEMENTS);
            for (int i = 0; i < list.length; ++i) {
                subList.setBytesAttribute(list[i], new byte[0]);
            }
            base.doneUpdate();
            Element modifiedBase = (Element)base.createWritableClone();
            attributes = modifiedBase.getAttributes();
            systemAttributes = (IAttributeSet)attributes.getAttribute(SYSTEM_ATTRIBUTES);
            subList = (IAttributeSet)systemAttributes.getAttribute(SUBCLASSED_ELEMENTS);
            subList.deleteAttribute(itemToRemove);
            return (DeltaElement)modifiedBase.doneUpdate();
        }
        catch (Exception e) {
            throw new Error();
        }
    }

    public void cleanupSuperAttributes(boolean deleteAll, boolean clearTamplate) {
        try {
            IAttributeSet systemAttributes = (IAttributeSet)this.m_attributes.getAttribute(SYSTEM_ATTRIBUTES);
            if (systemAttributes == null) {
                return;
            }
            if (clearTamplate) {
                systemAttributes.deleteAttribute(IS_TEMPLATE);
            }
            systemAttributes.deleteAttribute(IS_SUPER_ELEMENT);
            if (deleteAll) {
                systemAttributes.deleteAttribute(SUBCLASSED_ELEMENTS);
                return;
            }
            IAttributeSet subclassedItems = (IAttributeSet)systemAttributes.getAttribute(SUBCLASSED_ELEMENTS);
            if (subclassedItems == null) {
                return;
            }
            Iterator iterator = subclassedItems.getAttributes().keySet().iterator();
            while (iterator.hasNext()) {
                subclassedItems.setBytesAttribute((String)iterator.next(), new byte[0]);
            }
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    public void addSubclassedElement(String subClassedName, byte[] serializedDelta) {
        try {
            IAttributeSet systemAttributes = (IAttributeSet)this.m_attributes.getAttribute(SYSTEM_ATTRIBUTES);
            if (systemAttributes == null) {
                systemAttributes = this.m_attributes.createAttributeSet(SYSTEM_ATTRIBUTES);
            }
            systemAttributes.setBooleanAttribute(IS_SUPER_ELEMENT, Boolean.TRUE);
            IAttributeSet subclassedItems = (IAttributeSet)systemAttributes.getAttribute(SUBCLASSED_ELEMENTS);
            if (subclassedItems == null) {
                subclassedItems = systemAttributes.createAttributeSet(SUBCLASSED_ELEMENTS);
            }
            subclassedItems.setBytesAttribute(subClassedName, serializedDelta);
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    public void addReleaseVersion(String releaseVersion) {
        try {
            IAttributeSet systemAttributes = (IAttributeSet)this.m_attributes.getAttribute(SYSTEM_ATTRIBUTES);
            if (systemAttributes == null) {
                systemAttributes = this.m_attributes.createAttributeSet(SYSTEM_ATTRIBUTES);
            }
            systemAttributes.setStringAttribute(RELEASE_VERSION, releaseVersion);
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    private void addSuperToSubclassFrom(String superName) {
        try {
            IAttributeSet systemAttributes = (IAttributeSet)this.m_attributes.getAttribute(SYSTEM_ATTRIBUTES);
            if (systemAttributes == null) {
                systemAttributes = this.m_attributes.createAttributeSet(SYSTEM_ATTRIBUTES);
            }
            systemAttributes.setReferenceAttribute(SUBCLASS_FROM_THIS_SUPER, new Reference(superName));
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    public String getSuperToSubclassFrom() {
        IAttributeSet systemAttributes = (IAttributeSet)this.getAttributes().getAttribute(SYSTEM_ATTRIBUTES);
        if (systemAttributes != null) {
            Reference ref = (Reference)systemAttributes.getAttribute(SUBCLASS_FROM_THIS_SUPER);
            if (ref == null) {
                return null;
            }
            return ref.getElementName();
        }
        return null;
    }

    public final void setTemplate() {
        try {
            IAttributeSet systemAttributes = (IAttributeSet)this.m_attributes.getAttribute(SYSTEM_ATTRIBUTES);
            if (systemAttributes == null) {
                systemAttributes = this.m_attributes.createAttributeSet(SYSTEM_ATTRIBUTES);
            }
            systemAttributes.setBooleanAttribute(IS_TEMPLATE, Boolean.TRUE);
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    private void replaceSubclassingReferences(IReplaceRef replaceSrvc) {
        try {
            String[] subclassedList;
            IAttributeSet systemAttributes = (IAttributeSet)this.m_attributes.getAttribute(SYSTEM_ATTRIBUTES);
            if (systemAttributes == null) {
                return;
            }
            String superRef = (String)systemAttributes.getAttribute(SUPER_REFERENCE);
            if (superRef != null) {
                ((AttributeSet)systemAttributes).setAttributeObjectNoHistory(SUPER_REFERENCE, replaceSrvc.replace(superRef));
            }
            if ((subclassedList = this.getSubclassedList()).length == 0) {
                return;
            }
            AttributeSet subclassedItems = (AttributeSet)systemAttributes.getAttribute(SUBCLASSED_ELEMENTS);
            for (int i = 0; i < subclassedList.length; ++i) {
                subclassedItems.renameNoHistory(subclassedList[i], replaceSrvc.replace(subclassedList[i]));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Subclassing inconsistency: " + e.toString());
        }
    }

    private void replaceSubclassingDelta(IReplaceRef replaceSrvc) {
        try {
            IAttributeSet systemAttributes = (IAttributeSet)this.m_attributes.getAttribute(SYSTEM_ATTRIBUTES);
            if (systemAttributes == null) {
                return;
            }
            byte[] deltaBytes = (byte[])systemAttributes.getAttribute(SUBCLASSING_DELTA);
            if (deltaBytes == null) {
                return;
            }
            DeltaElement newDelta = DeltaElement.fromBytes(deltaBytes);
            newDelta.replaceReferences(false, replaceSrvc);
            ((AttributeSet)systemAttributes).setAttributeObjectNoHistory(SUBCLASSING_DELTA, newDelta.toBytes());
            this.m_subclassingDelta = null;
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    public void setSubclassingDelta(byte[] delta) {
        try {
            IAttributeSet systemAttributes = (IAttributeSet)this.m_attributes.getAttribute(SYSTEM_ATTRIBUTES);
            if (systemAttributes == null) {
                systemAttributes = this.m_attributes.createAttributeSet(SYSTEM_ATTRIBUTES);
            }
            ((AttributeSet)systemAttributes).setAttributeObjectNoHistory(SUBCLASSING_DELTA, delta);
            this.m_subclassingDelta = null;
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    @Override
    public boolean isTemplate() {
        IAttributeSet systemAttributes = (IAttributeSet)this.getAttributes().getAttribute(SYSTEM_ATTRIBUTES);
        if (systemAttributes != null) {
            Boolean isTemplate = (Boolean)systemAttributes.getAttribute(IS_TEMPLATE);
            if (isTemplate == null) {
                return false;
            }
            return isTemplate;
        }
        return false;
    }

    @Override
    public IDeltaElement getSubclassingDelta() {
        if (this.m_subclassingDelta != null) {
            return this.m_subclassingDelta;
        }
        IAttributeSet systemAttributes = (IAttributeSet)this.getAttributes().getAttribute(SYSTEM_ATTRIBUTES);
        if (systemAttributes != null) {
            byte[] deltaBytes = (byte[])systemAttributes.getAttribute(SUBCLASSING_DELTA);
            if (deltaBytes == null) {
                return null;
            }
            this.m_subclassingDelta = DeltaElement.fromBytes(deltaBytes);
            return this.m_subclassingDelta;
        }
        return null;
    }

    public void addSuperAttribute(String superClassName) {
        this.addSuperAttribute(superClassName, true);
    }

    public void addSuperAttribute(String superClassName, boolean addIsSubclassedTag) {
        try {
            IAttributeSet systemAttributes = (IAttributeSet)this.m_attributes.getAttribute(SYSTEM_ATTRIBUTES);
            if (systemAttributes == null) {
                systemAttributes = this.m_attributes.createAttributeSet(SYSTEM_ATTRIBUTES);
            }
            if (addIsSubclassedTag) {
                systemAttributes.setBooleanAttribute(IS_SUBCLASSED_ELEMENT, Boolean.TRUE);
            }
            systemAttributes.setStringAttribute(SUPER_REFERENCE, superClassName);
        }
        catch (Exception e) {
            throw new Error(e.toString());
        }
    }

    private IBasicElement doneUpdate(boolean forSubclassing) throws ReadOnlyException {
        if (this.doneUpdateCalled) {
            return null;
        }
        if (this.m_readOnly) {
            throw new ReadOnlyException();
        }
        IBasicElement retElement = null;
        if (this.isNew()) {
            if (forSubclassing) {
                throw new Error("Cannot call doneUpdateForSubclassing() on a new element.");
            }
            retElement = this;
        } else {
            retElement = (IBasicElement)((Object)this.createDelta(forSubclassing));
        }
        DeltaElement subclassingDelta = (DeltaElement)this.getSubclassingDelta();
        if (!forSubclassing && subclassingDelta != null && retElement instanceof DeltaElement) {
            subclassingDelta.adjustToSubclassedModification((DeltaElement)retElement);
            this.setSubclassingDelta(subclassingDelta.toBytes());
        }
        this.setReadOnly(true);
        this.doneUpdateCalled = true;
        return retElement;
    }

    @Override
    void markModified(String attributeName, boolean oldValueExistsNotused, boolean deletionnotUsed) {
        if (!attributeName.equals(ELEMENT_ATTRIBUTES)) {
            throw new Error();
        }
        this.markTreeModified();
    }

    @Override
    void delete() {
    }

    @Override
    Object getNameFromParent(Object listItem) {
        throw new Error();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
        if (this.m_attributes != null) {
            this.m_attributes.setReadOnly(readOnly);
        }
    }

    @Override
    public void applyDelta(IDelta delta) throws AttributeSetTypeException {
        throw new Error("This is not needed in Element and will not be implemented - use doApplyDelta");
    }

    @Override
    public void removeDeltaHistory() {
        this.m_attributes.removeDeltaHistory();
        this.m_isNew = true;
    }

    public void doApplyDelta(IDeltaElement deltaElement) throws VersionMisMatchException {
        if (deltaElement.isDeleted()) {
            throw new Error("Tried to apply a deleted delta.");
        }
        long thisVersion = this.m_identity.getVersion();
        long deltaVersion = deltaElement.getIdentity().getVersion();
        if (deltaVersion != thisVersion) {
            throw new VersionMisMatchException(deltaVersion < thisVersion);
        }
        Object newAttributes = deltaElement.getDeltaAttributes();
        if (newAttributes instanceof AttributeSet) {
            this.m_attributes = (AttributeSet)newAttributes;
            this.cacheAttributes();
        } else {
            try {
                this.m_attributes = (AttributeSet)this.getAttributes();
                if (this.m_identity.getVersion() == deltaVersion) {
                    this.m_attributes.applyDelta((DeltaAttributeSet)newAttributes);
                }
                this.cacheAttributes();
            }
            catch (AttributeSetTypeException e) {
                throw new Error("Could not apply the delta attribute set: " + e.toString());
            }
        }
        this.m_identity.setVersion(thisVersion + 1L);
    }

    public void revertToTemplate(AttributeName[] attributes, String subName) {
        DeltaElement subClassingDelta = DeltaElement.fromBytes(this.getSubclassedDelta(subName));
        ((DeltaAttributeSet)subClassingDelta.getDeltaAttributes()).revertToTemplate(attributes);
        ElementIdentity id = (ElementIdentity)subClassingDelta.getIdentity();
        id.setVersion(id.getVersion() + 1L);
        this.addSubclassedElement(subName, subClassingDelta.toBytes());
    }

    @Override
    public IDelta createDelta(boolean forSubclassing) {
        if (this.isNew()) {
            throw new Error();
        }
        boolean isSubclassedElement = this.getSuperElementName() != null;
        Object attributesDelta = null;
        attributesDelta = this.m_attributes.isNew() ? this.m_attributes : this.m_attributes.createDelta(forSubclassing || isSubclassedElement);
        return new DeltaElement(this.m_identity, attributesDelta);
    }

    @Override
    public IElementIdentity getIdentity() {
        return this.m_identity;
    }

    @Override
    public IAttributeSet getAttributes() {
        AttributeSet attributes = null;
        attributes = this.m_attributes != null || this.m_cache == null ? this.m_attributes : (AttributeSet)this.m_cache.getAttributes(this);
        return attributes;
    }

    @Override
    public IElement createWritableClone() {
        Element element = (Element)this.deepClone();
        element.setReadOnly(false);
        return element;
    }

    public Element createHeaderClone() {
        return new Element(this.m_identity.createClone(), this.m_deleted);
    }

    public IElement createClone() {
        Element element = (Element)this.deepClone();
        return element;
    }

    public IElement createWritableClone(String elementName, String typeName, String releaseVersion) {
        throw new Error("Not Implemented");
    }

    public String toString() {
        return "Element " + this.m_identity.toString();
    }

    @Override
    public Object getAttribute(AttributeName attributeName) {
        if (this.isDeleted()) {
            throw new Error("The element is deleted");
        }
        if (attributeName.getComponentCount() == 0) {
            return this.getAttributes();
        }
        return this.getAttributes().getAttribute(attributeName);
    }

    @Override
    boolean checkSubclassingDelta(AttributeName name) {
        DeltaElement delta = (DeltaElement)this.getSubclassingDelta();
        if (delta == null) {
            return false;
        }
        return delta.inSuperElement(name);
    }

    @Override
    String[] checkSubclassingDeletedAttributes(AttributeName name) {
        if (this.isDirty()) {
            throw new Error(this.m_name + " is modified. Cannot call getDeletedAttributesInThisSubclassed in a modified element.");
        }
        DeltaElement delta = (DeltaElement)this.getSubclassingDelta();
        if (delta == null) {
            return new String[0];
        }
        return delta.getDeletedAttributes(name);
    }

    public static HashMap groupByParentDir(IDirElement[] elements) {
        HashMap<String, ArrayList<IDirElement>> groups = new HashMap<String, ArrayList<IDirElement>>();
        for (int i = 0; i < elements.length; ++i) {
            EntityName eName = Element.getEntity(elements[i].getIdentity().getName());
            String parentName = eName.getParent();
            ArrayList<IDirElement> group = (ArrayList<IDirElement>)groups.get(parentName);
            if (group == null) {
                group = new ArrayList<IDirElement>();
                groups.put(parentName, group);
            }
            group.add(elements[i]);
        }
        return groups;
    }

    private static EntityName getEntity(String name) {
        EntityName entity = null;
        try {
            entity = new EntityName(name);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(name + " is illegal.");
        }
        return entity;
    }

    @Override
    public boolean replaceReferences(boolean isSystemAtts, IReplaceRef replaceSrvc) {
        this.replaceSubclassingDelta(replaceSrvc);
        this.replaceSubclassingReferences(replaceSrvc);
        return this.m_attributes.replaceReferences(false, replaceSrvc);
    }

    public DeltaElement findSuperDelta(String subclassedName) {
        String[] oldSubList = this.getSubclassedList();
        DeltaElement superDelta = Element.removeSubToSuperDelta(oldSubList, subclassedName, this.getIdentity());
        this.removeSubclassedDelta(subclassedName);
        return superDelta;
    }

    public Element cleanupSuperElement(boolean deleteAll, boolean clearTemplate) {
        this.setReadOnly(false);
        this.cleanupSuperAttributes(deleteAll, clearTemplate);
        return (Element)this.createClone();
    }
}

