/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.config.query.impl.Util;
import java.util.HashMap;
import java.util.Iterator;

public final class AttributeAssociationTree {
    private AttributeSetNode m_tree;

    public int size() {
        return this.m_tree.size();
    }

    public AttributeAssociationTree() {
        this.m_tree = new AttributeSetNode();
    }

    public AttributeAssociationTree(AttributeSetNode node) {
        this.m_tree = node;
    }

    public Object getSubtree(Object name) {
        Object node = this.m_tree.get(name);
        if (node == null) {
            return null;
        }
        if (node instanceof AttributeSetNode) {
            return new AttributeAssociationTree((AttributeSetNode)node);
        }
        if (node instanceof Payload) {
            return ((Payload)node).getValue();
        }
        throw new IllegalArgumentException();
    }

    public void insertPayload(AttributeName attName, Object payLoad) {
        if (attName.getComponentCount() == 0) {
            this.m_tree.insertPayload(payLoad);
        } else {
            this.m_tree.insertPayload(attName.getComponent(0), Util.removeFirstComponent((AttributeName)attName), payLoad);
        }
    }

    public void removeNode(AttributeName attName) {
        if (attName.getComponentCount() == 0) {
            this.m_tree.clear();
        } else {
            this.m_tree.removeNode(attName.getComponent(0), Util.removeFirstComponent((AttributeName)attName));
        }
    }

    public Object removePayload(AttributeName attName) {
        if (attName.getComponentCount() == 0) {
            return this.m_tree.removePayload();
        }
        return this.m_tree.removePayload(attName.getComponent(0), Util.removeFirstComponent((AttributeName)attName));
    }

    public Object getPayload(AttributeName attName) {
        if (attName.getComponentCount() == 0) {
            return this.m_tree.getPayload();
        }
        return this.m_tree.getPayload(attName.getComponent(0), Util.removeFirstComponent((AttributeName)attName));
    }

    private class AttributeSetNode
    extends HashMap {
        private int m_level;
        private Object m_payLoad;

        AttributeSetNode() {
            this(0);
        }

        AttributeSetNode(int level) {
            this.m_level = level;
            this.m_payLoad = null;
        }

        @Override
        public String toString() {
            Iterator iterator = this.keySet().iterator();
            String result = this.m_payLoad != null ? "P " : "NP ";
            String spaces = "";
            for (int i = 0; i < this.m_level; ++i) {
                spaces = spaces + "  ";
            }
            while (iterator.hasNext()) {
                Object attName = iterator.next();
                result = result + "\n" + spaces + attName;
                Object node = this.get(attName);
                if (!(node instanceof AttributeSetNode)) continue;
                result = result + node.toString();
            }
            return result;
        }

        void insertPayload(Object payLoad) {
            this.m_payLoad = payLoad;
        }

        Object removePayload() {
            Object payLoad = this.m_payLoad;
            this.m_payLoad = null;
            return payLoad;
        }

        Object getPayload() {
            return this.m_payLoad;
        }

        Object removePayload(Object attName, AttributeName nameLowerLevels) {
            Object nextLevel = this.validateAndRetrieveAttribute(attName);
            if (nextLevel == null) {
                return null;
            }
            if (nameLowerLevels.getComponentCount() == 0) {
                if (nextLevel instanceof AttributeSetNode) {
                    return ((AttributeSetNode)nextLevel).removePayload();
                }
                return ((Payload)this.remove(attName)).getValue();
            }
            this.checkIsAttributeSetNode(nextLevel);
            return ((AttributeSetNode)nextLevel).removePayload(nameLowerLevels.getComponent(0), Util.removeFirstComponent((AttributeName)nameLowerLevels));
        }

        Object getPayload(Object attName, AttributeName nameLowerLevels) {
            Object nextLevel = this.validateAndRetrieveAttribute(attName);
            if (nextLevel == null) {
                return null;
            }
            if (nameLowerLevels.getComponentCount() == 0) {
                if (nextLevel instanceof AttributeSetNode) {
                    return ((AttributeSetNode)nextLevel).getPayload();
                }
                return ((Payload)nextLevel).getValue();
            }
            this.checkIsAttributeSetNode(nextLevel);
            return ((AttributeSetNode)nextLevel).getPayload(nameLowerLevels.getComponent(0), Util.removeFirstComponent((AttributeName)nameLowerLevels));
        }

        private void checkIsAttributeSetNode(Object nextLevel) {
            if (!(nextLevel instanceof AttributeSetNode)) {
                throw new IllegalArgumentException();
            }
        }

        void removeNode(Object attName, AttributeName nameLowerLevels) {
            Object nextLevel;
            this.checkCorrectType(attName);
            if (nameLowerLevels.getComponentCount() == 0) {
                this.remove(attName);
            }
            if ((nextLevel = this.get(attName)) == null) {
                return;
            }
            if (!(nextLevel instanceof AttributeSetNode)) {
                throw new IllegalArgumentException();
            }
            ((AttributeSetNode)nextLevel).removeNode(nameLowerLevels.getComponent(0), Util.removeFirstComponent((AttributeName)nameLowerLevels));
        }

        void insertPayload(Object attName, AttributeName nameLowerLevels, Object payLoad) {
            Object insertedBefore = this.validateAndRetrieveAttribute(attName);
            if (nameLowerLevels.getComponentCount() == 0) {
                if (insertedBefore != null && insertedBefore instanceof AttributeSetNode) {
                    ((AttributeSetNode)insertedBefore).insertPayload(payLoad);
                } else {
                    this.put(attName, new Payload(payLoad));
                }
                return;
            }
            Object nextComponent = nameLowerLevels.getComponent(0);
            if (insertedBefore == null) {
                insertedBefore = nextComponent instanceof Integer ? new AttributeListNode(this.m_level + 1) : new AttributeSetNode(this.m_level + 1);
                this.put(attName, insertedBefore);
            } else if (insertedBefore instanceof Payload) {
                AttributeSetNode replacement = nextComponent instanceof Integer ? new AttributeListNode(this.m_level + 1) : new AttributeSetNode(this.m_level + 1);
                replacement.insertPayload(((Payload)insertedBefore).getValue());
                this.put(attName, replacement);
                insertedBefore = replacement;
            }
            ((AttributeSetNode)insertedBefore).insertPayload(nextComponent, Util.removeFirstComponent((AttributeName)nameLowerLevels), payLoad);
        }

        private Object validateAndRetrieveAttribute(Object attName) {
            this.checkCorrectType(attName);
            Object insertedBefore = this.get(attName);
            return insertedBefore;
        }

        private void checkCorrectType(Object attName) {
            if (!this.correctType(attName)) {
                throw new IllegalArgumentException();
            }
        }

        boolean correctType(Object nameComponent) {
            return nameComponent instanceof String;
        }
    }

    private final class Payload {
        Object m_value;

        Payload(Object value) {
            this.m_value = value;
        }

        Object getValue() {
            return this.m_value;
        }
    }

    private final class AttributeListNode
    extends AttributeSetNode {
        AttributeListNode() {
            this(0);
        }

        AttributeListNode(int level) {
            super(level);
        }

        @Override
        boolean correctType(Object nameComponent) {
            return nameComponent instanceof Integer;
        }
    }
}

