/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.runtime.impl;

import com.sonicsw.mf.common.MFProxyException;
import com.sonicsw.mf.common.MFProxyRuntimeException;
import com.sonicsw.mf.common.runtime.IRemoteExecResult;
import com.sonicsw.mf.common.runtime.impl.RemoteExecResult;
import com.sonicsw.mx.util.IEmptyArray;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class ExecUtility {
    public static final String NEWLINE = System.getProperty("line.separator");

    public static RemoteExecResult exec(String[] cmdarray, String[] envp, String workDirPath, byte[] inputBytes) {
        ExecProcess p = null;
        try {
            p = new ExecProcess(cmdarray, envp, workDirPath, inputBytes);
            p.exec();
            int exitCode = p.waitFor();
            return new RemoteExecResult(true, p.getIOExceptionsTrace(), exitCode, p.getOutData(), p.getErrData());
        }
        catch (Exception e) {
            return new RemoteExecResult(false, ExecUtility.printStackTrace((Throwable)e, "com.sonicsw.mf.framework.agent.ExecUtility failed:"), 1, null, null);
        }
    }

    public static String execResultOutputToString(IRemoteExecResult result) {
        byte[] outBytes = result.getProcessStdOutput();
        String outputString = outBytes != null && outBytes.length > 0 ? new String(outBytes) : null;
        byte[] errBytes = result.getProcessStdError();
        String errString = errBytes != null && errBytes.length > 0 ? new String(errBytes) : null;
        String rsltString = outputString;
        if (errString != null) {
            rsltString = rsltString == null ? errString : rsltString + System.getProperty("line.separator") + errString;
        }
        return rsltString != null ? rsltString : "";
    }

    public static String printStackTrace(Throwable exception, String message) {
        StringBuffer buffer = new StringBuffer(message);
        buffer.append(NEWLINE);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(out, true);
        ExecUtility.printStackTrace(exception, writer);
        byte[] data = out.toByteArray();
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        buffer.append(new String(data));
        return buffer.toString();
    }

    public static void printStackTrace(Throwable exception, PrintWriter writer) {
        if (exception == null) {
            writer.println("Exception = null");
            return;
        }
        exception.printStackTrace(writer);
        Throwable cause = exception.getCause();
        Class<?> exceptionClass = exception.getClass();
        try {
            Method getTargetExceptionMethod = exceptionClass.getMethod("getTargetException", IEmptyArray.EMPTY_CLASS_ARRAY);
            Throwable targetException = (Throwable)getTargetExceptionMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (targetException != null) {
                if (!targetException.equals(cause)) {
                    writer.print("Caused by: ");
                    ExecUtility.printStackTrace(targetException, writer);
                }
                return;
            }
        }
        catch (NoSuchMethodException getTargetExceptionMethod) {
        }
        catch (IllegalAccessException getTargetExceptionMethod) {
        }
        catch (InvocationTargetException getTargetExceptionMethod) {
            // empty catch block
        }
        try {
            Method getTargetErrorMethod = exceptionClass.getMethod("getTargetError", IEmptyArray.EMPTY_CLASS_ARRAY);
            Throwable targetError = (Throwable)getTargetErrorMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (targetError != null) {
                if (!targetError.equals(cause)) {
                    writer.print("Caused by: ");
                    ExecUtility.printStackTrace(targetError, writer);
                }
                return;
            }
        }
        catch (NoSuchMethodException getTargetErrorMethod) {
        }
        catch (IllegalAccessException getTargetErrorMethod) {
        }
        catch (InvocationTargetException getTargetErrorMethod) {
            // empty catch block
        }
        try {
            Method getLinkedExceptionMethod = exceptionClass.getMethod("getLinkedException", IEmptyArray.EMPTY_CLASS_ARRAY);
            Throwable linkedException = (Throwable)getLinkedExceptionMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
            if (linkedException != null) {
                if (!linkedException.equals(cause)) {
                    writer.print("Caused by: ");
                    ExecUtility.printStackTrace(linkedException, writer);
                }
                return;
            }
        }
        catch (NoSuchMethodException getLinkedExceptionMethod) {
        }
        catch (IllegalAccessException getLinkedExceptionMethod) {
        }
        catch (InvocationTargetException getLinkedExceptionMethod) {
            // empty catch block
        }
        if (!exceptionClass.getName().equals(MFProxyRuntimeException.class.getName()) && !exceptionClass.getName().equals(MFProxyException.class.getName())) {
            try {
                Method getActualExceptionMethod = exceptionClass.getMethod("getActualException", IEmptyArray.EMPTY_CLASS_ARRAY);
                Throwable actualException = (Throwable)getActualExceptionMethod.invoke((Object)exception, IEmptyArray.EMPTY_OBJECT_ARRAY);
                if (actualException != null) {
                    if (!actualException.equals(cause)) {
                        writer.print("Caused by: ");
                        ExecUtility.printStackTrace(cause, writer);
                    }
                    return;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private static class ExecProcess {
        private String[] m_execCommand;
        private File m_workDir;
        private String[] m_envp;
        private Process m_systemProcess;
        private byte[] m_inputBytes;
        private OutputReader m_stdOutputReader;
        private OutputReader m_stdErrorReader;
        private InputWriter m_stdInputWriter;

        ExecProcess(String[] execCommand, String[] envp, String workingDir, byte[] inputBytes) throws Exception {
            this.m_execCommand = execCommand;
            this.m_workDir = new File(workingDir != null ? workingDir : ".");
            this.m_envp = envp;
            this.m_inputBytes = inputBytes;
            if (!this.m_workDir.exists()) {
                throw new Exception("Working directory \"" + this.m_workDir.getAbsolutePath() + "\" does not exist.");
            }
        }

        byte[] getErrData() {
            return this.m_stdErrorReader.getData();
        }

        byte[] getOutData() {
            return this.m_stdOutputReader.getData();
        }

        String getIOExceptionsTrace() {
            String result;
            StringBuffer sb = new StringBuffer();
            IOException e = this.m_stdOutputReader.getException();
            if (e != null) {
                sb.append(ExecUtility.printStackTrace((Throwable)e, "Reading the std output from the process failed:"));
            }
            if ((e = this.m_stdErrorReader.getException()) != null) {
                sb.append(ExecUtility.printStackTrace((Throwable)e, "Reading the std error from the process failed:"));
            }
            IOException iOException = e = this.m_stdInputWriter != null ? this.m_stdInputWriter.getException() : null;
            if (e != null) {
                sb.append(ExecUtility.printStackTrace((Throwable)e, "Writing the input to the process failed:"));
            }
            return (result = sb.toString()).length() > 0 ? result : null;
        }

        public void exec() throws Exception {
            this.m_systemProcess = Runtime.getRuntime().exec(this.m_execCommand, this.m_envp, this.m_workDir);
            this.m_stdOutputReader = new OutputReader("com.sonicsw.mf.framework.agent.ExecUtility Standard Output", this.m_systemProcess.getInputStream());
            this.m_stdErrorReader = new OutputReader("com.sonicsw.mf.framework.agent.ExecUtility Standard Error", this.m_systemProcess.getErrorStream());
            this.m_stdOutputReader.start();
            this.m_stdErrorReader.start();
            if (this.m_inputBytes != null) {
                this.m_stdInputWriter = new InputWriter("com.sonicsw.mf.framework.agent.ExecUtility Standard Input", this.m_systemProcess.getOutputStream(), this.m_inputBytes);
                this.m_stdInputWriter.start();
            } else {
                this.m_systemProcess.getOutputStream().close();
            }
        }

        int waitFor() {
            while (true) {
                try {
                    int exiCode = this.m_systemProcess.waitFor();
                    this.m_stdOutputReader.processExited();
                    this.m_stdErrorReader.processExited();
                    this.m_stdOutputReader.waitForOutput();
                    this.m_stdErrorReader.waitForOutput();
                    return exiCode;
                }
                catch (InterruptedException e) {
                    this.m_systemProcess.destroy();
                    continue;
                }
                break;
            }
        }

        private final class InputWriter
        extends Thread {
            private OutputStream m_stream;
            private byte[] m_outputBytes;
            private IOException m_exception;

            private InputWriter(String threadName, OutputStream stream, byte[] outputBytes) {
                super(threadName);
                this.setDaemon(true);
                this.m_stream = stream;
                this.m_outputBytes = outputBytes;
            }

            IOException getException() {
                return this.m_exception;
            }

            @Override
            public void run() {
                try {
                    if (this.m_outputBytes.length > 0) {
                        this.m_stream.write(this.m_outputBytes);
                    }
                    this.m_stream.close();
                }
                catch (IOException e) {
                    this.m_exception = e;
                }
            }
        }

        private final class OutputReader
        extends Thread {
            private InputStream m_stream;
            private ArrayList<byte[]> m_buffers;
            private byte[] m_buffer;
            private byte[] m_data;
            private boolean m_outputReady;
            private IOException m_exception;
            private boolean m_stop;
            private volatile boolean m_stopRequest;

            private OutputReader(String threadName, InputStream stream) {
                super(threadName);
                this.setDaemon(true);
                this.m_stream = stream;
                this.m_buffer = new byte[8196];
                this.m_buffers = new ArrayList();
                this.m_outputReady = false;
                this.m_stopRequest = false;
                this.m_stop = false;
            }

            byte[] getData() {
                return this.m_data;
            }

            IOException getException() {
                return this.m_exception;
            }

            void prepareData() {
                int totalLength = 0;
                for (int i = 0; i < this.m_buffers.size(); ++i) {
                    totalLength += this.m_buffers.get(i).length;
                }
                this.m_data = new byte[totalLength];
                int crntOffset = 0;
                for (int i = 0; i < this.m_buffers.size(); ++i) {
                    byte[] crntBuffer = this.m_buffers.get(i);
                    System.arraycopy(crntBuffer, 0, this.m_data, crntOffset, crntBuffer.length);
                    crntOffset += crntBuffer.length;
                }
            }

            void processExited() {
                this.m_stopRequest = true;
            }

            private synchronized void waitForOutput() {
                while (!this.m_outputReady) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            private synchronized void outputReady() {
                this.m_outputReady = true;
                this.notifyAll();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        int available;
                        if ((available = this.m_stream.available()) > 0) {
                            int count;
                            if (available > this.m_buffer.length) {
                                available = this.m_buffer.length;
                            }
                            if ((count = this.m_stream.read(this.m_buffer, 0, available)) < 0) break;
                            if (count == 0) continue;
                            byte[] crntBuffer = new byte[count];
                            System.arraycopy(this.m_buffer, 0, crntBuffer, 0, count);
                            this.m_buffers.add(crntBuffer);
                        } else {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (this.m_stop) break;
                        if (!this.m_stopRequest) continue;
                        this.m_stop = true;
                    }
                    this.prepareData();
                }
                catch (IOException e) {
                    this.m_exception = e;
                }
                finally {
                    this.outputReady();
                }
            }
        }
    }
}

