/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.jndi.mfcontext;

import com.sonicsw.jndi.mfcontext.MFConnection;
import com.sonicsw.mf.comm.IExceptionListener;
import com.sonicsw.mf.comm.jms.ConnectorClient;
import com.sonicsw.mf.common.MFSecurityException;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;

public final class MFConnectionManager
implements IExceptionListener {
    private static Hashtable s_managers = new Hashtable();
    private static LockManager s_lockManager = new LockManager();
    private ConnectorClient m_connector = null;
    private Hashtable m_env;
    private long m_connectTimeout;
    private long m_socketConnectTimeout;
    private long m_initialConnectTimeout;
    private long m_requestTimeout;
    private String m_draNode;
    MFConnection m_connection = null;
    private int m_referenceCount;
    private String m_id;
    private final boolean useLockManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MFConnectionManager getManager(String urls, String user, String password, String draNode, String domainName, long idleTimeout, String connectTimeout, String socketConnectTimeout, String requestTimeout, boolean ... useLockManager) throws NamingException {
        MFConnectionManager manager;
        String ID = urls + user + password + draNode + domainName + idleTimeout + connectTimeout + socketConnectTimeout + requestTimeout;
        if (useLockManager == null || useLockManager[0]) {
            Object object = s_lockManager.getLock(ID);
            synchronized (object) {
                manager = (MFConnectionManager)s_managers.get(ID);
                if (manager == null) {
                    manager = new MFConnectionManager(urls, user, password, draNode, domainName, idleTimeout, Long.valueOf(connectTimeout), Long.valueOf(socketConnectTimeout), Long.valueOf(requestTimeout), ID, true);
                    s_managers.put(ID, manager);
                } else {
                    manager.incRefCount();
                }
            }
        } else {
            manager = new MFConnectionManager(urls, user, password, draNode, domainName, idleTimeout, Long.valueOf(connectTimeout), Long.valueOf(socketConnectTimeout), Long.valueOf(requestTimeout), ID, false);
        }
        return manager;
    }

    MFConnectionManager(String urls, String user, String password, String draNode, String domainName, long idleTimeout, long connectTimeout, long socketConnectTimeout, long requestTimeout, String ID, boolean useLockManager) throws NamingException {
        this.useLockManager = useLockManager;
        this.m_id = ID;
        this.m_connectTimeout = connectTimeout;
        this.m_socketConnectTimeout = socketConnectTimeout;
        this.m_initialConnectTimeout = connectTimeout;
        this.m_requestTimeout = requestTimeout;
        this.m_draNode = draNode;
        this.m_referenceCount = 1;
        this.m_env = new Hashtable();
        this.m_env.put("ConnectionURLs", urls);
        this.m_env.put("DefaultUser", user == null ? "" : user);
        this.m_env.put("DefaultPassword", password == null ? "" : password);
        this.connect();
        this.m_connection = new MFConnection(this, domainName, idleTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect() throws NamingException {
        if (this.useLockManager) {
            Object object = s_lockManager.getLock(this.m_id);
            synchronized (object) {
                this.execConnect();
            }
        } else {
            this.execConnect();
        }
    }

    private void execConnect() throws NamingException {
        try {
            this.m_connector = new ConnectorClient("JNDICLIENT");
            this.m_connector.setDeliveryMode(1);
            this.m_connector.setExceptionListener(this);
            this.m_connector.setConnectTimeout(this.m_connectTimeout);
            this.m_connector.setSocketConnectTimeout(this.m_socketConnectTimeout);
            this.m_connector.setRequestTimeout(this.m_requestTimeout);
            this.m_connector.setDurable(false);
            if (this.m_draNode != null && this.m_draNode.length() > 0) {
                this.m_connector.setManagementNode(this.m_draNode);
            }
            this.m_connector.connect(this.m_env, this.m_initialConnectTimeout > 0L ? this.m_initialConnectTimeout : 0L);
        }
        catch (MFSecurityException e) {
            throw new AuthenticationException(e.getMessage());
        }
        catch (Exception e) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(e);
            this.m_connector = null;
            throw namingException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        if (this.useLockManager) {
            Object object = s_lockManager.getLock(this.m_id);
            synchronized (object) {
                this.execDisconnect();
            }
        } else {
            this.execDisconnect();
        }
    }

    private void execDisconnect() {
        if (this.m_connector != null) {
            this.m_connector.close();
            this.m_connector = null;
        }
    }

    ConnectorClient getConnector() {
        return this.m_connector;
    }

    MFConnection getConnection() {
        return this.m_connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incRefCount() {
        if (this.useLockManager) {
            Object object = s_lockManager.getLock(this.m_id);
            synchronized (object) {
                ++this.m_referenceCount;
            }
        }
    }

    void close() {
        this.cleanup(false);
    }

    @Override
    public void onException(Exception exception) {
        this.cleanup(true);
    }

    protected void finalize() {
        this.cleanup(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(boolean forceCleanup) {
        MFConnection closeConnection = null;
        if (this.useLockManager) {
            Object object = s_lockManager.getLock(this.m_id);
            synchronized (object) {
                --this.m_referenceCount;
                if (this.m_referenceCount <= 0 || forceCleanup) {
                    this.m_referenceCount = 0;
                    s_managers.remove(this.m_id);
                    this.disconnect();
                    closeConnection = this.m_connection;
                    this.m_connection = null;
                }
            }
        } else {
            this.disconnect();
            closeConnection = this.m_connection;
            this.m_connection = null;
        }
        if (closeConnection != null) {
            closeConnection.close();
        }
    }

    static class LockManager {
        private HashMap m_lockTable = new HashMap();

        LockManager() {
        }

        synchronized Object getLock(String ID) {
            Object lock = this.m_lockTable.get(ID);
            if (lock == null) {
                lock = new String("L");
                this.m_lockTable.put(ID, lock);
            }
            return lock;
        }
    }
}

