/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common;

import com.sonicsw.mf.common.IComponent;
import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.config.IElementChange;
import com.sonicsw.mf.common.config.IFSElementChange;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.info.IManagementInfo;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.INotification;
import com.sonicsw.mx.util.IEmptyArray;
import java.util.ArrayList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public abstract class AbstractComponent
implements IComponent {
    protected short m_state = 0;
    protected long m_startTime = 0L;
    protected IComponentContext m_context;
    public int m_traceMask = 0;
    private INotification m_lastStateNotification = null;
    private static final String DEFAULT_TRACE_MASK_VALUES = "1=verbose,2=set attributes,4=operation invoked,8=notification sent";
    private static final String ENABLE_METRICS_ATTR = "ENABLE_METRICS";

    @Override
    public void init(IComponentContext context) {
        this.m_context = context;
        this.m_state = 1;
    }

    @Override
    public synchronized void start() {
        this.setState((short)3);
        this.m_startTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void stop() {
        this.setState((short)1);
        this.m_startTime = 0L;
    }

    @Override
    public void destroy() {
        this.m_state = 0;
        this.m_context = null;
    }

    @Override
    public Short getState() {
        return new Short(this.m_state);
    }

    @Override
    public String getStateString() {
        return IComponentState.STATE_TEXT[this.m_state];
    }

    @Override
    public Long getUptime() {
        long uptime = this.m_startTime == 0L ? 0L : System.currentTimeMillis() - this.m_startTime;
        return new Long(uptime);
    }

    @Override
    public void enableMetrics(IMetricIdentity[] ids) {
    }

    @Override
    public void disableMetrics(IMetricIdentity[] ids) {
    }

    @Override
    public String[] getInstanceMetricNames(IMetricIdentity id) {
        return null;
    }

    @Override
    public IManagementInfo[] getManagementInfo() {
        return new IManagementInfo[0];
    }

    @Override
    public MBeanAttributeInfo[] getAttributeInfos() {
        IManagementInfo[] mgmtInfos = this.getManagementInfo();
        if (mgmtInfos == null || mgmtInfos.length == 0) {
            return null;
        }
        ArrayList<IManagementInfo> infos = new ArrayList<IManagementInfo>();
        for (int i = 0; i < mgmtInfos.length; ++i) {
            if (!(mgmtInfos[i] instanceof MBeanAttributeInfo)) continue;
            infos.add(mgmtInfos[i]);
        }
        if (infos.isEmpty()) {
            return null;
        }
        return infos.toArray(IEmptyArray.EMPTY_ATTRIBUTE_INFO_ARRAY);
    }

    @Override
    public MBeanOperationInfo[] getOperationInfos() {
        IManagementInfo[] mgmtInfos = this.getManagementInfo();
        if (mgmtInfos == null || mgmtInfos.length == 0) {
            return null;
        }
        ArrayList<IManagementInfo> infos = new ArrayList<IManagementInfo>();
        for (int i = 0; i < mgmtInfos.length; ++i) {
            if (!(mgmtInfos[i] instanceof MBeanOperationInfo)) continue;
            infos.add(mgmtInfos[i]);
        }
        if (infos.isEmpty()) {
            return null;
        }
        return infos.toArray(IEmptyArray.EMPTY_OPERATION_INFO_ARRAY);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfos() {
        IManagementInfo[] mgmtInfos = this.getManagementInfo();
        if (mgmtInfos == null || mgmtInfos.length == 0) {
            return null;
        }
        ArrayList<IManagementInfo> infos = new ArrayList<IManagementInfo>();
        for (int i = 0; i < mgmtInfos.length; ++i) {
            if (!(mgmtInfos[i] instanceof MBeanNotificationInfo)) continue;
            infos.add(mgmtInfos[i]);
        }
        if (infos.isEmpty()) {
            return null;
        }
        return infos.toArray(IEmptyArray.EMPTY_NOTIFICATION_INFO_ARRAY);
    }

    @Override
    public Integer getTraceMask() {
        return new Integer(this.m_traceMask);
    }

    @Override
    public void setTraceMask(Integer traceMask) {
        this.m_traceMask = traceMask;
        if (this.m_traceMask < 0) {
            this.m_traceMask = 0;
        }
    }

    @Override
    public String getTraceMaskValues() {
        return DEFAULT_TRACE_MASK_VALUES;
    }

    @Override
    public synchronized void handleElementChange(IElementChange elementChange) {
    }

    @Override
    public void handleFSNamingNotification(INamingNotification notification) {
    }

    @Override
    public void handleFileChange(IFSElementChange fileChange) {
    }

    protected void setState(short state) {
        if (this.m_state != state) {
            this.m_state = state;
            switch (state) {
                case 3: {
                    this.sendStateNotification(state, 3, (short)0, false);
                    break;
                }
                case 1: {
                    this.sendStateNotification(state, 3, (short)0, true);
                    break;
                }
            }
        }
    }

    protected void sendStateNotification(int state, int severityLevel, short logType) {
        this.sendStateNotification(state, severityLevel, logType, false);
    }

    private void sendStateNotification(int state, int severityLevel, short logType, boolean checkLastNotification) {
        if (checkLastNotification && this.m_lastStateNotification != null && this.m_lastStateNotification.getEventName().equals(IComponentState.STATE_TEXT[state])) {
            return;
        }
        INotification notification = this.m_context.createNotification((short)0, INotification.SUBCATEGORY_TEXT[0], IComponentState.STATE_TEXT[state], severityLevel);
        notification.setLogType(logType);
        this.m_context.sendNotification(notification);
        this.m_lastStateNotification = notification;
    }

    protected boolean matchesMetricPattern(String metricType, String metricPattern) {
        String prefix;
        if (metricType == null || metricPattern == null || metricType.length() < 1 || metricPattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        if (metricType.equals(metricPattern)) {
            return true;
        }
        if (metricPattern.equals("*")) {
            return true;
        }
        return metricPattern.endsWith("*") && metricType.startsWith(prefix = metricPattern.substring(0, metricPattern.length() - 2));
    }

    protected void validateOnline() {
        if (this.m_state != 3) {
            throw new IllegalStateException(this.m_context.getComponentName().getComponentName() + " is not online");
        }
    }
}

