/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.config.impl.NameMapper;
import com.sonicsw.mx.util.IEmptyArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class LogicalStorageNameMapper
implements Serializable {
    private static final long serialVersionUID = 0L;
    private HashMap<String, String> m_storageToLogical;
    private transient NameMapper m_logicalToStorage;
    private transient ReadWriteLock m_lock = new ReentrantReadWriteLock();
    private static final String NEWLINE = System.getProperty("line.separator");

    public static void main(String[] args) throws Exception {
        int i;
        LogicalStorageNameMapper mapper = new LogicalStorageNameMapper();
        String E1 = "/a1/b1/l1";
        String E2 = "/a1/b1/l2";
        String E3 = "/a1/b2/l3";
        String oldEr = "/a1";
        String newEr = "/x1";
        mapper.set(E1, "/V1");
        mapper.set(E2, "/V2");
        mapper.set(E3, "/V3");
        HashMap<String, String> corrections = new HashMap<String, String>();
        corrections.put("/V1", "/xxx");
        mapper.applyCorrections(corrections);
        corrections = new HashMap();
        corrections.put("/V1", E1);
        mapper.applyCorrections(corrections);
        System.out.println(mapper.storageToLogical("/V1") + " logical: " + mapper.logicalToStorage(E1));
        System.out.println(mapper.storageToLogical("/V2") + " logical: " + mapper.logicalToStorage(E2));
        System.out.println(mapper.storageToLogical("/V3") + " logical: " + mapper.logicalToStorage(E3));
        String[] fullList = mapper.scan("/a1/b1");
        for (int i2 = 0; i2 < fullList.length; ++i2) {
            System.out.println(fullList[i2]);
        }
        System.out.println();
        String[] renamedList = mapper.rename(oldEr, newEr);
        for (i = 0; i < renamedList.length; ++i) {
            System.out.println(renamedList[i]);
        }
        System.out.println();
        System.out.println("REMOVE: " + mapper.deleteByStorageName("/V1"));
        System.out.println();
        fullList = mapper.scan("/");
        for (i = 0; i < fullList.length; ++i) {
            System.out.println(fullList[i]);
        }
        System.out.println();
        System.out.println("REMOVE: " + mapper.deleteByStorageName("/V2"));
        System.out.println();
        fullList = mapper.scan("/");
        for (i = 0; i < fullList.length; ++i) {
            System.out.println(fullList[i]);
        }
        System.out.println();
        System.out.println("REMOVE: " + mapper.deleteByStorageName("/V3"));
        System.out.println();
        fullList = mapper.scan("/");
        for (i = 0; i < fullList.length; ++i) {
            System.out.println(fullList[i]);
        }
        System.out.println();
        E1 = "/a1/b1/l1";
        E2 = "/a1/b1/l2";
        E3 = "/a2/b2/l3";
        mapper.set(E1, "/V1");
        mapper.set(E2, "/V2");
        mapper.set(E3, "/V3");
        System.out.println(mapper.logicalToStorage(E1) + " " + mapper.storageToLogical("/V1"));
        System.out.println(mapper.logicalToStorage(E2) + " " + mapper.storageToLogical("/V2"));
        System.out.println(mapper.logicalToStorage(E3) + " " + mapper.storageToLogical("/V3"));
        System.out.println();
        fullList = mapper.scan("/");
        for (i = 0; i < fullList.length; ++i) {
            System.out.println(fullList[i] + " " + mapper.storageToLogical(fullList[i]));
        }
        System.out.println();
        oldEr = "/a1/b1/l1";
        newEr = "/a1/b1/x1";
        renamedList = mapper.rename(oldEr, newEr);
        for (i = 0; i < renamedList.length; ++i) {
            System.out.println("RENAMED: " + renamedList[i] + " " + mapper.storageToLogical(renamedList[i]));
        }
        System.out.println();
        System.out.println("REMOVING...");
        fullList = mapper.scan("/a1/b1");
        for (i = 0; i < fullList.length; ++i) {
            System.out.println("NAME: " + fullList[i] + " " + mapper.storageToLogical(fullList[i]));
        }
        System.out.println();
        renamedList = mapper.deleteByLogicalName("/a1/b1");
        for (i = 0; i < renamedList.length; ++i) {
            System.out.println("REMOVED ITEM: " + renamedList[i]);
        }
        System.out.println();
        fullList = mapper.scan("/");
        for (i = 0; i < fullList.length; ++i) {
            System.out.println("NAME: " + fullList[i] + " " + mapper.storageToLogical(fullList[i]));
        }
    }

    public LogicalStorageNameMapper() {
        this.init();
    }

    public int size() {
        this.m_lock.readLock().lock();
        try {
            int n = this.m_storageToLogical == null ? 0 : this.m_storageToLogical.size();
            return n;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    private void init() {
        this.m_storageToLogical = new HashMap();
        this.m_logicalToStorage = new NameMapper();
    }

    public HashMap<String, String> getStorageToLogicalMap() {
        this.m_lock.readLock().lock();
        try {
            HashMap hashMap = (HashMap)this.m_storageToLogical.clone();
            return hashMap;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyCorrections(HashMap<String, String> corrections) {
        this.m_lock.writeLock().lock();
        try {
            HashMap<String, String> saveStorageToLogical = this.m_storageToLogical;
            for (Map.Entry<String, String> entry : corrections.entrySet()) {
                String storageName = entry.getKey();
                String newLogicalName = entry.getValue();
                if (newLogicalName != null) {
                    saveStorageToLogical.put(storageName, newLogicalName);
                    continue;
                }
                saveStorageToLogical.remove(storageName);
            }
            this.init();
            this.constructFromStorageLogicalMap(saveStorageToLogical);
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public void set(String logicalPath, String storagePath) {
        this.set(logicalPath, storagePath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String logicalPath, String storagePath, boolean replaceMap) {
        block8: {
            this.m_lock.writeLock().lock();
            try {
                String insertMessage = NEWLINE + "Inserting LOGICAL: " + logicalPath + " STORAGE: " + storagePath + NEWLINE;
                if (logicalPath == null || storagePath == null) {
                    throw new RuntimeException("Storage and logical must not be null. " + insertMessage);
                }
                EntityName logicalPathE = this.getEntityName(logicalPath);
                String existingLogical = this.m_storageToLogical.get(storagePath);
                String existingStorage = (String)this.m_logicalToStorage.get(logicalPathE);
                if (replaceMap || existingLogical == null && existingStorage == null) {
                    if (replaceMap && existingStorage != null) {
                        this.m_storageToLogical.remove(existingStorage);
                    }
                    this.m_storageToLogical.put(storagePath, logicalPath);
                    this.m_logicalToStorage.set(logicalPathE, storagePath);
                    break block8;
                }
                if (existingLogical != null && existingStorage != null) {
                    if (!existingLogical.equalsIgnoreCase(logicalPath) || !existingStorage.equals(storagePath)) {
                        throw new RuntimeException(insertMessage + LogicalStorageNameMapper.existingErrorMessage(existingLogical, existingStorage));
                    }
                    break block8;
                }
                throw new RuntimeException(insertMessage + LogicalStorageNameMapper.existingErrorMessage(existingLogical, existingStorage));
            }
            finally {
                this.m_lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] rename(String oldPath, String newPath) {
        this.m_lock.writeLock().lock();
        try {
            NameMapper.NamedPayLoad[] list = this.m_logicalToStorage.rename(this.getEntityName(oldPath), this.getEntityName(newPath));
            if (list == null) {
                String[] stringArray = IEmptyArray.EMPTY_STRING_ARRAY;
                return stringArray;
            }
            String[] result = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                result[i] = (String)list[i].getPayload();
                this.m_storageToLogical.put(result[i], list[i].getName());
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteByStorageName(String storagePath) {
        this.m_lock.writeLock().lock();
        try {
            String logicalPath = this.m_storageToLogical.remove(storagePath);
            if (logicalPath != null) {
                this.m_logicalToStorage.remove(this.getEntityName(logicalPath));
            }
            String string = logicalPath;
            return string;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] deleteByLogicalName(String logicalPath) {
        this.m_lock.writeLock().lock();
        try {
            NameMapper.NamedPayLoad[] list = this.m_logicalToStorage.remove(this.getEntityName(logicalPath));
            if (list == null) {
                String[] stringArray = IEmptyArray.EMPTY_STRING_ARRAY;
                return stringArray;
            }
            String[] result = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                result[i] = (String)list[i].getPayload();
                this.m_storageToLogical.remove(result[i]);
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public String storageToLogical(String storagePath) {
        this.m_lock.readLock().lock();
        try {
            String string = this.m_storageToLogical.get(storagePath);
            return string;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String logicalToStorage(String logicalPath) {
        this.m_lock.readLock().lock();
        try {
            Object node = this.m_logicalToStorage.get(this.getEntityName(logicalPath));
            if (node instanceof String) {
                String string = (String)node;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] scan(String logicalPath) {
        this.m_lock.readLock().lock();
        try {
            NameMapper.NamedPayLoad[] list = this.m_logicalToStorage.scan(this.getEntityName(logicalPath));
            if (list == null) {
                String[] stringArray = IEmptyArray.EMPTY_STRING_ARRAY;
                return stringArray;
            }
            String[] result = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                result[i] = (String)list[i].getPayload();
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public Object clone() {
        this.m_lock.readLock().lock();
        try {
            LogicalStorageNameMapper lsnm = new LogicalStorageNameMapper();
            lsnm.constructFromStorageLogicalMap((HashMap)this.m_storageToLogical.clone());
            LogicalStorageNameMapper logicalStorageNameMapper = lsnm;
            return logicalStorageNameMapper;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.m_storageToLogical);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.m_lock = new ReentrantReadWriteLock();
        this.init();
        this.constructFromStorageLogicalMap((HashMap)s.readObject());
    }

    private void constructFromStorageLogicalMap(HashMap<String, String> storageToLogical) {
        this.m_logicalToStorage = new NameMapper();
        for (Map.Entry<String, String> entry : storageToLogical.entrySet()) {
            this.set(entry.getValue(), entry.getKey());
        }
        this.m_storageToLogical = storageToLogical;
    }

    private EntityName getEntityName(String path) {
        try {
            return new EntityName(path);
        }
        catch (ConfigException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private static String existingErrorMessage(String existingLogical, String existingStorage) {
        return "One-to-One relation violation - existing LOGICAL:  " + existingLogical + " existing STORAGE: " + existingStorage;
    }
}

