/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.ConfigException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class EntityName {
    private static final String MF_DIR_SEPARATOR_STRING = "/";
    private final String m_entityName;
    private String m_parentName = null;
    private final String[] m_nameComponents;

    public EntityName(String[] components, int count) {
        this.m_nameComponents = new String[count];
        for (int i = 0; i < count; ++i) {
            this.m_nameComponents[i] = components[i];
        }
        this.m_entityName = EntityName.componentsToName(this.m_nameComponents);
    }

    public EntityName(String nameString) throws ConfigException {
        String nameComponent;
        if (nameString == null || nameString.length() == 0) {
            throw new ConfigException("The name is invalid - cannot be null or empty.");
        }
        if (!nameString.startsWith(MF_DIR_SEPARATOR_STRING)) {
            throw new ConfigException(nameString + " is invalid - it must start with '" + MF_DIR_SEPARATOR_STRING + "'");
        }
        StringTokenizer nameTokenizer = new StringTokenizer(nameString, MF_DIR_SEPARATOR_STRING);
        ArrayList<String> nameComponents = new ArrayList<String>();
        while (nameTokenizer.hasMoreTokens() && (nameComponent = nameTokenizer.nextToken()).length() != 0) {
            nameComponents.add(nameComponent);
        }
        this.m_nameComponents = nameComponents.toArray(new String[nameComponents.size()]);
        this.m_entityName = EntityName.componentsToName(this.m_nameComponents);
    }

    public EntityName createChild(String child) {
        if (child.indexOf(47) != -1) {
            throw new IllegalArgumentException("The child name includes the '/' character.");
        }
        String[] childComponents = new String[this.m_nameComponents.length + 1];
        System.arraycopy(this.m_nameComponents, 0, childComponents, 0, this.m_nameComponents.length);
        childComponents[childComponents.length - 1] = child;
        return new EntityName(childComponents, childComponents.length);
    }

    public boolean isRoot() {
        return this.m_nameComponents.length == 0;
    }

    public String getName() {
        return this.m_entityName;
    }

    public String createKidName(String kidBaseName) {
        if (this.m_nameComponents.length == 0) {
            return this.m_entityName + kidBaseName;
        }
        return this.m_entityName + '/' + kidBaseName;
    }

    public String[] getNameComponents() {
        return (String[])this.m_nameComponents.clone();
    }

    public String[] getParentComponents() {
        if (this.m_nameComponents.length == 0) {
            return null;
        }
        String[] parentComponents = new String[this.m_nameComponents.length - 1];
        if (parentComponents.length > 0) {
            System.arraycopy(this.m_nameComponents, 0, parentComponents, 0, parentComponents.length);
        }
        return parentComponents;
    }

    public EntityName getParentEntity() {
        if (this.m_nameComponents.length == 0) {
            throw new IllegalArgumentException("No parent.");
        }
        return new EntityName(this.m_nameComponents, this.m_nameComponents.length - 1);
    }

    public synchronized String getParent() {
        if (this.m_parentName != null) {
            return this.m_parentName;
        }
        switch (this.m_nameComponents.length) {
            case 0: {
                this.m_parentName = "";
                return this.m_parentName;
            }
            case 1: {
                this.m_parentName = MF_DIR_SEPARATOR_STRING;
                return this.m_parentName;
            }
        }
        this.m_parentName = "";
        for (int i = 0; i < this.m_nameComponents.length - 1; ++i) {
            this.m_parentName = this.m_parentName + '/' + this.m_nameComponents[i];
        }
        return this.m_parentName;
    }

    public String getBaseName() {
        if (this.m_nameComponents.length == 0) {
            return "";
        }
        return this.m_nameComponents[this.m_nameComponents.length - 1];
    }

    public boolean isParent(EntityName child) {
        return this.parenthood(this.m_nameComponents, child.m_nameComponents) == 1;
    }

    private int parenthood(String[] components1, String[] components2) {
        int index1;
        for (index1 = 0; index1 < components1.length && index1 < components2.length && components1[index1].equals(components2[index1]); ++index1) {
        }
        if (index1 == components1.length && index1 + 1 == components2.length) {
            return 1;
        }
        if (index1 + 1 == components1.length && index1 == components2.length) {
            return 2;
        }
        return 0;
    }

    public static boolean containsAnyChar(String target, String chars) {
        for (int i = 0; i < target.length(); ++i) {
            if (chars.indexOf(target.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }

    private static String componentsToName(String[] components) {
        String name = MF_DIR_SEPARATOR_STRING;
        for (int i = 0; i < components.length; ++i) {
            name = name + (i + 1 < components.length ? components[i] + '/' : components[i]);
        }
        return name;
    }

    public String toString() {
        return this.getName();
    }
}

