/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.IAttributeSetType;
import com.sonicsw.mf.common.config.ITypeCollection;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.impl.AttributeSetType;
import com.sonicsw.mf.common.config.impl.TypedAttSet;
import com.sonicsw.mf.common.config.impl.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;

final class TypeCollection
extends HashMap
implements ITypeCollection,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    private boolean m_readOnly = false;

    TypeCollection() {
    }

    int estimateSize() {
        return 16 + Util.estimateHashMapSize(this);
    }

    @Override
    public boolean typesEqual(ITypeCollection c) {
        return this.equals(c);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof TypeCollection)) {
            return false;
        }
        TypeCollection typeCollection = (TypeCollection)o;
        String[] typeCollectionNames = typeCollection.getAllTypeNames();
        for (int i = 0; i < typeCollectionNames.length; ++i) {
            AttributeSetType thisType = (AttributeSetType)this.getAttributeSetType(typeCollectionNames[i]);
            AttributeSetType thatType = (AttributeSetType)typeCollection.getAttributeSetType(typeCollectionNames[i]);
            if (thatType.equals(thisType)) continue;
            return false;
        }
        String[] thisTypeCollectionNames = this.getAllTypeNames();
        for (int i = 0; i < thisTypeCollectionNames.length; ++i) {
            AttributeSetType thatType;
            AttributeSetType thisType = (AttributeSetType)this.getAttributeSetType(thisTypeCollectionNames[i]);
            if (thisType.equals(thatType = (AttributeSetType)typeCollection.getAttributeSetType(thisTypeCollectionNames[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getAllTypeNames());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        s.writeBoolean(this.m_readOnly);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        this.m_readOnly = s.readBoolean();
        if (version != 3) {
            Util.throwSerialVersionMismatch(version, 3);
        }
    }

    void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            ((AttributeSetType)iterator.next()).setReadOnly(readOnly);
        }
    }

    TypedAttSet cloneInstance(TypedAttSet set) {
        AttributeSetType type = (AttributeSetType)this.getAttributeSetType(set.getTypeName());
        return type.createTypedSet(set.values());
    }

    @Override
    public IAttributeSetType createAttributeSetType(String typeName) throws AttributeSetTypeException, ReadOnlyException {
        if (this.containsKey(typeName)) {
            throw new AttributeSetTypeException(typeName + " already exists.");
        }
        if (this.m_readOnly) {
            throw new ReadOnlyException();
        }
        AttributeSetType newType = new AttributeSetType(typeName);
        this.put(typeName, newType);
        return newType;
    }

    @Override
    public IAttributeSetType deleteAttributeSetType(String typeName) throws AttributeSetTypeException, ReadOnlyException {
        if (this.m_readOnly) {
            throw new ReadOnlyException();
        }
        IAttributeSetType typeObject = (IAttributeSetType)this.get(typeName);
        if (typeObject == null) {
            return null;
        }
        if (((AttributeSetType)typeObject).hasInstances()) {
            throw new AttributeSetTypeException("There are AttributeSet instances of type '" + typeName + "' - cannot be deleted.");
        }
        this.remove(typeName);
        return typeObject;
    }

    @Override
    public IAttributeSetType getAttributeSetType(String typeName) {
        return (IAttributeSetType)this.get(typeName);
    }

    @Override
    public String[] getAllTypeNames() {
        String[] result = new String[this.size()];
        Iterator iterator = this.keySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            result[i++] = (String)iterator.next();
        }
        return result;
    }

    void verifyType(AttributeSetType type, String typeContainer) throws AttributeSetTypeException {
        if (this.get(type.m_name) != type) {
            throw new AttributeSetTypeException("The IAttributeSetType object '" + this.get(type.m_name) + "' was not defined in " + typeContainer);
        }
    }
}

