/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.config.impl.AttributeList;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.config.impl.AttributeSetType;
import com.sonicsw.mf.common.config.impl.DeltaAttributeList;
import com.sonicsw.mf.common.config.impl.DeltaAttributeSet;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public final class Util {
    static final int OBJECT_SIZE = 16;
    static final int ARRAY_SIZE = 16;
    static final int BIGDECIMAL_SIZE_ESTIMATE = 120;
    static final int BOOLEAN_SIZE = 16;
    static final int LONG_SIZE = 16;
    static final int INTEGER_SIZE = 16;
    static final int DATE_SIZE = 24;
    static final int ELEMENT_NODE_SIZE = 64;

    static void throwSerialVersionMismatch(int objectVersion, int classVersion) throws IOException {
        throw new IOException("Serialization version mismatch. Serialized object version: " + objectVersion + " class version: " + classVersion);
    }

    static int estimateHashMapSize(HashMap map) {
        if (map == null) {
            return 0;
        }
        int estimate = 16;
        estimate += map.size() * 2;
        int count = map.size();
        Iterator iterator = map.keySet().iterator();
        for (int i = 0; i < count; ++i) {
            Object key = iterator.next();
            estimate += Util.estimateSize(key) + Util.estimateSize(map.get(key));
        }
        return estimate;
    }

    static int estimateArrayListSize(ArrayList list) {
        if (list == null) {
            return 0;
        }
        int estimate = 16;
        estimate += list.size() * 2;
        for (int i = 0; i < list.size(); ++i) {
            estimate += Util.estimateSize(list.get(i));
        }
        return estimate;
    }

    public static boolean validSimpleValue(Object o) {
        if (o == null) {
            return true;
        }
        String type = o.getClass().getName();
        if (type.equals("java.lang.String")) {
            return true;
        }
        if (type.equals("java.lang.Integer")) {
            return true;
        }
        if (type.equals("java.lang.Boolean")) {
            return true;
        }
        if (type.equals("com.sonicsw.mf.common.config.Reference")) {
            return true;
        }
        if (type.equals("[B")) {
            return true;
        }
        if (type.equals("java.lang.Long")) {
            return true;
        }
        if (type.equals("java.math.BigDecimal")) {
            return true;
        }
        return type.equals("java.util.Date");
    }

    static int estimateSize(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof String) {
            return 16 + (((String)o).length() << 1);
        }
        if (o instanceof Integer) {
            return 16;
        }
        if (o instanceof Long) {
            return 16;
        }
        if (o instanceof BigDecimal) {
            return 120;
        }
        if (o instanceof Date) {
            return 24;
        }
        if (o instanceof Boolean) {
            return 16;
        }
        if (o instanceof byte[]) {
            return 16 + ((byte[])o).length;
        }
        if (o instanceof AttributeSet) {
            return ((AttributeSet)o).estimateSize();
        }
        if (o instanceof AttributeList) {
            return ((AttributeList)o).estimateSize();
        }
        if (o instanceof AttributeSetType) {
            return ((AttributeSetType)o).estimateSize();
        }
        if (o instanceof DeltaAttributeSet) {
            return ((DeltaAttributeSet)o).estimateSize();
        }
        if (o instanceof DeltaAttributeList) {
            return ((DeltaAttributeList)o).estimateSize();
        }
        if (o instanceof Reference) {
            return 16 + Util.estimateSize(((Reference)o).getElementName());
        }
        throw new Error(" Unknown type " + o.getClass().getName());
    }

    static Object createDelta(Object v1, Object v1Type, Object v2, Object v2Type) {
        String type2;
        String type1 = v1.getClass().getName();
        if (!type1.equals(type2 = v2.getClass().getName())) {
            return v2;
        }
        if (type1.equals("java.lang.String")) {
            if (v1.equals(v2)) {
                return null;
            }
            return v2;
        }
        if (type1.equals("com.sonicsw.mf.common.config.impl.AttributeSet")) {
            return ((AttributeSet)v1).createDelta((AttributeSetType)v1Type, (AttributeSet)v2, (AttributeSetType)v2Type);
        }
        if (type1.equals("java.lang.Integer")) {
            if (((Integer)v1).equals(v2)) {
                return null;
            }
            return v2;
        }
        if (type1.equals("java.lang.Boolean")) {
            if (((Boolean)v1).equals(v2)) {
                return null;
            }
            return v2;
        }
        if (type1.equals("[B")) {
            byte[] b1 = (byte[])v1;
            byte[] b2 = (byte[])v2;
            if (b1.length == b2.length) {
                for (int i = 0; i < b1.length; ++i) {
                    if (b1[i] == b2[i]) continue;
                    return v2;
                }
                return null;
            }
            return v2;
        }
        if (type1.equals("com.sonicsw.mf.common.config.impl.AttributeList")) {
            return ((AttributeList)v1).createDelta((AttributeList)v2);
        }
        if (type1.equals("java.lang.Long")) {
            if (((Long)v1).equals(v2)) {
                return null;
            }
            return v2;
        }
        if (type1.equals("java.math.BigDecimal")) {
            if (((BigDecimal)v1).equals(v2)) {
                return null;
            }
            return v2;
        }
        if (type1.equals("com.sonicsw.mf.common.config.Reference")) {
            String name2;
            String name1 = ((Reference)v1).getElementName();
            if (name1.equals(name2 = ((Reference)v2).getElementName())) {
                return null;
            }
            return v2;
        }
        if (type1.equals("java.util.Date")) {
            if (((Date)v1).equals(v2)) {
                return null;
            }
            return v2;
        }
        throw new Error(" Unknown type " + type1);
    }

    public static boolean startsWith(boolean ignoreCase, Object v1, Object v2) {
        if (v1 == null || v2 == null) {
            return false;
        }
        if (!(v1 instanceof String) || !(v2 instanceof String)) {
            return false;
        }
        String source = (String)v1;
        String prefix = (String)v2;
        return source.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static boolean atomicAndEqual(Object v1, Object v2) {
        String type2;
        String type1 = v1.getClass().getName();
        if (!type1.equals(type2 = v2.getClass().getName())) {
            return false;
        }
        if (type1.equals("java.lang.String")) {
            return v1.equals(v2);
        }
        if (type1.equals("com.sonicsw.mf.common.config.impl.AttributeSet")) {
            return false;
        }
        if (type1.equals("java.lang.Integer")) {
            return ((Integer)v1).equals(v2);
        }
        if (type1.equals("java.lang.Boolean")) {
            return ((Boolean)v1).equals(v2);
        }
        if (type1.equals("[B")) {
            byte[] b1 = (byte[])v1;
            byte[] b2 = (byte[])v2;
            if (b1.length == b2.length) {
                for (int i = 0; i < b1.length; ++i) {
                    if (b1[i] == b2[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (type1.equals("com.sonicsw.mf.common.config.impl.AttributeList")) {
            return false;
        }
        if (type1.equals("java.lang.Long")) {
            return ((Long)v1).equals(v2);
        }
        if (type1.equals("java.math.BigDecimal")) {
            return ((BigDecimal)v1).equals(v2);
        }
        if (type1.equals("com.sonicsw.mf.common.config.Reference")) {
            String name2;
            String name1 = ((Reference)v1).getElementName();
            return name1.equals(name2 = ((Reference)v2).getElementName());
        }
        if (type1.equals("java.util.Date")) {
            return ((Date)v1).equals(v2);
        }
        throw new Error(" Unknown type " + type1);
    }
}

