/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.query;

import com.sonicsw.mf.common.config.query.impl.Util;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class QueryBatch
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 1;
    private int m_size = 100;
    private int m_firstIndex = -1;
    private int m_lastIndex = -1;
    private IDirElement[] m_resultElements = null;

    public int getSize() {
        return this.m_size;
    }

    public void setSize(int size) {
        this.m_size = size;
    }

    public IDirElement[] getElements() {
        return this.m_resultElements;
    }

    public QueryBatch(IDirElement[] els, QueryBatch existing) {
        this.m_resultElements = els;
        if (existing != null) {
            this.m_firstIndex = existing.m_firstIndex;
            this.m_lastIndex = existing.m_lastIndex;
            this.m_size = existing.m_size;
        }
    }

    public QueryBatch() {
    }

    public void next(IDirElement[] candidates) {
        int newFirstIndex;
        int newLastIndex;
        IDirElement[] batchResult = null;
        if (this.m_size >= 0) {
            newLastIndex = this.m_lastIndex + this.m_size;
            newFirstIndex = newLastIndex - (this.m_size - 1);
        } else {
            newFirstIndex = this.m_firstIndex + this.m_size;
            newLastIndex = newFirstIndex - (this.m_size + 1);
        }
        if (newFirstIndex >= candidates.length || newLastIndex < 0) {
            this.m_resultElements = new IDirElement[0];
        }
        this.m_firstIndex = newFirstIndex < 0 ? 0 : newFirstIndex;
        this.m_lastIndex = newLastIndex >= candidates.length ? candidates.length - 1 : newLastIndex;
        batchResult = new IDirElement[this.m_lastIndex - this.m_firstIndex + 1];
        System.arraycopy(candidates, this.m_firstIndex, batchResult, 0, this.m_lastIndex - this.m_firstIndex + 1);
        this.m_resultElements = batchResult;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(1);
        HashMap<String, Object> table = new HashMap<String, Object>(3, 1.0f);
        table.put("size", new Integer(this.m_size));
        table.put("start", new Integer(this.m_firstIndex));
        table.put("end", new Integer(this.m_lastIndex));
        table.put("els", this.m_resultElements);
        s.writeObject(table);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        System.out.println("QueryBatch.readObject");
        int version = s.readInt();
        if (version != 1) {
            Util.throwSerialVersionMismatch((int)version, (int)1);
        }
        HashMap table = (HashMap)s.readObject();
        this.m_size = (Integer)table.get("size");
        this.m_firstIndex = (Integer)table.get("start");
        this.m_lastIndex = (Integer)table.get("end");
        this.m_resultElements = (IDirElement[])table.get("els");
        System.out.println("size, firstIndex, lastIndex " + this.m_size + " " + this.m_firstIndex + " " + this.m_lastIndex);
    }
}

