/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.runtime.impl;

import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.ContainerIdentity;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;

public final class ComponentIdentity
extends ContainerIdentity
implements IComponentIdentity,
Serializable {
    private static final long serialVersionUID = 5163047150767243748L;
    private static final short m_serialVersion = 0;
    private String m_componentName;

    public ComponentIdentity(CanonicalName canonicalName, IElementIdentity configID) {
        super(canonicalName, configID);
        this.m_componentName = canonicalName.getComponentName();
    }

    @Override
    public String getCanonicalName() {
        return super.getCanonicalName() + ":ID=" + this.m_componentName;
    }

    @Override
    public String getComponentName() {
        return this.m_componentName;
    }

    @Override
    public String toString() {
        return this.getCanonicalName();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IComponentIdentity)) {
            return false;
        }
        return this.toString().equals(object.toString()) && this.getConfigIdentity().equals(((IComponentIdentity)object).getConfigIdentity());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.toString(), this.getConfigIdentity());
    }

    @Override
    public int compareTo(Object object) throws ClassCastException {
        return this.toString().compareTo(((IComponentIdentity)object).toString());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(2);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(0));
        stream.writeUTF("componentName");
        stream.writeObject(this.m_componentName);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numValues = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(stream.readUTF(), stream.readObject());
        }
        switch ((Short)map.get("serialVersion")) {
            default: 
        }
        try {
            this.m_componentName = (String)map.get("componentName");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

