/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.runtime.impl;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.runtime.IContainerIdentity;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Objects;

public class ContainerIdentity
implements IContainerIdentity,
Serializable {
    private static final long serialVersionUID = 1958150406706801004L;
    private static final short m_serialVersion = 0;
    private static final String DOMAIN_NAME_ATTR = "DOMAIN_NAME";
    private static final String CONTAINER_NAME_ATTR = "CONTAINER_NAME";
    private String m_domainName;
    private String m_containerName;
    private String m_nodeName;
    private String m_localContainerName;
    private IElementIdentity m_configID;

    public ContainerIdentity(IElement containerConfig) {
        IAttributeSet containerAttrs = containerConfig.getAttributes();
        this.m_domainName = (String)containerAttrs.getAttribute(DOMAIN_NAME_ATTR);
        if (this.m_domainName == null) {
            this.m_domainName = "Domain1";
        }
        this.m_containerName = (String)containerAttrs.getAttribute(CONTAINER_NAME_ATTR);
        this.m_configID = containerConfig.getIdentity();
        CanonicalName.CompoundContainerName compoundName = new CanonicalName.CompoundContainerName(this.m_containerName);
        this.m_localContainerName = compoundName.m_localContainerName;
        this.m_nodeName = compoundName.m_nodeName;
    }

    public ContainerIdentity(CanonicalName canonicalName, IElementIdentity configID) {
        this.m_domainName = canonicalName.getDomainName();
        this.m_containerName = canonicalName.getContainerName();
        this.m_localContainerName = canonicalName.getLocalContainerName();
        this.m_nodeName = canonicalName.getNodeName();
        this.m_configID = configID;
    }

    @Override
    public String getDomainName() {
        return this.m_domainName;
    }

    @Override
    public String getContainerName() {
        return this.m_containerName;
    }

    public String getLocalContainerName() {
        return this.m_localContainerName;
    }

    @Override
    public String getNodeName() {
        return this.m_nodeName;
    }

    @Override
    public String getCanonicalName() {
        return this.m_domainName + '.' + this.m_containerName;
    }

    public String getCanonicalNamePrefix() {
        return this.m_domainName + '.' + this.m_containerName + ":";
    }

    @Override
    public IElementIdentity getConfigIdentity() {
        return this.m_configID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_domainName);
        sb.append('.');
        sb.append(this.m_containerName);
        if (this.m_nodeName.length() > 0) {
            sb.append('@').append(this.m_nodeName);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IContainerIdentity)) {
            return false;
        }
        return this.toString().equals(object.toString()) && this.getConfigIdentity().equals(((IContainerIdentity)object).getConfigIdentity());
    }

    public int hashCode() {
        return Objects.hash(this.toString(), this.getConfigIdentity());
    }

    @Override
    public int compareTo(Object object) throws ClassCastException {
        return this.toString().compareTo(((IContainerIdentity)object).toString());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(4);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(0));
        stream.writeUTF("domainName");
        stream.writeObject(this.m_domainName);
        stream.writeUTF("containerName");
        stream.writeObject(this.m_containerName);
        stream.writeUTF("configID");
        stream.writeObject(this.m_configID);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numValues = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(stream.readUTF(), stream.readObject());
        }
        switch ((Short)map.get("serialVersion")) {
            default: 
        }
        try {
            this.m_domainName = (String)map.get("domainName");
        }
        catch (Exception i) {
            // empty catch block
        }
        try {
            this.m_containerName = (String)map.get("containerName");
        }
        catch (Exception i) {
            // empty catch block
        }
        try {
            this.m_configID = (IElementIdentity)map.get("configID");
        }
        catch (Exception i) {
            // empty catch block
        }
        CanonicalName canonicalName = new CanonicalName(this.m_domainName, this.m_containerName, "");
        this.m_localContainerName = canonicalName.getLocalContainerName();
        this.m_nodeName = canonicalName.getNodeName();
    }
}

