/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.util;

import com.sonicsw.mx.util.IEmptyArray;
import com.sonicsw.mx.util.OStream;
import com.sonicsw.mx.util.Sorter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class CLI {
    private static Map m_helpMap = Collections.synchronizedMap(new HashMap());
    private static Vector m_keywords = new Vector();
    private static Map m_rootNode = Collections.synchronizedMap(new HashMap());
    private static Map m_currentNode = null;
    private static volatile Method m_commandMethod;
    private static volatile Method m_helpMethod;
    private static List<String> m_cmdLine;
    private static List<String> m_params;
    protected static final String DEFAULT_PROMPT = "> ";
    private static volatile String m_promptString;
    private static boolean m_prompt;
    private static final String HELP_REQUEST_CHAR = "?";
    private static final String COMMENT_TOKEN = "//";
    private static boolean m_commandFinished;
    private static volatile Thread m_readerThread;
    private static BufferedReader m_inputReader;
    private static boolean m_paused;
    protected static Class m_thisClassObject;
    protected static Class m_cliClassObject;
    private static final String CMD_TOKEN_DELIMITERS = " \n\t\r";
    public static final String ECHO_CMD_PROP = "sonicsw.mx.cli.echo";
    public static final String SHOW_PROMPT_PROP = "sonicsw.mx.cli.prompt";
    public static final String TEXT_WIDTH_PROP = "sonicsw.mx.cli.wrap";
    protected static final boolean ECHO_CMD;
    protected static boolean SHOW_PROMPT;
    protected static int TEXT_WIDTH;
    private static final Object METHOD_KEY;
    private static final Object HELP_KEY;

    protected static void addCommand(String command, Method implementation, Method help) {
        HashMap<String, HashMap<Object, Method>> parentNode = m_rootNode;
        StringTokenizer st = new StringTokenizer(command, " ");
        while (st.hasMoreTokens()) {
            HashMap<String, HashMap<Object, Method>> childNode;
            String token = st.nextToken();
            if (!m_keywords.contains(token)) {
                m_keywords.add(token);
            }
            if ((childNode = (HashMap<String, HashMap<Object, Method>>)parentNode.get(token)) == null) {
                childNode = new HashMap<String, HashMap<Object, Method>>();
                parentNode.put(token, childNode);
            }
            if (!st.hasMoreTokens()) {
                childNode.put((String)METHOD_KEY, (HashMap<Object, Method>)((Object)implementation));
                childNode.put((String)HELP_KEY, (HashMap<Object, Method>)((Object)help));
                continue;
            }
            parentNode = childNode;
        }
        m_helpMap.put(command, help);
    }

    protected static ArrayList getCmdLine() {
        return m_cmdLine == null ? null : (ArrayList)((ArrayList)m_cmdLine).clone();
    }

    protected static ArrayList getParams() {
        return m_params == null ? null : (ArrayList)((ArrayList)m_params).clone();
    }

    public static void setPrompt(String prompt) {
        m_promptString = prompt;
    }

    public static void cancelReadParseExecute() {
        if (m_readerThread == null) {
            return;
        }
        OStream.println();
        m_paused = true;
    }

    public static synchronized void readParseExecute() {
        m_paused = false;
        if (m_readerThread != null) {
            if (m_prompt) {
                CLI.prompt();
            }
            return;
        }
        m_readerThread = new Thread("Command Line Reader"){

            @Override
            public void run() {
                BufferedReader inputReader = null;
                String enc = System.getProperty("inputEncoding");
                if (enc == null) {
                    inputReader = new BufferedReader(new InputStreamReader(System.in));
                } else {
                    try {
                        inputReader = new BufferedReader(new InputStreamReader(System.in, enc));
                    }
                    catch (UnsupportedEncodingException e) {
                        OStream.println("Unsupported encoding:" + enc);
                        inputReader = new BufferedReader(new InputStreamReader(System.in));
                    }
                }
                boolean bye = false;
                m_prompt = true;
                block12: while (!bye && !m_paused) {
                    if (m_prompt) {
                        CLI.prompt();
                    }
                    String cmd = null;
                    try {
                        cmd = inputReader.readLine();
                        if (m_paused) {
                            m_readerThread = null;
                            return;
                        }
                    }
                    catch (IOException e) {
                        if (!this.isInterrupted()) {
                            OStream.printStackTrace(e);
                        }
                        return;
                    }
                    if (cmd == null) {
                        m_paused = true;
                        m_readerThread = null;
                        return;
                    }
                    if (cmd.length() == 0) continue;
                    cmd = cmd.trim();
                    if (ECHO_CMD) {
                        CLI.more(cmd);
                    }
                    if (cmd.startsWith(CLI.COMMENT_TOKEN)) continue;
                    m_currentNode = Collections.synchronizedMap(m_rootNode);
                    m_commandMethod = null;
                    m_helpMethod = null;
                    m_cmdLine = Collections.synchronizedList(new ArrayList());
                    m_params = Collections.synchronizedList(new ArrayList());
                    boolean unbalancedQuotes = false;
                    StringBuffer cmdToken = new StringBuffer();
                    block13: for (int i = 0; i < cmd.length(); ++i) {
                        char c = cmd.charAt(i);
                        switch (c) {
                            case '\\': {
                                if (++i >= cmd.length()) continue block13;
                                cmdToken.append(cmd.charAt(i));
                                continue block13;
                            }
                            case '\"': {
                                block14: while (++i < cmd.length() && cmd.charAt(i) != '\"') {
                                    char blindChar = cmd.charAt(i);
                                    switch (blindChar) {
                                        case '\\': {
                                            if (++i >= cmd.length()) continue block14;
                                            cmdToken.append(cmd.charAt(i));
                                            continue block14;
                                        }
                                    }
                                    cmdToken.append(blindChar);
                                }
                                if (i != cmd.length()) continue block13;
                                unbalancedQuotes = true;
                                continue block13;
                            }
                            case ' ': {
                                if (!CLI.handleNextToken(cmdToken.toString(), m_commandMethod == null)) continue block12;
                                cmdToken = new StringBuffer();
                                continue block13;
                            }
                            default: {
                                cmdToken.append(c);
                            }
                        }
                    }
                    if (cmdToken.length() > 0 && !CLI.handleNextToken(cmdToken.toString(), m_commandMethod == null)) continue;
                    if (unbalancedQuotes) {
                        OStream.println("Unbalanced quotes");
                        continue;
                    }
                    if (m_commandMethod != null) {
                        CLI.invokeCommand();
                        continue;
                    }
                    CLI.displayGenericHelp();
                }
            }
        };
        m_readerThread.setDaemon(true);
        m_readerThread.start();
    }

    private static boolean handleNextToken(String token, boolean cmdRequired) {
        HashMap node = (HashMap)m_currentNode.get(token);
        if (node == null) {
            if (token.equals(HELP_REQUEST_CHAR) || cmdRequired) {
                if (m_helpMethod != null) {
                    CLI.displayCommandHelp();
                } else {
                    CLI.displayGenericHelp();
                }
                return false;
            }
            m_params.add(token);
        } else {
            m_commandMethod = (Method)node.get(METHOD_KEY);
            m_helpMethod = (Method)node.get(HELP_KEY);
            m_currentNode = Collections.synchronizedMap(node);
        }
        m_cmdLine.add(token);
        return true;
    }

    public static void redoPrompt() {
        if (m_prompt && m_commandFinished) {
            CLI.prompt();
        }
    }

    public static void crAfterPrompt() {
        if (SHOW_PROMPT && m_prompt && m_commandFinished) {
            OStream.println();
        }
    }

    private static void more(String toPrint) {
        OStream.println(toPrint);
    }

    private static void displayGenericHelp() {
        OStream.println("\nCommands are: \n");
        Vector helpStrings = new Vector(m_currentNode.keySet());
        CLI.more(helpStrings, true);
        OStream.println();
    }

    private static void displayCommandHelp() {
        String commandOutput = null;
        m_commandFinished = false;
        try {
            commandOutput = (String)m_helpMethod.invoke((Object)m_cliClassObject, IEmptyArray.EMPTY_OBJECT_ARRAY);
        }
        catch (InvocationTargetException e) {
            Throwable ex = e.getTargetException();
            OStream.printStackTrace(ex);
        }
        catch (IllegalAccessException iae) {
            OStream.printStackTrace(iae);
        }
        OStream.println();
        OStream.println(commandOutput);
        OStream.println();
        m_commandFinished = true;
    }

    private static void invokeCommand() {
        String commandOutput = null;
        m_commandFinished = false;
        try {
            if (m_params.size() > m_commandMethod.getParameterTypes().length) {
                if (m_helpMethod != null) {
                    CLI.displayCommandHelp();
                }
            } else {
                String[] params = new String[m_commandMethod.getParameterTypes().length];
                System.arraycopy(m_params.toArray(IEmptyArray.EMPTY_STRING_ARRAY), 0, params, 0, m_params.size());
                commandOutput = (String)m_commandMethod.invoke((Object)m_cliClassObject, (Object[])params);
            }
            if (commandOutput != null) {
                OStream.println();
                OStream.println(commandOutput);
                OStream.println();
            }
        }
        catch (InvocationTargetException e) {
            Throwable ex = e.getTargetException();
            OStream.printStackTrace(ex);
        }
        catch (Exception e) {
            OStream.printStackTrace(e);
        }
        m_commandFinished = true;
    }

    private static void prompt() {
        if (SHOW_PROMPT) {
            OStream.print(m_promptString);
            OStream.flush();
        }
    }

    private static void more(Vector toPrint, boolean columns) {
        if (columns) {
            String[] alpha_ordered = Sorter.sort(toPrint);
            String[] columnized = CLI.putInColumns(alpha_ordered, 0);
            CLI.moreNoAlpha(columnized);
        } else {
            CLI.more(toPrint);
        }
    }

    protected static String[] putInColumns(String[] items, int cols) {
        int columnLength;
        int columns;
        if (cols != 0) {
            columns = cols;
            columnLength = 79 / cols;
        } else {
            columns = TEXT_WIDTH / 15;
            columnLength = 15;
        }
        String[] itemsInColumns = new String[items.length];
        String currentLine = "";
        int lineIndex = 0;
        for (int itemIndex = 0; itemIndex < items.length; ++itemIndex) {
            String currentItem = items[itemIndex];
            if (itemIndex % columns == 0) {
                if (itemIndex > 0) {
                    itemsInColumns[lineIndex] = currentLine;
                    ++lineIndex;
                }
                currentLine = "";
            }
            currentLine = currentLine + currentItem;
            int padIndex = currentLine.length();
            while (padIndex % columnLength != 0) {
                currentLine = currentLine + " ";
                ++padIndex;
            }
        }
        itemsInColumns[lineIndex] = currentLine;
        return itemsInColumns;
    }

    protected static void moreNoAlpha(String[] toPrint) {
        for (int counter = 0; counter < toPrint.length; ++counter) {
            if (toPrint[counter] == null) continue;
            OStream.println(toPrint[counter]);
        }
    }

    private static void more(Vector toPrint) {
        String[] alpha_ordered = Sorter.sort(toPrint);
        for (int index = 0; index < alpha_ordered.length; ++index) {
            OStream.println(alpha_ordered[index]);
        }
    }

    public static String showHelp() {
        String[] commands = (String[])Sorter.sort(m_helpMap.keySet().toArray(IEmptyArray.EMPTY_STRING_ARRAY));
        StringBuffer buffer = new StringBuffer();
        try {
            for (int i = 0; i < commands.length; ++i) {
                Method helpMethod;
                if (i > 0) {
                    buffer.append("\n\n\n");
                }
                if ((helpMethod = (Method)m_helpMap.get(commands[i])) != null) {
                    buffer.append((String)helpMethod.invoke((Object)m_cliClassObject, IEmptyArray.EMPTY_OBJECT_ARRAY));
                    continue;
                }
                buffer.append("Help not implemented for " + commands[i]);
            }
        }
        catch (InvocationTargetException e) {
            Throwable ex = e.getTargetException();
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public static String showKeywords() {
        OStream.println("\nKeywords are: \n");
        CLI.more(m_keywords, true);
        OStream.println();
        return null;
    }

    public static String help(String token1, String token2, String token3, String token4, String token5) {
        HashMap node = null;
        if (token1 != null && token1.length() > 0 && m_rootNode.containsKey(token1)) {
            node = (HashMap)m_rootNode.get(token1);
        }
        if (token2 != null && token2.length() > 0 && node.containsKey(token2)) {
            node = (HashMap)node.get(token2);
        }
        if (token3 != null && token3.length() > 0 && node.containsKey(token3)) {
            node = (HashMap)node.get(token3);
        }
        if (token4 != null && token4.length() > 0 && node.containsKey(token4)) {
            node = (HashMap)node.get(token4);
        }
        if (token5 != null && token5.length() > 0 && node.containsKey(token5)) {
            node = (HashMap)node.get(token5);
        }
        if (node == null) {
            m_currentNode = Collections.synchronizedMap(m_rootNode);
            CLI.displayGenericHelp();
            return null;
        }
        m_helpMethod = (Method)node.get(HELP_KEY);
        if (m_helpMethod == null) {
            m_currentNode = Collections.synchronizedMap(node);
            CLI.displayGenericHelp();
            return null;
        }
        CLI.displayCommandHelp();
        return null;
    }

    public static String comment() {
        return null;
    }

    public static String showHelpHelp() {
        return "Usage: show help\n\nDisplays help for all commands.";
    }

    public static String showKeywordsHelp() {
        return "Usage: show keywords\n\nDisplays all the known command keywords.";
    }

    public static String helpHelp() {
        return "Usage: {? <command> | <command> ?}\n\nDisplays help for a command.";
    }

    public static String commentHelp() {
        return "Usage: //\n\nTreats the text to the end of the line as a comment.";
    }

    static {
        m_promptString = DEFAULT_PROMPT;
        m_commandFinished = true;
        m_paused = false;
        m_thisClassObject = CLI.class;
        m_cliClassObject = CLI.class;
        ECHO_CMD = new Boolean(System.getProperty(ECHO_CMD_PROP, "false"));
        SHOW_PROMPT = new Boolean(System.getProperty(SHOW_PROMPT_PROP, "true"));
        TEXT_WIDTH = Integer.parseInt(System.getProperty(TEXT_WIDTH_PROP, "79"));
        METHOD_KEY = null;
        HELP_KEY = "";
        try {
            CLI.addCommand("show help", m_thisClassObject.getDeclaredMethod("showHelp", IEmptyArray.EMPTY_CLASS_ARRAY), m_thisClassObject.getDeclaredMethod("showHelpHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            CLI.addCommand("show keywords", m_thisClassObject.getDeclaredMethod("showKeywords", IEmptyArray.EMPTY_CLASS_ARRAY), m_thisClassObject.getDeclaredMethod("showKeywordsHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            CLI.addCommand(HELP_REQUEST_CHAR, m_thisClassObject.getDeclaredMethod("help", String.class, String.class, String.class, String.class, String.class), m_thisClassObject.getDeclaredMethod("helpHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
            CLI.addCommand(COMMENT_TOKEN, m_thisClassObject.getDeclaredMethod("comment", IEmptyArray.EMPTY_CLASS_ARRAY), m_thisClassObject.getDeclaredMethod("commentHelp", IEmptyArray.EMPTY_CLASS_ARRAY));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }
}

