/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.util;

public class URLUtil {
    public static String buildUrlString(String protocol, String host, int port) {
        String portAsString = null;
        if (port > 0) {
            portAsString = Integer.toString(port);
        }
        return URLUtil.buildUrlString(protocol, host, portAsString);
    }

    public static String buildUrlString(String protocol, String host, String port) {
        StringBuilder url = new StringBuilder();
        if (protocol != null && !protocol.equals("")) {
            url.append(protocol).append("://");
        }
        url.append(URLUtil.wrapIPv6Address(host));
        if (port != null & port.length() > 0) {
            url.append(":").append(port);
        }
        return url.toString();
    }

    public static String wrapIPv6Address(String hostParam) {
        String host = hostParam;
        if (host == null) {
            return null;
        }
        if (!host.startsWith("[") && host.contains(":")) {
            host = "[" + host + "]";
        }
        return host;
    }

    public static String unwrapIPv6Address(String hostParam) {
        String host = hostParam;
        if (host == null) {
            return null;
        }
        if (host.startsWith("[") && host.contains(":") && host.endsWith("]")) {
            host = host.substring(1, host.length() - 1);
        }
        return host;
    }
}

