/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.runtime.impl;

import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.runtime.IComponentIdentity;
import com.sonicsw.mf.common.runtime.IComponentState;
import com.sonicsw.mf.common.runtime.IIdentity;
import com.sonicsw.mf.common.runtime.ISubComponentState;
import com.sonicsw.mf.common.runtime.impl.CanonicalName;
import com.sonicsw.mf.common.runtime.impl.ComponentIdentity;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ComponentState
implements IComponentState,
Serializable {
    private static final long serialVersionUID = 3469829302166258423L;
    private static final short m_serialVersion = 1;
    private IComponentIdentity m_componentID;
    private short m_state;
    private int m_errorLevel;
    private String m_errorDescription;
    private Map<String, ISubComponentState[]> m_subComponentStates;

    public ComponentState(CanonicalName canonicalName, IElementIdentity configID, short state, String errorDescription, int errorLevel, Map<String, ISubComponentState[]> subComponentStates) {
        this.m_componentID = new ComponentIdentity(canonicalName, configID);
        this.m_state = state;
        this.m_errorLevel = errorLevel;
        this.m_errorDescription = errorDescription;
        this.m_subComponentStates = subComponentStates == null ? new HashMap() : subComponentStates;
    }

    @Override
    public IIdentity getRuntimeIdentity() {
        return this.m_componentID;
    }

    @Override
    public short getState() {
        return this.m_state;
    }

    public void setState(short state) {
        if (state < 0 || state > 4) {
            throw new IllegalArgumentException("Invalid component state: " + state);
        }
        this.m_state = state;
    }

    @Override
    public String getStateString() {
        return IComponentState.STATE_TEXT[this.getState()];
    }

    @Override
    public int getLastErrorLevel() {
        return this.m_errorLevel;
    }

    public void setLastErrorLevel(int errorLevel) {
        if (errorLevel < 0 || errorLevel > 3) {
            throw new IllegalArgumentException("Invalid component error severity: " + errorLevel);
        }
        this.m_errorLevel = errorLevel;
    }

    @Override
    public String getLastErrorDescription() {
        return this.m_errorDescription;
    }

    public void setLastErrorDescription(String errorDescription) {
        this.m_errorDescription = errorDescription;
    }

    @Override
    public Map<String, ISubComponentState[]> getSubComponentStates() {
        return this.m_subComponentStates;
    }

    public String toString() {
        return this.getStateString();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IComponentState)) {
            return false;
        }
        return this.getRuntimeIdentity().equals(((IComponentState)object).getRuntimeIdentity()) && this.getState() == ((IComponentState)object).getState();
    }

    public int hashCode() {
        return Objects.hash(this.getRuntimeIdentity(), this.getState());
    }

    @Override
    public int compareTo(Object object) throws ClassCastException {
        return this.toString().compareTo(((IComponentState)object).toString());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeInt(6);
        stream.writeUTF("serialVersion");
        stream.writeObject(new Short(1));
        stream.writeUTF("componentID");
        stream.writeObject(this.m_componentID);
        stream.writeUTF("state");
        stream.writeObject(new Short(this.m_state));
        stream.writeUTF("errorDescription");
        stream.writeObject(this.m_errorDescription);
        stream.writeUTF("errorLevel");
        stream.writeObject(new Integer(this.m_errorLevel));
        stream.writeUTF("subComponentStates");
        if (this.m_subComponentStates == null) {
            this.m_subComponentStates = new HashMap<String, ISubComponentState[]>();
        }
        if (this.m_subComponentStates instanceof Serializable) {
            stream.writeObject(this.m_subComponentStates);
        } else {
            stream.writeObject(new HashMap<String, ISubComponentState[]>(this.m_subComponentStates));
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numValues = stream.readInt();
        HashMap<String, Object> map = new HashMap<String, Object>(numValues);
        for (int i = 0; i < numValues; ++i) {
            map.put(stream.readUTF(), stream.readObject());
        }
        switch ((Short)map.get("serialVersion")) {
            case 0: {
                try {
                    this.m_componentID = (IComponentIdentity)map.get("componentID");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_state = (Short)map.get("state");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_errorDescription = (String)map.get("errorDescription");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_errorLevel = (Integer)map.get("errorLevel");
                }
                catch (Exception exception) {}
                break;
            }
            default: {
                try {
                    this.m_componentID = (IComponentIdentity)map.get("componentID");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_state = (Short)map.get("state");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_errorDescription = (String)map.get("errorDescription");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_errorLevel = (Integer)map.get("errorLevel");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_subComponentStates = (HashMap)map.get("subComponentStates");
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

