/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.url;

import java.net.MalformedURLException;
import java.net.URL;

public final class BrokerURL {
    public static final String TCP = "tcp";
    public static final String HTTP = "http";
    private static final String HTTPS = "https";
    public static final String SSL = "ssl";
    private static final String SSL_IAIK = "ssl.iaik";
    private static final String MQTT = "mqtt";
    private static final String MQTTS = "mqtts";
    private static final String LOCALHOST = "localhost";
    private static final int PORT_DEFAULT = 2506;
    private String m_brokerURL;
    private String m_brokerHostName = "localhost";
    private String m_brokerProtocol = "tcp";
    private int m_brokerPort;
    private boolean m_allowsEmptyHostname = false;

    public BrokerURL(String brokerURL) throws MalformedURLException {
        this.parseURL(brokerURL);
    }

    public BrokerURL(String brokerURL, boolean allowsEmptyHostname) throws MalformedURLException {
        this.m_allowsEmptyHostname = allowsEmptyHostname;
        this.parseURL(brokerURL);
    }

    public String getBrokerURL() {
        return this.m_brokerURL;
    }

    public String getBrokerHostName() {
        return this.m_brokerHostName;
    }

    public String getBrokerProtocol() {
        return this.m_brokerProtocol;
    }

    public int getBrokerPort() {
        return this.m_brokerPort;
    }

    private void parseURL(String brokerURL) throws MalformedURLException {
        String host;
        if (brokerURL == null || "".equals(brokerURL)) {
            if (this.m_allowsEmptyHostname) {
                this.m_brokerHostName = null;
            }
            return;
        }
        this.m_brokerURL = brokerURL = brokerURL.trim();
        if (brokerURL.length() >= 6 && brokerURL.substring(0, 6).equalsIgnoreCase("tcp://")) {
            this.m_brokerProtocol = TCP;
            host = brokerURL.substring(6);
        } else if (brokerURL.length() >= 7 && brokerURL.substring(0, 7).equalsIgnoreCase("http://")) {
            this.m_brokerProtocol = HTTP;
            host = brokerURL.substring(7);
        } else if (brokerURL.length() >= 8 && brokerURL.substring(0, 8).equalsIgnoreCase("https://")) {
            this.m_brokerProtocol = HTTPS;
            host = brokerURL.substring(8);
        } else if (brokerURL.length() >= 6 && brokerURL.substring(0, 6).equalsIgnoreCase("ssl://")) {
            this.m_brokerProtocol = SSL;
            host = brokerURL.substring(6);
        } else if (brokerURL.length() >= 11 && brokerURL.substring(0, 11).equalsIgnoreCase("ssl.iaik://")) {
            this.m_brokerProtocol = SSL;
            host = brokerURL.substring(11);
        } else if (brokerURL.length() >= 7 && brokerURL.substring(0, 7).equalsIgnoreCase("mqtt://")) {
            this.m_brokerProtocol = MQTT;
            host = brokerURL.substring(7);
        } else if (brokerURL.length() >= 8 && brokerURL.substring(0, 8).equalsIgnoreCase("mqtts://")) {
            this.m_brokerProtocol = MQTTS;
            host = brokerURL.substring(8);
        } else {
            host = brokerURL;
        }
        try {
            URL url = new URL("http://" + host);
            this.m_brokerHostName = url.getHost();
            this.m_brokerPort = url.getPort();
            if (!(this.m_brokerHostName != null && this.m_brokerHostName.length() != 0 || this.m_allowsEmptyHostname)) {
                throw new MalformedURLException("Missing hostname");
            }
            if (this.m_brokerPort == -1) {
                this.m_brokerPort = 2506;
            }
        }
        catch (MalformedURLException e) {
            MalformedURLException ex = new MalformedURLException(host + " (broker url: " + brokerURL + ")");
            ex.initCause(e);
            throw ex;
        }
    }
}

