/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.util;

import com.sonicsw.mf.common.IComponentContext;
import com.sonicsw.mf.common.ILogger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MFLogger {
    private Logger m_logger;

    public MFLogger(IComponentContext context, String loggerName) {
        this.m_logger = Logger.getLogger(loggerName);
        this.m_logger.setLevel(Level.FINEST);
        this.m_logger.setUseParentHandlers(false);
        MFLogHandler mfLogHandler = new MFLogHandler(context);
        this.m_logger.addHandler(mfLogHandler);
    }

    public MFLogger(ILogger logger, String loggerName) {
        this.m_logger = Logger.getLogger(loggerName);
        this.m_logger.setLevel(Level.FINEST);
        this.m_logger.setUseParentHandlers(false);
        MFLogHandler mfLogHandler = new MFLogHandler(logger);
        this.m_logger.addHandler(mfLogHandler);
    }

    private static class MFLogHandler
    extends Handler {
        IComponentContext context;
        ILogger logger;

        private MFLogHandler(IComponentContext context) {
            this.context = context;
        }

        private MFLogHandler(ILogger logger) {
            this.logger = logger;
        }

        @Override
        public void publish(LogRecord record) {
            int severity = this.getSeverity(record.getLevel());
            String message = record.getMessage();
            Throwable throwable = record.getThrown();
            if (throwable != null) {
                if (message == null || message.length() == 0) {
                    if (this.logger == null) {
                        this.context.logMessage(throwable, severity);
                    } else {
                        this.logger.logMessage("", throwable, severity);
                    }
                } else if (this.logger == null) {
                    this.context.logMessage(message, throwable, severity);
                } else {
                    this.logger.logMessage(message, throwable, severity);
                }
            } else if (this.logger == null) {
                this.context.logMessage(message, severity);
            } else {
                this.logger.logMessage(message, severity);
            }
        }

        private int getSeverity(Level level) {
            if (level == Level.CONFIG) {
                return 4;
            }
            if (level == Level.INFO) {
                return 3;
            }
            if (level == Level.WARNING) {
                return 2;
            }
            if (level == Level.SEVERE) {
                return 1;
            }
            return 7;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

