/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.view.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IAttributeSetType;
import com.sonicsw.mf.common.config.ReadOnlyException;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.view.IFolder;
import com.sonicsw.mf.common.view.ILink;
import com.sonicsw.mf.common.view.IViewElement;
import com.sonicsw.mf.common.view.IViewElementAttributes;
import com.sonicsw.mf.common.view.ViewException;
import com.sonicsw.mf.common.view.impl.Link;
import com.sonicsw.mf.common.view.impl.View;
import com.sonicsw.mf.common.view.impl.ViewConstants;
import com.sonicsw.mf.common.view.impl.ViewElementAttributes;
import com.sonicsw.mx.util.IEmptyArray;
import java.util.ArrayList;
import java.util.HashMap;

final class Folder
implements IFolder {
    IAttributeSet m_attrSet = null;
    IAttributeSetType m_folderAttrType = null;
    IAttributeSetType m_linkAttrType = null;
    ViewElementAttributes m_attributes = null;
    private String m_name = null;

    Folder(IAttributeSet parent, IAttributeSetType folderAttrs, IAttributeSetType linkAttrs, String name) throws AttributeSetTypeException, ReadOnlyException, ConfigException {
        String folderLowerCase = name;
        if (name.compareTo(ViewConstants.ROOT_FOLDER) != 0) {
            folderLowerCase = name.toLowerCase();
        }
        this.m_attrSet = (IAttributeSet)parent.getAttribute(folderLowerCase);
        if (this.m_attrSet == null && System.getProperty("MQ_UPGRADE", "false").equals("true")) {
            this.m_attrSet = (IAttributeSet)parent.getAttribute(name);
        }
        if (this.m_attrSet == null) {
            this.m_attrSet = parent.createAttributeSet(folderLowerCase);
            this.m_attrSet.createAttributeList(ViewConstants.ATTRS_VALUES);
            this.m_attrSet.setIntegerAttribute(ViewConstants.TYPE_ATTR, ViewConstants.FOLDER_TYPE);
            this.m_attrSet.setStringAttribute(ViewConstants.ORIGINAL_NAME, name);
        }
        this.m_name = name;
        this.m_folderAttrType = folderAttrs;
        this.m_linkAttrType = linkAttrs;
        this.setAttributes();
    }

    @Override
    public IFolder createFolder(String folderName) throws ViewException, ReadOnlyException, ConfigException {
        this.validateElementName(folderName);
        if (this.checkExistance(folderName)) {
            throw new ViewException(folderName + " already exists.");
        }
        Folder subFolder = new Folder(this.m_attrSet, this.m_folderAttrType, this.m_linkAttrType, folderName);
        return subFolder;
    }

    @Override
    public void deleteFolder(String folderName) throws ViewException, ReadOnlyException, ConfigException {
        if (!this.checkExistance(folderName)) {
            throw new ViewException("Can't create folder.Folder: " + folderName + " does not exist");
        }
        this.deleteViewElement(folderName);
    }

    @Override
    public ILink link(String linkName, String linkedObjectName, boolean complex) throws ViewException, ReadOnlyException, ConfigException {
        this.validateElementName(linkName);
        View.validateFullName(linkedObjectName);
        if (this.checkExistance(linkName)) {
            throw new ViewException(linkName + " already exists.");
        }
        Link link = new Link(this.m_attrSet, this.m_linkAttrType, linkName, linkedObjectName, complex);
        return link;
    }

    @Override
    public ILink link(String linkName, String linkedObjectName) throws ViewException, ReadOnlyException, ConfigException {
        return this.link(linkName, linkedObjectName, false);
    }

    @Override
    public void unlink(String linkName) throws ViewException, ReadOnlyException, ConfigException {
        if (!this.checkExistance(linkName)) {
            throw new ViewException("Can't unlink link: " + linkName + ". Link doesn't exist.");
        }
        this.deleteViewElement(linkName);
    }

    @Override
    public IViewElement getViewElement(String viewElementName) throws ViewException, ConfigException {
        IAttributeSet element = (IAttributeSet)this.m_attrSet.getAttribute(viewElementName.toLowerCase());
        if (element == null && System.getProperty("MQ_UPGRADE", "false").equals("true")) {
            element = (IAttributeSet)this.m_attrSet.getAttribute(viewElementName);
        }
        if (element == null) {
            throw new ViewException("Element or folder " + viewElementName + " doesn't exist");
        }
        Integer type = (Integer)element.getAttribute(ViewConstants.TYPE_ATTR);
        String name = (String)element.getAttribute(ViewConstants.ORIGINAL_NAME);
        if (name == null && System.getProperty("MQ_UPGRADE", "false").equals("true")) {
            name = viewElementName;
        }
        if (name == null) {
            throw new ViewException("Element name for " + viewElementName + " is null");
        }
        if (type.intValue() == ViewConstants.FOLDER_TYPE.intValue()) {
            return new Folder(this.m_attrSet, this.m_folderAttrType, this.m_linkAttrType, name);
        }
        return new Link(this.m_attrSet, this.m_linkAttrType, name, (String)element.getAttribute(ViewConstants.ATTR_LINKOBJECT), false);
    }

    @Override
    public String[] list() {
        ArrayList<String> list = new ArrayList<String>();
        HashMap map = this.m_attrSet.getAttributes();
        for (String name : map.keySet()) {
            Object value = map.get(name);
            if (!(value instanceof IAttributeSet)) continue;
            String originalName = (String)((IAttributeSet)value).getAttribute(ViewConstants.ORIGINAL_NAME);
            if (originalName != null) {
                list.add(originalName);
                continue;
            }
            if (!System.getProperty("MQ_UPGRADE", "false").equals("true")) continue;
            list.add(name);
        }
        if (list.isEmpty()) {
            return IEmptyArray.EMPTY_STRING_ARRAY;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public IViewElementAttributes getAttributes() {
        return this.m_attributes;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    private void setAttributes() {
        this.m_attributes = new ViewElementAttributes();
        this.m_attributes.setAttributeNamesList(this.m_folderAttrType.getAttributeNames());
        this.m_attributes.setAttributeValuesList((IAttributeList)this.m_attrSet.getAttribute(ViewConstants.ATTRS_VALUES));
    }

    private boolean checkExistance(String name) {
        return this.m_attrSet.getAttributes().get(name.toLowerCase()) != null;
    }

    void deleteViewElement(String name) throws ReadOnlyException, ConfigException {
        this.validateElementName(name);
        this.m_attrSet.deleteAttribute(name.toLowerCase());
    }

    private void validateElementName(String name) throws ConfigException {
        if (EntityName.containsAnyChar(name, ViewConstants.RESERVED_CHARACTERS)) {
            throw new ConfigException("Invalid name '" + name + "'. Folder and link names cannot contain the characters: " + ViewConstants.RESERVED_CHARACTERS);
        }
        if (name.startsWith(ViewConstants.MF_PREFIX)) {
            throw new ConfigException("Folder and link names cannot start with the '_MF' prefix.");
        }
    }
}

