/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.IDSTransaction;
import com.sonicsw.mf.common.config.IBasicElement;
import com.sonicsw.mf.common.config.INamingNotification;
import com.sonicsw.mf.common.config.impl.ElementCreateNotification;
import com.sonicsw.mf.common.config.impl.ElementDeleteNotification;
import com.sonicsw.mf.common.config.impl.FolderCreateNotification;
import com.sonicsw.mf.common.config.impl.FolderDeleteNotification;
import com.sonicsw.mf.common.config.impl.MetaAttributesChangeNotification;
import com.sonicsw.mf.common.config.impl.RenameNotification;
import com.sonicsw.mf.common.config.impl.Util;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class DSTransaction
implements IDSTransaction,
Serializable {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    private ArrayList m_actions = new ArrayList();

    public ArrayList getActions() {
        return this.m_actions;
    }

    public void addAction(Action action) {
        this.m_actions.add(action);
    }

    public void addAction(int index, Action action) {
        this.m_actions.add(index, action);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        s.writeObject(this.m_actions);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3) {
            Util.throwSerialVersionMismatch(version, 3);
        }
        this.m_actions = (ArrayList)s.readObject();
    }

    @Override
    public void addCreateElement(IDirElement element) {
        this.m_actions.add(new CreateElement(element));
    }

    public CreateElement createCreateElement(IDirElement element) {
        return new CreateElement(element);
    }

    @Override
    public void addCreateElements(IDirElement[] elements) {
        this.m_actions.add(new CreateElements(elements));
    }

    @Override
    public void addUpdateElement(IDeltaDirElement element) {
        this.m_actions.add(new UpdateElement(element, false));
    }

    @Override
    public void addUpdateElement(IDeltaDirElement element, boolean doNotUpdateIfEmpty) {
        this.m_actions.add(new UpdateElement(element, doNotUpdateIfEmpty));
    }

    @Override
    public void addDeleteElement(String elementName) {
        this.m_actions.add(new DeleteElement(elementName));
    }

    @Override
    public void addCreateFolder(String folderName) {
        this.m_actions.add(new CreateFolder(folderName));
    }

    @Override
    public void addCreateFolder(String folderName, boolean existingOk) {
        this.m_actions.add(new CreateFolder(folderName, existingOk));
    }

    @Override
    public void addDeleteFolder(String folderName) {
        this.m_actions.add(new DeleteFolder(folderName));
    }

    @Override
    public void addRename(String oldName, String newName) {
        this.m_actions.add(new Rename(oldName, newName));
    }

    @Override
    public void addSetAttributes(String name, HashMap attributes) {
        this.m_actions.add(new SetAttributes(name, attributes));
    }

    @Override
    public void addSubclassElement(IBasicElement delta, String newElementPath) {
        this.m_actions.add(new SubclassElement(delta, newElementPath));
    }

    @Override
    public void addCloneElement(IBasicElement deltaFromSource, String newElementPath) {
        this.m_actions.add(new CloneElement0(deltaFromSource, newElementPath, false));
    }

    @Override
    public void addCloneElement(IBasicElement deltaFromSource, String newElementPath, boolean createTemplate) {
        this.m_actions.add(new CloneElement0(deltaFromSource, newElementPath, createTemplate));
    }

    @Override
    public void addCloneElement(String sourcePath, String newElementPath) {
        this.m_actions.add(new CloneElement1(sourcePath, newElementPath, false));
    }

    @Override
    public void addCloneElement(String sourcePath, String newElementPath, boolean createTemplate) {
        this.m_actions.add(new CloneElement1(sourcePath, newElementPath, createTemplate));
    }

    @Override
    public void addAttachBlob(IBasicElement element, InputStream blobStream) throws IOException {
        this.m_actions.add(new AttachBlob(element, blobStream));
    }

    public void addAppendBlob(AttachBlob attachAction, byte[] blob, int offset) throws IOException {
        this.m_actions.set(this.m_actions.indexOf(attachAction), new AppendBlob(attachAction.m_element, blob, offset));
    }

    public AttachBlob createAttachBlob(IBasicElement element, InputStream blobStream) throws IOException {
        return new AttachBlob(element, blobStream);
    }

    @Override
    public void addDetachBlob(IDeltaDirElement delta) {
        this.m_actions.add(new DetachBlob(delta));
    }

    public class DetachBlob
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public IDeltaDirElement m_delta;

        DetachBlob(IDeltaDirElement delta) {
            this.m_delta = delta;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            return new INamingNotification[0];
        }
    }

    public class AttachBlob
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public byte[] m_blob;
        public IBasicElement m_element;
        public transient String m_newStorageName;
        public transient InputStream m_stream;

        AttachBlob(IBasicElement element, InputStream blobStream) throws IOException {
            this.m_element = element;
            if (blobStream == null) {
                throw new IOException("The blob stream object cannot be null.");
            }
            this.m_stream = blobStream;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            if (this.m_element instanceof IDirElement) {
                return new INamingNotification[]{new ElementCreateNotification(this.m_element.getIdentity().getName())};
            }
            return new INamingNotification[0];
        }
    }

    public class AppendBlob
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public byte[] m_blob;
        public int m_src;
        public transient String m_newStorageName;
        public IBasicElement m_element;

        AppendBlob(IBasicElement element, byte[] blob, int src) throws IOException {
            this.m_element = element;
            if (blob == null) {
                throw new IOException("The blob stream object cannot be null.");
            }
            this.m_blob = blob;
            this.m_src = src;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            if (this.m_element instanceof IDirElement) {
                return new INamingNotification[]{new ElementCreateNotification(this.m_element.getIdentity().getName())};
            }
            return new INamingNotification[0];
        }
    }

    public class SetAttributes
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public String m_name;
        public HashMap m_attributes;

        SetAttributes(String name, HashMap attributes) {
            this.m_name = name;
            this.m_attributes = attributes;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            return new INamingNotification[]{new MetaAttributesChangeNotification(this.m_name, this.m_attributes)};
        }
    }

    public class CloneElement1
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public String m_sourcePath;
        public String m_newElementPath;
        public boolean m_createTemplate;
        public transient String m_newStorageName;

        CloneElement1(String sourcePath, String newElementPath, boolean createTemplate) {
            this.m_sourcePath = sourcePath;
            this.m_newElementPath = newElementPath;
            this.m_createTemplate = createTemplate;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            return new INamingNotification[]{new ElementCreateNotification(this.m_newElementPath)};
        }
    }

    public class CloneElement0
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public IBasicElement m_delta;
        public String m_newElementPath;
        public boolean m_createTemplate;
        public transient String m_newStorageName;

        CloneElement0(IBasicElement delta, String newElementPath, boolean createTemplate) {
            this.m_delta = delta;
            this.m_newElementPath = newElementPath;
            this.m_createTemplate = createTemplate;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            return new INamingNotification[]{new ElementCreateNotification(this.m_newElementPath)};
        }
    }

    public class SubclassElement
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public IBasicElement m_delta;
        public String m_newElementPath;
        public transient String m_newStorageName;

        SubclassElement(IBasicElement delta, String newElementPath) {
            this.m_delta = delta;
            this.m_newElementPath = newElementPath;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            return new INamingNotification[]{new ElementCreateNotification(this.m_newElementPath)};
        }
    }

    public class Rename
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public String m_oldName;
        public String m_newName;

        Rename(String oldName, String newName) {
            this.m_oldName = oldName;
            this.m_newName = newName;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            return new INamingNotification[]{new RenameNotification(this.m_oldName, this.m_newName)};
        }
    }

    public class DeleteFolder
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public String m_folderName;

        DeleteFolder(String foldertName) {
            this.m_folderName = foldertName;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            return new INamingNotification[]{new FolderDeleteNotification(this.m_folderName)};
        }
    }

    public class CreateFolder
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public String m_folderName;
        public boolean m_existingOk;

        CreateFolder(String foldertName) {
            this.m_folderName = foldertName;
            this.m_existingOk = false;
        }

        CreateFolder(String folderName, boolean existingOk) {
            this.m_folderName = folderName;
            this.m_existingOk = existingOk;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            return new INamingNotification[]{new FolderCreateNotification(this.m_folderName)};
        }
    }

    public class DeleteElement
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public String m_elementName;

        DeleteElement(String elementName) {
            this.m_elementName = elementName;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            return new INamingNotification[]{new ElementDeleteNotification(this.m_elementName)};
        }
    }

    public class UpdateElement
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public IDeltaDirElement m_element;
        public boolean m_doNotUpdateIfEmpty;

        UpdateElement(IDeltaDirElement element, boolean doNotUpdateIfEmpty) {
            this.m_element = element;
            this.m_doNotUpdateIfEmpty = doNotUpdateIfEmpty;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            return new INamingNotification[0];
        }
    }

    public class CreateElements
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public IDirElement[] m_elements;
        public transient String[] m_newStorageNames;

        CreateElements(IDirElement[] elements) {
            this.m_elements = elements;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            INamingNotification[] notifications = new INamingNotification[this.m_elements.length];
            for (int i = 0; i < notifications.length; ++i) {
                notifications[i] = new ElementCreateNotification(this.m_elements[i].getIdentity().getName());
            }
            return notifications;
        }
    }

    public class CreateElement
    extends Action
    implements Serializable {
        private static final long serialVersionUID = 0L;
        public IDirElement m_element;
        public transient String m_newStorageName;

        CreateElement(IDirElement element) {
            this.m_element = element;
        }

        @Override
        public INamingNotification[] getNamingNotifications() {
            return new INamingNotification[]{new ElementCreateNotification(this.m_element.getIdentity().getName())};
        }
    }

    public abstract class Action
    implements Serializable {
        private static final long serialVersionUID = 0L;

        public abstract INamingNotification[] getNamingNotifications();
    }
}

