/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.metrics;

import com.sonicsw.mf.common.metrics.IAggregateMetric;
import com.sonicsw.mf.common.metrics.IAggregateMetricsData;
import com.sonicsw.mf.common.metrics.IAlert;
import com.sonicsw.mf.common.metrics.IHistoricalMetric;
import com.sonicsw.mf.common.metrics.IMetric;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.IMetricInfo;
import com.sonicsw.mf.common.metrics.IMetricsData;
import com.sonicsw.mf.common.metrics.impl.AggregateMetric;
import com.sonicsw.mf.common.metrics.impl.Alert;
import com.sonicsw.mf.common.metrics.impl.HistoricalMetric;
import com.sonicsw.mf.common.metrics.impl.Metric;
import com.sonicsw.mf.common.metrics.impl.MetricIdentity;
import com.sonicsw.mf.common.metrics.impl.MetricInfo;
import com.sonicsw.mf.common.metrics.impl.MetricsData;
import com.sonicsw.mx.util.IEmptyArray;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class MetricsFactory {
    public static IMetricIdentity createMetricIdentity(String[] nameComponents) {
        return new MetricIdentity(nameComponents);
    }

    public static IMetricIdentity createMetricIdentity(IMetricIdentity parentID, String nameComponent) {
        String[] parentNameComponents = parentID.getNameComponents();
        String[] nameComponents = new String[parentNameComponents.length + 1];
        System.arraycopy(parentNameComponents, 0, nameComponents, 0, parentNameComponents.length);
        nameComponents[parentNameComponents.length] = nameComponent;
        return MetricsFactory.createMetricIdentity(nameComponents);
    }

    public static IMetricIdentity createMetricIdentity(String absoluteName) {
        ArrayList<String> nameComponents = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(absoluteName, ".%", true);
        String nameComponent = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(".")) {
                if (nameComponent == null) {
                    nameComponents.add("");
                    continue;
                }
                nameComponents.add(nameComponent);
                nameComponent = null;
                continue;
            }
            if (token.equals("%")) {
                if (nameComponent == null) {
                    nameComponent = st.nextToken();
                    continue;
                }
                nameComponent = nameComponent + st.nextToken();
                continue;
            }
            if (nameComponent == null) {
                nameComponent = token;
                continue;
            }
            nameComponent = nameComponent + token;
        }
        if (nameComponent != null) {
            nameComponents.add(nameComponent);
        }
        return MetricsFactory.createMetricIdentity(nameComponents.toArray(IEmptyArray.EMPTY_STRING_ARRAY));
    }

    public static IMetric createMetric(IMetricIdentity id, long value, long currencyTimestamp) {
        return new Metric(id, value, currencyTimestamp);
    }

    public static IHistoricalMetric createMetric(String source, IMetric metric) {
        return new HistoricalMetric(source, metric.getMetricIdentity(), metric.getValue(), metric.getCurrencyTimestamp());
    }

    public static IAggregateMetric createMetric(String[] sources, IMetricIdentity id, long[] values, long currencyTimestamp) {
        return new AggregateMetric(sources, id, values, currencyTimestamp);
    }

    public static IMetricInfo createMetricInfo(IMetricIdentity id, short valueType, String description, String extendedDataData, boolean isInstanceMetric, boolean isDynamic, boolean supportsHighAlerts, boolean supportsLowAlerts, String units) {
        return new MetricInfo(id, valueType, description, extendedDataData, isInstanceMetric, isDynamic, supportsHighAlerts, supportsLowAlerts, units);
    }

    public static IMetricInfo createMetricInfo(IMetricIdentity id, short valueType, String description, String extendedDataData, boolean isInstanceMetric, boolean isDynamic) {
        return MetricsFactory.createMetricInfo(id, valueType, description, extendedDataData, isInstanceMetric, isDynamic, false, false, null);
    }

    public static IMetricsData createMetricsData(IMetric[] metrics, long currencyTimestamp) {
        return new MetricsData(metrics, currencyTimestamp);
    }

    public static IAggregateMetricsData createMetricsData(IAggregateMetric[] metrics, long currencyTimestamp) {
        return new MetricsData(metrics, currencyTimestamp);
    }

    public static IAlert createAlert(IMetricIdentity metricId, boolean isHighThreshold, long threshold) {
        if (metricId == null) {
            throw new IllegalArgumentException("Metric identity cannot be null");
        }
        return new Alert(metricId, isHighThreshold, threshold);
    }

    public static IAlert createAlertWithParent(IMetricIdentity metricId, IAlert parent) {
        if (metricId == null) {
            throw new IllegalArgumentException("Metric identity cannot be null");
        }
        return new Alert(metricId, parent);
    }

    public static IAlert[] createAlerts(IMetricIdentity metricId, boolean isHighThreshold, String thresholds) {
        if (metricId == null) {
            throw new IllegalArgumentException("Metric identity cannot be null");
        }
        ArrayList<IAlert> alertsList = new ArrayList<IAlert>();
        if (thresholds != null) {
            String[] tokens = thresholds.split(",");
            for (int i = 0; i < tokens.length; ++i) {
                try {
                    long value = Long.decode(tokens[i]);
                    IAlert alert = MetricsFactory.createAlert(metricId, isHighThreshold, value);
                    alertsList.add(alert);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return alertsList.toArray(new IAlert[alertsList.size()]);
    }
}

