/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.metrics.impl;

import com.sonicsw.mf.common.metrics.IAlert;
import com.sonicsw.mf.common.metrics.IMetricIdentity;
import com.sonicsw.mf.common.metrics.MetricsFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.Objects;

public class Alert
implements IAlert,
Serializable {
    private IMetricIdentity m_metricId;
    private long m_threshold = 0L;
    private boolean m_hiLo = true;
    private long m_lastValue = -1L;
    private GregorianCalendar m_initialAlertTime = null;
    private boolean m_isRepeat = false;
    private boolean m_isExceeded = false;
    private static final long serialVersionUID = 1589193560369980527L;
    private static final short m_serialVersion = 0;
    private IAlert parent = null;
    private static final short ID_NAME_FIELD = 0;
    private static final short THRESHOLD_FIELD = 1;
    private static final short IS_HIGH_THRESHOLD_FIELD = 2;

    public Alert() {
    }

    public Alert(IMetricIdentity metricId, boolean hiLo, long threshold) {
        this.m_metricId = metricId;
        this.m_threshold = threshold;
        this.m_hiLo = hiLo;
    }

    public Alert(IMetricIdentity metricId, IAlert parentAlert) {
        this.m_metricId = metricId;
        this.m_threshold = parentAlert.getThresholdValue();
        this.m_hiLo = parentAlert.isHighThreshold();
        this.parent = parentAlert;
    }

    @Override
    public IMetricIdentity getMetricIdentity() {
        return this.m_metricId;
    }

    @Override
    public boolean isHighThreshold() {
        return this.m_hiLo;
    }

    @Override
    public long getThresholdValue() {
        return this.m_threshold;
    }

    @Override
    public IAlert getParent() {
        return this.parent;
    }

    public boolean isExceeded() {
        return this.m_isExceeded;
    }

    public GregorianCalendar getInitialAlertTime() {
        return this.m_initialAlertTime;
    }

    public boolean isRepeat() {
        return this.m_isRepeat;
    }

    public boolean setThresholdValue(long newThreshold) {
        boolean ret = false;
        this.m_threshold = newThreshold;
        if (this.m_lastValue >= 0L && (this.m_hiLo && newThreshold > this.m_lastValue || !this.m_hiLo && newThreshold < this.m_lastValue)) {
            this.m_isExceeded = true;
            ret = true;
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean check(long value, boolean repeat) {
        this.m_lastValue = value;
        if (this.m_hiLo) {
            if (value <= this.m_threshold) {
                this.m_isExceeded = false;
                this.m_initialAlertTime = null;
                this.m_isRepeat = false;
                return false;
            }
            if (this.m_isExceeded && !repeat) {
                return false;
            }
        } else {
            if (value >= this.m_threshold) {
                this.m_isExceeded = false;
                this.m_initialAlertTime = null;
                this.m_isRepeat = false;
                return false;
            }
            if (this.m_isExceeded && !repeat) {
                return false;
            }
        }
        this.m_isExceeded = true;
        if (this.m_initialAlertTime == null) {
            this.m_initialAlertTime = new GregorianCalendar();
            return true;
        }
        this.m_isRepeat = true;
        return true;
    }

    public boolean isInstanceOf(IAlert parent) {
        if (!(parent instanceof IAlert)) {
            return false;
        }
        return this.getMetricIdentity().isInstanceOf(parent.getMetricIdentity()) && this.isHighThreshold() == parent.isHighThreshold() && this.getThresholdValue() == parent.getThresholdValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof IAlert)) {
            return false;
        }
        IAlert other = (IAlert)obj;
        return this.getMetricIdentity().equals(other.getMetricIdentity()) && this.isHighThreshold() == other.isHighThreshold() && this.getThresholdValue() == other.getThresholdValue();
    }

    public int hashCode() {
        return Objects.hash(this.getMetricIdentity(), this.isHighThreshold(), this.getThresholdValue());
    }

    public String toString() {
        return '[' + this.m_metricId.getName() + "]hiLo=" + this.m_hiLo + ",threshold=" + this.m_threshold;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        int fieldCount = 3;
        stream.writeShort(fieldCount);
        stream.writeShort(0);
        stream.writeShort(0);
        stream.writeObject(this.m_metricId.getNameComponents());
        stream.writeShort(1);
        stream.writeLong(this.m_threshold);
        stream.writeShort(2);
        stream.writeBoolean(this.m_hiLo);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int numFields = stream.readShort();
        short serialVer = stream.readShort();
        for (int i = 0; i < numFields; ++i) {
            short field = stream.readShort();
            switch (serialVer) {
                default: 
            }
            if (field == 0) {
                String[] nameComponents = (String[])stream.readObject();
                this.m_metricId = MetricsFactory.createMetricIdentity(nameComponents);
                continue;
            }
            if (field == 1) {
                this.m_threshold = stream.readLong();
                continue;
            }
            if (field != 2) continue;
            this.m_hiLo = stream.readBoolean();
        }
    }

    @Override
    public boolean sameMetricIdentity(IMetricIdentity other) {
        if (other == null) {
            return false;
        }
        return this.getMetricIdentity().equals(other);
    }
}

