/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.util;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.DirectoryDoesNotExistException;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.ElementFactory;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.util.MonitoredContainer;
import java.util.ArrayList;

public class MonitoredContainerList {
    private static final String WORKBENCH_DIR = "/workbench";
    private static final String MONITORED_ELEMENT_PATH = "/workbench/monitored_containers";
    private static final String CONTAINER_LIST_ATT = "CONTAINER_LIST";

    public static void setMonitoredContainerList(IDirectoryFileSystemService ds0, MonitoredContainer[] monitoredContainers) throws Exception {
        IDirectoryAdminService ds = (IDirectoryAdminService)((Object)ds0);
        boolean isUpgrade = false;
        String upgrade = System.getProperty("wb.upgrade");
        if (upgrade != null) {
            isUpgrade = new Boolean(upgrade);
        }
        if (isUpgrade) {
            ds.setElementReleaseVersion(MONITORED_ELEMENT_PATH, "107");
            IDirElement monitored_list = ds.getElement(MONITORED_ELEMENT_PATH, true);
            if (monitored_list != null) {
                IAttributeSet listElementAtts = monitored_list.getAttributes();
                IAttributeList containersList = (IAttributeList)listElementAtts.getAttribute(CONTAINER_LIST_ATT);
                if (containersList != null) {
                    for (int position = containersList.getCount() - 1; position >= 0; --position) {
                        IAttributeList container = (IAttributeList)containersList.getItem(position);
                        ArrayList containerItems = container.getItems();
                        Reference cRef = null;
                        cRef = containerItems.get(0) instanceof Reference ? (Reference)containerItems.get(0) : (Reference)containerItems.get(1);
                        IElementIdentity mContainer = null;
                        try {
                            mContainer = ds0.getFSIdentity(cRef.getElementName());
                        }
                        catch (DirectoryServiceException directoryServiceException) {
                            // empty catch block
                        }
                        if (mContainer != null && mContainer.getReleaseVersion().equals("107")) continue;
                        System.out.println("\tAddToDS: Removing container " + cRef.getElementName() + " from the monitored container list");
                        containersList.deleteAttributeItem(position);
                    }
                }
                ds.setElement(monitored_list.doneUpdate(), null);
            }
        } else {
            MonitoredContainerList.createWorkbenchDir(ds);
            ds.deleteElement(MONITORED_ELEMENT_PATH, null);
            IDirElement listElement = ElementFactory.createElement(MONITORED_ELEMENT_PATH, "monitored_list", "107");
            IAttributeSet listElementAtts = listElement.getAttributes();
            IAttributeList list = listElementAtts.createAttributeList(CONTAINER_LIST_ATT);
            for (int i = 0; i < monitoredContainers.length; ++i) {
                IAttributeList dsMonitoredContainer = list.addNewAttributeListItem();
                dsMonitoredContainer.addReferenceItem(new Reference(monitoredContainers[i].getContainerLogicalPath()));
                dsMonitoredContainer.addBooleanItem(new Boolean(monitoredContainers[i].isAutoLaunch()));
            }
            ds.setElement(listElement.doneUpdate(), null);
        }
    }

    public static MonitoredContainer[] getMonitoredContainerList(IDirectoryFileSystemService ds0) throws Exception {
        IDirectoryAdminService ds = (IDirectoryAdminService)((Object)ds0);
        MonitoredContainerList.createWorkbenchDir(ds);
        IDirElement listElement = ds.getElement(MONITORED_ELEMENT_PATH, false);
        if (listElement == null) {
            return new MonitoredContainer[0];
        }
        IAttributeSet listElementAtts = listElement.getAttributes();
        IAttributeList list = (IAttributeList)listElementAtts.getAttribute(CONTAINER_LIST_ATT);
        ArrayList<MonitoredContainer> resultList = new ArrayList<MonitoredContainer>();
        for (int i = 0; i < list.getCount(); ++i) {
            IAttributeList dsMonitoredContainer = (IAttributeList)list.getItem(i);
            Reference ref = (Reference)dsMonitoredContainer.getItem(0);
            boolean autoLaunch = (Boolean)dsMonitoredContainer.getItem(1);
            resultList.add(new MonitoredContainer(ref.getElementName(), autoLaunch));
        }
        return resultList.toArray(new MonitoredContainer[resultList.size()]);
    }

    static void createWorkbenchDir(IDirectoryAdminService ds) throws Exception {
        try {
            ds.listAll(WORKBENCH_DIR);
        }
        catch (DirectoryDoesNotExistException e) {
            ds.createDirectory(WORKBENCH_DIR);
        }
    }
}

