/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.util;

import com.sonicsw.mx.util.ServiceMaintenance;

public class ServiceMaintainer
extends Thread {
    private boolean m_isAccessible;
    private long m_frequency;
    private ServiceMaintenance m_maintenance;
    private boolean m_open;
    private boolean m_dontSleepInitially;
    private String m_contextID;
    private Object m_lock = new Object();

    public ServiceMaintainer(ServiceMaintenance maintenance, long frequency, boolean initialAccessibility) {
        super("Service Maintainer");
        this.init(maintenance, frequency, initialAccessibility, null);
    }

    public ServiceMaintainer(String purpose, ServiceMaintenance maintenance, long frequency, boolean initialAccessibility) {
        super("Service Maintainer: " + purpose);
        this.init(maintenance, frequency, initialAccessibility, null);
    }

    public ServiceMaintainer(ServiceMaintenance maintenance, long frequency, boolean initialAccessibility, String contextID) {
        super("mx.util.ServiceMaintainer for " + contextID);
        this.init(maintenance, frequency, initialAccessibility, contextID);
    }

    private void init(ServiceMaintenance maintenance, long frequency, boolean initialAccessibility, String contextID) {
        super.setDaemon(true);
        this.m_contextID = contextID;
        this.m_open = true;
        this.m_frequency = frequency;
        this.m_maintenance = maintenance;
        this.m_isAccessible = initialAccessibility;
        this.m_dontSleepInitially = !this.m_isAccessible;
        this.start();
    }

    public Object getLock() {
        return this.m_lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setAccesssibility(boolean isAccessible) {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.m_open) {
                return false;
            }
            if (isAccessible == this.m_isAccessible) {
                return false;
            }
            this.m_maintenance.onAccessibilityChange(isAccessible);
            this.m_isAccessible = isAccessible;
            if (isAccessible) {
                this.m_lock.notifyAll();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToBeAccessible() {
        Object object = this.m_lock;
        synchronized (object) {
            if (!this.m_open) {
                return false;
            }
            if (this.m_isAccessible) {
                return true;
            }
            try {
                while (!this.m_isAccessible) {
                    this.m_lock.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.m_isAccessible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_open) {
                this.interrupt();
                this.m_open = false;
            }
        }
    }

    public boolean isAccessible() {
        if (!this.m_open) {
            return false;
        }
        return this.m_isAccessible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.m_open) {
                if (!this.m_dontSleepInitially) {
                    Object object = this.m_lock;
                    synchronized (object) {
                        this.m_lock.wait(this.m_frequency);
                    }
                }
                this.m_dontSleepInitially = false;
                Exception e = this.doMaintenance();
                this.m_maintenance.setException(e);
                this.setAccesssibility(e == null);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Exception doMaintenance() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_contextID == null) {
                return this.m_maintenance.doMaintenance();
            }
            return this.m_maintenance.doMaintenance(this.m_contextID);
        }
    }
}

