/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.IAttributeChangeHandler;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaAttributeList;
import com.sonicsw.mf.common.config.IDeltaAttributeSet;
import com.sonicsw.mf.common.config.NotModifiedAttException;
import com.sonicsw.mf.common.config.impl.AttributeAssociationTree;
import com.sonicsw.mf.common.config.query.AttributeName;
import java.util.ArrayList;
import java.util.HashMap;

public final class ProcessDeltaNotifications {
    private static final int MODIFIED = 1;
    private static final int DELETED = 2;
    private static final AttributeName ROOT_NAME = new AttributeName();

    public static void handleElementDeletion(AttributeAssociationTree tree, ArrayList list) {
        ProcessDeltaNotifications.notifyChange(2, null, (IAttributeChangeHandler)tree.getPayload(ROOT_NAME), list);
    }

    public static void processDelta(IDeltaAttributeSet delta, AttributeAssociationTree tree, ArrayList list) {
        Object subTree;
        ProcessDeltaNotifications.notifyChange(1, delta, (IAttributeChangeHandler)tree.getPayload(ROOT_NAME), list);
        String[] modifiedAttributes = delta.getModifiedAttributesNames();
        for (int i = 0; i < modifiedAttributes.length; ++i) {
            Object newValue = null;
            try {
                newValue = delta.getNewValue(modifiedAttributes[i]);
            }
            catch (NotModifiedAttException e) {
                throw new IllegalArgumentException(e.toString());
            }
            subTree = tree.getSubtree(modifiedAttributes[i]);
            if (subTree == null) continue;
            if (subTree instanceof AttributeAssociationTree) {
                if (newValue instanceof IDeltaAttributeSet) {
                    ProcessDeltaNotifications.processDelta((IDeltaAttributeSet)newValue, (AttributeAssociationTree)subTree, list);
                    continue;
                }
                if (newValue instanceof IDeltaAttributeList) {
                    ProcessDeltaNotifications.processDelta((IDeltaAttributeList)newValue, (AttributeAssociationTree)subTree, list);
                    continue;
                }
                IAttributeChangeHandler handler = (IAttributeChangeHandler)((AttributeAssociationTree)subTree).getPayload(ROOT_NAME);
                ProcessDeltaNotifications.notifyChange(1, newValue, handler, list);
                tree.removeNode(new AttributeName(modifiedAttributes[i]));
                tree.insertPayload(new AttributeName(modifiedAttributes[i]), handler);
                continue;
            }
            ProcessDeltaNotifications.notifyChange(1, newValue, (IAttributeChangeHandler)subTree, list);
        }
        String[] deletedAttributes = delta.getDeletedAttributesNames();
        for (int i = 0; i < deletedAttributes.length; ++i) {
            subTree = tree.getSubtree(deletedAttributes[i]);
            if (subTree == null) continue;
            if (subTree instanceof AttributeAssociationTree) {
                ProcessDeltaNotifications.notifyChange(2, null, (IAttributeChangeHandler)((AttributeAssociationTree)subTree).getPayload(ROOT_NAME), list);
            } else {
                ProcessDeltaNotifications.notifyChange(2, null, (IAttributeChangeHandler)subTree, list);
            }
            tree.removeNode(new AttributeName(deletedAttributes[i]));
        }
    }

    public static void processDelta(IDeltaAttributeList delta, AttributeAssociationTree tree, ArrayList list) {
        ProcessDeltaNotifications.notifyChange(1, delta, (IAttributeChangeHandler)tree.getPayload(ROOT_NAME), list);
        int[] deletedItems = delta.getDeletedItemNumbers();
        for (int i = 0; i < deletedItems.length; ++i) {
            Object subTree = tree.getSubtree(new Integer(deletedItems[i]));
            if (subTree == null) continue;
            if (subTree instanceof AttributeAssociationTree) {
                ProcessDeltaNotifications.notifyChange(2, null, (IAttributeChangeHandler)((AttributeAssociationTree)subTree).getPayload(ROOT_NAME), list);
                continue;
            }
            ProcessDeltaNotifications.notifyChange(2, null, (IAttributeChangeHandler)subTree, list);
        }
        if (deletedItems.length > 0) {
            tree.removeNode(ROOT_NAME);
        }
        HashMap modifiedItems = delta.getModifiedItems();
        for (Integer modifiedNum : modifiedItems.keySet()) {
            Object newValue = modifiedItems.get(modifiedNum);
            Object subTree = tree.getSubtree(modifiedNum);
            if (subTree == null) continue;
            if (subTree instanceof AttributeAssociationTree) {
                if (newValue instanceof IDeltaAttributeSet) {
                    ProcessDeltaNotifications.processDelta((IDeltaAttributeSet)newValue, (AttributeAssociationTree)subTree, list);
                    continue;
                }
                if (newValue instanceof IDeltaAttributeList) {
                    ProcessDeltaNotifications.processDelta((IDeltaAttributeList)newValue, (AttributeAssociationTree)subTree, list);
                    continue;
                }
                IAttributeChangeHandler handler = (IAttributeChangeHandler)((AttributeAssociationTree)subTree).getPayload(ROOT_NAME);
                ProcessDeltaNotifications.notifyChange(1, newValue, handler, list);
                tree.removeNode(new AttributeName(modifiedNum));
                tree.insertPayload(new AttributeName(modifiedNum), handler);
                continue;
            }
            ProcessDeltaNotifications.notifyChange(1, newValue, (IAttributeChangeHandler)subTree, list);
        }
    }

    public static void notifyChange(int type, Object value, IAttributeChangeHandler handler, ArrayList list) {
        if (handler == null) {
            return;
        }
        list.add(new NotifyAction(type, value, handler));
    }

    public static void processDelta(IAttributeSet attributeSet, AttributeAssociationTree tree, ArrayList list) {
        ProcessDeltaNotifications.notifyChange(1, attributeSet, (IAttributeChangeHandler)tree.getPayload(ROOT_NAME), list);
        tree.removeNode(ROOT_NAME);
    }

    public static void doNotifications(ArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            ((NotifyAction)list.get(i)).notifyChange();
        }
    }

    private static class NotifyAction {
        private int m_type;
        private Object m_value;
        private IAttributeChangeHandler m_handler;

        NotifyAction(int type, Object value, IAttributeChangeHandler handler) {
            this.m_type = type;
            this.m_value = value;
            this.m_handler = handler;
        }

        void notifyChange() {
            Thread currentThread = Thread.currentThread();
            ClassLoader originalContextClassLoader = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(this.m_handler.getClass().getClassLoader());
            try {
                if (this.m_type == 2) {
                    this.m_handler.itemDeleted();
                } else {
                    this.m_handler.itemModified(this.m_value);
                }
            }
            finally {
                currentThread.setContextClassLoader(originalContextClassLoader);
            }
        }
    }
}

