/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.jmx.client;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class JMSConnectorAddress {
    private Hashtable m_env;
    private String m_managementNode;
    private String m_serverIdentity;

    public JMSConnectorAddress(Hashtable env) {
        this.m_env = env;
    }

    public void setManagementNode(String node) {
        this.m_managementNode = node;
    }

    public String getManagementNode() {
        return this.m_managementNode;
    }

    public void setServerIdentity(String identity) {
        if (identity == null) {
            this.m_serverIdentity = identity;
            return;
        }
        StringTokenizer st = new StringTokenizer(identity, ".", true);
        if (st.countTokens() != 3) {
            throw new IllegalArgumentException("Identity not of format \"<domain>.<container>\": " + identity);
        }
        String firstToken = st.nextToken();
        String secondToken = st.nextToken();
        String thirdToken = st.nextToken();
        if (firstToken.length() == 0 || !secondToken.equals(".") || thirdToken.length() == 0) {
            throw new IllegalArgumentException("Identity does not supply values of the format \"<domain>.<container>\": " + identity);
        }
        this.m_serverIdentity = identity;
    }

    public String getServerIdentity() {
        return this.m_serverIdentity;
    }

    public Hashtable getEnv() {
        return this.m_env;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JMSConnectorAddress)) {
            return false;
        }
        JMSConnectorAddress address = (JMSConnectorAddress)object;
        Hashtable otherEnv = address.getEnv();
        if (this.m_env.size() != otherEnv.size()) {
            return false;
        }
        Enumeration keys = this.m_env.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object thisValue = this.m_env.get(key);
            Object otherValue = otherEnv.get(key);
            if (otherValue == null) {
                return false;
            }
            if (thisValue.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public void setSecondaryConnectionURLs(String secondaryURLs) {
    }

    public String getSecondaryConnectionURLs() {
        return null;
    }

    public void setSecondaryNode(String secondaryNode) {
    }

    public String getSecondaryNode() {
        return null;
    }

    public void setTryDSAndAMBackupsOnFailure(Boolean tryDSAndAMBackupsOnFailure) {
    }

    public Boolean getTryDSAndAMBackupsOnFailure() {
        return new Boolean(false);
    }

    public int hashCode() {
        return 0;
    }
}

