/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.mgmtapi.config;

import com.sonicsw.ma.mgmtapi.config.IMgmtBeanBase;
import com.sonicsw.ma.mgmtapi.config.MgmtException;
import com.sonicsw.ma.mgmtapi.util.ValidName;
import com.sonicsw.mf.mgmtapi.config.IComponentCollectionBean;
import com.sonicsw.mf.mgmtapi.config.IContainerBean;
import com.sonicsw.mf.mgmtapi.config.IContainerCollectionBean;
import com.sonicsw.mf.mgmtapi.config.IDomainBean;
import com.sonicsw.mf.mgmtapi.config.gen.AbstractMFMgmtBeanFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MFMgmtBeanFactory
extends AbstractMFMgmtBeanFactory {
    public IDomainBean getDomainBean() throws MgmtException {
        return this.getDomainBean("/_Default");
    }

    @Override
    public List getDomainBeanNames() throws MgmtException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("/_Default");
        return list;
    }

    @Override
    public List getAuthenticationDomainBeanNames() throws MgmtException {
        return this.listFolderElements("MF_AUTHENTICATION_DOMAIN");
    }

    @Override
    public IComponentCollectionBean createComponentCollectionBean(String name) throws MgmtException {
        this.retrieveAndValidateCollectionType(name);
        return super.createComponentCollectionBean(name);
    }

    @Override
    public IContainerCollectionBean createContainerCollectionBean(String name) throws MgmtException {
        this.retrieveAndValidateCollectionType(name);
        return super.createContainerCollectionBean(name);
    }

    private void retrieveAndValidateCollectionType(String name) throws MgmtException {
        String tail = name.substring(name.lastIndexOf(47) + 1);
        try {
            ValidName.validate(tail, 2);
        }
        catch (Exception e) {
            throw new MgmtException("Invalid collection name " + tail + " ", e);
        }
    }

    public HashMap getDeployedComponents(String containerName) throws MgmtException {
        IContainerBean container = super.getContainerBean(containerName);
        IContainerBean.IComponentsType types = container.getComponents();
        List names = types.getKeyNames();
        HashMap<String, IMgmtBeanBase> componentInfo = new HashMap<String, IMgmtBeanBase>(names.size());
        for (String name : names) {
            String id = this.getDomain() + "." + container.getContainerName() + ":ID=" + name;
            IContainerBean.IStartupParams params = types.getEntry(name);
            IMgmtBeanBase bean = params.getConfigRef();
            componentInfo.put(id, bean);
        }
        return componentInfo;
    }

    public String[] getComponentsRuntimeIDs() throws MgmtException {
        ArrayList<String> compRuntimeIds = new ArrayList<String>();
        List containerBeanNames = this.getContainerBeanNames();
        for (Object containerBeanNameObj : containerBeanNames) {
            IContainerBean container = this.getContainerBean((String)containerBeanNameObj);
            IContainerBean.IComponentsType types = container.getComponents();
            List componentTypeNames = types.getKeyNames();
            for (Object componentTypeNameObj : componentTypeNames) {
                String componentId = this.getDomain() + "." + container.getContainerName() + ":ID=" + componentTypeNameObj;
                compRuntimeIds.add(componentId);
            }
        }
        return compRuntimeIds.toArray(new String[0]);
    }

    public String[] getContainersRuntimeIDs() throws MgmtException {
        ArrayList<String> ids = new ArrayList<String>(0);
        List names = super.getContainerBeanNames();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            IContainerBean container = super.getContainerBean((String)iter.next());
            String id = this.getDomain() + "." + container.getContainerName();
            ids.add(id);
        }
        return ids.toArray(new String[0]);
    }

    @Override
    public void saveContainerBean(IContainerBean bean) throws MgmtException {
        if (!bean.isFaultTolerant()) {
            this.saveBean(bean);
            return;
        }
        if (bean.getFaultToleranceParameters().getFaultToleranceRole().equals("PRIMARY")) {
            this.saveBeans(new IMgmtBeanBase[]{bean, bean.getFaultToleranceParameters().getFaultTolerancePeerRef()});
        }
        if (bean.getFaultToleranceParameters().getFaultToleranceRole().equals("BACKUP")) {
            this.saveBean(bean);
        }
    }
}

