/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.impl;

import com.sonicsw.mf.common.config.AttributeSetTypeException;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IDeltaElement;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.impl.AttributeSet;
import com.sonicsw.mf.common.config.impl.CannotAdjustToSuperModificationException;
import com.sonicsw.mf.common.config.impl.DeltaAttributeSet;
import com.sonicsw.mf.common.config.impl.Element;
import com.sonicsw.mf.common.config.impl.ElementIdentity;
import com.sonicsw.mf.common.config.impl.ICanReplaceRef;
import com.sonicsw.mf.common.config.impl.IDelta;
import com.sonicsw.mf.common.config.impl.IReplaceRef;
import com.sonicsw.mf.common.config.impl.Util;
import com.sonicsw.mf.common.config.query.AttributeName;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public final class DeltaElement
implements IDeltaElement,
IDeltaDirElement,
IDelta,
Serializable,
ICanReplaceRef {
    private static final long serialVersionUID = 0L;
    private static final int SERIALIZATION_VERSION = 3;
    private boolean m_isDeleted = false;
    private ElementIdentity m_identity;
    private Object m_attributeSet;

    DeltaElement(ElementIdentity identity, Object attributeSet) {
        this.m_identity = identity;
        this.m_attributeSet = attributeSet;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(3);
        s.writeBoolean(this.m_isDeleted);
        s.writeObject(this.m_identity);
        s.writeObject(this.m_attributeSet);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int version = s.readInt();
        if (version != 3) {
            Util.throwSerialVersionMismatch(version, 3);
        }
        this.m_isDeleted = s.readBoolean();
        this.m_identity = (ElementIdentity)s.readObject();
        this.m_attributeSet = s.readObject();
    }

    public DeltaElement createEmptyDelta(ElementIdentity identity) {
        return new DeltaElement(identity, new DeltaAttributeSet(null, new HashMap(), new HashMap()));
    }

    @Override
    public boolean emptyDelta() {
        if (this.m_attributeSet instanceof DeltaAttributeSet) {
            return ((DeltaAttributeSet)this.m_attributeSet).emptyDelta();
        }
        return false;
    }

    public void setIdentity(ElementIdentity identity) {
        this.m_identity = identity;
    }

    @Override
    public IElementIdentity getIdentity() {
        return this.m_identity;
    }

    @Override
    public boolean isDeleted() {
        return this.m_isDeleted;
    }

    @Override
    public Object getDeltaAttributes() {
        if (this.m_isDeleted) {
            return null;
        }
        return this.m_attributeSet;
    }

    public String toString() {
        if (this.m_identity != null) {
            return this.m_identity.toString();
        }
        return null;
    }

    public int estimateSize() {
        DeltaAttributeSet attributes = (DeltaAttributeSet)this.getDeltaAttributes();
        if (attributes != null) {
            return attributes.estimateSize() + this.m_identity.estimateSize();
        }
        return this.m_identity.estimateSize();
    }

    public Element toElement(String name) throws Exception {
        Element element = new Element(name, "DELTA ELEMENT", "1.0");
        if (this.m_attributeSet instanceof DeltaAttributeSet) {
            IAttributeSet newAttributes = element.getAttributes();
            ((DeltaAttributeSet)this.m_attributeSet).toAttributeSet(newAttributes);
        } else {
            element.doApplyDelta(this);
        }
        return element;
    }

    boolean inSuperElement(AttributeName name) {
        if (!(this.m_attributeSet instanceof DeltaAttributeSet)) {
            return false;
        }
        return ((DeltaAttributeSet)this.m_attributeSet).inSuperElement(name);
    }

    String[] getDeletedAttributes(AttributeName name) {
        if (!(this.m_attributeSet instanceof DeltaAttributeSet)) {
            return null;
        }
        return ((DeltaAttributeSet)this.m_attributeSet).getDeletedAttributes(name);
    }

    public void adjustToSubclassedModification(DeltaElement subModification) {
        if (!(this.m_attributeSet instanceof DeltaAttributeSet) && !(subModification.m_attributeSet instanceof DeltaAttributeSet)) {
            this.m_attributeSet = subModification.m_attributeSet;
        } else if (!(this.m_attributeSet instanceof DeltaAttributeSet)) {
            try {
                ((AttributeSet)this.m_attributeSet).applyDelta((DeltaAttributeSet)subModification.m_attributeSet);
            }
            catch (AttributeSetTypeException e) {
                throw new Error(e.toString());
            }
        } else if (!(subModification.m_attributeSet instanceof DeltaAttributeSet)) {
            this.m_attributeSet = subModification.m_attributeSet;
        } else {
            ((DeltaAttributeSet)this.m_attributeSet).adjustToSubclassedModification((DeltaAttributeSet)subModification.m_attributeSet);
        }
    }

    public void adjustToSuperclassModification(DeltaElement superModification) throws CannotAdjustToSuperModificationException {
        if (!(this.m_attributeSet instanceof DeltaAttributeSet)) {
            return;
        }
        if (!(superModification.m_attributeSet instanceof DeltaAttributeSet)) {
            throw new CannotAdjustToSuperModificationException("top level element attributes");
        }
        ((DeltaAttributeSet)this.m_attributeSet).adjustToSuperclassModification((DeltaAttributeSet)superModification.m_attributeSet);
    }

    public boolean properForSubclassing() {
        if (this.m_attributeSet instanceof DeltaAttributeSet) {
            return ((DeltaAttributeSet)this.m_attributeSet).properForSubclassing();
        }
        return true;
    }

    public DeltaElement createClone() {
        return DeltaElement.fromBytes(this.toBytes());
    }

    public byte[] toBytes() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(this);
            byte[] bytes = out.toByteArray();
            objectOut.close();
            return bytes;
        }
        catch (Exception e) {
            throw new Error("toBytes failed.");
        }
    }

    public static DeltaElement fromBytes(byte[] bytes) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            ObjectInputStream objectIn = new ObjectInputStream(in);
            return (DeltaElement)objectIn.readObject();
        }
        catch (Exception e) {
            throw new Error("fromBytes failed.");
        }
    }

    @Override
    public boolean replaceReferences(boolean isSystemAtts, IReplaceRef replaceSrvc) {
        return ((ICanReplaceRef)this.m_attributeSet).replaceReferences(false, replaceSrvc);
    }
}

