/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.common.config.upgrade;

import com.sonicsw.mf.common.config.upgrade.ShortcutCreatorException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Date;

public class ShortcutCreator {
    private boolean m_debug = false;

    public ShortcutCreator(boolean debug) {
        this.m_debug = debug;
    }

    public boolean createShortcut(String sourceFilePath, String destinationDirPath, String shortcutName, String iconFilePath, boolean overwriteExisting) throws ShortcutCreatorException {
        this.traceln("createShortcut(\"" + sourceFilePath + "\", \"" + destinationDirPath + "\", " + (iconFilePath == null ? "[icon unspecified]" : iconFilePath) + "\", " + (overwriteExisting ? "true" : "false") + ")");
        if ("".equals(sourceFilePath) || "".equals(destinationDirPath)) {
            throw new ShortcutCreatorException(sourceFilePath, destinationDirPath, "Empty file name.");
        }
        File sourceFile = new File(sourceFilePath);
        if (!sourceFile.isFile()) {
            throw new ShortcutCreatorException(sourceFilePath, destinationDirPath, "The target for the shortcut is not a valid file.");
        }
        File iconFile = null;
        if (iconFilePath == null) {
            iconFile = sourceFile;
        } else {
            iconFile = new File(iconFilePath);
            if (!iconFile.exists()) {
                iconFile = null;
            }
        }
        File destinationDir = new File(destinationDirPath);
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        return this.createShortcut(sourceFile, destinationDir, shortcutName, iconFile, overwriteExisting);
    }

    private boolean createShortcut(File sourceFile, File destinationDir, String shortcutName, File iconFile, boolean overwriteExisting) throws ShortcutCreatorException {
        String internetShortcutFileName;
        URI sourceFileURI = sourceFile.toURI();
        String string = internetShortcutFileName = shortcutName == null ? null : shortcutName + ".url";
        if (internetShortcutFileName == null) {
            String sourceFileName = sourceFile.getName();
            internetShortcutFileName = sourceFileName.substring(0, sourceFileName.length() - 4) + ".url";
        }
        File internetShortcutFile = new File(destinationDir, internetShortcutFileName);
        if (!overwriteExisting && internetShortcutFile.exists()) {
            throw new ShortcutCreatorException(sourceFile.getAbsolutePath(), destinationDir.getAbsolutePath(), "The file already exists.");
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(internetShortcutFile);
        }
        catch (FileNotFoundException e) {
            throw new ShortcutCreatorException(sourceFile.getAbsolutePath(), destinationDir.getAbsolutePath(), "Error when writing the shortcut: " + e.getMessage());
        }
        out.println("[InternetShortcut]");
        out.println("URL=" + sourceFileURI.toString());
        out.println("IconIndex=0");
        out.println("IconFile=" + iconFile.getAbsolutePath());
        out.close();
        this.traceln("createShortcut(File, File, File, boolean): DONE");
        return true;
    }

    private String getTimeStamp() {
        Date now = new Date(System.currentTimeMillis());
        return now.toString();
    }

    private String getTrace(String trace) {
        String thisClassShortName = "ShortcutCreator";
        return this.getTimeStamp() + ": " + thisClassShortName + ": " + trace;
    }

    private void traceln(String trace) {
        if (this.m_debug) {
            System.out.println(this.getTrace(trace));
        }
    }
}

