/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mx.config.ConfigAttributeException;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.ConfigServiceRuntimeException;
import com.sonicsw.mx.config.ConfigTypeException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IAttributeList;
import com.sonicsw.mx.config.IAttributeMap;
import com.sonicsw.mx.config.IConfigElement;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.impl.AttributeDescriptionMapImpl;
import com.sonicsw.mx.config.impl.AttributeListImpl;
import com.sonicsw.mx.config.impl.AttributeMapImpl;
import com.sonicsw.mx.config.impl.ConfigReference;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.ConfigTypeImpl;
import com.sonicsw.mx.config.impl.PropertyMapImpl;
import com.sonicsw.mx.config.impl.Util;
import java.math.BigDecimal;
import java.util.Date;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.util.HexBin;
import org.apache.xerces.impl.validation.ValidationState;

public class AttributeDescriptionImpl
implements IAttributeDescription {
    protected IConfigType m_owner = null;
    protected String m_description = null;
    protected Class m_type = null;
    protected PropertyMapImpl m_properties = null;
    protected AttributeDescriptionMapImpl m_attributeDescriptions = null;
    protected XSSimpleType m_xsSimpleType = null;
    protected ConfigServer m_configServer = null;
    protected static final String ATTRIBUTE_DESCRIPTIONS_ATTRIBUTE = "attributeDescriptions";
    protected static final String TYPE_ATTRIBUTE = "type";
    protected static final String DESCRIPTION_ATTRIBUTE = "description";
    protected static final String PROPERTIES_ATTRIBUTE = "properties";

    protected AttributeDescriptionImpl() {
    }

    protected AttributeDescriptionImpl(ConfigServer configServer) {
        this.m_configServer = configServer;
        this.m_attributeDescriptions = new AttributeDescriptionMapImpl(this.m_configServer);
        this.m_properties = new PropertyMapImpl(this.m_configServer);
    }

    protected AttributeDescriptionImpl(IAttributeSet description, ConfigServer configServer) {
        this.init(description, configServer);
    }

    protected final void init(IAttributeSet dsAttributeSet, ConfigServer configServer) {
        try {
            this.m_configServer = configServer;
            IAttributeSet attributeDescrs = (IAttributeSet)dsAttributeSet.getAttribute(ATTRIBUTE_DESCRIPTIONS_ATTRIBUTE);
            if (attributeDescrs == null) {
                attributeDescrs = dsAttributeSet.createAttributeSet(ATTRIBUTE_DESCRIPTIONS_ATTRIBUTE);
            }
            this.m_attributeDescriptions = new AttributeDescriptionMapImpl(attributeDescrs, this.m_configServer);
            IAttributeSet properties = (IAttributeSet)dsAttributeSet.getAttribute(PROPERTIES_ATTRIBUTE);
            if (properties == null) {
                properties = dsAttributeSet.createAttributeSet(PROPERTIES_ATTRIBUTE);
            }
            this.m_properties = new PropertyMapImpl(properties, this.m_configServer);
            this.m_description = (String)dsAttributeSet.getAttribute(DESCRIPTION_ATTRIBUTE);
            String typeValue = (String)dsAttributeSet.getAttribute(TYPE_ATTRIBUTE);
            if (typeValue != null) {
                this.m_type = Class.forName(typeValue);
            }
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException("ad-init-failed", e);
        }
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer indentBuf = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            indentBuf.append("    ");
        }
        String indentStr = indentBuf.toString();
        String className = this.getType().getName();
        String typeName = className.substring(className.lastIndexOf(".") + 1);
        buffer.append("[" + typeName + "] =\n");
        buffer.append(indentStr).append("{\n");
        if (this.getDescription() != null) {
            buffer.append(indentStr).append("    ").append("description = " + this.getDescription() + "\n");
        }
        if (!this.m_properties.isEmpty()) {
            buffer.append(indentStr).append("    ").append("properties =\n");
            buffer.append(indentStr).append("    ").append("{\n");
            buffer.append(this.m_properties.toString(indent + 2));
            buffer.append(indentStr).append("    ").append("}\n");
        }
        if (this.getAttributeDescriptions().size() > 0) {
            buffer.append(indentStr).append("    ").append("attributes =\n");
            buffer.append(indentStr).append("    ").append("{\n");
            buffer.append(this.getAttributeDescriptions().toString(indent + 2));
            buffer.append(indentStr).append("    ").append("}\n");
        }
        buffer.append(indentStr).append("}\n");
        return buffer.toString();
    }

    @Override
    public Object clone() {
        try {
            AttributeDescriptionImpl copy = (AttributeDescriptionImpl)super.clone();
            copy.m_owner = null;
            copy.m_properties = (PropertyMapImpl)this.m_properties.clone();
            copy.m_attributeDescriptions = (AttributeDescriptionMapImpl)this.m_attributeDescriptions.clone();
            this.m_xsSimpleType = null;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new ConfigServiceRuntimeException("ad-clone-failed", e);
        }
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public Class getType() {
        return this.m_type;
    }

    public void setType(Class type) {
        if (type == null) {
            throw new ConfigServiceRuntimeException("ad-set-type-is-null");
        }
        this.m_type = type;
    }

    @Override
    public Object getProperty(String propertyName) {
        if (this.m_properties != null) {
            return this.m_properties.getProperty(propertyName);
        }
        return null;
    }

    public void setProperty(String propertyName, Object propertyValue) throws ConfigServiceException {
        if (this.m_properties != null) {
            this.m_properties.setProperty(propertyName, propertyValue);
            if (this.m_owner != null) {
                ((ConfigTypeImpl)this.m_owner).setModified();
            }
        }
    }

    public Object removeProperty(String propertyName) throws ConfigServiceException {
        if (this.m_properties != null) {
            Object obj = this.m_properties.removeProperty(propertyName);
            if (this.m_owner != null && obj != null) {
                ((ConfigTypeImpl)this.m_owner).setModified();
            }
            return obj;
        }
        return null;
    }

    @Override
    public Set getPropertyNames() {
        return this.m_properties.getPropertyNames();
    }

    public AttributeDescriptionMapImpl getAttributeDescriptions() {
        return this.m_attributeDescriptions;
    }

    @Override
    public IAttributeDescription getAttributeDescription(String attributeName) {
        return this.m_attributeDescriptions.getAttributeDescription(attributeName);
    }

    public void setAttributeDescription(String attributeName, IAttributeDescription attributeValue) throws ConfigServiceException {
        this.m_attributeDescriptions.setAttributeDescription(attributeName, attributeValue);
    }

    public IAttributeDescription removeAttributeDescription(String attributeName) throws ConfigServiceException {
        return this.m_attributeDescriptions.removeAttributeDescription(attributeName);
    }

    @Override
    public Set getAttributeDescriptionNames() {
        return this.m_attributeDescriptions.getAttributeDescriptionNames();
    }

    @Override
    public IAttributeDescription getAttributeDescription(IConfigPath path) {
        return this.m_attributeDescriptions.getAttributeDescription(path);
    }

    public void setAttributeDescription(IConfigPath path, IAttributeDescription attributeValue) throws ConfigServiceException {
        this.m_attributeDescriptions.setAttributeDescription(path, attributeValue);
    }

    public IAttributeDescription removeAttributeDescription(IConfigPath path) throws ConfigServiceException {
        return this.m_attributeDescriptions.removeAttributeDescription(path);
    }

    @Override
    public void validate(Object value) throws ConfigServiceException {
        if (this.m_xsSimpleType == null) {
            this.m_xsSimpleType = this.buildSimpleType();
        }
        if (value == null) {
            throw new ConfigAttributeException(null, "config-attr-val-is-null");
        }
        if (this.m_type == IAttributeMap.class || this.m_type == IAttributeList.class) {
            throw new ConfigAttributeException(null, "config-attr-val-can-not-validate", new Object[]{value, this.m_type.getName()});
        }
        if (value instanceof ConfigReference) {
            if (this.m_type != IConfigElement.class) {
                throw new ConfigAttributeException(null, "config-attr-val-incorrect-type", new Object[]{value, IConfigElement.class.getName(), this.m_type.getName()});
            }
        } else if (!this.m_type.isInstance(value)) {
            throw new ConfigAttributeException(null, "config-attr-val-incorrect-type", new Object[]{value, value.getClass().getName(), this.m_type.getName()});
        }
        try {
            ValidatedInfo validatedInfo = new ValidatedInfo();
            this.m_xsSimpleType.validate(Util.toString(value), (ValidationContext)new ValidationState(), validatedInfo);
        }
        catch (InvalidDatatypeValueException e) {
            throw new ConfigTypeException(e.getKey(), e.getArgs(), (Exception)((Object)e));
        }
    }

    @Override
    public Object validate(String content) throws ConfigServiceException {
        if (this.m_xsSimpleType == null) {
            this.m_xsSimpleType = this.buildSimpleType();
        }
        if (content == null) {
            throw new ConfigServiceException("ad-validate-content-is-null", new Object[]{content});
        }
        if (this.m_type == IAttributeMap.class || this.m_type == IAttributeList.class) {
            throw new ConfigServiceException("ad-validate-content-invalid-type");
        }
        try {
            Object value = this.m_xsSimpleType.validate(content, (ValidationContext)new ValidationState(), new ValidatedInfo());
            if (this.getType() == Integer.class) {
                BigDecimal converted = new BigDecimal(value.toString());
                value = new Integer(converted.intValue());
            } else if (this.getType() == Long.class) {
                BigDecimal converted = new BigDecimal(value.toString());
                value = new Long(converted.longValue());
            } else if (this.getType() == BigDecimal.class) {
                value = new BigDecimal(value.toString());
            } else if (this.getType() == IConfigElement.class) {
                value = new ConfigReference(Util.url2Name((String)value), this.m_configServer);
            } else if (this.getType() == byte[].class) {
                value = HexBin.decode((String)value.toString());
            } else if (this.getType() == Date.class) {
                value = Util.convertToDate((int[])value);
            }
            return value;
        }
        catch (InvalidDatatypeValueException e) {
            throw new ConfigTypeException(e.getKey(), e.getArgs(), (Exception)((Object)e));
        }
    }

    public void toAttributeSet(IAttributeSet attrSet) {
        try {
            attrSet.setStringAttribute(DESCRIPTION_ATTRIBUTE, this.getDescription());
            if (this.getType() != null) {
                attrSet.setStringAttribute(TYPE_ATTRIBUTE, this.getType().getName());
            }
            IAttributeSet attributeProperties = attrSet.createAttributeSet(PROPERTIES_ATTRIBUTE);
            this.m_properties.toAttributeSet(attributeProperties);
            this.m_attributeDescriptions.toAttributeSet(attrSet.createAttributeSet(ATTRIBUTE_DESCRIPTIONS_ATTRIBUTE));
        }
        catch (Exception e) {
            throw new ConfigServiceRuntimeException("ad-to-attr-set-failed", e);
        }
    }

    protected XSSimpleType buildSimpleType() throws ConfigServiceException {
        try {
            ListIterator iterator;
            AttributeListImpl enumerationDesc;
            PropertyMapImpl properties = this.m_properties;
            Object tmp = properties.getProperty("mx.config.simpleTypeName");
            if (tmp == null) {
                throw new ConfigServiceException("ad-build-simple-type-not-atomic");
            }
            String simpleTypeName = (String)tmp;
            XSSimpleType baseType = SchemaDVFactory.getInstance().getBuiltInType(simpleTypeName);
            XSSimpleType simpleType = SchemaDVFactory.getInstance().createTypeRestriction(null, null, (short)0, baseType, null);
            Object property = null;
            XSFacets facets = new XSFacets();
            short presentFacets = 0;
            property = properties.getProperty("mx.config.whiteSpace");
            if (property != null) {
                facets.whiteSpace = ((Long)property).shortValue();
                presentFacets = (short)(presentFacets | 0x10);
            }
            if ((property = properties.getProperty("mx.config.length")) != null) {
                facets.length = ((Long)property).intValue();
                presentFacets = (short)(presentFacets | 1);
            }
            if ((property = properties.getProperty("mx.config.minLength")) != null) {
                facets.minLength = ((Long)property).intValue();
                presentFacets = (short)(presentFacets | 2);
            }
            if ((property = properties.getProperty("mx.config.maxLength")) != null) {
                facets.maxLength = ((Long)property).intValue();
                presentFacets = (short)(presentFacets | 4);
            }
            if ((property = properties.getProperty("mx.config.totalDigits")) != null) {
                facets.totalDigits = ((Long)property).intValue();
                presentFacets = (short)(presentFacets | 0x200);
            }
            if ((property = properties.getProperty("mx.config.fractionDigits")) != null) {
                facets.fractionDigits = ((Long)property).intValue();
                presentFacets = (short)(presentFacets | 0x400);
            }
            if ((property = properties.getProperty("mx.config.pattern")) != null) {
                enumerationDesc = (AttributeListImpl)property;
                iterator = enumerationDesc.listIterator();
                while (iterator.hasNext()) {
                    AttributeMapImpl regexDesc = (AttributeMapImpl)iterator.next();
                    if (facets.pattern == null) {
                        facets.pattern = (String)regexDesc.getAttribute("mx.config.regex.pattern");
                        continue;
                    }
                    facets.pattern = facets.pattern + " | " + (String)regexDesc.getAttribute("mx.config.regex.pattern");
                }
                presentFacets = (short)(presentFacets | 8);
            }
            if ((property = properties.getProperty("mx.config.enumeration")) != null) {
                enumerationDesc = (AttributeListImpl)property;
                iterator = enumerationDesc.listIterator();
                while (iterator.hasNext()) {
                    String enumeration = (String)iterator.next();
                    if (facets.enumeration == null) {
                        facets.enumeration = new Vector();
                    }
                    facets.enumeration.add(enumeration);
                }
                presentFacets = (short)(presentFacets | 0x800);
            }
            if ((property = properties.getProperty("mx.config.maxInclusive")) != null) {
                facets.maxInclusive = property.toString();
                presentFacets = (short)(presentFacets | 0x20);
            }
            if ((property = properties.getProperty("mx.config.maxExclusive")) != null) {
                facets.maxExclusive = property.toString();
                presentFacets = (short)(presentFacets | 0x40);
            }
            if ((property = properties.getProperty("mx.config.minExclusive")) != null) {
                facets.minExclusive = property.toString();
                presentFacets = (short)(presentFacets | 0x80);
            }
            if ((property = properties.getProperty("mx.config.minInclusive")) != null) {
                facets.minInclusive = property.toString();
                presentFacets = (short)(presentFacets | 0x100);
            }
            ValidationState validationContext = new ValidationState();
            simpleType.applyFacets(facets, presentFacets, (short)0, (ValidationContext)validationContext);
            return simpleType;
        }
        catch (InvalidDatatypeFacetException e) {
            throw new ConfigTypeException(e.getKey(), e.getArgs(), (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new ConfigServiceException("ad-build-simple-type-failed", e);
        }
    }

    protected void setOwner(IConfigType configType) throws ConfigServiceException {
        if (this.m_owner != null && configType != null) {
            new ConfigServiceException("ad-set-owner-already-owned", new Object[]{configType.getName(), this.m_owner.getName()});
        }
        this.m_attributeDescriptions.setOwner(configType);
        this.m_owner = configType;
    }
}

