/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mx.config.ConfigAttributeException;
import com.sonicsw.mx.config.ConfigServiceException;
import com.sonicsw.mx.config.ConfigServiceRuntimeException;
import com.sonicsw.mx.config.IAttributeDescription;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.IConfigType;
import com.sonicsw.mx.config.impl.AttributeDescriptionImpl;
import com.sonicsw.mx.config.impl.ConfigPathImpl;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.ConfigTypeImpl;
import com.sonicsw.mx.config.impl.NameSetImpl;
import com.sonicsw.mx.config.impl.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AttributeDescriptionMapImpl
extends HashMap {
    protected IConfigType m_owner = null;
    protected ConfigServer m_configServer = null;

    public AttributeDescriptionMapImpl(ConfigServer configServer) {
        this.m_configServer = configServer;
    }

    public AttributeDescriptionMapImpl(IAttributeSet descriptions, ConfigServer configServer) {
        this.m_configServer = configServer;
        HashMap descrMap = descriptions.getAttributes();
        for (String key : descrMap.keySet()) {
            IAttributeSet value = (IAttributeSet)descrMap.get(key);
            this.put(key, new AttributeDescriptionImpl(value, this.m_configServer));
        }
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuffer buffer = new StringBuffer();
        StringBuffer indentBuf = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            indentBuf.append("    ");
        }
        String indentStr = indentBuf.toString();
        for (String attrName : this.keySet()) {
            IAttributeDescription attrDesc = this.getAttributeDescription(attrName);
            buffer.append(indentStr).append(attrName + " " + ((AttributeDescriptionImpl)attrDesc).toString(indent));
        }
        return buffer.toString();
    }

    @Override
    public Object clone() {
        AttributeDescriptionMapImpl copy = (AttributeDescriptionMapImpl)super.clone();
        copy.m_owner = null;
        copy.putAll((Map)this);
        return copy;
    }

    public IAttributeDescription getAttributeDescription(String name) {
        return (IAttributeDescription)this.get(name);
    }

    public void setAttributeDescription(String name, IAttributeDescription value) throws ConfigAttributeException {
        try {
            this.put(name, value);
        }
        catch (Exception e) {
            throw new ConfigAttributeException((IConfigPath)new ConfigPathImpl(name), "adm-set-attr-desc-failed", e);
        }
    }

    public IAttributeDescription removeAttributeDescription(String name) throws ConfigAttributeException {
        try {
            return (IAttributeDescription)this.remove(name);
        }
        catch (ConfigServiceRuntimeException e) {
            throw (ConfigAttributeException)((Object)e.getLinkedException());
        }
    }

    public IAttributeDescription getAttributeDescription(IConfigPath path) {
        switch (path.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return this.getAttributeDescription(path.getLastComponent());
            }
        }
        IAttributeDescription attrDesc = this.getAttributeDescription(path.getFirstComponent());
        if (attrDesc != null) {
            return attrDesc.getAttributeDescription(path.subPath(1));
        }
        return null;
    }

    public void setAttributeDescription(IConfigPath path, IAttributeDescription value) throws ConfigAttributeException {
        try {
            switch (path.size()) {
                case 0: {
                    return;
                }
                case 1: {
                    this.setAttributeDescription(path.getLastComponent(), value);
                    return;
                }
            }
            IAttributeDescription attrDesc = this.getAttributeDescription(path.getFirstComponent());
            if (attrDesc != null) {
                ((AttributeDescriptionImpl)attrDesc).setAttributeDescription(path.subPath(1), value);
            }
            return;
        }
        catch (Exception e) {
            throw new ConfigAttributeException(path, "adm-set-attr-desc-cp-failed", e);
        }
    }

    public IAttributeDescription removeAttributeDescription(IConfigPath path) throws ConfigAttributeException {
        try {
            switch (path.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.removeAttributeDescription(path.getLastComponent());
                }
            }
            IAttributeDescription attrDesc = this.getAttributeDescription(path.getFirstComponent());
            if (attrDesc != null) {
                return ((AttributeDescriptionImpl)attrDesc).removeAttributeDescription(path.subPath(1));
            }
            return null;
        }
        catch (Exception e) {
            throw new ConfigAttributeException(path, "adm-remove-attr-desc-cp-failed", e);
        }
    }

    public AttributeDescriptionMapImpl getAttributeDescriptions(Set descriptionNames) {
        AttributeDescriptionMapImpl map = new AttributeDescriptionMapImpl(this.m_configServer);
        for (String name : descriptionNames) {
            map.put(name, this.get(name));
        }
        return map;
    }

    public void setAttributeDescriptions(AttributeDescriptionMapImpl attributeDescriptions) throws ConfigAttributeException {
        Set nameSet = this.getAttributeDescriptionNames();
        for (String attrName : nameSet) {
            IAttributeDescription value = this.getAttributeDescription(attrName);
            this.setAttributeDescription(attrName, value);
        }
        super.putAll(attributeDescriptions);
    }

    public AttributeDescriptionMapImpl removeAttributeDescriptions(Set attributeNames) throws ConfigAttributeException {
        AttributeDescriptionMapImpl map = new AttributeDescriptionMapImpl(this.m_configServer);
        for (String name : attributeNames) {
            Object attribute = this.remove(name);
            map.put(name, attribute);
        }
        return map;
    }

    public Set getAttributeDescriptionNames() {
        NameSetImpl names = new NameSetImpl();
        names.addAll(this.keySet());
        return names;
    }

    public void toAttributeSet(IAttributeSet dsAttributeDescriptionSet) {
        for (String attrName : this.getAttributeDescriptionNames()) {
            try {
                IAttributeSet attrSet = dsAttributeDescriptionSet.createAttributeSet(attrName);
                ((AttributeDescriptionImpl)this.getAttributeDescription(attrName)).toAttributeSet(attrSet);
            }
            catch (Exception e) {
                throw new ConfigServiceRuntimeException("adm-to-attr-set-failed", e);
            }
        }
    }

    @Override
    public final Object put(Object key, Object value) throws ConfigServiceRuntimeException {
        try {
            AttributeDescriptionImpl desc = (AttributeDescriptionImpl)Util.validateAttributeDescriptionValue(value);
            desc.setOwner(this.m_owner);
            desc = super.put(Util.validateAttributeDescriptionName(key), desc);
            if (desc != null) {
                desc.setOwner(null);
            }
            if (this.m_owner != null) {
                ((ConfigTypeImpl)this.m_owner).setModified();
            }
            return desc;
        }
        catch (ConfigServiceException e) {
            throw new ConfigServiceRuntimeException(e);
        }
    }

    @Override
    public void putAll(Map mappings) throws ConfigServiceRuntimeException {
        for (Map.Entry entry : this.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) throws ConfigServiceRuntimeException {
        try {
            AttributeDescriptionImpl desc = (AttributeDescriptionImpl)super.remove(key);
            if (desc != null) {
                desc.setOwner(null);
            }
            if (this.m_owner != null && desc != null) {
                ((ConfigTypeImpl)this.m_owner).setModified();
            }
            return desc;
        }
        catch (ConfigServiceException e) {
            throw new ConfigServiceRuntimeException(new ConfigAttributeException((IConfigPath)new ConfigPathImpl((String)key), "adm-remove-failed", (Exception)((Object)e)));
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    protected void setOwner(IConfigType configType) throws ConfigServiceException {
        if (this.m_owner != null && configType != null) {
            new ConfigServiceException("ad-set-owner-already-owned", new Object[]{configType.getName(), this.m_owner.getName()});
        }
        for (AttributeDescriptionImpl description : this.values()) {
            description.setOwner(configType);
        }
        this.m_owner = configType;
    }
}

