/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mx.config.impl;

import com.sonicsw.mx.config.ConfigChange;
import com.sonicsw.mx.config.IConfigPath;
import com.sonicsw.mx.config.impl.ConfigServer;
import com.sonicsw.mx.config.impl.DispatcherModule;

public class CheckForEmptyDispatcherModule
extends DispatcherModule {
    public CheckForEmptyDispatcherModule(ConfigServer cs) {
        super(cs);
    }

    @Override
    public boolean processConfigChange(ConfigChange configChange) {
        if (configChange.getChangeType() == 1 && this.isEmptyConfigChange(configChange)) {
            this.m_cs.debugPrintln("CheckForEmptyDispatcher - discard update for " + configChange.getName());
            return false;
        }
        return true;
    }

    private boolean isEmptyConfigChange(ConfigChange configChange) {
        Object obj;
        if (!configChange.getDeletedAttributeNames().isEmpty()) {
            return false;
        }
        if (configChange.getNewAttributeNames().size() > 1) {
            return false;
        }
        if (configChange.getModifiedAttributeNames().size() > 1) {
            return false;
        }
        if (configChange.getNewAttributeNames().size() == 1 && configChange.getModifiedAttributeNames().size() == 1) {
            return false;
        }
        if (configChange.getNewAttributeNames().size() == 1 && (obj = configChange.getNewAttributeNames().iterator().next()) instanceof IConfigPath) {
            if (!((IConfigPath)obj).getFirstComponent().equals("_MF_SYSTEM_ATTRIBUTES")) {
                return false;
            }
            if (((IConfigPath)obj).size() > 1 && ((IConfigPath)obj).getComponent(1).equals("TOOL_ANNOTATION")) {
                return false;
            }
            if (configChange.isReleaseVersion()) {
                return false;
            }
        }
        if (configChange.getModifiedAttributeNames().size() == 1 && (obj = configChange.getModifiedAttributeNames().iterator().next()) instanceof IConfigPath) {
            if (!((IConfigPath)obj).getFirstComponent().equals("_MF_SYSTEM_ATTRIBUTES")) {
                return false;
            }
            if (((IConfigPath)obj).getComponent(1).equals("TOOL_ANNOTATION")) {
                return false;
            }
            if (configChange.isReleaseVersion()) {
                return false;
            }
        }
        return true;
    }
}

